<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'pt_br', version '3.11'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'O processo de backup foi concluído';
$string['asyncbackupcompletebutton'] = 'Continue';
$string['asyncbackupcompletedetail'] = 'O processo de backup foi concluído com sucesso. <br/> Você pode acessar o backup na <a href="{$a}">página de restauração.</a>';
$string['asyncbackuperror'] = 'O processo de backup falhou';
$string['asyncbackuperrordetail'] = 'O processo de backup falhou. Por favor, contate seu administrador do sistema.';
$string['asyncbackuppending'] = 'O processo de backup está pendente.';
$string['asyncbackupprocessing'] = 'O backup está em progresso.';
$string['asyncbadexecution'] = 'Execução incorreta do controlador de backup. É {$a} e deve ser 2.';
$string['asynccheckprogress'] = 'Você pode ver o progresso a qualquer momento na <a href="{$a}">página de restauração</a>.';
$string['asyncemailenable'] = 'Habilitar notificações de mensagens.';
$string['asyncemailenabledetail'] = 'Se habilitado, usuários receberão uma mensagem quando um backup ou restauração assíncrona for concluída.';
$string['asyncgeneralsettings'] = 'Backup/restauração assíncrona';
$string['asyncmessagebody'] = 'Mensagem';
$string['asyncmessagebodydefault'] = 'Sua {operation} (ID: {backupid}) foi concluída com sucesso. Você pode acessar em:  <a href="{link}">{link}</a>..';
$string['asyncmessagebodydetail'] = 'Mensagem para enviar quando um backup ou restauração assíncrona for concluída.';
$string['asyncmessagesubject'] = 'Assunto';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} concluída com sucesso';
$string['asyncmessagesubjectdetail'] = 'Assunto da mensagem';
$string['asyncnowait'] = 'Você não precisa esperar aqui, pois o processo continuará em segundo plano.';
$string['asyncprocesspending'] = 'Processo pendente';
$string['asyncrestorecomplete'] = 'O processo de restauração foi concluído';
$string['asyncrestorecompletebutton'] = 'Continue';
$string['asyncrestorecompletedetail'] = 'O processo de restauração foi concluído com sucesso. Clicar em continue levará você ao <a href="{$a}">curso do item restaurado.</a>';
$string['asyncrestoreerror'] = 'O processo de restauração falhou';
$string['asyncrestoreerrordetail'] = 'O processo de restauração falhou. Por favor, contate seu administrador do sistema.';
$string['asyncrestoreinprogress'] = 'Restauração em progresso';
$string['asyncrestoreinprogress_help'] = 'As restaurações assíncronas de curso em andamento são mostradas aqui.';
$string['asyncrestorepending'] = 'O processo de restauração está pendente';
$string['asyncrestoreprocessing'] = 'A restauração está em andamento';
$string['asyncreturn'] = 'Voltar para o curso';
$string['autoactivedescription'] = 'Escolha se deseja ou não fazer backups automatizados. Se o backup manual for selecionado, os backups automatizados somente serão possíveis através de scripts de console (CLI). Estes scripts podem ser disparados manualmente no prompt de comandos ou através do agendador de tarefas (cron).';
$string['autoactivedisabled'] = 'Desabilitado';
$string['autoactiveenabled'] = 'Habilitado';
$string['autoactivemanual'] = 'Manual';
$string['automatedbackupschedule'] = 'Programação';
$string['automatedbackupschedulehelp'] = 'Decida em quais dias da semana devem ser feitos os backups.';
$string['automatedbackupsinactive'] = 'Este site não está habilitado para backups programados';
$string['automatedbackupstatus'] = 'Estado dos backups programados';
$string['automateddeletedays'] = 'Apagar backups mais antigos que';
$string['automatedmaxkept'] = 'Número máximo de backups mantidos';
$string['automatedmaxkepthelp'] = 'Isso especifica o número máximo de backups recentes salvos automaticamente e mantidos para cada curso . Backups mais antigos serão apagados automaticamente.';
$string['automatedminkept'] = 'Número mínimo de backups mantidos';
$string['automatedminkepthelp'] = 'Se os backups forem mais antigos que um número especificado de dias serão excluídos , pode acontecer que um curso inativa acaba sem backup. Para evitar isso, é necessário definir um número mínimo de backups mantidos .';
$string['automatedsettings'] = 'Configurações do backup automático';
$string['automatedsetup'] = 'Configurar o backup automático';
$string['automatedstorage'] = 'Armazenamento do backup automático';
$string['automatedstoragehelp'] = 'Escolha o local onde você deseja que os backups automáticos sejam armazenados.';
$string['backupactivity'] = 'Backup da atividade: {$a}';
$string['backupcourse'] = 'Backup do curso: {$a}';
$string['backupcoursedetails'] = 'Detalhes do curso';
$string['backupcoursesection'] = 'Seção: {$a}';
$string['backupcoursesections'] = 'Seções do curso';
$string['backupdate'] = 'Data da criação';
$string['backupdetails'] = 'Detalhes do Backup';
$string['backupdetailsnonstandardinfo'] = 'O arquivo selecionado não é um arquivo de backup padrão Moodle. O processo de restauração irá tentar converter o arquivo de backup no formato padrão e depois restaurá-lo.';
$string['backupformat'] = 'Formato';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1.x';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Formato desconhecido';
$string['backuplog'] = 'Informações técnicas e alertas';
$string['backupmode'] = 'Modo';
$string['backupmode10'] = 'Geral';
$string['backupmode20'] = 'Importar';
$string['backupmode30'] = 'Hub';
$string['backupmode40'] = 'Mesmo título';
$string['backupmode50'] = 'Automático';
$string['backupmode60'] = 'Convertido';
$string['backupmode70'] = 'Assíncrono';
$string['backupsection'] = 'Backup da seção do curso: {$a}';
$string['backupsettings'] = 'Configurações do backup';
$string['backupsitedetails'] = 'Detalhes do site';
$string['backupstage16action'] = 'Continuar';
$string['backupstage1action'] = 'Próximo';
$string['backupstage2action'] = 'Próximo';
$string['backupstage4action'] = 'Executar o backup';
$string['backupstage8action'] = 'Continuar';
$string['backuptype'] = 'Tipo';
$string['backuptypeactivity'] = 'Atividade';
$string['backuptypecourse'] = 'Curso';
$string['backuptypesection'] = 'Seção';
$string['backupversion'] = 'Versão do backup';
$string['cannotfindassignablerole'] = 'O papel {$a} no arquivo de backup não pôde ser mapeado para nenhum dos papéis que você possui permissão para atribuir.';
$string['choosefilefromactivitybackup'] = 'Área de backup da atividade';
$string['choosefilefromactivitybackup_help'] = 'Os backups de atividade feitos usando as configurações padrão são armazenados aqui.';
$string['choosefilefromautomatedbackup'] = 'Backups automáticos';
$string['choosefilefromautomatedbackup_help'] = 'Contém backups gerados automaticamente.';
$string['choosefilefromcoursebackup'] = 'Área de backup do curso';
$string['choosefilefromcoursebackup_help'] = 'Os backups de curso feitos usando as configurações padrão são armazenados aqui.';
$string['choosefilefromuserbackup'] = 'Área de backup de arquivos privados do usuário';
$string['choosefilefromuserbackup_help'] = 'Arquivos de backup com informações de usuário anônimas são armazenados aqui.';
$string['config_keep_groups_and_groupings'] = 'Por padrão, mantenha os grupos e agrupamentos atuais.';
$string['config_keep_roles_and_enrolments'] = 'Por padrão, mantenha as funções e inscrições atuais.';
$string['config_overwrite_conf'] = 'Permitir que usuário substitua a configuração atual do curso';
$string['config_overwrite_course_fullname'] = 'Por padrão preencha o nome completo do curso com o arquivo de backup. Isto requer que a opção "Substituir a configuração do curso" seja marcada e o usuário atual tenha a capacidade de alterar o nome completo do curso (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Por padrão preencha o nome breve do curso com o arquivo de backup. Isto requer que a opção "Substituir a configuração do curso" seja marcada e o usuário atual tenha a capacidade de alterar o nome breve do curso (moode/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Por padrão preencha a data de início do curso com o arquivo de backup. Isto requer que a opção "Substituir a configuração do curso" seja marcada e o usuário atual tenha a capacidade de alterar as datas do curso na restauração (moode/restore:rolldates)';
$string['configgeneralactivities'] = 'Define o padrão para inclusão das atividades no backup.';
$string['configgeneralanonymize'] = 'Se habilitado, todas as informações pertencentes aos usuários serão transformadas em anônimas, por padrão.';
$string['configgeneralbadges'] = 'Define o padrão para a inclusão de emblemas em backups.';
$string['configgeneralblocks'] = 'Define o padrão para a inclusão dos blocos no backup.';
$string['configgeneralcalendarevents'] = 'Define o padrão para incluir eventos de calendário em um backup.';
$string['configgeneralcomments'] = 'Define o padrão para a inclusão dos comentários no backup.';
$string['configgeneralcompetencies'] = 'Define o padrão para incluir competências em um backup.';
$string['configgeneralcontentbankcontent'] = 'Define o padrão para incluir o conteúdo do banco de conteúdo em um backup.';
$string['configgeneralfiles'] = 'Define o padrão para incluir arquivos em um backup. Observação: desativar essa configuração resultará em um backup que inclui apenas referências a arquivos. Isso não é um problema se o backup for restaurado no mesmo site e os arquivos não tiverem sido excluídos de acordo com a configuração \'Limpar arquivos da lixeira\' (filescleanupperiod).';
$string['configgeneralfilters'] = 'Define o padrão para a inclusão dos filtros no backup.';
$string['configgeneralgroups'] = 'Define o padrão para a inclusão de grupos e agrupamentos em um backup.';
$string['configgeneralhistories'] = 'Define o padrão para a inclusão do histórico do usuário no backup.';
$string['configgenerallogs'] = 'Se habilitado, os logs serão incluídos no backup, por padrão.';
$string['configgeneralpermissions'] = 'Se habilitado, as permissões de papel serão importadas. Isso pode substituir as permissões existentes para usuários inscritos.';
$string['configgeneralquestionbank'] = 'Se habilitado, o banco de questões será incluído nos backups por padrão. ATENÇÃO: Desabilitar esta configuração implica automaticamente em desabilitar o backup de atividades que utilizam o banco de questões, como o questionário.';
$string['configgeneralroleassignments'] = 'Se habilitado, por padrão as atribuições dos papéis serão incluídas no backup.';
$string['configgeneralusers'] = 'Define o padrão para a inclusão dos usuários no backup.';
$string['configgeneraluserscompletion'] = 'Se habilitado, as informações de andamento dos usuários serão incluídas no backup, por padrão.';
$string['configlegacyfiles'] = 'Define o padrão para incluir arquivos de curso legados em um backup. Os arquivos de curso legado são de versões do Moodle anteriores a 2.0.';
$string['configloglifetime'] = 'Isto especifica o intervalo de tempo do qual você quer manter os logs de backups. Logs que se tornarem mais antigos que esta idade serão automaticamente apagados. É recomendado manter este valor baixo pois as informações de log de backup pode se tornar enormes.';
$string['configrestoreactivities'] = 'Define o padrão para restauração de atividades.';
$string['configrestorebadges'] = 'Define o padrão para restauração de emblemas.';
$string['configrestoreblocks'] = 'Define o padrão para restauração de blocos.';
$string['configrestorecalendarevents'] = 'Define o padrão para restauração de eventos de calendário.';
$string['configrestorecomments'] = 'Define o padrão para restauração de comentários.';
$string['configrestorecompetencies'] = 'Define o padrão para restauração de competências.';
$string['configrestorecontentbankcontent'] = 'Define o padrão para restaurar o conteúdo do banco de conteúdo.';
$string['configrestoreenrolments'] = 'Define o padrão para restauração de métodos de inscrição.';
$string['configrestorefilters'] = 'Define o padrão para restauração de filtros.';
$string['configrestoregroups'] = 'Define o padrão para a restauração de grupos e agrupamentos, se eles foram incluídos no backup.';
$string['configrestorehistories'] = 'Define o padrão para restauração do histórico do usuário, se ele foi incluído no backup.';
$string['configrestorelogs'] = 'Se os logs foram habilitados serão restaurados por padrão, se eles foram incluídos no backup.';
$string['configrestorepermissions'] = 'Se habilitado, as permissões da papel serão restauradas. Isso pode substituir as permissões existentes para usuários inscritos.';
$string['configrestoreroleassignments'] = 'Se atribuição de funções padrão foram habilitados eles serão restaurados, se eles foram incluídos no backup.';
$string['configrestoreusers'] = 'Define o padrão para restaurar usuários, se eles foram incluídos no backup.';
$string['configrestoreuserscompletion'] = 'Se as informações de conclusão do usuário estão habilitadas elas serão restauradas por padrão, se elas foram incluídas no backup.';
$string['confirmcancel'] = 'Cancelar o backup';
$string['confirmcancelimport'] = 'Cancelar importação';
$string['confirmcancelno'] = 'Não cancelar';
$string['confirmcancelquestion'] = 'Você tem certeza que deseja cancelar? Qualquer informação que você digitou será perdida.';
$string['confirmcancelrestore'] = 'Cancelar restauração';
$string['confirmcancelyes'] = 'Cancelar backup';
$string['confirmnewcoursecontinue'] = 'Novo aviso do curso';
$string['confirmnewcoursecontinuequestion'] = 'Um curso (oculto) temporário será criado pelo processo de restauração. Para abortar a restauração, clique em cancelar. Não feche o navegador durante a restauração.';
$string['copiesinprogress'] = 'Este curso tem cópias em andamento. <a href="{$a}">Ver cópias em andamento.</a>';
$string['copycoursedesc'] = 'Este curso será duplicado e colocado na categoria de curso selecionada.';
$string['copycourseheading'] = 'Copiar um curso';
$string['copycoursetitle'] = 'Copiar o curso: {$a}';
$string['copydest'] = 'Destino';
$string['copyfieldnotfound'] = 'Os dados de campo obrigatórios não foram encontrados para o(s) campo(s): {$a}';
$string['copyformfail'] = 'O envio Ajax do formulário de cópia do curso falhou.';
$string['copyingcourse'] = 'Cópia do curso em andamento';
$string['copyingcourseshortname'] = 'Copiando';
$string['copyop'] = 'Operação atual';
$string['copyprogressheading'] = 'Cópias de curso em andamento';
$string['copyprogressheading_help'] = 'Esta tabela mostra o status de todas as suas cópias não finalizadas do curso.';
$string['copyprogresstitle'] = 'Progresso da cópia do curso';
$string['copyreturn'] = 'Copiar e voltar';
$string['copysource'] = 'Origem';
$string['copyview'] = 'Copiar e ver';
$string['coursecategory'] = 'Categoria em que o curso será restaurado';
$string['courseid'] = 'ID original';
$string['coursesettings'] = 'Configurações do curso';
$string['coursetitle'] = 'Título';
$string['currentstage1'] = 'Configurações iniciais';
$string['currentstage16'] = 'Concluir';
$string['currentstage2'] = 'Configurações do esquema';
$string['currentstage4'] = 'Confirmação e revisão';
$string['currentstage8'] = 'Executar o backup';
$string['enableasyncbackup'] = 'Habilitar backups assíncronos';
$string['enableasyncbackup_help'] = 'Se habilitado, todas as operações de backup e restauração serão realizadas de forma assíncrona. Isso não afeta as importações e exportações. Backups e restaurações assíncronas permitem que os usuários realizem outras operações enquanto um backup ou restauração estiver em andamento.';
$string['enterasearch'] = 'Digite um termo a pesquisar';
$string['error_block_for_module_not_found'] = 'Instância órfã de bloco (id: {$a->bid}) para o módulo do curso (id:{$a->mid}) encontrada. Não será realizado backup para este bloco.';
$string['error_course_module_not_found'] = 'Módulo de curso órfão (id: {$a}) encontrado. Não será realizado backup para este módulo.';
$string['errorcopyingbackupfile'] = 'Falha ao copiar o arquivo de backup para a pasta temporária antes de restaurar.';
$string['errorfilenamemustbezip'] = 'O nome digitado deve ser um arquivo ZIP e ter a extensão .mbz';
$string['errorfilenamerequired'] = 'Você precisa informar um nome válido para este backup';
$string['errorfilenametoolong'] = 'O nome do arquivo deve ser inferior a 255 caracteres.';
$string['errorinvalidformat'] = 'Formato de backup inválido';
$string['errorinvalidformatinfo'] = 'O arquivo selecionado não é um arquivo de backup do Moodle válido e não pode ser restaurado.';
$string['errorminbackup20version'] = 'Este arquivo de backup foi criado em uma versão de desenvolvimento do backup do Moodle ({$a->backup}). No mínimo, você precisa da versão {$a->min}. Não pôde ser restaurado.';
$string['errorrestorefrontpagebackup'] = 'Você só pode restaurar backups de página principal na página principal';
$string['executionsuccess'] = 'O arquivo de backup foi criado com sucesso.';
$string['extractingbackupfileto'] = 'Extraindo arquivo de backup para: {$a}';
$string['failed'] = 'Backup falhou';
$string['filealiasesrestorefailures'] = 'Falhas de restauro de aliases';
$string['filealiasesrestorefailures_help'] = 'Alias são links simbólicos para outros arquivos, incluindo aqueles armazenados em repositórios externos. Em alguns casos, o Moodle não pode recuperá-los - por exemplo, ao restaurar o backup em outro site ou quando o arquivo referenciado não existe. Mais detalhes ea razão real da falha pode ser encontrado no ficheiro de registo de restauração.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Alguns aliases incluídos no arquivo de backup não pôde ser restaurado. A lista a seguir contém o seu local esperado eo arquivo de origem eles estavam se referindo ao site original.';
$string['filename'] = 'Nome do arquivo';
$string['filereferencesincluded'] = 'Há referências em arquivos a conteúdos externos incluídos no pacote de backup. Estas não funcionarão se o backup for restaurado em um outro site.';
$string['filereferencesnotsamesite'] = 'O arquivo de backup é de um site diferente e, portanto, as referências de arquivo não podem ser restauradas.';
$string['filereferencessamesite'] = 'O arquivo de backup é deste site e, portanto, as referências de arquivos podem ser restauradas.';
$string['generalactivities'] = 'Incluir recursos e atividades';
$string['generalanonymize'] = 'Tornar as informações anônimas';
$string['generalbackdefaults'] = 'Padrões gerais do backup';
$string['generalbadges'] = 'Incluir emblemas';
$string['generalblocks'] = 'Incluir blocos';
$string['generalcalendarevents'] = 'Incluir eventos de calendário';
$string['generalcomments'] = 'Incluir comentários';
$string['generalcompetencies'] = 'Incluir competências';
$string['generalcontentbankcontent'] = 'Incluir o conteúdo do banco de conteúdo';
$string['generalenrolments'] = 'Incluir métodos de inscrição';
$string['generalfiles'] = 'Incluir arquivos';
$string['generalfilters'] = 'Incluir filtros';
$string['generalgradehistories'] = 'Incluir históricos';
$string['generalgroups'] = 'Incluir grupos e agrupamentos';
$string['generalhistories'] = 'Incluir históricos';
$string['generallegacyfiles'] = 'Incluir arquivos de curso legados';
$string['generallogs'] = 'Incluir logs';
$string['generalpermissions'] = 'Incluir sobreposições de permissões';
$string['generalquestionbank'] = 'Incluir banco de questões';
$string['generalrestoredefaults'] = 'Padrões gerais de restauração';
$string['generalrestoresettings'] = 'Configurações gerais de restauração';
$string['generalroleassignments'] = 'Incluir atribuições de papéis';
$string['generalsettings'] = 'Configurações gerais de backup';
$string['generalusers'] = 'Incluir usuários';
$string['generaluserscompletion'] = 'Incluir informações de andamento do usuário';
$string['hidetypes'] = 'Esconder as opções de tipo';
$string['importbackupstage16action'] = 'Continuar';
$string['importbackupstage1action'] = 'Próximo';
$string['importbackupstage2action'] = 'Próximo';
$string['importbackupstage4action'] = 'Executar a importação';
$string['importbackupstage8action'] = 'Continuar';
$string['importcurrentstage0'] = 'Selecionar o curso';
$string['importcurrentstage1'] = 'Configurações iniciais';
$string['importcurrentstage16'] = 'Concluir';
$string['importcurrentstage2'] = 'Configurações do esquema';
$string['importcurrentstage4'] = 'Confirmação e revisão';
$string['importcurrentstage8'] = 'Executar a importação';
$string['importfile'] = 'Importar um arquivo de backup';
$string['importgeneralduplicateadminallowed'] = 'Permitir a resolução de conflitos de administração';
$string['importgeneralduplicateadminallowed_desc'] = 'Se o site tem uma conta com nome de usuário \'admin\' , em seguida, tentar restaurar um arquivo de backup contendo uma conta com nome de usuário \'admin\' pode causar um conflito. Se essa configuração for habilitada, o conflito será resolvido alterando o nome de usuário no arquivo de backup para \' admin_xyz \' .';
$string['importgeneralmaxresults'] = 'O número máximo de cursos listados para importação';
$string['importgeneralmaxresults_desc'] = 'Isto controla o número de cursos que são listados durante o primeiro passo do processo de importação';
$string['importgeneralsettings'] = 'Padrões gerais de importação';
$string['importrootsettings'] = 'Importar configurações';
$string['importsettings'] = 'Configurações gerais de importação';
$string['importsuccess'] = 'Importação concluída. Clique em Continuar para retornar ao curso.';
$string['includeactivities'] = 'Incluir:';
$string['includeditems'] = 'Ítens incluídos:';
$string['includefilereferences'] = 'Referências em arquivos a conteúdo externo';
$string['includesection'] = 'Seção {$a}';
$string['includeuserinfo'] = 'Dados do usuário';
$string['inprogress'] = 'Backup em andamento';
$string['jumptofinalstep'] = 'Pular para o passo final';
$string['keep'] = 'Manter';
$string['keptroles'] = 'Incluir inscrições de papel';
$string['keptroles_help'] = 'Usuários com os papéis selecionados serão inscritos no novo curso. Nenhum dado do usuário será copiado, a menos que a opção \'Incluir dados do usuário\' esteja ativada.';
$string['locked'] = 'Bloqueado';
$string['lockedbyconfig'] = 'Esta configuração foi bloqueada pelas configurações padrões do backup';
$string['lockedbyhierarchy'] = 'Bloqueado pelas dependências';
$string['lockedbypermission'] = 'Você não possui permissões suficientes para alterar esta configuração';
$string['loglifetime'] = 'Manter logs por';
$string['managefiles'] = 'Gerenciar os arquivos de backup';
$string['mergerestoredefaults'] = 'Restaurar padrões ao mesclar com outro curso';
$string['missingfilesinpool'] = 'Alguns arquivos não puderam ser salvos durante o backup, portanto não será possível restaurá-los.';
$string['module'] = 'Módulo';
$string['moodleversion'] = 'Versão do Moodle';
$string['morecoursesearchresults'] = 'Mais de {$a} cursos encontrados, mostrando o primeiro de {$a} resultados';
$string['moreresults'] = 'Existem muitos resultados, digite um termo de pesquisa mais específico.';
$string['nomatchingcourses'] = 'Não existem cursos a exibir';
$string['norestoreoptions'] = 'Não existem categorias ou cursos existentes nos quais você possa restaurar.';
$string['originalwwwroot'] = 'URL do backup';
$string['overwrite'] = 'Sobrescrever';
$string['pendingasyncdeletedetail'] = 'Este curso tem um backup assíncrono pendente. <br/> Cursos não podem ser excluídos até que esse backup seja concluído.';
$string['pendingasyncdetail'] = 'Os backups assíncronos permitem apenas que um usuário tenha um backup pendente para um recurso por vez.<br/>Vários backups assíncronos do mesmo recurso não podem ser colocados na fila, pois isso provavelmente resultaria em vários backups com o mesmo conteúdo.';
$string['pendingasyncedit'] = 'Há um backup assíncrono ou uma cópia pendente para este curso. Por favor, não edite o curso até que o backup seja concluído.';
$string['pendingasyncerror'] = 'Backup pendente para este recurso';
$string['preparingdata'] = 'Preparando dados';
$string['preparingui'] = 'Preparando-se para exibir a página';
$string['previousstage'] = 'Voltar';
$string['privacy:metadata:backup:detailsofarchive'] = 'Este arquivo pode conter vários dados do usuário relacionados a um curso, como notas, inscrições de usuários e dados de atividades.';
$string['privacy:metadata:backup:externalpurpose'] = 'O objetivo deste arquivo é armazenar informações relacionadas a um curso, que podem ser restauradas no futuro.';
$string['privacy:metadata:backup_controllers'] = 'A lista de operações de backup';
$string['privacy:metadata:backup_controllers:itemid'] = 'O ID do curso';
$string['privacy:metadata:backup_controllers:operation'] = 'A operação foi executada, ex. restaurar.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'A hora em que a ação foi criada';
$string['privacy:metadata:backup_controllers:timemodified'] = 'A hora em que a ação foi modificada';
$string['privacy:metadata:backup_controllers:type'] = 'O tipo do item em operação, ex. atividade.';
$string['qcategory2coursefallback'] = 'A categoria de questões "{$a->name}", originalmente no contexto de sistema/curso no arquivo de backup, será criada no contexto de curso pela restauração';
$string['qcategorycannotberestored'] = 'A categoria de questões "{$a->name}" não pôde ser criada pela restauração';
$string['question2coursefallback'] = 'A categoria de questões "{$a->name}", originalmente no contexto de sistema/curso no arquivo de backup, será criada no contexto de curso pela restauração';
$string['questionegorycannotberestored'] = 'As questões "{$a->name}" não puderam ser criadas pela restauração';
$string['recyclebin_desc'] = 'Observe que essas configurações também serão usadas para a lixeira.';
$string['replacerestoredefaults'] = 'Restaurar padrões ao restaurar em outro curso excluindo conteúdo';
$string['restoreactivity'] = 'Restaurar atividade';
$string['restorecourse'] = 'Restaurar curso';
$string['restorecoursesettings'] = 'Configurações do curso';
$string['restoredcourseid'] = 'ID do curso restaurado : {$a}';
$string['restoreexecutionsuccess'] = 'O curso foi restaurado com sucesso, clique no botão continuar abaixo para visualizar o curso que você restaurou.';
$string['restorefileweremissing'] = 'Alguns arquivos não puderam ser restaurados porque eles estavam faltando no backup.';
$string['restorenewcoursefullname'] = 'Novo nome de curso';
$string['restorenewcourseshortname'] = 'Novo nome curto do curso';
$string['restorenewcoursestartdate'] = 'Nova data de início do curso';
$string['restorerolemappings'] = 'Restaurar o mapeamento de papéis';
$string['restorerootsettings'] = 'Restaurar configurações';
$string['restoresection'] = 'Restaurar seção';
$string['restorestage1'] = 'Confirmar';
$string['restorestage16'] = 'Revisar';
$string['restorestage16action'] = 'Executar a restauração';
$string['restorestage1action'] = 'Próximo';
$string['restorestage2'] = 'Destino';
$string['restorestage2action'] = 'Próximo';
$string['restorestage32'] = 'Processar';
$string['restorestage32action'] = 'Continuar';
$string['restorestage4'] = 'Configurações';
$string['restorestage4action'] = 'Próximo';
$string['restorestage64'] = 'Concluir';
$string['restorestage64action'] = 'Continuar';
$string['restorestage8'] = 'Esquema';
$string['restorestage8action'] = 'Próximo';
$string['restoretarget'] = 'Destino da restauração';
$string['restoretocourse'] = 'Restauração para o curso:&nbsp;';
$string['restoretocurrentcourse'] = 'Restaurar neste curso';
$string['restoretocurrentcourseadding'] = 'Mesclar o conteúdo do backup com este curso';
$string['restoretocurrentcoursedeleting'] = 'Excluir o conteúdo deste curso e restaurar o backup';
$string['restoretoexistingcourse'] = 'Restaurar em um curso existente';
$string['restoretoexistingcourseadding'] = 'Mesclar o conteúdo do backup em um curso existente';
$string['restoretoexistingcoursedeleting'] = 'Excluir o conteúdo de um curso existente e restaurar o backup';
$string['restoretonewcourse'] = 'Restaurar como um novo curso';
$string['restoringcourse'] = 'Restauração do curso em progresso';
$string['restoringcourseshortname'] = 'restaurando';
$string['rootenrolmanual'] = 'Restaurar como inscrições manuais';
$string['rootsettingactivities'] = 'Incluir atividades e recursos';
$string['rootsettinganonymize'] = 'Tornar as informações de usuário anônimas';
$string['rootsettingbadges'] = 'Incluir emblemas';
$string['rootsettingblocks'] = 'Incluir blocos';
$string['rootsettingcalendarevents'] = 'Incluir calendário de eventos';
$string['rootsettingcomments'] = 'Incluir comentários';
$string['rootsettingcompetencies'] = 'incluir competências';
$string['rootsettingcontentbankcontent'] = 'Incluir o conteúdo do banco de conteúdo';
$string['rootsettingcustomfield'] = 'Incluir campos personalizados';
$string['rootsettingenrolments'] = 'Incluir métodos de inscrição';
$string['rootsettingenrolments_always'] = 'Sim, sempre';
$string['rootsettingenrolments_never'] = 'Não, restaurar usuários como inscrições manuais';
$string['rootsettingenrolments_withusers'] = 'Sim, apenas se usuários estiverem incluídos';
$string['rootsettingfiles'] = 'Incluir arquivos';
$string['rootsettingfilters'] = 'Incluir filtros';
$string['rootsettinggradehistories'] = 'Incluir o histórico de notas';
$string['rootsettinggroups'] = 'Incluir grupos e agrupamentos';
$string['rootsettingimscc1'] = 'Converter para IMS Common Cartridge 1.0';
$string['rootsettingimscc11'] = 'Converter para IMS Common Cartridge 1.1';
$string['rootsettinglegacyfiles'] = 'Incluir arquivos de curso legados';
$string['rootsettinglogs'] = 'Incluir os logs do curso';
$string['rootsettingpermissions'] = 'Incluir sobreposições de permissões';
$string['rootsettingquestionbank'] = 'Incluir banco de questões';
$string['rootsettingroleassignments'] = 'Incluir as atribuições de papéis';
$string['rootsettings'] = 'Configurações do backup';
$string['rootsettingusers'] = 'Incluir os usuários inscritos';
$string['rootsettinguserscompletion'] = 'Incluir os detalhes de andamento do usuário';
$string['samesitenotification'] = 'Esse backup foi criado apenas com referências aos arquivos, e não com os próprios arquivos. A restauração funcionará apenas neste site.';
$string['sectionactivities'] = 'Atividades';
$string['sectioninc'] = 'Incluído no backup (sem informações do usuário)';
$string['sectionincanduser'] = 'Incluído no backup com informações do usuário';
$string['selectacategory'] = 'Selecione uma categoria';
$string['selectacourse'] = 'Selecione um curso';
$string['setting_course_fullname'] = 'Nome do curso';
$string['setting_course_shortname'] = 'Nome curto do curso';
$string['setting_course_startdate'] = 'Data de início do curso';
$string['setting_keep_groups_and_groupings'] = 'Manter grupos e agrupamentos atuais';
$string['setting_keep_roles_and_enrolments'] = 'Manter papéis e inscrições atuais';
$string['setting_overwrite_conf'] = 'Sobrescrever configuração do curso';
$string['setting_overwrite_course_fullname'] = 'Sobrescrever nome completo do curso';
$string['setting_overwrite_course_shortname'] = 'Sobrescrever nome breve do curso';
$string['setting_overwrite_course_startdate'] = 'Sobrescrever data de início do curso';
$string['showtypes'] = 'Mostrar opções de tipo';
$string['sitecourseformatwarning'] = 'Este é um backup da página principal. Ele só pode ser restaurado na página principal.';
$string['skiphidden'] = 'Ignorar cursos ocultos';
$string['skiphiddenhelp'] = 'Escolha se quer ou não ignorar cursos ocultos';
$string['skipmodifdays'] = 'Ignorar cursos não modificados desde';
$string['skipmodifdayshelp'] = 'Optar por ignorar cursos que não foram modificados desde um número de dias';
$string['skipmodifprev'] = 'Ignorar cursos não modificados desde o backup anterior';
$string['skipmodifprevhelp'] = 'Escolha se os cursos que não foram modificados desde o último backup automático devem ser ignorados.';
$string['status'] = 'Status';
$string['storagecourseandexternal'] = 'Área de arquivos de backup e o diretório especificado';
$string['storagecourseonly'] = 'Área de arquivos de backup';
$string['storageexternalonly'] = 'Diretório especificado para backups automáticos';
$string['successful'] = 'Backup bem sucedido';
$string['successfulcopy'] = 'Cópia bem sucedida';
$string['successfulrestore'] = 'Restauração bem sucedida';
$string['timetaken'] = 'Tempo empregado';
$string['title'] = 'Título';
$string['totalcategorysearchresults'] = 'Total de categorias: {$a}';
$string['totalcoursesearchresults'] = 'Total de cursos: {$a}';
$string['undefinedrolemapping'] = 'Mapeamento de papel indefinido para o arquétipo \'{$a}\'.';
$string['unnamedsection'] = 'Sem nome de seção';
$string['userdata'] = 'Incluir dados de usuários';
$string['userdata_help'] = 'Se habilitado, dados como postagens no fórum, envio de tarefas, etc., serão copiados para o novo curso para qualquer usuário com um papel selecionado em \'Incluir papéis das inscrições\'.';
$string['userinfo'] = 'Info. de usuário';
