<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_db', language 'no', version '3.11'.
 *
 * @package     auth_db
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_dbcannotconnect'] = 'Kan ikke koble til ekstern database';
$string['auth_dbcannotreadtable'] = 'Kan ikke lese ekstern tabell';
$string['auth_dbcantconnect'] = 'Kunne ikke kontakte den oppgitte autentiseringsdatabasen';
$string['auth_dbchangepasswordurl_key'] = 'URL for å endre passord';
$string['auth_dbcolumnlist'] = 'Den eksterne tabllen inneholder følgende kolonner:<br />{$a}';
$string['auth_dbdebugauthdb'] = 'Feilsøk ADOdb';
$string['auth_dbdebugauthdbhelp'] = 'Feilsøk ADOdb forbindelsen til ekstern database - bruk bare du får blank side ved pålogging. Bør ikke brukes på produksjonsservere.';
$string['auth_dbdeleteuser'] = 'Slettet bruker {$a->name} id {$a->id}';
$string['auth_dbdeleteusererror'] = 'Feil ved sletting av bruker {$a}';
$string['auth_dbdescription'] = 'Denne metoden bruker en ekstern database for å kontrollere om et gitt brukernavn og passord er gyldig. Hvis kontoen er ny, kan oplysninger fra andre felter også kopieres inn til Moodle.';
$string['auth_dbextencoding'] = 'Ekstern db koding';
$string['auth_dbextencodinghelp'] = 'Koding brukt i ekstern database';
$string['auth_dbextrafields'] = 'Disse feltene er valgfrie. Du kan velge å forhåndsutfylle noen brukerfelter i Moodle fra <b>den eksterne databasen</b> som du skriver her.<p> Hvis du ikke skriver noe her, vil standardverdierne bli brukt.<p> I alle tilfeller vil brukeren være i stand til å endre disse feltene når de er innlogget.';
$string['auth_dbfieldpass'] = 'Navn på feltet som inneholder passord';
$string['auth_dbfieldpass_key'] = 'Passordfelt';
$string['auth_dbfielduser'] = 'Navn på feltet som inneholder brukernavn. Dette feltet må være av datatypen "VARCHAR".';
$string['auth_dbfielduser_key'] = 'Brukernavnfelt';
$string['auth_dbhost'] = 'Navn på serveren som hoster databasen. Bruk system DSN oppføring dersom du bruker ODBC. Bruken PDO DSN oppføring dersom du bruker PDO.';
$string['auth_dbhost_key'] = 'Vert';
$string['auth_dbinsertuser'] = 'Lagt til bruker {$a->name} id {$a->id}';
$string['auth_dbinsertuserduplicate'] = 'Det oppstod en feil da brukeren {$a->username} skulle settes inn - en bruker med dette brukernavnet har allerede blitt opprettet gjennom \'{$a->auth}\'modulen.';
$string['auth_dbinsertusererror'] = 'Feil under innlegging av bruker {$a}';
$string['auth_dbname'] = 'Navnet på selve databasen. La feltet stå tomt om du bruker ODBC DSN. La feltet være tomt dersom din PDO DSN allerede inneholder databasenavnet.';
$string['auth_dbname_key'] = 'DB-navn';
$string['auth_dbnoexttable'] = 'Uspesifisert ekstern tabell.';
$string['auth_dbnouserfield'] = 'Uspesifisert eksternt brukerfelt';
$string['auth_dbpass'] = 'Passord som passer til brukernavnet ovenfor';
$string['auth_dbpass_key'] = 'Passord';
$string['auth_dbpasstype'] = '<p>Angi formatet som passordfeltet bruker. </p> <p> Bruk \'intern\' hvis du vil at den eksterne databasen skal administrere brukernavn og e-postadresser, men Moodle skal administrere passord. Hvis du bruker \'intern\', må du oppgi et fylt e-postadressefelt i den eksterne databasen, og du må aktivere den planlagte oppgaven \\auth_db\\task\\sync_users. Moodle vil sende en e-post til nye brukere med et midlertidig passord.</p>';
$string['auth_dbpasstype_key'] = 'Passordformat';
$string['auth_dbreviveduser'] = 'Gjenopprettet bruker {$a->name} id {$a->id}';
$string['auth_dbrevivedusererror'] = 'Feil ved gjenoppretting av bruker {$a}';
$string['auth_dbsaltedcrypt'] = 'Krypter enveis streng hashing';
$string['auth_dbsetupsql'] = 'SQL setup kommando';
$string['auth_dbsetupsqlhelp'] = 'SQL kommando for spesielt databaseoppsett, ofte brukt for å sette opp kommunikasjons-språk - eksempel for MySQL og PostgreSQL: <em>SET NAMES \'utf8\'</em>';
$string['auth_dbsuspenduser'] = 'Deaktivert bruker {$a->name} id {$a->id}';
$string['auth_dbsuspendusererror'] = 'Feil ved fjerning av bruker {$a}';
$string['auth_dbsybasequoting'] = 'Bruk sybase quotes';
$string['auth_dbsybasequotinghelp'] = 'Sybasemetode ved enkle anførselstegn ved avbrytelse - trengs i Orocle, MS SQL og noen andre databaser. Ikke bruk for MySQL!';
$string['auth_dbsyncuserstask'] = 'Synkroniser brukeroppgaver';
$string['auth_dbtable'] = 'Navn på tabellen i databasen';
$string['auth_dbtable_key'] = 'Tabell';
$string['auth_dbtableempty'] = 'Den eskterne tabellen er tom';
$string['auth_dbtype'] = 'Databasetypen (Se dokumentasjonen <a href="http://adodb.org/dokuwiki/doku.php" target="_blank">ADOdb - Database Abstraction Layer for PHP</a> for detaljer.';
$string['auth_dbtype_key'] = 'Database';
$string['auth_dbupdateerror'] = 'Feil ved oppdatering av ekstern database.';
$string['auth_dbupdateusers'] = 'Oppdater brukere';
$string['auth_dbupdateusers_description'] = 'Legg til nye og oppdater eksisterende brukere.';
$string['auth_dbupdatinguser'] = 'Oppdaterer bruker {$a->name} id {$a->id}';
$string['auth_dbuser'] = 'Brukernavn med lesetilgang til databasen';
$string['auth_dbuser_key'] = 'DB-bruker';
$string['auth_dbuserstoadd'] = 'Brukere å legge til: {$a}';
$string['auth_dbuserstoremove'] = 'Brukere å fjerne: {$a}';
$string['pluginname'] = 'Bruk en ekstern database';
$string['privacy:metadata'] = 'Modulen "Ekstern databaseautentisering" lagrer ikke noen persondata.';
