<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_ldap', language 'no', version '3.11'.
 *
 * @package     enrol_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['assignrole'] = 'Tildeler rollen \'{$a->role_shortname}\' til brukeren \'{$a->user_username}\' i kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['assignrolefailed'] = 'Mislykket tildeling av rollen \'{$a->role_shortname}\' til brukeren \'{$a->user_username}\' i kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['autocreate'] = 'Kurs kan automatisk bli opprettet når det er innrulleringer til kurs som ikke eksisterer i Moodle ennå.';
$string['autocreate_key'] = 'Auto-opprett';
$string['autocreation_settings'] = 'Innstillinger for automatisk kursopprettelse';
$string['autoupdate_settings'] = 'Innstillinger for automatiske kursoppdateringer';
$string['autoupdate_settings_desc'] = '<p>Velg felt for oppdatering når synkroniseringsskriptet kjører (Synkronisere LDAP påmeldinger).</p><p>Når minst ett felt er valgt vil oppdateringen kjøre.</p>';
$string['bind_dn'] = 'Hvis du ønsker å bruke bind-user for å søke etter brukere angi her. Noe som ligner på \'cn=ldapbruker,ou=heleskola,o=1klasse\'';
$string['bind_dn_key'] = 'Bind-brukerens unike navn';
$string['bind_pw'] = 'Passord for bind-user';
$string['bind_pw_key'] = 'Passord';
$string['bind_settings'] = 'Bind innstillinger';
$string['cannotcreatecourse'] = 'Kan ikke auto-opprette kurset: mangler påkrevde data fra LDAP-oppføringen!';
$string['cannotupdatecourse'] = 'Kan ikke oppdatere kurset: mangler obligatoriske data fra LDAP! Kursets id-nummer: \'{$a->idnumber}\'';
$string['cannotupdatecourse_duplicateshortname'] = 'Kan ikke oppdatere kurset: Kortnavnet eksisterer allerede. Dropper kurset med id-nummeret:  \'{$a->idnumber}\'...';
$string['category'] = 'Kategori for auto-opprettede kurs';
$string['category_key'] = 'Kategori';
$string['contexts'] = 'LDAP kontekst';
$string['couldnotfinduser'] = 'Fant ikke brukeren \'{$a}\', hopper over...';
$string['course_fullname'] = 'Valgfritt: LDAP felt hvor en henter fullt navn fra.';
$string['course_fullname_key'] = 'Fullt navn';
$string['course_fullname_updateonsync'] = 'Oppdatert fullt navn når synkroniseringen kjøres';
$string['course_fullname_updateonsync_key'] = 'Oppdater fullt navn';
$string['course_idnumber'] = 'Lenke til unik identifisering i LDAP, vanligvis <em>cn</em> eller <em>uid</em>. Det er anbefalt at du låser denne verdien hvis du bruker automatisk kursoppretelse';
$string['course_idnumber_key'] = 'ID-nummer';
$string['course_search_sub'] = 'Søk opp gruppemedlemsskap fra underkontekster';
$string['course_search_sub_key'] = 'Søk i underkontekster';
$string['course_settings'] = 'Kurspåmeldingsinnstillinger';
$string['course_shortname'] = 'Valgfritt: LDAP felt å få kortnavn fra.';
$string['course_shortname_key'] = 'Kortnavn';
$string['course_shortname_updateonsync'] = 'Oppdater kortnavnet når synkroniseringen kjøres';
$string['course_shortname_updateonsync_key'] = 'Oppdater kortnavn';
$string['course_summary'] = 'Valgfritt: LDAP felt å få "beskrivelse av deg selv" fra.';
$string['course_summary_key'] = 'Sammendrag';
$string['course_summary_updateonsync'] = 'Oppdater kursbeskrivelsen når synkroniseringen kjøres';
$string['course_summary_updateonsync_key'] = 'Oppdater sammendrag';
$string['coursenotexistskip'] = 'Kurset \'{$a}\' eksisterer ikke og auto-oppretting er deaktivert - hopper over...';
$string['courseupdated'] = 'Oppdateringen av kurset med kurs-ID \'{$a->idnumber}\' var vellykket';
$string['courseupdateskipped'] = 'Kurset med kurs-ID \'{$a->idnumber}\' trenger ikke oppdatering. Hopper over...';
$string['createcourseextid'] = 'CREATE user er påmeldt et ikke-eksisterende kurs  \'{$a->courseextid}\'';
$string['createnotcourseextid'] = 'Bruker er påmeldt et ikke-eksisterende kurs  \'{$a->courseextid}\'';
$string['creatingcourse'] = 'Oppretter kurset \'{$a}\'...';
$string['duplicateshortname'] = 'Opprettelsen av kurset feilet. Kortnavn er allerede i bruk. Hopper over kurs med kurs-ID \'{$a->idnumber}\'...';
$string['editlock'] = 'Lås verdi';
$string['emptyenrolment'] = 'Ingen påmelding for rollen  \'{$a->role_shortname}\' i kurset \'{$a->course_shortname}\'';
$string['enrolname'] = 'LDAP';
$string['enroluser'] = 'Meld inn brukeren \'{$a->user_username}\' i kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['enroluserenable'] = 'Aktivert påmelding for brukeren  \'{$a->user_username}\' i kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['explodegroupusertypenotsupported'] = 'ldap_explode_group() støtter ikke valgte brukertype: {$a}';
$string['extcourseidinvalid'] = 'Kursets eksterne ID er ugyldig!';
$string['extremovedsuspend'] = 'Deaktivert påmelding for brukeren \'{$a->user_username}\' i kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedsuspendnoroles'] = 'Deaktiverte påmelding og fjernet roller for brukeren \'{$a->user_username}\' i kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['extremovedunenrol'] = 'Meld ut brukeren  \'{$a->user_username}\' fra kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['failed'] = 'Mislykkes!';
$string['general_options'] = 'Generelle valg';
$string['group_memberofattribute'] = 'Attributt-navnet angir hvilken gruppe en gitt bruker eller gruppe tilhører (memberOf, groiupMembership, etc)';
$string['group_memberofattribute_key'] = 'Attributt for \'Member of\'';
$string['host_url'] = 'Angi LDAP vert på URL måte eks: \'ldap://ldap.minvert.no/\' eller \'ldaps://ldap.minvert.no/\'';
$string['host_url_key'] = 'Verts-URL';
$string['idnumber_attribute'] = 'Dersom gruppemedlemsskap inneholder unike navn - angi samme attributt som du brukte for brukerens  \'ID Number\' du har mappet i LDAP autentiseringsinnstillingene.';
$string['idnumber_attribute_key'] = 'ID-nummer attributt';
$string['ldap:manage'] = 'Administrere LDAP påmeldingsinstanser';
$string['ldap_encoding'] = 'Angi hvilket kodesett som brukes av LDAP-serveren. Mest vanlige er utf-8, MS AD v2 bruker standard plattform kodesett som cp1252, cp1250, etc.';
$string['ldap_encoding_key'] = 'LDAP kodesett';
$string['memberattribute'] = 'LDAP medlemsinnstilling';
$string['memberattribute_isdn'] = 'Dersom gruppemedlemsskapet inneholder unike navn kan du angi det her. Dersom tilfellet må du også sette opp de andre innstillingene i denne seksjonen også.';
$string['memberattribute_isdn_key'] = 'Medlemsattributten bruker dn';
$string['nested_groups'] = 'Vil du bruke nestede grupper (grupper av grupper) i påmeldingen?';
$string['nested_groups_key'] = 'Nestede grupper';
$string['nested_groups_settings'] = 'Innstillinger for nestede grupper';
$string['nosuchrole'] = 'Ingen slik rolle: \'{$a}\'';
$string['objectclass'] = 'objectClass brukt for å søke kurs. Vanligvis \'posixGroup\'';
$string['objectclass_key'] = 'Objektklasse';
$string['ok'] = 'Ok!';
$string['opt_deref'] = 'Dersom gruppemedlemsskap inneholder unike navn - angi her hvordan aliaser skal håndteres ved søking. Velg en av følgende verdier:  \'Nei\' (LDAP_DEREF_NEVER) eller \'Ja\' (LDAP_DEREF_ALWAYS).';
$string['opt_deref_key'] = 'Aliaser for dereference';
$string['phpldap_noextension'] = 'PHP sin LDAP-modul ser ut til å mangle. Vennligst sjekk at den er installert og aktivert hvis du ønsker å bruke denne påmeldingsmodulen.';
$string['pluginname'] = 'LDAP påmeldinger';
$string['pluginname_desc'] = '<p>Du kan bruke en LDAP server for å kontrollere påmeldingene dine. Det antas at LDAP treet inneholder gruppene for å koble til kursene og at hver av disse gruppene/kursene vil ha medlemsskap-egenskaper til å koble til studentene.</p>
<p>Den antas at kursene er definert som grupper i LDAP, hvor hver gruppe har flere medlemsskap-felter
(<em>medlem</em> eller <em>medlemUid</em>) som inneholder unik identifikasjon til brukeren</p>
<p>For å bruke LDAP innmelding <strong>må</strong> brukerne ha et gyldig idnummerfelt.LDAP gruppene må ha det idnummeret i medlemsfeltet for at brukeren skal meldes inn i kurset. Dette vil vanligvis virke bra hvis du allerede bruker LDAP autentisering.</p>
<p>Påmeldingene vil oppdateres når brukeren logger på. Du kan også kjøre et script for å holde påmeldingene oppdatert. Se i <em>enrol/ldap/enrol_ldap_sync.php</em>.</p>
<p>Dette tillegget kan også settes til å opprette nye kurs automatisk når nye grupper opprettes i LDAP.</p>';
$string['pluginnotenabled'] = 'Modulen er ikke aktivert!';
$string['privacy:metadata'] = 'Modulen "LDAP påmeldinger" lagrer ikke noen persondata.';
$string['role_mapping'] = '<p>For hver rolle du vil tildele fra LDAP må du oppgi listen av kontekster hvor kursrollens grupper finnes. Atskill forskjellige kontekster med semikolon \';\'.</p><p>Du må også angi den egenskapen LDAP-serveren din benytter for å gruppere brukerne. Vanligvis er dette \'member\' eller \'memberUid\'</p>';
$string['role_mapping_attribute'] = 'LDAP-brukeregenskap for {$a}';
$string['role_mapping_context'] = 'LDAP-kontekster for {$a}';
$string['role_mapping_key'] = 'Mapp roller fra LDAP';
$string['roles'] = 'Rolle lenking';
$string['server_settings'] = 'LDAP serverinnstillinger';
$string['synccourserole'] = '== Synkroniserer kurset \'{$a->idnumber}\' for rollen \'{$a->role_shortname}\'';
$string['syncenrolmentstask'] = 'Synkroniser LDAP påmeldingsoppgaver';
$string['template'] = 'Valgfri: auto-opprettede kurs kan kopiere innstillinge fra et malkurs.';
$string['template_key'] = 'Mal';
$string['unassignrole'] = 'Fradeler rollen \'{$a->role_shortname}\' for brukeren \'{$a->user_username}\' fra kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignrolefailed'] = 'Mislykkes i rollefradeling for  \'{$a->role_shortname}\' til brukeren \'{$a->user_username}\' fra kurset \'{$a->course_shortname}\' (id {$a->course_id})';
$string['unassignroleid'] = 'Fradeler rolleID \'{$a->role_id}\' til brukerID \'{$a->user_id}\'';
$string['updatelocal'] = 'Oppdater lokale data';
$string['user_attribute'] = 'Dersom gruppemedlemsskap innenholder unike navn kan du angi attributten som skal brukes for å navne/søke på brukere. Hvis du bruker LDAP-autentisering burde denne verdien samsvare med attributten angitt i \'ID-nummer\' mappingen i LDAP-autentiseringsmodulen.';
$string['user_attribute_key'] = 'ID-nummer attributt';
$string['user_contexts'] = 'Dersom gruppemedlemsskap innenholder unike navn, angi listen over kontekster hvor brukere finnes. Forskjellige kontekster separeres med  \';\'. For eksempel: \'ou=users,o=org; ou=others,o=org\'.';
$string['user_contexts_key'] = 'Kontekster';
$string['user_search_sub'] = 'Dersom gruppemedlemsskap innenholder unike navn, angi om søk også skal inkludere underkontekster.';
$string['user_search_sub_key'] = 'Søk i underkontekster';
$string['user_settings'] = 'Innstillinger for  brukeroippslag';
$string['user_type'] = 'Dersom gruppemedlemsskap innenholder unike navn må du angi hvordan brukere er lagret i LDAP';
$string['user_type_key'] = 'Brukertype';
$string['version'] = 'Versjon av LDAP-protokoll serveren din bruker.';
$string['version_key'] = 'Versjon';
