<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'simplecertificate', language 'no', version '3.11'.
 *
 * @package     simplecertificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allusers'] = 'Alle brukere';
$string['awardedsubject'] = 'Varsling av tildelt kursbevis:  {$a->certificate} tildelt {$a->student}';
$string['awardedto'] = 'Tildelt';
$string['bulkaction'] = 'Velg en massehandling';
$string['bulkbuttonlabel'] = 'Send';
$string['bulkview'] = 'Massehandlinger';
$string['cantdeleteissue'] = 'Feil ved fjerning av tildelte kursbevis';
$string['cantissue'] = 'Kursbeviset kan ikke tildeles fordi brukeren ikke oppfyller aktivitetskravene';
$string['certificatecopy'] = 'Kopi';
$string['certificateimage'] = 'Kursbevisets bildefil';
$string['certificateimage_help'] = 'Dette er bildet som skal brukes på kursbeviset';
$string['certificatename'] = 'Kursbevisnavn';
$string['certificatename_help'] = 'Kursbevisnavn';
$string['certificatenot'] = 'Modulen Enkelt kursbevis kunne ikke finnes';
$string['certificatetext'] = 'Kursbevistekst';
$string['certificatetext_help'] = 'Dette er teksten som vil brukes på kursbeviset. Noe av teksten kan være variabel, f.eks. kursnavn, kursdeltakerens navn og dato for tildeling.
Variablene er:
<li>{USERNAME} -> Brukerens navn</li>
<li>{COURSENAME} -> Kursets fulle navn</li>
<li>{GRADE} -> Karakter</li>
<li>{DATE} -> Dato</li>
<li>{OUTCOME} -> Outcomes</li>
<li>{TEACHERS} -> Liste med lærere i kurset</li>
<li>{IDNUMBER} -> User id number</li>
<li>{FIRSTNAME} -> User first name</li>
<li>{LASTNAME} -> User last name</li>
<li>{EMAIL} -> User e-mail</li>
<li>{ICQ} -> User ICQ</li>
<li>{SKYPE} -> User Skype</li>
<li>{YAHOO} -> User yahoo messenger</li>
<li>{AIM} -> User AIM</li>
<li>{MSN} -> User MSN</li>
<li>{PHONE1} -> User 1° Phone Number</li>
<li>{PHONE2} -> User 2° Phone Number</li>
<li>{INSTITUTION} -> User institution</li>
<li>{DEPARTMENT} -> User department</li>
<li>{ADDRESS} -> Brukerens addresse</li>
<li>{CITY} -> Brukerens by</li>
<li>{COUNTRY} -> Brukerens land</li>
<li>{URL} -> User Home-page</li>
<li>{CERTIFICATECODE} -> Unique certificate code text</li>
<li>{USERROLENAME} -> User role name in course</li>
<li>{TIMESTART} -> User Enrollment start date in course</li>
<li>{USERIMAGE} -> User profile image</li>
<li>{USERRESULTS} -> User results (grade) in others course activities</li>
<li>{PROFILE_xxxx} -> Egendefinerte profilfelt</li>
</ul>
For å hente inn tekst fra egendefinerte profilefelt, må du bruke prefikset "PROFILE_" foran kortnavnet til profilfeltet.
Teksten kan inneholde vanlig HTML, vanlige fonter og tabeller, men unngå alle posisjonsdefinisjoner.';
$string['certificatetextx'] = 'Horisontal posisjon for tekst (venstre marg)';
$string['certificatetexty'] = 'Vertikal posisjon for tekst';
$string['certificateverification'] = 'Kursbevisverifikasjon';
$string['certlifetime'] = 'Behold tildelte kursbevis i (antall måneder)';
$string['certlifetime_help'] = 'Dette angir tiden du ønsker at tildelte kursbevis skal lagres. Tildelte kursbevis som er eldre enn dette vil automatisk bli slettet.';
$string['code'] = 'Kode';
$string['codex'] = 'Horisontal posisjon for kursbevisets QR-kode';
$string['codey'] = 'Vertikal posisjon for kursbevisets QR-kode';
$string['completedusers'] = 'Brukere som oppfyller kursbeviskravene';
$string['completiondate'] = 'Kursfullføring';
$string['coursegrade'] = 'Kurskarakter';
$string['coursename'] = 'Alternativt kursnavn';
$string['coursename_help'] = 'Alternativt kursnavn';
$string['coursenotfound'] = 'Fant ikke kurset';
$string['coursetimereq'] = 'Antall påkrevde minutter i kurset';
$string['coursetimereq_help'] = 'Skriv inn den minimumstiden brukeren må ha brukt i kurset for at de skal motta kursbeviset.';
$string['datefmt'] = 'Datoformat';
$string['datefmt_help'] = 'Skriv inn et gyldig PHP datoformat (<a href="http://www.php.net/manual/en/function.strftime.php"> Datoformater</a>). Eller la være tom for å bruke brukeren valgte datoformat.';
$string['defaultcertificatetextx'] = 'Standard horisontal posisjon for tekst';
$string['defaultcertificatetexty'] = 'Standard vertikal posisjon for tekst';
$string['defaultcodex'] = 'Standard horisontal posisjon for kursbevisets QR-kode';
$string['defaultcodey'] = 'Standard vertikal posisjon for kursbevisets QR-kode';
$string['defaultheight'] = 'Standardhøyde';
$string['defaultperpage'] = 'Per side';
$string['defaultperpage_help'] = 'Antall kursbevis som skal vises per side (Maks 200)';
$string['defaultwidth'] = 'Standardbredde';
$string['deletissuedcertificates'] = 'Slett tildelte kursbevis';
$string['delivery'] = 'Levering';
$string['delivery_help'] = 'Her kan du velge hvordan kursdeltakerne skal motta kursbeviset sitt.
<ul>
<li>Åpne i nettleser: Åpner kursbeviset i ett nytt vindu i nettleseren</li>
<li>Tving nedlasting: Laster ned fila med kursbeviset til brukerens datamaskin</li>
<li>Via epost: Kursbeviset blir sendt som som et vedlegg i en epost til kursdeltakerens epostadresse</li>
<li>Etter at kursdeltakerne mottar kursbeviset kan de klikke på en lenke på kursets hovedside og de vil kunne se kursbeviset og datoen det ble tildelt.</li>
</ul>';
$string['designoptions'] = 'Designvalg';
$string['download'] = 'Tving nedlasting';
$string['emailcertificate'] = 'Epost';
$string['emailfrom'] = 'Avsendernavn på epost';
$string['emailfrom_help'] = 'Alternativ avsendernavn på epost';
$string['emailothers'] = 'Varsle andre';
$string['emailothers_help'] = 'Skriv inn epostadressene til de som skal varsles med epost når brukere mottar et kursbevis';
$string['emailsent'] = 'Epostene har blitt sendt';
$string['emailstudentsubject'] = 'Ditt kursbevis for {$a->course}';
$string['emailstudenttext'] = 'Hei {$a->username}!

Her er kursbeviset ditt for kurset: {$a->course}.

Dette er en automatisk melding - vennligst ikke svar på den.';
$string['emailteachermail'] = '{$a->student} had mottatt kursbeviset sitt: \'{$a->certificate}\'
for {$a->course}.

Du kan se det her:

    {$a->url}';
$string['emailteachermailhtml'] = '{$a->student} had mottatt kursbeviset sitt: <i>{$a->certificate}</i>
for {$a->course}.

Du kan se det her:

    <a href="{$a->url}"Kursbevisrapport</a>';
$string['emailteachers'] = 'Varsle lærere';
$string['emailteachers_help'] = 'Når aktivert vil lærere varsles med en epost hver gang noen mottar et kursbevis.';
$string['enablesecondpage'] = 'Aktiver bakside på kursbeviset';
$string['enablesecondpage_help'] = 'Aktiver kursbevisets bakside. Hvis deaktivert vil bare kursbevisets QR-kode kunne vises på baksiden.';
$string['eventcertificate_verified'] = 'Kursbevis verifisert';
$string['eventcertificate_verified_description'] = 'Brukeren med id {$a->userid} verifiserte kursbeviset med id {$a->certificateid}, tildelt brukeren med id {$a->certiticate_userid}.';
$string['filenotfound'] = 'Fant ikke filen';
$string['getcertificate'] = 'Hent kursbevis';
$string['grade'] = 'Karakter';
$string['gradefmt'] = 'Karakterformat';
$string['gradefmt_help'] = 'Det er tre ulike karakterformater som kan skrives på kursbeviset:
<ull>
<li>Karakter i prosent</li>
<li>Karakter i poeng</li>
<li>Bokstavkarakter: Skriver ut prosentkarakteren som en bokstav</li>
</ul>';
$string['gradeletter'] = 'Bokstavkarakter';
$string['gradepercent'] = 'Karakter i prosent';
$string['gradepoints'] = 'Karakter i poeng';
$string['height'] = 'Kursbevishøyde';
$string['hours'] = 'timers';
$string['intro'] = 'Beskrivelse';
$string['invalidcode'] = 'Ugyldig kursbeviskode';
$string['issued'] = 'Tildelt';
$string['issuedcertificatenotfound'] = 'Fant ikke tildelt kursbevis';
$string['issueddate'] = 'Dato tildelt';
$string['issueddownload'] = 'Tildelt kursbevis [id: {$a}] er lastet ned';
$string['issuedview'] = 'Tildelte kursbevis';
$string['issueoptions'] = 'Tildelingvalg';
$string['keywords'] = 'kursbevis, kurs, pdf, moodle';
$string['modulename'] = 'Enkelt kursbevis';
$string['modulename_help'] = 'Modulen Enkelt kursbevis tillater læreren å opprette et eget kursbevis som kan tildeles kursdeltakere som har fullført visse kriterier.';
$string['modulenameplural'] = 'Enkle kursbevis';
$string['multipdf'] = 'Last ned kursbevis i en zip-fil';
$string['neverdeleteoption'] = 'Aldri slett';
$string['nocertificatesissued'] = 'Ingen kursbevis har blitt tildelt';
$string['nodelivering'] = 'Ingen levering, brukeren vil motta kursbeviset på andre måter';
$string['onepdf'] = 'Last ned kursbevis i en PDF-fil';
$string['openbrowser'] = 'Åpne i nytt vindu';
$string['opendownload'] = 'Klikk på knappen nedenfor for å laste ned og lagre kursbeviset.';
$string['openemail'] = 'Klikk på knappen nedenfor for å få kursbeviset tilsendt som et epostvedlegg.';
$string['openwindow'] = 'Klikk på knappen nedenfor for å åpne kursbeviset i et nytt vindu.';
$string['pluginadministration'] = 'Kursbevisadministrasjon';
$string['pluginname'] = 'Enkelt kursbevis';
$string['printdate'] = 'Utskriftsdato';
$string['printdate_help'] = 'Dette er datoen som vil bli vist, dersom en utskriftsdato er valgt. Hvis kursfullføringsdatoen er valgt, men brukeren ikke har fullført kurset, vil mottaksdatoen vises. Du kan også velge å vise utskriftsdato based på når en aktivitet har blitt karaktersatt. Hvis kursbeviset utstedes før karakteren er satt, vil mottaksdatoen vises.';
$string['printgrade'] = 'Vis karakter';
$string['printgrade_help'] = 'Du kan velge å vise enhver enkeltkarakter fra karakterboka på kursbeviset. Karakterelementene vises i samme rekkefølge som i karakterboka.';
$string['printoutcome'] = 'Vis læringsutbytte';
$string['printoutcome_help'] = 'Du kan velge å vise ethvert læringsutbytte på kursbeviset.';
$string['printqrcode'] = 'Vis kursbevisets QR-kode';
$string['printqrcode_help'] = 'Vis (eller ikke) kursbevisets QR-kode';
$string['qrcodefirstpage'] = 'Vis QR-koden på forsiden';
$string['qrcodefirstpage_help'] = 'Vis QR-koden på forsiden';
$string['qrcodeposition'] = 'Plassering av QR-koden';
$string['qrcodeposition_help'] = 'Dette er XY-koordinatene (i millimeter) for kursbeviset QR-kode';
$string['receiveddate'] = 'Dato mottatt';
$string['report'] = 'Rapport';
$string['requiredtimenotmet'] = 'Du må ha brukt minst {$a->requiredtime} minutter i kurset for å få dette kursbeviset';
$string['secondimage'] = 'Bildefil for kursbevisets bakside';
$string['secondimage_help'] = 'Dette er bildet som vil brukes på kursbevisets bakside';
$string['secondpageoptions'] = 'Kursbevisets bakside';
$string['secondpagetext'] = 'Tekst på kursbevisets bakside';
$string['secondpagex'] = 'Horisontal posisjon for tekst på kursbevisets bakside';
$string['secondpagey'] = 'Vertikal posisjon for tekst på kursbevisets bakside';
$string['secondtextposition'] = 'Posisjon for tekst på kursbevisets bakside';
$string['secondtextposition_help'] = 'Dette er X og Y koordinatene (i millimeter) for plassering av tekst på kursbevisets bakside';
$string['sendtoemail'] = 'Send på epost til brukeren';
$string['showusers'] = 'Vis';
$string['simplecertificate:addinstance'] = 'Legg til et enkelt kursbevis';
$string['simplecertificate:manage'] = 'Administrer enkelt kursbevis';
$string['simplecertificate:view'] = 'Vis enkelt kursbevis';
$string['size'] = 'Kursbevisstørrelse';
$string['size_help'] = 'Dette er bredden og høyden (i millimeter) på kursbeviset. Standardinnstillingene er liggende A4-format';
$string['standardview'] = 'Tildel et kursbevis';
$string['summaryofattempts'] = 'Sammendrag av tidligere tildelte kursbevis';
$string['textposition'] = 'Plassering av kursbevistekst';
$string['textposition_help'] = 'Dette er X og y koordinatene (i millimeter) for kursbevisteksten';
$string['timestartdatefmt'] = 'Datoformat for kursstart';
$string['timestartdatefmt_help'] = 'Skriv inn et gyldig PHP datoformat (<a href="http://www.php.net/manual/en/function.strftime.php"> Datoformater</a>). Eller la være tom for å bruke brukeren valgte datoformat.';
$string['upgradeerror'] = 'Feil mens oppgradering av $a';
$string['usercontextnotfound'] = 'Brukerkonteksten ikke funnet';
$string['userdateformat'] = 'Brukerens lokale datoformat';
$string['usernotfound'] = 'Fant ikke brukeren';
$string['variablesoptions'] = 'Andre valg';
$string['verifycertificate'] = 'Verifiser kursbevis';
$string['viewcertificateviews'] = 'Vis {$a} tildelte kursbevis';
$string['width'] = 'Kursbevisbredde';
