<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dataprivacy', language 'no', version '3.11'.
 *
 * @package     tool_dataprivacy
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitiesandresources'] = 'Aktiviteter og ressurser';
$string['addcategory'] = 'Legg til kategori';
$string['addnewdefaults'] = 'Standarder for legge til ny modul';
$string['addpurpose'] = 'Legg til formål';
$string['addroleoverride'] = 'Legg til rolleoverstyring';
$string['approve'] = 'Godkjenn';
$string['approvedrequestsubmitted'] = 'Forespørselen din er sendt og vil bli behandlet snart.';
$string['approverequest'] = 'Godkjenn forespørsel';
$string['automaticdatadeletionapproval'] = 'Automatisk sletting av data ber om godkjenning';
$string['automaticdatadeletionapproval_desc'] = 'Hvis det er aktivert, blir forespørsler om sletting av data automatisk godkjent. <br/> Merk at den automatiske godkjenningen bare vil gjelde for nye forespørsler om sletting av data med denne innstillingen aktivert. Eksisterende forespørsler om sletting av data i påvente av godkjenning må fortsatt godkjennes manuelt av personvernombudet.';
$string['automaticdataexportapproval'] = 'Automatisk dataeksport ber om godkjenning';
$string['automaticdataexportapproval_desc'] = 'Hvis aktivert, blir dataeksportforespørsler automatisk godkjent. <br/> Merk at den automatiske godkjenningen bare vil gjelde for nye dataeksportforespørsler med denne innstillingen aktivert. Eksisterende dataeksportforespørsler i påvente av godkjenning, må fortsatt godkjennes manuelt av personvernombudet.';
$string['automaticdeletionrequests'] = 'Opprett automatiske dataslettingsforespørsler';
$string['automaticdeletionrequests_desc'] = 'Hvis aktivert vil automatisk dataslettingsforespørsler opprettes automatisk for alle manuelt slettede brukerkontoer.';
$string['bulkapproverequests'] = 'Godta forespørsler';
$string['bulkdenyrequests'] = 'Avslå forespørsler';
$string['cachedef_contextlevel'] = 'Kontekstnivåer formål og kategorier';
$string['cachedef_purpose'] = 'Dataformål';
$string['cachedef_purpose_overrides'] = 'Formålsoverskrivninger i personvernverktøyet';
$string['cancelrequest'] = 'Avbryt forespørsel';
$string['cancelrequestconfirmation'] = 'Ønsker du virkelig å avbryte denne dataforespørselen?';
$string['cannotreset'] = 'Kan ikke tilbakestille denne forespørselen. Kun avslåtte forespørsler kan tilbakestilles.';
$string['categories'] = 'Kategorier';
$string['categorieslist'] = 'Liste med datakategorier';
$string['category'] = 'Kategori';
$string['category_help'] = 'En kategori i dataregisteret beskriver en type data. En ny kategori kan legges til, eller hvis Arv er valgt, brukes datakategorien fra en høyere kontekst. Kontekster er (fra lav til høy): Blokker> Aktivitetsmoduler> Kurs> Kurskategorier> Portal.';
$string['categorycreated'] = 'Kategori opprettet';
$string['categorydefault'] = 'Standard kategori';
$string['categorydefault_help'] = 'Standardkategorien er datakategorien som brukes til nye forekomster. Hvis Arv er valgt, brukes datakategorien fra en høyere kontekst. Kontekster er (fra lav til høy): Blokker> Aktivitetsmoduler> Kurs> Kurskategorier> Bruker> Portal.';
$string['categoryupdated'] = 'Kategori oppdatert';
$string['close'] = 'Lukk';
$string['compliant'] = 'Kompatibel';
$string['confirmapproval'] = 'Ønsker du virkelig å godkjenne denne dataforespørselen?';
$string['confirmbulkapproval'] = 'Ønsker du virkelig å massegodta de valgte dataforespørslene?';
$string['confirmbulkdenial'] = 'Ønsker du virkelig å masseavslå de valgte dataforespørslene?';
$string['confirmcompletion'] = 'Ønsker du virkelig å markere denne brukerhenvendelsen som løst?';
$string['confirmcontextdeletion'] = 'Ønsker du virkelig å bekrefte slettingen av de valgte kontekstene? Dette vil også slette alle brukerdata i de tilhørende underkontekstene.';
$string['confirmdenial'] = 'Ønsker du virkelig å avslå denne dataforespørselen';
$string['confirmrequestresubmit'] = 'Er du sikker på at du ønsker å avbryte {$a->type}forespørselen for {$a->username} og sende den inn på nytt?';
$string['contactdataprotectionofficer'] = 'Kontakt personvernombudet';
$string['contactdataprotectionofficer_desc'] = 'Hvis aktivert, vil brukerne kunne kontakte personvernombudet og foreta en dataanmodning via en lenke på deres profilside.';
$string['contactdpoviaprivacypolicy'] = 'Vennligst kontakt portalens personvernombud som beskrevet i personvernreglene';
$string['contextlevelname10'] = 'Portal';
$string['contextlevelname30'] = 'Brukere';
$string['contextlevelname40'] = 'Kurskategorier';
$string['contextlevelname50'] = 'Kurs';
$string['contextlevelname70'] = 'Aktivitetsmoduler';
$string['contextlevelname80'] = 'Blokker';
$string['contextpurposecategorysaved'] = 'Formål og kategori lagret';
$string['createcategory'] = 'Opprett datakategori';
$string['createdeletedatarequest'] = 'Opprett dataslettingsforespørsel';
$string['createnewdatarequest'] = 'Opprett en ny dataforespørsel';
$string['createpurpose'] = 'Datalagringsformål';
$string['creationauto'] = 'Automatisk';
$string['creationmanual'] = 'Manuelt';
$string['datadeletion'] = 'Datasletting';
$string['datadeletionpagehelp'] = 'Data hvor oppbevaringsperioden er utløpt, er oppført her. Vennligst kontroller og bekreft datasletting, som deretter blir utført av cron-jobben "Slett utgåtte kontekster".';
$string['dataprivacy:downloadallrequests'] = 'Last ned eksporterte data for alle.';
$string['dataprivacy:downloadownrequest'] = 'Last ned dine egne eksporterte data.';
$string['dataprivacy:makedatadeletionrequestsforchildren'] = 'Krev datasletting for mindreårige';
$string['dataprivacy:makedatarequestsforchildren'] = 'Lag dataforespørsler for mindreårige';
$string['dataprivacy:managedataregistry'] = 'Administrér dataregisteret';
$string['dataprivacy:managedatarequests'] = 'Administrér dataforespørsler';
$string['dataprivacy:requestdelete'] = 'Krev datasletting for deg selv';
$string['dataprivacy:requestdeleteforotheruser'] = 'Krev datasletting på vegne av en annen bruker';
$string['dataregistry'] = 'Dataregister';
$string['dataregistryinfo'] = 'Dataregistret gjør det mulig å angi kategorier (typer av data) og formål (årsakene til behandling av data) for alt innhold på portalen - fra brukere og kurs ned til aktiviteter og blokker. For hvert formål kan en oppbevaringsperiode settes. Når en oppbevaringsperiode er utløpt, blir dataene flagget og oppført for sletting, ventende på bekreftelse fra administrator.';
$string['datarequestcreatedforuser'] = 'Dataforespørsel opprettet for {$a}';
$string['datarequestcreatedfromscheduledtask'] = 'Automatisk opprettet fra en cron-jobb (tidligere slettede brukere)';
$string['datarequestcreatedupondelete'] = 'Automatisk opprettet ved brukersletting.';
$string['datarequestemailsubject'] = 'Dataforespørsel: {$a}';
$string['datarequests'] = 'Dataforespørsler';
$string['dataretentionexplanation'] = 'Dette sammendraget viser standardkategorier og formål for å beholde brukerdata. Enkelte områder mer spesifikke kategorier og formål enn de som er oppført her.';
$string['dataretentionsummary'] = 'Sammendrag av dataoppbevaring';
$string['datecomment'] = '[{$a->date}]:
{$a->comment}';
$string['daterequested'] = 'Data forespurt';
$string['daterequesteddetail'] = 'Data forespurt:';
$string['defaultexpired'] = 'Data for alle brukere';
$string['defaultexpiredexcept'] = 'Data for alle brukere unntatt de som har en av følgende roller:<br> {$a->unexpired}';
$string['defaultsinfo'] = 'Standardkategorier og formål er lagt til alle nylig opprettede instanser.';
$string['defaultssaved'] = 'Standarder lagret';
$string['defaultswarninginfo'] = 'Advarsel: Endring av disse standardinnstillingene kan påvirke oppbevaringsperioden for eksisterende forekomster.';
$string['defaultunexpired'] = 'Kun data for brukere med en av følgende roller:<br> {$a->expired}';
$string['defaultunexpiredwithexceptions'] = 'Kun data for brukere som har en av følgende roller:<br>
{$a->expired}
Med mindre de også har en av følgende roller:<br>
{$a->unexpired}';
$string['deletecategory'] = 'Slett kategori';
$string['deletecategorytext'] = 'Er du sikker på at du ønsker å slette kategorien \'{$a}\'?';
$string['deletedefaults'] = 'Slett standarder: {$a}';
$string['deletedefaultsconfirmation'] = 'Er du sikker på at du vil slette standardkategori og formål for {$a} moduler?';
$string['deleteexistingdeleteduserstask'] = 'Opprett dataslettingsforespørsler for tidligere slettede brukere.';
$string['deleteexpiredcontextstask'] = 'Slett utløpte kontekster';
$string['deleteexpireddatarequeststask'] = 'Slett eksportfiler for utløpte dataforespørsler.';
$string['deletemyaccount'] = 'Slett brukerkontoen min';
$string['deletepurpose'] = 'Slett formål';
$string['deletepurposetext'] = 'Er du sikker på at du ønsker å slette formålet \'{$a}\'?';
$string['deny'] = 'Avslå';
$string['denyrequest'] = 'Avslå forespørsel';
$string['deprecated'] = 'Avviklet';
$string['deprecatedexplanation'] = 'Denne modulen bruker en gammel versjon av et av personvernsgrensesnittene og bør oppdateres.';
$string['download'] = 'Last ned';
$string['downloadexpireduser'] = 'Nedlastingen er utløpt. Send inn en ny forespørsel hvis du vil eksportere dine persondata.';
$string['dporolemapping'] = 'Personvernombud rollemapping';
$string['dporolemapping_desc'] = 'Personvernombudet kan håndtere dataforespørsler. Rettigheten tool/dataprivacy:managedatarequests må være tillatt for den rollen som skal vises som personvernombud.';
$string['duplicaterole'] = 'Rolle allerede spesifisert';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editdefaults'] = 'Rediger standarder: {$a}';
$string['editmoduledefaults'] = 'Rediger modulstandarder';
$string['editpurpose'] = 'Rediger formål';
$string['editpurposes'] = 'Rediger formål';
$string['effectiveretentionperiodcourse'] = '{$a} (etter kursets sluttdato)';
$string['effectiveretentionperioduser'] = '{$a} (siden forrige gang brukere vr aktiv på portalen)';
$string['emailsalutation'] = 'Kjære {$a},';
$string['errorcannotrequestdeleteforother'] = 'Du har ikke tillatelser til å opprette dataslettingsforespørsler for denne brukeren.';
$string['errorcannotrequestdeleteforself'] = 'Du har ikke tillatelser til å opprette dataslettingsforespørsler for deg selv.';
$string['errorcannotrequestexportforself'] = 'Du har ikke tillatelse til å opprette eksportforespørsel for deg selv.';
$string['errorcontactdpodisabled'] = 'Muligheten for å kontakte personvernansvarlig er deaktivert.';
$string['errorcontexthasunexpiredchildren'] = 'Konteksten "{$a}" har fortsatt underkontekster som ikke er utløpt. Ingen kontekster har blitt flagget for sletting.';
$string['errorinvalidrequestcomments'] = 'Kommentarfeltet kan kun innholde ren tekst.';
$string['errorinvalidrequestcreationmethod'] = 'ugyldig foresprselopprettelsesmetode!';
$string['errorinvalidrequeststatus'] = 'Ugyldig forespørselstatus!';
$string['errorinvalidrequesttype'] = 'Ugyldig forespørselstype!';
$string['errornocapabilitytorequestforothers'] = 'Bruker {$a-> requestedby} har ikke muligheten til å foreta en dataforespørsel på vegne av brukeren {$a-> userid}';
$string['errornoexpiredcontexts'] = 'Det er ingen utløpte kontekster å behandler';
$string['errorrequestalreadyexists'] = 'Du har allerede en aktiv forespørsel.';
$string['errorrequestnotfound'] = 'Fant ikke forespørsel';
$string['errorrequestnotwaitingforapproval'] = 'Forespørselen avventer ikke godkjenning. Enten fordi den ikke er klar ennå eller allerede er behandlet.';
$string['errorsendingmessagetodpo'] = 'Det oppstod en feil under sending av melding til {$a}.';
$string['exceptionnotificationbody'] = '<p>Unntak oppsto mens du kalte <b>
{$a->fullmethodname} </ b>. <br> Dette betyr at modulen <b> {$a->component} </b> ikke fullførte behandlingen av dataene. Nedenfor finner du unntaksinformasjon som kan sendes til modul-utvikleren.</p> <pre> {$a->message} <br>

{$a->backtrace} </pre>';
$string['exceptionnotificationsubject'] = 'Unntak oppstod under behandling av personverndata';
$string['expandplugin'] = 'Utvid- og minimermodul';
$string['expandplugintype'] = 'Utvid- og minimer modultype.';
$string['expiredretentionperiodtask'] = 'Utløpt beholdelsesperiode';
$string['expiredrolewithretention'] = '{$a->retention} (Utløpt)';
$string['expiry'] = 'Utløper';
$string['explanationtitle'] = 'Ikoner brukt på denne siden og hva de betyr.';
$string['external'] = 'Tillegg';
$string['externalexplanation'] = 'En tilleggsmodul installert på denne portalen.';
$string['filteroption'] = '{$a->category}: {$a->name}';
$string['frontpagecourse'] = 'Forsidekurs';
$string['gdpr_art_6_1_a_description'] = 'Den registrerte har gitt samtykke til behandling av hans eller hennes personopplysninger for ett eller flere spesifikke formål';
$string['gdpr_art_6_1_a_name'] = 'Samtykke (GDPR Art. 6.1(a))';
$string['gdpr_art_6_1_b_description'] = 'Behandling er nødvendig for utførelsen av en kontrakt som den registrerte er part i eller for å ta skritt på anmodning fra den registrerte før inngåelse av en kontrakt';
$string['gdpr_art_6_1_b_name'] = 'Kontrakt (GDPR Art. 6.1(b))';
$string['gdpr_art_6_1_c_description'] = 'Behandlingen er nødvendig for å oppfylle en rettslig forpliktelse som kontrolleren skal oppfylle';
$string['gdpr_art_6_1_c_name'] = 'Rettslig forpliktelse (GDPR Art 6.1(c))';
$string['gdpr_art_6_1_d_description'] = 'Behandling er nødvendig for å beskytte den registrerte vitnesbyrd eller en annen fysisk person';
$string['gdpr_art_6_1_d_name'] = 'Vitalinteresser (GDPR Art 6.1 (d))';
$string['gdpr_art_6_1_e_description'] = 'Behandling er nødvendig for utførelsen av en oppgave utført av offentlig interesse eller i utøvelse av offentlig myndighet som er ansvarlig for kontrolleren';
$string['gdpr_art_6_1_e_name'] = 'Offentlig oppgave (GDPR Art. 6.1 (e))';
$string['gdpr_art_6_1_f_description'] = 'Behandlingen er nødvendig i forbindelse med legitime interesser forfulgt av kontrolleren eller av en tredjepart, unntatt der slike interesser blir overstyrt av interesser eller grunnleggende rettigheter og friheter den registrerte som krever beskyttelse av personopplysninger, særlig hvor dataemnet er et barn';
$string['gdpr_art_6_1_f_name'] = 'Legitime interesser (GDPR Art. 6.1 (f))';
$string['gdpr_art_9_2_a_description'] = 'Den registrerte har gitt uttrykkelig samtykke til behandling av disse personopplysningene for et eller flere spesifiserte formål, med unntak av hvor unions- eller medlemsstatsloven fastsetter at forbudet nevnt i nr. 1 i GDPR artikkel 9 ikke kan løftes av den registrerte';
$string['gdpr_art_9_2_a_name'] = 'Eksplisitt samtykke (GDPR Art. 9.2 (a))';
$string['gdpr_art_9_2_b_description'] = 'Behandling er nødvendig for å utføre forpliktelsene og utøve regissørens eller den registrerte spesifikke rettigheter innen arbeids- og sosial- og sosialbeskyttelsesloven, i den utstrekning det er godkjent av unions- eller medlemsstatslov eller en kollektiv avtale i henhold til medlemsstatslovgivningen som sørger for hensiktsmessige garantier for den registreres grunnleggende rettigheter og interesser';
$string['gdpr_art_9_2_b_name'] = 'Sysselsetting og sosial sikkerhet / beskyttelse lov (GDPR Artikkel 9.2 (b))';
$string['gdpr_art_9_2_c_description'] = 'Behandlingen er nødvendig for å beskytte de vitale interessene til den registrerte eller av en annen fysisk person, der den registrerte er fysisk eller juridisk ute av stand til å gi samtykke';
$string['gdpr_art_9_2_c_name'] = 'Beskyttelse av vitale interesser (GDPR artikkel 9.2 (c))';
$string['gdpr_art_9_2_d_description'] = 'Behandling utføres i løpet av sin legitime virksomhet med hensiktsmessige garantier av en stiftelse, forening eller annen ikke-for-profit-kropp med et politisk, filosofisk, religiøst eller fagforeningsmål og under forutsetning av at behandlingen bare gjelder medlemmer eller tidligere medlemmer av kroppen eller til personer som har regelmessig kontakt med det i forbindelse med deres formål og at personopplysningene ikke blir avslørt utenfor den aktuelle organisasjonen uten samtykke fra den registrerte';
$string['gdpr_art_9_2_d_name'] = 'Legitime aktiviteter knyttet til medlemmene / nærkontakter til en stiftelse, forening eller annen ikke-for-profit organ (GDPR Art. 9.2 (d))';
$string['gdpr_art_9_2_e_description'] = 'Behandling gjelder personopplysninger som åpenbart blir offentliggjort av den registrerte';
$string['gdpr_art_9_2_e_name'] = 'Data offentliggjort av den registrerte (GDPR Art. 9.2 (e))';
$string['gdpr_art_9_2_f_description'] = 'Behandling er nødvendig for å etablere, utøve eller forsvare juridiske krav eller når domstolene handler i deres rettslige kapasitet';
$string['gdpr_art_9_2_f_name'] = 'Juridiske krav og rettssaker (GDPR Art. 9.2 (f))';
$string['gdpr_art_9_2_g_description'] = 'Behandling er nødvendig av hensyn til vesentlig offentlig interesse på grunnlag av unions- eller medlemsstatslov som skal stå i forhold til det forfulgte formål, respektere essensen av retten til databeskyttelse og sørge for egnede og konkrete tiltak for å beskytte de grunnleggende rettighetene og interessen til den registrerte';
$string['gdpr_art_9_2_g_name'] = 'Vesentlig offentlig interesse (GDPR Art. 9.2 (g))';
$string['gdpr_art_9_2_h_description'] = 'Behandling er nødvendig for forebyggende eller yrkesmedisinske formål, for vurdering av arbeidstakerens arbeidsevne, medisinsk diagnose, helse- eller sosialhjelp eller behandling eller forvaltning av helse- eller sosialhjelpssystemer og -tjenester på grunnlag av Union eller medlemsstatslov eller i henhold til kontrakt med en helsepersonell og underlagt de vilkår og garantier som er nevnt i punkt 3 i GDPR artikkel 9';
$string['gdpr_art_9_2_h_name'] = 'Medisinske formål (GDPR Art. 9.2 (h))';
$string['gdpr_art_9_2_i_description'] = 'Behandling er nødvendig av hensyn til allmennhetens interesse for folkehelsen, for eksempel beskyttelse mot alvorlige grensehelser mot helsen eller sikring av høye standarder for kvalitet og sikkerhet i helsevesenet og legemidler eller medisinsk utstyr, på grunnlag av Union eller medlemsstatslov som fastsetter egnede og konkrete tiltak for å beskytte den registrertes rettigheter og friheter, særlig taushetsplikten';
$string['gdpr_art_9_2_i_name'] = 'Folkehelse (GDPR Art. 9.2 (i))';
$string['gdpr_art_9_2_j_description'] = 'Behandling er nødvendig for arkivering i offentlig interesse, vitenskapelig eller historisk forskningsformål eller statistiske formål i samsvar med artikkel 89 nr. 1, basert på unions- eller medlemsstatslov, som skal stå i forhold til det forfulgte mål, respektere essensen av retten til databeskyttelse og sørge for egnede og konkrete tiltak for å sikre de registrerte personers grunnleggende rettigheter og interesser';
$string['gdpr_art_9_2_j_name'] = 'Offentlig interesse, eller vitenskapelig / historisk / statistisk forskning (GDPR Art. 9.2 (j))';
$string['hide'] = 'Minimer alle';
$string['httpwarning'] = 'Eventuelle data som lastes ned fra denne portalen, kan ikke krypteres. Ta kontakt med systemadministratoren og be om at de installerer SSL på dette nettstedet.';
$string['inherit'] = 'Arv';
$string['lawfulbases'] = 'Rettslig grunnlag';
$string['lawfulbases_help'] = 'Velg minst ett alternativ som vil fungere som lovlig grunnlag for behandling av personlige data. For detaljer om disse lovlige basene, se <a href="https://gdpr-info.eu/art-6-gdpr/" target="_blank"> GDPR Art. 6.1 </a>';
$string['markcomplete'] = 'Merk som løst';
$string['markedcomplete'] = 'Henvendelsen din har blitt markert som løst av personvernombudet.';
$string['message'] = 'Melding';
$string['messagelabel'] = 'Melding:';
$string['messageprovider:contactdataprotectionofficer'] = 'Dataforespørsler';
$string['messageprovider:datarequestprocessingresults'] = 'Resultat fra behandling av dataforespørsler';
$string['messageprovider:notifyexceptions'] = 'Varsler om dataforespørselsunntak';
$string['moduleinstancename'] = '{$a->instancename} ({$a->modulename})';
$string['mypersonaldatarequests'] = 'Mine persondataforespørsler';
$string['nameandparent'] = '{$a->parent} / {$a->name}';
$string['nameemail'] = '{$a->name} ({$a->email})';
$string['nchildren'] = '{$a} barn';
$string['newrequest'] = 'Ny forespørsel';
$string['noactivitiestoload'] = 'Ingen aktiviteter';
$string['noassignedroles'] = 'Ingen tildelte roller i denne konteksten';
$string['noblockstoload'] = 'Ingen blokker';
$string['nocategories'] = 'Det er ikke opprettet noen kategorier ennå';
$string['nocoursestoload'] = 'Ingen kategorier';
$string['nodatarequests'] = 'Det er ingen dataforespørsler';
$string['nodatarequestsmatchingfilter'] = 'Det er ingen dataforespørsler som passer med det gitte filteret.';
$string['noexpiredcontexts'] = 'Dette kontekstnivået har ingen data med utløpt oppbevaringsperiod.';
$string['nopersonaldatarequests'] = 'Du har ingen persondataforespørsler';
$string['nopurposes'] = 'Det er ikke opprettet noen formål ennå';
$string['nosubjectaccessrequests'] = 'Det finnes ingen dataforespørsler som krever din oppmerksomhet';
$string['nosystemdefaults'] = 'Standard portalformål og kategori er ikke definert ennå.';
$string['notset'] = 'Ikke satt (bruk standardverdi)';
$string['notyetexpired'] = '{$a} (Ikke utløpt)';
$string['overrideinstances'] = 'Tilbakestill instanser med egendefinerte verdier';
$string['pluginname'] = 'Datasikkerhet';
$string['pluginname_help'] = 'Modul for datasikkerhet';
$string['pluginregistry'] = 'Personvernkompatible moduler';
$string['pluginregistrytitle'] = 'Personvernkompatible moduler';
$string['privacy'] = 'Personvern';
$string['privacy:metadata:preference:tool_dataprivacy_request-filters'] = 'De nåværende filtrene som anvendes på dataforespørselssiden.';
$string['privacy:metadata:preference:tool_dataprivacy_request-perpage'] = 'Antallet dataforespørsler brukeren foretrekker å se på en side';
$string['privacy:metadata:request'] = 'Informasjon fra personlige dataforespørsler (innholdstilgang og sletteforespørsler) som er mottatt på denne portalen.';
$string['privacy:metadata:request:comments'] = 'Eventuelle brukerkommentarer til forespørsler.';
$string['privacy:metadata:request:dpocomment'] = 'Kommentarer fra personvernombudet angående forespørselen.';
$string['privacy:metadata:request:requestedby'] = 'IDen til brukeren som gjør forespørselen, hvis den er gjort på vegne av en annen bruker.';
$string['privacy:metadata:request:timecreated'] = 'Tidsstempelet indikerer når forespørselen ble gjort av brukeren.';
$string['privacy:metadata:request:userid'] = 'IDen til brukeren som forespørselen tilhører';
$string['privacyofficeronly'] = 'Bare brukere som er tildelt en personvernombudsrolle ({$a}) har tilgang til dette innholdet';
$string['privacyrequestexpiry'] = 'Dataforespørsel utløper';
$string['privacyrequestexpiry_desc'] = 'Tiden som godkjente dataforespørsler vil bli tilgjengelig for nedlasting. Hvis den er satt til null, er det ingen tidsbegrensning.';
$string['protected'] = 'Beskyttet';
$string['protectedlabel'] = 'Oppbevaring av disse dataene har en høyere rettspraksis enn en brukers forespørsel om å bli glemt. Disse dataene slettes bare etter at oppbevaringsperioden er utløpt.';
$string['purpose'] = 'Formål';
$string['purpose_help'] = 'Formålet beskriver årsaken til behandlingen av dataene. En ny hensikt kan legges til, eller hvis Arv er valgt, brukes formålet fra en høyere kontekst. Kontekster er (fra lav til høy):
Blokker > Aktivitetsmoduler > Kurs > Kurskategorier > Bruker > Portal.';
$string['purposecreated'] = 'Formål opprettet';
$string['purposedefault'] = 'Standard formål';
$string['purposedefault_help'] = 'Standardformålet er formålet som brukes til nye forekomster. Dersom Arv er valgt, blir det formål fra et høyere sammenheng anvendes. Kontekster er (fra lav til høy): Blokker> Aktivitetsmoduler> Kurs> Kurskategorier> Bruker> Portal.';
$string['purposeoverview'] = 'Formålet beskriver bruksområdet og bevaring av lagrede persondata. Grunnnlaget for lagring og bevaring blir også beskrevet i formlet.';
$string['purposes'] = 'Formål';
$string['purposeslist'] = 'Liste med dataformål';
$string['purposeupdated'] = 'Formål oppdatert';
$string['replyto'] = 'Svar til';
$string['requestactions'] = 'Handlinger';
$string['requestapproved'] = 'Forespørselen har blitt godkjent';
$string['requestby'] = 'Forespurt av';
$string['requestbydetail'] = 'Forespurt av:';
$string['requestcomments'] = 'Kommentarer';
$string['requestcomments_help'] = 'Dette feltet lar deg legge til mer informasjon om forespørselen din.';
$string['requestcreation'] = 'Opprettelse';
$string['requestdenied'] = 'Forespørselen har blitt avslått';
$string['requestemailintro'] = 'Du har mottatt en dataforespørsel:';
$string['requestfor'] = 'Bruker';
$string['requestmarkedcomplete'] = 'Forespørselen har blitt markert som løst.';
$string['requestorigin'] = 'Portal';
$string['requestsapproved'] = 'Forespørslene ble godtatt';
$string['requestsdenied'] = 'Forespørslene ble avslått';
$string['requeststatus'] = 'Status';
$string['requestsubmitted'] = 'Forespørselen din er sendt til personvernombudet';
$string['requesttype'] = 'Type';
$string['requesttype_help'] = 'Velg årsaken til at du vil kontakte personvernombudet. Vær oppmerksom på at sletting av persondata vil gjøre at du ikke lengre kan logge inn på portalen.';
$string['requesttypedelete'] = 'Slett alle mine persondata';
$string['requesttypedeleteshort'] = 'Slett';
$string['requesttypeexport'] = 'Eksporter alle mine persondata';
$string['requesttypeexportshort'] = 'Eksporter';
$string['requesttypeothers'] = 'Generell forespørsel';
$string['requesttypeothersshort'] = 'Melding';
$string['requesttypeuser'] = '{$a->typename} ({$a->user})';
$string['requireallenddatesforuserdeletion'] = 'Behandle kurs uten sluttdato som aktive';
$string['requireallenddatesforuserdeletion_desc'] = 'For kalkulering av brukerutløp er det fere faktorer som vurderes:

* Brukerens siste innloggingstidspunkt sammenlignes med bevaringstiden og
* Om brukeren er innmeldt i noen aktive kurs.

Ved sjekking av av aktiv påmelding i et kurs brukes avslutningsdatoen for kurset. Om kurset ikke har noen avslutningsdato er det denne innstillingen som brukes.

Om kurset ikke har noen avslutningsdato og denne innstillingen er aktiv kan ikke brukeren slettes.';
$string['requiresattention'] = 'Krever oppmerksomhet.';
$string['requiresattentionexplanation'] = 'Denne modulen implementerer ikke Moodles personvern-API. Hvis denne modulen lagrer persondata kan de ikke eksporteres eller slettes via Moodles personvernsystem.';
$string['resubmitrequest'] = 'Send inn {$a->type} forespørselen på nytt for {$a->username}';
$string['resubmitrequestasnew'] = 'Send inn på nytt som ny forespørsel';
$string['resubmittedrequest'] = 'Den eksisterende {$a->type} forespørselen for {$a->username} ble avbrutt og sendt på nytt.';
$string['resultdeleted'] = 'Du har nylig bedt om at din konto og personlige data i {$a} skal slettes. Denne prosessen er fullført, og du vil ikke lenger kunne logge inn.';
$string['resultdownloadready'] = 'Din kopi av personopplysningene dine fra {$a} som du nylig ba om, er nå tilgjengelig for nedlasting fra følgende lenke.';
$string['retentionperiod'] = 'Oppbevaringsperiode';
$string['retentionperiod_help'] = 'Oppbevaringsperioden angir hvor lang tid dataene beholdes. Når oppbevaringsperioden er utløpt, blir dataene flagget og oppført for sletting, ventende på bekreftelse fra administrator.';
$string['retentionperiodnotdefined'] = 'Det er ikke definert noen oppbevaringsperiode';
$string['retentionperiodzero'] = 'Ingen beholdelsesperiode';
$string['reviewdata'] = 'Gjennomgå data';
$string['role'] = 'Rolle';
$string['role_help'] = 'Rollen overstyringen skal anvendes på.';
$string['roleoverride'] = 'Rolleoverstyring';
$string['roleoverrideoverview'] = 'Databevaringsreglene kan overstyres for bestemte brukerroller, noe som gjør at du kan angi en kortere eller lengre bevaringsperiode. En bruker vil kun være utløpt når alle rollene er utløpt.';
$string['roleoverrides'] = 'Rolleoverstyringer';
$string['selectbulkaction'] = 'Vennligst velg en massehandling.';
$string['selectdatarequests'] = 'Vennligst velg dataforespørsler.';
$string['selectuserdatarequest'] = 'Select {$a->username}s {$a->requesttype} dataforespørsel.';
$string['send'] = 'Send';
$string['sensitivedatareasons'] = 'Årsaker til sensitive persondataprosesseringer';
$string['sensitivedatareasons_help'] = 'Velg en eller flere aktuelle grunner som unngår forbudet mot behandling av sensitive personopplysninger knyttet til dette formålet. For mer informasjon, vennligst se
 <a href="https://gdpr-info.eu/art-9-gdpr/" target="_blank">GDPR Art. 9.2</a>';
$string['setdefaults'] = 'Angi standardverdier';
$string['showdataretentionsummary'] = 'Vis databevaringssammendraget';
$string['showdataretentionsummary_desc'] = 'Dersom aktivert vil en lenke til databevaringssammendraget vises i fotteren og på profilsiden.';
$string['statusapproved'] = 'Godkjent';
$string['statusawaitingapproval'] = 'Venter godkjenning';
$string['statuscancelled'] = 'Avbrutt';
$string['statuscomplete'] = 'Fullført';
$string['statusdeleted'] = 'Slettet';
$string['statusdetail'] = 'Status:';
$string['statusexpired'] = 'Utløpt';
$string['statuspending'] = 'Ventende';
$string['statusprocessing'] = 'Behandler';
$string['statusready'] = 'Nedlasting klar';
$string['statusrejected'] = 'Avslått';
$string['subjectscope'] = 'Emneområde';
$string['subjectscope_help'] = 'Emneoversikten lister opp roller som kan tildeles i denne konteksten.';
$string['summary'] = 'Oppsummering av registerinnstillinger';
$string['systemconfignotsetwarning'] = 'Portal- og kategoriformål er ikke definert. Når dette manger vil alle data slettes når sletteforespørsler blir innvilget.';
$string['tobedeleted'] = 'Data som skal slettes';
$string['unexpiredrolewithretention'] = '{$a->retention} (Unexpired)';
$string['user'] = 'Bruker';
$string['userlistexplanation'] = 'Denne modulen har hovedtilbyder, men skal også implementer brukerlistetilbyder for full støtte av personvernfunksjonaliteten.';
$string['userlistnoncompliant'] = 'Brukerlistetilbyder mangler';
$string['viewrequest'] = 'Vis forespørsel';
$string['visible'] = 'Utvid alle';
