<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'et', version '3.11'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Tegevused';
$string['addcategory'] = 'Lisa kategooria';
$string['addcategoryerror'] = 'Ei saanud kategooriat lisada.';
$string['addexceptionerror'] = 'Viga erandi lisamisel userid:gradeitem jaoks.';
$string['addfeedback'] = 'Lisa tagasiside';
$string['addgradeletter'] = 'Lisa hindetäht';
$string['addidnumbers'] = 'Lisa ID-numbrid';
$string['additem'] = 'Lisa hinnatav tegevus';
$string['additionalfeedback'] = 'Täiendav tagasiside';
$string['addoutcome'] = 'Lisa tulemus';
$string['addoutcomeitem'] = 'Lisa tulemuseüksus';
$string['addscale'] = 'Lisa skaala';
$string['adjustedweight'] = 'Kaalutud tulemus';
$string['aggregateextracreditmean'] = 'Hinnete keskmine (koos lisapunktidega)';
$string['aggregatemax'] = 'Kõrgeim hinne';
$string['aggregatemean'] = 'Hinnete keskmine';
$string['aggregatemedian'] = 'Hinnete mediaan';
$string['aggregatemin'] = 'Madalaim hinne';
$string['aggregatemode'] = 'Hinnete mood';
$string['aggregatenotonlygraded'] = 'Kaasa tühjad hinded';
$string['aggregateonlygraded'] = 'Jäta tühjad hinded välja';
$string['aggregateonlygraded_help'] = 'Tühi hinne on hinne, mis on hinnetelehelt puudu. See võib olla ülesande esitusest, mis pole veel hinnatud, või testist, mida pole veel kordagi sooritatud vms.

See säte määrab, kas tühje hindeid ei kaasata koondtulemusse või arvestatakse kui miinimumhindeid, näiteks 0, kui ülesannet hinnatakse vahemikus 0–100.';
$string['aggregateoutcomes'] = 'Kaasa tulemused koondtulemusse';
$string['aggregateoutcomes_help'] = 'Kui see säte on lubatud, kaasatakse tulemused koondtulemusse. Selle tulemuseks võib olla ootamatu kategooria koondtulemus.';
$string['aggregatesonly'] = 'Muuda ainult koondhinnete kuvamiseks';
$string['aggregatesubcatsupgradedgrades'] = 'Märkus. Koondtulemuse arvutamise säte „Arvuta koondtulemus koos alamkategooriatega“ on õpikeskkonna uuendamise käigus eemaldatud. Kuna varem kasutati sellel kursusel sätet „Arvuta koondtulemus koos alamkategooriatega“, on soovitatav see muudatus hinnetelehel läbi vaadata.';
$string['aggregatesum'] = 'Loomulik';
$string['aggregateweightedmean'] = 'Hinnete kaalutud keskmine';
$string['aggregateweightedmean2'] = 'Lihtne hinnete kaalutud keskmine';
$string['aggregation'] = 'Koondtulemus';
$string['aggregation_help'] = 'Koondtulemuse arvutamise viis määratleb, kuidas hinded kategoorias kombineeritakse. Võimalused on näiteks sellised:

* hinnete keskmine – kõigi hinnete summa jagatuna hinnete koguarvuga;
* hinnete mediaan – keskmine hinne, kui hinded on reastatud suuruse järgi;
* madalaim hinne;
* kõrgeim hinne;
* hinnete mood – hinne, mis esineb kõige sagedamini;
* loomulik – kõigi hinnete kaalutud väärtuste summa.';
$string['aggregation_link'] = 'hinne/koondtulemus';
$string['aggregationcoef'] = 'Koondtulemuse koefitsient';
$string['aggregationcoefextra'] = 'Lisapunkt';
$string['aggregationcoefextra_help'] = 'Kui koondtulemuse arvutamise viis on „Loomulik“ või „Lihtne kaalutud keskmine“ ja lisapunkti ruut on märgitud, siis ei liideta hinnatava tegevuse maksimumhinnet kategooria maksimumhindele. See annab võimaluse saada kategooria eest maksimumhinne ilma kõigi hinnatavate tegevuste eest maksimumhindeid saamata. Kui õpikeskkonna administraator on lubanud maksimumist kõrgemad hinded, võib esineda maksimumist kõrgemaid hindeid.

Kui koondtulemuse arvutamise viis on „Hinnete keskmine (koos lisapunktidega)“ ja lisapunkti väärtuseks on määratud rohkem kui null, siis on lisapunkt tegur, millega hinne pärast keskmise arvutamist korrutatakse, enne kui see kogusummale liidetakse.';
$string['aggregationcoefextra_link'] = 'hinne/koondtulemus';
$string['aggregationcoefextrasum'] = 'Lisapunkt';
$string['aggregationcoefextrasum_help'] = 'Kui lisapunkti ruut on märgitud, ei lisata hinnatava tegevuse maksimumhinnet kategooria maksimumhindele, tulemuseks on kategoorias maksimumhinde (või sellest kõrgemate hinnete, kui õpikeskkonna administraator on selle lubanud) saamise võimalus, saamata maksimumhindeid kõikides hinnatavates tegevustes.';
$string['aggregationcoefextrasum_link'] = 'hinne/koondtulemus';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Lisapunkti kaal';
$string['aggregationcoefextraweight_help'] = 'Kui lisapunkti väärtus on seatud suuremaks kui null, toimib hinne koondtulemuses lisapunktina. Arv on tegur, millega hinne korrutatakse enne selle lisamist arvutusliku koondtulemuse keskmisele.';
$string['aggregationcoefextraweight_link'] = 'hinne/koondtulemus';
$string['aggregationcoefweight'] = 'Üksuse kaal';
$string['aggregationcoefweight_help'] = 'Hinnatava elemendi kaalu kasutatakse kategooria koondtulemuse arvestamisel, et mõjutada elemendi olulisust võrreldes sama kategooria muude hinnatavate tegevustega.';
$string['aggregationcoefweight_link'] = 'hinne/koondtulemus';
$string['aggregationhintdropped'] = '( Eemaldatud )';
$string['aggregationhintexcluded'] = '( Välistatud )';
$string['aggregationhintextra'] = '( Lisapunkt )';
$string['aggregationhintnovalue'] = '( Tühi )';
$string['aggregationofa'] = 'Üksuse {$a} koondtulemus';
$string['aggregationposition'] = 'Kategooria koondtulemuse asukoht';
$string['aggregationposition_help'] = 'See säte määrab, kas kategooria ja kursuse koondtulemuse veerud kuvatakse hinnetelehe aruandes esimese või viimasena.';
$string['aggregationsvisible'] = 'Saadavalolevad koondtulemuste tüübid';
$string['aggregationsvisiblehelp'] = 'Saate valida kõik koondtüübid, mis peaksid olema saadaval. Mitme üksuse valimiseks hoidke all klahvi Ctrl..';
$string['allgrades'] = 'Kõik hinded kategooriate kaupa';
$string['allstudents'] = 'Kõik õpilased';
$string['allusers'] = 'Kõik kasutajad';
$string['autosort'] = 'Sordi automaatselt';
$string['availableidnumbers'] = 'Id-numbrid';
$string['average'] = 'Keskmine';
$string['averagesdecimalpoints'] = 'Keskmise tulemuse komakohad';
$string['averagesdecimalpoints_help'] = 'See säte määrab, mitu komakohta kuvatakse igas keskmises hindes või kas kategoorias või hindeobjekti puhul kasutatakse üldist komakohasätet (pärandatav).';
$string['averagesdisplaytype'] = 'Keskmise tulemuse kuvamise tüüp';
$string['averagesdisplaytype_help'] = 'See säte määrab, kas keskmine kuvatakse tegelike hinnetena, protsentides või tähtedes, või kas kategooria või hinnatava tegevuse puhul kasutatakse kuvamistüüpi (päritud).';
$string['backupwithoutgradebook'] = 'Tagavarakoopias ei sisaldu hinnetelehe seadistusi';
$string['badgrade'] = 'Sisestatud hinne ei sobi';
$string['badlyformattedscale'] = 'Sisestage komaga eraldatud väärtuste loend(vähemalt kaks väärtust).';
$string['baduser'] = 'Kuvatud kasutaja on kehtetu';
$string['bonuspoints'] = 'Boonuspunktid';
$string['bulkcheckboxes'] = 'Hulgi märkeruudud';
$string['calculatedgrade'] = 'Arvutatud hinne';
$string['calculation'] = 'Arvutus';
$string['calculation_help'] = 'Hinde arvutus on valem, mida kasutatakse hinnete määramiseks. Valem peaks algama võrdusmärgiga (=) ja võidakse kasutada peamisi matemaatilisi operaatoreid, nagu näiteks max, min ja sum. Soovi korral saab muud hinnatavad tegevused arvutusse kaasata, selleks tuleb tippida nende ID-numbrid topeltnurksulgudes.';
$string['calculation_link'] = 'hinne/arvutamine';
$string['calculationadd'] = 'Lisa arvutustehe';
$string['calculationedit'] = 'Muuda arvutustehet';
$string['calculationsaved'] = 'Arvutustehe on salvestatud';
$string['calculationview'] = 'Vaata arvutustehet';
$string['cannotaccessgroup'] = 'Kahjuks puudub juurdepääs valitud rühma hinnetele.';
$string['categories'] = 'Kategooriad';
$string['category'] = 'Kategooria';
$string['categoryedit'] = 'Muuda kategooriat';
$string['categoryname'] = 'Kategooria nimi';
$string['categorytotal'] = 'Kategooria kokku';
$string['categorytotalfull'] = '{$a->category} kokku';
$string['categorytotalname'] = 'Kategooria täisnimi';
$string['changedefaults'] = 'Muuda vaikesätteid';
$string['changereportdefaults'] = 'Muuda aruannete vaikesätteid';
$string['chooseaction'] = 'Vali tegevus ...';
$string['choosecategory'] = 'Vali kategooria';
$string['collapsecriterion'] = 'Ahendamise kriteerium';
$string['combo'] = 'Vahekaardid ja rippmenüü';
$string['compact'] = 'Kompaktne';
$string['componentcontrolsvisibility'] = 'Selle, kas see hindeelement on peidetud, määravad tegevusesätted.';
$string['contract'] = 'Lepingu kategooria';
$string['contributiontocoursetotal'] = 'Panus kursuse kogutulemusse';
$string['controls'] = 'Juhtelemendid';
$string['courseavg'] = 'Kursuse keskmine';
$string['coursegradecategory'] = 'Kursuse tulemuse kategooria';
$string['coursegradedisplaytype'] = 'Kursuse tulemuse kuvamise tüüp';
$string['coursegradedisplayupdated'] = 'Kursuse hinnete kuvamise vaade on uuendatud';
$string['coursegradesettings'] = 'Kursuse hinnete sätted';
$string['coursename'] = 'Kursuse nimi';
$string['coursescales'] = 'Kursuse skaala';
$string['coursesettings'] = 'Kursusesätted';
$string['coursesettingsexplanation'] = 'Kursusesätted määratlevad ka selle, kuidas hinneteleht kõigile kursusel osalejatele kuvatakse.';
$string['coursesiamtaking'] = 'Kursused, mida ma kuulan';
$string['coursesiamteaching'] = 'Kursused, mida ma õpetan';
$string['coursetotal'] = 'Kursus kokku';
$string['createcategory'] = 'Loo kategooria';
$string['createcategoryerror'] = 'Ei saanud luua uut kategooriat';
$string['creatinggradebooksettings'] = 'Loon hinnetelehe sätteid';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Praeguse ülemkategooria koondtulemus';
$string['curveto'] = 'Ümardus';
$string['decimalpoints'] = 'Kümnendkohad';
$string['decimalpoints_help'] = 'See säte määratleb hinnetes kuvatavate kümnendkohtade arvu. See ei mõjuta hinnetega tehtavaid arvutusi, mida tehakse viie kümnendkoha täpsusega.';
$string['default'] = 'Vaikimisi';
$string['defaultprev'] = 'Vaikimisi ({$a})';
$string['deletecategory'] = 'Kustuta kategooria';
$string['disablegradehistory'] = 'Keela hinnete ajalugu';
$string['disablegradehistory_help'] = 'Saate keelata ajaloo jälgimise hinnetega seotud tabelites. See võib serveri pisut kiiremaks muuta ja hoida kokku ruumi andmebaasis.';
$string['displaylettergrade'] = 'Näita tähelisi hindeid';
$string['displaypercent'] = 'Näita protsente';
$string['displaypoints'] = 'Näita punkte';
$string['displayweighted'] = 'Näita kaalutud hindeid';
$string['dropdown'] = 'Rippmenüü';
$string['droplow'] = 'Eemalda madalaimad';
$string['droplow_help'] = 'See säte võimaldab jätta koondtulemustest välja määratud arvu madalaimaid hindeid.';
$string['droplowestvalue'] = 'Määra madalaima hinde eemaldamise väärtus';
$string['droplowestvalues'] = 'Eemalda {$a} madalaimat väärtust';
$string['dropped'] = 'Eemaldatud';
$string['dropxlowest'] = 'Eemalda X madalamat';
$string['dropxlowestwarning'] = 'Pane tähele: kui sa kasutad "Eemalda X madalamat", siis hindamine eeldab, et kõik objektid kategoorias on väärt sama palju punkte. Kui väärtused punktides erinevad, on tulemused ennustamatud.';
$string['duplicatedgradeitem'] = '{$a} (koopia)';
$string['duplicatescale'] = 'Duplikaatskaala';
$string['edit'] = 'Muuda';
$string['editcalculation'] = 'Muuda arvutustehet';
$string['editcalculationverbose'] = 'Muuda kategooria {$a->category} mooduli {$a->itemmodule} üksuse {$a->itemname} arvutusi';
$string['editfeedback'] = 'Muuda tagasisidet';
$string['editgrade'] = 'Muuda hinnet';
$string['editgradeletters'] = 'Muuda tähelisi hindeid';
$string['editoutcome'] = 'Muuda tulemust';
$string['editoutcomes'] = 'Muuda tulemusi';
$string['editscale'] = 'Muuda skaalat';
$string['edittree'] = 'Häälestus';
$string['editverbose'] = 'Muuda kategooria {$a->category} mooduli {$a->itemmodule} üksust {$a->itemname}';
$string['enableajax'] = 'Luba AJAX';
$string['enableajax_help'] = 'Lisab hindajaaruandele AJAX-i funktsionaalsuskihi, lihtsustades ja kiirendades üldisi toiminguid. Sõltub JavaScripti lubatusest kasutaja brauseri tasemel.';
$string['enableoutcomes'] = 'Luba tulemused';
$string['enableoutcomes_help'] = 'Kui see säte on lubatud, saab hinnatavate tegevuste hindamiseks kasutada üht või mitut skaalat, mis on seotud tulemuste aruandega.';
$string['encoding'] = 'Kodeering';
$string['encoding_help'] = 'Valige andmete jaoks kasutatav märgikood. (Standardkood on UTF-8.) Kui ekslikult on valitud vale kood, on seda näha imporditavate andmete eelvaates.';
$string['errorcalculationbroken'] = 'Tõenäoliselt ringviide või vigane arvutusvalem';
$string['errorcalculationnoequal'] = 'Valem peab algama võrdusmärgiga (=1+2)';
$string['errorcalculationunknown'] = 'Valem ei sobi';
$string['errorgradevaluenonnumeric'] = 'Saadud mitte-numbriline väärtus järgneva tähe madalaima või kõrgeima hinde jaoks:';
$string['errornocalculationallowed'] = 'Selle üksuse puhul pole arvutused lubatud';
$string['errornocategorisedid'] = 'Kategoriseerimata ID-d ei õnnestunud saada!';
$string['errornocourse'] = 'Ei saanud kursuse informatsiooni!';
$string['errorreprintheadersnonnumeric'] = 'Saadud mitte-numbriline väärtus päiste kordamisele.';
$string['errorsavegrade'] = 'Kahjuks ei saanud hinnet salvestada.';
$string['errorsettinggrade'] = 'Tõrge kasutaja ID {$a->userid} üksuse „{$a->itemname}“ hinde salvestamisel';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Viga hinde kategooria ID {$a->id} sätte "Ainult koondamata hinnete koondamine" värskendamisel';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Viga hinde kategooria ID {$a->id} sätte „Kaasa tulemused koondamisse” värskendamisel';
$string['errorupdatinggradecategoryaggregation'] = 'Viga hinde kategooria kategooria ID summeerimistüübi {$a->id} värskendamisel';
$string['errorupdatinggradeitemaggregationcoef'] = 'Viga hinde üksuse ID {$a->id} koondkoefitsiendi (kaal või lisakrediit) värskendamisel';
$string['eventgradedeleted'] = 'Hinne on kustutatud';
$string['eventgradeitemcreated'] = 'Hindamise kirje loodud';
$string['eventgradeitemdeleted'] = 'Hindeelement kustutatud';
$string['eventgradeitemupdated'] = 'Hindamise kirje uuendatud';
$string['eventgradelettercreated'] = 'Hindamise täht loodud';
$string['eventgradeletterdeleted'] = 'Hindamise täht kustutatud';
$string['eventgradeletterupdated'] = 'Hindamise täht uuendatud';
$string['eventgradeviewed'] = 'Hindeid vaadati hinnetelehel';
$string['eventscalecreated'] = 'Skaala loodud';
$string['eventscaledeleted'] = 'Skaala kustutatud';
$string['eventscaleupdated'] = 'Skaala uuendatud';
$string['eventusergraded'] = 'Kasutaja on hinnatud';
$string['excluded'] = 'Välja arvatud';
$string['excluded_help'] = 'Kui valitud, siis ei kajastata hinnet üheski koondtulemuses.';
$string['expand'] = 'Laienda kategooria';
$string['expandcriterion'] = 'Laienda kriteeriumi';
$string['export'] = 'Ekspordi';
$string['exportalloutcomes'] = 'Ekspordi kõik tulemused';
$string['exportfeedback'] = 'Ekspordi koos tagasisidega';
$string['exportfeedback_desc'] = 'Ekspordi ajal saab selle tühistada-';
$string['exportformatoptions'] = 'Ekspordi vorminguvalikud';
$string['exportonlyactive'] = 'Välista peatatud kasutajad';
$string['exportonlyactive_help'] = 'Kaasa eksporti ainult õppijad, kelle kursusele registreering on aktiivne ja pole peatatud';
$string['exportplugins'] = 'Ekspordi lisandmoodulid';
$string['exportsettings'] = 'Ekspordi sätted';
$string['exportto'] = 'Ekspordi kohta';
$string['externalurl'] = 'Väline URL';
$string['externalurl_desc'] = 'Välise hinnetelehe kasutamise korral tuleb URL määratleda siin.';
$string['extracreditvalue'] = 'Üksuse {$a} lisapunkti väärtus';
$string['extracreditwarning'] = 'Pane tähele: määrates kõik kategooria elemendid lisapunktideks, eemaldatakse nad hinde arvutamisest. Samuti ei näidata punktide kogusummat.';
$string['feedback'] = 'Tagasiside';
$string['feedback_help'] = 'See väli võimaldab kommenteerida lisatud hinnet.';
$string['feedbackadd'] = 'Lisa tagasiside';
$string['feedbackedit'] = 'Redigeeri tagasisidet';
$string['feedbackfiles'] = 'Tagasiside failid';
$string['feedbackforgradeitems'] = 'Tagasiside tegevusele {$a}';
$string['feedbackhistoryfiles'] = 'Tagasiside ajaloo failid';
$string['feedbacks'] = 'Tagasisided';
$string['feedbacksaved'] = 'Tagasiside salvestatud';
$string['feedbackview'] = 'Vaata tagasisidet';
$string['finalgrade'] = 'Lõpphinne';
$string['finalgrade_help'] = 'Kui ülekirjutatuse ruut on märgitud, saab hinnet lisada või muuta.';
$string['fixedstudents'] = 'Staatiline õppijate veerg';
$string['fixedstudents_help'] = 'Muudab õppijate veeru staatiliseks ja lubab hindeid kerida horisontaalselt, ilma et õppijate veerg liiguks.';
$string['forceimport'] = 'Sunni import';
$string['forceimport_help'] = 'Sunni hinnete import ka siis, kui hindeid värskendati pärast impordifaili eksportimist';
$string['forceoff'] = 'Sunni: Väljas';
$string['forceon'] = 'Sunni: Sees';
$string['forelementtypes'] = 'valitud {$a} jaoks';
$string['forstudents'] = 'Õpilastele';
$string['full'] = 'Rööpselt';
$string['fullmode'] = 'Aktiveeri täisvaade';
$string['generalsettings'] = 'Üldsätted';
$string['grade'] = 'Hinne';
$string['grade_help'] = 'Hinne, millega autasustatakse õpilast töö eest.';
$string['gradeadministration'] = 'Hinnete haldamine';
$string['gradealreadyupdated'] = '{$a} hinnet ei imporditud, sest hinded on impordifailis vanemad kui hindajaaruandes. Kui soovite hinnete importimist sellegipoolest jätkata, kasutage valikut „Sunni import“.';
$string['gradeanalysis'] = 'Hinde analüüs';
$string['gradebook'] = 'Hinneteleht';
$string['gradebookcalculationsfixbutton'] = 'Kinnita hindemuudatused ja paranda arvutusvead';
$string['gradebookcalculationsuptodate'] = 'Arvutused hinnetelehel on ajakohased. Võimalik, et muudatuste nägemiseks peate selle lehe uuesti laadima.';
$string['gradebookcalculationswarning'] = 'Märkus: Hinnetelehel kuvatavate hinnete arvutamisel tuvastati vigu. Kui kursus pole alanud või on pooleli, on soovitatav klõpsata allolevat nuppu ja vead parandada, kuigi selle tulemusel mõned hinded muudetakse. Kui teie kursus on juba lõppenud ja hinded esitatud, siis te tõenäoliselt ei soovi seda viga parandada.

Uuem versioon on {$a->currentversion}, teie kasutate hinnetelehe versiooni {$a->gradebookversion}. Muudatuste loendi leiate lehelt <a href="{$a->url}">Hinnetelehe arvutuste muudatused</a>.';
$string['gradebookhiddenerror'] = 'See hinneteleht on hetkel seatud kõike õppijate eest varjama.';
$string['gradebookhistories'] = 'Hinnete ajalood';
$string['gradebooksetup'] = 'Hinnetelehe häälestus';
$string['gradeboundary'] = 'Tähelise hinde piir';
$string['gradeboundary_help'] = 'See säte määratleb miinimumprotsendi, millest kõrgematele hinnetele määratakse täheline hinne.';
$string['gradecategories'] = 'Hinnete kategooriad';
$string['gradecategory'] = 'Hinde kategooria';
$string['gradecategoryonmodform'] = 'Hinde kategooria';
$string['gradecategoryonmodform_help'] = 'See säte kontrollib kategooriat, milles selle tegevuse hinded hinnetelehele pannakse.';
$string['gradecategorysettings'] = 'Hinde kategooria sätted';
$string['gradedisplay'] = 'Hinnete kuvamine';
$string['gradedisplaytype'] = 'Hinnete kuvamistüüp';
$string['gradedisplaytype_help'] = 'See säte määrab, kuidas hinded kuvatakse hindaja- ja kasutajaaruannetes.

* Tegelik – saadud hinded
* Protsendiline
* Täht – tähti või sõnu kasutatakse hinnete vahemikku esitamiseks';
$string['gradedon'] = 'Hinnatud $a';
$string['gradeexport'] = 'Hinnete eksport';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Hinnete ekspordi kohandatud profiiliväljad';
$string['gradeexportcustomprofilefields_desc'] = 'Kaasa need kohandatud profiiliväljad komadega eraldatult hinnete eksporti.';
$string['gradeexportdecimalpoints'] = 'Eksporditavate hinnete kümnendkohad';
$string['gradeexportdecimalpoints_desc'] = 'Eksportimisel kuvatavate kümnendkohtade arv. Selle sätte saab ekspordi ajal üle kirjutada.';
$string['gradeexportdisplaytype'] = 'Hinnete ekspordi kuvamistüüp';
$string['gradeexportdisplaytype_desc'] = 'Hindeid saab eksportimisel kuvada tegelike hinnetena, protsendina (viidates miinimum- ja maksimumhindele) või tähtedena (A, B, C jne). Selle sätte saab ekspordi ajal üle kirjutada.';
$string['gradeexportdisplaytypes'] = 'Hinnete ekspordi kuvamistüübid';
$string['gradeexportuserprofilefields'] = 'Hinnete ekspordi kasutajaprofiiliväljad';
$string['gradeexportuserprofilefields_desc'] = 'Kaasa need kasutajaprofiiliväljad komadega eraldatult hinnete eksporti.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Algsed miinimum- ja maksimumhinded';
$string['gradehelp'] = 'Hinnetelehe abi';
$string['gradehistorylifetime'] = 'Hinnete ajaloo eluiga';
$string['gradehistorylifetime_help'] = 'See määrab ära aja, kui kaua säilitada hinnetega seotud tabelite muudatuste ajalugu. Soovitatav on säilitada seda nii kaua kui võimalik. Kui esineb jõudlusprobleeme või kui andmebaasiruum on piiratud, proovige määrata väiksem väärtus.';
$string['gradeimport'] = 'Hinnete import';
$string['gradeimportfailed'] = 'Hinnete import nurjus sooritamise ajal. Üksikasjad:';
$string['gradeitem'] = 'Hinnatav tegevus';
$string['gradeitemaddusers'] = 'Eemalda hindamiselt';
$string['gradeitemadvanced'] = 'Hinnatavate tegevuste täpsemad valikud';
$string['gradeitemadvanced_help'] = 'Valige kõik elemendid, mis tuleks hinnatavate tegevuste muutmisel kuvada täpsemate valikutena.';
$string['gradeitemislocked'] = 'See tegevus on hinnetelehel lukustatud. Selle tegevuse hinnetes tehtud muudatusi ei kopeerita hinnetelehele, kuni see on lukust avamata.';
$string['gradeitemlocked'] = 'Hindamine on lukus';
$string['gradeitemmembersselected'] = 'Hindamiselt eemaldatud';
$string['gradeitemminmax'] = 'Hindeelemendi sätetes määratud miinimum- ja maksimumhinded';
$string['gradeitemnonmembers'] = 'Hindamisele lisatud';
$string['gradeitemremovemembers'] = 'Lisa hindamisele';
$string['gradeitems'] = 'Hinnatavad tegevused';
$string['gradeitemsettings'] = 'Hindeelemendi sätted';
$string['gradeitemsinc'] = 'Kaasatavad hindeelemendid';
$string['gradeletter'] = 'Täheline hinne';
$string['gradeletter_help'] = 'Tähelisi hindeid kasutatakse hinnetevahemiku väljendamiseks ja võivad olla A, B, C, ... või sõnad, näiteks arvestatud, mittearvestatud, ...';
$string['gradeletternote'] = 'Tähelise hinde kustutamiseks tühjenda<br/>üks selle tähe kohta käivatest tekstilahtritest ja salvesta muudatused.';
$string['gradeletteroverridden'] = 'Tähelised vaikehinded on praegu üle kirjutatud.';
$string['gradeletters'] = 'Tähelised hinded';
$string['gradelocked'] = 'Hinne on lukus';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Maksimumhinne';
$string['grademax_help'] = 'See säte määrab maksimumhinde, kui kasutatakse väärtuselist hindetüüpi. Tegevuspõhise hindeelemendi maksimumhinde saab määrata tegevusesätete lehel.';
$string['grademin'] = 'Miinimumhinne';
$string['grademin_help'] = 'See säte määrab miinimumhinde, kui kasutatakse väärtuselist hindetüüpi.';
$string['gradenotificationmessage'] = 'Sul on uus tagasiside sinu tehtud töö "{$a}" kohta';
$string['gradenotificationsubject'] = 'Oled saanud hinde';
$string['gradeoutcomeitem'] = 'Tulemus';
$string['gradeoutcomes'] = 'Tulemused';
$string['gradeoutcomescourses'] = 'Kursuse tulemused';
$string['gradepass'] = 'Lävend';
$string['gradepass_help'] = 'See säte määrab sooritamiseks nõutava miinimumhinde. Seda väärtust kasutatakse tegevuste ja kursuse lõpetamise jälgimisel ning hinnetelehel, kus positiivsed hinded on esile toodud rohelisega ja negatiivsed hinded punasega.';
$string['gradepassgreaterthangrade'] = 'Lävend ei saa olla suurem kui maksimaalne võimalik hinne {$a}';
$string['gradepointdefault'] = 'Hindepunkti vaikeväärtus';
$string['gradepointdefault_help'] = 'See säte määratleb hindeelemendis saadaoleva hindepunktiväärtuse vaikeväärtuse.';
$string['gradepointdefault_validateerror'] = 'See säte peab olema täisarv vahemikus ühest kuni maksimaalse hindepunktini.';
$string['gradepointmax'] = 'Maksimaalne hindepunkt';
$string['gradepointmax_help'] = 'See säte määratleb tegevuses saadaoleva hindepunkti maksimaalse väärtuse.';
$string['gradepointmax_validateerror'] = 'See säte peab olema täisarv vahemikus 1–10&#160;000.';
$string['gradepreferences'] = 'Hinnete eelistused';
$string['gradepreferenceshelp'] = 'Hindamise eelistuste abi';
$string['gradepublishing'] = 'Luba avaldamine';
$string['gradepublishing_help'] = 'Luba avaldamine eksportimistel ja importimistel: Eksporditud hinnetele saab juurde pääseda URL-i kaudu, ilma Moodle’i õpikeskkonda sisse logimata. Hindeid saab importida sarnase URL-i kaudu (mis tähendab, et Moodle’i õpikeskkond saab importida muu õpikeskkonna avaldatud hindeid). Vaikimisi saavad seda funktsiooni kasutada ainult administraatorid, palun teavitage kasutajaid enne vajalike tegevuslubade teistele rollidele lisamist (kätkeb ohtu järjehoidjate jagamisel, allatõmbajate kiirendajate programmidega, IP-piirangud jne).';
$string['gradepublishinglink'] = 'Laadi alla: {$a}';
$string['gradereport'] = 'Hinnete aruanne';
$string['graderreport'] = 'Hindajaaruanne';
$string['grades'] = 'Hinded';
$string['gradesforuser'] = 'Kasutaja {$a->user} hinded';
$string['gradesmoduledeletionpendingwarning'] = 'Hoiatus. Tegevuse kustutamine on pooleli! Mõni hinne eemaldatakse peagi.';
$string['gradesmoduledeletionprefix'] = '[Kustutamine on pooleli]';
$string['gradesonly'] = 'Aktiveeri valik „Ainult hinded“';
$string['gradessettings'] = 'Hinnete sätted';
$string['gradetype'] = 'Hinde tüüp';
$string['gradetype_help'] = 'Hinde tüüpe on neli:

* Pole – hindamine pole võimalik;
* Väärtus – numbriline koos miinimum- ja maksimumväärtusega;
* Skaala – üksus loendist;
* Tekst – ainult tagasiside.

Liita saab ainult hinde tüüpe Väärtus ja Skaala. Tegevuspõhise hindeelemendi hinde tüübi saab määrata tegevusesätete lehel.';
$string['gradevaluetoobig'] = 'Üks hindeväärtus on suurem kui üksuse {$a} lubatud maksimumhinne';
$string['gradeview'] = 'Vaata hinnet';
$string['gradewasmodifiedduringediting'] = 'Kasutajale {$a->username} töö {$a->itemname} eest sisestatud hinnet eirati, kuna seda värskendas viimati keegi teine.';
$string['gradeweighthelp'] = 'Hinnete kaalude abi';
$string['gradingmodulename'] = 'Hindamine ({$a})';
$string['groupavg'] = 'Rühma keskmine';
$string['hidden'] = 'Peidetud';
$string['hidden_help'] = 'Kui see ruut on märgitud, siis on hinded õppijate eest peidetud. Soovi korral saate määrata kuupäeva, milleni hinded peidetuks jäävad, et avaldada hinded alles pärast hindamise lõpetamist.';
$string['hiddenasdate'] = 'Kuva peidetud hinnetele postitamiskuupäev';
$string['hiddenasdate_help'] = 'Kui kasutaja ei saa peidetud hindeid kuvada, siis kuva märgi „-“ asemel esitamise kuupäev.';
$string['hiddenuntil'] = 'Peidetud kuni';
$string['hiddenuntildate'] = 'Peidetud kuni: {$a}';
$string['hideadvanced'] = 'Peida täpsemad funktsioonid';
$string['hideaverages'] = 'Peida keskmised';
$string['hidecalculations'] = 'Peida arvutused';
$string['hidecategory'] = 'Peidetud';
$string['hideeyecons'] = 'Peida ikoonide näitamine/peitmine';
$string['hidefeedback'] = 'Peida tagasiside';
$string['hideforcedsettings'] = 'Peida sunnitud sätted';
$string['hideforcedsettings_help'] = 'Sunnitud sätteid ei kuvata hindamise kasutajaliideses.';
$string['hidegroups'] = 'Peida rühmad';
$string['hidelocks'] = 'Peida lukud';
$string['hidenooutcomes'] = 'Näita tulemusi';
$string['hidequickfeedback'] = 'Peida tagasiside';
$string['hideranges'] = 'Peida vahemikud';
$string['hidetotalifhiddenitems'] = 'Peida koondtulemused, kui need sisaldavad peidetud üksusi';
$string['hidetotalifhiddenitems_help'] = 'See säte määrab, kas koondtulemused, mis sisaldavad peidetud hindeelemente, kuvatakse õppijatele või asendatakse sidekriipsuga (-). Kui kuvatakse, siis võidakse koondtulemus arvutada nii peidetud üksusi kaasates kui ka neid kaasamata.

Kui peidetud üksused välja jäetakse, erineb koondtulemus sellest, mida näeb õpetaja hindajaaruandes, kuna õpetaja näeb alati koondtulemust, mis on arvutatud kõigi üksuste, nii peidetute kui ka mittepeidetute põhjal. Kui peidetud üksused kaasatakse, võib õppijatel olla võimalik arvutada peidetud üksused välja.';
$string['hidetotalshowexhiddenitems'] = 'Kuva koondtulemus ilma peidetud üksusteta';
$string['hidetotalshowinchiddenitems'] = 'Kuva koondtulemus koos peidetud üksustega';
$string['hideverbose'] = 'Peida kategooria {$a->category} mooduli {$a->itemmodule} üksus {$a->itemname}';
$string['highgradeascending'] = 'Sorteeri kasvavalt kõrgeima hinde järgi';
$string['highgradedescending'] = 'Sorteeri kahanevalt kõrgeima hinde järgi';
$string['highgradeletter'] = 'Kõrgeim';
$string['identifier'] = 'Kasutaja tuvastamisalus:';
$string['idnumbers'] = 'ID-numbrid';
$string['ignore'] = 'Eira';
$string['import'] = 'Impordi';
$string['importcsv'] = 'Impordi CSV-fail';
$string['importcsv_help'] = 'Hindeid saab CSV-faili kaudu importida järgmises vormingus:

* iga faili rida sisaldab üht kirjet;
* iga kirje on komaga või mõne muu eraldajaga eraldatud andmete rida;
* esimene kirje sisaldab väljanimede loendit ja määratleb ülejäänud faili vormingu;
* nõutav on kasutaja ID andmeid sisaldav väljanimi – kasutajanimi, ID-number või meiliaadress.

Õiges vormingus faili saab hankida, kui kõigepealt eksportida mõned hinded. Seda faili saab seejärel muuta ja CSV-failina salvestada.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Impordi kohandatud tulemustena (ainult see kursus)';
$string['importerror'] = 'Ilmnes tõrge, seda skripti ei kutsutud õigete parameetritega.';
$string['importfailed'] = 'Import nurjus. Andmeid ei imporditud.';
$string['importfeedback'] = 'Impordi tagasiside';
$string['importfile'] = 'Impordi fail';
$string['importfilemissing'] = 'Faili ei saadud; minge tagasi vormi juurde ja tehke kindlaks, kas laadisite üles sobiva faili.';
$string['importfrom'] = 'Impordi';
$string['importoutcomenofile'] = 'Üles laaditud fail oli tühi või rikutud. Palun veenduge, et see on sobiv fail. Probleem tuvastati real {$a}; see on põhjustatud sellest, et andmeread ei sisaldanud nii palju veerge kui esimene rida (päiserida) või imporditud failis puuduvad eeldatavad päised. Sobiva päisega faili näite saamiseks vaadake eksporditud faili.';
$string['importoutcomes'] = 'Impordi tulemused';
$string['importoutcomes_help'] = 'Tulemusi saab importida CSV-faili kaudu, mille vorming on samasugune nagu eksporditulemuste CSV-failil.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Imporditud tulemus „{$a->name}“ ID-ga #{$a->id}';
$string['importplugins'] = 'Impordi lisandmoodulid';
$string['importpreview'] = 'Impordi eelvaade';
$string['importsettings'] = 'Impordisätted';
$string['importskippednomanagescale'] = 'Teil pole õigust uut skaalat lisada, seega jäeti tulemus „{$a}“ vahele, sest see nõuab uue skaala loomist';
$string['importskippedoutcome'] = 'Tulemus lühinimega „{$a}“ on selles kontekstis juba olemas, imporditud failis olev jäeti vahele.';
$string['importstandard'] = 'Impordi standardtulemustena';
$string['importsuccess'] = 'Hinnete importimine õnnestus';
$string['importxml'] = 'Impordi XML';
$string['includescalesinaggregation'] = 'Kaasa skaalad koondtulemusse';
$string['includescalesinaggregation_help'] = 'Saate määrata, kas kõik skaalad kaasatakse numbritena kõikidesse koondhinnetesse kõikide kursuste kõikidel hinnetelehtedel. HOIATUS: selle sätte muutmine sunnib kõiki koondhindeid uuesti arvutama.';
$string['incorrectcourseid'] = 'Kursuse ID oli vigane';
$string['incorrectcustomscale'] = '(Vale kohandatud skaala, palun muutke.)';
$string['incorrectminmax'] = 'Miinimum peab olema väiksem kui maksimum';
$string['inherit'] = 'Päritav';
$string['intersectioninfo'] = 'Õppija/hinde info';
$string['invalidgradeexporteddate'] = 'Ekspordikuupäev ei sobi, kuna see on rohkem kui aasta vana või tulevikus või on vorming vale.';
$string['item'] = 'Üksus';
$string['iteminfo'] = 'Üksuse teave';
$string['iteminfo_help'] = 'See säte pakub ruumi üksuse kohta teabe sisestamiseks. Teavet ei kuvata mitte kuskil mujal.';
$string['itemname'] = 'Üksuse nimi';
$string['itemnamehelp'] = 'Selle mooduli sisestatud üksuse nimi.';
$string['items'] = 'Üksused';
$string['itemsedit'] = 'Muuda hindeelementi';
$string['keephigh'] = 'Säilita kõrgeim tulemus';
$string['keephigh_help'] = 'Kui valitud on see säte, säilitatakse ainult X kõrgeimat hinnet. X on väärtus, mille sellele valikule määrate.';
$string['keephighestvalues'] = 'Säilita {$a} suurimat väärtust';
$string['keymanager'] = 'Võtmehaldur';
$string['lessthanmin'] = 'Kasutaja {$a->username} töö {$a->itemname} hinne on madalam kui lubatud miinimum';
$string['letter'] = 'Täht';
$string['lettergrade'] = 'Täheline hinne';
$string['lettergradenonnumber'] = 'Madalaim ja/või kõrgeim hinne oli mitte-numbriline järgmise tähe jaoks:';
$string['letterpercentage'] = 'Täheline hinne (protsent)';
$string['letterreal'] = 'Täheline hinne (tegelik)';
$string['letters'] = 'Tähed';
$string['linkedactivity'] = 'Seotud tegevus';
$string['linkedactivity_help'] = 'See säte määrab tegevuse, millega see õpiväljund seotud on. Seda saab kasutada, et saada ülevaade õppija oskustest teatud kriteeriumide, mitte lihtsalt tegevuse hinde põhjal.';
$string['linktoactivity'] = 'Link üksuse {$a->title} tegevusele {$a->name}';
$string['lock'] = 'Lukusta';
$string['locked'] = 'Lukus';
$string['locked_help'] = 'Kui see ruut on märgitud, siis ei saa hindega seotud tegevus hindeid enam automaatselt värskendada.';
$string['locktime'] = 'Lukus pärast';
$string['locktimedate'] = 'Lukus pärast: {$a}';
$string['lockverbose'] = 'Lukusta kategooria {$a->category} mooduli {$a->itemmodule} üksus {$a->itemname}';
$string['lowest'] = 'Madalaim';
$string['lowgradeletter'] = 'Madalaim';
$string['manualitem'] = 'Käsitsiüksus';
$string['mapfrom'] = 'Vastenda kohast';
$string['mapfrom_help'] = 'Valige arvutustabelis veerg, mis sisaldab kasutajatuvastusandmeid (kasutajanimi, kasutaja ID, meiliaadress).';
$string['mappings'] = 'Hindeelemendi vastendused';
$string['mappings_help'] = 'Arvutustabeli iga hinneteveeru jaoks valige vastav hindeelement, kuhu hinded importida.';
$string['mapto'] = 'Vastenda kohta';
$string['mapto_help'] = 'Valige samad tuvastusandmed, nagu valisite sätte „Vastenda kohast“ jaoks.';
$string['max'] = 'Kõrgeim';
$string['maxgrade'] = 'Maksimumhinne';
$string['meanall'] = 'Kõik hinded';
$string['meangraded'] = 'Mittetühjad hinded';
$string['meanselection'] = 'Kasuta keskmise arvutamiseks';
$string['meanselection_help'] = 'See säte määratleb, kas iga kategooria või hindeelemendi keskmise arvutamisel kaasatakse hinneteta lahtrid.';
$string['median'] = 'Mediaan';
$string['min'] = 'Madalaim';
$string['minimum_show'] = 'Kuva miinimumhinne';
$string['minimum_show_help'] = 'Miinimumhinnet kasutatakse hinnete ja kaalude arvutamisel. Kui seda ei kuvata, on miinimumhinne vaikimisi null ja seda ei saa muuta.';
$string['minmaxtouse'] = 'Arvutamisel kasutatav miinimum- ja maksimumhinne';
$string['minmaxtouse_desc'] = 'See säte määratleb, kas hinnetelehel kuvatava hinde arvutamiseks kasutatakse hinde andmise ajal kehtinud algset miinimum- ja maksimumhinnet või neid, mis on määratud hindeelemendi sätetemenüüs. Soovitatav on seda sätet muuta tipptunnivälisel ajal, kuna selle tõttu arvutatakse kõik hinded uuesti ja see võib põhjustada serveri suure koormuse.';
$string['minmaxtouse_help'] = 'See säte määratleb, kas hinnetelehel kuvatava hinde arvutamiseks kasutatakse hinde andmise ajal kehtinud algset miinimum- ja maksimumhinnet või neid, mis on määratud hindeelemendi sätetemenüüs.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Märkus. Osa hindeid on muudetud, et lahendada hinnetelehel olev vastuolu, mille põhjustas kuvatava hinde arvutamisel kasutatud miinimum- ja maksimumhinde muutmine. Soovitatav on muudatused läbi vaadata ja kinnitada.';
$string['minmaxupgradefixbutton'] = 'Lahenda vastuolud';
$string['minmaxupgradewarning'] = 'Märkus. Mõne hinde puhul on tuvastatud vastuolu, kuna muudetud on hinnetelehel kuvatava hinde arvutamisel kasutatud miinimum- ja maksimumhinnet. Soovitatav on, et järjekindlusetused lahendatakse allolevat nuppu klõpsates, kuigi selle tulemusel mõned hinded muudetakse.';
$string['missingitemtypeoreid'] = 'Üksuse grade_edit_tree_column_select::get_item_cell($item, $params) teisest parameetrist puudub massiivi võti (itemtype või eid)';
$string['missingscale'] = 'Skaala peab olema valitud';
$string['mode'] = 'Režiim';
$string['modgrade'] = 'Hinne';
$string['modgrade_help'] = 'Valige selle tegevuse jaoks kasutatav hindamistüüp. Kui valitud on „Skaala“, saate skaala valida skaalade ripploendist. „Punkti“ kasutamisel korral saate siis sisestada selle tegevuse eest saadaval oleva maksimumhinde.';
$string['modgradecantchangegradetype'] = 'Tüüpi ei saa muuta, sest selle üksuse jaoks on hinded juba olemas.';
$string['modgradecantchangegradetypemsg'] = 'Mõni hinne on juba antud, seetõttu ei saa enam tüüpi muuta. Kui soovite maksimumhinnet muuta, peate enne määrama, kas olemasolevad hinded teisendatakse uuele skaalale või mitte.';
$string['modgradecantchangegradetyporscalemsg'] = 'Mõni hinne on juba antud, seetõttu pole enam võimalik hinnete tüüpi ja skaalat muuta.';
$string['modgradecantchangeratingmaxgrade'] = 'Maksimumhinnet ei saa muuta, kui hinnatava tegevuse jaoks on juba mõni hinne olemas.';
$string['modgradecantchangescale'] = 'Skaalat ei saa muuta, sest selle üksuse jaoks on hinded juba olemas.';
$string['modgradecategorycantchangegradetypemsg'] = 'Kategooriaga on seostatud hinnatavad tegevused, mis on üle kirjutatud. Seetõttu on mõni hinne juba antud ja hinde tüüpi ei saa enam muuta. Kui soovite maksimumhinnet muuta, peate enne määrama, kas olemasolevad hinded teisendatakse uuele skaalale või mitte.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Kategooriaga on seostatud hinnatavad tegevused, mis on üle kirjutatud. Seetõttu on mõni hinne juba antud ja hinde tüüpi ja skaalat pole enam võimalik muuta.';
$string['modgradecategoryrescalegrades'] = 'Teisenda ülekirjutatud hinded uuele skaalale';
$string['modgradecategoryrescalegrades_help'] = 'Kui muudate hinnetelehe üksuse maksimumhinnet, peate määrama, kas olemasolevad protsentuaalsed hinded muutuvad samuti.

Kui määrate väärtuseks „Jah“, teisendatakse ülekirjutatud hinded uuele skaalale nii, et protsentuaalne hinne jääb samaks.

Näide. Kui määrate selle valiku väärtuseks „Jah“ ja muudate üksuse maksimumhinde väärtuselt 10 väärtusele 20, teisendatakse vana skaala hinne 6/10 (60%) uuel skaalal hindeks 12/20 (60%). Kui valiku väärtuseks on määratud „Ei“, siis hinnet ei muudeta ja seda peab õigete tulemuste tagamiseks käsitsi muutma.';
$string['modgradedonotmodify'] = 'Ära muuda olemasolevaid hindeid';
$string['modgradeerrorbadpoint'] = 'Hinde väärtus on sobimatu Väärtus peab olema täisarv vahemikus 1–{$a}';
$string['modgradeerrorbadscale'] = 'Valitud on sobimatu skaala. Veenduge, et valiksite skaala allolevate valikuvariantide hulgast.';
$string['modgrademaxgrade'] = 'Maksimumhinne';
$string['modgraderescalegrades'] = 'Teisenda olemasolevad hinded uuele skaalale';
$string['modgraderescalegrades_help'] = 'Kui muudate hinnetelehe üksuse maksimumhinnet, peate määrama, kas olemasolevad protsentuaalsed hinded muutuvad samuti.

Kui määrate väärtuseks „Jah“, teisendatakse olemasolevad hinded uuele skaalale nii, et protsentuaalne hinne jääb samaks.

Näide. Kui määrate selle valiku väärtuseks „Jah“ ja muudate üksuse maksimumhinde väärtuselt 10 väärtusele 20, teisendatakse vana skaala hinne 6/10 (60%) uuel skaalal hindeks 12/20 (60%). Kui valiku väärtuseks on määratud „Ei“, siis teisendatakse vana skaala hinne 6/10 (60%) uue skaala hindeks 6/20 (30%) ja seda peab õigete tulemuste tagamiseks käsitsi muutma.';
$string['modgradetype'] = 'Tüüp';
$string['modgradetypenone'] = 'Pole';
$string['modgradetypepoint'] = 'Punkt';
$string['modgradetypescale'] = 'Skaala';
$string['morethanmax'] = 'Kasutaja {$a->username} töö {$a->itemname} hinne on kõrgem kui lubatud maksimum';
$string['moveselectedto'] = 'Teisalda valitud üksused kohta';
$string['movingelement'] = '{$a} teisaldamine';
$string['multfactor'] = 'Kordaja';
$string['multfactor_help'] = 'Kordaja on tegur, millega korrutatakse kõiki selle hindeelemendi hindeid, maksimaalseks väärtuseks saab olla maksimumhinne. Näiteks kui kordaja on 2 ja maksimumhinne on 100, siis kõik hinded, mis on väiksemad kui 50, korrutatakse arvuga 2, ja kõik hinded, mis on 50 või sellest suuremad, muudetakse 100-ks.';
$string['multfactorvalue'] = 'Üksuse {$a} kordaja väärtus';
$string['mustchooserescaleyesorno'] = 'Peate valima, kas olemasolevad hinded teisendatakse uuele skaalale';
$string['mygrades'] = 'Kasutajamenüü hinnete link';
$string['mygrades_desc'] = 'See säte võimaldab anda võimaluse linkida kasutajamenüüst välisele hinnetelehele.';
$string['mypreferences'] = 'Minu eelistused';
$string['myreportpreferences'] = 'Minu aruande-eelistused';
$string['navmethod'] = 'Navigeerimisviis';
$string['neverdeletehistory'] = 'Ära kunagi kustuta ajalugu';
$string['newcategory'] = 'Uus kategooria';
$string['newitem'] = 'Uus hindeelement';
$string['newoutcomeitem'] = 'Uus õpiväljund';
$string['no'] = 'Ei';
$string['nocategories'] = 'Selle kursuse jaoks ei suudetud lisada või leida hinnete kategooriaid.';
$string['nocategoryname'] = 'Kategooria nime ei antud';
$string['nocategoryview'] = 'Pole ühtki kategooriat, mille järgi vaadata';
$string['nocourses'] = 'Siin pole veel ühtegi kursust';
$string['noforce'] = 'Ära sunni';
$string['nogradeletters'] = 'Tähelisi hindeid ei ole määratud';
$string['nogradesreturned'] = 'Ühtki hinnet ei tagastatud';
$string['noidnumber'] = 'ID-number puudub';
$string['nolettergrade'] = 'Pole tähelist hinnet:';
$string['nomode'] = 'pole';
$string['nonnumericweight'] = 'Saadud mitte-numbriline väärtus:';
$string['nonunlockableverbose'] = 'Hinnet ei saa lukust avada, kuni {$a->itemname} on lukust avamata.';
$string['nonweightedpct'] = 'mitte-kaalutud %';
$string['nooutcome'] = 'Tulemust pole';
$string['nooutcomes'] = 'Õpiväljundid peavad olema seotud kursuse tulemusega, aga sellel kursusel pole tulemusi. Kas sooviksite lisada?';
$string['nopermissiontoresetweights'] = 'Kaalude lähtestamiseks pole õigust';
$string['nopublish'] = 'Ära avalda';
$string['noreports'] = 'Te ei ole selles õpikeskkonnas registreerunud ühelegi kursusele ega õpeta ühtegi kursust.';
$string['norolesdefined'] = 'Rolle pole määratletud jaotises Haldamine > Hinded > Üldsätted > Hinnatavad rollid';
$string['noscales'] = 'Tulemused peavad olema seotud kursuse skaalaga või globaalse skaalaga, aga kumbagi pole. Kas sooviksite lisada?';
$string['noselectedcategories'] = 'Ühtegi kategooriat ei ole valitud';
$string['noselecteditems'] = 'Ühtegi objekti ei ole valitud';
$string['notenrolled'] = 'Te pole praegu ühelegi kursusele registreeritud.';
$string['notteachererror'] = 'Selle vahendi kasutamiseks peate olema õpetaja õigustes';
$string['nousersloaded'] = 'Ühtegi kasutajat ei laaditud';
$string['nouserstograde'] = 'Ei ole kasutajaid keda hinnata';
$string['numberofgrades'] = 'Hindeid';
$string['onascaleof'] = 'skaalal {$a->grademin} kuni {$a->grademax}';
$string['operations'] = 'Toimingud';
$string['options'] = 'Valikud';
$string['others'] = 'Teised';
$string['outcome'] = 'Tulemus';
$string['outcome_help'] = 'See säte määratleb tulemuse, mida see hindeelement hinnetelehel väljendab.';
$string['outcomeassigntocourse'] = 'Määra sellele kursusele muu tulemus';
$string['outcomecategory'] = 'Loo tulemusi kategoorias';
$string['outcomecategorynew'] = 'Uus kategooria';
$string['outcomeconfirmdelete'] = 'Kas soovite tulemuse "{$a}" kindlasti kustutada?';
$string['outcomecreate'] = 'Lisa uus tulemus';
$string['outcomedelete'] = 'Kustuta tulemus';
$string['outcomefullname'] = 'Täisnimi';
$string['outcomeitem'] = 'Õpiväljund';
$string['outcomeitemsedit'] = 'Muuda õpiväljundit';
$string['outcomereport'] = 'Hinde ülevaade';
$string['outcomes'] = 'Tulemused';
$string['outcomescourse'] = 'Kasutatud tulemusi kursuses';
$string['outcomescoursecustom'] = 'Kasutati kohandatud (ei saa eemaldada)';
$string['outcomescoursenotused'] = 'Standardseid ei kasutata';
$string['outcomescourseused'] = 'Kasutati standardseid (ei saa eemaldada)';
$string['outcomescustom'] = 'Kohandatud tulemused';
$string['outcomeshortname'] = 'Lühinimi';
$string['outcomesstandard'] = 'Standardtulemused';
$string['outcomesstandardavailable'] = 'Saadaval standardtulemused';
$string['outcomestandard'] = 'Standardtulemus';
$string['outcomestandard_help'] = 'Standardtulemused on kättesaadavad õpikeskkonnaüleselt kõikide kursuste jaoks.';
$string['overallaverage'] = 'Üldine keskmine';
$string['overridden'] = 'Üle kirjutatud';
$string['overridden_help'] = 'Kui see ruut on märgitud, siis ei saa hinnet enam seotud tegevuse käigus muuta.

Kui hinnet on muudetud hindajaraportis, siis märgitakse ülekirjutatuse ruut automaatselt. Märget on siiski võimalik ka tühistada, et võimaldada hindega seotud tegevuse käigus hinde muutmine.';
$string['overriddennotice'] = 'Teie selle tegevuse lõpphinnet oli käsitsi kohandatud.';
$string['overridecat'] = 'Luba kategooriahinnete käsitsi ülekirjutamine';
$string['overridecat_help'] = 'Selle sätte keelamine teeb kasutajatel kategooriahinnete ülekirjutamise võimatuks.';
$string['overridesitedefaultgradedisplaytype'] = 'Kirjuta õpikeskkonna vaikesätted üle';
$string['overridesitedefaultgradedisplaytype_help'] = 'Kui see ruut on märgitud, siis saab kursusele määrata tähelised hinded ja nende piirid, selle asemel et kasutada õpikeskkonna vaikeväärtusi.';
$string['overrideweightofa'] = 'Kirjuta hinde {$a} kaal üle';
$string['parentcategory'] = 'Ülemkategooria';
$string['pctoftotalgrade'] = '% koguhindest';
$string['percent'] = 'Protsenti';
$string['percentage'] = 'Protsent';
$string['percentageletter'] = 'Protsent (täheline hinne)';
$string['percentagereal'] = 'Protsent (tegelik)';
$string['percentascending'] = 'Sorteeri kasvavalt protsendi järgi';
$string['percentdescending'] = 'Sorteeri kahanevalt protsendi järgi';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Nihe';
$string['plusfactor_help'] = 'Nihe on arv, mis lisatakse igale hindele selle hindeelemendi kohta pärast kordaja rakendamist.';
$string['plusfactorvalue'] = 'Hinde {$a} nihke väärtus';
$string['points'] = 'punktid';
$string['pointsascending'] = 'Sorteeri kasvavalt punktide järgi';
$string['pointsdescending'] = 'Sorteeri kahanevalt punktide järgi';
$string['positionfirst'] = 'Esimene';
$string['positionlast'] = 'Viimane';
$string['preferences'] = 'Eelistused';
$string['prefgeneral'] = 'Üldine';
$string['prefletters'] = 'Tähelised hinded ja nende piirid';
$string['prefrows'] = 'Eriread';
$string['prefshow'] = 'Kuva/peida lülitid';
$string['previewrows'] = 'Kuva ridade eelvaade';
$string['privacy:metadata:categorieshistory'] = 'Klassikategooriate eelmiste versioonide register';
$string['privacy:metadata:filepurpose'] = 'Kasutaja jaoks hinneraamatusse salvestatud tagasisidefailid.';
$string['privacy:metadata:grade_import_newitem'] = 'Ajutine tabel uute hinnete kirjete salvestamiseks, mis pärinevad hinnete impordist';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Unikaalne partiikood ühe impordipartii identifitseerimiseks';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Andmeid importiv kasutaja';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Uue hinde kirje nimi';
$string['privacy:metadata:grade_import_values'] = 'Ajutine tabel hinnete importimiseks';
$string['privacy:metadata:grade_import_values:feedback'] = 'Hinde tagasiside';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Töötlemata hinde väärtus';
$string['privacy:metadata:grade_import_values:importcode'] = 'Unikaalne partiikood ühe impordipartii identifitseerimiseks';
$string['privacy:metadata:grade_import_values:importer'] = 'Andmeid importiv kasutaja';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Märgista, kui imporditi ainult tagasisidet';
$string['privacy:metadata:grade_import_values:userid'] = 'Kasutaja, kelle hinna imporditi';
$string['privacy:metadata:grades'] = 'Hinnete register';
$string['privacy:metadata:grades:aggregationstatus'] = 'Koondamise olek';
$string['privacy:metadata:grades:aggregationweight'] = 'Koondamise kaal';
$string['privacy:metadata:grades:feedback'] = 'Tagasiside';
$string['privacy:metadata:grades:finalgrade'] = 'Hinne';
$string['privacy:metadata:grades:information'] = 'Täiendav info hinde kohta';
$string['privacy:metadata:grades:timemodified'] = 'Hinde viimane muutmise aeg';
$string['privacy:metadata:grades:userid'] = 'Kasutaja ID, kellele hinne kuulub';
$string['privacy:metadata:grades:usermodified'] = '';
$string['privacy:metadata:gradeshistory'] = 'Eelnevate hinnete register';
$string['privacy:metadata:history:loggeduser'] = 'Versioonimise ajal sisse logitud kasutaja ID';
$string['privacy:metadata:history:timemodified'] = 'Hinnete versioonimise aeg';
$string['privacy:metadata:itemshistory'] = 'Hinnete varasemate versioonide register';
$string['privacy:metadata:outcomes'] = 'Tulemuste register';
$string['privacy:metadata:outcomes:timemodified'] = 'Registri muutmise aeg';
$string['privacy:metadata:outcomes:usermodified'] = 'Registrit muutnud kasutaja ID';
$string['privacy:metadata:outcomeshistory'] = 'Tulemuste varasemate versioonide salvestus';
$string['privacy:metadata:scale'] = 'Skaalade register';
$string['privacy:metadata:scale:timemodified'] = 'Registri viimase muutmise aeg';
$string['privacy:metadata:scale:userid'] = 'Reigistrit muutnud kasutaja';
$string['privacy:metadata:scalehistory'] = 'Skaalade eelnevate versioonide register';
$string['privacy:path:relatedtome'] = 'Minuga seotud';
$string['privacy:request:historyactiondelete'] = 'Kustuta';
$string['privacy:request:historyactioninsert'] = 'Sisesta';
$string['privacy:request:historyactionupdate'] = 'Uuenda';
$string['privacy:request:unknowndeletedgradeitem'] = 'Tundmatu (hinde kirje kustutati)';
$string['profilereport'] = 'Kasutajaprofiili aruanne';
$string['profilereport_help'] = 'Hinnetearuannet kasutatakse kasutaja profiililehel.';
$string['publishing'] = 'Avaldamine';
$string['publishingoptions'] = 'Hinde avaldamise võimalused';
$string['quickfeedback'] = 'Kiirtagasiside';
$string['quickgrading'] = 'Kiirhindamine';
$string['quickgrading_help'] = 'Kui see säte on lubatud, kuvatakse muutmise sisselülitamisel iga hinde jaoks tekstisisestusväli, mis võimaldab muuta korraga mitut hinnet. Muudatused salvestatakse ja tuuakse esile pärast värskendusnupu klõpsamist.

Pange tähele, et kui tagasisidet muudetakse hindajaaruandes, määratakse ülekirjutatuse lipp, mis tähendab seda, et seda tagasisidet ei saa enam seotud tegevuse käigus muuta.';
$string['range'] = 'Vahemik';
$string['rangedecimals'] = 'Vahemiku kümnendkohad';
$string['rangedecimals_help'] = 'Vahemiku puhul kuvatav kümnendkohtade arv';
$string['rangesdecimalpoints'] = 'Vahemiku kümnendkohad';
$string['rangesdecimalpoints_help'] = 'See säte määrab, mitu komakohta kuvatakse igas vahemikus või kas kategoorias või hindeelemendis kasutatakse üldist komakohasätet (pärandatav).';
$string['rangesdisplaytype'] = 'Vahemiku kuvamistüüp';
$string['rangesdisplaytype_help'] = 'See säte määrab, kas vahemik kuvatakse tegelike hinnetena, protsentides või tähtedes, või kas kategooria või hinnatava tegevuse puhul kasutatakse kuvamistüüpi (päritud).';
$string['rank'] = 'Võrdlus teistega';
$string['rawpct'] = 'Puhas %';
$string['real'] = 'Tegelik';
$string['realletter'] = 'Tegelik (täheline hinne)';
$string['realpercentage'] = 'Tegelik (protsent)';
$string['recalculatinggrades'] = 'Hinnete ümberarvutamine';
$string['recovergradesdefault'] = 'Taasta hinnete vaikeväärtused';
$string['recovergradesdefault_help'] = 'Saate vaikimisi taastada kasutaja uuesti kursusele registreerimisel vanad hinded.';
$string['refreshpreview'] = 'Värskenda eelvaadet';
$string['regradeanyway'] = 'Hinda ikkagi uuesti';
$string['removeallcoursegrades'] = 'Kustuta kõik hinded';
$string['removeallcoursegrades_help'] = 'Kui see valik on märgitud, kustutatakse kõik hinnetelehele käsitsi lisatud hindeelemendid koos hinnete ja ülekirjutatud, välistatud, peidetud ja lukustatud hinnete andmetega Alles jäävad ainult tegevustega seotud hindeelemendid.';
$string['removeallcourseitems'] = 'Kustuta kõik objektid ja kategooriad';
$string['removeallcourseitems_help'] = 'Kui see valik on märgitud, kustutatakse kõik hinnetelehele käsitsi lisatud kategooriad ja hindeelemendid koos hinnete ja ülekirjutatud, välistatud, peidetud ja lukustatud hinnete andmetega Alles jäävad ainult tegevustega seotud hindeelemendid.';
$string['report'] = 'Aruanne';
$string['reportdefault'] = 'Aruannete vaikesätted ({$a})';
$string['reportplugins'] = 'Aruande pluginad';
$string['reportsettings'] = 'Aruandesätted';
$string['reprintheaders'] = 'Päiste kordamine';
$string['resetweights'] = 'Lähtesta üksuse {$a->itemname} kaalud';
$string['resetweightsshort'] = 'Lähtesta kaalud';
$string['respectingcurrentdata'] = 'jäetakse praegune seadistus muutmata';
$string['rowpreviewnum'] = 'Kuva ridade eelvaade';
$string['rowpreviewnum_help'] = 'Enne impordi kinnitamist saab kuvada imporditavate andmete eelvaate. See säte määratleb, kui mitu rida eelvaates kuvatakse.';
$string['savechanges'] = 'Salvesta muudatused';
$string['savepreferences'] = 'Salvesta eelistused';
$string['scaleconfirmdelete'] = 'Kas soovite kindlasti kustutada skaala „{$a}“?';
$string['scaledpct'] = 'Skaala %';
$string['seeallcoursegrades'] = 'Kuva kõik kursuse hinded';
$string['select'] = 'Vali {$a}';
$string['selectalloroneuser'] = 'Valige kõik või üks kasutaja';
$string['selectauser'] = 'Valige kasutaja';
$string['selectdestination'] = 'Vali sihtkoht {$a}';
$string['separator'] = 'Eraldaja';
$string['separator_help'] = 'Valige CSV-failis kasutatav eraldaja. (Tavaliselt on selleks koma.)';
$string['sepcolon'] = 'Koolon';
$string['sepcomma'] = 'Koma';
$string['sepsemicolon'] = 'Semikoolon';
$string['septab'] = 'Tabulaator';
$string['setcategories'] = 'Määra kategooriad';
$string['setcategorieserror'] = 'Sa pead esmalt määrama oma kursusele kategooriad, enne kui saad neile kaalusid anda';
$string['setgradeletters'] = 'Määra tähelised hinded';
$string['setpreferences'] = 'Määra eelistused';
$string['setting'] = 'Säte';
$string['settings'] = 'Sätted';
$string['setweights'] = 'Määra kaalud';
$string['showactivityicons'] = 'Kuva tegevuste ikoonid';
$string['showactivityicons_help'] = 'Kui see säte on lubatud, kuvatakse tegevuste nimede kõrval tegevuste ikoonid.';
$string['showallhidden'] = 'Kuva peidetud';
$string['showallstudents'] = 'Näita kõiki õppijaid';
$string['showanalysisicon'] = 'Kuva hinnete analüüsi ikoon';
$string['showanalysisicon_desc'] = 'Saate valida, kas vaikimisi kuvatakse hinnete analüüsi ikoon või mitte. Kui tegevusmoodul seda toetab, lingib hinnete analüüsi ikoon lehele, kus on hinde ja selle saamispõhjuse üksikasjalikum selgitus.';
$string['showanalysisicon_help'] = 'Kui tegevusmoodul seda toetab, lingib hinnete analüüsi ikoon lehele, kus on hinde ja selle saamispõhjuse üksikasjalikum selgitus.';
$string['showaverage'] = 'Kuva keskmine';
$string['showaverage_help'] = 'Saate määrata, kas keskmise hinde veerg kuvatakse. Pange tähele, et kui keskmine arvutatakse väheste hinnete põhjal, võivad osalejad teiste hinded välja arvutada. Jõudluspõhjustel on keskmine hinne umbkaudne, kui see sõltub mõnest peidetud üksusest.';
$string['showaverages'] = 'Kuva keskmise tulemuse veerg';
$string['showaverages_help'] = 'Kui see säte on lubatud, sisaldab hindajaaruanne lisarida, kus kuvatakse iga kategooria- ja hindeelemendi keskmine väärtus.';
$string['showcalculations'] = 'Kuva arvutused';
$string['showcalculations_help'] = 'Kui see säte on lubatud, siis muutmisel kuvatakse iga hinnatava tegevuse ja kategooria juures kalkulaatoriikoon koos visuaalse näidikuga, et hinne on arvutatud.';
$string['showcontributiontocoursetotal'] = 'Kuva panus kursuse kogutulemusse';
$string['showcontributiontocoursetotal_help'] = 'Saate valida, kas kuvatakse protsendiveerg, kus on näidatud iga hindeelemendi panus kasutaja kursuse kogutulemusse protsentides (pärast hinde kaalumist).';
$string['showeyecons'] = 'Kuva kuvamise/peitmise ikoonid';
$string['showeyecons_help'] = 'Kui see säte on lubatud, kuvatakse muutmise sisselülitamisel iga hinde kohta kuvamise/peitmise ikoon, mis võimaldab kontrollida hinde nähtavust õppijale.';
$string['showfeedback'] = 'Kuva tagasiside';
$string['showfeedback_help'] = 'Saate määrata, kas tagasisideveerg kuvatakse.';
$string['showgrade'] = 'Kuva hinded';
$string['showgrade_help'] = 'Saate määrata, kas hinnete veerg kuvatakse.';
$string['showgroups'] = 'Kuva rühmad';
$string['showhiddenitems'] = 'Kuva peidetud üksused';
$string['showhiddenitems_help'] = 'Saate valida, kas peidetud hindeelemendid oleks täielikult peidetud või oleksid peidetud hindeelementide nimed õppijatele näha.

* Kuva peidetud – peidetud hindeelementide nimed kuvatakse, aga õppijate hinded on peidetud.
* Peidetud kuni – hindeelemendid on täielikult peidetud kuni määratud kuupäevani, pärast seda kuvatakse kogu üksus.
* Peidetud – peidetud hindeelemendid on täielikult peidetud';
$string['showhiddenuntilonly'] = 'Peidetud määratud ajani';
$string['showingaggregatesonly'] = 'Ainult koondhinnete kuvamine';
$string['showingfullmode'] = 'Täisvaate kuvamine';
$string['showinggradesonly'] = 'Ainult hinnete kuvamine';
$string['showlettergrade'] = 'Kuva tähelised hinded';
$string['showlettergrade_help'] = 'Saate määrata, kas tähelise hinde veerg kuvatakse.';
$string['showlocks'] = 'Kuva lukud';
$string['showlocks_help'] = 'Kui see säte on lubatud, kuvatakse muutmise sisselülitamisel iga hinde kohta lukustamise/avamise ikoon, mis võimaldab kontrollida, kas seotud tegevus saab hinnet automaatselt värskendada.';
$string['shownohidden'] = 'Ära kuva';
$string['shownooutcomes'] = 'Peida hinded';
$string['shownumberofgrades'] = 'Kuva keskmise arvutamiseks võetud hinnete arv';
$string['shownumberofgrades_help'] = 'Kui see säte on lubatud, siis kuvatakse iga keskmise hinde järel sulgudes selle arvutamiseks kasutatud hinnete arv.';
$string['showonlyactiveenrol'] = 'Kuva ainult aktiivsed kursusele registreerumised';
$string['showonlyactiveenrol_help'] = 'See säte määratleb, kas hinnetelehe aruandes on nähtavad ainult aktiivsed kursusele registreerunud kasutajad. Kui see säte on lubatud, ei kuvata hinnetelehel peatatud kontoga kasutajaid.';
$string['showpercentage'] = 'Kuva protsendid';
$string['showpercentage_help'] = 'Saate määrata, kas kuvatakse iga hindeelemendi protsendiline väärtus.';
$string['showquickfeedback'] = 'Kuva kiirtagasiside';
$string['showquickfeedback_help'] = 'Kui see säte on lubatud, kuvatakse muutmise sisselülitamisel iga hinde jaoks punktiirjoonega piiratud tagasisidesisestusväli, mis võimaldab muuta korraga mitme hinde tagasisidet. Muudatused salvestatakse ja tuuakse esile pärast värskendusnupu klõpsamist.

Pange tähele, et kui tagasisidet muudetakse hindajaaruandes, määratakse ülekirjutatuse lipp, mis tähendab seda, et seda tagasisidet ei saa enam seotud tegevuse käigus muuta.';
$string['showrange'] = 'Kuva vahemikud';
$string['showrange_help'] = 'Saate määrata, kas vahemiku veerg kuvatakse.';
$string['showranges'] = 'Kuva vahemikud';
$string['showranges_help'] = 'Kui see säte on lubatud, sisaldab hindajaaruanne lisarida, kus kuvatakse iga kategooria- ja hindeelemendi vahemik.';
$string['showrank'] = 'Kuva tulemus teistega võrreldes';
$string['showrank_help'] = 'Saate määrata, kas iga hinnatava tegevuse puhul kuvatakse õppija positsioon võrreldes ülejäänud klassiga.';
$string['showuserimage'] = 'Kuva kasutaja profiilipildid';
$string['showuserimage_help'] = 'Saate valida, kas hindajaaruandes kuvatakse kasutaja nime kõrval profiilipilt.';
$string['showverbose'] = 'Kuva kategooria {$a->category} mooduli {$a->itemmodule} üksus {$a->itemname}';
$string['showweight'] = 'Kuva kaalud';
$string['showweight_help'] = 'Saate määrata, kas hinde kaalu veerg kuvatakse.';
$string['simpleview'] = 'Õppija- või ülesandepõhine vaade';
$string['singleview'] = '{$a}: õppija- või ülesandepõhine vaade';
$string['sitewide'] = 'Õpikeskkonnaülene';
$string['sort'] = 'sordi';
$string['sortasc'] = 'Sordi kasvavalt';
$string['sortbyfirstname'] = 'Sordi eesnime järgi';
$string['sortbylastname'] = 'Sordi perekonnanime järgi';
$string['sortdesc'] = 'Sordi kahanevalt';
$string['standarddeviation'] = 'Standardhälve';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Õppija';
$string['studentsperpage'] = 'Õppijaid lehe kohta';
$string['studentsperpage_help'] = 'See säte määrab, mitu õppijat lehe kohta kuvatakse hindajaaruandes.';
$string['studentsperpagereduced'] = 'Õppijate maksimaalne arv lehe kohta on vähendatud väärtuselt {$a->originalstudentsperpage} väärtuseks {$a->studentsperpage}. Kaaluke PHP sätte max_input_vars suurendamist üksuses {$a->maxinputvars}.';
$string['subcategory'] = 'Tavakategooria';
$string['submissions'] = 'Esitatud tööd';
$string['submittedon'] = 'Esitatud: {$a}';
$string['sumofgradesupgradedgrades'] = 'Märkus. Koondtulemuse arvutamise viisi „Hinnete summa“ väärtus on õpikeskkonna uuendamise käigus muudetud väärtuseks „Loomulik“. Kuna varem kasutati sellel kursusel sätet „Hinnete summa“, on soovitatav see muudatus hinnetelehel läbi vaadata.';
$string['switchtofullview'] = 'Lülita täisvaatele';
$string['switchtosimpleview'] = 'Lülitu lithsale vaatele';
$string['tabs'] = 'Vahekaardid';
$string['topcategory'] = 'Ülemkategooria';
$string['total'] = 'Kokku';
$string['totalweight100'] = 'Kogukaal on 100';
$string['totalweightnot100'] = 'Kogukaal ei ole 100';
$string['turnfeedbackoff'] = 'Keera tagasiside sisse';
$string['turnfeedbackon'] = 'Keeta tagasiside välja';
$string['typenone'] = 'Pole';
$string['typescale'] = 'Skaala';
$string['typescale_help'] = 'See säte määrab hindetüübi Skaala kasutamisel kasutatava skaala. Tegevuspõhise hindeelemendi skaala saab määrata tegevusesätete lehel.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Väärtus';
$string['uncategorised'] = 'Kategooriata';
$string['unchangedgrade'] = 'Hinne on muutmata';
$string['unenrolledusersinimport'] = 'See import sisaldas järgmiste kasutajate hindeid, kes ei ole praegu kursusele registreeritud: {$a}';
$string['unlimitedgrades'] = 'Piiramatud hinded';
$string['unlimitedgrades_help'] = 'Vaikimisi on hinded piiratud hindeelemendi maksimum- ja miinimumväärtusega. Selle sätte lubamine eemaldab selle piirangu ja lubab hinded, mille väärtus on üle 100%, otse hinnetelehele kanda.';
$string['unlock'] = 'Ava lukust';
$string['unlockverbose'] = 'Ava lukust {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Kasutamata';
$string['updatedgradesonly'] = 'Ekspordi uued või värskendatud hinded';
$string['upgradedgradeshidemessage'] = 'Sule teatis';
$string['upgradedminmaxrevertmessage'] = 'Ennista muudatused';
$string['uploadgrades'] = 'Laadi hinded üles';
$string['useadvanced'] = 'Kasuta täpsemat seadistust';
$string['usedcourses'] = 'Kasutatud kursused';
$string['usedgradeitem'] = 'Kasutatud hindeelement';
$string['usenooutcome'] = 'Ära kasuta tulemusi';
$string['usenoscale'] = 'Ära kasuta skaalat';
$string['usepercent'] = 'Kasuta protsenti';
$string['user'] = 'Kasutaja';
$string['userenrolmentsuspended'] = 'Kasutaja registreerumine katkestatud';
$string['userfields_show'] = 'Kuva kasutajaandmete väljad';
$string['userfields_show_help'] = 'Saate kuvada kasutajaandmete lisaväljad, nagu meiliaadressi või hindajaaruande. Konkreetseid kuvatavaid välju saab hallata õpikeskkonna sätte showuseridentity kaudu';
$string['usergrade'] = 'Kasutaja {$a->fullname} ({$a->useridnumber}) üksuses {$a->gradeidnumber}';
$string['userid'] = 'Kasutaja ID';
$string['useridnumberwarning'] = 'Ilma ID-numbrita kasutajad välistatakse ekspordist, kuna neid ei saa importida';
$string['usermappingerror'] = 'Kasutaja vastendamise tõrge: Kasutajat välja {$a->field} väärtusega „{$a->value}“ ei leitud.';
$string['usermappingerrorcurrentgroup'] = 'Kasutaja pole praeguse rühma liige.';
$string['usermappingerrormultipleusersfound'] = 'Kasutaja kaardistamise viga: leitud mitu kasutajat, kelle {$a->value} all on väli {$a->field}. Kasuta unikaalsemat kaardistamisvälja.';
$string['usermappingerrorusernotfound'] = 'Kasutaja vastendamise tõrge. Kasutajat ei leitud.';
$string['userpreferences'] = 'Kasutajaeelistused';
$string['useweighted'] = 'Kasuta kaalusid';
$string['verbosescales'] = 'Laiendatud skaalad';
$string['verbosescales_help'] = 'Laiendatud skaala kasutab numbrite asemel sõnu. Kui soovite importida nii arvulised kui ka laiendatud skaalad, määrake sätteks „Jah“. Kui soovite importida ainult arvulised skaalad, määrake sätteks „Ei“.';
$string['viewbygroup'] = 'Rühm';
$string['viewgrades'] = 'Vaata hindeid';
$string['weight'] = 'Kaal';
$string['weight_help'] = 'Väärtus, mida kasutatakse mitme hindeelemendi suhtelise väärtuse määratlemiseks kategoorias või kursusel.';
$string['weightcourse'] = 'Kasuta kursusel kaalutud keskmist hinnet';
$string['weightedascending'] = 'Sorteeri kaalutud protsendi järgi kasvavalt';
$string['weighteddescending'] = 'Sorteeri kaalutud protsendi järgi kahanevalt';
$string['weightedpct'] = 'kaalutud %';
$string['weightedpctcontribution'] = 'kaalutud % toetus';
$string['weightofa'] = 'Hinde {$a} kaal';
$string['weightorextracredit'] = 'Kaal või lisaväärtus';
$string['weightoverride'] = 'tulemuse kaalu korrigeerimine';
$string['weightoverride_help'] = 'Hindeelemendi kaalu lähtestamiseks automaatselt arvutatud väärtusele eemaldage see märge. Selle ruudu märkimine takistab kaalu automaatset korrigeerimist.';
$string['weights'] = 'Kaal';
$string['weightsadjusted'] = 'Teie kaalud on korrigeeritud kogusummaks 100.';
$string['weightsedit'] = 'Muuda kaalu või lisaväärtust';
$string['weightuc'] = 'Arvutatud kaal';
$string['writinggradebookinfo'] = 'Hinnetelehe sätete kirjutamine';
$string['xml'] = 'XML';
$string['yes'] = 'Jah';
$string['yourgrade'] = 'Sinu hinne';
