<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'ar', version '3.11'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'التقييمات تغلق:';
$string['activitydate:assessmentsclosed'] = 'التقييمات أغلقت:';
$string['activitydate:assessmentsopen'] = 'التقييمات تفتح:';
$string['activitydate:assessmentsopened'] = 'التقييمات فتحت:';
$string['activitydate:submissionsclose'] = 'التسليمات تغلق:';
$string['activitydate:submissionsclosed'] = 'التسليمات أغلقت:';
$string['activitydate:submissionsopen'] = 'التسليمات تفتح:';
$string['activitydate:submissionsopened'] = 'التسليمات فتحت:';
$string['aggregategrades'] = 'إعادة إحتساب التقديرات';
$string['aggregation'] = 'إجمالي التقديرات';
$string['allocate'] = 'وزِّع التسليمات';
$string['allocatedetails'] = 'متوقع: {$a->expected}<br />مسلَّم: {$a->submitted}<br />ليوزَّع: {$a->allocate}';
$string['allocation'] = 'توزيع التسليم';
$string['allocationconfigured'] = 'تم توزيع التسليم';
$string['allocationdone'] = 'تم التوزيع';
$string['allocationerror'] = 'خطأ في التوزيع';
$string['allowedfiletypesforoverallfeedback'] = 'أنواع ملفات مرفقات الإفادة المسموح بها';
$string['allowedfiletypesforoverallfeedback_help'] = 'يمكن تقييد أنواع ملفات مرفقات الإفادة عبر تقديم قائمة بالأنواع المسموح بها. إذا تم ترك الحقل فارغاً، فعندها كل أنواع الملفات مسموح بها.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'أنواع ملفات مرفقات التسليم المسموح بها';
$string['allowedfiletypesforsubmission_help'] = 'يمكن تقييد أنواع ملفات مرفقات التسليم عبر تقديم قائمة بالأنواع المسموح بها. إذا تم ترك الحقل فارغاً، فعندها كل أنواع الملفات مسموح بها.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'جميع التسليمات ({$a})';
$string['alreadygraded'] = 'مقيَّم سلفاً';
$string['areaconclusion'] = 'نص الاستنتاج';
$string['areainstructauthors'] = 'تعليمات التسليم';
$string['areainstructreviewers'] = 'تعليمات التقييم';
$string['areaoverallfeedbackattachment'] = 'مرفقات الإفادة الشاملة';
$string['areaoverallfeedbackcontent'] = 'نصوص الإفادة الشاملة';
$string['areasubmissionattachment'] = 'مرفقات التسليم';
$string['areasubmissioncontent'] = 'نصوص التسليم';
$string['assess'] = 'قيِّم';
$string['assessedexample'] = 'التسليم النموذجي المُقيَّم';
$string['assessedsubmission'] = 'التسليم المُقيَّم';
$string['assessingexample'] = 'يجري تقييم التسليم النموذجي';
$string['assessingsubmission'] = 'يجري تقييم التسليم';
$string['assessment'] = 'تقييم';
$string['assessmentby'] = 'بواسطة <a href="{$a->url}">{$a->name}</a>';
$string['assessmentbyfullname'] = 'التقييم من قِبل {$a}';
$string['assessmentbyyourself'] = 'تقييمك';
$string['assessmentdeleted'] = 'أُلغيَ توزيع التقييم';
$string['assessmentend'] = 'الموعد النهائي للتقييم';
$string['assessmentendbeforestart'] = 'لا يمكن جعل الموعد النهائي للتقييم قبل تاريخ فتحه';
$string['assessmentenddatetime'] = 'الموعد النهائي للتقييم: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} الموعد النهائي للتقييم';
$string['assessmentform'] = 'نموذج التقييم';
$string['assessmentofsubmission'] = '<a href="{$a->assessmenturl}">تقييم</a> <a href="{$a->submissionurl}">{$a->submissiontitle}</a>';
$string['assessmentreference'] = 'التقييم المرجعي';
$string['assessmentreferenceconflict'] = 'من غير الممكن تقييم التسليم النموذجي الذي أعطيتَ له تقييماً مرجعياً.';
$string['assessmentreferenceneeded'] = 'عليك تقييم التسليم النموذجي هذا لتعطي تقييماً مرجعياً. أنقر زر \'استمر\' لتقييم التسليم.';
$string['assessments'] = 'التقييمات';
$string['assessmentsettings'] = 'إعدادات التقييم';
$string['assessmentstart'] = 'إفتح التقييم من';
$string['assessmentstartdatetime'] = 'إفتح التقييم من {$a->daydatetime} ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} يُفتح للتقييم من';
$string['assessmentweight'] = 'وزن التقييم';
$string['assignedassessments'] = 'التسليمات المعينة لغرض تقييمات';
$string['assignedassessmentsnone'] = 'ليست هناك تسليمات معينة لك لتقييمها';
$string['backtoeditform'] = 'عودة إلى نموذج التحرير';
$string['byfullname'] = 'من قِبَل <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'من قِبَل {$a}';
$string['calculategradinggrades'] = 'إحسب تقديرات التقييم';
$string['calculategradinggradesdetails'] = 'المتوقعة: {$a->expected}<br />المحتسبة: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'إحسب تقديرات التسليم';
$string['calculatesubmissiongradesdetails'] = 'المتوقعة: {$a->expected}<br />المحتسبة: {$a->calculated}';
$string['chooseuser'] = 'إختر المستخدم...';
$string['clearaggregatedgrades'] = 'إخلاء كل التقديرات المجمعة';
$string['clearaggregatedgrades_help'] = 'ستتم إعادة تعيين الدرجات المجمعة للتسليمات والدرجات للتقييم. يمكنك إعادة حساب هذه التقديرات من البداية في مرحلة تقييم الدرجات مرة أخرى.';
$string['clearaggregatedgradesconfirm'] = 'هل أنت متأكد من أنك تريد مسح التقديرات المحسوبة للتسليمات والدرجات للتقييم؟';
$string['clearassessments'] = 'إخلاء التقييمات';
$string['clearassessments_help'] = 'سيتم إعادة تعيين الدرجات المحتسبة للتسليمات ودرجات التقييمات. المعلومات المتعلقة بكيفية ملء نماذج التقييم بقيت على حالها، ولكن على جميع المقيمين فتح نموذج التقييم مجدداً وإعادة حفظه للحصول على التقديرات المحددة مرة أخرى.';
$string['clearassessmentsconfirm'] = 'هل أنت متأكد من رغبتك في إخلاء كل تقديرات التقييم؟ لن تتمكن بنفسك من إعادة تلك المعلومات مجددًا، وعلى المقيمين إعادة تقييم التسليمات المعينة';
$string['conclusion'] = 'الاستنتاج';
$string['conclusion_help'] = 'يتم عرض نص الاستنتاج إلى المشاركين عند انتهاء النشاط.';
$string['configexamplesmode'] = 'النمط الافتراضي لتقييم الأمثلة في ورش العمل';
$string['configgrade'] = 'العلامة العظمى الافتراضية للتسليم في ورش العمل';
$string['configgradedecimals'] = 'أقصى عدد من المراتب التي ينبغي إظهارها بعد الفارزة العشرية عند عرض الدرجات.';
$string['configgradinggrade'] = 'العلامة العظمى الافتراضية للتقييم في ورش العمل';
$string['configmaxbytes'] = 'أقصى حجم ملف إفتراضياً للتسليم في كل ورش العمل في الموقع (عرضة لحدوده في المقرر الدراسي وغيره من الإعدادات المحلية)';
$string['configstrategy'] = 'استراتيجية الدرجات الافتراضية لورش العمل';
$string['createsubmission'] = 'أضف تسليماً';
$string['crontask'] = 'المعالجة الخلفية لوحدة ورشة العمل';
$string['daysago'] = '{$a} يوماً مضت';
$string['daysleft'] = '{$a} يوماً بقيت';
$string['daystoday'] = 'هذا اليوم';
$string['daystomorrow'] = 'غداً';
$string['daysyesterday'] = 'البارحة';
$string['deadlinesignored'] = 'تقييدات الوقت لا تنطبق عليك';
$string['deletesubmission'] = 'إحذف التسليم';
$string['editassessmentform'] = 'تحرير نموذج التقييم';
$string['editassessmentformstrategy'] = 'تحرير نموذج التقييم ({$a})';
$string['editingassessmentform'] = 'يجري تحرير نموذج التقييم';
$string['editingsubmission'] = 'يجري تحرير التسليم';
$string['editsubmission'] = 'تحرير التسليم';
$string['err_multiplesubmissions'] = 'في أثناء تحرير هذا النموذج، تم حفظ نسخة أخرى من التسليم. التسليمات المتعددة من قبل المستخدم غير مسموح بها.';
$string['err_removegrademappings'] = 'تعذرت إزالة تعيينات العلامة غير المستعملة';
$string['evaluategradeswait'] = 'لطفاً، إنتظر ريثما يتم تقييم التقييمات واحتساب الدرجات';
$string['evaluation'] = 'تقييم منح العلامة';
$string['evaluationmethod'] = 'طريقة تقييم منح العلامة';
$string['evaluationmethod_help'] = 'تحدد طريقة تقييم الدرجات كيفية حساب التقدير. يمكنك السماح لها بإعادة حساب التقديرات بشكل متكرر باستخدام إعدادات مختلفة ما لم تكن راضيًا عن النتيجة.';
$string['evaluationsettings'] = 'إعدادات تقييم الدرجات';
$string['eventassessableuploaded'] = 'تسليم تم رفعه';
$string['eventassessmentevaluated'] = 'تقييم تم تقييمه';
$string['eventassessmentevaluationsreset'] = 'تقييمات تقييم تمت إعادة تعيينها';
$string['eventassessmentreevaluated'] = 'تقييم تمت إعادة تقييمه';
$string['eventphaseautomaticallyswitched'] = 'طور تم تبديله تلقائيًا';
$string['eventphaseswitched'] = 'طور تم تحويله';
$string['eventsubmissionassessed'] = 'تسليم تم تقييمه';
$string['eventsubmissionassessmentsreset'] = 'تقييمات تسليم تم إخلاؤها';
$string['eventsubmissioncreated'] = 'تسليم تم إنشاؤه';
$string['eventsubmissiondeleted'] = 'تسليم تم حذفه';
$string['eventsubmissionreassessed'] = 'تسليم تمت إعادة تقييمه';
$string['eventsubmissionupdated'] = 'تسليم تم تحديثه';
$string['eventsubmissionviewed'] = 'تسليم تمت معاينته';
$string['example'] = 'التسليم النموذجي';
$string['exampleadd'] = 'أضف تسليماً نموذجياً';
$string['exampleassess'] = 'قيِّم التسليم النموذجي';
$string['exampleassessments'] = 'التسليمات النموذجية المطلوب تقييمها';
$string['exampleassesstask'] = 'قيِّم النماذج';
$string['exampleassesstaskdetails'] = 'المتوقع: {$a->expected}<br />المقيَّم: {$a->assessed}';
$string['examplecomparing'] = 'قارن تقييمات التسليم النموذجي';
$string['exampledelete'] = 'إحذف النموذج';
$string['exampledeleteconfirm'] = 'هل أنت متأكد من رغبتك في حذف التسليم النموذجي الآتي؟ أنقر زر \'استمر\' لحذف التسليم.';
$string['exampleedit'] = 'تحرير النموذج';
$string['exampleediting'] = 'يجري تحرير النموذج';
$string['exampleneedassessed'] = 'عليك أولاً تقييم كل التسليمات النموذجية';
$string['exampleneedsubmission'] = 'عليك أولاً تسليم عملك وتقييم كل التسليمات النموذجية';
$string['examplesbeforeassessment'] = 'النماذج تتاح للمرء بعد تسليمه وينبغي تقييمها قبل التقييم المناظر';
$string['examplesbeforesubmission'] = 'ينبغي تقييم النماذج قبل قيام المرء بالتسليم';
$string['examplesmode'] = 'نمط تقييم النماذج';
$string['examplesubmissions'] = 'تسليمات النموذج';
$string['examplesvoluntary'] = 'تقييم التسليم النموذجي أمر طوعي';
$string['exportsubmission'] = 'تصدير هذه الصفحة';
$string['feedbackauthor'] = 'إفادة موجهة إلى الكاتب';
$string['feedbackauthorattachment'] = 'المرفق';
$string['feedbackby'] = 'إفادة {$a}';
$string['feedbackreviewer'] = 'إفادة موجهة إلى المقيِّم';
$string['feedbacksettings'] = 'الإفادة';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'الدرجات المعطاة';
$string['grade_grading_name'] = 'التقييم';
$string['grade_submission_name'] = 'التسليم';
$string['gradecalculated'] = 'العلامة المحتسبة للتسليم';
$string['gradedecimals'] = 'المنازل العشرية في الدرجات';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'الدرجة: {$a->received} من {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (التقييم)';
$string['gradeitemsubmission'] = '{$a->workshopname} (التسليم)';
$string['gradeover'] = 'تجاوز العلامة للتسليم';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'تقرير تقديرات ورشة العمل';
$string['gradetopassgrading'] = 'درجة النجاح للتسليم';
$string['gradetopasssubmission'] = 'درجة النجاح للتقييم';
$string['gradinggrade'] = 'الدرجة على التقييم';
$string['gradinggrade_help'] = 'هذا الإعداد يحدد الدرجة العظمى التي يمكن إحرازها لتقييم التسليم.';
$string['gradinggradecalculated'] = 'العلامة المحتسبة للتقييم';
$string['gradinggradeof'] = 'علامة التقييم (من {$a})';
$string['gradinggradeover'] = 'تجاوز العلامة للتقييم';
$string['gradingsettings'] = 'إعدادات منح العلامة';
$string['groupnoallowed'] = 'ليس مسموحاً لك بالوصول إلى أي مجموعة في ورشة العمل هذه';
$string['iamsure'] = 'نعم، أنا متأكد';
$string['indicator:cognitivedepth'] = 'ورشة العمل معرفياً';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط ورشة العمل.';
$string['indicator:cognitivedepthdef'] = 'ورشة العمل معرفياً';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات ورشة العمل خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم، معاينة الرد، التعليق على الرد، إعادة التقديم بعد معاينة الرد)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ورشة العمل إجتماعياً';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط ورشة العمل.';
$string['indicator:socialbreadthdef'] = 'ورشة العمل إجتماعياً';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات ورشة العمل خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً، المشاركة مع الآخرين)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'المعلومة';
$string['instructauthors'] = 'تعليمات التسليم';
$string['instructreviewers'] = 'تعليمات التقييم';
$string['introduction'] = 'الوصف';
$string['latesubmissions'] = 'التسليمات المتأخرة';
$string['latesubmissions_desc'] = 'إسمح بالتسليمات بعد الموعد النهائي';
$string['latesubmissions_help'] = 'عند تمكينه، يمكن للكاتب تسليم عمله بعد الموعد النهائي للتسليم أو خلال طور التقييم. مع ذلك، التسليمات المتأخرة لا يمكن تحريرها.';
$string['latesubmissionsallowed'] = 'التسليمات المتأخرة مسموح بها';
$string['legacyallocationplugincron'] = 'التعيين السابق لمشغل الوظائف الدورية لورشة العمل';
$string['maxbytes'] = 'أقصى حجم لمرفقات التسليم';
$string['modulename'] = 'ورشة عمل';
$string['modulename_help'] = 'وحدة نشاط ورشة العمل تُمكِّن تجميع، مراجعة وتقييم أعمال الطلاب تقييماً مناظراً.

يمكن للطلبة تسليم أي محتوى رقمي (ملفات)، مثل مستندات معالج النصوص Word أو الجداول، كما يمكنهم أيضاً الطباعة مباشرة في حقل مخصص باستعمال محرر النصوص.

يتم تقييم التسليمات باستعمال نموذج تقييم متعدد المعايير يُعرَّف من قبل المعلم. عملية التقييم المناظر وفهم نموذج التقييم يمكن التمرن عليها مقدماً بواسطة تسليمات نموذجية مقدمة من قبل المعلم يصاحبها تقييم مرجعي. الطلبة تعطى لهم فرصة تقييم واحد أو أكثر من تسليمات نظرائهم. يمكن إخفاء هويات أصحاب التسليمات وكذلك التقييمات إن تطلب الأمر.

يحصل الطلبة على علامتين في نشاط ورشة العمل - علامة على تسليمهم وعلامة أخرى على تقييمهم لتسليمات نظرائهم. العلامتان كلاهما تسجلان في سجل التقديرات.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'ورش عمل';
$string['myassessments'] = 'تقييماتي';
$string['mysubmission'] = 'تسليمي';
$string['nattachments'] = 'العدد الأقصى من مرفقات التسليم';
$string['noexamples'] = 'لا نماذج بعد في ورشة العمل هذه';
$string['noexamplesformready'] = 'ينبغي عليك تعريف نموذج التقييم قبل تقديم تسليمات نموذجية';
$string['nogradeyet'] = 'لا علامة بعد';
$string['nosubmissionfound'] = 'لا تسليم لهذا المستخدم';
$string['nosubmissions'] = 'لا تسليمات بعد في ورشة العمل هذه';
$string['nosubmissiontype'] = 'ينبغي توافر نوع تسليم واحد على الأقل';
$string['notassessed'] = 'غير مقيَّم بعد';
$string['nothingfound'] = 'لا شيء لعرضه';
$string['nothingtoreview'] = 'لا شيء لمراجعته';
$string['notoverridden'] = 'غير متجاوز';
$string['noworkshops'] = 'لا توجد ورش عمل في هذا المقرر الدراسي';
$string['noyoursubmission'] = 'لم تقم بتسليم عملك بعد';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'الإفادة الشاملة';
$string['overallfeedbackfiles'] = 'العدد الأقصى لمرفقات الإفادة الشاملة';
$string['overallfeedbackmaxbytes'] = 'أقصى حجم لمرفق الإفادة الشاملة';
$string['overallfeedbackmode'] = 'نمط الإفادة الشاملة';
$string['overallfeedbackmode_0'] = 'مُعطَلة';
$string['overallfeedbackmode_1'] = 'مُمَكَّنة واختيارية';
$string['overallfeedbackmode_2'] = 'مُمَكَّنة وإجبارية';
$string['overallfeedbackmode_help'] = 'عند تمكينها، سيظهر حقل نص أسفل نموذج التقييم. يمكن للمقيمين وضع إفادتهم الشاملة بشأن التسليم هناك، أو تقديم توضيح إضافي عن تقييمهم.';
$string['page-mod-workshop-x'] = 'أي صفحة لوحدة ورشة العمل';
$string['participant'] = 'المشارك';
$string['participantrevierof'] = 'المشارك هو مقيِّم لـ';
$string['participantreviewedby'] = 'المشارك مقيَّم من قبل';
$string['phaseassessment'] = 'طور التقييم';
$string['phaseclosed'] = 'مغلق';
$string['phaseevaluation'] = 'مرحلة تقييم الدرجات';
$string['phasesetup'] = 'طور الإعداد';
$string['phasesoverlap'] = 'طورا التسليم والتقييم لا يمكن لهما أن يتداخلا';
$string['phasesubmission'] = 'طور التسليم';
$string['pluginadministration'] = 'إدارة ورشة العمل';
$string['pluginname'] = 'ورشة العمل';
$string['prepareexamples'] = 'تحضير تسليمات النماذج';
$string['previewassessmentform'] = 'استعراض';
$string['privacy:metadata:aggregatedgradinggrade'] = 'العلامة المجمعة لكل التقييمات التي قام بها المستخدم في ورشة العمل المعطاة';
$string['privacy:metadata:assessmentgrade'] = 'العلامة المجمعة للتسليم المقترح من قبل هذا التقييم';
$string['privacy:metadata:assessmentgradinggrade'] = 'العلامة الممنوحة على تقديم هذا التقييم';
$string['privacy:metadata:assessmentgradinggradeover'] = 'القيمة المتجاوزة يدوياً للعلامة الممنوحة لتقديم هذا التقييم';
$string['privacy:metadata:assessmentid'] = 'مُعرَّف التقييم';
$string['privacy:metadata:authorid'] = 'مُعرَّف كاتب التسليم';
$string['privacy:metadata:dimensiongrade'] = 'العلامة في بُعد التقييم المعطى';
$string['privacy:metadata:dimensionid'] = 'مُعرَّف بُعد التقييم';
$string['privacy:metadata:example'] = 'فيما إذا كان هذا السجل يمثل تسليماً نموذجياً';
$string['privacy:metadata:feedbackauthor'] = 'إفادة موجهة إلى الكاتب';
$string['privacy:metadata:feedbackauthorformat'] = 'تنسيق النص للإفادة الموجهة للكاتب';
$string['privacy:metadata:feedbackreviewer'] = 'الإفادة الموجهة للمستخدم المقدم للتقييم';
$string['privacy:metadata:feedbackreviewerformat'] = 'تنسيق النص للإفادة الموجهة للمستخدم المقدم للتقييم';
$string['privacy:metadata:late'] = 'فيما إذا كان التسليم حاصلاً بعد الموعد النهائي';
$string['privacy:metadata:peercomment'] = 'التعليق على العلامة المعطاة من قبل المستخدم المقدم للتقييم';
$string['privacy:metadata:peercommentformat'] = 'تنسيق النص للتعليق على العلامة المعطاة';
$string['privacy:metadata:preference:perpage'] = 'عدد التسليمات التي يفضل المستخدم مشاهدتها في صفحة واحدة';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'حالة الطي/التوسع لمنظر \'التسليمات النموذجية\'';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'حالة الطي/التوسع لمنظر \'تقرير تسليمات ورشة العمل\'';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'حالة الطي/التوسع لمنظر \'نموذج التقييم\'';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'حالة الطي/التوسع لمنظر \'التسليمات الموزعة لغرض التقييم\'';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'حالة الطي/التوسع لمنظر \'شريط أدوات ورشة العمل\'';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'حالة الطي/التوسع لمنظر \'الاستنتاج\'';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'حالة الطي/التوسع لمنظر \'التسليمات النموذجية لغرض التقييم\'';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'حالة الطي/التوسع لمنظر \'التسليمات النموذجية لغرض التقييم\'';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'حالة الطي/التوسع لمنظر \'تقرير تقديرات ورشة العمل\'';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'حالة الطي/التوسع لمنظر \'تعليمات التسليم\'';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'حالة الطي/التوسع لمنظر \'تعليمات التقييم\'';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'حالة الطي/التوسع لمنظر \'المقدمة\'';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'حالة الطي/التوسع لمنظر \'الإفادة الشاملة\'';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'حالة الطي/التوسع لمنظر \'تسليمك\'';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'حالة الطي/التوسع لمنظر \'التسليمات المنشورة\'';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'حالة الطي/التوسع لمنظر \'تقديراتك\'';
$string['privacy:metadata:published'] = 'فيما إذا كان ينبغي نشر التسليم إلى كل المشاركين بمجرد إغلاق ورشة العمل';
$string['privacy:metadata:reviewerid'] = 'مُعرَّف المستخدم المقدم للتقييم';
$string['privacy:metadata:strategy'] = 'اسم الإضافة الفرعية لاستراتيجية التقدير الذي يقوم بتفسير قيم السجل';
$string['privacy:metadata:submissioncontent'] = 'محتوى التسليم';
$string['privacy:metadata:submissioncontentformat'] = 'تنسيق النص لمحتوى التسليم';
$string['privacy:metadata:submissiongrade'] = 'العلامة المجمعة للتسليم مكتوبة برقم عشري من المدى 0..100';
$string['privacy:metadata:submissiongradeover'] = 'القيمة المتجاوزة يدوياً للعلامة المجمعة';
$string['privacy:metadata:submissionid'] = 'مُعرَّف التسليم';
$string['privacy:metadata:submissiontitle'] = 'عنوان التسليم';
$string['privacy:metadata:subsystem:corefiles'] = 'وحدة ورشة العمل تخزن الملفات المضمنة وتجعلها مرفقة بنص التسليم';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'تمتلك وحدة ورشة العمل نظام داخلي يدعم أنظمة منع السرقة الفكرية';
$string['privacy:metadata:timeaggregated'] = 'وقت آخر احتساب للعلامة المجمعة';
$string['privacy:metadata:timecreated'] = 'وقت إنشاء هذا السجل في قاعدة البيانات';
$string['privacy:metadata:timemodified'] = 'وقت آخر تعديل هذا السجل في قاعدة البيانات';
$string['privacy:metadata:userid'] = 'مُعرَّف المستخدم المحتسبة له العلامة المجمعة';
$string['privacy:metadata:weight'] = 'وزن التقييم';
$string['privacy:metadata:workshopaggregations'] = 'تحتفظ بالدرجات المجمعة للتقييم';
$string['privacy:metadata:workshopassessments'] = 'يحمل معلومات عن التقييمات الموزعة لتسليمات وحدة ورشة العمل';
$string['privacy:metadata:workshopgrades'] = 'يحمل معلومات عن الكيفية التي تم بها ملء نماذج التقييم بالدرجات والتعليقات';
$string['privacy:metadata:workshopid'] = 'مُعرَّف نشاط ورشة العمل';
$string['privacy:metadata:workshopsubmissions'] = 'يحمل معلومات عن تسليمات وحدة ورشة العمل';
$string['privacy:request:delete:content'] = 'تم حذف المحتوى (بطلب المستخدم أو انتهاء صلاحيته)';
$string['privacy:request:delete:title'] = '[محذوف]';
$string['publishedsubmissions'] = 'التسليمات المنشورة';
$string['publishsubmission'] = 'أنشر التسليمات';
$string['publishsubmission_help'] = 'التسليمات المنشورة متاحة للآخرين عند إغلاق ورشة العمل.';
$string['reassess'] = 'أعد التقييم';
$string['receivedgrades'] = 'تم استلام الدرجات';
$string['recentassessments'] = 'تقييمات ورشة العمل:';
$string['recentsubmissions'] = 'تسليمات ورشة العمل:';
$string['resetassessments'] = 'حذف كل التقييمات';
$string['resetassessments_help'] = 'يمكن اختيار حذف التقييمات الموزعة فقط دون التأثير على التسليمات. إذا كان بالنية حذف التسليمات، فتقييماتها سيتم حذفها ضمنياً وهذا الخيار سيتم تجاهله. لاحظ أن ذلك يشمل أيضاً تقييمات التسليمات النموذجية.';
$string['resetphase'] = 'التبديل إلى طور الإعداد';
$string['resetphase_help'] = 'عند تمكينه، فكل ورش العمل سيتم وضعها في طور الإعداد الأولي.';
$string['resetsubmissions'] = 'حذف كل التسليمات';
$string['resetsubmissions_help'] = 'كل التسليمات وتقييماتها سيتم حذفها. هذا لا يؤثر على التسليمات النموذجية.';
$string['saveandclose'] = 'حفظ وإغلاق';
$string['saveandcontinue'] = 'حفظ ومتابعة التحرير';
$string['saveandpreview'] = 'حفظ واستعراض';
$string['saveandshownext'] = 'إحفظ وأظهر التالي';
$string['search:activity'] = 'ورشة العمل - معلومات النشاط';
$string['selfassessmentdisabled'] = 'تم تعطيل التقييم الذاتي';
$string['showingperpage'] = 'إظهار {$a} من العناصر لكل صفحة';
$string['showingperpagechange'] = 'غيِّر ...';
$string['someuserswosubmission'] = 'هناك كاتب واحد على الأقل لم يسلم عمله بعد';
$string['sortasc'] = 'فرز تصاعدي';
$string['sortdesc'] = 'فرز تنازلي';
$string['strategy'] = 'استراتيجية منح العلامة';
$string['strategy_help'] = 'تحدد استراتيجية الدرجات نموذج التقييم المستخدم وطريقة تقدير التقديمات. هناك 4 خيارات:

* التقدير التراكمي - يتم إعطاء التعليقات والدرجات فيما يتعلق بجوانب محددة
* التعليقات - يتم إعطاء التعليقات فيما يتعلق بجوانب محددة ولكن لا يمكن إعطاء أي درجة
* عدد الأخطاء - يتم تقديم التعليقات وتقييم نعم / لا بخصوص تأكيدات محددة
* سلم التقييم - التقييم على أساس المستويات، يعطى وفقاً لمعايير معينة';
$string['strategyhaschanged'] = 'استراتيجية منح العلامة في ورشة العمل قد تغيرت منذ فتح النموذج للتحرير.';
$string['submission'] = 'التسليم';
$string['submissionattachment'] = 'المرفق';
$string['submissionby'] = 'التسليم من قِبل {$a}';
$string['submissioncontent'] = 'محتوى التسليم';
$string['submissiondeleteconfirm'] = 'هل أنت متأكد من رغبتك في حذف التسليم الآتي؟';
$string['submissiondeleteconfirmassess'] = 'هل أنت متأكد من رغبتك في حذف التسليم الآتي؟ لاحظ أن ذلك سيحذف أيضاً تقييمات {$a->count} المتعلقة بهذا التسليم، مما قد يؤثر على تقديرات المقيمين.';
$string['submissionend'] = 'الموعد النهائي للتسليمات';
$string['submissionendbeforestart'] = 'لا يمكن جعل الموعد النهائي للتسليمات قبل تاريخ فتحها';
$string['submissionenddatetime'] = 'الموعد النهائي للتسليمات: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} الموعد النهائي للتسليمات';
$string['submissionendswitch'] = 'تحول إلى الطور التالي بعد الموعد النهائي للتسليمات';
$string['submissionendswitch_help'] = 'إذا تم تحديد الموعد النهائي للتسليمات وهذه الخانة مؤشرة، ستقوم ورسة العمل تلقائياً بالانتقال إلى طور التقييم بعد الموعد النهائي للتسليمات.

إذا قمت بتمكين هذه الميزة، من الموصى به أن تقوم بتهيئة طريقة التوزيع المجدول أيضاً. إذا لم يتم توزيع التسليمات، لا يمكن إجراء أي تقييمات حتى وإن كانت ورشة العمل نفسها في طور التقييم.';
$string['submissiongrade'] = 'علامة التسليم';
$string['submissiongrade_help'] = 'هذا الإعداد يحدد العلامة العظمى التي يمكن إحرازها للعمل المسلم.';
$string['submissiongradeof'] = 'علامة التسليم (من {$a})';
$string['submissionlastmodified'] = 'آخر تعديل';
$string['submissionrequiredcontent'] = 'عليك إدخال نص ما أو إضافة ملف.';
$string['submissionrequiredfile'] = 'عليك إضافة ملف أو إدخال نص ما.';
$string['submissionsettings'] = 'إعدادات التسليم';
$string['submissionsreport'] = 'تقرير تسليمات ورشة العمل';
$string['submissionstart'] = 'قبول التسليمات بدءاً من';
$string['submissionstartdatetime'] = '{$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} يُفتح للتسليمات';
$string['submissiontitle'] = 'العنوان';
$string['submissiontypedisabled'] = 'نوع التسليم هذا معطل في ورشة العمل هذه.';
$string['submissiontypefileavailable'] = 'ملف مرفق<span class="accesshide"> متاح</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">ملف مرفق </span>مطلوب';
$string['submissiontypes'] = 'أنواع التسليم';
$string['submissiontypetextavailable'] = 'نص عبر الإنترنت<span class="accesshide"> متاح</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">نص عبر الإنترنت </span>مطلوب';
$string['submittednotsubmitted'] = 'مُسَلَّم ({$a->submitted}) / غير مُسَلَّم ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'طريقة توزيع التسليمات';
$string['subplugintype_workshopallocation_plural'] = 'طرق توزيع التسليمات';
$string['subplugintype_workshopeval'] = 'طريقة تقييم الدرجات';
$string['subplugintype_workshopeval_plural'] = 'طرق تقييم الدرجات';
$string['subplugintype_workshopform'] = 'استراتيجية الدرجات';
$string['subplugintype_workshopform_plural'] = 'استراتيجيات الدرجات';
$string['switchingphase'] = 'يجري تبديل الطور';
$string['switchphase'] = 'تبديل الطور';
$string['switchphase10'] = 'الإعداد';
$string['switchphase10info'] = 'أنت على وشك تحويل ورشة العمل إلى <strong>مرحلة الإعداد</strong>. في هذه المرحلة، لا يمكن للمستخدمين تعديل تسليماتهم أو تقييماتهم. قد يستعمل المعلمون هذا الطور لتغيير إعدادات ورشة العمل، تعديل استراتيجية الدرجات أو يحسنون نماذج التقييم.';
$string['switchphase20'] = 'تحول إلى طور التسليم';
$string['switchphase20info'] = 'أنت على وشك تحويل ورشة العمل إلى <strong>طور التسليم</strong>. يمكن للطلبة تسليم أعمالهم في هذا الطور (ضمن تواريخ التحكم بالتسليم، إن أوجدت). قد يقوم المعلمون بتوزيع التسليمات من أجل التقييم المناظر.';
$string['switchphase30'] = 'تحول إلى طور التقييم';
$string['switchphase30auto'] = 'ستتحول ورشة العمل تلقائياً إلى طور التقييم بعد {$a->daydatetime} ({$a->distanceday})';
$string['switchphase30info'] = 'أنت على وشك تحويل ورشة العمل إلى <strong>طور التقييم</strong>. في هذا الطور، قد يقوم المقيمون بتقييم التسليمات التي وُزِّعت عليهم (ضمن تواريخ التحكم بالتقييمات، إن أوجدت).';
$string['switchphase40'] = 'انتقل إلى مرحلة التقييم';
$string['switchphase40info'] = 'أنت على وشك تحويل ورشة العمل إلى <strong>مرحلة تقييم الدرجات </strong>. في هذه المرحلة، لا يمكن للمستخدمين تعديل عمليات الإرسال أو تقييماتهم. يمكن للمعلمين استعمال أدوات تقييم الدرجات لحساب التقديرات النهائية وتقديم الإفادة للمراجعين.';
$string['switchphase50'] = 'أغلق ورشة العمل';
$string['switchphase50info'] = 'أنت على وشك إغلاق ورشة العمل. هذا سيؤدي إلى إظهار الدرجات المحتسبة في سجل التقديرات. يمكن للطلبة معاينة تسليماتهم وتقييماتهم لتلك التسليمات.';
$string['switchphaseauto'] = 'تمت جدولة التحويل';
$string['switchphasenext'] = 'تًحَوَّل إلى الطور التالي';
$string['taskassesspeers'] = 'قيِّم المناظرين';
$string['taskassesspeersdetails'] = 'الإجمالي: {$a->total}<br />قيد الانتظار: {$a->todo}';
$string['taskassessself'] = 'قيِّم نفسك';
$string['taskconclusion'] = 'أعطِ استنتاجاً عن النشاط';
$string['taskdone'] = 'المهمة أُنجزت';
$string['taskfail'] = 'المهمة فشلت';
$string['taskinfo'] = 'معلومات المهمة';
$string['taskinstructauthors'] = 'أعط تعليمات عن التسليم';
$string['taskinstructreviewers'] = 'أعط تعليمات عن التقييم';
$string['taskintro'] = 'ضع وصف ورشة العمل';
$string['tasksubmit'] = 'قم بتسليم عملك';
$string['tasktodo'] = 'المهمة المطلوبة';
$string['toolbox'] = 'أدوات ورشة العمل';
$string['undersetup'] = 'ورشة العمل حالياً هي قيد الإعداد. إنتظر لطفاً حتى تتحول إلى الطور التالي.';
$string['useexamples'] = 'استعمل نماذج';
$string['useexamples_desc'] = 'التسليمات النموذجية تُقدم للتدريب على التقييم';
$string['useexamples_help'] = 'عند تمكينه، يمكن للمستخدمين محاولة تقييم تسليم نموذجي واحد أو أكثر ومقارنة تقييماتهم بتقييم مرجعي. لا يتم احتساب العلامة الممنوحة على التقييم.';
$string['usepeerassessment'] = 'استعمل التقييم المناظر';
$string['usepeerassessment_desc'] = 'يمكن للطلبة تقييم أعمال الآخرين';
$string['usepeerassessment_help'] = 'عند تمكينه، يمكن للمستخدمين أن توزع عليهم أعمال الآخرين لتقييمها، وسيتلقون درجات إضافية على تقييماتهم هذه فضلاً عن الدرجات الخاصة بتسليماتهم.';
$string['userdatecreated'] = 'مُسَلَّمة في <span>{$a}</span>';
$string['userdatemodified'] = 'معدلة في <span>{$a}</span>';
$string['userplan'] = 'مخطط ورشة العمل';
$string['userplan_help'] = 'يعرض مخطط ورشة العمل كل أطوار النشاط ويدرج مهام كل منها. الطور الحالي مُبَرَّز وإكمال المهمة مؤشر بعلامة.';
$string['userplanaccessibilityskip'] = 'تخطى إلى المهام الحالية';
$string['userplanaccessibilitytitle'] = 'الجدول الزمني لورشة العمل ذات {$a} أطوار';
$string['userplancurrentphase'] = 'الطور الحالي';
$string['useselfassessment'] = 'استعمل التقييم الذاتي';
$string['useselfassessment_desc'] = 'يمكن للطلبة تقييم أعمالهم الذاتية';
$string['useselfassessment_help'] = 'عند تمكينه، سيكون بالإمكان توزيع التسليم على نفس المستخدم المقدِّم له لغرض تقييمه وسيتلقى علامة على ذلك فضلاً عن العلامة الممنوحة له على تسليمه.';
$string['viewworkshopsummary'] = 'معاينة ملخص ورشة العمل';
$string['weightinfo'] = 'الوزن: {$a}';
$string['withoutsubmission'] = 'مُقَيِّم بدون تسليم خاص به';
$string['workshop:addinstance'] = 'إضافة ورشة عمل جديدة';
$string['workshop:allocate'] = 'توزيع التسليمات بغرض التقييم';
$string['workshop:deletesubmissions'] = 'حذف التسليمات';
$string['workshop:editdimensions'] = 'تحرير نماذج التقييم';
$string['workshop:exportsubmissions'] = 'تصدير التسليمات';
$string['workshop:ignoredeadlines'] = 'تجاهل تقييدات الوقت';
$string['workshop:manageexamples'] = 'إدارة التسليمات النموذجية';
$string['workshop:overridegrades'] = 'تجاوز التقديرات المحسوبة';
$string['workshop:peerassess'] = 'التقييم المناظر';
$string['workshop:publishsubmissions'] = 'نشر التسليمات';
$string['workshop:submit'] = 'التسليم';
$string['workshop:switchphase'] = 'تحويل الطور';
$string['workshop:view'] = 'معاينة ورشة العمل';
$string['workshop:viewallassessments'] = 'معاينة كل التقييمات';
$string['workshop:viewallsubmissions'] = 'معاينة كل التسليمات';
$string['workshop:viewauthornames'] = 'معاينة أسماء الكُتَّاب';
$string['workshop:viewauthorpublished'] = 'معاينة كُتَّاب التسليمات المنشورة';
$string['workshop:viewpublishedsubmissions'] = 'معاينة التسليمات المنشورة';
$string['workshop:viewreviewernames'] = 'معاينة أسماء المُقيِّمين';
$string['workshopname'] = 'اسم ورشة العمل';
$string['yourassessmentfor'] = 'تقييمك لـ {$a}';
$string['yourgrades'] = 'تقديراتك';
$string['yoursubmission'] = 'تسليمك';
$string['yoursubmissionwithassessments'] = 'تسليمك مع التقييمات';
