<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dyslexic', language 'es', version '3.11'.
 *
 * @package     block_dyslexic
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['dyslexic:addinstance'] = 'Añadir un bloque Mod disléxico';
$string['dyslexic:myaddinstance'] = 'Agregue un bloque Mod disléxico al tablero';
$string['howto_description'] = 'El bloque Dyslexic Mod usa la tecnología Javascript para cambiar la visualización del sitio usando CSS.</br>La elección del usuario está almacenada en la cookie.';
$string['info'] = '¿Qué es la dislexia?';
$string['intro'] = 'La fuente OpenDyslexic aumenta la legibilidad para los lectores con dislexia.</br>¿Qué fuente desea usar?';
$string['link'] = 'Leer más sobre la fuente OpenDyslexic';
$string['opendyslexic_font'] = 'Fuente OpenDyslexic';
$string['pluginname'] = 'Modo disléxico';
$string['readmore'] = 'Leer más...';
$string['script_off'] = 'Detener animación !';
$string['script_on'] = 'Recargar animación';
$string['wikipedia_description'] = 'La dislexia, también conocida como trastorno de lectura, se caracteriza por problemas con la lectura que no están relacionados con problemas de inteligencia general. Diferentes personas se ven afectadas en diversos grados. Los problemas pueden incluir dificultades para deletrear palabras, leer rápidamente, escribir palabras, pronunciar palabras en la cabeza, pronunciar palabras al leer en voz alta y comprender lo que se lee. A menudo, estas dificultades se notan por primera vez en la escuela. Cuando alguien que antes sabía leer pierde su habilidad, se le conoce como alexia. Las dificultades son involuntarias y las personas con este trastorno tienen un deseo inamovible de aprender.</br>
Se cree que la causa de la dislexia involucra tanto factores genéticos como ambientales. Algunos casos se dan en familias. A menudo ocurre en personas con trastorno por déficit de atención con hiperactividad (TDAH) y se asocia con dificultades similares con los números. Puede comenzar en la edad adulta como resultado de una lesión cerebral traumática, un accidente cerebrovascular o una demencia. Los mecanismos subyacentes son problemas dentro del procesamiento del lenguaje del cerebro. La dislexia se diagnostica a través de una serie de pruebas de memoria, ortografía, visión y habilidades de lectura. La dislexia está separada de las dificultades de lectura causadas por una enseñanza insuficiente; o problemas de audición o visión.</br>
El tratamiento implica ajustar los métodos de enseñanza para satisfacer las necesidades de la persona. Si bien no cura el problema subyacente, puede disminuir el grado de los síntomas. Los tratamientos dirigidos a la visión no son efectivos. La dislexia es la discapacidad de aprendizaje más común y afecta al 3-7 % de la población; sin embargo, hasta un 20% puede tener algún grado de síntomas. Si bien la dislexia se diagnostica con mayor frecuencia en hombres, se ha sugerido que afecta a hombres y mujeres por igual. La dislexia ocurre en todas las áreas del mundo. Algunos creen que la dislexia debería considerarse mejor como una forma diferente de aprender, con ventajas y desventajas.';
$string['wikipedia_url'] = 'https://es.wikipedia.org/wiki/Dislexia';
