<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'es', version '3.11'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'La descarga de Moodle es gratuita y el registro volutario por lo que no tenemos información de todo el mundo que lo usa. De todas formas, utilizando lo que sabemos, automáticamente generamos gráficos e información estadística en nuestra página de estadísticas.';
$string['aboutstatisticsheading'] = 'Estadísticas de Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Estadísticas de Moodle';
$string['activeusers24hours'] = 'Usuarios registrados que han accedido las últimas 24 horas:';
$string['activeuserspastmonth'] = 'Usuarios registrados que han accedido el pasado mes:';
$string['browsegittitle'] = 'Navega nuestro código fuente';
$string['cachedef_frontpagecolumn'] = 'Columnas de portada';
$string['cachedef_usefulposts'] = 'Mensajes útiles';
$string['communities'] = 'Comunidades';
$string['communitiesmy'] = 'Mis comunidades';
$string['community'] = 'Comunidad';
$string['communityadministration'] = 'Administración de la comunidad';
$string['communitycurrent'] = 'Comunidad actual';
$string['communityenrolme'] = 'Hazte miembro de esta comunidad';
$string['communityenrolmentoptions'] = 'Unirse a una comunidad';
$string['communityintro'] = 'Moodle tiene una gran y diversa comunidad de usuarios con alrededor de <a href="http://moodle.org/userpics">{$a->usercount} usuarios registrados</a> sólamente en este sitio Moodle, hablando más <a href="http://download.moodle.org/lang16/">{$a->langcount} idiomas</a> en <a href="http://moodle.org/sites">{$a->countrycount} países</a> (disponemos de <a href="http://moodle.org/stats">más estadísticas</a>).';
$string['communityjoinbyyourself'] = 'Únase usted mismo';
$string['communityjoinbyyourselfas'] = 'Únase usted mismo como {$a->rolename}';
$string['communitynoguestaccess'] = 'Los invitados no pueden acceder a esta área de la comunidad, por favor, trate de acceder con su usuario.';
$string['communitynotenrollable'] = 'Usted mismo no puede convertirse en miembro de esta comunidad. Por favor, contacte con el moderador de la comunidad.';
$string['communitysomeallowguest'] = 'Algunas comunidades pueden permitir el acceso a invitados';
$string['communityunenrolme'] = 'Abandonar la comunidad {$a}';
$string['conferencecenter'] = 'Centro de conferencias de Moodle';
$string['connectedsites'] = 'Algunos sitios Moodle se han conectado a moodle.org usando la red de Moodle, por lo que puede acceder directamente a ellas una vez se haya autenticado aquí.';
$string['donations10over'] = 'Otras donaciones de USD 10 o más';
$string['donationsassociation'] = 'Únase a la <a href="https://moodleassociation.org/"> Asociación Moodle </a>: ayude a decidir cómo se deben gastar las cuotas de membresía en los elementos de la hoja de ruta de Moodle';
$string['donationsdevelopment'] = 'Sin embargo, el desarrollo de Moodle y el mantenimiento de todos los sitios de nuestra comunidad nos cuesta mucho dinero y un apoyo adicional siempre suma. Si ama Moodle o lo ha encontrado útil para su negocio, escuela o institución, haga una donación. Todo ayuda.';
$string['donationsdonatenow'] = 'Dona ahora';
$string['donationsensure'] = 'Las donaciones garantizan que los engranajes esenciales de la Máquina Moodle (nuestros desarrolladores) continúen creando nuevas funciones y corrigiendo errores, haciendo que Moodle sea mejor para todos nosotros.';
$string['donationsmoodle'] = 'Donar a Moodle';
$string['donationsopensource'] = 'Moodle es verdadero código abierto y completamente libre de obligaciones financieras para nuestros usuarios, ¡así es como debería ser el software!';
$string['donationsover1000'] = 'Donaciones anteriores superiores a USD 1000';
$string['donationsover200'] = 'Otras donaciones superiores a USD 200';
$string['donationsover500'] = 'Otras donaciones superiores a USD 500';
$string['donationspartner'] = 'Utilice un <a href="https://moodle.com/partners/"> Moodle Partner certificado </a> para los servicios. El 10% de sus ingresos se aporta al proyecto Moodle.';
$string['donationsshop'] = 'Compre algo en nuestra <a href="http://www.zazzle.com/moodle_hq/"> tienda Moodle </a> y úselo con orgullo.';
$string['donationsthankeveryone'] = 'Gracias a todos los que han contribuido al proyecto Moodle.';
$string['donationsthankyou'] = 'Gracias';
$string['donationstitle'] = 'Donaciones';
$string['donationsways'] = 'Otras formas de contribuir económicamente a Moodle:';
$string['download_activities'] = 'Actividades';
$string['download_admintools'] = 'Herramientas de Administración';
$string['download_appdocumentation'] = 'Documentación de la aplicación';
$string['download_appreleasenotes'] = 'Notas de la versión';
$string['download_browseall'] = 'Examinar todo';
$string['download_downloadosx'] = 'Descarga Moodle para OS X (contiene Moodle, Apache, MySQL y PHP para ejecutar en Mac OS)';
$string['download_downloadwindows'] = 'Descargue Moodle para Windows (contiene Moodle, Apache, MySQL y PHP para ejecutarse en el sistema operativo Windows)';
$string['download_forandroid'] = 'Para Android';
$string['download_forios'] = 'Para iOS';
$string['download_helpbox_description'] = 'Lea la documentación para comenzar y visite nuestros foros comunitarios, o simplemente póngase en contacto con un Moodle Partner para el alojamiento, la instalación y otros servicios.';
$string['download_helpbox_installing'] = 'Instalación de Moodle';
$string['download_helpbox_partners'] = 'Socios Moodle';
$string['download_helpbox_support'] = 'Foros de soporte';
$string['download_helpbox_title'] = '¿Necesita ayuda?';
$string['download_helpbox_upgrading'] = 'Actualizando Moodle';
$string['download_hero_description'] = 'Está bajo la <a class="link" href="http://docs.moodle.org/dev/License">licencia GPL-</a>, lo que significa que todos están licenciados libremente para usar y disfrutar los beneficios de nuestro software.<br><br>Revise nuestra más reciente versión de Moodle.';
$string['download_hero_headline'] = 'Moodle es código abierto';
$string['download_langpackinfo'] = 'Los paquetes de idioma son generados automáticamente a partir del trabajo de traductores en el  <a href="http://lang.moodle.org/">Sitio de traducción</a>Para más detalles, vea la documentación en inglés para desarrolladores en <a href="https://docs.moodle.org/dev/Translation">Translation documentation</a>.';
$string['download_langpackinstallinfo'] = 'Se pueden instalar paquetes adicionales de idioma en su sitio Moodle via <em>Administración > Administración del sitio > Idioma > Paquetes de idioma</em>, o manualmente. Para más detalles, vea la   <a href="https://docs.moodle.org/all/es/Paquetes_de_idioma">Documentación sobre paquetes de idioma</a>.';
$string['download_langpackinstalltitle'] = 'Instalación de paquetes de idioma';
$string['download_langpacktitle'] = 'Paquetes de idioma para Moodle {$a}';
$string['download_mobileapp'] = 'App Mobile';
$string['download_themes'] = 'Temas';
$string['download_viewallbuilds'] = 'Ver todas las compilaciones (requiere un servidor web, PHP y una base de datos para ejecutarse)';
$string['downloadcore'] = 'Nuestro principal método de distribución es a través de estos paquetes estándar con la distribución base. Contienen un conjunto de módulos que son mantenidos por los desarrolladores de Moodle, y son adecuados para ser utilizados en cualquier plataforma donde tenga instalados PHP y una base de datos.';
$string['downloadcoretitle'] = 'Paquetes estándar de Moodle';
$string['downloadintro'] = 'Moodle es código abierto bajo <a href="http://docs.moodle.org/dev/License">GPL licence</a>.  Todo lo que creamos se puede descargar y utilizar gratuita y libremente.';
$string['downloadlang'] = 'En las versiones actuales de Moodle se ha automatizado la adición de paquetes de idiomas desde el menú de administración del sitio. De todas formas, para versiones antiguas de Moodle, los paquetes de idioma se pueden descargar de forma manual.';
$string['downloadlangtitle'] = 'Paquetes de idioma';
$string['downloadmac'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier ordenador con Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Navegue por nuestra base de datos de módulos extra y extensiones que pueden ser instalados en su sitio Moodle para dotarlo de funcionalidades extras más allá de las incluidas en la distribución base de Moodle.';
$string['downloadmodulestitle'] = 'Extensiones';
$string['downloadthemes'] = 'El aspecto visual de Moodle puede cambiar notablemente en función del tema gráfico.  Mantenemos una base de datos de temas creados y mantenidos por usuarios de Moodle.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadviagitcvs'] = 'Otras formas de obtener Moodle incluyen <a href="http://docs.moodle.org/all/es/Git_para_Administradores">descarga mediante Git</a> o <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">descarga mediante CVS</a>.';
$string['downloadwin'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier ordenador con Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Únicamente los administradores pueden acceder a esta interfaz.';
$string['erroralreadyvoted'] = 'Usted ya ha votado por {$a}';
$string['errormaxmessages'] = 'Lo sentimos, pero no puede enviar más de 3 mensajes.';
$string['errornomainnews'] = 'No se ha podido encontrar o crear un foro principal de noticias en el sitio';
$string['errorsendingmail'] = 'Ha ocurrido un error al enviar el mensaje. Por favor, inténtelo de nuevo más tarde, o contacte con el administrador del sitio.';
$string['eventdonation_created'] = 'Lista de donaciones creada';
$string['eventdonation_submitted'] = 'Donación enviada';
$string['events'] = 'Aunque estamos especializados en la enseñanza en línea, siempre es bueno verse todos juntos en persona. Visite estos enlaces para más información sobre nuestras conferencias (las llamamos MoodleMoots) y otros eventos.';
$string['eventstitle'] = 'Eventos';
$string['feed_events'] = 'Eventos';
$string['feed_events_more'] = 'Más entradas del calendario';
$string['feed_news'] = 'Anuncios';
$string['feed_news_more'] = 'Ver todos los anuncios';
$string['feed_resources'] = 'Recursos';
$string['feed_useful'] = 'Mensajes útiles';
$string['feed_useful_more'] = 'Más mensajes';
$string['focusbox_community'] = 'Soporte y foros de la comunidad';
$string['focusbox_community_text'] = 'Obtenga soporte y comparta ideas, en su propio idioma.';
$string['focusbox_community_viewall'] = 'Listar todas las comunidades';
$string['focusbox_future'] = 'Ayude a darle forma al futuro de Moodle';
$string['focusbox_future_crowdfund'] = 'Proyectos financiados por la comunidad';
$string['focusbox_future_gdf'] = 'Foros de desarrolladores';
$string['focusbox_future_research'] = 'Investigación Moodle';
$string['focusbox_future_roadmap'] = 'Plan de desarrollo';
$string['focusbox_future_text'] = 'Descubre qué es lo próximo y ayude a marcar la diferencia.';
$string['focusbox_settingup'] = 'Configuración';
$string['focusbox_settingup_community'] = 'Soporte de la comunidad';
$string['focusbox_settingup_download'] = 'Descarga gratuita';
$string['focusbox_settingup_hosting'] = 'Alojamiento';
$string['focusbox_settingup_install'] = 'Instalación';
$string['focusbox_settingup_own'] = 'Por sí mismo';
$string['focusbox_settingup_partner'] = 'A través de un Moodle Partner';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Soporte comercial';
$string['focusbox_teaching'] = 'Enseñando con Moodle';
$string['focusbox_teaching_books'] = 'Libros';
$string['focusbox_teaching_courses'] = 'Cursos y contenido';
$string['focusbox_teaching_docs'] = 'Documentación';
$string['focusbox_teaching_text'] = 'Explore la gran variedad de funcionalidades y recursos disponibles en Moodle.';
$string['focusbox_theproject'] = 'El proyecto Moodle';
$string['focusbox_theproject_about'] = 'Acerca de Moodle';
$string['focusbox_theproject_devs'] = 'Desarrolladores';
$string['focusbox_theproject_hq'] = 'Sede central de Moodle';
$string['focusbox_theproject_partners'] = 'Moodle Partners';
$string['focusbox_theproject_stats'] = 'Estadísticas';
$string['focusbox_theproject_text'] = 'Aprenda más sobre el proyecto Moodle y nuestros acuerdos de colaboración.';
$string['focusbox_uptodate'] = 'Manténgase actualizado';
$string['focusbox_uptodate_buzz'] = 'Chismes Moodle';
$string['focusbox_uptodate_news'] = 'Anuncios';
$string['focusbox_uptodate_planet'] = 'Planeta Moodle';
$string['focusbox_uptodate_security'] = 'Avisos de seguridad';
$string['focusbox_uptodate_social'] = 'Redes sociales';
$string['focusbox_uptodate_text'] = 'Últimas noticias sobre Moodle, actualizaciones y destacados en el mundo.';
$string['generaldeveloperforum'] = 'Foro general de desarrolladores';
$string['graphpopulation'] = 'Gráfico de la población de Moodle';
$string['graphregistrationmap'] = 'Mapa de registros de Moodle';
$string['graphregistrationmapdesc'] = 'Los 10 primeros entre los sitios registrados en {$a} países';
$string['graphusersites'] = 'Comparación de usuarios de Moodle v sitio';
$string['heroslide_community_description'] = 'Bienvenido a la comunidad Moodle. Descubra el valor de un esfuerzo abierto colaborativo por uno de los equipos de código abierto más grandes del mundo.';
$string['heroslide_community_headline'] = 'Impulsado por la comunidad, soportado globalmente.';
$string['heroslide_community_slidecontrol'] = 'Apoyado por una comunidad global';
$string['heroslide_donate_headline'] = 'Ayúdanos a marcar la diferencia con una educación abierta y de calidad para todos';
$string['heroslide_getstarted_description'] = 'Moodle es la plataforma de aprendizaje más utilizada del mundo. Empieza a construir tu sitio de formación online en minutos.';
$string['heroslide_getstarted_headline'] = 'Empezar es fácil';
$string['heroslide_getstarted_slidecontrol'] = 'Empieza ahora';
$string['heroslide_global_description'] = 'Disponible en más de 100 idiomas, Moodle tiene la confianza de organizaciones e instituciones, grandes y pequeñas, con millones de usuarios en todo el mundo.';
$string['heroslide_global_headline'] = 'Impulsando ambientes de aprendizaje en todo el mundo';
$string['heroslide_global_slidecontrol'] = 'Impulsando ambientes de aprendizaje en todo el mundo';
$string['heroslide_link_demo'] = 'Demostración';
$string['heroslide_link_donate'] = 'Donar';
$string['heroslide_link_features'] = 'Características';
$string['heroslide_link_forums'] = 'Foros de la comunidad';
$string['heroslide_link_getstarted'] = 'Empieza ahora';
$string['heroslide_link_sites'] = 'Sitios registrados';
$string['heroslide_link_stats'] = 'Estadísticas';
$string['heroslide_link_stories'] = 'Leer más';
$string['heroslide_power_description'] = 'La plataforma de aprendizaje gratuita del mundo que lo ayuda a crear experiencias de enseñanza y aprendizaje en línea efectivas en un entorno colaborativo y privado.';
$string['heroslide_power_headline'] = 'Poderoso. Seguro. Código abierto.';
$string['heroslide_power_slidecontrol'] = 'Sólida plataforma de aprendizaje de código abierto';
$string['heroslide_story1_description'] = '"Liderar en el aprendizaje basado en tecnología nos permite facilitar el descubrimiento, la creatividad y la oportunidad de los estudiantes". - Profesor Darrell Evans, vicerrector profesional (aprendizaje y enseñanza), Universidad de Monash';
$string['heroslide_story1_headline'] = 'Mejorando la enseñanza y el aprendizaje en todas partes';
$string['heroslide_story2_description'] = 'El proveedor global de transporte, logística y servicios marítimos, GAC, ofrece iniciativas de aprendizaje y desarrollo a más de 10.000 empleados en más de 70 países con su Academia corporativa.';
$string['heroslide_story2_headline'] = 'Lograr la excelencia en el aprendizaje corporativo';
$string['heroslide_story3_description'] = 'Forth Valley College es una de las universidades más grandes de Escocia, que ofrece más de 750 cursos con más de 20 000 usuarios activos en sus sitios.';
$string['heroslide_story3_headline'] = 'Brindar educación integral y flexible';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas (VSO) ofrece aprendizaje interactivo y apoyo para voluntarios a nivel internacional para permitir enfoques de capacitación global.';
$string['heroslide_story4_headline'] = 'Ayudando a los voluntarias y voluntarios a entregar programas para combatir la pobreza';
$string['heroslide_story_slidecontrol'] = 'Historias sobre Moodle alrededor del mundo';
$string['jobs'] = 'Visite nuestra base de datos de ofertas de trabajo para información sobre puestos de trabajo en todo el mundo';
$string['logoinfo'] = 'El nombre Moodle ™ es una marca registrada de Moodle Trust.

Si tiene la intención de utilizar el nombre y/o el logotipo para publicitar servicios genéricos de Moodle (por ejemplo, alojamiento de Moodle, soporte de Moodle, certificación de Moodle, capacitación de Moodle, consultoría de Moodle, personalización de Moodle, desarrollo de cursos de Moodle, diseño de temas de Moodle, integraciones de Moodle, Moodle instalaciones, etc.) o como el nombre de un paquete de software, debe buscar y recibir permiso directo por escrito de Moodle Trust a través del [servicio de asistencia de moodle.com] (http://moodle.com/helpdesk/), de acuerdo con con las restricciones normales de marcas comerciales.

No hay restricciones sobre cómo usa el nombre en otros contextos (por ejemplo, si usa Moodle solo para proporcionar cursos, entonces puede usar el nombre libremente para referirse a él). Si no está seguro de un caso en particular, por favor pregúntenos a través del [servicio de ayuda de moodle.com] (http://moodle.com/helpdesk/). Estaremos encantados de proporcionarle un permiso oficial por escrito o ayudarle a corregir su redacción.';
$string['logotitle'] = 'Logo de Moodle';
$string['manageads'] = 'Administrar anuncios de socios';
$string['managedonations'] = 'Gestionar donaciones';
$string['moodleorg:manageads'] = 'Administrar anuncios de socios';
$string['moodleorg:managedonations'] = 'Gestionar el registro de donaciones';
$string['moodlepartner_corporate'] = 'Entrenamiento corporativo';
$string['moodlepartner_other'] = 'Otros sectores';
$string['moodlepartner_school'] = 'Escuela';
$string['moodlepartner_university'] = 'Universidad';
$string['networkinfo'] = 'Los siguientes sitios Moodle han sido conectados a moodle.org empleando la red Moodle, por lo que puede ingresar a ellos directamente desde aquí.';
$string['networktitle'] = 'Sitios conectados';
$string['newregistrations'] = 'Registros nuevos';
$string['newstitle'] = 'Noticias';
$string['noenrolledcoursesyet'] = 'Aún no se ha matriculado en ningún curso de este sitio';
$string['partnerslogan'] = 'El Proyecto Moodle cuenta con el respaldo de más de 90 <a href="https://moodle.com/partners/"> Socios Moodle </a> certificados a nivel mundial.';
$string['permalink'] = 'Enlace  permanente';
$string['pluginname'] = 'Sitio moodle.org';
$string['popularissues'] = 'Temas más populares';
$string['privacy:metadata:db:registerdonations'] = 'Mantiene registros de donaciones de Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Cantidad donada';
$string['privacy:metadata:db:registerdonations:name'] = 'Nombre del donante';
$string['privacy:metadata:db:registerdonations:org'] = 'Organización donante';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Marca de tiempo de la donación';
$string['privacy:metadata:db:registerdonations:url'] = 'URL del donante';
$string['recentlyratedposts'] = 'Publicaciones calificadas recientemente';
$string['recentpart'] = 'Esta página muestra algunas de las personas que están utilizando moodle.org hoy.';
$string['registeredsites'] = 'Las instituciones no están obligadas a informar a nadie cuando usan Moodle, porque Moodle es Código Abierto.  Aún así, algunos sitios Moodle han escogido registrarse con nosotros y así los podemos listar.';
$string['registeredsitestitle'] = 'Sitios registrados';
$string['registereduserslastday'] = 'Nuevos usuarios en las últimas 24 horas:';
$string['registereduserstotal'] = 'Total de usuarios registrados:';
$string['registrationgraphalt'] = 'Registros totales en Moodle a lo largo del tiempo';
$string['registrationgraphdesc'] = 'Llevamos a cabo una <a href="http://docs.moodle.org/en/Usage">comprobación masiva regular de los sitios </a> para asegurarnos de que aún existen, por lo que en ocasiones es posible que vea reducciones en el recuento';
$string['registrationslast6months'] = 'Registros en los últimos 6 meses';
$string['registrationslastmonths'] = 'Registros en los últimos {$a} meses';
$string['registrationstotal'] = 'Todos los registros actuales';
$string['resources_buzz'] = 'Todos los registros actuales';
$string['resources_courses'] = 'Cursos';
$string['resources_jobs'] = 'Empleos';
$string['resources_plugins'] = 'Complementos';
$string['roadmap'] = 'Hoja de ruta de Moodle';
$string['rssdescription'] = 'Publicaciones de foro útiles recientes o calificadas de manera útil de moodle.org';
$string['rssmoodlecommore'] = 'Vea todas las novedades recientes';
$string['rssmoodlecomtitle'] = 'Novedades recientes';
$string['rsstitle'] = 'Publicaciones en foros de Moodle.org';
$string['searchmoodleorg'] = 'Buscar moodle.org';
$string['securitytitle'] = 'Anuncios de seguridad';
$string['shop'] = '¿Busca la forma de hacer ver que forma parte de nuestra comunidad? Eche un ojo a nuestra tienda donde encontrará camisetas, tazas y otras cosas.';
$string['social-facebook-moodle'] = 'Página oficial de Moodle en Facebook';
$string['social-googleplus-community'] = 'Página oficial de comunidad Moodle en Google+';
$string['social-googleplus-moodle'] = 'Página oficial de Moodle en Google+';
$string['social-linkedin-moodle'] = 'Página oficial de Moodle en Linkedln';
$string['social-twitter-moodle'] = 'Anuncios oficiales de Moodle, noticias agregadas de Moodle de Planet Moodle y Moodle Buzz, y publicaciones útiles en el foro';
$string['social-twitter-moodledev'] = 'Actualizaciones y noticias sobre el desarrollo de Moodle';
$string['social-twitter-moodlehq'] = 'Tweets de Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Ofertas de trabajos relacionados con Moodle';
$string['social-twitter-moodlenet'] = 'Contenido y cursos compartidos de Moodle';
$string['social-twitter-moodleplugins'] = 'Extensiones de Moodle publicadas recientemente';
$string['social-twitter-moodleresearch'] = 'Actualizaciones sobre la conferencia anual de investigación de Moodle y la investigación relacionada con Moodle';
$string['social-twitter-moodlesecurity'] = 'Avisos de seguridad de Moodle';
$string['social-twitter-moodlesites'] = 'Actualizaciones de estado para la red de sitios y servicios de Moodle HQ';
$string['social-twitter-moodlethemes'] = 'Temas de Moodle lanzados recientemente';
$string['social-youtube-moodle'] = 'Canal oficial de Moodle en YouTube';
$string['socialinfo'] = 'Estamos en varios sitios de redes sociales para ayudar a crear conciencia sobre el proyecto Moodle y compartir las últimas noticias y acontecimientos en el mundo Moodle. ¡Síganos para mantenerse al día y conocer a otros miembros de la comunidad!';
$string['socialtitle'] = 'Medios sociales';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Cursos';
$string['statsenrolments'] = 'Matriculaciones';
$string['statsposts'] = 'Mensajes en foros';
$string['statsquestions'] = 'Preguntas de cuestionario';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Profesores';
$string['statsusers'] = 'Usuarios';
$string['supportbooks'] = 'Mantenemos una lista de libros a la venta sobre Moodle.';
$string['supportcommercial'] = 'Los <a href="http://moodle.com/">Partners de Moodle</a> son un grupo de empresas que prestan servicios autorizados por todo el mundo encargados de financiar económicamente el proyecto de código abierto Moodle. Proporcionan una gran variedad de servicios comerciales para los usuarios de Moodle en todo el mundo:';
$string['supportdocs1'] = 'La documentación de Moodle es un buen sitio para empezar, sobre todo nuestra página de Preguntas Frecuentes.';
$string['supportdocs2'] = 'Una buena manera de acceder a documentación relevante de Moodle es utilizar el enlace "Documentación de Moodle para esta página" en la parte inferior de cada página de su sitio Moodle.';
$string['supportdocsfaq'] = 'Preguntas frecuentes';
$string['supportdocslang'] = 'Documentación de Moodle en otros idiomas';
$string['supportforums'] = 'Nuestra comunidad de usuarios se comunica principalmente mediante los foros dentro de los "cursos" de este sitio Moodle.  Debe "matricularte" en el curso para poder enviar mensajes (la matriculación es totalmente gratuita).';
$string['supportforumsenglish'] = 'Aquí la mayoría del soporte y debates entre usuarios y desarrolladores están en inglés:';
$string['supportforumsenglishname'] = 'Usando Moodle';
$string['supportforumslang'] = 'El foro de Moodle para hacer vida social en inglés está aquí:';
$string['supportforumslangname'] = 'Sala de estar de Moodle';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'También disponemos de otros foros, en muchos idiomas:';
$string['supportforumslistname'] = 'Listado de todos los cursos';
$string['supportintro'] = '¡No está solo!  Hay muchas formas de conseguir ayuda con Moodle si lo necesita.';
$string['syncregistrationstask'] = 'Sincronizar las actualizaciones de registro del sitio 1.9 con moodle.net';
$string['top10countriesbyregistration'] = 'Los 10 países principales por registros';
$string['top10sitesbycourses'] = 'Los 10 sitios con más cursos';
$string['top10sitesbyusers'] = 'Los 10 sitios con más usuarios';
$string['url-about'] = 'http://docs.moodle.org/all/es/Acerca_de_Moodle';
$string['url-features'] = 'http://docs.moodle.org/all/es/Características';
$string['url-install'] = 'http://docs.moodle.org/all/es/Instalación';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/all/es/Página_Principal';
$string['versionsused'] = 'Versiones utilizadas';
