<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'es', version '3.11'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Accesibilidad';
$string['accessibilitydisabled'] = 'El Kit de Accesibilidad Brickfield no está habilitado en este sitio. Póngase en contacto con el administrador del sitio para habilitarlo.';
$string['accessibilityreport'] = 'Kit de Accesibilidad';
$string['accessibilitytool'] = 'Herramienta de accesibilidad Brickfield';
$string['accessibilitytools'] = 'Herramientas de accesibilidad de Brickfield';
$string['activate'] = 'Activar';
$string['activated'] = 'La extensión está activada y lista para usar.';
$string['activationform'] = 'Registro en Brickfield';
$string['activationheader'] = 'Activación de Brickfield';
$string['activationinfo'] = '<p>Para utilizar esta extensión, debe proporcionar claves válidas para este sitio en este formulario.</p><p>Por favor <a href="{$a}" data-action="send_info" target="_blank">regístrese en el Portal de Brickfield (abre en ventana nueva)</a> para recibir las claves si aún no las tiene.</p><p>Una vez activadas, sus claves se validarán mediante tareas cron programadas.</p>';
$string['activityresults:pluginname'] = 'Informe de la herramienta de desglose por actividad';
$string['activityresults:toolname'] = 'Resumen del desglose por actividad';
$string['activityresults:toolshortname'] = 'Desglose por actividad';
$string['advanced:pluginname'] = 'Informe avanzado de la herramienta de accesibilidad';
$string['advanced:toolname'] = 'Resumen avanzado';
$string['advanced:toolshortname'] = 'Avanzado';
$string['allcourses'] = 'Todos los cursos revisados ({$a})';
$string['allcoursescat'] = 'Todos los cursos revisados para la categoría {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'A petición';
$string['analysis:disabled'] = 'Deshabilitado';
$string['analysistype'] = 'Habilitar solicitudes de análisis';
$string['analysistype_desc'] = 'Permitir la solicitud de análisis de accesibilidad del contenido';
$string['analysistypedisabled'] = 'El análisis de contenido está deshabilitado';
$string['bannercontentone'] = 'La versión Enterprise del Kit de Accesibilidad dispone de un completo conjunto de funciones para ayudar a su organización a mejorar la accesibilidad de sus cursos. <a href="{$a}">Contacte con Brickfield Education Labs</a> para reservar una demostración gratuita de las funciones avanzadas.';
$string['bannercontenttwo'] = 'Cree una plataforma de enseñanza y aprendizaje eficaz e inclusiva mediante la búsqueda de contenido que no cumpla con las pautas, solucionando los problemas y garantizando el futuro del contenido de su curso Moodle con archivos accesibles, editor y funciones mejoradas.';
$string['bannerheadingone'] = 'Actualizar a la versión Enterprise del Kit de Accesibilidad';
$string['batch'] = 'Límite de lote';
$string['brickfield'] = 'Kit de Brickfield';
$string['brickfield:viewcoursetools'] = 'Ver informes por cursos';
$string['brickfield:viewsystemtools'] = 'Ver informes de todos los cursos';
$string['bulkprocesscaches'] = 'Procesar almacenamiento en caché masivo';
$string['bulkprocesscourses'] = 'Comprobación masiva de accesibilidad de lotes de procesos';
$string['buttonone'] = 'Obtener una demostración gratuita';
$string['cachepending'] = 'Se están recopilando los datos del resumen';
$string['checkdesc:alinksdontopennewwindow'] = 'Los enlaces que se abren en una ventana nueva deben advertir a los usuarios con antelación.';
$string['checkdesc:amustcontaintext'] = 'Un enlace debe contener texto para que sea perceptible.';
$string['checkdesc:areadontopennewwindow'] = 'Las áreas, utilizadas en mapas de imágenes, que se abren en una nueva ventana deben advertir a los usuarios con anticipación.';
$string['checkdesc:areahasaltvalue'] = 'Las áreas, utilizadas en mapas de imágenes, no les deben faltar texto alternativo, de forma similar a las imágenes.';
$string['checkdesc:asuspiciouslinktext'] = 'El texto del enlace debe ser descriptivo y proporcionar contexto sobre su destino.';
$string['checkdesc:basefontisnotused'] = 'Los elementos basefont (usados tradicionalmente para formatear) no son accesibles y no deben usarse.';
$string['checkdesc:blinkisnotused'] = 'Los elementos que parpadean (que se encienden y apagan) no son accesibles y no deben utilizarse.';
$string['checkdesc:boldisnotused'] = 'No se deben utilizar el elemento negrita (b); en su lugar, debería utilizarse la etiqueta "strong".';
$string['checkdesc:contenttoolong'] = 'La longitud total del contenido de la página no debe exceder las 500 palabras.';
$string['checkdesc:csstexthascontrast'] = 'El contraste de color entre el texto y el fondo es demasiado bajo.';
$string['checkdesc:embedhasassociatednoembed'] = 'Los elementos embed (para incrustar multimedia) no deben perder sus elementos "noembed" correspondientes.';
$string['checkdesc:headerh3'] = 'Los encabezados que siguen a los encabezados H3 (la opción de encabezado mayor del editor) no deben romper la jerarquía de encabezados de página.';
$string['checkdesc:headershavetext'] = 'Un encabezado debe contener texto para que sea perceptible.';
$string['checkdesc:iisnotused'] = 'No se deben utilizar elementos en cursiva (i); en su lugar, debería usarse "em".';
$string['checkdesc:imgaltisdifferent'] = 'El texto alternativo de la imagen no debe ser el nombre del archivo de la imagen.';
$string['checkdesc:imgaltistoolong'] = 'El texto alternativo de la imagen no debe tener más de los (125) caracteres máximos permitidos.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'El texto alternativo de la imagen no debe estar vacío, especialmente cuando la imagen tiene un enlace que va a otra parte.';
$string['checkdesc:imgaltnotplaceholder'] = 'El texto alternativo de la imagen no debe ser un simple texto de marcador de posición, como "imagen".';
$string['checkdesc:imghasalt'] = 'El texto alternativo de la imagen no debe faltar en los elementos de la imagen, a menos que sean puramente decorativos y sin significado.';
$string['checkdesc:imgwithmaphasusemap'] = 'Los mapas de imagen, con áreas en las que se puede hacer clic, necesitan elementos coincidentes de "usemap" y "map".';
$string['checkdesc:legendtextnotempty'] = 'Los elementos "legend", que se utilizan para poner título a los elementos "fieldset", deben contener texto.';
$string['checkdesc:marqueeisnotused'] = 'Los elementos "marquee" (desplazamiento automático) no son accesibles y no deben utilizarse.';
$string['checkdesc:noheadings'] = 'La ausencia de encabezados hace que el contenido sea menos estructurado y más difícil de leer.';
$string['checkdesc:objectmusthaveembed'] = 'Los elementos "object" (para incrustar recursos externos) no deben perder sus elementos "embed" correspondientes.';
$string['checkdesc:objectmusthavetitle'] = 'Los elementos "object" (para incorporar recursos externos) no deben perder sus descripciones "title" correspondientes.';
$string['checkdesc:objectmusthavevalidtitle'] = 'Los elementos "object" (para incrustar recursos externos) deben tener "title" correspondientes con el texto.';
$string['checkdesc:strikeisnotused'] = 'No se deben utilizar elementos "strike" (tachados); en su lugar, debería usarse "del" (eliminado).';
$string['checkdesc:tabledatashouldhaveth'] = 'Idealmente a las tablas no les deberían faltar encabezados.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Los resúmenes de las tablas (summary) y los subtítulos (captions) no deben ser idénticos.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Idealmente, las tablas no deberían tener celdas combinadas.';
$string['checkdesc:tablethshouldhavescope'] = 'Debe declararse el "scope" de fila o columna de la tabla (utilizados para mapear filas y columnas a cada celda).';
$string['checkidvalidation'] = 'Tarea para comprobar si hay checkids no válidos';
$string['checkscompleted'] = 'Comprobaciones completadas: {$a}';
$string['checktype'] = 'Comprobar grupo';
$string['checktype:form'] = 'Formulario';
$string['checktype:image'] = 'Imagen';
$string['checktype:layout'] = 'Diseño';
$string['checktype:link'] = 'Enlace';
$string['checktype:media'] = 'Media';
$string['checktype:table'] = 'Tabla';
$string['checktype:text'] = 'Texto';
$string['checktyperesults:pluginname'] = 'Informe de Tipos de contenido de la herramienta de accesibilidad';
$string['checktyperesults:toolname'] = 'Resumen de Tipos de contenido';
$string['checktyperesults:toolshortname'] = 'Tipos de contenido';
$string['cmpercent'] = 'Porcentaje global de actividades';
$string['cmpercenterrors'] = 'Porcentaje global de errores';
$string['cmpercenttitle'] = '% global del desglose por actividades frente a los errores';
$string['confirmationmessage'] = 'Se ha programado el curso para el análisis. El análisis se completará como pronto a las {$a}. Revíselo después.';
$string['contactadmin'] = 'Por favor, contacte con su administrador para completar el registro.';
$string['contactus'] = 'Contáctenos';
$string['contentfive'] = 'Corrige automáticamente las etiquetas HTML desactualizadas.';
$string['contentfour'] = 'Identifica qué actividades tienen más problemas de accesibilidad para priorizar el esfuerzo.';
$string['contentone'] = 'Evalúa automáticamente el contenido y las evaluaciones del curso para detectar problemas de accesibilidad.';
$string['contentsix'] = 'Proporciona a los profesores consejos para crear un mejor contenido.';
$string['contentthree'] = 'Proporciona a los estudiantes contenido en formatos accesibles, incluyendo audio, ePub y Braille electrónico.';
$string['contenttwo'] = 'Actualización masiva de texto confuso o inexistente para enlaces web, descripciones de imágenes y subtítulos de video.';
$string['contenttypeerrors'] = 'Resultados totales de las pruebas de contenido de la actividad por curso y por tipo de contenido.';
$string['contentyperesults'] = 'Aprobados/Reprobados totales por curso para áreas de contenido.';
$string['contextid'] = 'Contextid';
$string['core_course'] = 'Curso';
$string['core_question'] = 'Bancos de preguntas';
$string['count'] = 'Recuento';
$string['country'] = 'País';
$string['country_help'] = 'País del sitio';
$string['coursecount'] = 'Número de cursos';
$string['deletehistoricaldata'] = 'Eliminar los resultados del histórico de comprobaciones';
$string['dependency'] = 'Dependiente de';
$string['emptycategory'] = 'No se encontraron cursos para la categoría {$a}';
$string['emptytagcourses'] = 'No se encontraron resultados para cursos con marcas configuradas';
$string['enableaccessibilitytools'] = 'Habilitar las Herramientas de Accesibilidad';
$string['enableaccessibilitytools_desc'] = 'El Kit de Accesibilidad ayuda a identificar problemas de accesibilidad en los cursos.';
$string['error:nocoursespecified'] = 'Este informe resumen requiere una id de curso válida. Acceda al Kit de Accesibilidad desde dentro de un curso.';
$string['errorlink'] = 'Editar instancia de error para {$a}';
$string['errors'] = 'Errores: {$a}';
$string['errors:pluginname'] = 'Lista de errores de la herramienta de accesibilidad';
$string['errors:toolname'] = 'Resumen de la lista de errores';
$string['errors:toolshortname'] = 'Lista de errores';
$string['eventanalysis_requested'] = 'Análisis de contenido solicitado';
$string['eventanalysis_requesteddesc'] = 'Se  ha solicitado un análisis de contenido para el curso {$a}.';
$string['eventreport_downloaded'] = 'Resumen de accesibilidad descargado';
$string['eventreport_downloadeddesc'] = 'Se has descargado el resumen de accesibilidad para el curso con id  {$a}.';
$string['eventreport_viewed'] = 'Informe de accesibilidad visto';
$string['eventreport_vieweddesc'] = 'Se ha visto el informe de accesibilidad para el curso con la id {$a->course},
id de categoría {$a->category}, pestaña {$a->tab}.';
$string['failed'] = 'No superado';
$string['failedcount'] = 'No superados: {$a}';
$string['footerheading'] = 'Sección del pie de página';
$string['fullcachedone'] = 'Desactivar para volver a ejecutar el almacenamiento en caché';
$string['hashcorrect'] = 'El código introducido es correcto.';
$string['hashincorrect'] = 'El código introducido es incorrecto.';
$string['headingfive'] = 'Corrección del HTML';
$string['headingfour'] = 'Esfuerzo de enfoque';
$string['headingone'] = 'Evaluación de contenido';
$string['headingsix'] = 'Soporte al desempeño';
$string['headingthree'] = 'Archivos en formatos accesibles';
$string['headingtwo'] = 'Reparación';
$string['hideshow'] = 'Oculta/Muestra';
$string['inactive'] = 'La extensión está inactiva y no puede usarse. Por favor escriba claves de registro válidas y presione "Activar".';
$string['innercontextid'] = 'Contexto interno';
$string['installed'] = 'Extensión instalada';
$string['installedcli'] = 'Extensión instalada mediante línea de comandos';
$string['installeddescription'] = 'Se ha instalado la extensión, redirección al formulario de activación.';
$string['invalidaccessibilitytool'] = 'Se ha solicitado una subextensión de accesibilidad no válida.';
$string['invalidcategoryid'] = 'Categoría inválida, por favor, revise los datos introducidos';
$string['invalidcourseid'] = 'Curso inválido, por favor revise los datos introducidos';
$string['invalidlinkphrases'] = 'clic | clique aquí | haga clic aquí | clica aquí | pinche aquí | info| más información | información | información aquí | leer más | leer más aquí | saber más | detalles | más detalles | más';
$string['language'] = 'Idioma';
$string['language_help'] = 'Idioma del sitio';
$string['messageprovider:warningcheckid'] = 'Advertencia de checkids inválidos';
$string['mobileservice'] = 'Servicio para móviles habilitado  ({$a})';
$string['module'] = 'Módulo';
$string['modulename'] = 'Nombre';
$string['moreinfo'] = 'Más información';
$string['noerrorsfound'] = 'No se han econtrado errores de accesibilidad habituales para sus parámetros de búsqueda. ¡Felicidades!';
$string['norecords'] = 'No se han encontrado registros pertinentes para sus parámetros de búsqueda.';
$string['notregistered'] = 'Debe registrar su Kit de Accesibilidad.';
$string['notvalidated'] = 'Su Kit de Accessibilidad es funcional mientras se valida.';
$string['numcourses'] = 'Número de cursos ({$a})';
$string['numfactivities'] = 'Número de actividades ({$a})';
$string['numfiles'] = 'Número de archivos ({$a})';
$string['numinstances'] = 'Número de instancias';
$string['numusers'] = 'Número de usuarios ({$a})';
$string['pagedesc:checktype'] = '<p>Para resumir y analizar los resultados de las diversas comprobaciones realizadas, agrupamos estas comprobaciones en diferentes tipos de contenido. Por lo tanto, todos los resultados de la comprobación de accesibilidad relacionada con la imagen están en el grupo de tipo de contenido "Imagen", todos los resultados de la comprobación de accesibilidad relacionada con el diseño están en el grupo de tipo de contenido "Diseño", y así sucesivamente.</p><p>Las actividades están incluidas ya sea como actividades, recursos o áreas de contenido relacionadas con los cursos en sí.</p><p>La página del gráfico de tipo de contenido muestra el error desglosado por grupo de tipo de contenido: Imagen, Diseño, Enlace, Media, Tabla y Texto.</p>';
$string['pagedesc:pertarget'] = '<p>Para resumir y analizar los resultados de la comprobación por actividad, agrupamos estos resultados en las diferentes actividades detectadas.</p><p>Las actividades se incluyen ya sea como actividades, recursos u otras áreas de contenido relacionadas con los cursos mismos. Cada actividad sin errores detectados se cuenta como superada, cada actividad con uno o más errores detectados se cuenta como no superada. A continuación, se muestra la ratio de actividades superadas y no superadas.</p><p>La página del gráfico de desglose por actividades muestra la ratio de instancias superadas y no superadas en total, por actividad, tales como tarea, curso, etiqueta, etc.</p>';
$string['pagedesctitle:checktype'] = 'Sobre los tipos de contenido';
$string['pagedesctitle:pertarget'] = 'Sobre el desglose por actividad';
$string['passed'] = 'Superado';
$string['passedcount'] = 'Superado(s): {$a}';
$string['passrate'] = 'Tasa de superación: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Número de pruebas y errores específicos por comprobación y por curso.';
$string['perpage'] = 'Elementos a mostrar por página';
$string['pluginname'] = 'Kit de Accesibilidad';
$string['printable:downloadpdf'] = 'Descargar PDF';
$string['printable:pluginname'] = 'Informe resumen del informe de la herramienta de accesibilidad';
$string['printable:printreport'] = 'Informe imprimible';
$string['printable:toolname'] = 'Informe resumen';
$string['printable:toolshortname'] = 'Informe resumen';
$string['privacy:metadata'] = 'El complemento de informe de comprobaciones de accesibilidad no almacena ningún dato personal.';
$string['processanalysisrequests'] = 'Procesar solicitudes de análisis de contenido';
$string['registernow'] = 'Por favor regístrese ahora.';
$string['registration'] = 'Formulario de registro';
$string['registrationinfo'] = '<p>Este proceso de registro le permite utilizar la versión Starter del Kit de Accesibilidad de Brickfield para su sitio Moodle registrado.</p><p>Su uso está sujeto a los <a href="{$a}" target="_blank">Términos y condiciones de Brickfield Education Labs (abre en ventana nueva)</a> que Usted acepta al usar este producto.</p>';
$string['release'] = 'Versión de Moodle ({$a})';
$string['remaining'] = '({$a} errores restantes)';
$string['response:0'] = 'Esta URL no apunta a ninguna parte';
$string['response:404'] = 'No se ha encontrado la página de esta URL';
$string['schedule:blocknotscheduled'] = '<p> Aun no se ha programado el análisis de este curso para encontrar problemas frecuentes de accesibilidad.</p>';
$string['schedule:notscheduled'] = '<p> Aun no se ha programado el análisis de este curso para encontrar problemas frecuentes de accesibilidad.</p><p>Al hcer clic en el botón "Enviar para analizar", confirma que desea que todo el contenido HTML relevante del curso, como las descripciones de las secciones del curs, descripciones de actividades, preguntas, páginas y més, se programen para su análisis.</p><p>Este análisis llevará a cabo múltiples comprobaciones comunes de accesibilidad en el contenido HTML de su curso, y los resultados se mostrarán en las páginas de informes del Kit de Accesibilidad. El análisis será procesado en segundo plano, mediante tareas programadas, por lo que la velocidad de finalización dependerá de los tiempos y los programas de ejecución de las tareas.</p>';
$string['schedule:requestanalysis'] = 'Enviar para analizar';
$string['schedule:scheduled'] = 'Se ha programado este curso para el análisis.';
$string['schedule:sitenotscheduled'] = '<p>El contenido global (independiente del curso) aún no se ha programado para analizar y encontrar problemas de accesibilidad comunes.</p><p>Al hacer clic en el botón "Enviar para analizar", confirma que quiere que todo el contenido relevante y global (independiente del curso) se programe para ser analizado.</p><p>Este análisis llevará a cabo múltiples comprobaciones comunes de accesibilidad en el contenido, y los resultados se mostrarán en las páginas de informes del Kit de Accesibilidad. El análisis será procesado en segundo plano, mediante tareas programadas, por lo que la velocidad de finalización dependerá de los tiempos y los programas de ejecución de las tareas.</p>';
$string['schedule:sitescheduled'] = 'Se ha programado el análisis del contenido global (independiente del curso).';
$string['secretkey'] = 'Clave API';
$string['secretkey_help'] = 'Este código se recibe por correo electrónico después del registro.';
$string['sendfollowinginfo'] = '<p>La siguiente información se enviará periódicamente para contribuir únicamente a las estadísticas generales. No se hará pública en ningún listado central.</p> {$a}';
$string['settings'] = 'Configuración del Kit de Accesibilidad';
$string['sitehash'] = 'Clave secreta (secret key)';
$string['sitehash_help'] = 'Este código se recibe por correo electrónico después del registro.';
$string['taberrors'] = 'Comprobar errores';
$string['targetavetitle'] = 'Promedio de errores por actividad';
$string['targetpercentage'] = 'Porcentaje de instancias que superan/no superan por actividad';
$string['targetratio'] = 'Ratio de superación de actividad';
$string['tblcheck'] = 'Comprobar';
$string['tblcheckexample'] = 'Ejemplo';
$string['tblcheckfailed'] = 'Comprobaciones no superadas';
$string['tblchecksummary'] = 'Resumen';
$string['tbledit'] = 'Editar';
$string['tblerrorcount'] = 'Errores';
$string['tblhtmlcode'] = 'Código HTML existente';
$string['tblinstance'] = 'Instancia';
$string['tblline'] = 'Línea';
$string['tbloverallpercentage'] = '% Errores generales';
$string['tblpercentage'] = 'Porcentaje';
$string['tblpreview'] = 'Previsualizar';
$string['tbltarget'] = 'Actividad';
$string['tblupdateto'] = 'Actualizar a';
$string['titleactivityresultsall'] = 'Resultados por actividad: todos los cursos revisados ({$a->count} courses)';
$string['titleactivityresultspartial'] = 'Resultados por actividad: curso {$a->name}';
$string['titleall'] = 'Detalles del error: todos los cursos revisados ({$a->count} courses)';
$string['titlechecktyperesultsall'] = 'Resultados por tipo de contenido: todos los cursos revisados ({$a->count} courses)';
$string['titlechecktyperesultspartial'] = 'Resultados por tipo de contenido: curso {$a->name}';
$string['titleerrorsall'] = 'Detalles del Error: todos los cursos revisados ({$a->count} courses)';
$string['titleerrorscount'] = 'Detalles del error:  (mostrando los primeros {$a} errores)';
$string['titleerrorspartial'] = 'Detalles del error: curso {$a->name}';
$string['titlepartial'] = 'Detalles del error: curso {$a->name}';
$string['titleprintableall'] = 'Curso {$a->name}';
$string['titleprintablepartial'] = 'Curso {$a->name}';
$string['tools'] = 'Informes';
$string['toperrors'] = 'Errores principales';
$string['toptargets'] = 'Actividades con errores';
$string['totalactivities'] = 'Total de actividades';
$string['totalactivitiescount'] = 'Total de activitidades: {$a}';
$string['totalareas'] = 'Total de áreas';
$string['totalerrors'] = 'Errores totales';
$string['totalgrouperrors'] = 'Total (suma) de errores por tipo de contenido';
$string['updatesummarydata'] = 'Actualizar summarydata del sitio';
$string['usersmobileregistered'] = 'Número de usuarios con dispositivos móviles registrados ({$a})';
$string['validationerror'] = 'La validación de la clave de registro ha fallado. Compruebe que la URL y las claves del sitio registrado sean correctas.';
$string['warningcheckidbody'] = 'Hay un problema con una comprobación de Brickfield que está activa pero que no aparece en la base de datos. Por favor, investigue.';
$string['warningcheckidsubject'] = 'Advertencia checkID del Kit de Accesibilidad';
