<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'ro', version '3.11'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acțiune';
$string['activityoverview'] = 'Aveți chestionare care trebuie predate';
$string['additionalinfo'] = 'Informații suplimentare';
$string['additionalinfo_help'] = 'Textul care va fi afișat în partea de sus a primei pagini a acestui chestionar. (adică instrucțiuni, informații de fundal etc.)';
$string['addnewquestion'] = 'Adăugarea întrebării {$a}';
$string['addnewsection'] = 'Adaugă secțiune nouă';
$string['addquestion'] = 'Adaugă întrebare...';
$string['addquestions'] = 'Adaugă întrebări';
$string['addquestiontosection'] = 'Adaugă întrebare la secțiune';
$string['addselqtype'] = 'Adaugă tipul de întrebare selectat';
$string['alignment'] = 'Alinierea butoanelor radio';
$string['alignment_help'] = 'Selectează alinierea butoanelor: vertical (implicit) sau orizontal.';
$string['alignment_link'] = 'mod/chestionar/întrebări#Butoane_Radio';
$string['all'] = 'Toate';
$string['allnameddegrees'] = 'Denumirea elementelor de scală';
$string['alreadyfilled'] = 'Ați completat deja acest chestionar pentru noi {$a}. Vă mulțumim.';
$string['andaveragevalues'] = 'și valori medii';
$string['anonymous'] = 'Anonim';
$string['answer'] = 'Răspuns';
$string['answergiven'] = 'Acest răspuns a fost dat';
$string['answernotgiven'] = 'Acest răspuns nu a fost dat';
$string['answerquestions'] = 'Raspunde la intrebari...';
$string['answers'] = 'Răspunsuri';
$string['attempted'] = 'Acest chestionar a fost trimis.';
$string['attemptstillinprogress'] = 'In curs. Salvat pe:';
$string['autonumbering'] = 'Numerotarea automată';
$string['autonumbering_help'] = 'Numerotarea automată a întrebărilor și a paginilor. Poate doriți să dezactivați numerotarea automată
  pentru chestionare cu ramificare condiționată.';
$string['autonumberno'] = 'Nu numerotați paginile sau întrebările';
$string['autonumberpages'] = 'Numerotarea automată a paginilor';
$string['autonumberpagesandquestions'] = 'Numerotarea automată a paginilor și a întrebărilor';
$string['autonumberquestions'] = 'Numerotarea automată a întrebărilor';
$string['average'] = 'Medie';
$string['averageposition'] = 'Poziția medie';
$string['averagerank'] = 'Rang mediu';
$string['bodytext'] = 'Corpul textului';
$string['boxesnbexact'] = 'exact {$a} casetă(e).';
$string['boxesnbmax'] = 'maxim {$a} casete.';
$string['boxesnbmin'] = 'minim {$a} casete.';
$string['boxesnbreq'] = 'Pentru această întrebare trebuie să bifați';
$string['by'] = 'de';
$string['cannotviewpublicresponses'] = 'Nu puteți vizualiza răspunsurile la acest chestionar public.';
$string['chart:bipolar'] = 'Bare bipolare';
$string['chart:hbar'] = 'Bare orizontale';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Trandafir';
$string['chart:type'] = 'Tipul graficului';
$string['chart:type_help'] = 'Selectați tipul de diagramă pe care doriți să îl utilizați pentru acest feedback';
$string['chart:vprogress'] = 'Bara de progres verticală';
$string['checkallradiobuttons'] = 'Vă rugăm să verificați butoanele radio <strong>{$a}</strong>!';
$string['checkboxes'] = 'Casete de bifat';
$string['checkboxes_help'] = 'Introduceți câte o opțiune pe linie, pentru ca utilizatorul să selecteze unul sau mai multe răspunsuri.';
$string['checkboxes_link'] = 'mod/chestionar/întrebări#Casete_de_bifat';
$string['checkbreaksadded'] = 'Noile întreruperi de pagină inserate în poziția (pozițiile):';
$string['checkbreaksok'] = 'Toate întreruperile de pagină necesare sunt prezente!';
$string['checkbreaksremoved'] = 'S-au eliminat {$a} întreruperi suplimentare de pagină.';
$string['checknotstarted'] = 'Selectarea nu a fost începută';
$string['checkstarted'] = 'Selectarea a fost începută';
$string['clicktoswitch'] = '(faceți click, pentru a comuta)';
$string['closed'] = 'Chestionarul a fost închis pe {$a}. Vă mulțumim.';
$string['closedate'] = 'Dată închidere';
$string['closeson'] = 'Chestionarul se închide pe {$a}';
$string['completionsubmit'] = 'Studentul trebuie să trimită acest chestionar, pentru a-l completa';
$string['condition'] = 'Condiție';
$string['confalts'] = '- SAU - <br />Pagina de confirmare';
$string['configmaxsections'] = 'Nr. maxim de secțiuni de feedback';
$string['configusergraph'] = 'Afișați diagrame pentru feedback-ul „Test de personalitate”';
$string['configusergraphlong'] = 'Utilizați biblioteca <a href="http://www.rgraph.net/">Rgraph</a>, pentru a afișa diagrame de feedback „Test de personalitate”.';
$string['confirmdelallresp'] = 'Sigur doriți să ștergeți TOATE răspunsurile din acest chestionar?';
$string['confirmdelchildren'] = 'Dacă ștergeți această întrebare, vor fi șterse și întrebările secundare:';
$string['confirmdelgroupresp'] = 'Sigur doriți să ștergeți TOATE răspunsurile de la {$a}?';
$string['confirmdelquestion'] = 'Sigur doriți să ștergeți întrebarea din poziția {$a}?';
$string['confirmdelquestionresps'] = 'Acest lucru va șterge, de asemenea, răspunsul {$a} dat deja la întrebarea respectivă.';
$string['confirmdelresp'] = 'Sigur doriți să ștergeți răspunsul până la&nbsp;{$a}&nbsp;?';
$string['confpage'] = 'Text antet';
$string['confpage_help'] = 'Antetul (cu caractere aldine) și corpul textului pentru pagina „Confirmare” se afișează după ce un utilizator completează acest chestionar. (URL-ul, dacă este prezent, are prioritate față de textul de confirmare.) Dacă lăsați acest câmp gol, în timpul completării chestionarului va fi afișat un mesaj implicit (Vă mulțumim că ați completat acest chestionar).';
$string['confpagedesc'] = 'Antetul (cu caractere aldine) și corpul textului pentru &quot;Confirmare&quot; pagina se afișează, după ce un utilizator completează acest chestionar. (URL-ul, dacă este prezent, are prioritate față de textul de confirmare.)';
$string['contentoptions'] = 'Opțiuni de conținut';
$string['couldnotcreatenewsurvey'] = 'Nu s-a reușit crearea unui nou sondaj!';
$string['couldnotdelresp'] = 'Nu s-a putut șterge răspunsul';
$string['createcontent'] = 'Definiți conținut nou';
$string['createcontent_help'] = 'Selectați una dintre opțiunile butonului radio. Valoarea implicită este \'Creați un nou\'.';
$string['createcontent_link'] = 'mod/chestionar/mod#Opțiuni_Conținut';
$string['createnew'] = 'Creați un chestionar nou';
$string['crontask'] = 'Sarcină curățare chestionar';
$string['date'] = 'Data';
$string['date_help'] = 'Utilizați acest tip de întrebare, dacă vă așteptați ca răspunsul să fie o dată formatată corect.';
$string['date_link'] = 'mod/chestionar/întrebări#Data';
$string['dateformatting'] = 'Folosiți formatul zi/lună/an, de ex. pentru 14 martie 1945:&nbsp; <strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Ștergeți TOATE răspunsurile';
$string['deletecurrentquestion'] = 'Ștergeți întrebarea {$a}';
$string['deletedallgroupresp'] = 'Au fost șterse TOATE răspunsurile din grupul {$a}';
$string['deletedallresp'] = 'Răspunsurile la chestionar au fost șterse';
$string['deletedisabled'] = 'Acest articol nu poate fi șters';
$string['deletedresp'] = 'Răspunsul a fost șters';
$string['deleteresp'] = 'Ștergeți acest răspuns';
$string['deletesection'] = 'Șterge această secțiune';
$string['deletingresp'] = 'Răspunsul este șters';
$string['dependencies'] = 'Dependențe';
$string['dependquestion'] = 'Întrebarea-părinte';
$string['dependquestion_help'] = 'Puteți selecta o întrebare-părinte și o opțiune de alegere pentru această întrebare. O întrebare-copil îi va fi afișată numai
                 studentului, dacă întrebarea-părinte și alegerea-părinte au fost selectate anterior.';
$string['dependquestion_link'] = 'mod/chestionar/întrebări#Întrebare_Parinte';
$string['directwarnings'] = 'Dependențele directe de această întrebare vor fi eliminate. Acest lucru va afecta:';
$string['displaymethod'] = 'Metoda de afișare nu a fost definită pentru întrebare.';
$string['download'] = 'Descărcați';
$string['downloadpdf'] = 'Descarcă PDF';
$string['downloadtextformat'] = 'Descărcați ca fișier CSV';
$string['downloadtextformat_help'] = 'Această funcție vă permite să salvați toate răspunsurile la un chestionar într-un fișier text (CSV).
  Acest fișier poate fi apoi importat într-o foaie de calcul (de exemplu, MS Excel sau Open Office Calc) sau un pachet statistic pentru prelucrarea ulterioară a datelor.';
$string['downloadtextformat_link'] = 'mod/chestionar/raport#Descărcare_în_format_text';
$string['dropdown'] = 'Caseta derulantă';
$string['dropdown_help'] = 'Nu există un avantaj real în utilizarea butoanelor radio în defavoarea casetei derulante
  cu excepția probabilă a listelor lungi de opțiuni, pentru a economisi spațiu pe ecran.';
$string['dropdown_link'] = 'mod/chestionar/întrebări#Caseta_derulantă';
$string['edit'] = 'Editare';
$string['editingquestionnaire'] = 'Setările de editare a chestionarului';
$string['editquestion'] = 'Editarea întrebării {$a}';
$string['email'] = 'Email';
$string['emailsend'] = 'Trimite rapoarte';
$string['errnewname'] = 'Ne pare rău, numele este deja utilizat. Alegeți un nume nou.';
$string['erroropening'] = 'Eroare la deschiderea chestionarului.';
$string['errortable'] = 'Eroare de sistem tabel corupt.';
$string['essaybox'] = 'Casetă eseu';
$string['essaybox_help'] = 'Această întrebare va afișa o casetă text simplă cu coloane x Textarea (sau lățimea zonei) și rândurile y Textarea (numărul de linii de text).

Dacă lăsați, atât x, cât și y la valoarea lor implicită 0 (sau dacă o setați la 0), atunci va fi afișat editorul HTML al moodle
  cu înălțime și lățime standard (dacă este disponibil în cursul/contextul utilizatorului și profilul utilizatorului).';
$string['event_all_responses_deleted'] = 'Toate răspunsurile au fost șterse';
$string['event_all_responses_saved_as_text'] = 'Toate răspunsurile au fost salvate ca text';
$string['event_all_responses_viewed'] = 'A fost vizualizat raportul cu toate răspunsurile';
$string['event_individual_responses_viewed'] = 'A fost vizualizat raportul cu răspunsurile individuale';
$string['event_non_respondents_viewed'] = 'Non-respondenți vizualizați';
$string['event_previewed'] = 'Chestionar previzualizat';
$string['event_question_created'] = 'Întrebarea a fost creată';
$string['event_question_deleted'] = 'Întrebarea a fost ștearsă';
$string['event_response_deleted'] = 'Răspuns individual șters';
$string['event_resumed'] = 'Încercarea a fost reluată';
$string['event_saved'] = 'Răspunsurile au fost salvate';
$string['event_submitted'] = 'Răspunsurile au fost trimise';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Ajutor Feedback';
$string['feedback_link'] = 'mod/chestionar/test_personalitate#Editare_mesaje_feedback_chestionar';
$string['feedbackaddmorefeedbacks'] = '{nu} mai adăugați câmpuri de feedback';
$string['feedbackbysection'] = 'Feedback Secțiuni';
$string['feedbackdefaultlabel'] = '[Secțiune nouă]';
$string['feedbackeditingglobal'] = 'Editarea chestionarului Feedback global';
$string['feedbackeditingmessages'] = 'Editarea mesajelor de feedback din chestionar';
$string['feedbackeditingsections'] = 'Editarea secțiunilor de feedback din chestionar';
$string['feedbackeditmessages'] = 'Salvați setările secțiunilor și editați mesajele de feedback';
$string['feedbackeditsections'] = 'Salvați setările și editați secțiunile de feedback';
$string['feedbackerrorboundaryformat'] = 'Limitele scorului de feedback trebuie să fie, ori un procent, ori un număr. Valoarea pe care ați introdus-o la limita {$a} nu este recunoscută.';
$string['feedbackerrorboundaryoutofrange'] = 'Limitele scorului de feedback trebuie să fie între 0% și 100%. Valoarea, pe care ați introdus-o la limita {$a}, se încadrează în afara intervalului.';
$string['feedbackerrorjunkinboundary'] = 'Trebuie să completați casetele limită ale scorului de feedback, fără a lăsa spații goale.';
$string['feedbackerrorjunkinfeedback'] = 'Trebuie să completați casetele de feedback, fără a lăsa spații goale.';
$string['feedbackerrororder'] = 'Limitele scorului de feedback trebuie să fie aranjate în ordine descrescătoare. Valoarea, pe care ați introdus-o la limita {$a}, se încadrează în afara secvenței.';
$string['feedbackglobal'] = 'Feedback global';
$string['feedbackglobalheading'] = 'Antet feedback global';
$string['feedbackglobalmessages'] = 'Mesaje feedback global';
$string['feedbackhdr'] = 'Feedback-uri';
$string['feedbackheading'] = 'Antet feedback';
$string['feedbackheading_help'] = 'În câmpul de antet de feedback puteți utiliza 2 variabile: $scorepercent și $oppositescorepercent.';
$string['feedbackmessages'] = 'mesaje secțiuni {$a}';
$string['feedbacknextsection'] = 'Secțiunea următoare {$a}';
$string['feedbacknone'] = 'Lipsă mesaje feedback';
$string['feedbacknotes'] = 'Note de feedback';
$string['feedbacknotes_help'] = 'Textul introdus aici va fi afișat respondenților la sfârșitul raportului de feedback';
$string['feedbackoptions'] = 'Opțiuni de feedback';
$string['feedbackoptions_help'] = 'Opțiunile de feedback sunt disponibile, dacă chestionarul dvs. conține următoarele tipuri de întrebări și setări de întrebări:
Butoane radio; Caseta derulantă; Da/Nu; sau Nota (scară normală sau Osgood). Aceste întrebări trebuie setate ca fiind Obligatorii, câmpul Nume întrebare NU trebuie să fie gol și opțiunile Răspunsuri posibile trebuie să conțină o valoare.';
$string['feedbackoptions_link'] = 'mod/chestionar/test_personalitate';
$string['feedbackremovequestionfromsection'] = 'Această întrebare face parte din secțiunea de feedback [{$a}]';
$string['feedbackremovesection'] = 'Eliminarea acestei întrebări va elimina complet secțiunea de feedback [{$a}]';
$string['feedbackreport'] = 'Raport de feedback';
$string['feedbackscore'] = 'Scorul de feedback';
$string['feedbackscoreboundary'] = 'Limita scorului de feedback';
$string['feedbackscores'] = 'Afișează scorurile';
$string['feedbackscores_help'] = 'Afișează tabelul scorurilor de feedback';
$string['feedbacksection'] = 'Secțiune';
$string['feedbacksectionheading'] = 'titlul secțiunii {$a}';
$string['feedbacksectionheadingmissing'] = 'Trebuie să introduceți un titlu pentru această secțiune de feedback!';
$string['feedbacksectionheadingtext'] = 'Titlu';
$string['feedbacksectionlabel'] = 'Etichetă';
$string['feedbacksectionlabel_help'] = 'Această etichetă va fi utilizată în diagrame. Vă rugăm să vă asigurați că este cât mai succintă!';
$string['feedbacksections'] = 'Secțiuni de feedback';
$string['feedbacksectionsselect'] = 'Secțiuni';
$string['feedbacksectionsselect_help'] = 'Plasați întrebările dvs. în acele secțiuni';
$string['feedbacksectionsselect_link'] = 'mod/chestionar/test_personalitate#Editarea_secțiunilor_cu_feedback_din_chestionar_2';
$string['feedbacksettingssaved'] = 'Setările de feedback au fost salvate';
$string['feedbacktype'] = 'Tipul de feedback';
$string['field'] = 'Întrebarea {$a}';
$string['fieldlength'] = 'Lungimea casetei de introducere a datelor';
$string['fieldlength_help'] = 'Pentru tipul de întrebare **Casetă de text**, introduceți **Lungimea casetei de introducere a datelor** și **Lungimea maximă a textului** a textului care trebuie introdus de respondent.

Valorile implicite sunt 20 de caractere pentru lățimea casetei de intrare și 25 de caractere pentru lungimea maximă a textului introdus.';
$string['finished'] = 'Ați răspuns la toate întrebările din acest chestionar!';
$string['firstrespondent'] = 'Primul respondent';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Text simplu';
$string['grade'] = 'Nota pentru completarea chestionarului';
$string['gradesdeleted'] = 'Notele din chestionar au fost șterse';
$string['headingtext'] = 'Text antet';
$string['horizontal'] = 'Orizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Include codurile opțiunilor';
$string['includechoicetext'] = 'Include textul aferent opțiunilor';
$string['includeincomplete'] = 'Include răspunsurile incomplete';
$string['incorrectcourseid'] = 'ID-ul cursului este incorect';
$string['incorrectmodule'] = 'ID-ul modulului de curs a fost incorect';
$string['incorrectquestionnaire'] = 'Chestionarul este incorect';
$string['indirectwarnings'] = 'Această listă prezintă întrebările dependente indirecte și dependențele rămase pentru întrebările dependente directe:';
$string['invalidresponse'] = 'A fost specificat un răspuns invalid.';
$string['invalidresponserecord'] = 'A fost specificată o înregistrare de răspuns invalidă.';
$string['invalidsurveyid'] = 'ID-ul chestionarului este invalid.';
$string['kindofratescale'] = 'Tipul de scală al evaluării';
$string['kindofratescale_help'] = 'Faceți click dreapta pe link-ul Mai mult ajutor de mai jos.';
$string['kindofratescale_link'] = 'mod/chestionar/întrebări#Tipul_de_scală_al_evaluării';
$string['lastrespondent'] = 'Ultimul respondent';
$string['length'] = 'Lungime';
$string['managequestions'] = 'Gestionați întrebările';
$string['managequestions_help'] = 'În secțiunea Gestionare întrebări din pagina Editare întrebări, puteți efectua o serie de operații în baza întrebărilor dintr-un Chestionar.';
$string['managequestions_link'] = 'mod/chestionar/întrebări#Gestiune_întrebări';
$string['mandatory'] = 'Obligatoriu - Toate aceste dependențe trebuie îndeplinite.';
$string['maxdigitsallowed'] = 'Nr. maxim de cifre permise';
$string['maxdigitsallowed_help'] = 'Utilizați **Nr. maxim de cifre permise**, pentru a seta o limită la numărul de caractere introduse în cazul unei Întrebări numerice. Rețineți că punctul zecimal se numără tot ca un singur caracter!';
$string['maxdigitsallowed_link'] = 'mod/chestionar/întrebări#Numeric';
$string['maxforcedresponses'] = 'Nr. maxim de răspunsuri forțate';
$string['maxforcedresponses_help'] = 'Folosiți acești parametri, pentru a-l forța pe respondent să bifeze un număr minim de casete **Min.** și un număr maxim de casete **Max.**. Pentru a
forța bifarea unui număr exact de casete, setați **Min.** și **Max.** la aceeași valoare. Dacă se dorește doar o valoare minimă sau maximă, lăsați cealaltă
valoare la valoarea implicită **0**. Dacă setați **Min.** sau **Max.** la alte valori decât valoarea lor implicită **0**, va fi afișat un mesaj de avertizare dacă
respondentul nu respectă cerințele dvs. Evident, trebuie să-i explicați clar respondentului toate cerințele, fie în instrucțiunile generale din
Chestionarul dvs., fie în textul întrebărilor relevante.';
$string['maxtextlength'] = 'Lungimea max. a textului';
$string['maxtextlength_help'] = 'Pentru tipul de întrebare Casetă text, introduceți lungimea casetei de introducere a datelor și lungimea maximă a textului care trebuie introdusă de respondent.
Valorile implicite sunt de 20 de caractere pentru lățimea casetei de introducere a datelor și 25 de caractere pentru lungimea maximă a textului introdus.';
$string['messageprovider:message'] = 'Memento chestionar';
$string['messageprovider:notification'] = 'Trimiterea chestionarului';
$string['minforcedresponses'] = 'Nr. min. de răspunsuri forțate';
$string['minforcedresponses_help'] = 'Folosiți acești parametri, pentru a-l forța pe respondent să bifeze un număr minim de casete **Min.** și un număr maxim de casete **Max.**. Pentru a
forța bifarea unui număr exact de casete, setați **Min.** și **Max.** la aceeași valoare. Dacă se dorește doar o valoare minimă sau maximă, lasă cealaltă
valoare la valoarea implicită **0**. Dacă setați **Min.** sau **Max.** la alte valori decât valoarea lor implicită **0**, va fi afișat un mesaj de avertizare, dacă
respondentul nu respectă cerințele dvs. Evident, trebuie să-i explicați respondentului toate cerințele, fie în instrucțiunile generale din
Chestionarul dvs., fie în textul întrebărilor relevante.';
$string['misconfigured'] = 'Cursul este configurat greșit';
$string['missingname'] = 'Întrebarea {$a} nu poate fi utilizată în această secțiune de feedback, deoarece nu are un nume.';
$string['missingnameandrequired'] = 'Întrebarea {$a} nu poate fi utilizată în această secțiune de feedback, deoarece nu are un nume și nu este obligatorie.';
$string['missingquestion'] = 'Vă rugăm să răspundeți la întrebarea obligatorie';
$string['missingquestions'] = 'Vă rugăm să răspundeți la întrebările obligatorii:';
$string['missingrequired'] = 'Întrebarea {$a} nu poate fi utilizată în această secțiune de feedback, deoarece nu este obligatorie.';
$string['modulename'] = 'Chestionar';
$string['modulename_help'] = 'Modulul chestionar vă permite să construiți sondaje folosind o varietate de tipuri de întrebări, în scopul colectării datelor de la utilizatori.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Chestionare';
$string['movedisabled'] = 'Acest articol nu poate fi mutat';
$string['myresponses'] = 'Toate răspunsurile dvs.';
$string['myresponsetitle'] = 'Răspunsul(-urile) {$a} dvs.';
$string['myresults'] = 'Rezultatele dvs.';
$string['name'] = 'Nume';
$string['navigate'] = 'Permiteți întrebări ramificate';
$string['navigate_help'] = 'Activați întrebările Da/Nu și Butoanele radio, pentru a lega întrebările de tip copil de alegerile lor din chestionarul dvs.';
$string['navigate_link'] = 'mod/chesetionar/ramificare_condiționată';
$string['next'] = 'Următorul';
$string['nextpage'] = 'Pagina următoare';
$string['nlines'] = '{$a} linii';
$string['noanswer'] = 'Niciun răspuns';
$string['noattempts'] = 'Nu s-a încercat completarea acestui chestionar';
$string['nodata'] = 'Nu există date publicate.';
$string['noduplicates'] = 'Nu există opțiuni duplicat';
$string['noduplicateschoiceserror'] = 'Trebuie să introduceți cel puțin 2 răspunsuri posibile pentru opțiunea „Nu există opțiuni duplicat!”';
$string['non_respondents'] = 'Utilizatorii care nu și-au trimis încă răspunsurile la acest chestionar';
$string['noneinuse'] = 'Acest chestionar nu conține nicio întrebare.';
$string['nopublicsurveys'] = 'Nu există chestionare publice.';
$string['noresponsedata'] = 'Nu există răspunsuri pentru această întrebare.';
$string['noresponses'] = 'Nu există răspunsuri';
$string['normal'] = 'Normal';
$string['not_started'] = 'nu a început';
$string['notanumber'] = '<strong>{$a}</strong> nu este un format de număr acceptat.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'Coloana N/A';
$string['notavail'] = 'Acest chestionar nu mai este disponibil. Rugați-l pe profesor să-l șteargă.';
$string['noteligible'] = 'Nu sunteți eligibil, pentru a completa acest chestionar.';
$string['notemplatesurveys'] = 'Nu există chestionare-șablon.';
$string['notenoughscaleitems'] = 'Trebuie să introduceți o valoare minimă de 2 articole la scară!';
$string['notificationfull'] = 'Chestionarul completat de cursant';
$string['notifications'] = 'Trimiteți notificări de completare a chestionarului';
$string['notifications_help'] = 'Notificați rolurile cu capacitatea „mod/chestionar:notificaredepunere”, atunci când se face o trimitere.';
$string['notifications_link'] = 'mod/chestionar/mod#Depunere_Notificări';
$string['notificationsimple'] = 'Doar notificare de completare';
$string['notopen'] = 'Acest chestionar nu se va deschide până la {$a}.';
$string['notrequired'] = 'Răspunsul nu este necesar';
$string['notset'] = 'nu a fost setat';
$string['nousersselected'] = 'Niciun utilizator selectat';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} încercări de completare a acestui chestionar';
$string['numberfloat'] = 'Numărul pe care l-ați introdus strong>{$a->number}</strong> a fost reformatat/ rotunjit cu <strong>{$a->precizie}</strong> zecimale.';
$string['numberofdecimaldigits'] = 'Nr. de cifre zecimale';
$string['numberofdecimaldigits_help'] = 'Utilizați **Nr de cifre zecimale**, pentru a specifica formatul valorii medii numărate și afișate în pagina Raport chestionar.';
$string['numberofdecimaldigits_link'] = 'mod/chestionar/întrebări#Numeric';
$string['numberscaleitems'] = 'Număr de elemente de scală';
$string['numberscaleitems_help'] = 'Nr de articole la scară este *numărul de articole* care trebuie utilizat în scala dvs. de evaluare. În mod normal, veți folosi o valoare de la 3 la 5. Valoare implicită: **5**.';
$string['numeric'] = 'Numeric';
$string['numeric_help'] = 'Utilizați acest tip de întrebare, dacă vă așteptați ca răspunsul să fie un număr formatat corect.';
$string['of'] = 'de';
$string['opendate'] = 'Dată deschidere';
$string['option'] = 'opțiunea {$a}';
$string['optional'] = 'Opțional - Cel puțin una dintre aceste dependențe trebuie îndeplinită.';
$string['optionalname'] = 'Numele întrebării';
$string['optionalname_help'] = 'Numele întrebării este utilizat, numai atunci când exportați răspunsuri în format CSV/Excel.
  Dacă nu exportați niciodată în CSV, nu trebuie să vă faceți griji cu privire la numele întrebărilor.
  Dacă intenționați să exportați în mod regulat datele chestionarului în CSV, aveți la dispoziție două opțiuni pentru numele întrebărilor.';
$string['optionalname_link'] = 'mod/chestionar/întrebări#Numele_Întrebării';
$string['or'] = '- SAU -';
$string['order_ascending'] = 'Ordine crescătoare';
$string['order_default'] = 'Vizualizare ordine implicită';
$string['order_descending'] = 'Ordinea descrescătoare';
$string['orderresponses'] = 'Ordinea răspunsurilor';
$string['orderresponses_help'] = 'Atunci când afișați Toate răspunsurile, puteți ordona opțiunile după numărul de răspunsuri (coloana Medie) pentru următoarele
  4 tipuri de întrebări.

* buton radio selecție unică
* listă derulantă selecție unică
* opțiuni multiple (bifare casete)
* întrebări de evaluare (inclusiv scale Likert).

Când ajungeți pe pagina Toate răspunsurile, toate răspunsurile sunt în mod implicit ordonate în ordinea în care creatorul chestionarului a introdus opțiunile aferente întrebărilor.
  Puteți alege să le aranjați în ordine crescătoare sau descrescătoare.';
$string['orderresponses_link'] = 'mod/chestionar/raport#Ordonare_Răspunsuri';
$string['osgood'] = 'Osgood';
$string['other'] = 'Alte:';
$string['otherempty'] = 'Dacă bifați această opțiune, trebuie să introduceți un text în caseta de text!';
$string['overviewnumresplog'] = 'răspunsuri';
$string['overviewnumresplog1'] = 'răspuns';
$string['overviewnumrespvw'] = 'răspunsuri';
$string['overviewnumrespvw1'] = 'răspuns';
$string['owner'] = 'Proprietar';
$string['page'] = 'Pagină';
$string['pageof'] = 'Pagină {$a->pagină} din {$a->totpagini}';
$string['parent'] = 'Părinte';
$string['participant'] = 'Participant';
$string['pleasecomplete'] = 'Vă rugăm să completați această opțiune.';
$string['pluginadministration'] = 'Administrarea chestionarului';
$string['pluginname'] = 'Chestionar';
$string['position'] = 'poziție';
$string['possibleanswers'] = 'Răspunsuri posibile';
$string['posteddata'] = 'Pagină accesată cu date postate:';
$string['preview_label'] = 'Previzualizare';
$string['preview_questionnaire'] = 'Previzualizarea chestionarului';
$string['previewing'] = 'Previzualizarea chestionarului';
$string['previous'] = 'Precedent';
$string['previouspage'] = 'Pagina precedentă';
$string['print'] = 'Tipăriți acest răspuns';
$string['printblank'] = 'Imprimare implicită';
$string['printblanktooltip'] = 'Deschide fereastra pentru imprimare cu chestionar necompletat';
$string['printtooltip'] = 'Deschide fereastra pentru imprimantă cu răspunsul curent';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Un răspuns la întrebări cu alegere multiplă.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID-ul unei înregistrări de alegere pentru acest răspuns.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Un răspuns la întrebare cu o singură alegere.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID-ul înregistrării alegerii pentru acest răspuns.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response'] = 'Un răspuns în curs sau trimis';
$string['privacy:metadata:questionnaire_response:complete'] = 'Starea de finalizare a răspunsului.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Nota pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Marcajul de timp pentru cea mai recentă salvare pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID-ul utilizatorului pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Un răspuns boolean (da/nu) la întrebare.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Răspunsul specific boolean.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_date'] = 'Un răspuns la întrebarea dată.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Răspunsul la data specifică.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_other'] = 'Un răspuns text cu \'altă\' alegere.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID-ul înregistrării alegerii pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Răspunsul textului specific.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Un răspuns la întrebarea de rang.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID-ul înregistrării alegerii pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Răspunsul specific la rang.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_text'] = 'Un răspuns la întrebare text.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID-ul înregistrării întrebării pentru acest răspuns.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Răspunsul textului specific.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID-ul înregistrării de răspuns pentru acest răspuns.';
$string['private'] = 'Privat';
$string['progressbar'] = 'Afișare bară de progres';
$string['public'] = 'Public';
$string['publiccopy'] = 'Copiere:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Tip de răspuns';
$string['qtype_help'] = 'Selectați dacă utilizatorilor li se va permite să răspundă o dată, zilnic, săptămânal, lunar sau de un număr nelimitat de ori (de multe ori).';
$string['qtypedaily'] = 'Răspundeți zilnic';
$string['qtypemonthly'] = 'Răspundeți lunar';
$string['qtypeonce'] = 'Răspundeți o singură dată';
$string['qtypeunlimited'] = 'răspuneți de multe ori';
$string['qtypeweekly'] = 'Răspundeți săptămânal';
$string['questionnaire:addinstance'] = 'Adăugați un chestionar nou';
$string['questionnaire:copysurveys'] = 'Copiați șablonul și chestionarele private';
$string['questionnaire:createpublic'] = 'Creați chestionare publice';
$string['questionnaire:createtemplates'] = 'Creați șabloane de chestionare';
$string['questionnaire:deleteresponses'] = 'Ștergeți orice răspuns';
$string['questionnaire:downloadresponses'] = 'Descărcați răspunsurile într-un fișier CSV';
$string['questionnaire:editquestions'] = 'Creați și editați întrebări din chestionar';
$string['questionnaire:manage'] = 'Creați și editați chestionare';
$string['questionnaire:message'] = 'Trimiteți mesaj non-respondenților';
$string['questionnaire:preview'] = 'Previzualizare chestionare';
$string['questionnaire:printblank'] = 'Imprimare chestionar necompletat';
$string['questionnaire:readallresponseanytime'] = 'Citiți toate răspunsurile oricând';
$string['questionnaire:readallresponses'] = 'Citiți rezumate de răspuns, sub rezerva orelor de deschidere';
$string['questionnaire:readownresponses'] = 'Citiți propriile răspunsuri';
$string['questionnaire:submissionnotification'] = 'Primiți o notificare pentru fiecare trimitere';
$string['questionnaire:submit'] = 'Completați și trimiteți un chestionar';
$string['questionnaire:view'] = 'Vizualizați un chestionar';
$string['questionnaire:viewsingleresponse'] = 'Vizualizați răspunsuri individuale complete';
$string['questionnaireadministration'] = 'Administrarea chestionarului';
$string['questionnairecloses'] = 'Chestionarul se închide';
$string['questionnaireopens'] = 'Chestionarul se deschide';
$string['questionnairereport'] = 'Raport chestionar';
$string['questionnum'] = 'Întrebarea #';
$string['questions'] = 'Întrebări';
$string['questionsinsection'] = 'Întrebările din această secțiune:';
$string['questiontypes'] = 'Tipuri de întrebări';
$string['questiontypes_help'] = 'Consultați documentația Moodle de mai jos';
$string['questiontypes_link'] = 'mod/chestionar/întrebări#Tipurile_de_întrebări';
$string['radiobuttons'] = 'Butoane radio';
$string['radiobuttons_help'] = 'În acest tip de întrebare, respondentul trebuie să selecteze una dintre opțiunile oferite.';
$string['radiobuttons_link'] = 'mod/chestionar/întrebări#Butoane_radio';
$string['rank'] = 'Clasament';
$string['ratescale'] = 'Acordați o notă (scală 1...5)';
$string['ratescale_help'] = 'Consultați documentația Moodle de mai jos';
$string['ratescale_link'] = 'mod/chestionar/întrebări#Acordați_o_notă_.28scara_1..5.29';
$string['realm'] = 'Tip de chestionar';
$string['realm_help'] = '* **Există trei tipuri de chestionare:**
 * Privat - aparține cursului în care este doar definit.
 * Șablon - poate fi copiat și editat.
 * Public - poate fi partajat între cursuri.';
$string['realm_link'] = 'mod/chestionar/Setări#Tipul_de_întrebare';
$string['redirecturl'] = 'Adresa URL către care este redirecționat un utilizator după completarea acestui chestionar.';
$string['remove'] = 'Ștergere';
$string['removeallquestionnaireattempts'] = 'Ștergeți toate răspunsurile la chestionar';
$string['removenotinuse'] = 'Acest chestionar depindea de un chestionar public care a fost șters.
Nu mai poate fi folosit și trebuie șters.';
$string['required'] = 'Este necesar un răspuns';
$string['required_help'] = 'Dacă selectați ***Da***, va fi necesar un răspuns la această întrebare, adică
respondentul nu va putea trimite chestionarul
fără a răspunde la această întrebare.';
$string['required_link'] = 'mod/chestionar/întrebări#Răspunsul_este_necesar';
$string['requiredparameter'] = 'Lipsea un parametru obligatoriu.';
$string['reset'] = 'Resetare';
$string['respeligiblerepl'] = '(înlocuit de suprascrierea rolurilor)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'toate';
$string['respondenteligiblestudents'] = 'numai studenți';
$string['respondenteligibleteachers'] = 'numai profesori';
$string['respondents'] = 'Respondenți';
$string['respondenttype'] = 'Tipul respondentului';
$string['respondenttype_help'] = 'Nume complet: afișează numele complet al cursanților care au completat chestionarul.
Anonim: nu se va afișa numele cursanților care au completat chestionarul.';
$string['respondenttype_link'] = 'mod/chestionar/mod#Tip_respondent';
$string['respondenttypeanonymous'] = 'Anonim';
$string['respondenttypefullname'] = 'Nume complet';
$string['response'] = 'Răspuns';
$string['responsefieldlines'] = 'Introduceți dimensiunea casetei';
$string['responseformat'] = 'Format de răspuns';
$string['responseoptions'] = 'Opțiuni de răspuns';
$string['responses'] = 'Răspunsuri';
$string['responseview'] = 'Vizualizare rezumat răspunsuri';
$string['responseview_help'] = 'Puteți specifica cine poate vedea răspunsurile tuturor respondenților la chestionarele trimise (tabele statistice generale).';
$string['responseview_link'] = 'mod/chestionar/mod#Vizualizare_răspunsuri';
$string['responseviewstudentsalways'] = 'Întotdeauna';
$string['responseviewstudentsnever'] = 'Niciodată';
$string['responseviewstudentswhenanswered'] = 'După completarea chestionarului';
$string['responseviewstudentswhenclosed'] = 'După închiderea chestionarului';
$string['restrictedtoteacher'] = 'Aceste funcții sunt limitate doar la profesorii cu drepturi de editare!';
$string['resume'] = 'Salvați/ Continuați răspunsurile';
$string['resume_help'] = 'Setarea acestei opțiuni le permite utilizatorilor să-și salveze răspunsurile la un chestionar, înainte de a le trimite. Utilizatorii pot lăsa chestionarul neterminat și pot să-l reia de unde au rămas la o dată ulterioară.';
$string['resume_link'] = 'mod/chestionar/mod#Salvare/Reluare_răspunsuri';
$string['resumesurvey'] = 'Reluare chestionar';
$string['return'] = 'Reluare';
$string['save'] = 'Salvare';
$string['saveasnew'] = 'Salvează ca întrebare nouă';
$string['savedbutnotsubmitted'] = 'Acest chestionar a fost salvat, dar nu a fost încă trimis.';
$string['savedprogress'] = 'Progresul dvs. a fost salvat. Puteți reveni oricând, pentru a completa acest chestionar.';
$string['saveeditedquestion'] = 'Salvați întrebarea {$a}';
$string['savesettings'] = 'Salvați setările';
$string['search:activity'] = 'Chestionar - informații despre activitate';
$string['search:question'] = 'Chestionar - întrebări';
$string['section'] = 'Descriere';
$string['sectionbreak'] = '----- Întrerupere pagină -----';
$string['sectionbreak_help'] = '----- Întrerupere pagină -----';
$string['sectionsnotset'] = 'Trebuie să selectați cel puțin o întrebare pentru fiecare secțiune! <br /> Secțiunea (secțiunile) nu este (sunt) selectată(e): {$a}';
$string['sectiontext'] = 'Etichetă';
$string['sectiontext_help'] = 'Aceasta nu este o întrebare, ci un text (scurt) care va fi afișat, pentru a introduce o serie de întrebări.';
$string['selecttheme'] = 'Selectați o temă (CSS) pe care să o utilizați în cadrul acestui chestionar.';
$string['send'] = 'Trimitere';
$string['send_message'] = 'Trimiteți mesaj utilizatorilor selectați';
$string['send_message_to'] = 'Trimiteți mesajul către:';
$string['sendemail'] = 'Trimitere email';
$string['sendemail_help'] = 'Furnizează o copie a fiecărei trimiteri la adresa sau adresele specificate.
Puteți furniza mai multe adrese, separându-le cu virgule.
Lăsați necompletat, pentru a nu face backup de e-mail.';
$string['set'] = 'setare';
$string['settings'] = 'Setări';
$string['settingssaved'] = 'Setările au fost salvate';
$string['show_nonrespondents'] = 'Non-respondenți';
$string['started'] = 'început';
$string['strfdate'] = '%z/%l/%A';
$string['strfdateformatcsv'] = 'z/l/A O:i:s';
$string['subject'] = 'Subiect';
$string['submissionnotificationhtmlanon'] = 'Există o nouă <a href="{$a->submissionurl}">trimitere</a> la chestionarul „{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> are un nou <a href="{$a->submissionurl}">submission</a> către "{$a->name}" chestionarul din cursul "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Trimiterea unui chestionar nou';
$string['submissionnotificationtextanon'] = 'Există o nouă trimitere ({$a->submissionurl}) la chestionarul „{$a->name}”.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) are o nouă trimitere ({$a->submissionurl}) la "{$a->name}" chestionarul din cursul "{$a->coursename}".';
$string['submitoptions'] = 'Opțiuni de trimitere';
$string['submitpreview'] = 'Trimiteți previzualizarea';
$string['submitpreviewcorrect'] = 'Această trimitere va fi acceptată ca fiind completată corect.';
$string['submitsurvey'] = 'Trimiteți chestionarul';
$string['submitted'] = 'Trimis pe:';
$string['subtitle'] = 'Subtitlu';
$string['subtitle_help'] = 'Subtitlul acestui chestionar. Apare sub titlu numai pe prima pagină.';
$string['summary'] = 'Rezumat';
$string['surveynotexists'] = 'chestionarul nu există.';
$string['surveyowner'] = 'Trebuie să fiți proprietarul unui chestionar, pentru a efectua această operațiune.';
$string['surveyresponse'] = 'Răspunsul din chestionar';
$string['template'] = 'Șablon';
$string['templatenotviewable'] = 'Chestionarele-șablon nu sunt vizibile.';
$string['text'] = 'Textul întrebării';
$string['textareacolumns'] = 'Coloane Suparafatatext';
$string['textareacolumns_help'] = 'Această întrebare va afișa o casetă de text simplu cu **x** *Coloane suprafațatext* (sau zonă *lățime*) * și **y** *Rânduri suprafațatext* (numărul de *linii* text).
Dacă lăsați, atât x, cât și y la valoarea lor implicită **0** (sau dacă o setați la **0**), editorul HTML va fi afișat cu înălțimea și lățimea standard (dacă
este disponibil în contextul cursului/utilizatorului &amp; profilul utilizatorului).';
$string['textarearows'] = 'Rânduri suprafațatext';
$string['textbox'] = 'Casetă de text';
$string['textbox_help'] = 'Pentru tipul de întrebare Casetă text, introduceți lungimea casetei de introducere a datelor și lungimea maximă a textului care trebuie introdus de respondent.
Valorile implicite sunt de 20 de caractere pentru lățimea casetei de introducere a datelor și 25 de caractere pentru lungimea maximă a textului introdus.';
$string['textdownloadoptions'] = 'Opțiuni pentru descărcarea CSV';
$string['thank_head'] = 'Vă mulțumim pentru completarea acestui chestionar.';
$string['theme'] = 'Temă';
$string['thismonth'] = 'luna curentă';
$string['thisresponse'] = 'Acest răspuns';
$string['thisweek'] = 'săptămâna aceasta';
$string['title'] = 'Titlu';
$string['title_help'] = 'Titlul acestui chestionar, care va apărea în partea de sus a fiecărei pagini. În mod implicit, Titlul este setat la Numele chestionarului, dar îl puteți edita după cum doriți.';
$string['today'] = 'astăzi';
$string['total'] = 'Total';
$string['type'] = 'Tipul de întrebare';
$string['undefinedquestiontype'] = 'Tipul de întrebare nedefinit!';
$string['unknown'] = 'Necunoscut';
$string['unknownaction'] = 'A fost specificată o acțiune necunoscută cu privire la chestionar...';
$string['url'] = 'Adresa URL de confirmare';
$string['url_help'] = 'Adresa URL către care este redirecționat un utilizator după completarea acestui chestionar.';
$string['useprivate'] = 'Copiați un chestionar existent';
$string['usepublic'] = 'Folosiți public';
$string['usetemplate'] = 'Folosiți șablonul';
$string['vertical'] = 'Vertical';
$string['view'] = 'Vizualizare';
$string['viewallresponses'] = 'Vizualizați toate răspunsurile';
$string['viewallresponses_help'] = 'Dacă chestionarul este setat la **Mod de grup**: *Grupuri vizibile* sau este setat la *Grupuri separate* și utilizatorul curent
  are capacitatea *moodle/site:accesațitoategrupurile* (în contextul actual), iar grupurile au fost definite în cursul curent,
  atunci utilizatorul are acces la o listă derulantă de grupuri. Această listă derulantă îi permite utilizatorului să „filtreze” răspunsurile la chestionare pe grupuri.
  Dacă setarea este **Mod de grup**: *Grupuri separate*, atunci utilizatorii care nu au capacitatea *moodle/site:accesațitoategrupurile*
  (de obicei studenți sau profesori care nu editează etc.) vor putea vizualiza doar răspunsurile grupului (grupurilor) de care aparțin.';
$string['viewallresponses_link'] = 'Vizualizare_Răspunsuri_Chestionar#Filtrare_grup';
$string['viewbyresponse'] = 'Lista de răspunsuri';
$string['viewindividualresponse'] = 'Răspunsuri individuale';
$string['viewindividualresponse_help'] = 'Faceți click pe numele respondenților din lista de mai jos, pentru a vizualiza răspunsurile lor individuale.';
$string['viewresponses'] = 'Toate răspunsurile ({$a})';
$string['viewyourresponses'] = 'Răspunsurile dvs.-vizualizare {$a}';
$string['warning'] = 'Atenție, a fost detectată o eroare.';
$string['wronganswers'] = 'Este ceva în neregulă cu răspunsurile dvs. (a se vedea mai jos)';
$string['wrongdateformat'] = 'Data introdusă: <strong>{$a}</strong> nu corespunde formatului afișat în exemplu.';
$string['wrongdaterange'] = 'EROARE! Anul trebuie să fie stabilit în intervalul 1902-2037.';
$string['wrongformat'] = 'Este ceva în neregulă cu răspunsul dvs. la întrebarea:&nbsp;';
$string['wrongformats'] = 'Este ceva în neregulă cu răspunsul dvs. la întrebările::&nbsp;';
$string['yesno'] = 'Da/ Nu';
$string['yesno_help'] = 'Întrebare simplă Da/ Nu.';
$string['yourresponse'] = 'Răspunsul dvs.';
$string['yourresponses'] = 'Răspunsurile dvs.';
