define("core/local/aria/focuslock",["exports","./selectors"],(function(_exports,_selectors){var obj;
/**
   * Tab locking system.
   *
   * This is based on code and examples provided in the ARIA specification.
   * https://www.w3.org/TR/wai-aria-practices/examples/dialog-modal/dialog.html
   *
   * @module     core/tablock
   * @copyright  2019 Andrew Nicols <andrew@nicols.co.uk>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.untrapFocus=_exports.trapFocus=void 0,_selectors=(obj=_selectors)&&obj.__esModule?obj:{default:obj};var lockRegionStack=[],initialFocusElementStack=[],finalFocusElementStack=[],lastFocus=null,ignoreFocusChanges=!1,isLocked=!1,lockHandler=function(event){if(!ignoreFocusChanges){for(var lockRegion=getCurrentLockRegion();lockRegion&&!document.contains(lockRegion);)untrapFocus(),lockRegion=getCurrentLockRegion();lockRegion&&(lockRegion.contains(event.target)?lastFocus=event.target:(focusFirstDescendant(),lastFocus==document.activeElement&&focusLastDescendant(),lastFocus=document.activeElement))}},focusFirstDescendant=function(){var lockRegion=getCurrentLockRegion(),focusableElements=Array.from(lockRegion.querySelectorAll(_selectors.default.elements.focusable));return focusableElements.unshift(lockRegion),focusableElements.some((function(focusableElement){return attemptFocus(focusableElement)}))},focusLastDescendant=function(){var lockRegion=getCurrentLockRegion(),focusableElements=Array.from(lockRegion.querySelectorAll(_selectors.default.elements.focusable)).reverse();return focusableElements.push(lockRegion),focusableElements.some((function(focusableElement){return attemptFocus(focusableElement)}))},attemptFocus=function(focusTarget){if(!function(focusTarget){if(focusTarget.tabIndex>0||0===focusTarget.tabIndex&&null!==focusTarget.getAttribute("tabIndex"))return!0;if(focusTarget.disabled)return!1;switch(focusTarget.nodeName){case"A":return!!focusTarget.href&&"ignore"!=focusTarget.rel;case"INPUT":return"hidden"!=focusTarget.type&&"file"!=focusTarget.type;case"BUTTON":case"SELECT":case"TEXTAREA":return!0;default:return!1}}(focusTarget))return!1;ignoreFocusChanges=!0;try{focusTarget.focus()}catch(e){}return ignoreFocusChanges=!1,document.activeElement===focusTarget},getCurrentLockRegion=function(){return lockRegionStack[lockRegionStack.length-1]};_exports.trapFocus=function(newLockRegion){if(function(newLockRegion){if(newLockRegion!==getCurrentLockRegion()){lockRegionStack.push(newLockRegion);var currentLockRegion=getCurrentLockRegion(),element=document.createElement("div");element.tabIndex=0,element.style.position="fixed",element.style.top=0,element.style.left=0;var initialNode=element.cloneNode();currentLockRegion.parentNode.insertBefore(initialNode,currentLockRegion),initialFocusElementStack.push(initialNode);var finalNode=element.cloneNode();currentLockRegion.parentNode.insertBefore(finalNode,currentLockRegion.nextSibling),finalFocusElementStack.push(finalNode)}}(newLockRegion),isLocked||document.addEventListener("focus",lockHandler,!0),!focusFirstDescendant()){var currentLockRegion=getCurrentLockRegion(),originalRegionTabIndex=currentLockRegion.tabIndex;currentLockRegion.tabIndex=0,attemptFocus(currentLockRegion),currentLockRegion.tabIndex=originalRegionTabIndex}lastFocus=document.activeElement,isLocked=!0};var untrapFocus=function(){!function(){lockRegionStack.pop();var finalNode=finalFocusElementStack.pop();finalNode&&finalNode.remove();var initialNode=initialFocusElementStack.pop();initialNode&&initialNode.remove()}(),lockRegionStack.length||(document.removeEventListener("focus",lockHandler,!0),lastFocus=null,ignoreFocusChanges=!1,isLocked=!1)};_exports.untrapFocus=untrapFocus}));

//# sourceMappingURL=focuslock.min.js.map