<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dyslexic', language 'es_mx', version '3.11'.
 *
 * @package     block_dyslexic
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['defaut_font'] = 'Tipo de letra (font) por defecto';
$string['dyslexic:addinstance'] = 'Añadir un bloque Mod disléctico';
$string['dyslexic:myaddinstance'] = 'Añadir un bloque Mod disléctico al Tablero';
$string['howto_description'] = 'El bloque Mod disléctico usa tecnología JavaScript para cambiar la visualización del sitio usando CSS.</br>La elección del usuario se almacena en \'cookie\'.';
$string['howto_title'] = 'Trabajando';
$string['info'] = '¿Qué es la dislexia?';
$string['intro'] = 'El tipo de letra (font) OpenDyslexic aumenta la legibilidad para los lectores con dislexia.</br>¿Cual tipo de letra (font) deseaba Usted usar ?';
$string['link'] = 'Lea más sobre el tipo de letra (font) OpenDyslexic';
$string['moving_description'] = 'Algunas personas disléxicas tienen esta impresión: ellos pueden leer, pero necesitan mucha concentración  porque las letras parecen moverse. Esta página le permite a Usted compartir esa sensación...';
$string['moving_title'] = '¿Porqué se está moviendo todo?';
$string['opendyslexic_font'] = 'OpenDyslexic font';
$string['pluginname'] = 'Módulo Disléxico';
$string['readmore'] = 'Lea más...';
$string['script_info'] = '\'Script\' para la animacion de la página de:';
$string['script_off'] = '¡Detener la animación!';
$string['script_on'] = 'Recargar la animación';
$string['wikipedia_description'] = 'La dislexia, también conocida como trastorno de lectura, se caracteriza por problemas con la lectura que no están relacionados con problemas con la inteligencia general. Diferentes personas se ven afectadas en diversos grados. Los problemas pueden incluir dificultades para deletrear palabras, leer rápidamente, escribir palabras, "pronunciar" palabras en la cabeza, pronunciar palabras cuando lee en voz alta y entender lo que se lee. A menudo estas dificultades se notan por primera vez en la escuela. Cuando alguien que antes podía leer pierde su habilidad, se lo conoce como alexia. Las dificultades son involuntarias y las personas con este trastorno tienen un deseo no afectado de aprender. </br>
Se cree que la causa de la dislexia involucra factores genéticos y ambientales. Algunos casos se ejecutan en familias. A menudo ocurre en personas con trastorno por déficit de atención con hiperactividad (TDAH) y se asocia con dificultades similares con los números. Puede comenzar en la edad adulta como el resultado de una lesión cerebral traumática, accidente cerebrovascular o demencia. Los mecanismos subyacentes son problemas dentro del procesamiento del lenguaje del cerebro. La dislexia se diagnostica a través de una serie de pruebas de memoria, ortografía, visión y habilidades de lectura. La dislexia está separada de las dificultades de lectura causadas por la enseñanza insuficiente; o problemas de audición o visión. </br>
El tratamiento implica ajustar los métodos de enseñanza para satisfacer las necesidades de la persona. Si bien no cura el problema subyacente, puede disminuir el grado de síntomas. Los tratamientos dirigidos a la visión no son efectivos. La dislexia es la discapacidad de aprendizaje más común, que afecta al 3-7% de la población; sin embargo, hasta un 20% puede tener algún grado de síntomas. Mientras que la dislexia se diagnostica con mayor frecuencia en los hombres, se ha sugerido que afecta a hombres y mujeres por igual. La dislexia ocurre en todas las áreas del mundo. Algunos creen que la dislexia debería considerarse mejor como una forma diferente de aprendizaje, con beneficios y desventajas.';
$string['wikipedia_title'] = 'Del artículo en la Wikipedia';
$string['wikipedia_url'] = 'https://es.wikipedia.org/wiki/Dislexia';
