<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'es_mx', version '3.11'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Acepto las <a href=":url" target="_blank">condiciones de uso</a>';
$string['accountdetailslinktext'] = 'aquí';
$string['action'] = 'Acción';
$string['add'] = 'Añadir';
$string['addedandupdatedpp'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedps'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P y se actualizó {$a->%old} antigua.';
$string['addedandupdatedsp'] = 'Se añadió {$a->%new} nueva biblioteca H5P y se actualizaron {$a->%old} antiguas.';
$string['addedandupdatedss'] = 'Se añadió {$a->%new} nueva biblioteca H5P y se actualizó {$a->%old} antigua.';
$string['addednewlibraries'] = 'Se añadieron {$a->%new} nuevas bibliotecas H5P.';
$string['addednewlibrary'] = 'Se añadió {$a->%new} nueva biblioteca H5P.';
$string['additionalinfo'] = 'Información adicional';
$string['additionallicenseinfo'] = 'Cualquier información adicional acerca de la licencia';
$string['addlibraries'] = 'Añadir bibliotecas';
$string['address'] = 'Dirección';
$string['age'] = 'Edad típica';
$string['agedescription'] = 'La audiencia destino de este contenido. Posiblemente formatos de ingresos separados por comas: "1,34-45,-50,59-".';
$string['ajaxfailed'] = 'Falló al cargar datos.';
$string['alttext'] = 'Texto alterno';
$string['anunexpectedsave'] = 'Pasó algo inesperado. No pudimos guardar este contenido.';
$string['assistivetechnologieslabel'] = 'Etiqueta de tecnología asistiva';
$string['attribution'] = 'Atribución 4.0';
$string['attributionnc'] = 'Atribución-NoComercial 4.0';
$string['attributionncnd'] = 'Atribución-NoComercial-NoDerivadas 4.0';
$string['attributionncsa'] = 'Atribución-NoComercial-CompartirIgual 4.0';
$string['attributionnd'] = 'Atribución-NoDerivadas 4.0';
$string['attributionsa'] = 'Atribución-CompartirIgual 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'comentarios del autor';
$string['authorcommentsdescription'] = 'Comentarios para el editor del contenido (Este texto no será publicado como una parte de la información sobre copyright)';
$string['authorname'] = 'Nombre del autor';
$string['authorrole'] = 'Rol del autor';
$string['back'] = 'Regresar';
$string['by'] = 'por';
$string['cancel'] = 'Cancelar';
$string['cancellabel'] = 'Cancelar';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'No';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Si';
$string['cancelpublishconfirmationdialogdescription'] = '¿Está seguro de querer cancelar el proceso de compartir?';
$string['cancelpublishconfirmationdialogtitle'] = 'Cancelar compartir';
$string['ccattribution'] = 'Atribución (CC BY)';
$string['ccattributionnc'] = 'Atribución-NoComercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Atribución-NoComercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atribución-NoComercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atribución-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Atribución-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Dedicación Dominio Público (CC0)';
$string['ccpdm'] = 'Marcado Dominio Público (PDM)';
$string['changedby'] = 'Cambiado por';
$string['changedescription'] = 'Descripción del cambio';
$string['changehasbeensubmitted'] = 'Un cambio ha sido enviado para';
$string['changelog'] = 'Bitácora_de_cambios';
$string['changeplaceholder'] = 'Foto recortada, texto cambiado, etc.';
$string['city'] = 'Ciudad';
$string['close'] = 'Cerrar';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completionpass_help'] = 'Si se habilita, esta actividad es considerada completada cuando el estudiante recibe una calificación aprobatoria (según sea especificada en la sección de Calificación de las configuraciones de H5P) o mayor.';
$string['completionpassdesc'] = 'El estudiante debe lograr una calificación aprobatoria para completar esta actividad';
$string['confirmdialogbody'] = 'Por favor, confirme que desea proceder. Esta acción no es reversible.';
$string['confirmdialogheader'] = 'Confirmar acción';
$string['confirmlabel'] = 'Confirmar';
$string['connectionlost'] = 'Conexión perdida. Los resultados serán almacenados y serán enviados cuando Usted recupere la conexión.';
$string['connectionreestablished'] = 'Conexión restablecida';
$string['contactperson'] = 'Persona para Contacto';
$string['contactpersondescription'] = 'H5P se pondrá en contacto con la Persona para Contacto en caso de que hubiera algún problema con el contenido compartido por el publicador. El nombre de la Persona para Contacto o cualquier otra información personal no será publicada ni compartida con terceros.';
$string['contentavailable'] = 'Su contenido normalmente estará disponible en el Hub dentro de un día hábil.';
$string['contentchanged'] = 'Ese contenido ha cambiado desde la última vez que Usted lo usó.';
$string['contentcopied'] = 'El contenido es copiado al portapapeles';
$string['contenthub:changesettings'] = 'Cambiar configuraciones de la cuenta <a href="{$a}">aquí</a>';
$string['contenthub:licenseagreementdescription'] = 'Por favor lea el siguiente acuerdo antes de proceder con el';
$string['contenthub:licenseagreementmaintext'] = 'TODO';
$string['contenthub:licenseagreementtitle'] = 'Acuerdo del Usuario Final (EULA)';
$string['contenthub:nopermissions'] = 'Usted no tiene permiso para registrar el sitio con el Hub de contenido.';
$string['contenthub:register'] = 'Registrar una cuenta con el Hub H5P <a href="{$a}">aquí</a>';
$string['contenthub:settings:box'] = 'Cuenta del Hub de Contenido';
$string['contenthub:settings:heading'] = 'Configuraciones de cuenta del Hub de Contenido';
$string['contenthubeditsharing'] = 'Editar información de compartición';
$string['contenthuboptions'] = 'Opciones del Hub H5P OER';
$string['contenthubshare'] = 'Compartir en el Hub H5P OER';
$string['contenthubsharinginprogress'] = 'Compartiendo...';
$string['contenthubsyncchanges'] = 'Sincronizar cambios';
$string['contenthubunshare'] = 'Des-compartir';
$string['contentissyncing'] = 'El contenido está siendo sincronizado.';
$string['contentlicensetitle'] = 'Información de Licencia del Contenido';
$string['contentnotshared'] = 'El contenido no está compartido en el Hub.';
$string['contentstatefrequency'] = 'Frecuencia para guardar estado del contenido';
$string['contentstatefrequency_help'] = 'En segundos, qué tan frecuente desea Usted que el usuario guarde automáticamente su progreso. Aumente este número si tiene problemas con muchas solicitudes Ajax';
$string['contenttype'] = 'Tipo de Contenido';
$string['contenttypecacheheader'] = 'Caché de Tipo de Contenido';
$string['contentupdatesoon'] = 'Su contenido se actualizará pronto';
$string['copyright'] = 'Derechos de uso';
$string['copyrightinfo'] = 'Información de copyright';
$string['copyrightstring'] = 'Derecho de autor (copyright)';
$string['copyrighttitle'] = 'Ver información de copyright para este contenido.';
$string['copyrightwarning'] = 'El contenido con Derechos Registrados (copyrighted) no puede ser compartido en el Hub de Contenido H5P. Si el contenido está licenciado con una licencia amistosa para OER (Recursos Educativos Abiertos) como Creative Commons, por favor elija la licencia apropiada. En caso contrario este contenido no puede ser compartido.';
$string['couldnotcopy'] = 'No pudo copiarse el archivo.';
$string['couldnotparsejsonfromzip'] = 'No se puede procesar JSON del paquete: %fileName';
$string['couldnotparsepostdata'] = 'No se pudo procesar datos publicados.';
$string['couldnotreadfilefromzip'] = 'No se puede leer archivo delpaquete: %fileName';
$string['couldnotsave'] = 'No pudo guardarse el archivo.';
$string['country'] = 'País';
$string['create'] = 'Crear';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Actualizar caché de tipo de contenido';
$string['ctcacheconnectionfailed'] = 'No pudo comunicarse con HUB H5P. Por favor inténtelo nuevamente más tarde.';
$string['ctcachedescription'] = 'Al asegurar que el caché de tipo de contenido está actualizado, se asegurará de que Usted pueda ver, descargar y usar las bibliotecas más nuevas. Esto es diferente de actualizar a las bibliotecas mismas.';
$string['ctcachelastupdatelabel'] = 'Última actualización';
$string['ctcacheneverupdated'] = 'Nunca';
$string['ctcachenolibraries'] = 'No se recibió ningun tipo de contenido del Hub H5P. Por favor inténtelo nuevamente más tarde';
$string['ctcachesuccess'] = '¡Caché de biblioteca fue actualizado exitosamente!';
$string['ctcachetaskname'] = 'Actualizar caché de tipo de contenido';
$string['currentpage'] = 'Página $current de $total';
$string['currentstep'] = 'Paso :step de :total';
$string['dataviewreportlabel'] = 'Ver respuestas';
$string['date'] = 'Fecha';
$string['description'] = 'Descripción';
$string['disablefileextensioncheck'] = 'Deshabilitar revisión de extensión del archivo';
$string['disablefileextensioncheckwarning'] = '¡Advertencia! El deshabilitar la revisión de la extensión del archivo puede tener implicaciones de seguridad, porque permite subir archivos PHP. Esto a su vez podría hacer posible que los atacantes ejecuten código malicioso en su sitio. Por favor, asegúrese de que sabe exactamente lo que está subiendo.';
$string['disablefullscreen'] = 'Deshabilitar pantalla-completa';
$string['disablehubconfirmationmsg'] = '¿Todavía quiere habilitar el hub?';
$string['disablehubdescription'] = 'Se recomienda encarecidamente que mantenga habilitada esta opción. El Hub H5P proporciona una interfaz fácil para obtener nuevos tipos de contenido y para mantener actualizados los tipos de contenido existentes. En el futuro, siempre será más fácil el compartir y re-utilizar contenido. Si esta opción es deshabilitada, Usted tendrá que instalar y actualizar tipos de contenido mediante formatos de subida de archivo.';
$string['disciplinedescription'] = 'Usted puede seleccionar varias disciplinas';
$string['disciplinelabel'] = 'Disciplinas';
$string['disciplinelimitreachedmessage'] = 'Usted puede seleccionar hasta : :numDisciplines disciplinas';
$string['disciplines'] = 'Disciplinas';
$string['displayoptionalwaysshow'] = 'Siempre mostrar';
$string['displayoptionauthoroff'] = 'Controlado por el autor, el valor por defecto es desactivado';
$string['displayoptionauthoron'] = 'Controlado por el autor, el valor por defecto es activado';
$string['displayoptiondownloadalways'] = 'Siempre';
$string['displayoptiondownloadnever'] = 'Nunca';
$string['displayoptiondownloadpermission'] = 'Solamente si el usuario tiene permisos para exportar H5P';
$string['displayoptionnevershow'] = 'Nunca mostrar';
$string['displayoptionpermissions'] = 'Mostrar solamente si el usuario tiene permisos para exportar H5P';
$string['displayoptionpermissionsembed'] = 'Mostrar solamente si el usuario tiene permiso para incrustar H5P';
$string['displayoptions'] = 'Opciones de Visualización';
$string['download'] = 'Descargar';
$string['downloadfailed'] = 'Falló la descarga de biblioteca solicitada.';
$string['downloadtitle'] = 'Descargar este contenido como un archivo H5P';
$string['dropdownbutton'] = 'Botón desplegable';
$string['editinfotitle'] = 'Editar información para <strong>:title</strong>';
$string['editingfailed'] = 'Falló la edición.';
$string['editor'] = 'Editor';
$string['emailaddress'] = 'Dirección Email';
$string['emailaddressdescription'] = 'La dirección Email será usada por H5P para ponerse en contacto con el publicador en el caso de que hubiera algún problema con el contenido, o en el caso de que el publicador necesite recuperar su cuenta.  No será publicada ni compartida con ningún tercero';
$string['emailconfirmbody'] = 'Hola {$a->username},

Gracias por enviar sus respuestas a \'{$a->hvpname}\' en el curso \'{$a->coursename}\'.

Este mensaje confirma que sus respuestas han sido guardadas.

Usted puede acceder a este H5P en {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Gracias por enviar sus respuestas a \'{$a->hvpname}\'';
$string['emailconfirmsubject'] = 'Confirmación de envío: {$a->hvpname}';
$string['emailnotifybody'] = 'Hola {$a->username},

{$a->studentname} ha completado \'{$a->hvpname}\' ({$a->hvpurl}) en el curso \'{$a->coursename}\'.

Usted puede revisar este intento en {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} ha completado {$a->hvpname}. Vea {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} ha completado {$a->hvpname}';
$string['embed'] = 'Incrustar';
$string['embedloginfailed'] = 'Usted no tiene acceso a este contenido. Intente ingresar al sitio.';
$string['embedtitle'] = 'Ver el código incrustado para este contenido';
$string['empty'] = 'Sin resultados disponibles';
$string['enableabout'] = 'Botón Acerca de H5P';
$string['enablecopyright'] = 'Botón de Copyright';
$string['enabledlrscontenttypes'] = 'Habilitar tipos de contenido que dependen de Learning Record Store';
$string['enabledlrscontenttypes_help'] = 'Hace posible el utilizar tipos de contenido que dependen de un Learning Record Store para funcionar adecuadamente, como el tipo de contenido de Cuestionario (Questionnaire).';
$string['enabledownload'] = 'Permitir Descargar';
$string['enableembed'] = 'Botón de Incrustar';
$string['enableframe'] = 'Mostrar marco y barra de acción';
$string['enablehublabel'] = 'Usar Hub H5P';
$string['enablejavascript'] = 'Por favor, habilite JavaScript.';
$string['enablesavecontentstate'] = 'Guardar estado del contenido';
$string['enablesavecontentstate_help'] = 'Guardar automáticamente el estado actual del contenido interactivo para cada usuario. Esto significa que el usuario puede seleccionar en donde se quedó.';
$string['failedtodownloadh5p'] = 'Fallló la descarga de H5P solicitada.';
$string['fileexceedsmaxsize'] = 'Uno de los archivos dentro del paquete excede el tamaño máximo de archivo permitido. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Archivo no encontrado en el servidor. Revise las configuraciones de subida de archivo.';
$string['filenotimage'] = 'El archivo no es una imagen.';
$string['filetypenotallowed'] = 'El tipo de archivo no está permitido.';
$string['finished'] = 'Terminado';
$string['fullscreen'] = 'Pantalla-completa';
$string['gpl'] = 'Licencia Pública General v3';
$string['gradeheading'] = 'Resultados para {$a}';
$string['gradetopassmustbeset'] = 'La calificación aprobatoria no puede ser cero porque esta actividad H5P tiene su método de finalización configurado para requerir calificación aprobatoria. Por favor configure un valor diferente de cero.';
$string['gradetopassnotset'] = 'Esta actividad H5P aun no tiene configurada una calificación aprobatoria. Puede ser configurada en la sección de Calificación de las configuraciones de la actividad H5P.';
$string['h5pfile'] = 'Archivo H5P';
$string['h5ptitle'] = 'Visite H5P.org para ver más contenido padrísimo.';
$string['helpchoosinglicense'] = 'Ayúdame a elegir una licencia';
$string['hide'] = 'Ocultar';
$string['hideadvanced'] = 'Ocultar avanzadas';
$string['hubcommunicationdisabled'] = 'Se ha deshabilitado la comunicación con Hub H5P porque falló uno o mas requisitos H5P.';
$string['hubisdisabled'] = 'el hub está deshabilitado. Usted puede re-habilitarlo en las configuraciones H5P.';
$string['hubisdisableduploadlibraries'] = 'El Hub H5P ha sido deshabilitado hasta que este problema pueda ser resuelto. Usted todavía puede subir bibliotecas mediante la página de "Bibliotecas H5P".';
$string['hubsettingsheader'] = 'Tipos de Contenido';
$string['hvp:addinstance'] = 'Crear nuevas actividades H5P';
$string['hvp:contenthubregistration'] = 'Registrar sitio con el Hub de Contenido H5P';
$string['hvp:emailconfirmsubmission'] = 'Obtener un mensaje de confirmación al enviar';
$string['hvp:emailnotifysubmission'] = 'Obtener un mensaje de confirmación cuando un intento sea enviado';
$string['hvp:getcachedassets'] = 'Requerido para ver actividades H5P';
$string['hvp:getembedcode'] = 'Ver código H5P incrustado cuando la opción \'controlado por permiso\' está configurada';
$string['hvp:getexport'] = 'Descargar archivo H5P cuando la opción \'controlado por permiso\' está configurada';
$string['hvp:installrecommendedh5plibraries'] = 'Instalar nuevos tipos seguros de bibliotecas H5P recomendadas por H5P.org';
$string['hvp:manage'] = 'Editar actividades H5P existentes';
$string['hvp:restrictlibraries'] = 'Restringir acceso a ciertos tipos de contenido H5P';
$string['hvp:savecontentuserdata'] = 'Guardar datos del progreso del usuario para actividades H5P';
$string['hvp:saveresults'] = 'Guardar resultados de actividades H5P completadas';
$string['hvp:share'] = 'Compartir contenido en el Hub H5P OER';
$string['hvp:updatelibraries'] = 'Instalar nuevos tipos de contenido H5P o actualizar los existentes';
$string['hvp:userestrictedlibraries'] = 'Usar tipos de contenido H5P restringidas';
$string['hvp:view'] = 'Ver e interactuar con actividades H5P';
$string['hvp:viewallresults'] = 'Ver todos los resultados para actividades H5P completadas';
$string['hvp:viewresults'] = 'Ver resultado para sus propias actividades H5P completadas';
$string['icon'] = 'Ícono';
$string['icondescription'] = '640x480px.En caso contrario el contenido seleccionado usará el ícono de la categoría';
$string['in'] = 'en';
$string['installdenied'] = 'Usted no tien epermiso para instalar tipos de contenido. Póngase en contacto con el administrador de su sitio.';
$string['installedlibraries'] = 'Bibliotecas instaladas';
$string['intro'] = 'Introducción';
$string['invalidage'] = 'Formato de ingreso inválido para Edad típica. Los formatos de ingreso posibles están separados por comas: "1, 34-45, -50, -59-".';
$string['invalidaudioformat'] = 'Formato de archivo de audio inválido. Use mp3 o wav.';
$string['invalidcontentfolder'] = 'Carpeta de contenido inválida';
$string['invalidcontenttype'] = 'El tipo de contenido elegido es inválido.';
$string['invalidfieldtype'] = 'Tipo de campo inválido.';
$string['invalidfile'] = 'Archivo "{$a->%filename}" no permitido. Solamente están permitidos archivos con las las siguientes extensiones: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'No pudo obtenerse H5P publicado.';
$string['invalidhvp'] = 'Actividad H5P inválida';
$string['invalidimageformat'] = 'Formato de archivo de imagen inválido. Use jpg png o gif.';
$string['invalidlanguagefile'] = 'Archivo de idioma inválido {$a->%file} en biblioteca {$a->%library}';
$string['invalidlanguagefile2'] = 'Archivo de idioma inválido {$a->%languageFile} ha sido incluido en la biblioteca {$a->%name}';
$string['invalidlibrary'] = 'Biblioteca inválida';
$string['invalidlibrarydata'] = 'Datos inválidos proporcionados por {$a->%property} en {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Datos inválidos proporcionados por {$a->%property} en {$a->%library}. Se esperaban datos Booleanos.';
$string['invalidlibraryname'] = 'Nombre inválido de biblioteca: {$a->%name}';
$string['invalidlibrarynamed'] = 'La biblioteca H5P  {$a->%library} usada en el contenido no es válida';
$string['invalidlibraryoption'] = 'Opción ilegal {$a->%option} en {$a->%library}';
$string['invalidlibraryproperty'] = 'No puede leerse la propiedad {$a->%property} en {$a->%library}';
$string['invalidmainjson'] = 'Falta un archivo principal válido h5p.json';
$string['invalidmultiselectoption'] = 'Opción inválida seleccionada en multi-selección.';
$string['invalidparameters'] = 'Parámetros inválidos';
$string['invalidselectoption'] = 'Opción inválida seleccionada en selección.';
$string['invalidsemanticsjson'] = 'El archivo semantics.json inválido ha sido  incluido en la biblioteca {$a->%name}';
$string['invalidsemanticstype'] = 'Error interno H5P: tipo de contenido desconocido "{$a->@type}" en semántica. ¡Quitando contenido!';
$string['invalidstring'] = 'La cadena de caracteres proporcionada no es válida de acuerdo a regexp en semántica.  (valor: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'H5P ha recibido un token inválido. Refresque la página e inténtelo de nuevo';
$string['invalidvideoformat'] = 'Formato de archivo de video inválido. Use mp4 o webm.';
$string['invalidxapiresult'] = 'No se encontraron resultados xAPI para la combinación del contenido dado y la ID del usuario';
$string['isnowsubmitted'] = 'Está ahora enviado al Hub H5P';
$string['javascriptloading'] = 'Esperando a JavaScript...';
$string['keywordexists'] = '¡La palabra clave ya existe!';
$string['keywords'] = 'Palabras clave';
$string['keywordsdescription'] = 'Usted puede añadir múltiples palabras clave separadas por comas. Presione "Entrar" o "Añadir" para confirmar las palabras clave';
$string['keywordsexists'] = '¡Las  palabras clave ya existen!';
$string['keywordsplaceholder'] = 'Añadir palabras clave';
$string['language'] = 'Idioma';
$string['level'] = 'Nivel';
$string['libraries'] = 'Bibliotecas H5P';
$string['librarydirectoryerror'] = 'El nombre del directorio de la biblioteca debe coincidir con machineName o con machineName-majorVersion.minorVersion (from library.json). (Directorio: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Acciones';
$string['librarylistinstancedependencies'] = 'Dependencias de la instancia';
$string['librarylistinstances'] = 'Instancias';
$string['librarylistlibrarydependencies'] = 'Dependencias de biblioteca';
$string['librarylistrestricted'] = 'Restringido';
$string['librarylisttitle'] = 'Título';
$string['librarynotselected'] = 'Usted debe seleccionar un tipo de contenido.';
$string['license'] = 'Licencia';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Dedicación Dominio Público';
$string['licenseCC010U'] = 'C0 1.0 Universal';
$string['licenseCC10'] = '1.0 Genérica';
$string['licenseCC20'] = '2.0 Genérica';
$string['licenseCC25'] = '2.5 Genérica';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 Internacional';
$string['licenseGPL'] = 'Licencia Pública General';
$string['licenseV1'] = 'Versión 1';
$string['licenseV2'] = 'Versión 2';
$string['licenseV3'] = 'Versión 3';
$string['licensedescription'] = 'Seleccionar una licencia para su contenido';
$string['licensedetails'] = 'Detalles de la licencia';
$string['licensedialogdescription'] = 'Haga clic en una licencia específica para obtener información acerca del uso apropiado';
$string['licensee'] = 'Licenciatario';
$string['licenseextras'] = 'Extras Licencia';
$string['licenseversion'] = 'Versión de Licencia';
$string['licenseversiondescription'] = 'Seleccionar una versión de licencia';
$string['loadingdata'] = 'Cargando datos.';
$string['logouploadtext'] = 'Avatar o logo de la organización';
$string['longdescription'] = 'Descripción larga';
$string['longdescriptionplaceholder'] = 'Descripción larga de su contenido';
$string['lookforupdates'] = 'Buscar actualizaciones H5P';
$string['maintitle'] = 'Compartiendo <strong>:title</strong>';
$string['maximumgrade'] = 'Calificación máxima';
$string['maximumgradeerror'] = 'Por favor, ingrese un número entero positivo válido como los puntos disponibles máximos para esta actividad';
$string['maxlength'] = ':length es el número máximo de caracteres';
$string['maxpostsizetoosmall'] = 'Su tamaño máximo de publicación PHP (PHP max post size) es muy pequeño. Con su configuración actual, Usted no puede subir archivos mayores a {$a->%number} MB. Esto podría ser un problema cuando intente subir H5Ps, imágenes y videos. Por favor considere incrementarlo a más de 5MB';
$string['maxscore'] = 'Puntuación máxima';
$string['maxuploadsizetoosmall'] = 'Su tamaño máximo de subida PHP (PHP max upload size) es muy pequeño. Con su configuración actual, Usted no puede subir archivos mayores a {$a->%number} MB. Esto podría ser un problema cuando intente subir H5Ps, imágenes y videos. Por favor considere incrementarlo a más de 5MB.';
$string['messageprovider:confirmation'] = 'Confirmación de sus propios envíos H5P';
$string['messageprovider:submission'] = 'Notificación de envíos H5P';
$string['missingcontentfolder'] = 'Falta una carpeta de contenido válido';
$string['missingcontentuserdata'] = 'Error: No pudieron encontrarse datos de contenido del usuario';
$string['missingcoreversion'] = 'El sistema no pudo instalar el componente <em>{$a->%component}</em> del paquete ; se requiere una versión más reciente del plugin H5P. Este sitio actualmente está corriendo la versión {$a->%current}, cuando la versión requerida es {$a->%required} o superior. Usted debería de considerar actualizar y entonces intentarlo nuevamente';
$string['missingdependency'] = 'Falta dependencia {$a->@dep} requerida por {$a->@lib}.';
$string['missinglibrary'] = 'Falta biblioteca requerida {$a->@library}';
$string['missinglibraryfile'] = 'El archivo "{$a->%file}" falta en la biblioteca: "{$a->%name}"';
$string['missinglibraryjson'] = 'No pudo encontrarse el archivo library.json con un formato json válido para la biblioteca {$a->%name}';
$string['missinglibraryproperty'] = 'La propiedad requerida {$a->%property} falta en {$a->%library}';
$string['missingmbstring'] = 'La extensión PHP mbstring no está cargada. H5P necesita esto para funcionar adecuadamente';
$string['missingparameters'] = 'Faltan parámetros';
$string['missinguploadpermissions'] = 'Tenga en cuenta que pueden existir bibliotecas en el paquete que Usted subió, pero Usted no tiene permitido subir nuevas bibliotecas . Póngase en contacto con el administrador del sitio a este respecto.';
$string['modulename'] = 'Contenido Interactivo';
$string['modulename_help'] = 'El módulo de actividad H5P le permite a Usted crear contenido interactivo, tal como Videos Interactivos, Conjuntos de Preguntas, Preguntas de Arrastrar y Soltar, Preguntas de Opción Múltiple, Presentaciones y mucho más.

Además de ser una herramienta de autoría para contenido enriquecido, H5P le permite a Usted importar y exportar archivos H5P para re-utilizar efectivamente y compartir contenido.

Las interacciones con el usuario y los puntajes son monitoreados usando xAPI y están disponibles mediante el Libro de Calificaciones de Moodle. Tenga en cuenta que es actualmente posible para personas con habilidades de programación el hacer trampa en interacciones H5P y obtener el puntaje completo sin saber las respuestas correctas. H5Ps no deben usarse  para exámenes sumativos o similares.

Usted añade contenido interactivo H5P al crear contenido usando la herramienta de autoría incluida o al subir archivos H5P encontrados en otros sitios con H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Contenido Interactivo';
$string['next'] = 'Siguiente';
$string['nextpage'] = 'Página siguiente';
$string['noanswersubmitted'] = 'Este usuario aun no ha enviado una respuesta al H5P';
$string['nocontent'] = 'No pudo encontrarse o procesarse el archivo content.json';
$string['nocontenttype'] = 'No fue especificado tipo de contenido.';
$string['nocopyright'] = 'No hay información disponible de copyright para este contenido.';
$string['nodata'] = 'No hay datos disponibles que coincidan con su criterio.';
$string['noexport'] = 'Falta archivo de exportación.';
$string['noextension'] = 'El archivo que Usted subió no es un paquete HTML5 válido (No tiene la extensión .h5p)';
$string['noh5ps'] = 'No hay contenido interactivo disponible para este curso.';
$string['nohubregistration'] = 'No registrado con Hub H5P';
$string['nojson'] = 'El archivo principal h5p.json  no es válido';
$string['nombstringexteension'] = 'La extensión PHP mbstring no está cargada. H5P necesita esto para funcionar apropiadamente.';
$string['noparameters'] = 'Sin parámetros';
$string['noparse'] = 'No pudo procesarse el archivo principal h5p.json';
$string['nopermissiontogettranslations'] = 'Usted no tiene permisos para recuperar traducciones';
$string['nopermissiontorestrict'] = 'Usted no tiene permiso para restringir bibliotecas.';
$string['nopermissiontosavecontentuserdata'] = 'Usted no tiene permiso para guardar datos de usuario del contenido.';
$string['nopermissiontosaveresult'] = 'Usted no tiene permiso para guardar el resultado para este contenido.';
$string['nopermissiontoupgrade'] = 'Usted no tiene permiso para actualizar bibliotecas.';
$string['nopermissiontouploadcontent'] = 'Usted no tiene permisos para subir contenido aquí.';
$string['nopermissiontouploadfiles'] = 'Usted no tiene permisos para subir archivos aquí.';
$string['nopermissiontoviewcontenthubcache'] = 'Usted no tiene permiso para ver los metadatos para el hub de contenido.';
$string['nopermissiontoviewcontenttypes'] = 'Usted no tiene permisos para ver los tipos de contenido.';
$string['nopermissiontoviewresult'] = 'Usted no tiene permiso para ver resultados para este contenido.';
$string['nosuchlibrary'] = 'No hay tal biblioteca';
$string['notapplicable'] = 'NO disponible';
$string['nounzip'] = 'El archivo que Usted subió no es un paquete HTML5 válido (No podemos descomprimirlo)';
$string['noversionattribution'] = 'Atribución';
$string['noversionattributionnc'] = 'Atribución-NoComercial';
$string['noversionattributionncnd'] = 'Atribución-NoComercial-NoDerivadas';
$string['noversionattributionncsa'] = 'Atribución-NoComercial-CompartirIgual';
$string['noversionattributionnd'] = 'Atribución-NoDerivadas';
$string['noversionattributionsa'] = 'Atribución-CompartirIgual';
$string['nowriteaccess'] = 'Se detectó un problema con el acceso de escritura del servidor. Por favor asegúrese de que su servidor puede escribir a su carpeta de datos.';
$string['noziparchive'] = 'Su versión de PHP no soporta ZipArchive.';
$string['offlinedialogbody'] = 'No pudimos enviar información acerca de su finalización de este trabajo. Por favor revise su conexión de internet.';
$string['offlinedialogheader'] = 'Se perdió su conexión al servidor';
$string['offlinedialogretrybuttonlabel'] = 'Reintentar ahorita';
$string['offlinedialogretrymessage'] = 'Reintentando en :num....';
$string['offlinesuccessfulsubmit'] = 'Resultados enviados exitosamente.';
$string['oldphpversion'] = 'Su versión de PHP está obsoleta. H5P requiere versión 5.2 para funcionar apropiadamente. Se recomienda versión 5.6 o mayor.';
$string['olduploadoldcontent'] = 'Usted está intentando subir contenido de una versión más antigua de H5P. Por favor actualice el contenido en el servidor de donde se originó e intente subirlo nuevamente o active el Hub H5P para que haga que este servidor lo actualice para Usted automáticamente.';
$string['onlyupdate'] = 'Solamente actualizar bibliotecas existentes';
$string['optionalinfo'] = 'Información opcional';
$string['options'] = 'Opciones';
$string['originator'] = 'Originador';
$string['pd'] = 'Dominio Público';
$string['pddl'] = 'Licencia y Dedicación de Dominio Público';
$string['pdm'] = 'Marca de Dominio Público';
$string['phone'] = 'Teléfono';
$string['pleasewait'] = 'Por favor espere ...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Se requiere un mensaje post para acceder al punto-final dado.';
$string['previouspage'] = 'Página anterior';
$string['privacy:metadata:core_files'] = 'La actividad H5P almacena archivos que han sido subidos como parte del contenido H5P.';
$string['privacy:metadata:core_grades'] = 'La actividad H5P almacena calificaciones de usuarios que han respondido a contenido H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Describe el estado actual del contenido para un usuario. Empleado para restaurar contenido a un estado anterior.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Datos del usuario que fueron almacenados.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identificador del tipo de datos.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Señalizador que determina si los datos deberían de ser eliminados cuando cambie el contenido.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'La ID del contenido H5P al que pertenecen los datos.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'La ID de la relación de los datos contenidos del usuario.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Señalización que determina si los datos deberían de ser pre-cargados dentro del contenido.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Sub-contenido de H5P. 0 si esto no es sub-contenido.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'La Id del usuario al que pertenecen los datos.';
$string['privacy:metadata:hvp_events'] = 'LLeva seguimiento de eventos H5P en bitácora.';
$string['privacy:metadata:hvp_events:content_id'] = 'La ID del contenido sobre del cual fue realizada la acción. 0 si es nuevo o sin contenido.';
$string['privacy:metadata:hvp_events:content_title'] = 'Título del contenido.';
$string['privacy:metadata:hvp_events:created_at'] = 'La hora a la cual fue creado el evento.';
$string['privacy:metadata:hvp_events:id'] = 'La ID única del evento.';
$string['privacy:metadata:hvp_events:library_name'] = 'La biblioteca que el evento afectó.';
$string['privacy:metadata:hvp_events:library_version'] = 'La versión de la biblioteca que el evento afectó.';
$string['privacy:metadata:hvp_events:sub_type'] = 'El sub-tipo de evento, o acción del evento.';
$string['privacy:metadata:hvp_events:type'] = 'El tipo de evento.';
$string['privacy:metadata:hvp_events:user_id'] = 'La ID del usuario que realizó la acción';
$string['privacy:metadata:hvp_xapi_results'] = 'Almacena eventos xAPI en contenido H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Información adicional que puede enviar el H5P.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'La ID del contenido en donde se realizó el evento.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'El patrón de respuesta correcta.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'La descripción, trabajo o pregunta del contenido sobre del cual se realizó la acción.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'La ID única del evento xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'El tipo de interacción.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Puntaje obtenible máximo para el evento.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'La ID del padre del contenido sobre del cual se realizó la acción. Nulo si no tiene padre.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Puntaje logrado para el evento.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'La respuesta que envió el usuario.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'La Id del usuario que realizó la acción.';
$string['publisherdescription'] = 'Descripción del publicador';
$string['publisherdescriptiontext'] = 'Esto será mostrado bajo "Información del publicador" en el contenido compartido';
$string['publisherfielddescription'] = 'Esto será mostrado como el "Nombre del publicador" en el contenido compartido';
$string['publisherfieldtitle'] = 'Publicador';
$string['question'] = 'Pregunta';
$string['registeronhub'] = 'Registrar en el Hub H5P';
$string['registrationfailed'] = 'Ocurrió un error';
$string['registrationfaileddescription'] = 'No pudimos crear una cuenta en este punto. Algo salió mal. Inténtelo  nuevamente después.';
$string['registrationtitle'] = 'Registro en Hub H5P';
$string['remove'] = 'Quitar';
$string['removechip'] = 'Quitar :chip de la lista';
$string['removeimage'] = 'Quitar imagen';
$string['removeoldlogentries'] = 'Quitar entradas antiguas de bitácora H5P';
$string['removeoldmobileauthentries'] = 'Quitar entradas de autenticación H5P mobile antiguas';
$string['removetmpfiles'] = 'Quitar archivos temporales H5P  antiguos';
$string['reportingquestionsremaininglabel'] = 'preguntas restantes por calificar';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Puntaje del Libro de calificaciones';
$string['reportingscoredelimiter'] = 'de un total de';
$string['reportingscorelabel'] = 'Puntaje:';
$string['reportnotsupported'] = 'No soportado';
$string['reportsubmitgradelabel'] = 'Enviar calificación';
$string['requiredinfo'] = 'Información requerida';
$string['resizescript'] = 'Incluya este script en su sitio web si quiere un tamaño dinámico del contenido incrustado:';
$string['resubmitscores'] = 'Intentando enviar resultados almacenados.';
$string['reuse'] = 'Re-utilizar';
$string['reusecontent'] = 'Reutilizar Contenido';
$string['reusedescription'] = 'Reutilizar este contenido';
$string['reveal'] = 'Revelar';
$string['reviewandsave'] = 'Revisar y Guardar';
$string['reviewandshare'] = 'Revisar y Compartir';
$string['reviewinfo'] = 'Revisar información';
$string['reviewmessage'] = 'Por favor revise la información inferior antes de compartir';
$string['reviseserversetupandretry'] = 'Cuando Usted haya revisado su configuración de su servidor Usted puede re-habilitar la comunicación con hub H5P en las Configuraciones de H5P.';
$string['savechanges'] = 'Guardar cambios';
$string['score'] = 'Puntaje';
$string['screenshots'] = 'Pantallazos';
$string['screenshotsdescription'] = 'Añadir hasta cinco pantallazos de su contenido';
$string['search'] = 'Buscar';
$string['searchplaceholder'] = 'Escriba para buscar por disciplinas';
$string['sendusagestatistics'] = 'Contribuir estadísticas de uso';
$string['sendusagestatistics_help'] = 'Los números de estadísticas de uso se reportarán automáticamente para ayudarle a los desarrolladores a entender mejor como se usa H5P y para determinar áreas potenciales de mejora. Lea más acerca de cuales <a {$a}>datos son colectados en h5p.org</a>.';
$string['settings'] = 'Configuraciones de H5P';
$string['share'] = 'Compartir';
$string['shared'] = 'Compartido';
$string['sharefailed'] = 'Falló compartición.';
$string['sharetryagain'] = 'Algo salió mal. Por favor inténtelo nuevamente después.';
$string['sharingnote'] = 'Todos los detalles del contenido pueden ser editados después de compartirlo';
$string['shortdescription'] = 'Descripción breve';
$string['shortdescriptionplaceholder'] = 'Descripción breve de su contenido';
$string['showadvanced'] = 'Mostrar avanzadas';
$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar más';
$string['sitecouldnotberegistered'] = 'El sitio no pudo ser registrado con el hub. Por favor, póngase en contacto con el administrador del sitio.';
$string['sitekey'] = 'Clave del Sitio';
$string['sitekeydescription'] = 'La clave del sitio es un secreto que identifica en forma única este sitio con el Hub.';
$string['sitekeyregistered'] = 'Usted ha sido proveído con una clave única que lo identifica con el Hub al recibir nuevas actualizaciones. La clave está disponible para verse en la página de "Configuraciones H5P".';
$string['size'] = 'Tamaño';
$string['somekeywordsexists'] = 'Algunas de estas palabras clave ya existen';
$string['source'] = 'Origen';
$string['sslnotenabled'] = 'Su servidor no tiene SSL habilitado. SSL debería de estar habilitado para asegurar una conexión segura con el hub H5P.';
$string['startingover'] = 'Usted va a comenzar de nuevo.';
$string['subcontentwarning'] = 'El sub-contenido (imágenes, preguntas, etc) será compartido bajo :license a menos que se especifique lo contrario en la herramienta de autoría';
$string['sublevel'] = 'Subnivel';
$string['submitted'] = '¡Enviado!';
$string['successfullyregisteredwithhub'] = 'Su sitio se ha registrado exitosamente con el Hub H5P.';
$string['successfullyregistred'] = 'Usted ha registrado exitosamente una cuenta en el Hub H5P';
$string['successfullyregistreddescription'] = 'Sus detalles de la cuenta pueden ser cambiados';
$string['successfullyupdated'] = 'Sus configuraciones de la cuenta en el Hub H5P han sido cambiadas exitosamente';
$string['thumbnail'] = 'Miniatura';
$string['title'] = 'Título';
$string['unabletocreatedir'] = 'No pudo crear directorio.';
$string['unabletogetfieldtype'] = 'No se puede obtener tipo del campo.';
$string['undisclosed'] = 'No revelado';
$string['unpackedfilesexceedsmaxsize'] = 'El tamaño total de los archivos desempacados excede el tamaño máximo permitido. (%used > %max)';
$string['updatedlibraries'] = 'Se actualizaron {$a->%old} bibliotecas H5P.';
$string['updatedlibrary'] = 'Biblioteca H5P {$a->%old} actualizada.';
$string['updatelibraries'] = 'Actualizar Todas las Bibliotecas';
$string['updateregistrationonhub'] = 'Guardar configuraciones de la cuenta';
$string['upgrade'] = 'Actualizar H5P';
$string['upgradebuttonlabel'] = 'Actualizar';
$string['upgradedone'] = 'Usted ha actualizado exitosamente {$a} instancia(s) de contenido..';
$string['upgradeerror'] = 'Ocurrió un error al procesar parámetros:';
$string['upgradeerrorcontent'] = 'No pudo actualizarse contenido %id:';
$string['upgradeerrordata'] = 'No pudieron cargarse datos para biblioteca %lib.';
$string['upgradeerrormissinglibrary'] = 'Falta biblioteca necesaria %lib.';
$string['upgradeerrornotsupported'] = 'Parámetros contienen %used lo cual no está soportado.';
$string['upgradeerrorparamsbroken'] = 'Los parámetros están rotos.';
$string['upgradeerrorscript'] = 'No pudieron cargarse scripts para %lib.';
$string['upgradeerrortoohighversion'] = 'Parámetros contienen %used cuando solamente %supported o más antigos están soportados.';
$string['upgradeheading'] = 'Actualizar contenido {$a}';
$string['upgradeinprogress'] = 'Actualizando a %ver...';
$string['upgradeinvalidtoken'] = 'Error: ¡ Token de seguridad inválido !';
$string['upgradelibrarycontent'] = 'Actualizar contenido de biblioteca';
$string['upgradelibrarymissing'] = 'Error:¡ Falta su biblioteca !';
$string['upgrademessage'] = 'Usted está a punto de acrtualizar {$a} intsancia(s) de contenido Por favor, seleccione versión de actualización.';
$string['upgradenoavailableupgrades'] = 'No hay actualizaciones disponibles para su biblioteca.';
$string['upgradenothingtodo'] = 'No hay instancias de contenido para actualizar.';
$string['upgradereturn'] = 'Regresar';
$string['upload'] = 'Subir';
$string['uploadlibraries'] = 'Subir Bibliotecas';
$string['uploadsizelargerthanpostsize'] = 'Su tamaño de subida máxima de PHP (max upload size) es mayor que su tamaño de publicación máxima (max post size). Esto es sabido que causa problemas en algunas instalaciones.';
$string['user'] = 'Usuario';
$string['validatingh5pfailed'] = 'Falló la validación del paquete h5p.';
$string['validationfailed'] = 'El H5P solicitado no era válido';
$string['viewreportlabel'] = 'Reporte';
$string['welcomecommunity'] = 'Nosotros esperamos que Usted disfrutará H5P y se una a nuestra comunidad creciente mediante nuestros <a {$a->foross}>foros</a> .';
$string['welcomecontactus'] = 'Si Usted tuviera alguna retroalimentación, no dude en <a {$a}>contactarnos</a>. ¡ Nosotros tomamos muy seriamente la retroalimentación y estamos dedicados a hacer H5P cada día mejor!';
$string['welcomegettingstarted'] = 'Para comenzar con H5P y Moodle, échele un vistazo a nuestro <a {$a->moodle_tutorial}>tutorial</a> y revise los <a {$a->example_content}>contenidos de ejemplo</a> en H5P.org para inspiración.';
$string['welcomeheader'] = '¡BienVenido al mundo de HSP!';
$string['wrongversion'] = 'La versión de la biblioteca H5P {$a->%machineName} usada en este contenido no es válida. El contenido tiene {$a->%contentLibrary}, pero debería ser {$a->%semanticsLibrary}.';
$string['year'] = 'Año';
$string['years'] = 'Año(s)';
$string['yearsfrom'] = 'Años (desde)';
$string['yearsto'] = 'Años (hasta)';
$string['zip'] = 'Zip';
