<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_rebel', language 'es_mx', version '3.11'.
 *
 * @package     theme_rebel
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Colores';
$string['alert'] = 'Alerta en Página de Ingreso';
$string['alert_desc'] = 'Añadir una alerta especial para una emergencia en su página inicial del sitio.';
$string['backgrounds'] = 'Fondos';
$string['badges'] = 'Insignias';
$string['badges_desc'] = 'Otorgar a sus estudiantes';
$string['brandcolor'] = 'Color de la marca';
$string['brandcolor_desc'] = 'El color del acento';
$string['brandemail'] = 'Email de la organización';
$string['brandemaildesc'] = 'Dirección Email para la organización que aparece en el pie de página.';
$string['brandinginfo'] = 'Opciones de Marcado personalizado';
$string['brandinginfo_desc'] = 'Use las opciones inferiores para proporcionar su marcado personalizado a su sitio';
$string['brandingsettings'] = 'Configuraciones de Marcado personalizado';
$string['brandlogo'] = 'Imagen del Logo de la Marca';
$string['brandlogo_desc'] = 'Esta imagen es mostrada en el área del encabezado y el área del pie. Debería ser un logo de tamaño pequeño.';
$string['brandorganization'] = 'Nombre de la Organización';
$string['brandorganizationdesc'] = 'Nombre de la Organización que aparecerá en el pie de página.';
$string['brandphone'] = 'Teléfono de la Organización';
$string['brandphonedesc'] = 'Teléfono de la Organización que aparecerá en el pie de página.';
$string['brandwebsite'] = 'Sitio web de la Organización';
$string['brandwebsitedesc'] = 'Sitio web de la Organización que aparecerá en el pie de página.';
$string['choosereadme'] = 'El tema Rebel es un tema hijo de Boost. Añade la habilidad de subir el fondo rebelde.';
$string['cmnotestudent'] = 'Mensaje en Tablero del Estudiante';
$string['cmnotestudent_desc'] = 'Proporcionar un mensaje para todos los estudiantes en el panel de gestión del curso.';
$string['cmnoteteacher'] = 'Mensaje en Tablero del Profesor';
$string['cmnoteteacher_desc'] = 'Proporcionar un mensaje para todos los profesores en el panel de gestión del curso.';
$string['cmnotetitle'] = 'Tablero del Curso';
$string['cmnotetitle_desc'] = 'Anotaciones en el Tablero del Curso';
$string['color_desc'] = 'Elegir un nuevo color del fondo para esta variable.';
$string['configtitle'] = 'Tema Rebel';
$string['courseadmininfo'] = 'Enlaces para Gestión del Curso del Profesor';
$string['courseadmininfo_desc'] = 'Determina cuales enlaces le gustaría mostrarle a profesores en el cajón de navegación de Gestión del Curso.';
$string['courseadminlinktoggle'] = 'Ocultar o Mostrar este enlace en el cajón de navegación de Gestión del Curso.';
$string['courseadminmenusettings'] = 'Configuraciones del Menú de Navegación';
$string['courseadminmenutitle'] = 'Gestión del Curso';
$string['courseadminreportinfo'] = 'Enlaces a Reporte de Gestión del Curso del Profesor';
$string['courseheaderlinktoggle'] = 'Ocultar o Mostrar este enlace en el área del encabezado.';
$string['courseinfo'] = 'Descripción del Curso';
$string['coursemanage'] = 'Configuraciones del Curso';
$string['coursemanage_desc'] = 'Gestionar todo su curso';
$string['coursemanagementbutton'] = 'Gestión del Curso';
$string['coursereportmenutitle'] = 'Reportes del Curso';
$string['coursestaff'] = 'Profesores del Curso';
$string['coursetilebg'] = 'Imagen Predeterminada del Curso';
$string['coursetilebg_desc'] = 'Esta es la imagen predeterminada para mosaicos de curso en el Tablero y la imagen del encabezado predeterminada para todos los cursos donde un profesor no haya subido una imagen dentro de las Configuraciones del Curso. Aun con las Imágenes del Encabezado desactivadas Usted puede usar una imagen aquí para que sea  la imagen predeterminada de mosaico de Curso en el Tablero.';
$string['createinfo'] = 'Botón Especial de Creador de Curso';
$string['createinfodesc'] = 'Este botón aparece en la página inicial del sitio cuando un usuario puede crear cursos nuevos. Aquellos con el rol de Creador de Curso a nivel del sitio verán este botón.';
$string['customlogininfo'] = 'Mejorar la Página para Ingresar';
$string['customlogininfo_desc'] = 'Use las opciones inferiores para mejorar la página de ingreso para Rebel.';
$string['dashboardbackgroundimage'] = 'Imagen del fondo de página del Tablero';
$string['dashboardbackgroundimage_desc'] = 'Una imagen que será estirada para llenar el fondo de la página del Tablero.';
$string['dashboardiconbutton'] = 'Tablero del Curso';
$string['dashboardtextbox'] = 'CajadeTexto del Tablero';
$string['dashboardtextbox_desc'] = 'Esta es una caja de texto personalizado que es mostrado en el Tablero del sitio. Úsela para dar la BienVenida  a estudiantes o para proporcionar instrucciones.';
$string['defaultbackgroundimage'] = 'Imagen del Encabezado de Página del Sitio';
$string['defaultbackgroundimage_desc'] = 'Esta imagen es usada en el área del encabezado para todas las páginas principales de Moodle: Tablero, Perfil, Página Inicial del sitio, todas las páginas diferentes de las páginas de curso.';
$string['easyenrol_blurp'] = 'Ingrese debajo su código del curso para inscribir nuevos cursos. Su profesor proporciona un código del curso.';
$string['easyenrol_btn'] = 'Inscribirse en un Curso';
$string['easyenrol_title'] = 'Formato para Inscripción';
$string['editoff'] = 'Desactivar Edición';
$string['editon'] = 'Activar Edición';
$string['featuretext'] = 'Caja de Texto Destacado';
$string['featuretext_desc'] = 'Una de las tres cajas de texto destacadas que aparecen debajo del formato para ingresar.';
$string['footer-bg'] = 'Fondo del Pie de Página';
$string['footeroverlay'] = 'Textura del Pie de Página';
$string['footeroverlay_desc'] = 'Sobrepuesto recomendado: Brushed.png.  Usted puede elegir cambiar la textura del fondo del pie de página. Nosotros descargamos nuestras imágenes de fondo transparentes de aquí: <a href="https://www.transparenttextures.com/">https://www.transparenttextures.com/</a>';
$string['footnote'] = 'Nota al Pie';
$string['footnotedesc'] = 'Editor del contenido de nota al pie para pie de página principal';
$string['frontpagebackgroundimage'] = 'Imagen del fondo de la Portada';
$string['frontpagebackgroundimage_desc'] = 'Una imagen que será estirada para llenar el fondo de la Portada.';
$string['generalsettings'] = 'Configuraciones Generales';
$string['header-bg'] = 'Fondo del Encabezado';
$string['headerlinks-bg'] = 'Fondo de Barra de Navegación de Enlace de Cabecera';
$string['headermenuinfo'] = 'Elementos del Menú del Encabezado';
$string['headermenuinfo_desc'] = 'Determinar cuales enlaces le gustaría mostrar en el área del encabezado.';
$string['headeroverlay'] = 'Textura de Cabecera';
$string['headeroverlay_desc'] = 'Sobrepuesto recomendado: Brushed.png.  Usted puede elegir cambiar la textura del fondo del pie de página. Nosotros descargamos nuestras imágenes de fondo transparentes de aquí: <a href="https://www.transparenttextures.com/">https://www.transparenttextures.com/</a>';
$string['iconnavheading'] = 'Navegación por Íconos';
$string['iconnavinfo'] = 'Navegación por Íconos del Tablero';
$string['iconnavinfo_desc'] = 'Crear botones con íconos para usar en la página inicial. Estos aparecen en la parte superior de la página en el Tablero.';
$string['iconwidth'] = 'Ancho del Ícono en Página Inicial';
$string['iconwidth_desc'] = 'Ancho de los 8 íconos individuales en la barra de navegación por íconos en la página inicial del sitio.';
$string['iconwidthinfo'] = 'Configuración del Ancho del Botón del Ícono';
$string['iconwidthinfodesc'] = 'Seleccionar un ancho que le permitirá a su texto del enlace caber dentro de los botones de navegación por íconos.';
$string['incoursebackgroundimage'] = 'Imagen del fondo de página de curso';
$string['incoursebackgroundimage_desc'] = 'Una imagen que será estirada para llenar el fondo de páginas de curso.';
$string['loginbackgroundimage'] = 'Imagen del fondo de la página de ingreso';
$string['loginbackgroundimage_desc'] = 'Una imagen que será estirada para llenar el fondo de la página de ingreso.';
$string['loginbottomtext'] = 'Caja de texto del Fondo';
$string['loginbottomtext_desc'] = 'Esta es una caja de texto de ancho completo que aparece hasta el fondo de la página para ingresar.';
$string['loginiconbutton'] = 'Ingresar al Sitio';
$string['loginsettings'] = 'Configuraciones del Ingreso';
$string['logintopimage'] = 'Imagen de Página de Ingreso';
$string['logintopimage_desc'] = 'Subir una imagen que será colocada a la derecha del formato para ingreso.';
$string['logintoptext'] = 'Caja de texto Superior';
$string['logintoptext_desc'] = 'Esta es una caja de texto de ancho completo que aparece justo debajo de la imagen en la página para ingresar.';
$string['marketingurltarget'] = 'Destino del Enlace';
$string['marketingurltargetdesc'] = 'Elegir cómo debería ser abierto el enlace';
$string['marketingurltargetnew'] = 'Página Nueva';
$string['marketingurltargetparent'] = 'Marco Padre';
$string['marketingurltargetself'] = 'Página Actual';
$string['moreoptions'] = 'Más Opciones...';
$string['mygradestext'] = 'Mis Calificaciones';
$string['myprogresspercentage'] = '% Completado';
$string['myprogresstext'] = 'Mi Progreso';
$string['navbar-bg'] = 'Fondo de Barra de Navegación Superior';
$string['navicon'] = 'Ícono';
$string['navicon1'] = 'Ícono Uno de Página Inicial';
$string['navicon2'] = 'Ícono Dos de Página Inicial';
$string['navicon3'] = 'Ícono Tres de Página Inicial';
$string['navicon4'] = 'Ícono Cuatro de Página Inicial';
$string['navicon5'] = 'Ícono Cinco de Página Inicial';
$string['navicon6'] = 'Ícono Seis de Página Inicial';
$string['navicon7'] = 'Ícono Siete de Página Inicial';
$string['navicon8'] = 'Ícono Ocho de Página Inicial';
$string['naviconbuttontext'] = 'Texto del Enlace';
$string['naviconbuttontextdesc'] = 'Texto que aparece debajo del ícono.';
$string['naviconbuttonurl'] = 'URL del Enlace';
$string['naviconbuttonurldesc'] = 'URL adonde apuntará el botón. Usted puede enlazar a cualquier dirección incluyendo sitios web de fuera, solo escriba la URL apropiada. Si su sitio Moodle está en un subdirectorio entonces la URL predeterminada no funcionará. Por favor ajuste la URL para que refleje el subdirectorio. Por ejemplo si "moodle" fuera su carpeta del subdirectorio entonces la URL necesitaría ser cambiada a /moodle/my/';
$string['navicondesc'] = 'Nombre del ícono que desea usar. La lista está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>. Simplemente escriba lo que va después de  "fa-", como por ejemplo "star".';
$string['naviconslidedesc'] = 'Texto de ícono sugerido: arrow-circle-down . O elija de la lista que está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>.  Simplemente escriba lo que va después de  "fa-", como por ejemplo "star".';
$string['nomycourses'] = 'Usted no está inscrito en ningún curso';
$string['nothiscourse'] = 'No podemos identificar ningún tópico o sección del curso';
$string['pluginname'] = 'Rebel';
$string['preset'] = 'Preconfiguraciones del tema';
$string['preset_desc'] = 'Elegir una preconfiguración para cambiar ampliamente el aspecto del tema.';
$string['presetfiles'] = 'Archivos de configuraciones adicionales del tema';
$string['presetfiles_desc'] = 'Los archivos de preconfiguración pueden ser usados  para alterar drásticamente la apariencia del tema. Vea <a href=https://docs.moodle.org/dev/Boost_Presets>Boost presets</a> para la información sobre como crear y compartir sus propios archivos de preconfiguración. Rebel necesita ciertas variables de configuración en SCSS.  Usted puede ver las preconfiguraciones de Rebel aquí: <a href=https://github.com/dbnschools/moodle-theme_rebel/tree/master/scss/preset target=_blank>Rebel Github Presets repository</a>.';
$string['privacy:metadata'] = 'El tema Rebel no almacena ningún dato de usuario individual.';
$string['qbank'] = 'Banco de Preguntas';
$string['qbank_desc'] = 'Crear y organizar preguntas de examen';
$string['rawscss'] = 'SCSS crudo';
$string['rawscss_desc'] = 'Use este campo para proporcionar código SCSS o CSS que será inyectado al final de la hoja de estilo.';
$string['rawscsspre'] = 'SCSS inicial crudo';
$string['rawscsspre_desc'] = '// Área Superior de Barra de Navegación</br>
$navbar-bg: #e3eaf5 ;</br>
$navbartextcolor: #333;</br>

// Área Superior de Encabezado</br>
$header-bg: #eef5f9;</br>
$headerlinks-bg: #e3eaf5;</br>
$headerlinks-link: $black;</br>

// Camino de migas en Rebel</br>
$breadcrumbblock: #607d8b;</br>
$breadcrumbblock-darken: #213561;</br>
$breadcrumbblock-highlight: #213561;</br>
$breadcrumbblock-highlight-darken: #607d8b;</br>
$breadcrumblinkcolor: $white;</br>
$breadcrumblinkcolor-hover: $white;</br>

//Menú de Íconos de Barra Lateral</br>
$sidebar-bg: $body-bg;</br>
$sidebar-iconcolor: $white;</br>
$sidebar-ahover-bg: #1f77b2;</br>
$sidebar-aattention: #4caf50;</br>
$sidebar-borderright-color: $white;</br>

// Área de Pie de Página del Fondo</br>
$footer-bg: #e5ebef;</br>
$footerlinkcolor: #333;</br>
$footertextcolor: #333;</br>

//Usado para estilizar plugin Inscripción Fácil</br>
$easyenrolltextcolor: $white;</br>
$easyenroll-bg: #4caf50;</br>

//Otros Colores Importantes</br>
$card-bg: rgba(255, 255, 255, 0.98)!default;</br>
$body-bg: #213561;</br>
$primary:       #1968BE;</br>
$success:       $green;</br>
$info:          #4caf50;</br>
$warning:       $orange;</br>
$danger:        $red;</br>
$secondary:     $gray-400;</br>

// Pestañas</br>
$nav-tabs-border-color:             $gray-300;</br>
$nav-tabs-link-hover-border-color:  $gray-200 $gray-200 $nav-tabs-border-color;</br>
$nav-tabs-link-active-color:        $gray-700;</br>
$nav-tabs-link-active-bg:           $gray-200;</br>
$nav-tabs-link-active-border-color: $gray-300 $gray-300 $nav-tabs-link-active-bg;';
$string['region-side-pre'] = 'Derecha';
$string['sectionlayout'] = 'Selector de Estilo de Sección';
$string['sectionlayout1'] = 'Predeterminado de Moodle Boost';
$string['sectionlayout2'] = 'Título de Sección Negritas';
$string['sectionlayout3'] = 'Caja Redondeada Simple';
$string['sectionlayout4'] = 'Tópico 0 En Caja';
$string['sectionlayout5'] = '';
$string['sectionlayout6'] = '';
$string['sectionlayout7'] = '';
$string['sectionlayout8'] = '';
$string['sectionlayout_desc'] = 'Elegir de entre los siguientes estilos de tópicos/semanas.';
$string['showcoursesections'] = 'Mostrar Navegación por Sección del Curso';
$string['showcoursesections_desc'] = 'Este menú proporciona una lista desplegable de secciones de curso y permite navegación rápida dentro de un curso. Podría no funcionar con todos los formatos de cursos.';
$string['showcustomlogin'] = 'Usar Página Personalizada de Ingreso';
$string['showcustomlogin_desc'] = 'Habilitar las características inferiores para que sean mostradas en la página para ingresar a Moodle.';
$string['showheaderimages'] = 'Mostrar Imágenes del Encabezado';
$string['showheaderimages_desc'] = 'Permitirle a Rebel usar imágenes personalizadas para el área del encabezado. Usted aun puede configurar debajo una Imagen del Mosaico del Curso pero no será usada como una imagen del encabezado dentro de un curso. Esta configuración desactiva completamente el uso de imágenes del encabezado.';
$string['sidebar-bg'] = 'Fondo de Barra Lateral';
$string['sliderinfo'] = 'Botón Especial del Ícono de la Imagen';
$string['sliderinfodesc'] = 'Este botón mostrará/ocultará una caja de texto especial que se desliza desde la barra de navegación por íconos. Esto es ideal para destacar cursos, proporcionar ayuda, o enlistar entrenamiento especial para el staff.';
$string['slidetextbox'] = 'Caja de texto de Diapositiva';
$string['slidetextbox_desc'] = 'El contenido de esta caja de texto será mostrado cuando sea presionado el Botón de la Imagen';
$string['studentdashbutton'] = 'Tablero del Curso';
$string['thiscourse'] = 'Secciones de Curso';
$string['userlinks'] = 'enlaces del Usuario';
$string['userlinks_desc'] = 'Gestionar sus estudiantes';
