<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dash', language 'fr', version '3.11'.
 *
 * @package     block_dash
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordionfield1'] = 'Champ en haut à gauche';
$string['accordionfield1icon'] = 'Icône de champ en haut à gauche';
$string['accordionfield2'] = 'Champ en haut à droite';
$string['accordionfield2icon'] = 'Icône de champ en haut à droite';
$string['accordionfield3'] = 'Champ en bas à gauche';
$string['accordionfield3icon'] = 'Icône de champ en bas à gauche';
$string['accordionfield4'] = 'Champ en bas à droite';
$string['accordionfield4icon'] = 'Icône de champ en bas à droite';
$string['achieved'] = 'Atteint';
$string['activityprogress'] = 'Progression (activités réalisées / total)';
$string['activityprogressbar'] = 'Barre de progression (activités réalisées / total)';
$string['addnewfield'] = 'Ajouter un nouveau champ';
$string['addtocontacts'] = 'Ajouter aux contacts';
$string['alpha_asc'] = 'Tri par ordre alphabétique de A à Z';
$string['alpha_desc'] = 'Tri par ordre alphabétique de Z à A';
$string['availablefields'] = 'Champs disponibles';
$string['availablefields_help'] = 'Choisissez tous les champs possibles que cette source de données utilisera. L\'utilisateur pourra sélectionner les champs à inclure à ses propres fins. Par exemple, si vous affichez des informations utilisateur, essayez d\'inclure autant de champs utilisateur que possible.';
$string['backgroundgradient'] = 'Dégradé d\'arrière-plan';
$string['backgroundgradient_help'] = 'Générez un dégradé : <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a>. Coller la propriété arrière-plan (linéaire-dégradé)';
$string['backgroundimage'] = 'Image d\'arrière plan';
$string['backgroundimage_help'] = 'Remplir tout l\'arrière-plan du bloc avec cette image';
$string['backgroundimagefield'] = 'Image d\'arrière plan';
$string['badgecolorfield'] = 'Champ de couleur du badge';
$string['badgecolorfield_help'] = 'Choisissez un champ qui renvoie les couleurs à utiliser pour les badges d\'élément de chronologie.';
$string['badges'] = 'Badges';
$string['badgestitle'] = 'Badges';
$string['blocktitle'] = 'Titre du bloc';
$string['blocktitle_help'] = 'Titre affiché en en-tête de bloc. Entrez un titre court et un descriptif parlant pour l\'utilisateur.';
$string['blockwidth'] = 'Largeur de bloc';
$string['bodyfield'] = 'Champ du corps';
$string['bootstrapversion'] = 'Version bootstrap du thème';
$string['bootstrapversion_desc'] = 'Choisissez la version de Bootstrap prise en charge par votre thème. Moodle utilise généralement  la version 4 et Totara la version 3.';
$string['border'] = 'Bordure';
$string['border_help'] = 'Valeur de la propriété de bordure CSS. Défini sur <b>aucun</b> pour aucune bordure.';
$string['buildown'] = 'Construisez le votre';
$string['buildown_help'] = 'Les sources de données sont hautement configurables, vous pouvez utiliser les sources de données à diverses fins. Les fonctionnalités de filtrage, de tri et de pagination sont prises en charge';
$string['buynow'] = 'Acheter maintenant';
$string['category'] = 'Nom de catégorie';
$string['choosedatasource'] = 'Choisissez la source de données';
$string['choosefeature'] = 'Choisissez la fonctionnalité';
$string['choosefilter'] = 'Choisissez le filtre';
$string['columns'] = 'Colonnes';
$string['columns_help'] = 'Le nombre de colonnes à afficher par ligne dans la grille.';
$string['competencyframework'] = 'Référentiel de compétences';
$string['completedactivities'] = 'Activités terminées';
$string['completion:completed'] = 'Terminé';
$string['completion:inprogress'] = 'En cours';
$string['completion:notstarted'] = 'Pas encore commencé';
$string['confirmleavegroup'] = 'Voulez-vous vraiment quitter le groupe {$a}';
$string['contacts'] = 'Contacts';
$string['contextid'] = 'Contexte';
$string['contextid_help'] = 'Le contexte de ce tableau de bord. Choisissez un cours spécifique si vous prévoyez de limiter les résultats de données (Exemple : filtre « Cours actuel »). Sinon, choisissez Système à des fins générales.';
$string['contextmissing'] = 'Contexte manquant';
$string['course_enrol_role'] = 'Rôle pour l\'inscription à l\'aide du widget d\'inscription';
$string['course_enrolments:abovecourseform'] = 'Au dessus des cours';
$string['course_enrolments:belowcourseform'] = 'En-dessous des cours';
$string['course_enrolments:disabled'] = 'Désactivé';
$string['course_enrolments:displayaddcourse'] = 'Afficher le formulaire d\'ajout de cours';
$string['course_enrolments:expandable'] = 'Extensible';
$string['course_enrolments:progress'] = 'Afficher la progression';
$string['course_enrols:viewotherprofiledash'] = 'Voir le bloc de tableau de bord Dash des autres utilisateurs';
$string['course_enrols:viewprofiledash'] = 'Afficher le bloc de tableau de bord Dash';
$string['coursebutton'] = 'Bouton de cours';
$string['coursecategories'] = 'Catégories de cours';
$string['coursecontent'] = 'Contenu du cours';
$string['coursedata:past'] = 'Passé';
$string['coursedate:future'] = 'Futur';
$string['coursedate:present'] = 'Actuel';
$string['coursedates'] = 'Dates du cours';
$string['courseimage'] = 'Image par défaut du cours';
$string['courseimagedesc'] = 'Téléchargez une image d\'espace réservé à afficher en tant qu\'image de cours pour une image de cours vide.';
$string['courseimagelink'] = 'Lien vers l\'image du cours';
$string['courseoverviewfilesurl'] = 'URL de l\'image du cours';
$string['courseredirecturl'] = 'URL de redirection du cours';
$string['courseredirecturldesc'] = 'Entrez l\'URL pour rediriger les utilisateurs depuis la page d\'index du cours.';
$string['courseshopurl'] = 'URL de la boutique du cours';
$string['coursestafftitle'] = 'Personnel de cours';
$string['coursestartdate_asc'] = 'Par date de début de cours (le plus récent en premier)';
$string['coursestartdate_desc'] = 'Par date de début de cours (le plus ancien en premier)';
$string['coursesummary'] = 'Résumé du cours';
$string['courseurl'] = 'URL du cours';
$string['createcustomdatasource'] = 'Créer une source de données personnalisée';
$string['createcustomlayout'] = 'Créer une mise en page personnalisée';
$string['createdashboard'] = 'Créer un tableau de bord';
$string['createlayout'] = 'Créer une mise en page personnalisée';
$string['cssclass'] = 'Classe CSS';
$string['currentcourse'] = 'Cours actuel';
$string['currentcoursecontext'] = 'Contexte du cours actuel';
$string['currentcoursegroups'] = 'Groupes de cours actuels';
$string['custom'] = 'Personnalisation';
$string['customdatasource'] = 'Source de données personnalisée';
$string['customdatasourcecreated'] = 'La source de données <b>{$a->name}</b> a été créée avec succès.';
$string['customdatasourcedeleted'] = 'Supprimer la source de données personnalisée';
$string['customdatasourceedited'] = 'La source de données <b>{$a->name}</b> a été modifiée avec succès.';
$string['customdatasources'] = 'Sources de données personnalisées';
$string['customfield'] = '{$a->name}';
$string['customfields'] = 'Champs personnalisés';
$string['customlayoutcreated'] = 'La mise en page personnalisée <b>{$a->name}</b> a été créée avec succès.';
$string['customlayoutdeleted'] = 'La mise en page personnalisée <b>{$a->name}</b> a été supprimée avec succès.';
$string['customlayoutedited'] = 'La mise en page personnalisée <b>{$a->name}</b> a été éditée avec succès.';
$string['customsqlfield'] = 'Champ SQL';
$string['customsqlselect'] = 'sélection SQL';
$string['dash:addinstance'] = 'Ajouter un nouveau bloc Dash';
$string['dash:myaddinstance'] = 'Ajouter un nouveau bloc Dash au tableau de bord';
$string['dash:mygroups_addusers'] = 'Ajouter des utilisateurs dans des groupes';
$string['dash:mygroups_creategroup'] = 'Créer des groupes dans les cours inscrits';
$string['dash:mygroups_leavegroup'] = 'Quitter les groupes';
$string['dash:mygroups_view'] = 'Afficher mes propres groupes';
$string['dash:mygroups_viewmembers'] = 'Afficher les membres dans les groupes attribués';
$string['dashboard'] = 'Tableau de bord';
$string['dashboardcreated'] = 'Le tableau de bord <b>{$a->name}</b> a été créé avec succès';
$string['dashboarddeleted'] = 'Tableau de bord <b>{$a->name}</b> supprimé avec succès';
$string['dashboardedited'] = 'Tableau de bord <b>{$a->name}</b> édité avec succès';
$string['dashboardlink'] = 'Lien vers le tableau de bord';
$string['dashboards'] = 'Tableaux de bord';
$string['databaseerror'] = 'Erreur de la base de données. Le contenu ne peut pas être affiché.';
$string['datasource'] = 'Source de données';
$string['datasource:competency_widget'] = 'Widget de graphique des compétences';
$string['datasource:completion_widget'] = 'Widget d\'achèvement de cours';
$string['datasource:completions_data_source'] = 'Achèvement de cours';
$string['datasource:completions_data_source_help'] = 'Liste de cours achevés des utilisateurs.';
$string['datasource:courses_data_source'] = 'Cours';
$string['datasource:courses_data_source_help'] = 'Liste des cours disponibles pour l\'utilisateur actuel.';
$string['datasource:dashboard_data_source'] = 'Tableaux de bord';
$string['datasource:dashboard_data_source_help'] = 'Liste des tableaux de bord';
$string['datasource:enrolments_widget'] = 'Widget Inscriptions';
$string['datasource:logstore_data_source'] = 'Journaux du site';
$string['datasource:logstore_data_source_help'] = 'Source de données des journaux de site';
$string['datasourcemissing'] = 'Source de données manquante';
$string['datasourcename'] = 'Nom de la source de données';
$string['datasources'] = 'Sources de données';
$string['datecompleted'] = 'Date complétée';
$string['daysuntilend'] = 'Jours jusqu\'à la date de fin';
$string['daysuntilstart'] = 'Jours jusqu\'à la date de début';
$string['defaultsortdirection'] = 'Sens du tri';
$string['defaultsortfield'] = 'Triés par';
$string['defaultsortfield_help'] = 'Trier les résultats de la base de données par ce champ. Si la mise en page prend en charge le tri des utilisateurs, ce sera la valeur par défaut.';
$string['delete'] = 'Supprimer';
$string['deleteconfirm'] = 'Voulez-vous vraiment supprimer le tableau de bord <b>{$a->name}</b> ?';
$string['deleteconfirmcustomdatasource'] = 'Voulez-vous vraiment supprimer la source de données personnalisée <b>{$a->name}</b> ?';
$string['deleteconfirmcustomlayout'] = 'Voulez-vous vraiment supprimer la disposition personnalisée <b>{$a->name}</b> ?';
$string['deletecustomdatasource'] = 'Supprimer la source de données personnalisée';
$string['deletecustomlayout'] = 'Supprimer la disposition personnalisée';
$string['deletedashboard'] = 'Supprimer le tableau de bord';
$string['disableall'] = 'Désactiver toutes les sorties Dash';
$string['disableall_help'] = 'Avertissement : à des fins de dépannage ou de dépannage des pages cassées';
$string['disableallmessage'] = 'La sortie Dash est désactivée. Vérifiez les paramètres du tableau de bord.';
$string['dragitem'] = 'Faire glisser l\'élément';
$string['edit'] = 'Modifier';
$string['editcustomdatasource'] = 'Modifier la source de données';
$string['editcustomlayout'] = 'Modifier la mise en page personnalisée';
$string['editdashboard'] = 'Modifier le tableau de bord';
$string['editpreferences'] = 'Modifier les préférences';
$string['editthisblock'] = 'Modifiez les paramètres de ce bloc pour terminer la configuration.';
$string['edituserenrolment'] = 'Modifier l\'inscription de {$a}';
$string['emptystateheading'] = 'État vide';
$string['enabledconditions'] = 'Limiter les données à';
$string['enabledfields'] = 'Champs activés';
$string['enabledfilters'] = 'Filtres activés';
$string['enroldate_asc'] = 'Trier par date d\'inscription (la plus ancienne en premier)';
$string['enroldate_desc'] = 'Trier par date d\'inscription (la plus récente en premier)';
$string['enroldetails'] = 'Détails de l\'inscription';
$string['enroled'] = 'Inscrit';
$string['enrollment'] = 'Inscription';
$string['enrollment_options'] = 'Options d\'inscription';
$string['enrollmentmethod'] = 'Méthode d\'inscription';
$string['enrollmentmethodstatus'] = 'Statut de la méthode d\'inscription';
$string['enrollmentoptions'] = 'Méthodes d\'inscription';
$string['enrollmentoptions:cost'] = 'À partir de {$a->currency} {$a->cost}';
$string['enrollmentoptions:credits'] = '{$a} crédits';
$string['enrollmentoptions:free'] = 'Gratuit';
$string['enrollmentoptions:fromcredits'] = 'À partir de {$a} crédits';
$string['enrollmentoptions:seeoptions'] = 'Voir les options';
$string['enrollments'] = 'Inscriptions';
$string['enrollmentself'] = 'Auto-inscriptions';
$string['enrollmentsnotself'] = 'Inscriptions non-autonomes';
$string['enrollmentstatus'] = 'Statut de l\'inscription';
$string['enrollmenttimeend'] = 'Date de fin d\'inscription';
$string['enrollmenttimestart'] = 'Date de début d\'inscription';
$string['enrolmentmethod'] = 'Méthode d\'inscription';
$string['enrolnow'] = 'Inscrire maintenant';
$string['event_desc_core_event_user_enrolment_created'] = '{$a->relateduserfullname} était inscrit à <a href="{$a->eventurl}" title="View {$a->contextname}">{$a->contextname}</a>';
$string['event_desc_generic'] = '{$a->userfullname} {$a->action} <a href="{$a->eventurl}" title="View {$a->contextname}">{$a->contextname}</a>';
$string['eventbutton'] = 'Bouton de l\'événement';
$string['eventclass'] = 'Classe de l\'événement';
$string['eventcolor'] = 'Couleur de l\'événement';
$string['eventdescription'] = 'Description de l\'événement';
$string['eventicon'] = 'Icône de l\'événement';
$string['eventlink'] = 'Lien de l\'événement';
$string['events'] = 'Événements';
$string['eventtime'] = 'Heure de l\'évènement';
$string['eventurl'] = 'URL de l\'événement';
$string['extracontent'] = 'Contenu supplémentaire';
$string['fieldalert'] = 'La mise en page choisie ne peut pas être personnalisée';
$string['fieldname'] = 'Nom du champ';
$string['fieldnotfound'] = 'Champ non trouvé.';
$string['fields'] = 'Champs';
$string['fieldselect'] = 'Sélectionner le champ SQL';
$string['fontcolor'] = 'Couleur de police';
$string['fontcolor_help'] = 'Propriété de couleur de police CSS (par exemple #ffffff, rgb(255, 255, 255), etc.)';
$string['footercontent'] = 'Contenu du pied de page';
$string['footercontent_help'] = 'Contenu affiché dans le pied du bloc.';
$string['footerfield'] = 'Champ du pied de page';
$string['footerrightfield'] = 'Champ de pied de page (à droite)';
$string['fullnamelinked'] = 'Nom complet (lié au profil)';
$string['generalsettings'] = 'Paramètres généraux';
$string['gotoevent'] = 'Aller à l\'événement';
$string['groupby'] = 'Groupés par';
$string['grouplabel'] = 'Libellé du groupe';
$string['headercontent'] = 'Contenu de l\'en-tête';
$string['headercontent_help'] = 'Contenu affiché dans l\'en-tête du bloc.';
$string['headerfooter'] = 'En-tête et pied de page';
$string['headingfield'] = 'Champ d\'en-tête';
$string['hidecoursecategory'] = 'Ne pas afficher l\'index des catégories/cours';
$string['hidecoursecategorydesc'] = 'Lorsqu\'un utilisateur tente d\'accéder à l\'URL /course/index.php, il sera automatiquement
redirigé vers la page d\'accueil du site, sauf si une URL personnalisée est spécifiée ci-dessous.
Si une URL est spécifiée, les utilisateurs seront redirigés vers cette URL';
$string['hidemycourses'] = 'Masquer les cours auxquels je suis inscrit';
$string['hidewhenempty'] = 'Cacher si vide';
$string['iconfield'] = 'Champ d\'icône';
$string['imageoverlayfield'] = 'Champ de superposition d\'image';
$string['imageoverlayfield_help'] = 'Contenu à afficher sur l\'image avec un arrière-plan uni.';
$string['imageurlfield'] = 'Champ URL de l\'image';
$string['imageurlfield_help'] = 'Choisissez un champ d\'URL d\'image qui sera utilisé dans chaque carte de la grille.';
$string['includesubcategories'] = 'Inclure les sous-catégories';
$string['includesubcategories_help'] = 'Si cette case est cochée, les sous-catégories des catégories choisies seront également incluses dans les résultats.';
$string['invalididnumberunique'] = 'Le numéro d\'identification existe déjà.';
$string['invalidoperator'] = 'Opérateur {$a->operator} non valide.';
$string['invalidshortname'] = 'Nom court non valide. Il ne doit contenir que des lettres a-z, A-Z ou des traits d\'union (-).';
$string['invalidshortnametoolong'] = 'Nom court non valide. Doit contenir 16 caractères ou moins.';
$string['invalidshortnameunique'] = 'Ce nom abrégé est déjà utilisé par un autre tableau de bord.';
$string['invalidwhereclause'] = 'Clause where non valide. Aucune valeur fournie.';
$string['label'] = 'Étiquette';
$string['layout'] = 'Mise en page';
$string['layoutaccordion'] = 'Disposition en accordéon (avec tables)';
$string['layoutaccordion2'] = 'Disposition en accordéon';
$string['layoutcards'] = 'Disposition de la grille';
$string['layoutdoesnotsupportfiltering'] = 'La mise en page choisie ne prend pas en charge le filtrage';
$string['layoutgrid'] = 'Disposition du tableau';
$string['layoutonestat'] = 'Une figure + mise en page d\'étiquette';
$string['layouttimeline'] = 'Disposition de la chronologie';
$string['layouttwostat'] = 'Disposition d\'une figure / autre figure';
$string['layouttype'] = 'Type de mise en page';
$string['loggedinuser'] = 'Utilisateur connecté';
$string['managecustomdatasources'] = 'Gérer les sources de données personnalisées';
$string['managedashboards'] = 'Gérer les tableaux de bord';
$string['managedatasources'] = 'Gérer les sources de données';
$string['managelayouts'] = 'Gérer les mises en page';
$string['maxlimit'] = 'Limité à';
$string['maxlimit_help'] = 'Limiter les résultats de la requête à cette quantité maximum.';
$string['messageurl'] = 'URL des messages';
$string['minheight'] = 'Hauteur minimum';
$string['minheight_help'] = 'Hauteur minimum en pixels pour les blocs.';
$string['missingmustachetemplate'] = 'Modèle mustache manquant.';
$string['mustachetemplate'] = 'Modèle mustache';
$string['mydashboards'] = 'Mes tableaux de bord';
$string['myenrolledcourses'] = 'Les cours auxquels je suis inscrits';
$string['myparticipants'] = 'Mes participants / étudiants';
$string['newblock'] = 'Nouveau tableau de bord';
$string['nocontactsavailable'] = 'Aucun contact disponible';
$string['nocourses'] = 'Aucun cours disponible';
$string['nodashboardsforuser'] = 'Aucun tableau de bord n\'est disponible pour le moment.';
$string['nogroupsavailable'] = 'Aucun groupe disponible';
$string['none'] = 'Aucun';
$string['nonpublicdashboards'] = 'Masquer les tableaux de bord publics';
$string['notachieved'] = 'Non réussi';
$string['notauthorized'] = 'Vous n\'avez pas accès à ce tableau de bord.';
$string['notavailable'] = 'Pas disponible';
$string['openmodule'] = 'Ouvrir le module';
$string['pagination_summary'] = 'Affichage de {$a->limit_from} - {$a->limit_to} sur {$a->total}';
$string['parentrole'] = 'Utilisateurs que j\'administre';
$string['parentrole_help'] = 'Inclut uniquement les utilisateurs auxquels l\'utilisateur actuel a un rôle attribué. Voir "<a href="https://docs.moodle.org/fr/Rôle_parent" target="_blank">Rôle parent</a>."';
$string['parseerror'] = 'Erreur d\'analyse. Le contenu ne peut pas être affiché.';
$string['participationnotcurrent'] = 'Non courant';
$string['permissions'] = 'Restreindre l\'accès à';
$string['permissionscohort'] = 'Cohorte';
$string['permissionsloggedin'] = 'Doit être connecté';
$string['permissionspublic'] = 'Public';
$string['perpage'] = 'Par page';
$string['perpage_help'] = 'Nombre de cartes à afficher en grille par page.';
$string['pictureofuserlinked'] = 'Photo de l\'utilisateur (liée au profil)';
$string['pictureofuserurl'] = 'URL de la photo de l\'utilisateur';
$string['pluginname'] = 'Dash';
$string['privacy:metadata'] = 'Le bloc Dash affiche uniquement des informations sur les cours et ne stocke pas de données lui-même.';
$string['proficient'] = 'Compétent';
$string['progress_help'] = 'Afficher la progression d\'achèvement du cours';
$string['querydebug'] = 'Débogage de la requête';
$string['querytemplate'] = 'Modèle de requête';
$string['querytemplate_help'] = 'Cette requête sera utilisée pour';
$string['querytemplateinstructions'] = 'Espaces réservés : <ul><li><b>%%SELECT%%</b> - Remplacé par toutes les sélections basées sur les définitions de champ. N\'incluez pas vos propres sélections !</li><li><b>%%WHERE%%</b> - Remplacé par des clauses générées à partir de filtres. Vous pouvez ajouter d\'autres clauses en toute sécurité en ajoutant AND après %%WHERE%%</li><li><b>%%GROUPBY%%</b> - Remplacé par un ou plusieurs champs de regroupement en fonction de la source de données</li> <li><b>%%ORDERBY%%</b> - Remplacé par le tri par défaut ou le tri sélectionné par l\'utilisateur (en cliquant sur l\'en-tête de colonne dans un tableau par exemple)</li></ul>';
$string['querytemplatetip'] = 'Astuce : Appuyez sur Ctrl + Espace pour afficher la saisie semi-automatique / saisie automatique lors de la saisie de votre requête.';
$string['readymatewidgets'] = 'Widgets prêts à l\'emploi';
$string['readymatewidgets_help'] = 'Utilisez les widgets ci-dessous, les widgets sont faciles à utiliser, il n\'est pas nécessaire de paramétrer des configurations supplémentaires.';
$string['savechanges'] = 'Sauvegarder les modifications';
$string['secondarynav'] = 'Ajouter à la navigation du cours';
$string['smart_coursebutton'] = 'Bouton de cours intelligent';
$string['sortalpha'] = 'Alphabétiquement';
$string['sortcoursestartdate'] = 'Date de démarrage du cours';
$string['sortenrolmentdate'] = 'Date d\'inscription';
$string['source'] = 'Source';
$string['stattodisplay'] = 'Figure à afficher';
$string['stattodisplayother'] = 'Autre figure à afficher';
$string['status'] = 'Statut';
$string['status:all'] = 'Tout';
$string['status:completed'] = 'Complété';
$string['status:enrolled'] = 'Inscrit';
$string['status:inprogress'] = 'En cours';
$string['status:notyetstarted'] = 'Pas encore commencé';
$string['subheadingfield'] = 'Champ de sous-titre';
$string['subheadingfieldicon'] = 'Icône de sous-titre';
$string['suggestcohort'] = 'Suggérer des utilisateurs qui font partie de la même cohorte';
$string['suggestcohort_desc'] = 'Afficher les utilisateurs avec le même bloc de liste de contacts des utilisateurs d\'intérêts';
$string['suggestcontacts'] = 'Contacts suggérés';
$string['suggestgroups'] = 'Suggérer des utilisateurs qui ont les mêmes groupes';
$string['suggestgroups_desc'] = 'Afficher les utilisateurs avec le même bloc de liste de contacts des utilisateurs d\'intérêts';
$string['suggestinterests'] = 'Suggérer des utilisateurs qui ont les mêmes centres d\'intérêt';
$string['suggestinterests_desc'] = 'Afficher les utilisateurs avec le même bloc de liste de contacts des utilisateurs d\'intérêts';
$string['suggestion:cohort'] = 'Également membre de {$a->cohort}';
$string['suggestion:groups'] = 'Dans votre groupe {$a->group}';
$string['suggestion:interest'] = 'Également intéressé par {$a->interest}';
$string['suggestion:users'] = 'Recommandé sur ce site';
$string['suggestusers'] = 'Suggérer des utilisateurs qui ont les mêmes utilisateurs';
$string['suggestusers_desc'] = 'Afficher les utilisateurs avec le même bloc de liste de contacts des utilisateurs d\'intérêts';
$string['supportsfieldvisibility'] = 'Prend en charge la visibilité sur le terrain';
$string['supportsfieldvisibility_help'] = 'Lorsqu\'il est activé, permet à l\'administrateur d\'activer et de désactiver conditionnellement les champs.';
$string['supportsfiltering'] = 'Prend en charge le filtrage';
$string['supportsfiltering_help'] = 'Lorsque cette option est activée, autoriser le filtrage des résultats. Ceci est géré par la source de données.';
$string['supportspagination'] = 'Prend en charge la pagination';
$string['supportspagination_help'] = 'Lorsqu\'il est activé, les résultats seront automatiquement paginés. La barre de pagination s\'affichera.';
$string['supportssorting'] = 'Prend en charge le tri';
$string['supportssorting_help'] = 'Lorsqu\'il est activé, le tri est autorisé (uniquement avec les tableaux).';
$string['system'] = 'Système';
$string['tabconditions'] = 'Conditions';
$string['tabfields'] = 'Champs';
$string['tabfilters'] = 'Filtres';
$string['tabgeneral'] = 'Général';
$string['tablealias_c'] = 'Cours';
$string['tablealias_cc'] = 'Catégorie de cours';
$string['tablealias_ccp'] = 'Achèvement du cours';
$string['tablealias_dd'] = 'Tableau de bord';
$string['tablealias_e'] = 'Méthode d\'inscription';
$string['tablealias_g'] = 'Groupe';
$string['tablealias_sl'] = 'Journaux du site';
$string['tablealias_u'] = 'Utilisateur';
$string['tablealias_ue'] = 'Inscription des utilisateurs';
$string['tags'] = 'Mots clés';
$string['timesinceevent'] = 'Temps écoulé depuis l\'événement';
$string['titleoverride'] = 'Remplacer le titre';
$string['totalactivities'] = 'Activités totales';
$string['totalactivitiescompletion'] = 'Total des activités (concernant l\'achèvement)';
$string['userprofilelink'] = 'Lien du profil utilisateur';
$string['userprofileurl'] = 'URL du profil utilisateur';
$string['users'] = 'Utilisateurs';
$string['users_help'] = 'La source de données des utilisateurs affiche la liste des utilisateurs disponibles à partir du LMS';
$string['userscompleted'] = 'Utilisateurs complétés';
$string['usersnotcompleted'] = 'Utilisateurs non complétés';
$string['userstat'] = 'Statistiques utilisateur';
$string['viewcourse'] = 'Voir le cours';
$string['viewdetails'] = 'Voir les détails';
$string['viewprofile'] = 'Voir le profil';
$string['widget'] = 'Widget';
$string['widget:course_completions'] = 'Achèvement des cours';
$string['widget:course_completions_help'] = 'Rapport d\'avancement du cours.';
$string['widget:course_enrols'] = 'Widget Inscriptions';
$string['widget:course_enrols_help'] = 'Afficher la liste des cours inscrits avec la progression de l\'achèvement';
$string['widget:groups:adduser'] = 'Ajouter un utilisateur';
$string['widget:groups:chat'] = 'Tchat';
$string['widget:groups:creategroup'] = 'Créer un groupe';
$string['widget:groups:groupmembers'] = 'Voir les membres';
$string['widget:groups:leavegroup'] = 'Quitter le groupe';
$string['widget:mycontacts'] = 'Mes contacts';
$string['widget:mycontacts_help'] = 'Liste des utilisateurs disponibles dans la liste des contacts.';
$string['widget:mygroups'] = 'Mes groupes';
$string['widget:mygroups_help'] = 'Liste des groupes attribués à l\'utilisateur, possibilité d\'afficher les autres membres du groupe, d\'ajouter des membres au groupe, de quitter les groupes, etc.';
$string['widget:mylearning'] = 'Mon apprentissage';
$string['widget:mylearning_help'] = 'Liste des cours qui ont des utilisateurs inscrits avec des informations de base sur les cours telles que le personnel et les badges disponibles et la liste des sections et modules de cours';
$string['widget:skill_graph'] = 'Graphique de compétence';
$string['widget:skill_graph_help'] = 'Rapport de répartition des compétences';
$string['withroles'] = 'Avec rôle(s)';
