<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'calendar', language 'it', version '3.11'.
 *
 * @package     calendar
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityevent'] = 'Evento di attività';
$string['addevent'] = 'Aggiungi eventi';
$string['advancedoptions'] = 'Opzioni avanzate';
$string['allday'] = 'Tutto il giorno';
$string['annually'] = 'Ogni anno';
$string['calendar'] = 'Calendario';
$string['calendarheading'] = 'Calendario {$a}';
$string['calendarpreferences'] = 'Preferenze calendario';
$string['calendartypes'] = 'Tipi di calendario';
$string['calendarurl'] = 'URL del calendario: {$a}';
$string['category'] = 'Categoria';
$string['categoryevent'] = 'Evento di categoria';
$string['categoryevents'] = 'Eventi di categoria';
$string['clickhide'] = 'clicca per nascondere';
$string['clickshow'] = 'clicca per visualizzare';
$string['colactions'] = 'Azioni';
$string['colcalendar'] = 'Calendario';
$string['collastupdated'] = 'Aggiornamento più recente';
$string['colpoll'] = 'Aggiornamento';
$string['commontasks'] = 'Opzioni';
$string['confirmeventdelete'] = 'Sei sicuro di eliminare l\'evento "{$a}"?';
$string['confirmeventseriesdelete'] = 'L\'evento "{$a->name}" fa parte di una serie di eventi. Vuoi eliminare soloq uesto evento o tutta le serie di {$a->count} eventi?';
$string['course'] = 'Corso';
$string['coursecalendar'] = 'Calendario {$a}';
$string['courseevent'] = 'Evento di corso';
$string['courseevents'] = 'Eventi di corso';
$string['courses'] = 'Corsi';
$string['customexport'] = 'Intervallo personalizzato ({$a->timestart} - {$a->timeend})';
$string['daily'] = 'Ogni giorno';
$string['day'] = 'Giorno';
$string['dayeventsmany'] = '{$a->num} eventi, {$a->day}';
$string['dayeventsnone'] = 'Nessun evento, {$a}';
$string['dayeventsone'] = '1 evento, {$a}';
$string['daynext'] = 'Giorno successivo';
$string['dayprev'] = 'Giorno precedente';
$string['dayviewfor'] = 'Visualizzazione giornaliera di:';
$string['dayviewtitle'] = 'Vista giornaliera: {$a}';
$string['daywithnoevents'] = 'Non ci sono eventi questo giorno';
$string['default'] = 'Default';
$string['deleteallevents'] = 'Elimina tutti gli eventi';
$string['deleteevent'] = 'Elimina evento';
$string['deleteevents'] = 'Elimina eventi';
$string['deleteoneevent'] = 'Elimina questo evento';
$string['detailedmonthviewfor'] = 'Visualizzazione mensile di:';
$string['detailedmonthviewtitle'] = 'Vista mensile dettagliata: {$a}';
$string['durationminutes'] = 'Durata in minuti';
$string['durationnone'] = 'Senza durata';
$string['durationuntil'] = 'Fino al';
$string['editevent'] = 'Modifica evento';
$string['erroraddingevent'] = 'Si è verificato un errore durante l\'inserimento dell\'evento';
$string['errorbadsubscription'] = 'La sottoscrizione al calendario non è stata trovata';
$string['errorbeforecoursestart'] = 'Non è possibile impostare un evento prima della data di inizio';
$string['errorcannotimport'] = 'Al momento non puoi impostare una sottoscrizione al calendario.';
$string['errorhasuntilandcount'] = 'In una regola di ricorrenza può essere presente UNTIL o COUNT, ma UNTIL e COUNT non possono essere entrambi presenti nella stessa regola di ricorrenza.';
$string['errorinvalidbydayprefix'] = 'I valori interi che precedono la regola BYDAY possono essere presenti solo per regole di ricorrenza MONTHLY o YEARLY.';
$string['errorinvalidbydaysuffix'] = 'I valori validi per il giorno della settimana parte di una regola BYDAY, sono MO, TU, WE, TH, FR, SA e SU.';
$string['errorinvalidbyhour'] = 'I valori validi per la regola BYHOUR vanno da 0 a 23.';
$string['errorinvalidbyminute'] = 'I valori validi per la regola BYMINUTE vanno da 0 a 59.';
$string['errorinvalidbymonth'] = 'I valori validi per la regola BYMONTH vanno da 1 a 12.';
$string['errorinvalidbymonthday'] = 'I valori validi per la regola BYMONTHDAY vanno da 1 a 31 oppure da -31 a -1';
$string['errorinvalidbysecond'] = 'I valori validi per la regola BYSECOND vanno da 0 a 59.';
$string['errorinvalidbysetpos'] = 'I valori validi per la regola BYSETPOS vanno da 1 a 366 oppure da -366 a -1';
$string['errorinvalidbyweekno'] = 'I valori validi per la regola BYWEEKNO vanno da 1 a 53 oppure da -53 a -1';
$string['errorinvalidbyyearday'] = 'I valori validi per la regola BYYEARDAY vanno da 1 a 366 oppure da -366 a -1';
$string['errorinvaliddate'] = 'Data non corretta';
$string['errorinvalidicalurl'] = 'L\'URL iCal fornita non è valida.';
$string['errorinvalidinterval'] = 'Il valore per le regola INTERVAL deve essere un intero positivo.';
$string['errorinvalidminutes'] = 'Specifica la durata in minuti impostando un numero tra 1 e 999.';
$string['errorinvalidrepeats'] = 'Specifica il numero di eventi impostando un numero tra 1 e 99.';
$string['errormustbeusedwithotherbyrule'] = 'La regola BYSETPOS può essere utilizzata solo in combinazione con un\'altra parte di regola BYxxx.';
$string['errornodescription'] = 'La descrizione è richiesta';
$string['errornoeventname'] = 'Il nome è richiesto';
$string['errornonyearlyfreqwithbyweekno'] = 'Le regola BYWEEKNO è valida solo per le regole YEARLY.';
$string['errorrequiredurlorfile'] = 'Per importare un calendario è necessario un file o un URL.';
$string['errorrrule'] = 'La regole di ricorrenza passata appare non corretta.';
$string['errorrruleday'] = 'Il parametro giorno della regola di ricorrenza non è valido';
$string['errorrrulefreq'] = 'Il parametro frequenza della regola di ricorrenza non è valido';
$string['eventcalendareventcreated'] = 'Creazione evento di calendario';
$string['eventcalendareventdeleted'] = 'Eliminazione evento di calendario';
$string['eventcalendareventupdated'] = 'Aggiornamento evento di calendario';
$string['eventdate'] = 'Data';
$string['eventdescription'] = 'Descrizione';
$string['eventduration'] = 'Durata';
$string['eventendtime'] = 'Scadenza';
$string['eventendtimewrapped'] = '{$a} (Orario di fine)';
$string['eventinstanttime'] = 'Ora';
$string['eventkind'] = 'Tipo di evento';
$string['eventname'] = 'Titolo dell\'evento';
$string['eventnameandcategory'] = '{$a->category}: {$a->name}';
$string['eventnameandcourse'] = '{$a->course}: {$a->name}';
$string['eventnone'] = 'Nessun evento';
$string['eventrepeat'] = 'Ripetizioni';
$string['events'] = 'Eventi';
$string['eventsall'] = 'Tutti gli eventi';
$string['eventsdeleted'] = 'Eventi eliminati';
$string['eventsfor'] = 'Eventi di {$a}';
$string['eventsimported'] = 'Eventi importati: {$a}';
$string['eventskey'] = 'Filtro eventi';
$string['eventsource'] = 'Fonte dell\'evento';
$string['eventspersonal'] = 'I miei eventi';
$string['eventsrelatedtocategories'] = 'Eventi delle categorie';
$string['eventsrelatedtocourses'] = 'Eventi relativi al corso';
$string['eventsrelatedtogroups'] = 'Eventi di gruppo';
$string['eventsskipped'] = 'Eventi saltati: {$a}';
$string['eventstarttime'] = 'Ora d\'inizio';
$string['eventstoexport'] = 'Eventi da esportare';
$string['eventsubscriptioncreated'] = 'Creazione sottoscrizione al calendario';
$string['eventsubscriptiondeleted'] = 'Eliminazione sottoscrizione al calendario';
$string['eventsubscriptioneditwarning'] = 'L\'evento nel calendario fa parte di una sottoscrizione. Eventuali modifiche apportate all\'evento si perderenano se la sottoscrizione verrà eliminata.';
$string['eventsubscriptionupdated'] = 'Aggiornamento sottoscrizione al calendario';
$string['eventsupdated'] = 'Eventi aggiornati: {$a}';
$string['eventtime'] = 'Ora';
$string['eventtype'] = 'Tipo di evento';
$string['eventtypecategory'] = 'di categoria';
$string['eventtypecourse'] = 'di corso';
$string['eventtypeglobal'] = 'globale';
$string['eventtypegroup'] = 'di gruppo';
$string['eventtypemodule'] = 'di modulo';
$string['eventtypeother'] = 'altri';
$string['eventtypesite'] = 'sito';
$string['eventtypeuser'] = 'dell\'utente';
$string['eventview'] = 'Dettagli evento';
$string['expired'] = 'Terminato';
$string['explain_site_timeformat'] = 'È possibile visualizzare l\'orario nel formato a 12 o 24 ore. Scegliendo "default" il formato sarà scelto automaticamente dalle impostazioni della lingua usata nel sito. L\'impostazione può essere modificata dalle preferenze dell\'utente.';
$string['export'] = 'Esportazione';
$string['exportbutton'] = 'Esportazione';
$string['exportcalendar'] = 'Esporta calendario';
$string['exporthelp'] = 'Come sottoscrivere il calendario da altre applicazioni (Google/Outlook/Altre)';
$string['forcecalendartype'] = 'Forza calendario';
$string['fri'] = 'Ven';
$string['friday'] = 'Venerdì';
$string['generateurlbutton'] = 'URL del calendario';
$string['global'] = 'Globali';
$string['globalevent'] = 'Evento globale';
$string['globalevents'] = 'Eventi globali';
$string['gotoactivity'] = 'Vai all\'attività';
$string['gotocalendar'] = 'Vai al calendario';
$string['group'] = 'Gruppo';
$string['groupevent'] = 'Evento di gruppo';
$string['groupevents'] = 'Eventi di gruppo';
$string['hideeventtype'] = 'Nascondi eventi {$a}';
$string['hourly'] = 'Ogni ora';
$string['importcalendar'] = 'Importa calendario';
$string['importcalendarfrom'] = 'Importa da';
$string['importcalendarheading'] = 'Importa calendario...';
$string['importfromfile'] = 'File calendario (.ics)';
$string['importfrominstructions'] = 'Per favore fornisci un URL di un calendario remoto oppure carica un file.';
$string['importfromurl'] = 'URL calendario';
$string['invalideventtype'] = 'Il tipo di evento selezionato non è valido.';
$string['invalidtimedurationminutes'] = 'La durata in minuti dell\'evento non è valida. La durata in minuti deve essere maggiore di 0, oppure non selezionare una durata.';
$string['invalidtimedurationuntil'] = 'La data e l\'orario di fine evento sono precedenti alla data di inizio. Per proseguire devi correggere questi valori.';
$string['iwanttoexport'] = 'Esporta';
$string['less'] = 'Di meno';
$string['managesubscriptions'] = 'Gestione sottoscrizioni';
$string['manyevents'] = '{$a} eventi';
$string['mon'] = 'Lun';
$string['monday'] = 'Lunedi';
$string['monthly'] = 'Ogni mese';
$string['monthlyview'] = 'Vista mensile';
$string['monthnext'] = 'Prossimo mese';
$string['monthprev'] = 'Mese precedente';
$string['monththis'] = 'Questo mese';
$string['more'] = 'Di più';
$string['namewithsource'] = '{$a->name} ({$a->source})';
$string['never'] = 'Mai';
$string['newevent'] = 'Nuovo evento';
$string['nocalendarsubscriptions'] = 'Non hai sottoscrizioni al calendario';
$string['notitle'] = 'senza titolo';
$string['noupcomingevents'] = 'Non ci sono eventi in programma per i prossimi giorni.';
$string['oneevent'] = '1 evento';
$string['pollinterval'] = 'Frequenza di aggiornamento';
$string['pollinterval_help'] = 'La frequenza di aggiornamento degli eventi del calendario';
$string['pref_lookahead'] = 'Cerca prossimi eventi';
$string['pref_lookahead_help'] = 'Imposta il numero massimo di giorni futuri entro i quali cercare eventi. Eventi che iniziano successivamente non saranno visualizzati. Da notare che <strong>non ci sono garanzie</strong> che gli eventi compresi nell\'intervallo di giorni specificato vengano effettivamente visualizzati: se ci sono più eventi di quanti impostati in
"Max. prossimi eventi" gli interventi che superano questo valore non saranno visualizzati.';
$string['pref_maxevents'] = 'Max. prossimi eventi';
$string['pref_maxevents_help'] = 'Imposta il numero massimo visualizzabile di prossimi eventi. Se scegli un numero alto è possibile che la visualizzazione degli eventi occupi molto spazio nella schermata.';
$string['pref_persistflt'] = 'Ricorda le impostazioni del filtro';
$string['pref_persistflt_help'] = 'Abilitando questa impostazione, Moodle ricorderà le tue impostazioni di filtraggio eventi nelle sessioni future.';
$string['pref_startwday'] = 'Primo giorno della settimana';
$string['pref_startwday_help'] = 'Nel calendario le settimane cominceranno nel giorno impostato.';
$string['pref_timeformat'] = 'Formato ora';
$string['pref_timeformat_help'] = 'È possibile visualizzare l\'orario nel formato a 12 o 24 ore. Scegliendo "default" il formato sarà scelto automaticamente dalle impostazioni della lingua usata nel sito.';
$string['preferences'] = 'Preferenze';
$string['preferences_available'] = 'Le tue preferenze';
$string['preferredcalendar'] = 'Calendario preferito';
$string['privacy:metadata:calendar:event'] = 'Il componente Calendario memorizza i dettagli degli eventi di calendario dell\'utente all\'interno del sottosistema core.';
$string['privacy:metadata:calendar:event:description'] = 'Descrizione dell\'evento di calendario.';
$string['privacy:metadata:calendar:event:eventtype'] = 'Tipo dell\'evento di calendario.';
$string['privacy:metadata:calendar:event:name'] = 'Nome dell\'evento di calendario.';
$string['privacy:metadata:calendar:event:timeduration'] = 'Durata dell\'evento di calendario.';
$string['privacy:metadata:calendar:event:timestart'] = 'Data e ora di inizio dell\'evento di calendario.';
$string['privacy:metadata:calendar:event_subscriptions'] = 'Il componente Calendario memorizza i dettagli delle sottoscrizioni al calendario dell\'utente all\'interno del sottosistema core.';
$string['privacy:metadata:calendar:event_subscriptions:eventtype'] = 'Tipo di evento della sottoscrizione al calendario.';
$string['privacy:metadata:calendar:event_subscriptions:name'] = 'Nome della sottoscrizione al calendario.';
$string['privacy:metadata:calendar:event_subscriptions:url'] = 'URL della sottoscrizione al calendario.';
$string['privacy:metadata:calendar:preferences:calendar_savedflt'] = 'Preferenza dell\'utente sulla visualizzazione del tipo dell\'evento di calendario.';
$string['recentupcoming'] = 'Recenti e dei prossimi 60 giorni';
$string['repeatedevents'] = 'Evento ripetuto';
$string['repeateditall'] = 'Applica i cambiamenti anche a tutti gli altri {$a}  eventi presenti in questa serie';
$string['repeateditthis'] = 'Applica cambiamenti solo per questo evento';
$string['repeatevent'] = 'Ripeti l\'evento';
$string['repeatnone'] = 'Senza ripetizioni';
$string['repeatweeksl'] = 'Ripetizioni settimanali';
$string['repeatweeksr'] = 'eventi';
$string['sat'] = 'Sab';
$string['saturday'] = 'Sabato';
$string['showeventtype'] = 'Visualizza eventi {$a}';
$string['shown'] = 'visibili';
$string['site'] = 'Sito';
$string['siteevent'] = 'Eventi del sito';
$string['siteevents'] = 'Eventi del sito';
$string['spanningevents'] = 'Eventi in corso';
$string['subscriptionname'] = 'Nome del calendario';
$string['subscriptionremoved'] = 'La sottoscrizione del calendario {$a} è stata rimossa';
$string['subscriptions'] = 'Sottoscrizioni';
$string['subscriptionsource'] = 'Fonte dell’evento: {$a}';
$string['subscriptionupdated'] = 'La sottoscrizione del calendario {$a} è stata aggiornata';
$string['sun'] = 'Dom';
$string['sunday'] = 'Domenica';
$string['thu'] = 'Gio';
$string['thursday'] = 'Giovedì';
$string['timeformat_12'] = '12 ore (am/pm)';
$string['timeformat_24'] = '24 ore';
$string['timeperiod'] = 'Periodo di tempo';
$string['today'] = 'Oggi';
$string['todayplustitle'] = 'Oggi {$a}';
$string['tomorrow'] = 'Domani';
$string['tt_deleteevent'] = 'Elimina evento';
$string['tt_editevent'] = 'Modifica evento';
$string['tue'] = 'Mar';
$string['tuesday'] = 'Martedì';
$string['typecategory'] = 'Evento di categoria';
$string['typeclose'] = 'Chiudi evento';
$string['typecourse'] = 'Evento di corso';
$string['typedue'] = 'Evento in scadenza';
$string['typegradingdue'] = 'Valutazione in scadenza';
$string['typegroup'] = 'Evento di gruppo';
$string['typeopen'] = 'Apri evento';
$string['typesite'] = 'Evento globale';
$string['typeuser'] = 'Evento dell\'utente';
$string['upcomingevents'] = 'Prossimi eventi';
$string['upcomingeventsfor'] = 'Prossimi eventi di:';
$string['urlforical'] = 'URL di esportazione di iCalendar, per l\'iscrizione al calendario';
$string['user'] = 'Utente';
$string['userevent'] = 'Evento dell\'utente';
$string['userevents'] = 'Eventi dell\'utente';
$string['viewupcomingactivitiesdue'] = 'Visualizza le prossime attività da svolgere';
$string['wed'] = 'Mer';
$string['wednesday'] = 'Mercoledì';
$string['weekly'] = 'Ogni settimana';
$string['weeknext'] = 'Prossima settimana';
$string['weekthis'] = 'Questa settimana';
$string['when'] = 'Quando';
$string['whendate'] = 'Quando: {$a}';
$string['yesterday'] = 'Ieri';
$string['youcandeleteallrepeats'] = 'Questo evento è parte di una serie di eventi ripetuti. Puoi eliminare solo questo evento, oppure tutti gli eventi in questa serie ({$a}) in un colpo solo.';
