<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'analytics', language 'da', version '3.11'.
 *
 * @package     analytics
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['analysablenotused'] = 'Analyserbar {$a->analysableid} ikke brugt: {$a->errors}';
$string['analysablenotvalidfortarget'] = 'Analyserbar {$a->analysableid} er ikke gyldig til denne destination: {$a->result}';
$string['analysisinprogress'] = 'Bliver stadig analyseret af en tidligere kørsel';
$string['analytics'] = 'Analyser';
$string['analyticsdisabled'] = 'Analyser er deaktiveret. Du kan aktivere det under "Siteadministration > Avancerede funktoner".';
$string['analyticslogstore'] = 'Loglager brugt til analyser';
$string['analyticslogstore_help'] = 'Det loglager der vil blive brugt af analyse-API til læsning af brugeres aktivitet.';
$string['analyticssettings'] = 'Analyseindstillinger';
$string['analyticssiteinfo'] = 'Site-information';
$string['defaultpredictionsprocessor'] = 'Standard forudsigelsesprosessor';
$string['defaultpredictoroption'] = 'Standard processor ({$a})';
$string['defaulttimesplittingmethods'] = 'Standard analyseinterval for modellens evaluering';
$string['defaulttimesplittingmethods_help'] = 'Analyseintervallet definerer hvornår systemet beregner forudsigelser og de aktivitetslogs der vil tages i betragtning til disse forudsigelser. Modellens evalueringsproces vil gentages gennem disse analyseintervaller med mindre et specifikt analyseinterval er angivet.';
$string['disabledmodel'] = 'Deaktiveret model';
$string['erroralreadypredict'] = 'Filen {$a} er allerede blevet brugt til generering af forudsigelser.';
$string['errorcannotreaddataset'] = 'Datasætfilen {$a} kan ikke læses.';
$string['errorcannotusetimesplitting'] = 'Det givne analyseinterval kan ikke bruges på denne model.';
$string['errorcannotwritedataset'] = 'Der kan ikke skrives i datasætfilen {$a}.';
$string['errorexportmodelresult'] = 'Maskinlærings-modellen kan ikke eksporteres.';
$string['errorimport'] = 'Fejl under import af den leverede JSON-fil.';
$string['errorimportmissingclasses'] = 'Følgende analysekomponenter er ikke tilgængelige på dette websted: {$a->missingclasses}.';
$string['errorimportmissingcomponents'] = 'Den leverede model kræver at følgende plugins installeres: {$a}. Bemærk at versionerne ikke nødvendigvis skal svare til dem der er installeret på dit websted. Installation af samme eller nyere version af plugin\'et vil i de fleste situationer være fint.';
$string['errorimportversionmismatches'] = 'Versionen af følgende komponenter er ikke den samme som dem på dit websted: {$a}. Du kan bruge indstillingen "Ignorer inkonsistens på version" til ignorering af disse forskelle.';
$string['errorinvalidcontexts'] = 'Nogle af de valgte kontekster kan ikke bruges i dette mål.';
$string['errorinvalidindicator'] = 'Ugyldig {$a} indikator';
$string['errorinvalidtarget'] = 'Ugyldig {$a} destination';
$string['errorinvalidtimesplitting'] = 'Ugyldigt analyseinterval. Kontroller at du har tilføjet det fulde klassenavn.';
$string['errornocontextrestrictions'] = 'Den valgte destination understøtter ikke restriktioner på kontekster';
$string['errornoexportconfig'] = 'Der opstod et problem under eksport af modellens konfiguration.';
$string['errornoexportconfigrequirements'] = 'Kun ikke-statiske modeller med et analyseinterval kan eksporteres';
$string['errornoindicators'] = 'Denne model har ingen indikatorer.';
$string['errornopredictresults'] = 'Ingen resultater returneret fra forudsigelsesprocessoren. Tjek output-mappens indhold for mere information.';
$string['errornoroles'] = 'Roller på studerende eller lærer er ikke defineret. Definer dem på siden med analyseindstillinger.';
$string['errornotarget'] = 'Denne model har ikke nogen destination.';
$string['errornotimesplittings'] = 'Denne model har ikke et analyseinterval.';
$string['errorpredictioncontextnotavailable'] = 'Denne forudsigelseskontekst er ikke længere tilgængelig';
$string['errorpredictionformat'] = 'Forkert format på forudsigelsesberegninger';
$string['errorpredictionnotfound'] = 'Ingen forudsigelse fundet';
$string['errorpredictionsprocessor'] = 'Fejl i forudsigelsesprocessor: {$a}';
$string['errorunknownaction'] = 'Ukendt handling';
$string['fixedack'] = 'Godkend';
$string['incorrectlyflagged'] = 'Forkert markeret';
$string['insightinfomessageaction'] = '{$a->text}: {$a->url}';
$string['levelinstitution'] = 'Uddannelsesniveau';
$string['modeinstruction'] = 'Instruktionsmåder';
$string['modeinstructionblendedhybrid'] = 'Blandet eller hybrid';
$string['modeinstructionfullyonline'] = 'Helt online';
$string['modeloutputdir'] = 'Output-mappe for modeller';
$string['modeloutputdirinfo'] = 'Mappen hvori forudsigelsesprocessorer gemmer al evalueret info. God til debugging og research.';
$string['modeltimelimit'] = 'Grænse for analysetid per model';
$string['modeltimelimitinfo'] = 'Indstillingen begrænser hvor længe modellen kan bruge til at analysere webstedets indhold.';
$string['nodata'] = 'Ingen data at analysere';
$string['nonewdata'] = 'Der foreligger ingen nye data. Modellen vil blive analyseret efter det næste analyseinterval.';
$string['nopredictionsyet'] = 'Ingen forudsigelser tilgængelige endnu';
$string['notapplicable'] = 'Ikke relevant';
$string['notuseful'] = 'Ikke brugbar';
$string['novaliddata'] = 'Ingen gyldige data til rådighed';
$string['onlycli'] = 'Kørsel af analyseprocesser kun via kommandolinje';
$string['onlycliinfo'] = 'Analyseprocesser såsom evalueringsmodeller, algoritmer til maskinlærings-træning eller få forudsigelser kan tage sin tid. De kan køre som cron-jobs eller kan startes via en kommandolinje. Er indstillingen deaktiveret, kan analyseprocesser kun køres fra web-interfacet.';
$string['percentonline'] = 'Procent online';
$string['percentonline_help'] = 'Hvis din organisation tilbyder blandede eller hybride kurser, hvor mange procent af de studerendes arbejde udføres da online i Moodle? Skriv et tal mellem 0 og 100.';
$string['predictionsprocessor_help'] = 'En forudsigelsesprocessor er den maskinlærings-backend, der bearbejder de datasæt der generes af beregningsmodellernes indikatorer og destination. Modellerne kan bruge forskellige processorer. Den der er specificeret her, vil være standard.';
$string['processingsitecontents'] = 'Behandler sitets indhold';
$string['timesplittingmethod_link'] = 'Time_splitting_methods';
$string['typeinstitution'] = 'Type institution';
$string['typeinstitutionacademic'] = 'Akademisk';
$string['typeinstitutionngo'] = 'Ikke-statslig organisation (NGO)';
$string['useful'] = 'Brugbar';
