<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'da', version '3.11'.
 *
 * @package     mnet
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS (selvsigneret)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (signeret)';
$string['RPC_HTTP_PLAINTEXT'] = 'HTTP ukrypteret';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (selvsigneret)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (signeret)';
$string['aboutyourhost'] = 'Vedrørende din server';
$string['accesslevel'] = 'Adgangsniveau';
$string['addhost'] = 'Gem';
$string['addnewhost'] = 'Tilføj en vært';
$string['addtoacl'] = 'Føj til adgangskontrol';
$string['allhosts'] = 'Alle værter';
$string['allhosts_no_options'] = 'Der er ingen valgmuligheder under visning af flere værter';
$string['allow'] = 'Tillad';
$string['applicationtype'] = 'Applikationstype';
$string['authfail_nosessionexists'] = 'Godkendelsen mislykkedes: mnet sessionen eksisterer ikke.';
$string['authfail_sessiontimedout'] = 'Godkendelsen mislykkedes: Mnet-sessionen har timeout.';
$string['authfail_usermismatch'] = 'Godkendelsen mislykkedes: Forkert brugernavn.';
$string['authmnetdisabled'] = 'MNet godkendelses-plugin er <strong>deaktiveret</strong>.';
$string['badcert'] = 'Dette er ikke et gyldigt certifikat.';
$string['certdetails'] = 'Cert-oplysninger';
$string['configmnet'] = 'MNet muliggør kommunikation mellem denne server og andre servere og servicer.';
$string['couldnotgetcert'] = 'Der blev ikke fundet et certifikat på  <br />{$a}.<br /> Værten kan være nede eller ikke konfigureret rigtigt.';
$string['couldnotmatchcert'] = 'Dette matcher ikke det certifikat der p.t. er publiseret på webserver.';
$string['courses'] = 'kurser';
$string['courseson'] = 'kurser på';
$string['current_transport'] = 'Aktuelle transport';
$string['currentkey'] = 'Nuværende offentlige nøgle';
$string['databaseerror'] = 'Oplysningerne kunne ikke tilføjes databasen.';
$string['deleteaserver'] = 'Sletter en server';
$string['deletedhostinfo'] = 'Denne vært er blevet slettet. Du kan fortryde ved at skifte slettet-status tilbage til "Nej".';
$string['deletedhosts'] = 'Slettede værter: {$a}';
$string['deletehost'] = 'Slet vært';
$string['deletekeycheck'] = 'Bekræft at du vil slette denne nøgle';
$string['deleteoutoftime'] = 'Dit 60-sekundersvindue til at slette denne nøgle er udløbet. Start forfra.';
$string['deleteuserrecord'] = 'SSO ACL: Slet posten for brugeren "{$a->user}" fra {$a->host}.';
$string['deletewrongkeyvalue'] = 'Der er opstået en fejl. Hvis ikke du var ved at slette din servers ssl-nøgle har du måske været genstand for et ondsindet angreb. Ingen handling er sat i værk.';
$string['deny'] = 'Afvis';
$string['description'] = 'Beskrivelse';
$string['duplicate_usernames'] = 'Det lykkedes ikke at oprette et indeks for kolonnerne "mnethostid" og "username" i din brugertabel.<br />Dette kan ske når du har <a href="{$a}" target="_blank">ens brugernavne i din brugertabel</a>.<br />Du kan godt opgradere alligevel. Klik på linket ovenfor og få et nyt vindue med anvisning på hvad du gør ved det problem. Det kan du tage dig af når opgraderingen er færdig.<br />';
$string['enabled_for_all'] = '(Denne service er aktiveret for alle værter).';
$string['enterausername'] = 'Angiv et brugernavn eller en liste med brugernavne adskilt af komma.';
$string['error7020'] = 'Denne fejl opstår gerne når fjernsitet har dannet en post for dig med den forkerte wwwroot, for eksempel https://minskole.dk i stedet for https://www.minskole.dk. Du bedes kontakte administratoren for fjernsitet med din wwwroot (som angivet i config.php) og bede om at angivelsen af din host opdateres.';
$string['error7022'] = 'Beskeden du sendte til fjernsitet var krypteret korrekt men ikke signeret. Dette er meget uventet; du bør indsende en fejlbesked hvis fejlen opstår (og angive så meget information som muligt om programversion, tidspunkt osv.)';
$string['error7023'] = 'Fjernsitet har forsøgt at dekrypteret din besked med alle de nøger der er registreret for dit site. Disse har alle fejlet. Du kan måske løse problemet ved manuelt at tilknytte nøglen til fjernsitet. Dette sker sandsynligvis kun hvis du ikke har kommunikeret med fjernsitet i et par måneder.';
$string['error7024'] = 'Du har sendt en ukrypteret besked til fjernsitet, men fjernsistet accepterer ikke ukrypteret kommunikation fra dit websted. Dette er meget uventet; du bør nok indsende en fejlrapport hvis dette sker (og angive så meget information som muligt om programversion, tidspunkt mv.)';
$string['error7026'] = 'Den nøgle din besked er underskrevet med, afviger fra den nøgle som fjernsitet har registreret for din server. Ydermere har fjernsitet forsøgt at hente din nuværende nøgle, men det mislykkedes. Forsøg at knytte nøglen til fjernsitet manuelt.';
$string['error709'] = 'Fjernsitet kunne ikke hente en SSL nøgle fra dig.';
$string['eventaccesscontrolcreated'] = 'Adgangskontrol oprettet';
$string['eventaccesscontrolupdated'] = 'Adgangskontrol opdateret';
$string['expired'] = 'Denne nøgle udløb den';
$string['expires'] = 'Gyldig indtil:';
$string['expireyourkey'] = 'Slet denne nøgle';
$string['expireyourkeyexplain'] = 'Moodle udskifter automatisk dine nøgĺer hver 28. dag (som udgangspunkt), men du kan altid <em>manuelt</em> fjerne nøglen hvis du mener den er blevet kompromitteret. En ny nøgle vil da straks blive genereret. <br />Sletter du nøglen vil andre applikationer ikke kunne kommunikere med dig, før du manuelt har kontaktet hver administrator og givet dem den nye nøgle.';
$string['exportfields'] = 'Felter til eksport';
$string['failedaclwrite'] = 'Det mislykkedes at skrive til MNets adgangskontrolliste for brugeren "{$a}".';
$string['findlogin'] = 'Find Login';
$string['forbidden-function'] = 'Den funktion er ikke aktiveret for RPC.';
$string['forbidden-transport'] = 'Den transportmetode du prøver at anvende, er ikke tilladt.';
$string['forcesavechanges'] = 'Gennemtving gem ændringer';
$string['helpnetworksettings'] = 'Konfigurer MNet-kommunikation';
$string['hidelocal'] = 'Skjul lokale brugere';
$string['hideremote'] = 'Skjul fjernbrugere';
$string['host'] = 'Vært';
$string['hostcoursenotfound'] = 'Vært eller kursus blev ikke fundet';
$string['hostdeleted'] = 'Vært slettet';
$string['hostexists'] = 'Der findes allerede en post for en vært med det navn (det kan være slettet). <a href="{$a}">Klik her</a> for at ændre posten.';
$string['hostlist'] = 'Liste med netværks-værter';
$string['hostname'] = 'Værtsnavn';
$string['hostnamehelp'] = 'Det fulde domænenavn på fjernværten, f.eks. www.eksempel.dk';
$string['hostnotconfiguredforsso'] = 'Denne server er ikke konfigureret til eksterne login.';
$string['hostsettings'] = 'Værtsindstillinger';
$string['http_self_signed_help'] = 'Tillad forbindelse ved brug af et selvsigneret DIY SSL-certifikat på fjernværten.';
$string['http_verified_help'] = 'Tillad forbindelse ved brug af et verificeret DIY SSL-certifikat på fjernværten, men over http (ikke https)';
$string['https_self_signed_help'] = 'Tillad forbindelse ved brug af et selvsigneret DIY SSL i PHP på fjernværten over http.';
$string['https_verified_help'] = 'Tillad forbindelse ved brug af et verificeret DIY SSL-certifikat på fjernværten.';
$string['id'] = 'Id';
$string['idhelp'] = 'Denne værdi tildeles automatisk og kan ikke ændres';
$string['importfields'] = 'Felter til import';
$string['inspect'] = 'Gennemse';
$string['installnosuchfunction'] = 'Kodefejl! Noget prøver at installere en mnet xmlrpc-funktion ({$a->method}) fra en fil ({$a->file}) og den er ikke at finde!';
$string['installnosuchmethod'] = 'Kodefejl! Noget prøver at installere en mnet xmlrpc-funktion ({$a->method}) på en klasse ({$a->class}) og den er ikke at finde!';
$string['installreflectionclasserror'] = 'Kodefejl! MNets introspection fejlede for metoden "{$a->method}" i class\'en "{$a->class}". Den originale fejlbesked, såfremt det er en hjælp, er: "{$a->error}"';
$string['installreflectionfunctionerror'] = 'Kodningsfejl! MNet-introspektion mislykkedes for funktionen "{$a->method}" i filen "{$a->file}".  Den oprindelige fejlmeddelelse, hvis den hjælper, er: "{$a->error}"';
$string['invalidaccessparam'] = 'Ugyldig adgangsparameter';
$string['invalidactionparam'] = 'Ugyldig handlingsparameter';
$string['invalidhost'] = 'Du skal angive en gyldig vært-identifikator';
$string['invalidpubkey'] = 'Nøglen er ikke en gyldig ssl-nøgle';
$string['invalidurl'] = 'Ugyldig URL-parameter';
$string['ipaddress'] = 'IP-adresse';
$string['is_in_range'] = 'IP-adressen  <code>{$a}</code>  repræsenterer en valideret vært, der er tillid til';
$string['ispublished'] = '{$a} har aktiveret denne service for dig';
$string['issubscribed'] = '{$a} abonnerer på denne service på din vært.';
$string['keydeleted'] = 'Din nøgle er slettet og erstattet.';
$string['keymismatch'] = 'Den offentlige nøgle du har på denne vært er ikke den samme som den offentliggjorte, som er: ';
$string['last_connect_time'] = 'Senest oprettede forbindelse';
$string['last_connect_time_help'] = 'Sidste gang du oprettede forbindelse til denne vært.';
$string['last_transport_help'] = 'Den transport du brugte til sidste forbindelse til denne vært.';
$string['leavedefault'] = 'Brug standard indstillinger i stedet';
$string['listservices'] = 'Oplist services';
$string['loginlinkmnetuser'] = '<br />Hvis du er en Moodle Netværks-fjernbruger og du kan <a href="{$a}">bekræfte din e-mailadresse her</a>, kan du blive sendt direkte til din loginside.<br />';
$string['logs'] = 'logs';
$string['managemnetpeers'] = 'Håndter peers';
$string['method'] = 'Metode';
$string['methodhelp'] = 'Hjælp til metode for {$a}';
$string['methodsavailableonhost'] = 'Metoder tilgængelige på {$a}';
$string['methodsavailableonhostinservice'] = 'Tilgængelige metoder for {$a->service} på {$a->host}';
$string['methodsignature'] = 'Metode signatur for {$a}';
$string['mnet'] = 'MNet';
$string['mnet_concatenate_strings'] = 'Sammenkæd (op til) 3 strenge og vis resultatet';
$string['mnet_session_prohibited'] = 'Brugerne fra din hjemmeserver har pt. ikke tilladelse til at roame til {$a}.';
$string['mnetdisabled'] = 'MNet er <strong>deaktiveret</strong>.';
$string['mnetidprovider'] = 'MNet ID-udbyder';
$string['mnetidproviderdesc'] = 'Du kan bruge denne facilitet til at få et link du kan logge ind på, hvis du opgiver korrekt mailadresse der matcher det brugernavn du tidligere loggede ind med.';
$string['mnetidprovidermsg'] = 'Du skulle kunne logge ind hos din {$a}-udbyder.';
$string['mnetidprovidernotfound'] = 'Beklager, men der blev ikke fundet yderligere information.';
$string['mnetpeers'] = 'Peers';
$string['mnetservices'] = 'Servicer';
$string['mnetsettings'] = 'MNet-indstillinger';
$string['moodle_home_help'] = 'Stien til MNet på den eksterne vært, f.eks. /moodle/.';
$string['name'] = 'Navn';
$string['net'] = 'Netværk';
$string['networksettings'] = 'Netværksindstillinger';
$string['never'] = 'Aldrig';
$string['noaclentries'] = 'Intet opført i SSO-adgangskontrollisten.';
$string['noaddressforhost'] = 'Beklager, men værtsnavnet ({$a}) kunne ikke oversættes!';
$string['nocurl'] = 'PHP cURL-biblioteket er ikke installeret';
$string['nolocaluser'] = 'Der er ingen lokal post for denne fjernbruger, og den kan ikke oprettes da denne vært ikke vil auto-oprette brugere. Kontakt din administrator!';
$string['nomodifyacl'] = 'Du har ikke tilladelse til at redigere adgangskontrollisten til MNET .';
$string['nonmatchingcert'] = 'Genstanden for certifikatet: <br /><em>{$a->subject}</em><br /> matcher ikke den vært den kom fra:<br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'Der var problemer med at modtage den offentlige nøgle.<br />Måske tillader værten ikke MNet eller måske er nøglen ugyldig.';
$string['nosite'] = 'Kunne ikke finde kursus på site-niveau';
$string['nosuchfile'] = 'Filen/funktionen {$a} eksisterer ikke.';
$string['nosuchfunction'] = 'Ude af stand til at lokalisere funktionen eller funktionen er forhindret for RPC';
$string['nosuchmodule'] = 'Funktionen havde forkert adresse og kunne ikke lokaliseres. Brug formatet mod/modulename/lib/functionname';
$string['nosuchpublickey'] = 'Det var ikke muligt at skaffe en offentlig nøgle til verificering af signatur.';
$string['nosuchservice'] = 'RPC-servicen kører ikke på denne vært.';
$string['nosuchtransport'] = 'Der er ingen transport med den id.';
$string['notBASE64'] = 'Strengen er ikke i formatet base64. Den kan ikke være en gyldig nøgle.';
$string['notPEM'] = 'Denne nøgle er ikke i PEM-format. Den vil ikke fungere.';
$string['not_in_range'] = 'IP-adressen <code>{$a}</code> repræsenterer ikke en valideret vært der er tillid til.';
$string['notenoughidpinfo'] = 'Din identitetsudbyder leverer ikke tilstrækkelig information til oprettelse eller opdatering af din konto lokalt. Beklager!';
$string['notinxmlrpcserver'] = 'Forsøg på at tilgå den eksterne MNet-klient, ikke under XMLR PC-serverkørsel';
$string['notmoodleapplication'] = 'ADVARSEL: Dette er ikke en Moodle-applikation, så nogle af inspektionsmetoderne virker måske ikke ordentligt.';
$string['notpermittedtojump'] = 'Du har ikke tilladelse til at starte en  ekstern session fra denne Moodle-server.';
$string['notpermittedtojumpas'] = 'Du kan ikke starte en fjernsession mens du er logget ind som en anden bruger';
$string['notpermittedtoland'] = 'Du har ikke tilladelse til at starte en  ekstern session.';
$string['off'] = 'Fra';
$string['on'] = 'Til';
$string['options'] = 'Valgmuligheder';
$string['peerprofilefielddesc'] = 'Her kan du tilsidesætte de generelle indstillinger for hvilke profilområderer der sendes og importeres når nye brugere oprettes';
$string['permittedtransports'] = 'Tilladte transporter';
$string['phperror'] = 'En intern PHP-fejl forhindrede din forespørgsel i at blive gennemført.';
$string['position'] = 'Position';
$string['postrequired'] = 'Slettefunktionen kræver en POST-forespørgsel';
$string['privacy:metadata'] = 'Plugin\'et MNet gemmer ingen personlige data.';
$string['profileexportfields'] = 'Felter at sende';
$string['profilefielddesc'] = 'Her kan du konfigurere listen med profilfelter der sendes og modtages over MNet når brugere oprettes eller opdateres. Du kan også tilsidesætte dette for hver enkelt MNet-peer. Bemærk at følgende felter altid sendes og ikke er frivillige: {$a}';
$string['profilefields'] = 'Profilområder';
$string['profileimportfields'] = 'Felter til import';
$string['promiscuous'] = 'Promiskuøs';
$string['publickey'] = 'Offentlig nøgle';
$string['publickey_help'] = 'Den offentlige nøgle er automatisk modtaget fra den eksterne server.';
$string['publickeyrequired'] = 'Du skal levere en offentlig nøgle';
$string['publish'] = 'Offentliggør';
$string['reallydeleteserver'] = 'Er du sikker på at du vil slette serveren?';
$string['receivedwarnings'] = 'Følgende advarsler er modtaget';
$string['recordnoexists'] = 'Posten eksisterer ikke.';
$string['reenableserver'] = 'Nej - vælg denne mulighed for at tillade denne server igen.';
$string['registerallhosts'] = 'Registrer alle værter (promiscuous mode)';
$string['registerallhostsexplain'] = 'Du kan vælge at registrere alle værter, der automatisk prøver at forbinde til dig. Det betyder at en post vil blive tilføjet i din værts-liste for hvert MNet-websted, der forbinder til dig og beder om din offentlige nøgle.<br />Herunder har du mulighed for at konfigurere servicer for "Alle værter" og ved at aktivere nogle servicer der, kan du vilkårligt tilbyde servicer til eksterne Moodle-servere.';
$string['registerhostsoff'] = 'Register alle værter der pt. er <b>off</b>';
$string['registerhostson'] = 'Register alle værter der pt. er <b>on</b>';
$string['remotecourses'] = 'Eksterne kurser';
$string['remotehost'] = 'Ekstern host';
$string['remotehosts'] = 'Eksterne værter';
$string['remoteuser'] = 'Fjernbruger {$a->remotetype}';
$string['remoteuserinfo'] = 'Profil hentet fra <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Netværkning kræver OpenSSL-udvidelse';
$string['restore'] = 'Gendan';
$string['returnvalue'] = 'Returværdi';
$string['reviewhostdetails'] = 'Gennemse værtsoplysninger';
$string['reviewhostservices'] = 'Gennemse værtsservicer';
$string['selectaccesslevel'] = 'Vælg et adgangsniveau fra listen.';
$string['selectahost'] = 'Vælg en ekstern Moodle-vært';
$string['service'] = 'Servicenavn';
$string['serviceid'] = 'Service-id';
$string['servicesavailableonhost'] = 'Servicer tilgængelige på {$a}';
$string['serviceswepublish'] = 'Servicer vi publicerer til {$a}.';
$string['serviceswesubscribeto'] = 'Services på {$a} vi abonnerer på.';
$string['settings'] = 'Indstillinger';
$string['showlocal'] = 'Vis lokale brugere';
$string['showremote'] = 'Vis fjernbrugere';
$string['ssl_acl_allow'] = 'SSO ACL: Tillad brugeren "{$a->user}" fra "{$a->host}"';
$string['ssl_acl_deny'] = 'SSO ACL: Afvis brugeren "{$a->user}" fra "{$a->host}"';
$string['sslverification'] = 'Ssl-verifikation';
$string['sslverification_help'] = 'Med denne indstilling kan du konfigurere sikkerhedsniveauet ved forbindelse til en peer ved brug af https.

* Ingen: Intet sikkerhedsniveau
* Verificer kun vært: validerer SSL-certifikatets domæne
* Verificer vært og peer (anbefales): Validerer SSL-certifikatets domæne og udbyder';
$string['ssoaccesscontrol'] = 'SSO adgangskontrol';
$string['ssoacldescr'] = 'Brug denne side til at tillade/afvise adgang for specifikke brugere fra MNet-værter. Dette er aktuelt når du tilbyder SSO-service til eksterne brugere. Kontroller dine <em>lokale</em> brugeres mulighed for at roame til andre MNet-værter ved at bruge rollesystemet til at give dem beføjelsen <em>mnetlogintoremote</em>.';
$string['ssoaclneeds'] = 'Denne funktion kræver at du har Netværk kørende og har MNets godkendelses-plugin aktiveret.';
$string['strict'] = 'Stringent';
$string['subscribe'] = 'Abonner';
$string['system'] = 'System';
$string['testclient'] = 'MNet-testklient';
$string['testtrustedhosts'] = 'Test en adresse';
$string['testtrustedhostsexplain'] = 'Tast en IP-adresse og se om det er en vært der er tillid til.';
$string['theypublish'] = 'De publicerer';
$string['theysubscribe'] = 'De tegner abonnement';
$string['transport_help'] = 'Disse muligheder er gensidige, du kan kun tvinge en ekstern vært til at bruge signeret ssl-certifikat hvis din server også har et.';
$string['trustedhosts'] = 'XML-RPC værter';
$string['trustedhostsexplain'] = '<p>Mekanismen til betroede værter muliggør specifikke maskiner at køre kald via XML-RPC til alle dele af Moodles API. Det gør at scripts kan kontrollere Moodle og det kan være meget risikabelt. Er du i tvivl, drop det.</p>
<p><strong>Det er ikke nødvendigt for en standard MNet-funktion!</strong> Aktiver den kun hvis du ved hvad du gør.</p>
<p>Du kan aktivere den ved at skrive en liste IP-adresser eller netværk, en per linje. Eksempler:</p> Din lokale vært:<br />127.0.0.1 <br />Din lokale vært (med en netværksblok):<br />127.0.0.1/32 <br />Kun værten med IP-adresse 192.168.0.7:<br />192.168.0.7/32<br />Alle værter med IP-adresser mellem 192.168.0.1 og 192.168.0.255:<br />192.168.0.0/24<br />Alle værter i det hele taget:<br />192.168.0.0/0<br />Det sidste eksempel er indlysende nok <strong>ikke</strong> en anbefalelsesværdig konfiguration.';
$string['turnitoff'] = 'Sluk den';
$string['turniton'] = 'Tænd den';
$string['type'] = 'Type';
$string['unknown'] = 'Ukendt';
$string['unknownerror'] = 'Der opstod en ukendt fejl under forhandlingen.';
$string['usercannotchangepassword'] = 'Som ekstern bruger kan du ikke ændre din kode her.';
$string['userchangepasswordlink'] = '<br />Du kan måske ændre din adgangskode hos din <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a> udbyder.';
$string['usernotfullysetup'] = 'Din brugerkonto er mangelfuld. Du skal <a href="{$a}"> vende tilbage til din udbyder</a> og sikre dig at din profil er komplet der. Du skal måske logge ud og ind igen før det virker.';
$string['usersareonline'] = 'Advarsel: {$a} brugere fra den server er i øjeblikket logget ind på din side.';
$string['validated_by'] = 'Den er godkendt af netværket: &nbsp;<code>{$a}</code>';
$string['verifyhostandpeer'] = 'Verificer vært og peer';
$string['verifyhostonly'] = 'Verificer kun vært';
$string['verifysignature-error'] = 'Signaturverificeringen mislykkedes. Der er opstået en fejl.';
$string['verifysignature-invalid'] = 'Signaturgodkendelsen mislykkedes. It appears that this payload was not signed by you.';
$string['version'] = 'Version';
$string['warning'] = 'Advarsel';
$string['wrong-ip'] = 'Din IP-adresse findes ikke i vores liste.';
$string['xmlrpc-missing'] = 'Du skal have XML-RPC installeret i din PHP for at kunne bruge denne funktion.';
$string['yourhost'] = 'Din vært';
$string['yourpeers'] = 'Dine peers';
