<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'da', version '3.11'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Du kan prøvese quizzen, men hvis det var en reel besvarelse, ville du blive lukket ude fordi:';
$string['action'] = 'Handling';
$string['activityoverview'] = 'Du har quizzer, der skal gennemføres';
$string['adaptive'] = 'Adaptiv tilstand';
$string['adaptive_help'] = 'Hvis denne indstilling er aktiveret kan et spørgsmål besvares flere gange i samme forsøg. Er et svar for eksempel markeret som forkert, kan den studerende med det samme forsøge med et nyt svar. Men afhængig af indstillingen "Anvend strafpoint", vil forkerte svar trække ned i point.';
$string['add'] = 'Tilføj';
$string['addaquestion'] = 'et nyt spørgsmål';
$string['addarandomquestion'] = 'et tilfældigt spørgsmål';
$string['addarandomquestion_help'] = 'Når et tilfældigt spørgsmål er tilføjet, resulterer det i et tilfældigt udvalgt spørgsmål fra den valgte kategori. Det betyder, at forskellige studerende sandsynligvis får forskellige spørgsmål, og når en quiz tillader flere forsøg på besvarelser, kan hvert forsøg indeholde forskellige spørgsmål.';
$string['addarandomselectedquestion'] = 'Tilføj et tilfældigt udvalgt spørgsmål...';
$string['addasection'] = 'ny sektions-overskrift';
$string['adddescriptionlabel'] = 'Tilføj et beskrivende element';
$string['addingquestion'] = 'Tilføjer spørgsmål';
$string['addingquestions'] = '<p>Her på siden administrerer du din database med spørgsmål. Spørgsmål organiseres i kategorier, og de kan bruges af en hvilken som helst quiz på dit kursus - eller på andre kurser hvis du vælger at \'offentliggøre\' dem.<p> <p>Når du har valgt eller oprettet en spørgsmålskategori, kan du oprette eller redigere spørgsmål. Du kan føje ethvert af disse spørgsmål til din quiz på den anden side af denne side.<p>';
$string['addmoreoverallfeedbacks'] = 'Føj {no} felt(er) til feedback';
$string['addnewgroupoverride'] = 'Tilføj gruppeundtagelse';
$string['addnewpagesafterselected'] = 'Tilføj nye sider efter de valgte spørgsmål';
$string['addnewquestionsqbank'] = 'Føj spørgsmål til kategorien {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Tilføj brugerundtagelse';
$string['addpagebreak'] = 'Tilføj side-deling';
$string['addpagehere'] = 'Tilføj side her';
$string['addquestion'] = 'Tilføj spørgsmål';
$string['addquestionfrombankatend'] = 'Tilføj fra spørgsmålsbanken i slutningen';
$string['addquestionfrombanktopage'] = 'Tilføj fra spørgsmålsbanken til side {$a}';
$string['addquestions'] = 'Tilføj spørgsmål';
$string['addquestionstoquiz'] = 'Føj spørgsmål til nuværende quiz';
$string['addrandom'] = 'Tilføj {$a} tilfældigt udvalgte spørgsmål';
$string['addrandom1'] = '<< Tilføj';
$string['addrandom2'] = 'tilfældige spørgsmål';
$string['addrandomfromcategory'] = 'Tilføj tilfældige spørgsmål fra kategorien:';
$string['addrandomquestion'] = 'Tilføj tilfældigt spørgsmål';
$string['addrandomquestionatend'] = 'Tilføj et tilfældigt spørgsmål til sidst';
$string['addrandomquestiontopage'] = 'Føj et tilfældigt spørgsmål til siden {$a}';
$string['addrandomquestiontoquiz'] = 'Føj et tilfældigt spørgsmål til quizzen {$a}';
$string['addselectedquestionstoquiz'] = 'Føj valgt(e) spørgsmål til quizzen';
$string['addselectedtoquiz'] = 'Føj valgte til quizzen';
$string['addtoquiz'] = 'Føj til quiz';
$string['affectedstudents'] = 'Påvirkede {$a}';
$string['aftereachquestion'] = 'Efter tilføjelse af hvert spørgsmål';
$string['afternquestions'] = 'Efter tilføjelse af {$a} spørgsmål';
$string['age'] = 'alder';
$string['allattempts'] = 'Alle besvarelser';
$string['allinone'] = 'Ubegrænset';
$string['allowreview'] = 'Tillad flere forsøg';
$string['alreadysubmitted'] = 'Du har sandsynligvis allerede afleveret denne besvarelse';
$string['alternativeunits'] = 'Alternative enheder';
$string['alwaysavailable'] = 'Altid tilgængelig';
$string['analysisoptions'] = 'Analysemuligheder';
$string['analysistitle'] = 'Tabel med analyse-emner';
$string['answer'] = 'Svar';
$string['answered'] = 'Besvaret';
$string['answerhowmany'] = 'Et eller flere svar?';
$string['answers'] = 'Svar';
$string['answersingleno'] = 'Flere svar tilladte';
$string['answersingleyes'] = 'Kun et svar';
$string['answertoolong'] = 'Svar for langt efter linje {$a} (255 karakterer maks.)';
$string['anytags'] = 'Ethvert tag';
$string['aon'] = 'AON-format';
$string['areyousureremoveselected'] = 'Er du sikker på du vil fjerne alle de markerede spørgsmål?';
$string['asshownoneditscreen'] = 'Som vist på redigeringssiden';
$string['attempt'] = 'Besvarelser {$a}';
$string['attemptalreadyclosed'] = 'Denne quiz er allerede afsluttet.';
$string['attemptclosed'] = 'Quizzen er ikke afsluttet endnu';
$string['attemptduration'] = 'Tid anvendt';
$string['attemptedon'] = 'Forsøgt besvaret d.';
$string['attempterror'] = 'Du har ikke tilladelse til at besvare denne quiz på nuværende tidspunkt: {$a}';
$string['attempterrorcontentchange'] = 'Denne forhåndsvisning af quizzen eksisterer ikke længere. (Når en quiz er redigeret færdig, slettes forhåndsvisningerne automatisk.)';
$string['attempterrorcontentchangeforuser'] = 'Dette besvarelsesforsøg i quizzen eksisterer ikke længere.';
$string['attempterrorinvalid'] = 'Ugyldig id på quiz-besvarelsesforsøg';
$string['attemptfirst'] = 'Første besvarelse';
$string['attemptincomplete'] = 'Denne besvarelse (af {$a}) er ikke afsluttet endnu.';
$string['attemptlast'] = 'Sidste besvarelse';
$string['attemptnumber'] = 'Besvarelse';
$string['attemptquiznow'] = '--== Begynd nu ==--';
$string['attemptreviewtitle'] = '{$a}: Gennemsyn af besvarelser';
$string['attemptreviewtitlepaged'] = '{$a->name}: Gennemsyn af besvarelser (side {$a->currentpage} af {$a->totalpages})';
$string['attempts'] = 'Besvarelser';
$string['attempts_help'] = 'Totalt antal tilladte besvarelsesforsøg (ikke antal ekstra forsøg).';
$string['attemptsallowed'] = 'Tilladt antal besvarelser';
$string['attemptsdeleted'] = 'Besvarelser slettet';
$string['attemptselection'] = 'Vælg hvilke besvarelser som skal analyseres for hver bruger';
$string['attemptsexist'] = 'Du kan ikke længere tilføje eller fjerne spørgsmål.';
$string['attemptsnum'] = 'Besvarelser: {$a}';
$string['attemptsnumthisgroup'] = 'Besvarelser: {$a->total} ({$a->group} fra denne gruppe)';
$string['attemptsnumyourgroups'] = 'Besvarelser: {$a->total} ({$a->group} fra dine grupper)';
$string['attemptsonly'] = 'Vis kun studerende med besvarelser';
$string['attemptstate'] = 'Tilstand';
$string['attemptstillinprogress'] = 'Uafsluttet besvarelse';
$string['attemptsummarytitle'] = '{$a}: Beskrivelse af besvarelse';
$string['attemptsunlimited'] = 'Ingen begrænsninger i antal besvarelser';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (side {$a->currentpage} af {$a->totalpages})';
$string['autosaveperiod'] = 'Forsinkelse på automatisk gemning';
$string['autosaveperiod_desc'] = 'Svar kan gemmes automatisk undervejs i quiz-besvarelserne. Svarene gemmes hver gang et af dem ændres og efter denne forsinkelse. Her må du afveje: Et kortere tidsrum forøger serverbelastningen, men reducerer risikoen for at den studerende mister sin besvarelse. Hvis du vil gøre tidsrummet meget kortere, skal du ændre det gradvist og overvåge serverbelastningen. Hvis belastningen bliver for høj, skal du forlænge forsinkelsen igen. Hvis du indstiller tidsrummet til 0, gemmes svar ikke automatisk.';
$string['back'] = 'Tilbage til spørgsmålet';
$string['backtocourse'] = 'Tilbage til kurset';
$string['backtoquestionlist'] = 'Tilbage til listen over spørgsmål';
$string['backtoquiz'] = 'Tilbage til redigering af quiz';
$string['basicideasofquiz'] = 'De grundlæggende ideer om at lave quizzer';
$string['bestgrade'] = 'Bedste vurdering';
$string['bothattempts'] = 'Vis studerende uden besvarelsesforsøg';
$string['browsersecurity'] = 'Browsersikkerhed';
$string['browsersecurity_help'] = 'Hvis "Fuldskærms-pop op med en vis JavaScript-sikkerhed" er valgt

* starter quizzen kun hvis den studerende har aktiveret JavaScript i browseren.
* vises quizzen i en pop op i et fuldt skærmvindue der dækker andre vinduer og er uden navigationsknapper
* er den studerende så vidt muligt forhindret i at bruge andre faciliteter såsom kopier og sæt ind.';
$string['calculated'] = 'Beregnet';
$string['calculatedquestion'] = 'Beregnet spørgsmål ikke understøttet på linje {$a}. Spørgsmålet vil blive ignoreret.';
$string['cannotcreatepath'] = 'Mapper kan ikke oprettes ({$a})';
$string['cannoteditafterattempts'] = 'Du kan ikke flytte eller slette spørgsmål der er besvaret. ({$a})';
$string['cannotfindprevattempt'] = 'Kan ikke finde tidligere besvarelser at bygge videre på.';
$string['cannotfindquestionregard'] = 'Hentning af spørgsmål til om-bedømmelse slog fejl!';
$string['cannotinsert'] = 'Kan ikke indsætte spørgsmål';
$string['cannotinsertrandomquestion'] = 'Kunne ikke indsætte nyt tilfældigt spørgsmål!';
$string['cannotloadquestion'] = 'Kunne ikke indlæse spørgsmålsindstillingerne';
$string['cannotloadtypeinfo'] = 'Kunne ikke loade spørgsmålstypens specifikke spørgsmålsinformation';
$string['cannotopen'] = 'Kan ikke åbne eksportfil ({$a})';
$string['cannotremoveallsectionslots'] = 'Du har valgt alle spørgsmål under sektionsoverskriften "{$a}". Du kan ikke fjerne alle spørgsmål under en sektionsoverskrift.';
$string['cannotremoveslots'] = 'Kan ikke fjerne spørgsmål';
$string['cannotrestore'] = 'Kunne ikke gendanne spørgsmålssessioner';
$string['cannotreviewopen'] = 'Du kan ikke evaluere denne besvarelse, den er stadig åben.';
$string['cannotsavelayout'] = 'Kunne ikke gemme layout';
$string['cannotsavenumberofquestion'] = 'Kunne ikke gemme antal spørgsmål per side';
$string['cannotsavequestion'] = 'Kunne ikke gemme spørgsmålsliste';
$string['cannotsetgrade'] = 'Kunne ikke sætte en ny højeste karakter for quizzen';
$string['cannotsetsumgrades'] = 'Indstilling af karaktersum mislykkedes';
$string['cannotstartgradesmismatch'] = 'Kan ikke starte en besvarelse af denne quiz. Quizzen er indstillet til at blive bedømt ud af {$a->grade}, men ingen af spørgsmålene i quizzen har en bedømmelse. Dette kan rettes på siden \'Rediger quiz\'.';
$string['cannotstartmissingquestion'] = 'Kan ikke starte en besvarelse af denne quiz. Quiz-definitionen indeholder et spørgsmål, der ikke findes.';
$string['cannotstartnoquestions'] = 'Kan ikke starte en besvarelse af denne quiz. Quizzen er endnu ikke sat op. Der er ikke tilføjet nogen spørgsmål.';
$string['cannotwrite'] = 'Kan ikke skrive til eksportfilen ({$a})';
$string['canredoquestions'] = 'Tillad ændring af svar inden for en besvarelse';
$string['canredoquestions_desc'] = 'Er indstillingen aktiveret, vil de studerende se en knap med teksten "Prøv et andet spørgsmål som dette" når de har prøvet at besvare et spørgsmål. Det giver dem mulighed for at besvare et tilsvarende (tilfældigt valgt) spørgsmål eller samme spørgsmål igen, uden at skulle afslutte quizzen og starte på ny. Denne mulighed er god til øvelsesquizzer.

Indstillingen påvirker kun spørgsmål og opførsel (f.eks. umiddelbar feedback eller interaktive med flere forsøg), hvor de studerende kan afslutte spørgsmålet inden besvarelsen afleveres.';
$string['canredoquestions_help'] = 'Er indstillingen aktiveret, vil de studerende se en knap med teksten "Prøv et andet spørgsmål som dette" når de har prøvet at besvare et spørgsmål. Det giver dem mulighed for at besvare et tilsvarende (tilfældigt valgt) spørgsmål eller samme spørgsmål igen, uden at skulle afslutte quizzen og starte på ny. Denne mulighed er god til øvelsesquizzer.

Indstillingen påvirker kun spørgsmål og opførsel (f.eks. umiddelbar feedback eller interaktive med flere forsøg), hvor de studerende kan afslutte spørgsmålet inden besvarelsen afleveres.';
$string['canredoquestionsyes'] = 'Ja, giv mulighed for at besvare et andet spørgsmål';
$string['caseno'] = 'Nej, ingen forskel på store og små bogstaver';
$string['casesensitive'] = 'Versalfølsom';
$string['caseyes'] = 'Ja, der skelnes mellem store og små bogstaver';
$string['categoryadded'] = 'Kategorien "{$a}" blev tilføjet';
$string['categorydeleted'] = 'Kategorien "{$a}" blev slettet';
$string['categorynoedit'] = 'Du har ikke tilladelse til at ændre kategorien "{$a}".';
$string['categoryupdated'] = 'Kategorien blev opdateret';
$string['close'] = 'Luk';
$string['closebeforeopen'] = 'Quizzen blev ikke opdateret. Du har angivet lukkedatoen før åbningsdatoen.';
$string['closed'] = 'Lukket';
$string['closepreview'] = 'Luk forhåndsvisning';
$string['closereview'] = 'Luk gennemsyn';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Skriv kommentar eller rediger karakter';
$string['comments'] = 'Kommentarer';
$string['completedon'] = 'Færdiggjort på';
$string['completionattemptsexhausted'] = 'Eller alle tilgængelige besvarelsesforsøg fuldført';
$string['completionattemptsexhausted_help'] = 'Marker quiz som afsluttet, når den studerende har opbrugt det maksimale antal besvarelsesforsøg.';
$string['completionattemptsexhausteddesc'] = 'Fuldført hvis alle tilgængelige forsøg er opbrugt';
$string['completiondetail:minattempts'] = 'Lav besvarelser: {$a}';
$string['completiondetail:passgrade'] = 'Få en karakter for bestået';
$string['completiondetail:passorexhaust'] = 'Modtag en beståelseskarakter eller gennemfør alle tilgængelige besvarelsesforsøg';
$string['completionminattempts'] = 'Mindste antal besvarelsesforsøg:';
$string['completionminattemptserror'] = 'Mindste antal forsøg på besvarelse skal være lavere eller lig med det tilladte antal.';
$string['completionminattemptsgroup'] = 'Kræv besvarelser';
$string['completionpass'] = 'Kræv beståelseskarakter';
$string['completionpass_help'] = 'Er indstillingen aktiveret, anses aktiviteten som værende gennemført når den studerende modtager en beståelseskarakter (som angivet i karaktersektionen af quiz-indstillingerne) eller højere.';
$string['completionpassdesc'] = 'Den studerende skal have bestået quizzen for at fuldføre den';
$string['configadaptive'] = 'Vælger du Ja, vil den studerende kunne få flere responser på et spørgsmål selv indenfor samme besvarelse af quizzen.';
$string['configattemptsallowed'] = 'Begræns det tilladte antal besvarelsesforsøg.';
$string['configdecimaldigits'] = 'Antal decimaler efter kommaet når karakterer vises.';
$string['configdecimalplaces'] = 'Antal decimaler der vises på karakterer i quizzen.';
$string['configdecimalplacesquestion'] = 'Antal decimaler der vises på karakteren i det enkelte spørgsmål.';
$string['configdelay1'] = 'Hvis du sætter en forsinkelse, skal de studerende vente i det angivne tidsrum inden de kan besvare en quiz igen efter det første forsøg.';
$string['configdelay1st2nd'] = 'Hvis du sætter en forsinkelse på her, kan den studerende ikke starte sin anden besvarelse, før dette tidsrum er gået siden afslutningen af det første forsøg.';
$string['configdelay2'] = 'Hvis du sætter en forsinkelse på her, skal den studerende vente det tidsrum, før de kan  prøve tredje gang eller mere.';
$string['configdelaylater'] = 'Hvis du sætter en forsinkelse på her, kan den studerende ikke starte sin tredje og senere besvarelse, før dette tidsrum er gået siden afslutningen af det forrige forsøg.';
$string['configeachattemptbuildsonthelast'] = 'Hvis flere besvarelser er tilladt, vil hver ny besvarelse indeholde resultaterne af de tidligere.';
$string['configgrademethod'] = 'Når gentagne besvarelser er tilladt, hvilken metode skal da benyttes til at beregne den studerendes endelige karakter for quizzen.';
$string['configintro'] = 'De værdier du sætter her, styrer hvilke standardværdier der bruges i indstillingerne når du opretter en ny quiz. Du kan også bestemme hvilke indstillinger der betragtes som avancerede.';
$string['configmaximumgrade'] = 'Standardkarakter som quizkarakteren skaleres op imod.';
$string['confignavmethod'] = 'Ved \'Fri navigation\' kan spørgsmål besvares i en hvilken som helst rækkefølge ved brug af navigation. Ved \'I rækkefølge\' skal spørgsmålene besvares i den rigtige rækkefølge.';
$string['confignewpageevery'] = 'Når du føjer spørgsmål til quizzen vil sideskift automatisk placeres efter den indstilling du vælger her.';
$string['configoutcomesadvanced'] = 'Hvis denne mulighed slås til, er udfaldet på quiz-redigeringsskemaet avancerede indstillinger.';
$string['configpenaltyscheme'] = 'Straf fratrækkes for hver forkert svar i adaptiv tilstand.';
$string['configpopup'] = 'Tving besvarelser til at åbne i et pop op-vindue og brug JavaScript trick i forsøg på at begrænse kopi-indsæt osv. i løbet af besvarelsen.';
$string['configrequirepassword'] = 'Studerende skal indtaste denne adgangskode for at få adgang til quizzen.';
$string['configrequiresubnet'] = 'Studerende kan kun besvare quizzen fra disse computere.';
$string['configreviewoptions'] = 'Her markeres hvilke informationer brugere kan se når de gennemser en besvarelse eller ser på quizrapporter.';
$string['configshowblocks'] = 'Vis blokke under besvarelse af quizzen.';
$string['configshowuserpicture'] = 'Vis brugerens billede på skærmen under besvarelsen.';
$string['configshufflewithin'] = 'Hvis du aktiverer denne indstilling vil svarmulighederne på hvert spørgsmål vises i tilfældig rækkefølge hver gang den studerende starter på en quiz - forudsat at funktionen også er aktiveret i det enkelte spørgsmåls indstillinger.';
$string['configtimelimit'] = 'Standard-tidsbegrænsning for quizzer i minutter. 0 betyder, at der ikke er nogen tidsgrænse.';
$string['configtimelimitsec'] = 'Standard tidsbegrænsning på quizzer i sekunder. 0 betyder at der ikke sættes nogen grænse.';
$string['configurerandomquestion'] = 'Konfigurer spørgsmål';
$string['confirmclose'] = 'Når du har afleveret, kan du ikke længere ændre dine svar i dette forsøg.';
$string['confirmremovequestion'] = 'Er du sikker på, du vil fjerne dette {$a} spørgsmål?';
$string['confirmremovesectionheading'] = 'Er du sikker på, du vil fjerne sektions-overskriften "{$a}"?';
$string['confirmserverdelete'] = 'Er du sikker på at du vil fjerne serveren <b>{$a}</b> fra listen?';
$string['connectionerror'] = 'Forbindelse til netværket afbrudt. (Autosave slog fejl).

Noter alle svar der er skrevet på denne side i løbet af de sidste par minutter, og prøv så at genoprette forbindelsen.

Når forbindelsen er genoprettet, skulle dine svar være gemt, og denne besked forsvinder.';
$string['connectionok'] = 'Netværksforbindelse genoprettet. Du kan trygt fortsætte.';
$string['containercategorycreated'] = 'Denne kategori er blevet oprettet for at indeholde alle de oprindelige kategorier som blev flyttet til site niveau, af følgende årsag/årsager:';
$string['continueattemptquiz'] = 'Fortsæt fra sidste forsøg';
$string['continuepreview'] = 'Fortsæt sidste gennemsyn';
$string['copyingfrom'] = 'Opretter en kopi af spørgsmålet "{$a}"';
$string['copyingquestion'] = 'Kopierer et spørgsmål';
$string['correct'] = 'Rigtigt';
$string['correctanswer'] = 'Rigtigt svar';
$string['correctanswerformula'] = 'Rigtigt svar formel';
$string['correctansweris'] = 'Rigtigt svar: {$a}';
$string['correctanswerlength'] = 'Signifikante tal';
$string['correctanswers'] = 'Rigtigt svar';
$string['correctanswershows'] = 'Vis rigtige svar';
$string['corrresp'] = 'Korrekt tilbagemelding';
$string['countdown'] = 'Nedtælling';
$string['countdownfinished'] = 'Tiden er gået, du skal aflevere dine svar nu.';
$string['countdowntenminutes'] = 'Der er 10 minutter tilbage.';
$string['coursetestmanager'] = 'Kursustestmanager-format';
$string['createcategoryandaddrandomquestion'] = 'Opret kategori og tilføj et tilfældigt spørgsmål';
$string['createfirst'] = 'Du bliver nødt til at lave nogle kort-svars spørgsmål først.';
$string['createmultiple'] = 'Føj flere tilfældige spørgsmål til quizzen';
$string['createnewquestion'] = 'Opret et nyt spørgsmål';
$string['createquestionandadd'] = 'Opret et nyt spørgsmål og føj det til quizzen.';
$string['custom'] = 'Selvdefineret format';
$string['dataitemneed'] = 'Du skal tilføje mindst et datasæt for at få et gyldigt svar.';
$string['datasetdefinitions'] = 'Datasætdefinitioner der kan genbruges i kategorien {$a}';
$string['datasetnumber'] = 'Tal';
$string['daysavailable'] = 'Dage til rådighed';
$string['decimaldigits'] = 'Antal decimaler i karakterer';
$string['decimalplaces'] = 'Antal decimaler i karakterer';
$string['decimalplaces_help'] = 'Indstillingen angiver, hvor mange decimaler der skal vises når den studerende præsenteres for sine karakterer. Indstillingen har kun betydning for visningen, den påvirker ikke databasens data eller beregningerne, de baseres på de nøjagtige værdier.';
$string['decimalplacesquestion'] = 'Antal decimaler i karakterer for hvert spørgsmål';
$string['decimalplacesquestion_help'] = 'Antal decimaler der vises på karakterer i de enkelte spørgsmål.';
$string['decimalpoints'] = 'Decimaler';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standardkarakter for spørgsmål';
$string['defaultinfo'] = 'Standardkategorien for spørgsmål.';
$string['delay1'] = 'Tidsforsinkelse mellem første og andet forsøg';
$string['delay1st2nd'] = 'Tvungen forsinkelse mellem 1. og 2. forsøg';
$string['delay1st2nd_help'] = 'Er indstillingen aktiveret, må den studerende vente i det specificerede tidsrum før quizzen kan forsøges besvaret for anden gang.';
$string['delay2'] = 'Tidsforsinkelse mellem senere besvarelser';
$string['delaylater'] = 'Tvungen forsinkelse mellem senere besvarelser';
$string['delaylater_help'] = 'Er indstillingen aktiveret, må den studerende vente i det specificerede tidsrum før quizzen kan forsøges besvaret flere gange.';
$string['deleteattemptcheck'] = 'Er du sikker på at du vil slette disse besvarelser?';
$string['deleteselected'] = 'Slet valgte';
$string['deletingquestionattempts'] = 'Sletter spørgsmålsbesvarelser';
$string['description'] = 'Beskrivelse';
$string['disabled'] = 'Deaktiveret';
$string['displayoptions'] = 'Vis muligheder';
$string['donotuseautosave'] = 'Brug ikke auto-gem';
$string['download'] = 'Klik for at downloade den eksporterede kategorifil';
$string['downloadextra'] = '(filen bliver også gemt i kursets mappe /backupdata/quiz)';
$string['dragtoafter'] = 'Efter {$a}';
$string['dragtostart'] = 'Til starten';
$string['duplicateresponse'] = 'Der er set bort fra den afleverede besvarelse da du tidligere har afleveret en identisk besvarelse.';
$string['eachattemptbuildsonthelast'] = 'Hver besvarelse bygger på den forrige';
$string['eachattemptbuildsonthelast_help'] = 'Hvis flere besvarelser er tilladt og denne indstilling er aktiveret, vil hver ny besvarelse indeholde svarene fra den forrige. Dermed vil det være muligt at gennemføre quizzen over flere omgange.';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editcatquestions'] = 'Rediger spørgsmål i kategorien';
$string['editingquestion'] = 'Redigerer et spørgsmål';
$string['editingquiz'] = 'Redigerer en quiz';
$string['editingquiz_help'] = 'Når du opretter en quiz, er de vigtigste begreber:

* Quizzen, som indeholder spørgsmål over en eller flere sider
* Spørgsmålsbanken, hvor kopier af alle spørgsmål opbevares inddelt i kategorier
* Tilfældige spørgsmål - En studerende får forskellige spørgsmål hver gang de besvarer quizzen og forskellige studerende kan få forskellige spørgsmål';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Redigerer quiz: {$a}';
$string['editmaxmark'] = 'Rediger højeste karakter';
$string['editoverride'] = 'Rediger undtagelse';
$string['editqcats'] = 'Rediger svarkategorier';
$string['editquestion'] = 'Rediger spørgsmål';
$string['editquestions'] = 'Rediger spørgsmål';
$string['editquiz'] = 'Rediger quiz';
$string['editquizquestions'] = 'Rediger quizspørgsmål';
$string['emailconfirmbody'] = 'Hej {$a->username}.

Tak for din aflevering af {$a->quizname} på kurset "{$a->coursename}", {$a->submissiontime}.

Denne mail bekræfter at dine svar er gemt.

Du kan se quizzen her: {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Tak for dine svar på quizzen "{$a->quizname}"';
$string['emailconfirmsubject'] = 'Bekræftelse på aflevering: {$a->quizname}';
$string['emailnotifybody'] = 'Hej {$a->username}.

{$a->studentname} har afsluttet
"{$a->quizname}"
({$a->quizurl})
på kurset "{$a->coursename}".

Du kan gennemse svarene her: {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} har afsluttet {$a->quizname}. Se {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} har gennemført {$a->quizname}';
$string['emailoverduebody'] = 'Hej {$a->studentname}.

Du har påbegyndt en besvarelse af "{$a->quizname}" på kurset "{$a->coursename}", men du har ikke afleveret den. Den skulle have været afleveret senest {$a->attemptduedate}.

Hvis du stadig gerne vil aflevere besvarelsen, skal du gå til {$a->attemptsummaryurl} og klikke på aflever-knappen. Dette skal gøres inden {$a->attemptgraceend}, ellers vil din besvarelse ikke blive talt med.';
$string['emailoverduesmall'] = 'Du har ikke afleveret din besvarelse på {$a->quizname}. Gå til {$a->attemptsummaryurl} inden {$a->attemptgraceend}, hvis du stadig gerne vil aflevere den.';
$string['emailoverduesubject'] = 'Besvarelsen skulle have været afleveret: {$a->quizname}';
$string['empty'] = 'Tom';
$string['enabled'] = 'Aktiveret';
$string['endtest'] = 'Afslut forsøg...';
$string['erroraccessingreport'] = 'Du har ikke adgang til denne rapport';
$string['errorinquestion'] = 'Fejl i spørgsmålet';
$string['errormissingquestion'] = 'Fejl: Systemet kan ikke finde spørgsmålet med id\'en {$a}';
$string['errornotnumbers'] = 'Fejl - svarene skal være numeriske';
$string['errorunexpectedevent'] = 'Uventet begivenhedskode {$a->event} fundet for spørgsmål {$a->questionid} i besvarelse {$a->attemptid}.';
$string['essay'] = 'Tekstsvar';
$string['essayquestions'] = 'Spørgsmål';
$string['eventattemptdeleted'] = 'Quizbesvarelse slettet';
$string['eventattemptpreviewstarted'] = 'Forhåndsvisning af quizbesvarelse påbegyndt';
$string['eventattemptreviewed'] = 'Quizbesvarelse gennemgået';
$string['eventattemptsummaryviewed'] = 'Quizbesvarelses-sammendrag set';
$string['eventattemptviewed'] = 'Quizbesvarelse set';
$string['eventeditpageviewed'] = 'Quiz-redigeringsside set';
$string['eventoverridecreated'] = 'Quiz-undtagelse oprettet';
$string['eventoverridedeleted'] = 'Quiz-undtagelse slettet';
$string['eventoverrideupdated'] = 'Quiz-undtagelse opdateret';
$string['eventquestionmanuallygraded'] = 'Spørgsmål bedømt manuelt';
$string['eventquizattemptabandoned'] = 'Quizbesvarelse opgivet';
$string['eventquizattemptregraded'] = 'Quiz-besvarelse bedømt igen';
$string['eventquizattemptstarted'] = 'Quizbesvarelse påbegyndt';
$string['eventquizattemptsubmitted'] = 'Quizbesvarelse afleveret';
$string['eventquizattempttimelimitexceeded'] = 'Tidsbegrænsningen for besvarelse af quizzen er overskredet';
$string['eventreportviewed'] = 'Quizrapport set';
$string['everynquestions'] = 'Hvert {$a}. spørgsmål';
$string['everyquestion'] = 'Hvert spørgsmål';
$string['everythingon'] = 'Alt på';
$string['existingcategory'] = 'Eksisterende kategori';
$string['exportcategory'] = 'eksporter kategori';
$string['exporterror'] = 'Der opstod en fejl under eksporten';
$string['exportingquestions'] = 'Spørgsmålene skrives nu til en fil';
$string['exportname'] = 'Filnavn';
$string['exportquestions'] = 'Eksporter spørgsmål til en fil';
$string['extraattemptrestrictions'] = 'Ekstra restriktioner på besvarelser';
$string['false'] = 'Falsk';
$string['feedback'] = 'Tilbagemelding';
$string['feedbackerrorboundaryformat'] = 'Intervalværdien for feedback skal enten være en procentværdi eller et heltal. Den værdi du indtastede i {$a} blev ikke genkendt som nogen af delene.';
$string['feedbackerrorboundaryoutofrange'] = 'Grænserne for feedback-karakter skal være mellem 0% og 100%. Den værdi du angav i skellet {$a} er udenfor området.';
$string['feedbackerrorjunkinboundary'] = 'Du er nødt til at indtaste et interval for feedback således at der ikke er sprunget nogen over';
$string['feedbackerrorjunkinfeedback'] = 'Du er nødt til at indtaste en feedback uden at springe nogen over.';
$string['feedbackerrororder'] = 'Grænser for karakterer for feedback skal være i rækkefølge med den højeste først. Den værdi, du indtastede i grænsen {$a}, er udenfor rækkefølgen.';
$string['file'] = 'Fil';
$string['fileformat'] = 'Filformat';
$string['fillcorrect'] = 'Vis det rigtige svar';
$string['filloutnumericalanswer'] = 'Du skal give mindst et muligt svar og en toleranceværdi. Det først matchende svar vil blive brugt til at bestemme karakteren og feedback. Hvis du angiver en feedback uden svar, vil denne feedback blive vist til studerende hvis svar ikke matcher nogen af de andre svar.';
$string['filloutoneanswer'] = 'Du skal give mindst et muligt svar. Tomme felter vil ikke blive bedømt. "*" kan bruges til at angive et vilkårligt tegn. Det første matchende svar vil blive brugt til at angive scoren og feedback.';
$string['filloutthreequestions'] = 'Du skal udfylde mindst tre spørgsmål med tilhørende svar. Du kan angive ekstra forkerte svar ved at skrive et svar med et tomt spørgsmålsfelt. Tomme spørgsmål og svar vil ikke blive brugt.';
$string['fillouttwochoices'] = 'Du skal give mindst to svar. Tomme felter vil ikke blive bedømt.';
$string['finishattemptdots'] = 'Afslut quizzen...';
$string['finishreview'] = 'Afslut gennemsyn';
$string['forceregeneration'] = 'gennemtving gendannelse';
$string['formatnotfound'] = 'Import-/eksportformatet {$a} ikke fundet';
$string['formulaerror'] = 'Formularfejl!';
$string['fractionsaddwrong'] = 'De positive bedømmelser giver ikke sammenlagt 100%
<br />I stedet giver de {$a}%
<br />Vil du vende tilbage og lave det om?';
$string['fractionsnomax'] = 'Et eller flere svar skal give 100%, så det er <br />muligt at få fuld bedømmelse for dette spørgsmål<br />Vil du vende tilbage og lave det om?';
$string['fromfile'] = 'fra filen: ';
$string['functiondisabledbysecuremode'] = 'Den funktion er i øjeblikket deaktiveret';
$string['generalfeedback'] = 'Generel feedback';
$string['generalfeedback_help'] = 'Generel feedback er tekst, der vises efter et spørgsmål er besvaret. I modsætning til feedback til et specifikt spørgsmål, som afhænger af det givne svar, er den samme, generelle tilbagemelding altid vist.';
$string['graceperiod'] = 'Tillægstid';
$string['graceperiod_desc'] = 'Hvis indstillingen for hvad man skal gøre når tiden udløber, er "Der er tillægstid ...", er dette det tidsrum der tildeles som udgangspunkt.';
$string['graceperiod_help'] = 'Hvis indstillingen for hvad man skal gøre når tiden udløber er "Der er tillægstid ...", er dette det tidsrum der tildeles.';
$string['graceperiodmin'] = 'Sidste tillægstid';
$string['graceperiodmin_desc'] = 'Der er et muligt problem ved afslutningen af denne quiz. På den ene side vil vi gerne give de studerende lov til at arbejde til sidste sekund ved hjælp af den timer, der automatisk indsender quizzen når tiden udløber. På den anden side kan serveren så blive overbelastet og skal bruge noget tid på at nå frem til at behandle svarene. Derfor tillader vi svar indtil et vist tidsrum efter at tiden er udløbet, så de studerende ikke straffes for at serveren er langsom. Imidlertid kunne de studerende snyde og få dette antal sekunder til at besvare quizzen. Du skal foretage en afvejning baseret på, hvor meget du stoler på din servers ydeevne under afvikling af quizzer.';
$string['graceperiodtoosmall'] = 'Tillægstiden skal være mere end {$a}.';
$string['grade'] = 'Karakter';
$string['gradeall'] = 'Vurder alle';
$string['gradeaverage'] = 'Gennemsnitlig vurdering';
$string['gradeboundary'] = 'Pointgrænse';
$string['gradeessays'] = 'Vurder tekstsvar';
$string['gradehighest'] = 'Højeste vurdering';
$string['grademethod'] = 'Vurdering ved gentagne forsøg';
$string['grademethod_help'] = 'Når gentagne besvarelser er tilladt, er der forskellige måder at beregne det endelige resultat på.

* Højeste vurdering af alle besvarelser
* Gennemsnitlig vurdering af alle besvarelser
* Første besvarelse (alle andre forsøg ignoreres)
* Sidste besvarelse (alle andre forsøg ignoreres)';
$string['gradesdeleted'] = 'Karakterer på quiz slettet';
$string['gradesofar'] = '{$a->method}: {$a->mygrade}/{$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Beståelseskarakteren kan ikke være nul, da quizzen har dens gennemførelsesmetode sat til at kræve at man har bestået. Sæt en anden værdi.';
$string['gradetopassnotset'] = 'Quizzen har ikke en karakter for bestået. Den kan angives i quiz-indstillingerne under karaktersektionen.';
$string['gradetopassoutof'] = 'Karakter for at bestå: {$a->grade} ud af {$a->maxgrade}';
$string['gradingdetails'] = 'Vurdering: {$a->raw} af {$a->max} point.';
$string['gradingdetailsadjustment'] = 'Fratrukket tidligere strafpoint bliver resultatet <strong>{$a->cur}/{$a->max}</strong>';
$string['gradingdetailspenalty'] = 'Denne besvarelse blev fratrukket {$a} strafpoint';
$string['gradingdetailszeropenalty'] = 'Du fik ikke nogen strafpoint for denne besvarelse';
$string['gradingmethod'] = 'Bedømmelsesmetode: {$a}';
$string['groupoverrides'] = 'Gruppeundertagelser';
$string['groupoverridesdeleted'] = 'Gruppeundtagelser slettet';
$string['groupsnone'] = 'Der er ingen grupper du har adgang til.';
$string['guestsno'] = 'Beklager, gæster kan ikke besvare quizzen';
$string['hidebreaks'] = 'Skjul sidedeling';
$string['hidereordertool'] = 'Skjul organiseringsværktøj';
$string['history'] = 'Svarhistorik';
$string['howquestionsbehave_desc'] = 'Standardindstilling for spørgsmåls opførsel i en quiz.';
$string['imagedisplay'] = 'Billede';
$string['import_help'] = 'Med denne funktion kan du importere spørgsmål fra eksterne tekstfiler.

Hvis din fil indeholder ikke-ASCII-tegn, skal du bruge UTF-8-kodning. Vær især forsigtig med filer genereret af Microsoft Office-programmer, da disse ofte bruger speciel kodning, som ikke vil blive håndteret korrekt.

Det er muligt at tilføje import- og eksportformater. Andre valgfrie formater kan være til rådighed i modul- og programudvidelsesdatabasen.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importer kategori';
$string['importerror'] = 'Der skete en fejl under importen';
$string['importfilearea'] = 'Importer fra fil som allerede er uploadet til kursusfiler...';
$string['importfileupload'] = 'Import fra fil upload';
$string['importfromthisfile'] = 'Import fra denne fil';
$string['importingquestions'] = 'Importerer {$a} spørgsmål fra fil';
$string['importmax10error'] = 'Der er en fejl i spørgsmålet. Det er ikke tilladt at have mere end ti svar';
$string['importmaxerror'] = 'Der er en fejl i spørgsmålet. Der er for mange svar.';
$string['importquestions'] = 'Importer spørgsmål fra en fil';
$string['inactiveoverridehelp'] = '* Denne tilsidesættelse er inaktiv fordi den studerendes adgang til aktiviteten er begrænset. Det kan skyldes gruppe- eller rolletildelinger, andre adgangsbegrænsninger eller at aktiviteten er skjult.';
$string['incorrect'] = 'Forkert';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Individuelle tilbagemeldinger til hvert element';
$string['info'] = 'Introduktion';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Oprindeligt antal af samlede feedback-felter';
$string['initialnumfeedbacks_desc'] = 'Når der oprettes en ny quiz, tildeles dette antal tomme, samlede svar-bokse. Når quizzen er oprettet, viser formularen det antal felter, der kræves til antallet af svar i quizzen. Indstillingen skal mindst være 1.';
$string['inprogress'] = 'Under udførelse';
$string['introduction'] = 'Beskrivelse';
$string['invalidattemptid'] = 'Dette besvarelses-id findes ikke';
$string['invalidcategory'] = 'Ugyldig kategori-id';
$string['invalidoverrideid'] = 'Ugyldigt undtagelses-id';
$string['invalidquestionid'] = 'Ugyldigt spørgsmåls-id';
$string['invalidquizid'] = 'Ugyldig quiz-id';
$string['invalidrandomslot'] = 'Ugyldigt tilfældigt spørgsmåls slot-id.';
$string['invalidsource'] = 'Kilden er ikke gyldig.';
$string['invalidsourcetype'] = 'Ugyldig kilde';
$string['invalidstateid'] = 'Ugyldigt tilstands-id';
$string['lastanswer'] = 'Dit seneste svar var';
$string['layout'] = 'Layout';
$string['layoutasshown'] = 'Sidelayout som vist';
$string['layoutasshownwithpages'] = 'Sidelayoutet som vist. <small> (Ny side for hver(t) {$a}. spørgsmål.) </small>';
$string['layoutshuffledandpaged'] = 'Spørgsmålene vises i tilfældig rækkefølge med {$a} spørgsmål pr. side.';
$string['layoutshuffledsinglepage'] = 'Spørgsmålene vises i tilfældig rækkefølge med alle på samme side.';
$string['legacyquizaccessrulescron'] = 'Gamle cron quiz-adgangsregler';
$string['link'] = 'Link';
$string['listitems'] = 'Oversigt over dele i quizzen';
$string['literal'] = 'Bogstav';
$string['loadingquestionsfailed'] = 'Indlæsning af spørgsmål mislykkedes: {$a}';
$string['makecopy'] = 'Gem som nyt spørgsmål';
$string['managetypes'] = 'Rediger svartyper og servere';
$string['manualgradequestion'] = 'Bedøm spørgsmål {$a->question} i {$a->quiz} af {$a->user} manuelt';
$string['manualgrading'] = 'Vurdering';
$string['mark'] = 'Aflever';
$string['markall'] = 'Aflever side';
$string['marks'] = 'Point';
$string['marks_help'] = 'De numeriske karakterer for hvert spørgsmål og den samlede score for besvarelsen.';
$string['match'] = 'Match';
$string['matchanswer'] = 'Matcher svar';
$string['matchanswerno'] = 'Matcher svaret {$a}';
$string['max'] = 'Maks.';
$string['maxmark'] = 'Maksimum karakter';
$string['messageprovider:attempt_overdue'] = 'Advarsel, når tidsfristen for din besvarelse er forfalden';
$string['messageprovider:confirmation'] = 'Bekræftelse af dine egne quiz-svar';
$string['messageprovider:submission'] = 'Underretning om dine studerendes quizafleveringer';
$string['min'] = 'Min.';
$string['minutes'] = 'Minutter';
$string['missingcorrectanswer'] = 'Det rigtige svar skal angives';
$string['missingitemtypename'] = 'Navn mangler';
$string['missingquestion'] = 'Spørgsmålet findes tilsyneladende ikke længere';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Quiz-modulet gør det muligt for læreren at designe quizzer bestående af multiple choice, sand-falsk, matching, kort svar og andre spørgsmålstyper.

Læreren kan tillade flere forsøg på at besvare quizzen - med spørgsmålene blandet eller tilfældigt valgt fra spørgsmålsbanken. Der kan oprettes en tidsbegrænsning.

Hvert forsøg - med undtagelse af tekstsvar - bedømmes automatisk, og karakteren gemmes i karakterbogen.

Læreren kan vælge hvornår og om den studerende skal have vist hints, feedback og korrekte svar.

Quizzer kan bruges:

* Som eksamen på et kursus
* Som mini-test til læseopgaver eller som afslutning på et emne
* Som eksamenstræning med brug af spørgsmål fra tidligere eksaminer
* Til at give omgående feedback på en præstation
* Til selvbedømmelse';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Quizzer';
$string['moveselectedonpage'] = 'Flyt de udvalgte spørgsmål til siden: {$a}';
$string['multichoice'] = 'Multiple choice';
$string['multipleanswers'] = 'Vælg mindst et svar';
$string['mustbesubmittedby'] = 'Svaret skal indsendes senest {$a}';
$string['name'] = 'Navn';
$string['navigatenext'] = 'Næste side';
$string['navigateprevious'] = 'Forrige side';
$string['navmethod'] = 'Navigationsmetode';
$string['navmethod_free'] = 'I vilkårlig rækkefølge';
$string['navmethod_help'] = 'Når indstillingen \'i rækkefølge\' er aktiveret, skal den studerende besvare quizzen i den rigtige rækkefølge og kan hverken vende tilbage til tidligere sider eller hoppe frem.';
$string['navmethod_seq'] = 'I rækkefølge';
$string['navnojswarning'] = 'Advarsel: Disse links vil ikke gemme dine svar. Brug den næste knap nederst på siden.';
$string['neverallononepage'] = 'Aldrig, alle spørgsmål på én side';
$string['newattemptfail'] = 'Fejl: kunne ikke starte en ny besvarelse af quizzen';
$string['newcategory'] = 'Ny kategori';
$string['newpage'] = 'Ny side';
$string['newpage_help'] = 'Ved lange quizzer kan det være hensigtsmæssigt at bruge flere sider ved at begrænse antallet af spørgsmål på hver side. Efterhånden som der tilføjes spørgsmål til quizzen vil sideskift automatisk placeres efter dette antal. Det vil dog være muligt at flytte sideskiftene manuelt senere på redigeringssiden.';
$string['newpageevery'] = 'Start automatisk en ny side';
$string['newsectionheading'] = 'Ny overskrift';
$string['noanswers'] = 'Der er ikke valgt et svar!';
$string['noattempts'] = 'Ingen har besvaret denne quiz';
$string['noattemptsfound'] = 'Ingen besvarelser fundet.';
$string['noattemptstoshow'] = 'Der er ingen besvarelser';
$string['nocategory'] = 'Forkert eller ingen kategori valgt';
$string['noclose'] = 'Ingen lukkedato';
$string['nocommentsyet'] = 'Indtil videre ingen kommentarer';
$string['noconnection'] = 'Der er ikke forbindelse til en webservice som kan behandle dette spørgsmål. Kontakt din administrator.';
$string['nodataset'] = 'ingenting - det er ikke et jokertegn';
$string['nodatasubmitted'] = 'Der blev ikke afleveret noget.';
$string['noessayquestionsfound'] = 'Ingen manuelt bedømte spørgsmål fundet.';
$string['nogradewarning'] = 'Denne quiz er endnu ikke bedømt, så du kan ikke give en overordnet feedback der adskiller sig karaktermæssigt.';
$string['nomoreattempts'] = 'Det er ikke tilladt med flere besvarelser';
$string['none'] = 'Ingen';
$string['noopen'] = 'Ingen åbningsdato';
$string['nooverridedata'] = 'Du skal oprette en undtagelse for mindst en af quiz-indstillingerne.';
$string['nopossibledatasets'] = 'Ingen mulige datasæt';
$string['noquestionintext'] = 'Spørgsmålsteksten indeholder ingen indlejrede spørgsmål';
$string['noquestions'] = 'Der er ikke tilføjet nogen spørgsmål  endnu';
$string['noquestionsfound'] = 'Ingen spørgsmål fundet';
$string['noquestionsinquiz'] = 'Der er ingen spørgsmål i denne quiz.';
$string['noquestionsnotinuse'] = 'Dette tilfældige spørgsmål bruges ikke da kategorien er tom.';
$string['noquestionsonpage'] = 'Tom side';
$string['noresponse'] = 'Ingen tilbagemelding';
$string['noreview'] = 'Du kan ikke gentage quizzen';
$string['noreviewattempt'] = 'Du har ikke tilladelse til at gennemse denne besvarelse.';
$string['noreviewshort'] = 'Ikke tilladt';
$string['noreviewuntil'] = 'Du kan først se quizzen igen {$a}';
$string['noreviewuntilshort'] = 'Tilgængelig {$a}';
$string['noscript'] = 'Javascript skal være slået til';
$string['notavailabletostudents'] = 'Bemærk: Lige nu er denne quiz ikke tilgængelig for dine studerende';
$string['notenoughrandomquestions'] = 'Der er ikke tilstrækkelig mange spørgsmål i kategorien {$a->category} til at oprette spørgsmålet {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Der er ikke oprettet tilstrækkelige underspørgsmål<br />Ønsker du at gå tilbage og ordne det?';
$string['notimedependentitems'] = 'Tidsafhængige elementer understøttes ikke af quizmodulet. Men du kan eventuelt sætte tidsbegrænsning på hele quizzen. Vil du vælge et andet element (eller bruge det nuværende alligevel)?';
$string['notyetgraded'] = 'Ikke vurderet endnu';
$string['notyetviewed'] = 'Ikke set endnu';
$string['notyourattempt'] = 'Dette er ikke din besvarelse!';
$string['noview'] = 'Brugere der er logget ind, kan ikke se denne quiz';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} har lavet {$a->attemptnum} besvarelser';
$string['numattemptsmade'] = '{$a} besvarelser til denne quiz';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisk';
$string['numquestionsx'] = 'Spørgsmål: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Kun lærere kan eksportere spørgsmål';
$string['onlyteachersimport'] = 'Kun lærere som har ret til at redigere kurset, kan importere spørgsmål';
$string['onthispage'] = 'Denne side';
$string['open'] = 'Ikke besvaret';
$string['openafterclose'] = 'Kunne ikke opdatere quizzen. Du har sat åbningsdagen efter lukkedagen.';
$string['openclosedatesupdated'] = 'Åbnings- og lukkedage er opdaterede';
$string['optional'] = 'Frivillig';
$string['orderandpaging'] = 'Rækkefølge og sideopdeling';
$string['orderandpaging_help'] = 'Tallene 10, 20, 30... ved hvert spørgsmål viser rækkefølgen. Tallene øges med 10 for hver side for at give plads til indsættelse af flere sider. Rækkefølgen ændres ved at ændre tallene og klikke på "Omorganiser spørgsmålene".

Tilføj sideskift efter et spørgsmål ved at markere spørgsmålet og klikke på "Tilføj nye sider efter de valgte spørgsmål".

Spørgsmålene kan arrangeres med et fast antal spørgsmål pr. side ved at klikke på "Genindel i sider..", vælge et antal spørgsmål pr. side og klikke på "Start".';
$string['orderingquiz'] = 'Rækkefølge og sideopdeling';
$string['orderingquizx'] = 'Rækkefølge og sideopdeling: {$a}';
$string['outcomesadvanced'] = 'Udfald er avancerede indstillinger';
$string['outof'] = '{$a->grade} ud af {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} ud af {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Samlet feedback';
$string['overallfeedback_help'] = 'Den samlede feedback gives efter at quizzen er gjort færdig. Ved at angive vurderingsgrænser (i procent eller med talværdier) kan den viste tekst  afhænge af disse grænser.';
$string['overdue'] = 'For sent';
$string['overduehandling'] = 'Når tidsfristen udløber';
$string['overduehandling_desc'] = 'Hvad skal der som standard ske hvis den studerende ikke afleverer quizzen før tidsfristen udløber.';
$string['overduehandling_help'] = 'Denne indstilling styrer hvad der sker, hvis den studerende ikke afleverer sin quizbesvarelse til tiden. Er den studerende aktiv i quizzen, vil nedtællingstimeren automatisk aflevere svaret for ham/hende, men hvis vedkommende er logget ud, styrer denne indstilling hvad der sker.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Besvarelser skal afleveres før tidsfristen udløber, ellers tæller de ikke med';
$string['overduehandlingautosubmit'] = 'Åbne besvarelser bliver afleveret automatisk';
$string['overduehandlinggraceperiod'] = 'Der er tillægstid hvor åbne besvarelser kan afleveres, men hvor der ikke kan svares på flere spørgsmål';
$string['overduemustbesubmittedby'] = 'Tiden er udløbet. Svaret skulle have været afleveret. Hvis du gerne vil have denne quiz bedømt, skal du aflevere inden  {$a}. Hvis du ikke afleverer inden da, vil ingen karakterer fra denne besvarelse blive talt med.';
$string['override'] = 'Begrænsning';
$string['overridedeletegroupsure'] = 'Bekræft at du vil slette undtagelsen for gruppen {$a}.';
$string['overridedeleteusersure'] = 'Bekræft at du vil slette undtagelsen for brugereren {$a}.';
$string['overridegroup'] = 'Undtagelse for gruppe';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Undtagelser';
$string['overridesnoneforgroups'] = 'Der er ikke oprettet nogen tilsidesættelser af gruppeindstillinger i denne quiz.';
$string['overridesnoneforusers'] = 'Der er ikke oprettet nogen tilsidesættelser af brugerindstillinger i denne quiz.';
$string['overridessummary'] = 'Der er tilsidesættelser af indstillinger ({$a})';
$string['overridessummarygroup'] = 'Grupper: {$a}';
$string['overridessummarythisgroup'] = 'Der findes tilsidesættelser af indstillinger ({$a}) for denne gruppe';
$string['overridessummaryuser'] = 'Brugere: {$a}';
$string['overridessummaryyourgroups'] = 'Der findes tilsidesættelser af indstillinger ({$a}) for dine grupper';
$string['overrideuser'] = 'Undtagelse for bruger';
$string['overrideusereventname'] = '{$a->quiz} - Opret undtagelse';
$string['page-mod-quiz-attempt'] = 'Prøv quiz';
$string['page-mod-quiz-edit'] = 'Rediger quizside';
$string['page-mod-quiz-report'] = 'En hvilken som helst quiz-rapportside';
$string['page-mod-quiz-review'] = 'Vis siden med quizbesvarelse igen';
$string['page-mod-quiz-summary'] = 'Side med sammenfatning af quizbesvarelser';
$string['page-mod-quiz-view'] = 'Quiz-informationsside';
$string['page-mod-quiz-x'] = 'En hvilken som helst quiz-modulside';
$string['pageshort'] = 'S';
$string['pagesize'] = 'Antal besvarelser pr. side';
$string['parent'] = 'Overordnet kategori';
$string['parentcategory'] = 'Overordnet kategori';
$string['parsingquestions'] = 'Analyserer spørgsmål fra importfilen.';
$string['partiallycorrect'] = 'Delvist rigtigt';
$string['penalty'] = 'Strafpoint';
$string['penaltyscheme'] = 'Anvend strafpoint (for adaptiv tilstand)';
$string['penaltyscheme_help'] = 'Er indstillingen aktiveret, fratrækkes strafpoint det endelige resultat for spørgsmålet. Straffens størrelse vælges individuelt for hvert spørgsmål. Indstillingen gælder kun adaptiv tilstand.';
$string['percentcorrect'] = 'Procent korrekt';
$string['pleaseclose'] = 'Din forespørgsel er blevet behandlet. Du kan nu lukke dette vindue';
$string['pluginadministration'] = 'Quizadministration';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Vis quizzen i et "sikret" vindue';
$string['popupblockerwarning'] = 'Denne del af quizzen vises i et beskyttet vindue. Det betyder at vinduet skal åbnes i fuld skærm. Hvis du har blokeret for pop op, bedes du tillade pop op\'er for dette site. På forhånd tak.';
$string['popupnotice'] = 'Studerende vil se denne quiz i et sikret fuldskærms-vindue.';
$string['preprocesserror'] = 'Der opstod en fejl under forbehandlingen!';
$string['preview'] = 'Prøvese';
$string['previewquestion'] = 'Prøvese spørgsmålet';
$string['previewquiz'] = 'Kontroller  {$a}';
$string['previewquiznow'] = 'Prøvese quizzen';
$string['previous'] = 'Forrige tilstand';
$string['privacy:metadata:core_question'] = 'Subsystemet core_question gemmer information om brug af spørgsmål i quiz-aktiviteten.';
$string['privacy:metadata:quiz'] = 'Quiz-aktiviteten gør brug af quiz-rapporter';
$string['privacy:metadata:quiz_attempts'] = 'Data vedrørende hvert besvarelsesforsøg i en quiz.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Besvarelsesforsøgsnummer';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Den aktuelle side brugeren er på.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Hvorvidt dette er en forhåndsvisning af quizzen.';
$string['privacy:metadata:quiz_attempts:state'] = 'Aktuelle status på besvarelsesforsøget.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Summen af karakterer for forsøget.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Hvornår status blev tjekket.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Hvornår besvarelsesforsøget blev fuldført.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Hvornår besvarelsesforsøget blev opdateret.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Hvornår besvarelsesforsøget blev opdateret via offline opdatering.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Hvornår besvarelsesforsøget blev påbegyndt.';
$string['privacy:metadata:quiz_grades'] = 'Data vedrørende den generelle karakter for quizzen.';
$string['privacy:metadata:quiz_grades:grade'] = 'Den generelle karakter for quizzen.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Quizzen der blev bedømt';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Hvornår quizzen blev redigeret.';
$string['privacy:metadata:quiz_grades:userid'] = 'Brugeren der blev vurderet.';
$string['privacy:metadata:quiz_overrides'] = 'Data om quizzens undtagelser.';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Quizzens nye lukketid.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Quizzens nye tidsgrænse.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Quizzens nye åbningstid.';
$string['privacy:metadata:quizaccess'] = 'Quiz-aktiviteten gør brug af quiz-adgangsregler.';
$string['publish'] = 'Publicer';
$string['publishedit'] = 'Du skal have tilladelse i det publicerende kursus til at tilføje eller redigere spørgsmål i denne kategori.';
$string['qbrief'] = 'Sp. {$a}';
$string['qname'] = 'navn';
$string['qti'] = 'IMS QTI-format';
$string['qtypename'] = 'type, navn';
$string['question'] = 'Spørgsmål';
$string['questionbank'] = 'fra spørgsmålsbanken';
$string['questionbankmanagement'] = 'Administration af spørgsmålsbank';
$string['questionbehaviour'] = 'Spørgsmålsindstillinger';
$string['questioncats'] = 'Spørgsmålskategorier';
$string['questiondeleted'] = 'Dette spørgsmål er blevet slettet. Kontakt din lærer.';
$string['questiondependencyadd'] = 'Ingen begrænsninger på hvornår spørgsmål {$a->thisq} kan besvares • Klik for at ændre';
$string['questiondependencyfree'] = 'Ingen restriktioner på dette spørgsmål';
$string['questiondependencyremove'] = 'Spørgsmålet {$a->thisq} kan ikke besvares før det foregående spørgsmål {$a->previousq} er afsluttet • Klik for at ændre';
$string['questiondependsonprevious'] = 'Dette spørgsmål kan ikke besvares før det foregående spørgsmål er afsluttet.';
$string['questioninuse'] = 'Spørgsmålet "{$a->questionname}" anvendes pt. i: <br />"{$a->quiznames}"<br />Spørgsmålet slettes ikke fra disse quizzer, men kun fra kategorilisten.';
$string['questionmissing'] = 'Spørgsmål til denne session mangler';
$string['questionname'] = 'Navn på spørgsmål';
$string['questionnonav'] = '<span class="accesshide">Spørgsmål </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information</span> {$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Spørgsmålet {$a} blev ikke indlæst fra databasen';
$string['questionorder'] = 'Spørgsmålenes rækkefølge';
$string['questionposition'] = 'Nyt nummer i rækkefølge for spørgsmål {$a}';
$string['questions'] = 'Spørgsmål';
$string['questionsetpreview'] = 'Forhåndsvisning af spørgsmålssæt';
$string['questionsinclhidden'] = 'Spørgsmål (inklusiv skjulte)';
$string['questionsinthisquiz'] = 'Spørgsmål i denne quiz';
$string['questionsmatchingfilter'] = 'Spørgsmål der matcher filteret: {$a}';
$string['questionsperpage'] = 'Maks. antal spørgsmål pr. side';
$string['questionsperpageselected'] = 'Antal spørgsmål pr. side er indstillet, så sidenummereringen for øjeblikket er fast. Af den grund er nummereringskontrollen sat ud af funktion. Du kan ændre dette  i {$a}.';
$string['questionsperpagex'] = 'Spørgsmål pr. side: {$a}';
$string['questiontext'] = 'Spørgsmål';
$string['questiontextisempty'] = '[Manglende spørgsmålstekst]';
$string['questiontype'] = 'Spørgsmålstype {$a}';
$string['questiontypesetupoptions'] = 'Valgmuligheder for spørgsmålstyper:';
$string['quiz:addinstance'] = 'Tilføj en ny quiz';
$string['quiz:attempt'] = 'Besvar quizzer';
$string['quiz:deleteattempts'] = 'Slet quizbesvarelser';
$string['quiz:emailconfirmsubmission'] = 'Modtag bekræftelse af dine egne afleveringer af quizzer';
$string['quiz:emailnotifysubmission'] = 'Få besked om dine studerendes afleveringer af quizzer';
$string['quiz:emailwarnoverdue'] = 'Få en advarsel når tidsfristen for besvarelse er ved at være overskredet.';
$string['quiz:grade'] = 'Vurder quizzer manuelt';
$string['quiz:ignoretimelimits'] = 'Ignorer tidsbegrænsning på quizzer';
$string['quiz:manage'] = 'Administrer quizzer';
$string['quiz:manageoverrides'] = 'Administrer tilsidesættelse af quizindstillinger';
$string['quiz:preview'] = 'Kontroller quizzer';
$string['quiz:regrade'] = 'Revurder quizsvar';
$string['quiz:reviewmyattempts'] = 'Evaluer dine besvarelser';
$string['quiz:view'] = 'Vis quizinformation';
$string['quiz:viewreports'] = 'Vis quizrapport';
$string['quizavailable'] = 'Quizzen er åben indtil: {$a}';
$string['quizclose'] = 'Luk';
$string['quizclosed'] = 'Quizzen lukkede {$a}';
$string['quizcloses'] = 'Quizzen lukker';
$string['quizcloseson'] = 'Quizzen lukker {$a}';
$string['quizeventcloses'] = '{$a} lukker';
$string['quizeventopens'] = '{$a} åbner';
$string['quizisclosed'] = 'Denne quiz er lukket';
$string['quizisclosedwillopen'] = 'Quizzen er lukket  (åbner {$a})';
$string['quizisopen'] = 'Quizzen er åben';
$string['quizisopenwillclose'] = 'Quizzen er åben (lukker {$a})';
$string['quiznavigation'] = 'Quiznavigation';
$string['quizopen'] = 'Åben fra';
$string['quizopenclose'] = 'Åbnings- og lukketider';
$string['quizopenclose_help'] = 'Studerende kan kun begynde et forsøg efter åbningstidspunktet og de skal afslutte besvarelsen inden lukketid.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Denne quiz er åben.';
$string['quizopenedon'] = 'Denne quiz åbnede {$a}';
$string['quizopens'] = 'Quizzen åbner';
$string['quizopenwillclose'] = 'Denne quiz er åben og lukker d. {$a} kl.';
$string['quizordernotrandom'] = 'Rækkefølgen i quizzen er ikke blandet';
$string['quizorderrandom'] = '* Rækkefølgen i quizzen er blandet';
$string['quizreport'] = 'Quizrapport';
$string['quizsettings'] = 'Quizindstillinger';
$string['quiztimer'] = 'Quiz-timer';
$string['quizwillopen'] = 'Quizzen åbner {$a}';
$string['random'] = 'Tilfældigt spørgsmål';
$string['randomcreate'] = 'Opret tilfældige spørgsmål';
$string['randomediting'] = 'Redigering af tilfældigt spørgsmål';
$string['randomfromcategory'] = 'Tilfældig(t/e) spørgsmål fra kategorien:';
$string['randomfromexistingcategory'] = 'Tilfældige spørgsmål fra en eksisterende kategori';
$string['randomfromunavailabletag'] = '{$a} (utilgængelig)';
$string['randomnosubcat'] = 'Spørgsmål fra denne kategori alene, ikke dens underkategorier.';
$string['randomnumber'] = 'Antal tilfældige spørgsmål';
$string['randomquestion'] = 'Tilfældigt spørgsmål';
$string['randomquestion_help'] = 'Et tilfældigt spørgsmål er en måde hvorpå tilfældigt udvalgte spørgsmål fra en specifik kategori eller med et specifikt tag, kan indsættes i en aktivitet.';
$string['randomquestiontags'] = 'Tags';
$string['randomquestiontags_help'] = 'Du kan begrænse udvælgelseskriterier yderligere ved at angive nogle tags her. Tilfældige spørgsmål vil blive valgt blandt spørgsmål med disse tags.';
$string['randomquestionusinganewcategory'] = 'Tilfældige spørgsmål fra en ny kategori';
$string['randomwithsubcat'] = 'Spørgsmål fra denne kategori og dens underkategorier.';
$string['readytosend'] = 'Du er ved at aflevere alle dine svar. Er du sikker på at du vil fortsætte?';
$string['reattemptquiz'] = '--== Prøv igen ==--';
$string['recentlyaddedquestion'] = 'Nyligt tilføjet spørgsmål!';
$string['recurse'] = 'Vis også spørgsmål fra underkategorier';
$string['redoesofthisquestion'] = 'Andre spørgsmål forsøgt besvaret her: {$a}';
$string['redoquestion'] = 'Prøv et andet spørgsmål som dette';
$string['regrade'] = 'Revurder alle afleveringer';
$string['regradecomplete'] = 'Alle afleveriger er revurderet';
$string['regradecount'] = '{$a->changed} ud af {$a->attempt} bedømmelser blev ændret';
$string['regradedisplayexplanation'] = 'Besvarelser der ændres under revurdering bliver vist som link til spørgsmålets gennemsynsvindue.';
$string['regradenotallowed'] = 'Du har ikke tilladelse til at revurdere denne quiz';
$string['regradingquestion'] = 'Revurderer "{$a}"';
$string['regradingquiz'] = 'Revurderer quizzen "{$a}"';
$string['remove'] = 'Fjern';
$string['removeallgroupoverrides'] = 'Slet alle gruppeundtagelser';
$string['removeallquizattempts'] = 'Slet alle besvarelser';
$string['removealluseroverrides'] = 'Slet alle brugerundtagelser';
$string['removeemptypage'] = 'Fjern tom side';
$string['removepagebreak'] = 'Fjern sideskift';
$string['removeselected'] = 'Fjern valgte';
$string['rename'] = 'Omdøb';
$string['renderingserverconnectfailed'] = 'Serveren {$a} kunne ikke behandle en RQP-anmodning. Kontroller at URL\'en er korrekt.';
$string['reorderquestions'] = 'Omorganiser spørgsmålene';
$string['reordertool'] = 'Vis reorganiseringsværktøjet';
$string['repaginate'] = 'Sideopdeling med {$a} spørgsmål pr side.';
$string['repaginatecommand'] = 'Genindel i sider';
$string['repaginatenow'] = 'Sideinddel nu';
$string['replace'] = 'Erstat';
$string['replacementoptions'] = 'Erstatningsmuligheder';
$string['report'] = 'Rapporter';
$string['reportanalysis'] = 'Elementanalyse';
$string['reportattemptsfrom'] = 'Forsøg fra';
$string['reportattemptsthatare'] = 'Forsøg som er';
$string['reportdisplayoptions'] = 'Visningsindstillinger';
$string['reportfullstat'] = 'Detaljeret statistik';
$string['reportmulti_percent'] = 'Flere procenter';
$string['reportmulti_q_x_student'] = 'Multi-studerende valg';
$string['reportmulti_resp'] = 'Individuelle svar';
$string['reportmustselectstate'] = 'Du skal vælge mindst en tilstand';
$string['reportnotfound'] = 'Ukendt rapport ({$a})';
$string['reportoverview'] = 'Oversigt';
$string['reportregrade'] = 'Revurder forsøg';
$string['reportresponses'] = 'Detaljerede responser';
$string['reports'] = 'Rapporter';
$string['reportshowonly'] = 'Vis kun forsøg';
$string['reportshowonlyfinished'] = 'Vis højst et afsluttet forsøg pr. bruger ({$a})';
$string['reportsimplestat'] = 'Simpel statistik';
$string['reportusersall'] = 'alle brugere, der har besvaret denne quiz';
$string['reportuserswith'] = 'tilmeldte brugere, der har besvaret quizzen';
$string['reportuserswithorwithout'] = 'tilmeldte brugere, der har eller ikke har besvaret quizzen';
$string['reportuserswithout'] = 'tilmeldte brugere, der ikke har besvaret quizzen';
$string['reportwhattoinclude'] = 'Hvad der skal inkluderes i rapporten';
$string['requirepassword'] = 'Kræv adgangskode';
$string['requirepassword_help'] = 'Hvis der er oprettet en adgangskode, skal studerende indtaste den for at kunne besvarelse quizzen.';
$string['requiresubnet'] = 'Kræv netværksadresse';
$string['requiresubnet_help'] = 'Adgang til quizzen kan begrænses til et subnet på LAN\'et eller internettet ved at spedificere en kommasepareret liste med delvise eller hele IP-adresser. Under en eksamen kan det således sikres at kun eksamensdeltagere i eksamenslokalet har adgang til quizzen.';
$string['response'] = 'Respons';
$string['responses'] = 'Responser';
$string['results'] = 'Resultater';
$string['returnattempt'] = 'Tilbage til besvarelse';
$string['reuseifpossible'] = 'genbrug tidligere fjernet';
$string['reverttodefaults'] = 'Gendan standarder for quizzer';
$string['review'] = 'Gennemse';
$string['reviewafter'] = 'Tillad at gennemse quizzen efter at den er lukket';
$string['reviewalways'] = 'Tillad at gennemse til enhver tid';
$string['reviewattempt'] = 'Vis besvarelse';
$string['reviewbefore'] = 'Tillad at gennemse så længe quizzen er åben';
$string['reviewclosed'] = 'Efter at quizzen er lukket';
$string['reviewduring'] = 'Under besvarelsen';
$string['reviewimmediately'] = 'Umiddelbart efter besvarelsen';
$string['reviewnever'] = 'Tillad aldrig at gennemse';
$string['reviewofattempt'] = 'Gennemsyn af besvarelsen {$a}';
$string['reviewofpreview'] = 'Evaluer forhåndsvisningen';
$string['reviewofquestion'] = 'Evaluering af spørgsmål {$a->question} i {$a->quiz} af {$a->user}';
$string['reviewopen'] = 'Senere, mens quizzen stadig er åben';
$string['reviewoptions'] = 'Studerende må gennemse';
$string['reviewoptionsheading'] = 'Indstillinger for gennemsyn';
$string['reviewoptionsheading_help'] = 'Denne valgmulighed styrer, hvilke informationer de studerende kan se, når de ser deres svar igennem eller ser quizrapporterne.

Indstillingen **Under besvarelsen** er kun relevant for nogle typer, som f.eks. \'interaktiv med flere forsøg\', der kan vise feedback under besvarelsen.

Indstillingen **Umiddelbart efter besvarelsen** gælder de første to minutter efter at der er klikket på \'Indsend og afslut\'.

Indstillingen **Senere, mens quizzen stadig er åben** gælder derefter og inden quizzen lukker.

Indstillingen **Efter at quizzen er lukket** gælder efter at quizzens lukkedato er passeret. Hvis quizzen ikke har nogen lukkedato, nås dette stadie aldrig.';
$string['reviewoverallfeedback'] = 'Samlet feedback';
$string['reviewoverallfeedback_help'] = 'Den feedback, der gives efter besvarelsen, afhængig af den studerendes totale karakter.';
$string['reviewresponse'] = 'Gennemse svar';
$string['reviewresponsetoq'] = 'Evaluer respons (spørgsmål {$a})';
$string['reviewthisattempt'] = 'Gense dine svar i dette forsøg';
$string['rqp'] = 'Eksternt spørgsmål';
$string['rqps'] = 'Eksterne spørgsmål';
$string['sameasoverall'] = 'Samme som for de samlede karakterer';
$string['save'] = 'Gem';
$string['saveandedit'] = 'Gem ændringer og rediger spørgsmål';
$string['saveattemptfailed'] = 'Kunne ikke gemme den nuværende besvarelse.';
$string['savedfromdeletedcourse'] = 'Gemt fra det slettede kursus "{$a}"';
$string['savegrades'] = 'Gem bedømmelser';
$string['savemyanswers'] = 'Gem mine svar';
$string['savenosubmit'] = 'Gem uden at aflevere';
$string['saveoverrideandstay'] = 'Gem og tilføj en undtagelse mere';
$string['savequiz'] = 'Gem hele quizzen';
$string['saving'] = 'Gemmer';
$string['savingnewgradeforquestion'] = 'Gemmer ny karakter for spørgsmåls-id {$a}.';
$string['savingnewmaximumgrade'] = 'Gemmer ny højeste karakter.';
$string['score'] = 'Highscore';
$string['scores'] = 'Point';
$string['search:activity'] = 'Quiz - aktivitets-information';
$string['sectionheadingedit'] = 'Rediger overskriften "{$a}"';
$string['sectionheadingremove'] = 'Fjern overskriften "{$a}"';
$string['seequestions'] = '(Se spørgsmål)';
$string['select'] = 'Vælg';
$string['selectall'] = 'Vælg alle';
$string['selectattempt'] = 'Vælg besvarelse';
$string['selectcategory'] = 'Vælg kategori';
$string['selectedattempts'] = 'Valgte forsøg...';
$string['selectmultipleitems'] = 'Vælg flere elementer';
$string['selectmultipletoolbar'] = 'Vælg flere værktøjslinjer';
$string['selectnone'] = 'Fravælg alt';
$string['selectquestiontype'] = '--Vælg spørgsmålstype--';
$string['serveradded'] = 'Server tilføjet';
$string['serveridentifier'] = 'Identifikation';
$string['serverinfo'] = 'Serverinformation';
$string['servers'] = 'Servere';
$string['serverurl'] = 'Server-URL';
$string['settingsoverrides'] = 'Undtagelser fra indstillinger';
$string['shortanswer'] = 'Kort-svar';
$string['show'] = 'Vis';
$string['showall'] = 'Vis alle spørgsmål på en side';
$string['showblocks'] = 'Vis blokke under besvarelse af spørgsmål';
$string['showblocks_help'] = 'Sideblokkene kan blive vist sammen med quizzen.';
$string['showbreaks'] = 'Vis sideadskillelse';
$string['showcategorycontents'] = 'Vis kategoriindhold {$a->arrow}';
$string['showcorrectanswer'] = 'Skal korrekte svar vises i feedbacken?';
$string['showdetailedmarks'] = 'Vis vurderingsinformationer';
$string['showeachpage'] = 'Vis én side ad gangen';
$string['showfeedback'] = 'Skal feedback vises efter besvarelserne?';
$string['showinsecurepopup'] = 'Brug et "sikkret" pop op-vindue til besvarelsen';
$string['showlargeimage'] = 'Stort billede';
$string['shownoattempts'] = 'Vis studerende uden besvarelser';
$string['shownoattemptsonly'] = 'Vis kun studerende der ikke har forsøg på besvarelser';
$string['shownoimage'] = 'Intet billede';
$string['showreport'] = 'Vis rapport';
$string['showsmallimage'] = 'Lille billede';
$string['showteacherattempts'] = 'Vis lærerbesvarelser';
$string['showuserpicture'] = 'Vis brugerens billede';
$string['showuserpicture_help'] = 'Er indstillingen aktiveret, vil den studerendes navn og billede blive vist på skærmen under besvarelsen og på gennemsynssiden. Det vil gøre det nemmere for eksamensvagter at verificere om den studerende er logget ind som sig selv under en eksamen.';
$string['shuffle'] = 'Bland';
$string['shuffleanswers'] = 'Bland svar';
$string['shuffledrandomly'] = 'Tilfældig orden';
$string['shufflequestions'] = 'Bland';
$string['shufflequestions_help'] = 'Hvis du slår dette til, vil rækkefølgen af spørgsmålene i denne sektion blive blandet i ny, tilfældig orden, hver gang quizzen besvares.

Dette kan gøre det sværere for de studerende at dele svar, men det gør det også sværere for de studerende at diskutere et bestemt spørgsmål med læreren.';
$string['shufflewithin'] = 'Bland svarmuligheder';
$string['shufflewithin_help'] = 'Aktiverer du denne indstilling, vil spørgsmålenes dele komme i tilfældig rækkefølge når spørgsmålet vises - forudsat at det også er aktiveret i indstillingerne for spørgsmålet. Indstillingen gælder kun de typer spørgsmål, der har flere dele, dvs. multiple choice og match.';
$string['singleanswer'] = 'Vælg et svar';
$string['sortage'] = 'Sorter efter alder';
$string['sortalpha'] = 'Sorter efter navn';
$string['sortquestionsbyx'] = 'Sorter spørgsmål efter: {$a}';
$string['sortsubmit'] = 'Sorter spørgsmål';
$string['sorttypealpha'] = 'Sorter efter type, navn';
$string['specificapathnotonquestion'] = 'Den specificerede filsti er ikke på det specificerede spørgsmål';
$string['specificquestionnotonquiz'] = 'Det specificerede spørgsmål er ikke i den specificerede quiz';
$string['startagain'] = 'Start igen';
$string['startattempt'] = 'Start besvarelse';
$string['startedon'] = 'Startet:';
$string['startnewpreview'] = 'Start en ny forhåndsvisning';
$string['stateabandoned'] = 'Aldrig afleveret';
$string['statefinished'] = 'Færdig';
$string['statefinisheddetails'] = 'Afleveret {$a}';
$string['stateinprogress'] = 'I gang';
$string['statenotloaded'] = 'Status blev ikke indlæst fra databasen for spørgsmålet {$a}';
$string['stateoverdue'] = 'Tiden er udløbet';
$string['stateoverduedetails'] = 'Skal afleveres senest {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stop ved fejl';
$string['submitallandfinish'] = '--== Gem og aflever ==--';
$string['subneterror'] = 'Problem! Der er kun adgang til denne quiz fra bestemte netværk (IP-adresser), og din IP-adresse er ikke inden for det tilladte område.';
$string['subnetnotice'] = 'Denne quiz er begrænset så der er kun adgang fra bestemte lokationer (IP-adresser). Din computer er ikke tilsluttet et netværk (subnet) der er tilladt i quizzen. Som lærer kan du dog godt få adgang til den.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quiz_plural'] = 'Rapporter';
$string['subplugintype_quizaccess'] = 'Adgangsregel';
$string['subplugintype_quizaccess_plural'] = 'Adgangsregler';
$string['substitutedby'] = 'vil blive erstattet med';
$string['summaryofattempt'] = 'Oversigt over besvarelse';
$string['summaryofattempts'] = 'Oversigt over dine besvarelser';
$string['temporaryblocked'] = 'Du kan ikke forsøge igen lige nu. <br />Du kan forsøge igen:';
$string['theattempt'] = 'Besvarelsen';
$string['theattempt_help'] = 'Hvorvidt den studerende overhovedet kan se besvarelsen igen.';
$string['time'] = 'Tid';
$string['timecompleted'] = 'Færdig';
$string['timedelay'] = 'Du kan ikke begynde på quizzen nu, da der skal gå et stykke tid, før du kan begynde en anden quiz.';
$string['timeleft'] = 'Tid tilbage';
$string['timelimit'] = 'Tidsbegrænsning';
$string['timelimit_help'] = 'Hvis indstillingen er aktiveret, vil tidsbegrænsningen oplyses på quizzens første side og et nedtællingsur vises i navigationsblokken.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Desværre, tiden er gået.';
$string['timestr'] = '%H:%M:%S d. %d/%m-%y';
$string['timesup'] = 'Tiden er gået!';
$string['timetaken'] = 'Tidsforbrug';
$string['timing'] = 'Tidsindstillinger';
$string['tofile'] = 'til fil';
$string['tolerance'] = 'Tolerance';
$string['toomanyrandom'] = 'Der er defineret flere "tilfældige spørgsmål" end der er spørgsmål at vælge mellem i kategorien.';
$string['top'] = 'Top';
$string['totalmarksx'] = 'Samlet karakter: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total af {$a} spørgsmål i kategorien.';
$string['true'] = 'Sandt';
$string['truefalse'] = 'Sandt/falsk';
$string['type'] = 'Type';
$string['unfinished'] = 'Åben';
$string['ungraded'] = 'Ikke vurderet';
$string['unit'] = 'Måleenhed';
$string['unknowntype'] = 'Denne type spørgsmål er ikke understøttet på linje {$a}. Dette spørgsmål vil blive ignoreret.';
$string['updateoverdueattemptstask'] = 'Opdaterer for sene quiz-besvarelser';
$string['updatequizslotswithrandomxofy'] = 'Opdaterer quiz-slots med data for "tilfældige" spørgsmål ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Opdater quizindstillinger';
$string['updatingatttemptgrades'] = 'Opdaterer karakterer for besvarelserne';
$string['updatingfinalgrades'] = 'Opdaterer endelige karakterer.';
$string['updatingthegradebook'] = 'Opdaterer karakterbogen.';
$string['upgradesure'] = '<div>Især quizmodulet vil udføre en omfattende ændring af quiztabellerne og denne opgradering er endnu ikke ordentligt gennemtestet. Du anbefales derfor kraftigt at tage backup af databasen før du fortsætter.</div>';
$string['upgradingquizattempts'] = 'Opgraderer quizbesvarelser: quiz {$a->done}/{$a->outof} (Quiz-id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Opgraderer meget gamle quizbesvarelser: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Denne kategori er ikke blevet slettet men flyttet op, da det er en offentlig kategori og nogle af spørgsmålene, bliver brugt i andre kurser.';
$string['useroverrides'] = 'Brugerundtagelser';
$string['useroverridesdeleted'] = 'Brugerundtagelser slettet';
$string['usersnone'] = 'Ingen studerende har adgang til denne quiz';
$string['validate'] = 'Valider';
$string['viewallanswers'] = 'Vis {$a} færdige quizzer';
$string['viewallreports'] = 'Vis rapport over {$a} svar';
$string['viewed'] = 'Set';
$string['warningmissingtype'] = '<b>Dette spørgsmål er af en type der ikke er blevet installeret i Moodle endnu.<br />Kontakt den ansvarlige for webstedet, hvis det skal installeres.</b>';
$string['wheregrade'] = 'Hvor er min vurdering?';
$string['wildcard'] = 'Jokertegn';
$string['windowclosing'] = 'Dette vindue vil lukke om et øjeblik.';
$string['withsummary'] = 'med opsummeringsstatistik';
$string['wronguse'] = 'Du kan ikke anvende siden på denne måde';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Du skal tilmeldes kurset før du kan besvare quizzen';
$string['yourfinalgradeis'] = 'Den endelige vurdering af denne quiz er {$a}';
