<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'concordance', language 'fr', version '3.8'.
 *
 * @package     concordance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addnewpanelist'] = 'Ajouter un nouveau panéliste';
$string['atleastpanelistnotcontacted'] = 'Au moins un panéliste n\'a pas été contacté';
$string['bibliographiespanelists'] = 'Biographies des panélistes';
$string['bibliography'] = 'Biographie';
$string['cannotremoveallsectionslots'] = 'Il n\'est pas permis de supprimer toutes les questions d\'une section.';
$string['categorypanelcourses'] = 'Catégorie des cours pour le panel d\'experts';
$string['concordance:addinstance'] = 'Ajouter une nouvelle gestion d\'une formation par concordance';
$string['concordance:view'] = 'Voir la gestion d\'une formation par concordance';
$string['configcategorypanelcourses'] = 'Les cours utilisés par les panels d\'experts de l\'activité Concordance seront classés dans cette catégorie';
$string['configpanelistsrole'] = 'Les panélistes de l\'activité Concordance obtiendront ce rôle dans le cours généré pour eux';
$string['defaultemailbody'] = 'En tant que panéliste, vous êtes invité à répondre à un questionnaire.
Un lien vous est fourni au bas de ce courriel pour y accéder.
Vos réponses seront ensuite colligées avec celles des autres panélistes, pour permettre aux étudiants d\'effectuer une activité de formation par concordance.';
$string['defaultemailsubject'] = 'Questionnaire en ligne - Formation par concordance';
$string['deletepanelistconfirm'] = 'Voulez-vous vraiment supprimer ce panéliste&nbsp;?';
$string['descriptionpanelist'] = 'Description pour les panélistes';
$string['descriptionstudent'] = 'Description pour les étudiants';
$string['editpanelist'] = 'Modifier le panéliste';
$string['errorincludepanelist'] = '- Vous devez inclure au moins un panéliste';
$string['errorincludequestion'] = '- Vous devez inclure au moins une question';
$string['eventconcordanceupdated'] = 'Concordance modifiée';
$string['eventemailsent'] = 'Courriel envoyé au panéliste';
$string['generate'] = 'Générer';
$string['generatedquizname'] = 'Nom du test généré';
$string['gotogeneratedquiz'] = 'Accéder au test généré';
$string['includebibliography'] = 'Inclure les biographies des panélistes dans l\'introduction';
$string['indicator:cognitivedepth'] = 'Concordance&nbsp;: aspect cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l\'étudiant dans une activité Concordance.';
$string['indicator:socialbreadth'] = 'Concordance&nbsp;: aspect social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur se base sur l\'interaction sociale atteinte par l\'étudiant dans une activité Concordance.';
$string['message'] = 'Message';
$string['modulename'] = 'Gestion d\'une formation par concordance';
$string['modulename_help'] = 'Le module <em>gestion d\'une formation par concordance (FpC)</em> vous permet d\'effectuer les étapes clés de la scénarisation pédagogique d\'une FpC, une modalité de formation en ligne qui place les participants en situation professionnelle et qui sollicite des micro-jugements sur des questions fréquemment rencontrées dans la pratique.
<p>Pour chaque question à laquelle le participant répond, une rétroaction automatisée apparait, basée sur les réponses préalablement données par des membres d\'un panel de référence. Le participant peut ainsi&nbsp;:</p>
<ul>
    <li>s\'auto-calibrer en découvrant comment sa réponse se situe par rapport à celles du panel&nbsp;;</li>
    <li>explorer le raisonnement des membres du panel à l\'aide des justifications que ceux-ci ont données à leurs réponses&nbsp;;</li>
    <li>découvrir des synthèses éducatives après un certain nombre de questions.</li>
</ul>
Le module <em>gestion d\'une formation par concordance</em> simplifie le processus de mise en place d\'une FpC qui se réalise en trois phases&nbsp;:
<ol>
    <li>Mise en place de la formation par concordance</li>
    <li>Collecte des réponses des panélistes</li>
    <li>Génération du test pour les étudiants</li>
</ol>';
$string['modulenameplural'] = 'Gestion de formations par concordance';
$string['nbemailssent'] = 'Nb. courriels envoyés';
$string['nopanelists'] = 'Aucun panéliste n\'a encore été créé.';
$string['noquizselected_cantcontact'] = 'Il n\'est pas possible de contacter les panélistes parce que le test pour les panélistes n\'a pas encore été sélectionné.';
$string['notcompleted'] = 'Non complété';
$string['page-mod-concordance-view'] = 'Page principale de l\'activité Concordance';
$string['page-mod-concordance-x'] = 'N\'importe quelle page de l\'activité Concordance';
$string['panelistcreated'] = 'Panéliste créé';
$string['panelistdeleted'] = 'Panéliste supprimé avec succès';
$string['panelistmanagement'] = 'Gestion des panélistes';
$string['panelistslist'] = 'Liste des panélistes';
$string['panelistsquiznotfound'] = 'Aucun test trouvé pour les panélistes';
$string['panelistsrole'] = 'Rôle pour les panélistes';
$string['paneliststoinclude'] = 'Panélistes à inclure';
$string['panelistupdated'] = 'Panéliste mis à jour';
$string['phase'] = 'Phase';
$string['phase_panelists'] = 'Phase de réponses des panélistes';
$string['phase_setup'] = 'Phase de mise en place';
$string['phase_students'] = 'Phase de génération du test étudiant';
$string['pluginadministration'] = 'Administration de Concordance';
$string['pluginname'] = 'Concordance';
$string['privacy:metadata'] = 'Le plugin d\'activité Concordance n\'enregistre aucune donnée personnelle.';
$string['privacy:metadata:concordance_panelist'] = 'Un enregistrement sur l\'état du panéliste';
$string['privacy:metadata:panelist:bibliography'] = 'La biographie du panéliste';
$string['privacy:metadata:panelist:email'] = 'Le courriel du panéliste';
$string['privacy:metadata:panelist:firstname'] = 'Le prénom du panéliste';
$string['privacy:metadata:panelist:lastname'] = 'Le nom du panéliste';
$string['privacy:metadata:panelist:userid'] = 'L\'identifiant de l\'utilisateur associé au panéliste';
$string['privacy:metadata:timemodified'] = 'L\'heure à laquelle l\'enregistrement a été modifié';
$string['questionscategoryinfo'] = 'Questions dans le test généré pour les étudiants le {$a}';
$string['questionscategoryname'] = 'Concordance - Test «&nbsp;{$a}&nbsp;»';
$string['questionstoinclude'] = 'Questions à inclure';
$string['quizcontainsconcordancequestion'] = 'Le test contient des questions de type Concordance';
$string['quizcontainsotherquestion'] = 'Le test contient certaines questions de type autre que Concordance (les réponses à ces questions par les panélistes ne seront pas compilées ni rendues visibles pour les étudiants)';
$string['quizdoesnotcontainconcordancequestion'] = 'Le test ne contient pas de question de type Concordance';
$string['quizselection'] = 'Sélection du test pour les panélistes';
$string['quizstate'] = 'État du test';
$string['quiztype'] = 'Type de test';
$string['quiztype_help'] = 'Un test formatif n\'apparaitra pas au carnet de notes et affichera aux étudiants la rétroaction immédiate pour chaque question.

Un test sommatif apparaitra au carnet de notes. La rétroaction sera affichée aux étudiants a posteriori dès la tentative finalisée («&nbsp;sommatif avec rétroaction&nbsp;») ou ne sera pas affichée («&nbsp;sommatif sans rétroaction&nbsp;»).

Dans tous les cas, il sera par la suite toujours possible de modifier le comportement du test en modifiant ses paramètres.';
$string['quiztypeformative'] = 'Formatif';
$string['quiztypesummativewithfeedback'] = 'Sommatif avec rétroaction';
$string['quiztypesummativewithoutfeedback'] = 'Sommatif sans rétroaction';
$string['quizvisibletostudent'] = 'Le test sélectionné est actuellement visible par les étudiants du cours';
$string['search:activity'] = 'Gestion d\'une formation par concordance';
$string['selectquiz_panelistcontacted'] = 'Il n\'est pas possible de changer le test puisqu\'au moins un panéliste a déjà été contacté. Pour qu\'il soit possible de changer le test, vous devez supprimer les panélistes déjà contactés. Le lien qu\'ils ont reçu par courriel ne sera plus fonctionnel, et vous devrez les re-créer et les re-contacter.';
$string['sendemailnote'] = 'Note : un lien personnalisé sera ajouté automatiquement à la fin de chacun des courriels pour permettre au panéliste de se connecter automatiquement au test à répondre';
$string['shouldnotmodifyquiz'] = 'Vous ne devez pas modifier le contenu du test actuellement sélectionné puisque ces modifications ne seront pas répercutées sur le test des panélistes.';
$string['studentquizgenerated'] = 'Un nouveau test a été généré pour les étudiants, il n\'est pas visible pour les étudiants pour l\'instant.';
$string['subject'] = 'Objet';
$string['switchphase'] = 'Changer de phase';
$string['switchtonextphase'] = 'Passer à la phase suivante';
$string['task_contactpanelists'] = 'Contacter les panélistes';
$string['task_editsettings'] = 'Modifier les paramètres';
$string['task_generatequiz'] = 'Générer le test pour les étudiants';
$string['task_panelistsmanagement'] = 'Générer les panélistes';
$string['task_quizselection'] = 'Sélectionner le test pour les panélistes';
$string['taskdone'] = 'Tâche effectuée';
$string['taskfail'] = 'Tâche échouée';
$string['taskinfo'] = 'Information sur une tâche';
$string['tasktodo'] = 'Tâche à effectuer';
$string['unfilledfield'] = 'Le champ «&nbsp;{$a}&nbsp;» n\'est pas rempli';
