<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'fr', version '3.8'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Ajouter des tuiles';
$string['admintools'] = 'Outils d\'administration';
$string['all'] = 'Toutes';
$string['allcomplete'] = 'Toutes complètes';
$string['allcoursescomplypalette'] = 'Tous les cours ont déjà des couleurs de tuiles autorisées. Rien à réinitialiser. Assurez-vous d\'enregistrer toutes les modifications apportées aux couleurs autorisées avant de lancer la réinitialisation.';
$string['allowlabelconversion'] = 'Autoriser la conversion des étiquettes en pages';
$string['allowlabelconversion_desc'] = 'Si cette option est cochée, les enseignants auront une option dans les paramètres d\'édition de chaque étiquette pour convertir l\'étiquette en page.';
$string['allowphototiles'] = 'Autoriser les tuiles photo';
$string['allowphototiles_desc'] = 'Si cette option est sélectionnée, les enseignants pourront télécharger une photo qui servira de fond pour la tuile. Ils pourront toujours utiliser les icônes de tuiles standard, dans le même cours. (Si elle n\'est pas sélectionnée, seules les icônes de tuiles seront autorisées et les autres paramètres de tuile photo ci-dessous seront ignorés.)';
$string['allowsubtilesview'] = 'Autoriser l\'affichage de sous-tuiles';
$string['allowsubtilesview_desc'] = 'Permet l\'utilisation d\'un réglage de parcours qui, s\'il est sélectionné, montre dans une tuile les activités (à l\'exception des étiquettes) comme sous tuiles, au lieu d\'une liste standard.';
$string['alternativelink'] = 'Lien alternatif';
$string['areyousure'] = 'Voulez-vous vraiment effectuer cette opération ?';
$string['asfraction'] = 'Afficher comme fraction';
$string['aspectratiotootallorwide'] = 'L\'image importée a été enregistrée, mais veuillez vérifier, car elle peut être <strong> {$a->tallorwide} </strong>. Si cela ne semble pas correct, veuillez la rogner aux dimensions standard du paysage et la téléverser à nouveau. Par exemple 200 de large x 300 de haut conviendraient.';
$string['aspercentagedial'] = 'Afficher en % dans le cercle';
$string['assumedatastoreconsent'] = 'Consentir au stockage des données dans la mémoire locale du navigateur';
$string['assumedatastoreconsent_desc'] = 'Si cette option est sélectionnée, l\'utilisateur <b>ne verra plus</b> apparaître une boîte de dialogue lui demandant de consentir au stockage des données dans la mémoire locale du navigateur.';
$string['basecolour'] = 'Couleur des tuiles';
$string['basecolour_help'] = 'La couleur définie ici sera appliquée à toutes les tuiles du cours. Les couleurs disponibles sont déterminées par l\'administrateur de votre site dans les réglages du plugin Tuiles';
$string['blockedpopup'] = 'Votre navigateur a bloqué une fenêtre surgissante ? Merci d\'autoriser les fenêtres surgissante depuis ce site, ou cliquez sur le lien suivant pour accéder au site dans cette fenêtre.';
$string['blockedpopuptitle'] = 'Fenêtre surgissante bloquée.';
$string['brandcolour'] = 'Couleur du bandeau';
$string['browserstorage'] = 'Stockage du navigateur';
$string['canceltask'] = 'Annuler la tâche';
$string['changedcolour'] = 'Couleur des tuiles par défaut pour le cours {$a}';
$string['checkforproblemcourses'] = 'Rechercher et résoudre les problèmes de cours';
$string['clickiffailstoload'] = 'Cliquer si la page ne se charge pas';
$string['close'] = 'Fermer';
$string['collapse'] = 'Réduire la section';
$string['collapsesections'] = 'Tout réduire';
$string['colourblue'] = 'Bleu';
$string['colourdarkgreen'] = 'Vert foncé';
$string['colourgreen'] = 'Vert';
$string['colourlightblue'] = 'Bleu clair';
$string['colourname_descr'] = 'Nom d\'affichage de la couleur. Le nom n\'est en général pas vu par les utilisateurs, à qui est présenté un nuancier';
$string['colournamegeneral'] = 'Afficher le nom de la couleur ci-dessus';
$string['colourpurple'] = 'Violet';
$string['colourred'] = 'Rouge';
$string['colours'] = 'Couleurs';
$string['complete'] = 'achevé';
$string['complete-n-auto'] = 'Élément non achevé. Il sera considéré comme achevé lorsque vous aurez rempli les critères d\'achèvement. Vous ne pouvez pas le modifier manuellement.';
$string['complete-y-auto'] = 'Élément achevé. Il a été marquée comme étant achevé lorsque vous avez rempli les critères d\'achèvement. Vous ne pouvez pas le modifier manuellement.';
$string['completion_help'] = 'Une coche à droite d\'une activité peut être utilisée pour indiquer quand l\'activité est terminée (un cercle vide sera affiché si non). <br><br>
Selon le réglage, une coche peut apparaître automatiquement lorsque vous avez terminé l\'activité selon les conditions définies par l\'enseignant.<br><br>
Dans d\'autres cas, vous pouvez cliquer sur le cercle vide lorsque vous pensez avoir terminé l\'activité. Celle-ci se transforme en une coche verte pleine. (Si vous cliquez de nouveau dessus, la coche se vide.)';
$string['completionswitchhelp'] = '<p>Vous avez choisi d\'afficher le suivi de l\'achèvement sur chaque tuile. Nous avons donc défini « Suivi de l\'achèvement > Activer » plus bas dans cette page sur « Oui ».</p>
<p>En outre, vous devez activer le suivi d\'achèvement pour <b>chaque élément </b> que vous suivez. Par exemple, pour un PDF, cliquez sur « Modifier les paramètres », regardez sous Activité terminée, et choisissez le paramètre dont vous avez besoin.</p>
<p>Vous pouvez aussi le faire <b>en lot</b> comme expliqué dans la <a href="https://docs.moodle.org/3x/fr/Achèvement_des_activités" target="_blank">documentation sur le suivi du progrès sur moodle.org</a></p>';
$string['completionwarning'] = 'Vous avez activé le suivi de l\'achèvement au niveau du cours, mais au niveau de l\'activité individuelle, aucun élément n\'a activé le suivi, il n\'y a donc rien à suivre.';
$string['completionwarning_changeinbulk'] = 'Modifier en lot';
$string['completionwarning_help'] = 'Vous devez rendre les éléments individuels traçables en les modifiant (sous Achèvement de l\'activité > Suivi de l\'achèvement) ou vous pouvez le faire en masse sous Administration des cours > Achèvement du cours';
$string['contact'] = 'Entrer en contact';
$string['contactdeveloper'] = 'Contacter le développeur';
$string['contents'] = 'Contenus';
$string['converttopage'] = 'Convertir en page';
$string['converttopage_confirm'] = 'Voulez-vous vraiment le faire ? Ceci ne peut pas être annulé (vous devrez créer à nouveau l\'étiquette manuellement si nécessaire).';
$string['courseshowtileprogress'] = 'Progression dans chaque tuile';
$string['courseshowtileprogress_error'] = 'Vous avez le \'Suivi de l\'achèvement > Activer le suivi de l\'achèvement\' réglé sur \'Non\' (voir plus bas sur cette page) qui entre en conflit avec ce paramètre. Si vous souhaitez afficher la progression sur les tuiles, définissez le \'Suivi de l\'achèvement > Activer le suivi de l\'achèvement\' sur \'Oui\'. Sinon, réglez ce paramètre sur \'Non\'.';
$string['courseshowtileprogress_help'] = '<p>Lorsque cette option est sélectionnée, la progression des activités de l\'utilisateur sera affichée dans chaque tuile, soit sous la forme d\'une <em>fraction</em> (par ex. \'Progrès 2/10\' signifiant que 2 activités sur 10 sont achevées), soit sous la forme d\'un <em>pourcentage</em> dans un cercle.</p><p>Il ne peut être utilisé que si l\'option \'Achèvement > Activer le suivi de l\'achèvement\' a été activée.</p><p>S\'il n\'y a pas d\'activités traçables dans une tuile donnée, l\'indicateur ne sera pas affiché pour cette tuile.</p>';
$string['coursetoomanysections'] = 'Attention aux éditeurs : ce cours a plus de tuiles que le maximum autorisé. Un maximum de {$a->max} sera montré aux étudiants (jusqu\'à « {$a->tilename} ») (les éditeurs peuvent en voir plus).';
$string['courseusebarforheadings'] = 'Souligner les titres avec des onglets de couleur';
$string['courseusebarforheadings_help'] = 'Afficher un onglet coloré à gauche de l\'en-tête dans le cours chaque fois qu\'un style d\'en-tête est sélectionné dans l\'éditeur de texte.';
$string['courseusesubtiles'] = 'Utiliser des sous-tuiles pour les activités';
$string['courseusesubtiles_help'] = 'Dans chaque tuile, montrez chaque activité comme une sous-tuile, au lieu d\'une liste d\'activités en bas de la page. Ceci ne s\'applique pas aux étiquettes qui ne seront pas affichées en tant que sous-tuiles et peuvent donc être utilisées comme titres entre les tuiles.';
$string['currentsection'] = 'Cette tuile';
$string['customcss'] = 'CSS personnalisé';
$string['customcssdesc'] = 'CSS personnalisé pour l\'appliquer à la section du contenu du cours lorsque le format du cours est utilisé. Ceci ne sera pas validé, alors prenez soin d\'entrer un code valide. Par exemple : <p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Préférence pour les données';
$string['datapreferror'] = 'La fonction de préférence de données n\'est disponible que si JavaScript est disponible dans votre navigateur. Sinon, le stockage des données ne peut pas être activé.';
$string['dataprefquestion'] = '<p> Pour faciliter l\'utilisation de ce site, nous stockons des informations fonctionnelles dans votre navigateur telles que le contenu de la dernière tuile que vous avez ouverte. Cela reste sur votre ordinateur pendant un court moment au cas où vous visiteriez à nouveau cette page. Nous ne l\'utilisons pas pour le suivi. Êtes-vous d\'accord? </p> <p> Nous nous souviendrons de votre choix jusqu\'à ce que vous effaciez votre historique de navigation. Pour vous désinscrire, cliquez sur "Annuler" (cela peut ralentir le chargement des pages). </p>';
$string['defaultthiscourse'] = 'Par défaut pour ce cours';
$string['defaulttilecolour'] = 'Couleur de tuile par défaut';
$string['defaulttileicon'] = 'Icône de tuile';
$string['defaulttileicon_help'] = 'L\'icône sélectionnée ici apparaîtra par défaut sur <em>toutes</em> les tuiles dans ce cours. On peut définir des icônes différentes pour les tuiles en utilisant les différents réglages au niveau de chaque tuile.';
$string['deleteemptytiles'] = 'Supprimer les tuiles vides';
$string['deleteimage'] = 'Supprimer l\'image';
$string['deletesection'] = 'Supprimer la tuile';
$string['deletetile'] = 'Supprimer la tuile';
$string['developedby'] = 'Format Tuiles développé par {$a}';
$string['developer'] = 'Développeur';
$string['disabledbyadmin'] = 'Désactivé par l\'administrateur sur site';
$string['displayfilterbar'] = 'Barre de filtrage';
$string['displayfilterbar_error'] = 'Si vous n\'avez pas défini de résultats pour ce cours, vous ne pouvez afficher qu\'une barre de filtre basée sur le nombre de tuiles, et non sur les résultats. Créez d\'abord quelques résultats, puis revenez ici. Voir';
$string['displayfilterbar_help'] = '<p>Lorsque sélectionné, s\'affichera automatiquement un tableau de boutons avant l\'écran de tuiles dans un cours, que les utilisateurs peuvent cliquer pour filtrer les tuiles jusqu\'à une certaine plage.</p><p>Lorsque l\'option « basé sur les numéros de tuiles » est sélectionnée, une série de boutons sera affichée, par exemple un bouton pour tuiles 1-4, un bouton pour tuiles 5-8, etc.</p><p>Lorsque l\'option « basé sur les résultats du cours » est sélectionnée, il y a un bouton par résultat du cours. Chaque tuile peut être assignée à un résultat donné (et donc à un bouton donné) à partir de la page des paramètres de cette tuile.';
$string['displaytitle_mod_doc'] = 'Document Word';
$string['displaytitle_mod_html'] = 'Page Web';
$string['displaytitle_mod_jpeg'] = 'Image';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Vidéo';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Présentation PowerPoint';
$string['displaytitle_mod_txt'] = 'Texte';
$string['displaytitle_mod_xls'] = 'Feuille de calcul';
$string['displaytitle_mod_zip'] = 'Zip';
$string['documentation'] = 'Documentation';
$string['documentationurl'] = 'URL de la documentation';
$string['documentationurl_descr'] = 'URL de la documentation du format Tuiles.';
$string['download'] = 'Télécharger';
$string['editsectionname'] = 'Éditer le nom de la tuile';
$string['embeddedurlerror'] = 'Si le site Web externe refuse de se connecter dans la fenêtre ci-dessus, utilisez ceci :';
$string['entersection'] = 'Entrer dans la section';
$string['existingimage'] = 'Image existante pour cette tuile';
$string['expand'] = 'Déplier';
$string['expandall'] = 'Tout déplier';
$string['expandsections'] = 'Révéler toutes les activités (toutes les sections)';
$string['experimentalfeature'] = 'Fonctionnalité expérimentale';
$string['experimentalsetting'] = '(réglage expérimental)';
$string['fileaddedtobottom'] = 'Fichier ajouté en bas de la section';
$string['filenoshowtext'] = 'Si le fichier ne s\'affiche pas ici, veuillez utiliser les boutons à droite pour le télécharger ou le visualiser dans une nouvelle fenêtre.';
$string['filterboth'] = 'Afficher les boutons en fonction du nombre de tuiles et des résultats du cours';
$string['filternumbers'] = 'Afficher les boutons en fonction des numéros de tuile';
$string['filteroutcomes'] = 'Afficher les boutons en fonction des résultats du cours';
$string['filteroutcomesrestore'] = 'Le cours d\'origine utilisait les résultats dans la barre de filtre, qui ne sont pas encore pris en charge pendant le processus de restauration. Le réglage de la barre de filtre a donc été modifié dans le parcours restauré. Si vous souhaitez utiliser les résultats pour filtrer les tuiles dans le cours restauré, veuillez configurer à nouveau les résultats. Le parcours initial n\'a pas été modifié.';
$string['fittilestowidth'] = 'Ajuster les tuiles à la largeur de l\'écran';
$string['fittilestowidth_desc'] = 'Si cette case est cochée, lorsqu\'un utilisateur accède à un cours sur un appareil non mobile, les tuiles retardent le chargement d\'une demi-seconde pendant qu\'un calcul est effectué pour déterminer la meilleure mise en page. Par exemple. évitez une tuile par rangée, centrez les tuiles sur l\'écran. Cela ne se produira que la première fois qu\'elles apparaîtront dans le cours dans une session donnée et sera ensuite mémorisé pour la session ou jusqu\'à ce que l\'utilisateur ajuste la taille de son écran.';
$string['fixproblems'] = 'Résoudre les problèmes';
$string['folderdisplayerror'] = 'Les dossiers configurés pour afficher le contenu en ligne ne sont pas compatibles avec le format des sous-dossiers. Ce <a href="{$a}">dossier</a> a donc été changé pour s\'afficher sur une page séparée';
$string['followthemecolour'] = 'Forcer la couleur du thème suivante';
$string['followthemecolour_desc'] = 'Si le paramètre a la valeur oui, les enseignants n\'auront pas le choix avec ce plugin et toutes les couleurs des tuiles ci-dessous seront ignorées. Au lieu de cela, on tentera d\'obtenir la couleur principale de la marque du thème et d\'utiliser cette couleur à la place.';
$string['guidance'] = 'Guide';
$string['height'] = 'hauteur';
$string['hidden'] = 'Caché';
$string['hide'] = 'Cacher';
$string['hidefromothers'] = 'Cacher la tuile';
$string['highestsectionnum'] = 'Numéro de section le plus élevé trouvé';
$string['highlightoff'] = 'Enlever le marquage';
$string['home'] = 'Accueil du cours';
$string['hovercolour'] = 'Couleur du survol de la tuile';
$string['hovercolour_descr'] = 'Couleur qui s\'affichera au survol d\'une tuile à la souris';
$string['icontitle-address-book-o'] = 'Carnet d\'adresses';
$string['icontitle-assessment_graded'] = 'Devoir A+';
$string['icontitle-assessment_timer'] = 'Devoir chronométré';
$string['icontitle-asterisk'] = 'Astérisque';
$string['icontitle-award-solid'] = 'Badge';
$string['icontitle-balance-scale'] = 'Balance';
$string['icontitle-bar-chart'] = 'Histogramme';
$string['icontitle-bell-o'] = 'Cloche';
$string['icontitle-binoculars'] = 'Jumelle';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Livre';
$string['icontitle-bookmark-o'] = 'Favori';
$string['icontitle-briefcase'] = 'Sacoche';
$string['icontitle-building'] = 'Immeuble';
$string['icontitle-bullhorn'] = 'Porte-voix';
$string['icontitle-bullseye'] = 'Cible';
$string['icontitle-calculator'] = 'Calculette';
$string['icontitle-calendar'] = 'Calendrier';
$string['icontitle-calendar-check-o'] = 'Calendrier avec coche';
$string['icontitle-check'] = 'Coche';
$string['icontitle-child'] = 'Enfant';
$string['icontitle-clock-o'] = 'Horloge';
$string['icontitle-clone'] = 'Copie';
$string['icontitle-cloud-download'] = 'Nuage (téléchargement)';
$string['icontitle-cloud-upload'] = 'Nuage (téléversement)';
$string['icontitle-comment-o'] = 'Bulle';
$string['icontitle-comments-o'] = 'Bulles';
$string['icontitle-compass'] = 'Boussole';
$string['icontitle-diamond'] = 'Diamant';
$string['icontitle-dollar'] = 'Dollar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Exclamation dans un triangle';
$string['icontitle-feed'] = 'Flux RSS';
$string['icontitle-file-text-o'] = 'Fichier texte';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Drapeau (à damier)';
$string['icontitle-flag-o'] = 'Drapeau';
$string['icontitle-flash'] = 'Éclair';
$string['icontitle-flask'] = 'Flacon';
$string['icontitle-flipchart'] = 'Tableau de conférence';
$string['icontitle-frown-o'] = 'Froncement de sourcils';
$string['icontitle-gavel'] = 'Marteau';
$string['icontitle-gbp'] = 'Livre anglaise';
$string['icontitle-globe'] = 'Globe';
$string['icontitle-handshake-o'] = 'Mains';
$string['icontitle-headphones'] = 'Casque audio';
$string['icontitle-heartbeat'] = 'Battements de cœur';
$string['icontitle-history'] = 'Horloge (retour)';
$string['icontitle-home'] = 'Maison';
$string['icontitle-id-card-o'] = 'Carte d\'identité';
$string['icontitle-info'] = 'Information';
$string['icontitle-jigsaw'] = 'Puzzle';
$string['icontitle-key'] = 'Clé';
$string['icontitle-laptop'] = 'Ordinateur';
$string['icontitle-life-buoy'] = 'Bouée de sauvetage';
$string['icontitle-lightbulb-o'] = 'Ampoule';
$string['icontitle-line-chart'] = 'Diagramme en ligne';
$string['icontitle-list'] = 'Liste (à puces)';
$string['icontitle-list-ol'] = 'Liste (numérotée)';
$string['icontitle-location-arrow'] = 'Flèche de direction';
$string['icontitle-map-marker'] = 'Repère cartographique';
$string['icontitle-map-o'] = 'Carte';
$string['icontitle-map-signs'] = 'Panneaux cartographiques';
$string['icontitle-microphone'] = 'Microphone';
$string['icontitle-mobile-phone'] = 'Téléphone portable';
$string['icontitle-mortar-board'] = 'Toque';
$string['icontitle-music'] = 'Musique';
$string['icontitle-newspaper-o'] = 'Journal';
$string['icontitle-number_1'] = 'Numéro 1';
$string['icontitle-number_10'] = 'Numéro 10';
$string['icontitle-number_2'] = 'Numéro 2';
$string['icontitle-number_3'] = 'Numéro 3';
$string['icontitle-number_4'] = 'Numéro 4';
$string['icontitle-number_5'] = 'Numéro 5';
$string['icontitle-number_6'] = 'Numéro 6';
$string['icontitle-number_7'] = 'Numéro 7';
$string['icontitle-number_8'] = 'Numéro 8';
$string['icontitle-number_9'] = 'Numéro 9';
$string['icontitle-pencil-square-o'] = 'Crayon dans un carré';
$string['icontitle-person'] = 'Personne';
$string['icontitle-pie-chart'] = 'Camembert';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Pièce de puzzle';
$string['icontitle-question-circle'] = 'Point d\'interrogation';
$string['icontitle-random'] = 'Aléatoire';
$string['icontitle-refresh'] = 'Circulaire';
$string['icontitle-road'] = 'Autoroute';
$string['icontitle-search'] = 'Loupe';
$string['icontitle-sliders'] = 'Curseurs';
$string['icontitle-smile-o'] = 'Sourire';
$string['icontitle-star'] = 'Étoile (pleine)';
$string['icontitle-star-half-o'] = 'Étoile (à moitié pleine)';
$string['icontitle-star-o'] = 'Étoile (vide)';
$string['icontitle-survey'] = 'Sondage';
$string['icontitle-tags'] = 'Etiquettes';
$string['icontitle-tasks'] = 'Tâches';
$string['icontitle-television'] = 'Écran';
$string['icontitle-thinking-person'] = 'Personne avec ampoule';
$string['icontitle-thumbs-o-down'] = 'Pouce baissé';
$string['icontitle-thumbs-o-up'] = 'Pouce levé';
$string['icontitle-trophy'] = 'Trophée';
$string['icontitle-umbrella'] = 'Parapluie';
$string['icontitle-university'] = 'Université';
$string['icontitle-user-o'] = 'Personne (sans ombre)';
$string['icontitle-users'] = 'Gens';
$string['icontitle-volume-up'] = 'Haut parleur';
$string['icontitle-wrench'] = 'Clé à molette';
$string['imagecannotbeused'] = 'L\'image ne peut pas être utilisée';
$string['imagedeletedfrom'] = 'Image supprimée de « {$a} »';
$string['imagesavedfor'] = 'Image enregistrée pour la tuile {$a}';
$string['imagesize'] = 'Taille de l\'image';
$string['items'] = 'Éléments';
$string['jsactivate'] = 'Activer la navigation animée';
$string['jsdeactivate'] = 'Désactiver la navigation animée';
$string['jsdeactivated'] = 'Vous avez désactivé la navigation animée. Vous pouvez la réactiver à l\'aide du menu de navigation.';
$string['jsmaxstoreditems'] = 'Nombre maximal d\'éléments de contenu dans le stockage de session de navigateur';
$string['jsmaxstoreditems_desc'] = 'Lorsque les utilisateurs naviguent sur l\'écran principal des tuiles, le navigateur stocke le code HTML pour l\'écran de vue d\'ensemble des tuiles lui-même, et le contenu de chaque tuile, jusqu\'au nombre maximum d\'éléments sélectionnés ici. Ceci permet une réponse très rapide lorsqu\'on clique sur une nouvelle tuile. Si vous réglez cette valeur à un niveau trop élevé, la mémoire du navigateur risque d\'être pleine (bien que cela n\'ait pas été un problème jusqu\'à présent lors des tests).';
$string['jsnavsettings'] = 'Navigation Javascript';
$string['jsreactivated'] = 'Vous avez activé la navigation animée. Cela peut être plus rapide à utiliser, mais nécessite l\'activation de JavaScript.';
$string['jsstoredcontentdeletemins'] = 'Suppression du contenu stocké de la session après (minutes)';
$string['jsstoredcontentdeletemins_desc'] = 'Après chaque clic de souris, afin de garder l\'espace libre pour le code HTML actuel, le navigateur de l\'utilisateur exécutera un nettoyage et <em>supprimera</em>delete</em> du stockage de session tous les contenus stockés plus anciens (sur la base qu\'il n\'est plus fiable et qu\'une nouvelle copie du serveur sera nécessaire)';
$string['jsstoredcontentexpirysecs'] = 'Le contenu stocké de la session expire après (secondes)';
$string['jsstoredcontentexpirysecs_desc'] = 'Lorsqu\'un utilisateur clique sur une tuile, si le contenu de la tuile dans le stockage de session du navigateur est plus ancien, il sera toujours affiché, mais une demande en arrière-plan sera faite au serveur pour une nouvelle copie afin de le remplacer. Ceci est pour permettre les mises à jour ultérieures du cours après que le navigateur a stocké sa copie. Si le contenu stocké est plus récent, il sera considéré comme étant à jour et sera affiché, sans qu\'aucune demande de serveur ne soit faite.';
$string['labelconverted'] = 'Étiquette convertie';
$string['links'] = 'Liens';
$string['loading'] = 'Chargement';
$string['maxcoursesectionsallowed'] = 'Le nombre maximum de sections de cours autorisées dans cet environnement est de {$ a}.';
$string['modalmodules'] = 'Modules modaux';
$string['modalmodules_desc'] = 'Lancer ces modules de cours dans une fenêtre modale. D\'autres modules pourraient être ajoutés dans une version ultérieure.';
$string['modalresources'] = 'Ressources modales';
$string['modalresources_desc'] = 'Lancer ces ressources dans une fenêtre modale. Remarque : si l\'autorisation est donnée ici, les activités URL s\'ouvriront dans une fenêtre modale si elles sont réglées sur {$a->displayembed} au niveau de l\'activité (par exemple des vidéos YouTube ou Vimeo). Même dans ce cas, leur affichage intégré peut être bloqué par leur propriétaire. Voir {$a->link}';
$string['modalwindows'] = 'Fenêtres modales';
$string['newsectionname'] = 'Nouveau nom pour la section {$a}';
$string['nexttopic'] = 'Section suivante';
$string['noconnectionerror'] = 'Impossible de charger le contenu. Vérifiez votre connexion Internet';
$string['nojswarning'] = 'Il semble que votre navigateur ne pas supporte pas JavaScript, ou celui-ci est désactivé. Une interface améliorée est disponible si vous activez JavaScript';
$string['none'] = 'Aucun';
$string['noproblemsfound'] = 'Aucun problème trouvé';
$string['notcomplete'] = 'Non achevé';
$string['notrecommended'] = 'Non recommandé';
$string['notregistered'] = 'Votre plugin Tuiles n\'est pas encore enregistré auprès du développeur du plugin.';
$string['novaliddefaultcolour'] = 'Aucune couleur valide définie pour la couleur de tuile par défaut ci-dessous';
$string['numberofsections'] = 'Nombre de sections dans le cours';
$string['ok'] = 'D\'accord';
$string['other'] = 'Autre';
$string['outcomes'] = 'résultats';
$string['outcomesunavailable'] = 'Résultats non disponibles';
$string['overall'] = 'Global';
$string['overallprogress'] = 'Achèvement d\'activité - progression générale';
$string['overallprogressshort'] = 'Progression générale';
$string['photoguidance_desc'] = '<p>Importez une photo au format <strong>paysage</strong>. La largeur doit être d\'environ 1,35 fois la hauteur. Par exemple. largeur 270 x  hauteur 200 conviendraient bien. Ce rapport n\'a pas besoin d\'être exact. </p>
<p> Les photos au format portrait ne correspondront pas à la forme de la tuile. Les images ou fichiers volumineux seront réduits et compressés si nécessaire, après le téléchargement.</p>';
$string['photolibrary'] = 'Galerie photo';
$string['photolibrary_desc'] = 'Ce sont les photos que vous avez téléchargées ou utilisées récemment. Pour en utiliser une comme arrière-plan de cette tuile, cliquez dessus. Pour en télécharger une nouvelle, utilisez l\'onglet de téléchargement ci-dessus.';
$string['phototilesaltstyle'] = 'Style alternatif de tuiles photo';
$string['phototilesaltstyle_desc'] = 'Si elles ne sont pas sélectionnées (ce qui est la valeur par défaut), les tuiles photo afficheront le titre en haut de la tuile. Le style alternatif montre le titre en bas';
$string['phototilesettings'] = 'Tuiles photo';
$string['phototiletitletransarency'] = 'Transparence du titre de la tuile photo';
$string['phototiletitletransarency_desc'] = 'La superposition de titre sur une tuile photo peut avoir un arrière-plan légèrement transparent (transparence de 30%t par défaut) ou un arrière-plan de couleur unie (0%)';
$string['phototitletitlelineheight'] = 'Hauteur de ligne de la tuile';
$string['phototitletitlepadding'] = 'Remplissage de la ligne verticale du titre';
$string['picknewicon'] = 'Choisir une nouvelle icône';
$string['picknewiconphoto'] = 'Choisir une nouvelle icône ou une photo d\'arrière-plan';
$string['pluginname'] = 'Format Tuiles';
$string['previoustopic'] = 'Section précédente';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Est-ce que l\'utilisateur a désactivé la navigation JavaScript animée.';
$string['privacypolicy'] = 'Politique de confidentialité';
$string['problemcourses'] = 'Cours où il y a des problèmes';
$string['problemcoursesintro'] = 'Les cours suivants ont des numéros de section plus élevés que prévu.  Veuillez utiliser les boutons ci-dessous pour résoudre les problèmes.';
$string['progress'] = 'Progression';
$string['reactivate'] = 'réactiver';
$string['register'] = 'Enregistrer';
$string['registeragreeprivacy'] = 'J\'accepte le {$a->privacypolicylink} du développeur du plugin';
$string['registerclicktocomplete'] = 'Cliquez sur D\'accord pour terminer le processus';
$string['registeredthanks'] = 'Votre plugin est enregistré. Je vous remercie.';
$string['registeremailno'] = 'Non, je ne souhaite recevoir aucun courriel';
$string['registeremailyes'] = 'Oui, je désire recevoir des notifications de mise à jour occasionnelles et d\'autres informations sur le plugin Tuiles';
$string['registerintro1'] = 'Nous serions ravis de rester en contact! Lorsque vous vous inscrivez';
$string['registerintro2'] = 'vous soutenez le développement futur de ce plugin';
$string['registerintro3'] = 'vous pouvez être averti rapidement des mises à jour importantes et des projets futurs';
$string['registerintro4'] = 'nous aimerions en savoir plus sur ce que vous aimeriez faire de ce plugin.';
$string['registerintro5'] = 'Vos coordonnées resteront confidentielles par le développeur, comme indiqué dans la politique de confidentialité ci-dessous. Merci pour votre soutien !';
$string['registermissingemail'] = 'Veuillez compléter votre adresse de courriel (vous avez sélectionné "Oui" pour les courriels ci-dessous)';
$string['registerpickemailpref'] = 'Veuillez sélectionner votre préférence de courriel';
$string['registerpolicyagreedlinktext'] = 'Politique de confidentialité et accord de traitement des données';
$string['registrationdeferred'] = 'Merci. Nous essayons d\'enregistrer votre plugin (ce n\'est pas encore terminé).';
$string['reopenlastsection'] = 'Ré-ouvrir la dernière tuile visitée';
$string['reopenlastsection_desc'] = 'Si coché, si un utilisateur revient sur un cours, la dernière section qu\'il avait ouverte sera ré-ouverte à l\'arrivée.';
$string['resetallcoursecolours'] = 'Réinitialiser toutes les couleurs de cours';
$string['resetcolours'] = 'Réinitialiser les couleurs';
$string['resetcolours_desc'] = 'Appuyez sur ce bouton pour réinitialiser la couleur de la tuile pour tous les cours qui n\'ont pas l\'une des couleurs ci-dessous. Les cours seront remplacés par la couleur de tuile par défaut ci-dessous. Vous pouvez l\'utiliser après avoir modifié la palette de couleurs ci-dessous, mais assurez-vous d\'avoir <strong>enregistré toutes les modifications</strong> des couleurs ci-dessous avant d\'appuyer sur ce bouton. Attention, cela pourrait changer la couleur de nombreux cours !';
$string['restorefailed'] = 'La restauration a échoué';
$string['restoreincorrectsections'] = 'Erreur : impossible de valider car le cours source contient des sections mal numérotées (par exemple, le numéro de section ({$a->sectionnum}) est supérieur au maximum autorisé ({$a->maxallowed}). Essayez d\'exclure ou de supprimer les sections avec des nombres élevés.';
$string['restoretoomanysections'] = 'Erreur : impossible de sauvegarder ou de restaurer car trop de sections de cours sont incluses ({$a->numsections}) et c\'est plus que le maximum autorisé ({$a->maxallowed}). Essayez d\'exclure ou de supprimer certaines sections.';
$string['revealcontents'] = 'Révéler le contenu des tuiles';
$string['scheduleddeleteemptysections'] = 'La tâche de suppression des sections vides du cours a été planifiée.  Veuillez réessayer plus tard.';
$string['section0name'] = 'Général';
$string['sectionerrorstring'] = 'Votre session a peut-être expiré. Essayez d\'actualiser cette page.';
$string['sectionerrortitle'] = 'Erreur au chargement du contenu';
$string['sectionname'] = 'Tuile';
$string['sectionnumber'] = 'Section / Numéro de tuile';
$string['selected'] = 'Sélectionné';
$string['setavailabletilecolours'] = 'Couleurs de tuiles autorisées (pour l\'ensemble du site)';
$string['settings'] = 'Paramètres du format Tuiles';
$string['show'] = 'Afficher';
$string['showalltiles'] = 'Afficher toutes les tuiles';
$string['showfromothers'] = 'Afficher la tuile';
$string['showoverallprogress'] = 'Afficher l\'indicateur de progression globale';
$string['showoverallprogress_desc'] = 'Afficher l\'indicateur « % de progression globale » en haut à droite du cours (la valeur affichée représente le total du % achevé de chaque tuile, en fonction de l\'achèvement de l\'activité et non de l\'achèvement du cours';
$string['showprogresssphototiles_desc'] = 'Si cette option est sélectionnée, la progression de l\'élève (par exemple, Progression 2/5) sera affichée sur les tuiles photo';
$string['showseczerocoursewide'] = 'Afficher la section 0 en haut de toutes les tuiles';
$string['showseczerocoursewide_desc'] = 'Si coché, la section zéro (la section du haut) sera affichée sur la page d\'accueil du cours et en haut de <b>chaque page de section du parcours </b> (c\'est-à-dire en haut du contenu de chaque tuile). Si la case n\'est pas cochée (recommandé), elle ne sera affichée que sur la page d\'atterrissage du parcours.';
$string['showseparatewin'] = 'Afficher le fichier dans une fenêtre séparée';
$string['sitename'] = 'Nom du site';
$string['snapwarning'] = 'Il peut être possible de modifier votre cours au format Tuiles en utilisant un autre thème, puis de revenir au thème Snap une fois que vous avez terminé l\'édition.';
$string['snapwarning_help'] = 'Theme_settings#Allow_user_themes';
$string['subtileszeczerotoggled'] = 'Section du haut alternant entre le format liste et sous tuiles';
$string['sureresetcolours'] = 'Voulez-vous vraiment réinitialiser les couleurs par défaut des tuiles de cours? Cela affectera {$a} cours';
$string['tilecolourgeneral'] = 'Palette de couleurs - couleur optionnelle';
$string['tilecolourgeneral_descr'] = 'Ce réglage permet à l\'administrateur de déterminer les couleurs disponibles pour les enseignants dans leurs cours. Pour désactiver une couleur, la régler sur noir (#000). Si vous modifiez les couleurs ici, aucune modification ne sera reportée dans les cours existants jusqu\'à ce que leur enseignant n\'essaie de changer la couleur d\'une tuile, auquel cas seules les couleurs définies ici lui seront proposées.';
$string['tilecolourschanged'] = 'Les couleurs des tuiles ont été réinitialisées. Toutes les tuiles ont maintenant des couleurs conformes aux couleurs ci-dessous.';
$string['tileicon'] = 'Icône à afficher sur cette tuile uniquement';
$string['tileicon_help'] = 'L\'élément sélectionné ici remplacera, pour cette tuile uniquement, l\'icône de tuile qui a été définie au niveau du cours.';
$string['tileicons'] = 'Icônes de tuile';
$string['tileoutcome'] = 'Résultat pour cette tuile';
$string['tileoutcome_help'] = 'Si vous sélectionnez un résultat pour cette tuile, vous pourrez alors, dans les paramètres du cours, afficher un ensemble de <em>boutons de filtrage</em>, un pour chaque résultat, qui, appuyé, affichera les tuiles en fonction du résultat qui leur a été attribué.';
$string['tileoutofsequence'] = 'Cette tuile a un numéro de section hors séquence. Veuillez supprimer complètement la vignette pour résoudre le problème (déplacez d\'abord tout contenu vers une autre tuile)';
$string['tileselecttip'] = 'Vous n\'avez pas besoin d\'utiliser ce formulaire pour changer une icône de tuile. Un moyen plus simple est, dans le cours en mode édition, de cliquer sur l\'icône que vous voulez changer.';
$string['tilesformatregistration'] = 'Enregistrement du format Tuiles';
$string['tilesoutofsequencewarning'] = 'Avertissement aux éditeurs : les tuiles suivantes comportent des erreurs. Veuillez supprimer une ou plusieurs de ces tuiles pour résoudre les problèmes :';
$string['tip'] = 'Astuce';
$string['togglecompletion'] = 'Cliquez pour basculer le statut d\'achèvement';
$string['tootall'] = 'Trop grand pour la tuile';
$string['toowide'] = 'Trop large pour la tuile';
$string['transparenttitleadjustments'] = 'Ajustements de transparence de titre';
$string['transparenttitleadjustments_desc'] = 'Sur les tuiles photo avec des arrière-plans de titre transparents, en fonction de votre thème, vous souhaiterez peut-être les ajuster pour vous assurer que les lignes transparentes du titre ne se chevauchent pas lorsqu\'elles sont enveloppées.
Notez que celles-ci varient également un peu selon les navigateurs. Valeurs suggérées pour Chrome: Thèmes basés sur Boost et Clean: 30,5 et 4 | Adaptable: 32 et 4 | Moove: 32 et 2 | Remui: 32 et 2,5';
$string['uploadnewphoto'] = 'Déposer une nouvelle photo';
$string['uploadnewphoto_help'] = 'Importez une image à utiliser sur cette tuile';
$string['usejavascriptnav'] = 'Utiliser la navigation JavaScript à partir de la page d\'accueil du format Tuiles';
$string['usejavascriptnav_desc'] = 'Une fois cochée, si l\'utilisateur clique sur une tuile sur la page d\'accueil du cours, avec javascript activé, JS sera utilisé pour passer au contenu de la tuile. Le contenu des tuiles sera stocké localement dans le navigateur selon les autres paramètres ci-dessous. Si cette case n\'est pas cochée, JS ne sera pas utilisé et la navigation existante sera utilisée à la place. Les autres paramètres JS ci-dessous seront ignorés.';
$string['usejseditingexpandcollapse'] = 'Mode d\'édition - utilisez JavaScript pour développer / réduire les tuiles';
$string['usejseditingexpandcollapse_desc'] = 'Si cette option est sélectionnée, en mode édition, un enseignant peut développer et réduire les tuiles d\'édition avec des transitions animées. Le contenu de la tuile sera chargé lors de l\'expansion, sans rechargement de page.';
$string['usejsnavforsinglesection'] = 'Utiliser la navigation JS pour une section par page';
$string['usejsnavforsinglesection_desc'] = 'Si cette case est cochée, tout appel pour une seule section par page (&section=xx) sera traité en utilisant JavaScript, en lançant la page principale du cours, animée pour s\'ouvrir à la section demandée via JS, plutôt que d\'appeler l\'ancienne page de section unique PHP.';
$string['usesubtilesseczero'] = 'Utiliser les sous-tuiles dans la section du haut';
$string['usesubtilesseczero_help'] = 'Si cette option est sélectionnée, les sous-tuiles seront utilisées dans la partie supérieure, mais aussi dans toutes les tuiles. Parce que les sous-tuiles prennent beaucoup de place tout en haut du parcours, il peut être préférable de ne pas sélectionner cette option, de sorte que tous les éléments de la section supérieure soient affichés sous forme de liste standard à la place.';
$string['usetooltips'] = 'Utiliser les info-bulles JavaScript';
$string['usetooltips_desc'] = 'Utiliser les info-bulles JavaScript lorsque l\'utilisateur survole certains éléments, par exemple les coches d\'achèvement, les tuiles pour le contenu des titres';
$string['width'] = 'largeur';
