<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'hu', version '3.8'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Aktuális feladatai vannak';
$string['addattempt'] = 'Újabb próbálkozás engedélyezése';
$string['addnewattempt'] = 'Új próbálkozás hozzáadása';
$string['addnewattempt_help'] = 'Új üres leadást szúr be munkálkodáshoz';
$string['addnewattemptfromprevious'] = 'Új próbálkozás hozzáadása az előző leadás alapján';
$string['addnewattemptfromprevious_help'] = 'Az előző leadás tartalmát átmásolja új leadáson való munkálkodáshoz';
$string['addnewgroupoverride'] = 'Csoportos felülírás hozzáadása';
$string['addnewuseroverride'] = 'Felhasználói felülírás hozzáadása';
$string['addsubmission'] = 'Leadott munka hozzáadása';
$string['addsubmission_help'] = 'Még nem adott le munkát.';
$string['allocatedmarker'] = 'Hozzárendelt értékelő';
$string['allocatedmarker_help'] = 'A leadott munkához rendelt értékelő';
$string['allowsubmissions'] = 'Felhasználó számára további leadás engedélyezése az adott feladat esetén';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'A feladat részletei és a leadási űrlap <strong>{$a}</strong> időponttól lesznek elérhetők.';
$string['allowsubmissionsfromdate'] = 'Leadások engedélyezése ekkortól';
$string['allowsubmissionsfromdate_help'] = 'Bekapcsolása esetén a tanulók ezen időpont előtt nem adhatnak le munkát. Ellenkező esetben azonnal beküldhetnek munkákat.';
$string['allowsubmissionsfromdatesummary'] = 'A feladathoz <strong>{$a}</strong> időponttól lehet leadni munkát.';
$string['allowsubmissionsshort'] = 'Leadott munka módosításának engedélyezése';
$string['alwaysshowdescription'] = 'A leírás mindig jelenjen meg.';
$string['alwaysshowdescription_help'] = 'Kikapcsolása esetén a fenti feladatleírás a tanulók számára csak a \'Leadások engedélyezése ekkortól\' alatt megadott időponttól lesz látható.';
$string['applytoteam'] = 'Osztályzatok és visszajelzés az egész csoportra kiterjesztve';
$string['assign:addinstance'] = 'Új feladat hozzáadása';
$string['assign:editothersubmission'] = 'Másik tanuló leadott munkájának szerkesztése';
$string['assign:exportownsubmission'] = 'Saját leadás exportálása';
$string['assign:grade'] = 'Feladat pontozása';
$string['assign:grantextension'] = 'Meghosszabbítás';
$string['assign:manageallocations'] = 'A leadott munkához rendelt értékelők kezelése';
$string['assign:managegrades'] = 'Osztályzatok ellenőrzése és közzététele';
$string['assign:manageoverrides'] = 'Hozzárendelési felülírások kezelése';
$string['assign:receivegradernotifications'] = 'Osztályozói leadásokról szóló értesítések fogadása';
$string['assign:releasegrades'] = 'Osztályzatok közzététele';
$string['assign:revealidentities'] = 'Tanuló kilétének felfedése';
$string['assign:reviewgrades'] = 'Osztályzatok ellenőrzése';
$string['assign:showhiddengrader'] = 'Rejtett osztályozó kilétének megtekintése';
$string['assign:submit'] = 'Feladat leadása';
$string['assign:view'] = 'Feladat megtekintése';
$string['assign:viewblinddetails'] = 'Tanulók kilétének megtekintése vakon osztályozás bekapcsolása esetén';
$string['assign:viewgrades'] = 'Pontok kijelzése';
$string['assignfeedback'] = 'Visszajelzés segédprogramja';
$string['assignfeedbackpluginname'] = 'Visszajelzés segédprogramja';
$string['assignmentisdue'] = 'A feladat teljesítendő';
$string['assignmentmail'] = '{$a->grader} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára, melyet a leadott munkához mellékelve talál meg: {$a->url}.';
$string['assignmentmailhtml'] = '{$a->grader} visszajelzést küldött a(z) \'<i>{$a->assignment}</i>\'<br /><br />  feladathoz leadott munkájára, melyet a <a href="{$a->url}">leadott munkához</a> mellékelve talál meg.';
$string['assignmentmailsmall'] = '{$a->grader} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára, melyet a leadott munkához mellékelve talál meg.';
$string['assignmentname'] = 'Feladat neve';
$string['assignmentplugins'] = 'Feladat segédprogramjai';
$string['assignmentsperpage'] = 'Oldalankénti feladatszám';
$string['assignsubmission'] = 'Leadási segédprogram';
$string['assignsubmissionpluginname'] = 'Leadási segédprogram';
$string['attemptheading'] = '{$a->attemptnumber}. próbálkozás: {$a->submissionsummary}';
$string['attempthistory'] = 'Előző próbálkozások';
$string['attemptnumber'] = 'Próbálkozás száma';
$string['attemptreopenmethod'] = 'Újból megnyitott próbálkozások';
$string['attemptreopenmethod_help'] = 'Meghatározza a leadási próbálkozások újbóli megnyitásának mikéntjét. Lehetőségek: <ul><li>Soha - A leadott munkát nem lehet újból megnyitni.</li><li>Kézileg - A leadott munkát egy tanár újból megnyithatja.</li><li>Automatikusan a teljesítésig - A leadott munka mindaddig automatikusan megnyílik, amíg a tanuló a feladathoz az osztályozónaplóban beállított teljesítési értéket el nem éri.</li></ul>';
$string['attemptreopenmethod_manual'] = 'Kézileg';
$string['attemptreopenmethod_none'] = 'Soha';
$string['attemptreopenmethod_untilpass'] = 'Automatikusan a teljesítésig';
$string['attemptsettings'] = 'Próbálkozás beállításai';
$string['availability'] = 'Elérhetőség';
$string['backtoassignment'] = 'Vissza a feladathoz';
$string['batchoperationconfirmaddattempt'] = 'Új próbálkozás engedélyezése a kijelölt leadások esetén?';
$string['batchoperationconfirmdownloadselected'] = 'Letölti a kijelölt leadott munkákat?';
$string['batchoperationconfirmgrantextension'] = 'Meghosszabbítás minden kiválasztott leadott munka esetén?';
$string['batchoperationconfirmlock'] = 'Zárolja az összes kiválasztott leadott munkát?';
$string['batchoperationconfirmremovesubmission'] = 'Törli a kiválasztott leadott munkákat?';
$string['batchoperationconfirmreverttodraft'] = 'A kiválasztott leadott munkákat visszaállítja piszkozattá?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Minden kiválasztott leadott munkához legyen értékelő hozzárendelve?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Minden kiválasztott leadott munkához legyen értékelési folyamat állapota beállítva?';
$string['batchoperationconfirmunlock'] = 'Feloldja az összes kiválasztott leadott munkát?';
$string['batchoperationlock'] = 'leadott munkák zárolása';
$string['batchoperationreverttodraft'] = 'leadott munkák visszaállítása piszkozattá?';
$string['batchoperationsdescription'] = 'A kiválasztottal...';
$string['batchoperationunlock'] = 'leadott munkák feloldása';
$string['batchsetallocatedmarker'] = 'Hozzárendelt értékelő beállítása {$a} kiválasztott felhasználóhoz';
$string['batchsetmarkingworkflowstateforusers'] = 'Értékelési folyamat állapotának  beállítása {$a} kiválasztott felhasználóhoz';
$string['blindmarking'] = 'Értékelés vakon';
$string['blindmarking_help'] = 'Vakon értékelés esetén az értékelők elől rejtve marad a tanulók kiléte. Ha a feladattal kapcsolatos leadott munka vagy osztályozás elkészül, a vakon értékelés beállításai nem módosíthatók.';
$string['blindmarkingenabledwarning'] = 'A tevékenységhez vak értékelés bekapcsolva';
$string['calendardue'] = '{$a} esedékes';
$string['calendargradingdue'] = '{$a} osztályozása esedékes';
$string['changefilters'] = 'Szűrőcsere';
$string['changeuser'] = 'Felhasználócsere';
$string['choosegradingaction'] = 'Osztályozási lépés';
$string['choosemarker'] = 'Választ';
$string['chooseoperation'] = 'Művelet kiválasztása';
$string['clickexpandreviewpanel'] = 'Kattintson az ellenőrző panel megnöveléséhez';
$string['collapsegradepanel'] = 'Osztályzatok paneljének becsukása';
$string['collapsereviewpanel'] = 'Ellenőrzés paneljének becsukása';
$string['comment'] = 'Megjegyzés';
$string['completionsubmit'] = 'Befejezéshez a tanulónak munkát kell leadnia.';
$string['configshowrecentsubmissions'] = 'A tevékenységekről szóló utóbbi jelentésekben bárki megtekintheti a leadott munkákkal kapcsolatos értesítéseket.';
$string['confirmbatchgradingoperation'] = 'Biztosan végrehajt {$a->operation} műveletet {$a->count} tanuló esetén?';
$string['confirmsubmission'] = 'Biztosan leadja munkáját osztályozásra? További módosításokra nem lesz lehetősége.';
$string['confirmsubmissionheading'] = 'Leadás megerősítése';
$string['conversionexception'] = 'A feladat átalakítása nem sikerült. A kivétel oka: {$a}.';
$string['couldnotconvertgrade'] = 'A feladatra adott osztályzat átalakítása {$a} felhasználó esetén nem sikerült.';
$string['couldnotconvertsubmission'] = 'A feladathoz leadott munka átalakítása {$a} felhasználó esetén nem sikerült.';
$string['couldnotcreatecoursemodule'] = 'A kurzusmodul létrehozása  nem sikerült.';
$string['couldnotcreatenewassignmentinstance'] = 'Az új feladatpéldány létrehozása  nem sikerült.';
$string['couldnotfindassignmenttoupgrade'] = 'Nincs meg a frissítendő régi feladat.';
$string['crontask'] = 'A hozzárendelési modul háttérben futó feldolgozása';
$string['currentassigngrade'] = 'Aktuális osztályzat a feladatban';
$string['currentattempt'] = 'Ez a(z)  {$a}. próbálkozás';
$string['currentattemptof'] = 'Ez a lehetséges {$a->maxattempts}  közül a(z) {$a->attemptnumber}.  próbálkozás';
$string['currentgrade'] = 'Aktuális osztályzat az osztályozónaplóban';
$string['cutoffdate'] = 'Lezárás időpontja';
$string['cutoffdate_help'] = 'Beállítása esetén a feladathoz meghosszabbítás hiányában nem adhatók le munkák ezen időpontot követően.';
$string['cutoffdatecolon'] = 'Lezárás időpontja:  {$a}';
$string['cutoffdatefromdatevalidation'] = 'A Lezárás időpontja nem lehet korábban, mint a leadások engedélyezésének kezdő időpontja';
$string['cutoffdatevalidation'] = 'A lezárás időpontja nem lehet korábbi, mint a leadási határidő.';
$string['defaultlayout'] = 'Alapelrendezés visszaállítása';
$string['defaultsettings'] = 'Feladat alapbeállításai';
$string['defaultsettings_help'] = 'Ezek a beállítások lesznek érvényesek az összes új feladat esetén.';
$string['defaultteam'] = 'Alapcsoport';
$string['deleteallsubmissions'] = 'Az összes leadott munka törlése';
$string['description'] = 'Leírás';
$string['disabled'] = 'Kikapcsolva';
$string['downloadall'] = 'Az összes leadott munka letöltése';
$string['downloadasfolders'] = 'Leadott munkák letöltése mappákban';
$string['downloadasfolders_help'] = 'A feladathoz kapcsolódó leadott munkák letölthetők mappákban. Minden leadott munka külön mappába kerül, a mappaszerkezet és az állománynevek nem változnak.';
$string['downloadselectedsubmissions'] = 'A kijelölt leadott munkák letöltése';
$string['duedate'] = 'Határidő';
$string['duedate_help'] = 'A feladat teljesítése ekkor esedékes. Ezen időpont után is adhatók le munkák, de ezek késedelmes megjelölést kapnak. A leadás adott időpont utáni megakadályozásához állítson be végső időpontot.';
$string['duedatecolon'] = 'Leadás időpontja:  {$a}';
$string['duedateno'] = 'Nincs határidő';
$string['duedatereached'] = 'A feladat teljesítésének határideje lejárt.';
$string['duedatevalidation'] = 'A leadási határidő nem lehet korábbi, mint a leadások engedélyezésének a kezdete.';
$string['duplicateoverride'] = 'Ismétlődő felülírás';
$string['editaction'] = 'Lépések...';
$string['editattemptfeedback'] = '{$a}. számú próbálkozáshoz tartozó osztályzat és visszajelzés szerkesztése';
$string['editingpreviousfeedbackwarning'] = 'Egy korábbi próbálkozáshoz tartozó visszajelzést szerkeszt. Ez a(z) {$a->totalattempts} próbálkozás közül a(z) {$a->attemptnumber}.';
$string['editingstatus'] = 'Szerkesztés állapota';
$string['editonline'] = 'Online szerkesztés';
$string['editoverride'] = 'Felülírás szerkesztése';
$string['editsubmission'] = 'Leadott munkám szerkesztése';
$string['editsubmission_help'] = 'Leadott munkáját még módosíthatja';
$string['editsubmissionother'] = '{$a} leadott munkájának szerkesztése';
$string['enabled'] = 'Bekapcsolva';
$string['errornosubmissions'] = 'Nincs letölthető leadott munka';
$string['errorquickgradingvsadvancedgrading'] = 'Az osztályzatok mentésére nem került sor, mert a feladathoz részletes osztályozás kapcsolódik.';
$string['errorrecordmodified'] = 'Az osztályzatok mentésére nem került sor, mert valaki egy vagy több rekordot az oldal feltöltése után módosított.';
$string['eventallsubmissionsdownloaded'] = 'Minden leadott munka letöltése folyamatban';
$string['eventassessablesubmitted'] = 'Leadtak egy munkát.';
$string['eventbatchsetmarkerallocationviewed'] = 'Ömlesztett jelzőkiosztás megtekintve';
$string['eventbatchsetworkflowstateviewed'] = 'Ömlesztett munkafolyamat állapota megtekintve';
$string['eventextensiongranted'] = 'Hosszabbítást kapott.';
$string['eventfeedbackupdated'] = 'Visszajelzés frissítve';
$string['eventfeedbackviewed'] = 'Visszajelzés megtekintve';
$string['eventgradingformviewed'] = 'Osztályozó űrlap megtekintve';
$string['eventgradingtableviewed'] = 'Osztályozó táblázat megtekintve';
$string['eventidentitiesrevealed'] = 'Azonosságok felfedve.';
$string['eventmarkerupdated'] = 'Kijelölt értékelő frissítve.';
$string['eventoverridecreated'] = 'Hozzárendelési felülírás létrehozva';
$string['eventoverridedeleted'] = 'Hozzárendelési felülírás törölve';
$string['eventoverrideupdated'] = 'Hozzárendelési felülírás frissítve';
$string['eventremovesubmissionformviewed'] = 'A leadott munka törlésének megerősítése megtekintve.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Azonosítást megerősítő oldal megtekintve';
$string['eventstatementaccepted'] = 'A felhasználó a leadott munka nyilatkozatát elfogadta.';
$string['eventsubmissionconfirmationformviewed'] = 'Leadást megerősítő űrlap megtekintve';
$string['eventsubmissioncreated'] = 'Leadott munka létrehozva';
$string['eventsubmissionduplicated'] = 'A felhasználó leadott munkájáról másolatot készített.';
$string['eventsubmissionformviewed'] = 'Leadási űrlap megtekintve';
$string['eventsubmissiongraded'] = 'A leadott munka osztályozása megtörtént.';
$string['eventsubmissionlocked'] = 'A leadott munkákat egy felhasználó számára zároltuk.';
$string['eventsubmissionstatusupdated'] = 'A leadott munka állapota frissítve.';
$string['eventsubmissionstatusviewed'] = 'Leadás állapota megtekintve';
$string['eventsubmissionunlocked'] = 'A leadott munkákat egy felhasználó számára feloldottuk.';
$string['eventsubmissionupdated'] = 'A felhasználó elmentett egy leadott munkát.';
$string['eventsubmissionviewed'] = 'Leadott munka megtekintve';
$string['eventworkflowstateupdated'] = 'A munkafolyamat állapota frissítve.';
$string['expandreviewpanel'] = 'Ellenőrzés paneljének megnövelése';
$string['extensionduedate'] = 'Meghosszabbítás lejárata';
$string['extensionnotafterduedate'] = 'A meghosszabbítás lejárata az esedékesség utáni időpont lehet';
$string['extensionnotafterfromdate'] = 'A meghosszabbítás lejárata nem lehet korábbi időpont, mint a leadások kezdeti időpontja';
$string['feedback'] = 'Visszajelzés';
$string['feedbackavailableanonhtml'] = 'Új visszajelzés érkezett \'<i>{$a->assignment}</i>\' leadott munkája kapcsán.<br /><br />
Megtekintheti a <a href="{$a->url}">leadott munkához</a> csatolva.';
$string['feedbackavailableanonsmall'] = 'Új visszajelzés a(z) {$a->assignment} munkához';
$string['feedbackavailableanontext'] = 'Új visszajelzés érkezett \'<i>{$a->assignment}</i>\' leadott munkája kapcsán.<br /><br /> Megtekintheti a leadott munkához csatolva:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} visszajelzést küldött a(z) \'<i>{$a->assignment}</i>\' feladathoz leadott munkájára.<br /><br /> Megtekintheti a(z) <a href="{$a->url}">leadott munka</a> mellett.';
$string['feedbackavailablesmall'] = '{$a->username} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz';
$string['feedbackavailabletext'] = '{$a->username} visszajelzést küldött a(z) \'{$a->assignment}\' feladathoz leadott munkájára.

Megtekintheti a leadott munka mellett: {$a->url}.';
$string['feedbackplugin'] = 'Visszajelzés segédprogramja';
$string['feedbackpluginforgradebook'] = 'Visszajelzés segédprogramja, mely megjegyzéseket továbbít az osztályozónaplóba';
$string['feedbackpluginforgradebook_help'] = 'Csak egy feladathoz kapcsolódó visszajelzést kezelő segédprogram küldhet visszajelzést az osztályozó naplóba.';
$string['feedbackplugins'] = 'Visszajelzés segédprogramjai';
$string['feedbacksettings'] = 'Visszajelzés beállításai';
$string['feedbacktypes'] = 'Visszajelzési típusok';
$string['filesubmissions'] = 'Állományok leadása';
$string['filter'] = 'Szűrő';
$string['filtergrantedextension'] = 'Garantált kiterjesztés';
$string['filternone'] = 'Nincs szűrő';
$string['filternotsubmitted'] = 'Nincs leadva';
$string['filterrequiregrading'] = 'Osztályozandó';
$string['filtersubmitted'] = 'Leadva';
$string['fixrescalednullgrades'] = 'A feladat hibás osztályzatokat tartalmaz, ezeket <a href="{$a->link}">automatikusan kijavíthatja</a>. Emiatt a kurzusösszesítés módosulhat.';
$string['fixrescalednullgradesconfirm'] = 'Biztosan javítja a hibás osztályzatokat? Minden érintett osztályzat törlődik. Emiatt a kurzusösszesítés módosulhat.';
$string['fixrescalednullgradesdone'] = 'Osztályzatok kijavítva.';
$string['gradeabovemaximum'] = 'Az osztályzat értéke legfeljebb {$a} lehet.';
$string['gradebelowzero'] = 'Az osztályzat értéke legalább nulla lehet.';
$string['gradecanbechanged'] = 'Az osztályozás módosítható';
$string['gradechangessaveddetail'] = 'Az osztályzat és a visszajelzés változásait a rendszer elmentette.';
$string['graded'] = 'Pontozott';
$string['gradedby'] = 'Osztályozta';
$string['gradedfollowupsubmit'] = 'Osztályozott - nyomon követő leadott munka átvéve';
$string['gradedon'] = 'Osztályozás időpontja';
$string['gradeitem:submissions'] = 'Leadott munkák';
$string['gradelocked'] = 'Ez az osztályzat zárolva van vagy felülírták az osztályozónaplóban';
$string['gradeoutof'] = '{$a} pontból';
$string['gradeoutofhelp'] = 'Osztályzat';
$string['gradeoutofhelp_help'] = 'A tanuló leadott munkájára adott osztályzatot itt adja meg. Használhat tizedeseket is.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} {$a->timeupdated}  időpontban frissítette a(z) <i>\'{$a->assignment}\'</i><br /><br /> feladathoz leadott munkáját.<br></br>Elérhető a(z) <a href="{$a->url}"> weboldalon</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} frissítette a(z) \'{$a->assignment}\' feladathoz leadott munkáját.';
$string['gradersubmissionupdatedtext'] = '{$a->username} {$a->timeupdated}  időpontban frissítette a(z) {$a->assignment}  feladathoz leadott munkáját. Itt érhető el: {$a->url}';
$string['gradestudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló osztályzata.';
$string['gradeuser'] = 'Osztályzat {$a}';
$string['grading'] = 'Osztályozás';
$string['gradingchangessaved'] = 'Az osztályzat módosításának a mentése megtörtént.';
$string['gradingduedate'] = 'Figyelmeztessen az értékelésre eddig:';
$string['gradingduedate_help'] = 'Az az időpont, amikorra a leadott munkák értékelését be kell fejezni. Ez az időpont a tanárok irányítópultos értesítésének a beállításában vesz részt.';
$string['gradingdueduedatevalidation'] = 'Az osztályozási emlékeztető határidejének dátuma nem lehet korábbi, mint az esedékesség dátuma.';
$string['gradingduefromdatevalidation'] = 'Az osztályozási emlékeztető határidejének dátuma nem lehet korábbi, mint a leadott munkák engedélyezésének kezdő dátuma.';
$string['gradingmethodpreview'] = 'Osztályozási kritériumok';
$string['gradingoptions'] = 'Lehetőségek';
$string['gradingstatus'] = 'Osztályozás állapota';
$string['gradingstudent'] = 'Tanuló osztályozása';
$string['gradingsummary'] = 'Osztályozási összesítő';
$string['grantextension'] = 'Meghosszabbítás';
$string['grantextensionforusers'] = 'Meghosszabbítás {$a} számára';
$string['groupoverrides'] = 'Csoportos felülírások';
$string['groupoverridesdeleted'] = 'Csoportos felülírások törölve';
$string['groupsnone'] = 'Nincs elérhető csoport.';
$string['groupsubmissionsettings'] = 'Csoportos leadás beállításai';
$string['hiddenuser'] = 'Résztvevő';
$string['hidegrader'] = 'Rejtett osztályozó kilétének elrejtése a tanulók elől';
$string['hidegrader_help'] = 'Bekapcsolása esetén elrejti a leadott munkát osztályozó kilétét, így a tanulók nem látják, ki osztályozta a munkájukat.

A beállításnak nincs hatása az osztályozási oldalon lévő megjegyzések négyzetére.';
$string['hideshow'] = 'Elrejt/Mutat';
$string['inactiveoverridehelp'] = '* A tanuló csoportja vagy szerepe hibás a feladattal próbálkozáshoz';
$string['indicator:cognitivedepth'] = 'Kognitív feladat';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által a feladat során elért kognitív mélységen alapul.';
$string['indicator:cognitivedepthdef'] = 'Kognitív feladat';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő a feladathoz kapcsolódó tevékenységek között szereplő kognitív elfoglaltság ezen százalékát érte el az elemzési időszak alatt  (Szintek = Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése, Visszajelzéshez kapcsolódó megjegyzés, Visszajelzés megtekintése utáni újbóli leadás)';
$string['indicator:socialbreadth'] = 'Társas feladat';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által a feladat során elért társas látókörön alapul.';
$string['indicator:socialbreadthdef'] = 'Társas feladat';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő a feladathoz kapcsolódó tevékenységek között szereplő társas elfoglaltság ezen százalékát érte el az elemzési időszak alatt (Szintek = Nincs részvétel, Egyedüli részvétel, Másokkal közös részvétel)';
$string['instructionfiles'] = 'Utasítások';
$string['introattachments'] = 'Kiegészítő állományok';
$string['introattachments_help'] = 'Kiegészítő állományokat, pl. válaszsablonokat adhat hozzá a feladatban való használatra. Letöltési hivatkozásaik a feladat oldalán a leírás alatt jelennek meg.';
$string['invalidfloatforgrade'] = 'Az adott osztályzat nem világos: {$a}';
$string['invalidgradeforscale'] = 'Az adott osztályzat nem érvényes erre a tartományra.';
$string['invalidoverrideid'] = 'Érvénytelen felülírás-azonosító';
$string['lastmodifiedgrade'] = 'Utolsó módosítás (osztályzat)';
$string['lastmodifiedsubmission'] = 'Utolsó módosítás (leadott munka)';
$string['latesubmissions'] = 'Későn leadott munkák';
$string['latesubmissionsaccepted'] = 'Csak {$a} időpontig engedélyezett';
$string['loading'] = 'Töltés...';
$string['locksubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló részéről további leadások megakadályozása';
$string['locksubmissions'] = 'Leadások zárolása';
$string['manageassignfeedbackplugins'] = 'Feladatra adott visszajelzések segédprogramjainak kezelése';
$string['manageassignsubmissionplugins'] = 'Feladathoz leadott munkák segédprogramjainak kezelése';
$string['marker'] = 'Értékelő';
$string['markerfilter'] = 'Értékelők szűrője';
$string['markerfilternomarker'] = 'Nincs jelölő';
$string['markingallocation'] = 'Értékelő-hozzárendelés használata';
$string['markingallocation_help'] = 'Bekapcsolása esetén értékelőket rendelhet az egyes tanulókhoz - ehhez az értékelési folyamatot engedélyezni kell';
$string['markingworkflow'] = 'Értékelési folyamat használata';
$string['markingworkflow_help'] = 'Bekapcsolása esetén a jegyek közzététel előtt több folyamaton mennek keresztül. Így a több értékelési kör révén a jegyeket minden tanuló egyszerre kaphatja meg.';
$string['markingworkflowstate'] = 'Értékelési folyamat állapota';
$string['markingworkflowstate_help'] = 'A választható folyamatállapotokat a feladathoz rendelt jogosultságai határozzák meg:

* Nincs értékelve - az értékelő még nem látott hozzá
* Értékelés alatt - az értékelő már  hozzálátott, de még nem készült el vele
* Értékelés kész - az értékelő már  befejezte, de még ránézhet
* Ellenőrzés alatt - az értékelés a minőség ellenőrzéséért felelős tanárhoz került
* Közzétételre kész - a tanár elégedett az értékeléssel, de még vár a közzététellel
* Közzétéve - az osztályzat/visszajelzés a tanuló rendelkezésére áll';
$string['markingworkflowstateinmarking'] = 'Értékelés alatt';
$string['markingworkflowstateinreview'] = 'Ellenőrzés alatt';
$string['markingworkflowstatenotmarked'] = 'Nincs értékelve';
$string['markingworkflowstatereadyforrelease'] = 'Közzétételre kész';
$string['markingworkflowstatereadyforreview'] = 'Az értékelés véget ért.';
$string['markingworkflowstatereleased'] = 'Közzétéve';
$string['maxattempts'] = 'Max. próbálkozás';
$string['maxattempts_help'] = 'A tanuló általi leadási próbálkozások maximális száma. Ezt követően a leadott munkát nem lehet újból megnyitni.';
$string['maxgrade'] = 'Maximális osztályzat';
$string['maxperpage'] = 'Maximális feladat oldalanként';
$string['maxperpage_help'] = 'Maximális feladat oldalanként, melyet az osztályozó a feladatosztályozó lapon megjeleníthet. Hasznos időkiesés elkerülésére sok beiratkozottal rendelkező kurzusok esetén.';
$string['messageprovider:assign_notification'] = 'Feladattal kapcsolatos értesítések';
$string['modulename'] = 'Feladat';
$string['modulename_help'] = 'A Feladat tevékenységmodul révén a tanár a tanulók előmenetelét ellenőrizheti elvégzendő munkák kijelölése, értékelése, osztályozása és visszajelzés küldése révén.

A tanuló bármilyen digitális tartalmat (állományt) leadhat (dokumentumot, számolótáblát, képet, hangállományt és videoklipet), online tölthet ki feladatokat. A feladat használható az elkészítendő munkára való figyelmeztetés eszközeként is.

Ellenőrzés során a tanár visszajelzést küldhet a fenti formátumokban, tetszése szerinti skálán leosztályozhatja a leadott munkát, a végleges osztályzat pedig bekerül az osztályozónaplóba.';
$string['modulenameplural'] = 'Feladatok';
$string['moreusers'] = 'további {$a} ...';
$string['multipleteams'] = 'Több csoportnak is tagja';
$string['multipleteams_desc'] = 'A feladat csoportos leadott munkát ír elő. Ön egynél több csoport tagja. Leadáshoz csak egy csoportnak lehet a tagja. Csoporttagságának módosításáért forduljon tanárához.';
$string['multipleteamsgrader'] = 'Több csoportnak is tagja, így nem adhat le munkát.';
$string['mysubmission'] = 'Leadott munkám:';
$string['newsubmissions'] = 'Feladatok leadva';
$string['noattempt'] = 'Nincs próbálkozás';
$string['noclose'] = 'Nincs lezárási időpont';
$string['nofiles'] = 'Nincs állomány.';
$string['nofilters'] = 'Nincs szűrő';
$string['nograde'] = 'Nincs osztályzat.';
$string['nolatesubmissions'] = 'Kései leadásra nincs mód.';
$string['nomoresubmissionsaccepted'] = 'Csak a halasztást kapók számára engedélyezett';
$string['none'] = 'Egy sem';
$string['noonlinesubmissions'] = 'Ehhez a feladathoz semmit nem kell neten keresztül leadnia.';
$string['noopen'] = 'Nincs nyitási időpont';
$string['nooverridedata'] = 'Legalább egy feladatbeállítást fölül kell írnia.';
$string['nosavebutnext'] = 'Következő';
$string['nosubmission'] = 'A feladathoz nem érkezett leadott munka.';
$string['nosubmissionsacceptedafter'] = 'Ezt követően leadásra nincs mód';
$string['noteam'] = 'Ön egyik csoportnak sem tagja';
$string['noteam_desc'] = 'A feladat csoportos leadott munkát ír elő. Ön nem tagja egy csoportnak sem, így nem hozhat létre leadott munkát. Csoport felvételéért forduljon tanárához.';
$string['noteamgrader'] = 'Ön egyik csoportnak sem tagja, így nem adhat le munkát.';
$string['notgraded'] = 'Nincs osztályozva';
$string['notgradedyet'] = 'Még nincs pontozva';
$string['notifications'] = 'Értesítések';
$string['notsubmittedyet'] = 'Még nincs leadva';
$string['nousers'] = 'Nincs felhasználó';
$string['nousersselected'] = 'Nincs kiválasztva felhasználó';
$string['numberofdraftsubmissions'] = 'Piszkozatok';
$string['numberofparticipants'] = 'Résztvevők';
$string['numberofsubmissionsneedgrading'] = 'Osztályozandó';
$string['numberofsubmittedassignments'] = 'Leadva';
$string['numberofteams'] = 'Csoportok';
$string['offline'] = 'Nincs szükség neten keresztüli leadásra';
$string['open'] = 'Nyitva';
$string['outlinegrade'] = 'Osztályzat: {$a}';
$string['outof'] = '{$a->current} / {$a->total}';
$string['overdue'] = '<font color="red">A feladat lejárt: {$a}</font>';
$string['override'] = 'Felülírás';
$string['overridedeletegroupsure'] = 'Biztosan törli a(z) {$a} csoport felülírását?';
$string['overridedeleteusersure'] = 'Biztosan törli a(z) {$a} felhasználó felülírását?';
$string['overridegroup'] = 'Csoport felülírása';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Felülírások';
$string['overrideuser'] = 'Felhasználó felülírása';
$string['overrideusereventname'] = '{$a->assign} - felülírás';
$string['page-mod-assign-view'] = 'Feladatmodul fő és leadási oldala';
$string['page-mod-assign-x'] = 'Feladatmodul tetszőleges oldala';
$string['paramtimeremaining'] = '{$a} van hátra';
$string['participant'] = 'Résztvevő';
$string['pluginadministration'] = 'Feladat kezelése';
$string['pluginname'] = 'Feladat';
$string['preventsubmissionnotingroup'] = 'Csoport számára leadás előírása';
$string['preventsubmissionnotingroup_help'] = 'Bekapcsolása esetén csak csoporttagok adhatnak le munkát.';
$string['preventsubmissions'] = 'Tanuló számára a feladathoz további munkák leadásának megakadályozása';
$string['preventsubmissionsshort'] = 'Leadott munkák módosításának megakadályozása';
$string['previous'] = 'Előző';
$string['privacy:attemptpath'] = '{$a}. próbálkozás';
$string['privacy:blindmarkingidentifier'] = 'Vak osztályozáshoz használt azonosító';
$string['privacy:gradepath'] = 'osztályzat';
$string['privacy:metadata:assigndownloadasfolders'] = 'Felhasználói beállítás több leadott munka mappákba való letöltése esetén';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Feladathoz kapcsolódó visszajelzés adatai.';
$string['privacy:metadata:assignfilter'] = 'Szűrési lehetőségek, mint pl. \'Leadva\', \'Nincs leadva\', \'Osztályozandó\' és \'Halasztott\'';
$string['privacy:metadata:assigngrades'] = 'A feladat felhasználói osztályzatait tárolja';
$string['privacy:metadata:assignmarkerfilter'] = 'Hozzárendelési összegzés szűrése a hozzárendelt osztályozó alapján.';
$string['privacy:metadata:assignmentid'] = 'Feladat azonosítója';
$string['privacy:metadata:assignmessageexplanation'] = 'Az üzeneteket az üzenetküldő rendszer továbbítja a tanulókhoz.';
$string['privacy:metadata:assignoverrides'] = 'A feladathoz kapcsolódó felülírás adatait tárolja';
$string['privacy:metadata:assignperpage'] = 'Oldalanként megjelenítendő feladatok száma.';
$string['privacy:metadata:assignquickgrading'] = 'Gyors osztályozás használatának beállítása.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Felhasználói leadott munka adatait tárolja';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Feladathoz kapcsolódó leadott munka adatai.';
$string['privacy:metadata:assignuserflags'] = 'Felhasználói metaadatokat, pl. meghosszabbítás időpontjait tárolja';
$string['privacy:metadata:assignusermapping'] = 'Vak osztályozáshoz használt társítás';
$string['privacy:metadata:assignworkflowfilter'] = 'Különféle munkafolyamatok szerinti szűrés.';
$string['privacy:metadata:grade'] = 'Feladat leadott munkájának számjegyes osztályzata. Megadható skálával/részletes osztályzattal stb., de mindig visszaalakul lebegőpontos számmá.';
$string['privacy:metadata:grader'] = 'Az osztályozó személy felhasználói azonosítója.';
$string['privacy:metadata:groupid'] = 'Azon csoport azonosítója, amelynek a felhasználói a tagja.';
$string['privacy:metadata:latest'] = 'Nagyban egyszerűsíti a kizárólag az utolsó próbálkozásra vonatkozó lekérdezéseket.';
$string['privacy:metadata:mailed'] = 'A felhasználói levél sorra került már?';
$string['privacy:metadata:timecreated'] = 'Létrehozás időpontja';
$string['privacy:metadata:userid'] = 'A felhasználó azonosítója';
$string['privacy:studentpath'] = 'studentsubmissions';
$string['privacy:submissionpath'] = 'leadott munka';
$string['quickgrading'] = 'Gyors osztályozás';
$string['quickgrading_help'] = 'Gyors osztályozás esetén az osztályzatokat (és eredményeket) közvetlenül a leadott munka táblázatában rögzítheti. Gyors osztályozás nem alkalmazható részletes osztályozással együtt, használata több értékelő esetén nem ajánlott.';
$string['quickgradingchangessaved'] = 'Az osztályozás változásainak mentése megtörtént.';
$string['quickgradingresult'] = 'Gyors osztályozás';
$string['recordid'] = 'Azonosító';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} idővel a kurzus kezdete után';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} idővel a kurzus kezdete előtt';
$string['relativedatessubmissiontimeleft'] = 'Minden egyes tanulóra kiszámítva';
$string['removeallgroupoverrides'] = 'Minden csoportfelülírás törlése';
$string['removealluseroverrides'] = 'Minden felhasználói felülírás törlése';
$string['removesubmission'] = 'A leadott munka törlése';
$string['removesubmissionconfirm'] = 'Biztosan törli a leadott adatokat?';
$string['removesubmissionconfirmforstudent'] = 'Biztosan törli {$a} tanuló leadott adatait?';
$string['removesubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló leadott munkájának törlése.';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Nyissa meg újra, amíg a teljesítési feltétel nem egyezik a vakon értékeléssel, mert az osztályzatok csak akkor kerülnek a naplóba, amikor a tanulók kilétére fény derül.';
$string['requireallteammemberssubmit'] = 'Minden csoporttag adjon le munkát';
$string['requireallteammemberssubmit_help'] = 'Bekapcsolása esetén minden csoporttagnak kattintania kell a Leadás gombra. Kikapcsolt állapotban a csoportszintű leadás bármely csoporttag Leadás gombra való kattintásával megtörténik.';
$string['requiresubmissionstatement'] = 'A leadási nyilatkozat tanulók általi elfogadásának előírása';
$string['requiresubmissionstatement_help'] = 'A leadási nyilatkozat tanulók általi elfogadásának előírása a feladat minden leadott munkájához.';
$string['revealidentities'] = 'Tanuló kilétének felfedése';
$string['revealidentitiesconfirm'] = 'Biztosan felfedi a tanulók kilétét ennél a feladatnál? A művelet nem érvényteleníthető, a jegyek pedig bekerülnek az osztályozónaplóba!';
$string['reverttodefaults'] = 'Visszatérés a hozzárendelési alapértékekhez';
$string['reverttodraft'] = 'Leadott munka visszaállítása piszkozattá';
$string['reverttodraftforstudent'] = 'Leadott munka visszaállítása piszkozattá (id={$a->id}, fullname={$a->fullname}) tanuló számára.';
$string['reverttodraftshort'] = 'Leadott munka visszaállítása piszkozattá';
$string['reviewed'] = 'Ellenőrizve';
$string['save'] = 'Mentés';
$string['saveallquickgradingchanges'] = 'Az összes gyorspontozási változás mentése';
$string['saveandcontinue'] = 'Mentés és folytatás';
$string['savechanges'] = 'Módosítások mentése';
$string['savegradingresult'] = 'Osztályzat';
$string['savenext'] = 'Mentés és a következő megjelenítése';
$string['saveoverrideandstay'] = 'Mentés és áttérés egy másik felülíráshoz';
$string['savingchanges'] = 'Módosítások mentése...';
$string['scale'] = 'Skála';
$string['search:activity'] = 'Feladathoz kapcsolódó tevékenységek';
$string['selectedusers'] = 'Kiválasztott felhasználók';
$string['selectlink'] = 'Választás';
$string['selectuser'] = 'Választás: {$a}';
$string['sendlatenotifications'] = 'Értékelők értesítése kései leadásokról';
$string['sendlatenotifications_help'] = 'Bekapcsolása esetén az osztályozók (rendszerint a tanárok) értesítést kapnak, ha egy tanuló későn adta le a feladatát. Az üzenetküldés módja beállítható.';
$string['sendnotifications'] = 'Értesítések küldése az osztályozásban közreműködőknek';
$string['sendnotifications_help'] = 'Bekapcsolása esetén az osztályozásban közreműködők (általában a tanárok) üzenetet kapnak, ha a tanuló (korán, időben vagy megkésve) ad le egy munkát. Az üzenetküldő módszereket testre szabhatja.';
$string['sendstudentnotifications'] = 'Tanulók értesítése';
$string['sendstudentnotifications_help'] = 'Bekapcsolása esetén a tanulók a frissített osztályzatról vagy visszajelzésről üzenetet kapnak. Ha a feladat során az osztályozási folyamat be van kapcsolva, értesítések küldésére csak az osztályzat véglegessé válásakor kerül sor.';
$string['sendstudentnotificationsdefault'] = 'A "Tanulók értesítése" alapbeállítása';
$string['sendstudentnotificationsdefault_help'] = 'Az osztályozó űrlapon állítsa be a "Tanulók értesítése" jelölőnégyzet alapértékét.';
$string['sendsubmissionreceipts'] = 'Leadott munkáról elismervény küldése a tanulóknak';
$string['sendsubmissionreceipts_help'] = 'Ezzel kapcsolja be a leadott munkáról szóló elismervény küldését a tanulóknak, akik minden sikeres leadást követően kapnak róla egy értesítést.';
$string['setmarkerallocationforlog'] = 'Értékelő hozzárendelése: (id={$a->id}, név={$a->fullname}, értékelő={$a->marker}).';
$string['setmarkingallocation'] = 'Hozzárendelt értékelő beállítása';
$string['setmarkingworkflowstate'] = 'Értékelési folyamat állapotának beállítása';
$string['setmarkingworkflowstateforlog'] = 'Értékelési folyamat állapotának beállítása : (id={$a->id}, név={$a->fullname}, állapot={$a->state}).';
$string['settings'] = 'Feladat beállításai';
$string['showrecentsubmissions'] = 'Legutóbbi leadott munkák megjelenítése';
$string['status'] = 'Állapot';
$string['studentnotificationworkflowstateerror'] = 'A tanulók értesítéséhez a munkamenetet \'Szabad\' állapottal kell megjelölni.';
$string['submission'] = 'Leadott munka';
$string['submissioncopiedhtml'] = 'Másolatot készített \'<i>{$a->assignment}</i>\' leadott munkájáról.<br /><br /> <a href="{$a->url}">Leadott munkájának</a> állapotát megtekintheti.';
$string['submissioncopiedsmall'] = 'Másolatot készített előző {$a->assignment} leadott munkájából.';
$string['submissioncopiedtext'] = 'Másolatot készített előző \'{$a->assignment}\' leadott munkájából.

Leadott munkájának állapotát megtekintheti: {$a->url}.';
$string['submissiondrafts'] = 'Tanulók számára a Leadás gombra kattintás előírása';
$string['submissiondrafts_help'] = 'Bekapcsolása esetén a tanulóknak  a Leadás gombra kattintva kell jelezni, hogy végeztek a leadandó munkával. Így a leadott munka piszkozatát megőrizhetik a rendszerben. Ha a beállítás a munkák leadása után "Nem"-ről "Igen"-re változik, a leadott munkákat a rendszert véglegesnek tekinti.';
$string['submissioneditable'] = 'A tanuló a leadandót szerkesztheti.';
$string['submissionempty'] = 'Nem volt leadás';
$string['submissionlog'] = 'Tanuló: {$a->fullname}, állapot: {$a->status}';
$string['submissionmodified'] = 'Leadott adatai vannak. Lépjen ki az oldalról és próbálja meg újra.';
$string['submissionmodifiedgroup'] = 'A leadott munkát másvalaki módosította. Lépjen ki az oldalról és próbálja meg újra.';
$string['submissionnotcopiedinvalidstatus'] = 'Leadott munkájáról nem készült másolat, mert újbóli megnyitása után szerkesztésre került sor.';
$string['submissionnoteditable'] = 'A tanuló a leadandót nem szerkesztheti.';
$string['submissionnotready'] = 'A feladathoz leadandó munka még nincs kész.';
$string['submissionplugins'] = 'Leadás segédprogramjai';
$string['submissionreceipthtml'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.<br /><br /> Állapotát megtekintheti a <a href="{$a->url}">leadott munka</a> alatt.';
$string['submissionreceiptotherhtml'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.<br /><br />
 Állapotát megtekintheti a <a href="{$a->url}">leadott munka</a> alatt.';
$string['submissionreceiptothersmall'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.';
$string['submissionreceiptothertext'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.

 Állapotát megtekintheti itt:
{$a->url}';
$string['submissionreceipts'] = 'Leadási értesítő küldése';
$string['submissionreceiptsmall'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.';
$string['submissionreceipttext'] = 'A(z) \'<i>{$a->assignment}</i>\' feladathoz megoldást adott le.

Állapotát megtekintheti itt: {$a->url}';
$string['submissionsclosed'] = 'Leadás lezárva';
$string['submissionsettings'] = 'Leadás beállításai';
$string['submissionslocked'] = 'A feladathoz nem lehet munkát leadni.';
$string['submissionslockedshort'] = 'A leadott munka nem módosítható.';
$string['submissionsnotgraded'] = 'Osztályozatlan leadott munkák: {$a}';
$string['submissionstatement'] = 'Leadási nyilatkozat';
$string['submissionstatement_help'] = 'A feladat leadásához minden tanuló által megerősítendő nyilatkozat.';
$string['submissionstatementacceptedlog'] = 'A leadási nyilatkozatot {$a} elfogadta.';
$string['submissionstatementdefault'] = 'A leadott munka saját munkám, kivéve azokat a részeket, ahol elismerem mások munkájának a felhasználását.';
$string['submissionstatementteamsubmission'] = 'Csoportos leadási nyilatkozat';
$string['submissionstatementteamsubmission_help'] = 'Csoportként való feladatleadáshoz minden tanuló által megerősítendő nyilatkozat.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Csoportos leadási nyilatkozat minden csoporttag feladatleadása esetén';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Csoporttagként való feladatleadáshoz minden tanuló által megerősítendő nyilatkozat.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'A leadott munka csoporttagként leadott munkám, kivéve azokat a részeket, ahol elismerem mások munkájának a felhasználását.';
$string['submissionstatementteamsubmissiondefault'] = 'A leadott munka a csoportom munkája, kivéve azokat a részeket, ahol elismerjük mások munkájának a felhasználását.';
$string['submissionstatus'] = 'Leadás állapota';
$string['submissionstatus_'] = 'Nincs leadott munka';
$string['submissionstatus_draft'] = 'Piszkozat (nincs leadva)';
$string['submissionstatus_marked'] = 'Osztályozott';
$string['submissionstatus_new'] = 'Nincs leadott munka';
$string['submissionstatus_reopened'] = 'Újból megnyitva';
$string['submissionstatus_submitted'] = 'Osztályozásra leadva';
$string['submissionstatusheading'] = 'Leadás állapota';
$string['submissionsummary'] = '{$a->status}. Utolsó módosítás időpontja {$a->timemodified}';
$string['submissionteam'] = 'Csoport';
$string['submissiontypes'] = 'Leadási típusok';
$string['submitaction'] = 'Leadás';
$string['submitassignment'] = 'Feladat leadása';
$string['submitassignment_help'] = 'A feladat leadás után nem módosítható.';
$string['submitforgrading'] = 'Leadás osztályozásra';
$string['submitted'] = 'Leadva';
$string['submittedearly'] = 'Feladat {$a} idővel korábban leadva';
$string['submittedlate'] = 'Feladat {$a} idővel később leadva';
$string['submittedlateshort'] = '{$a} kései';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Visszajelzés segédprogramja';
$string['subplugintype_assignfeedback_plural'] = 'Visszajelzés segédprogramjai';
$string['subplugintype_assignsubmission'] = 'Leadás segédprogramja';
$string['subplugintype_assignsubmission_plural'] = 'Leadás segédprogramja';
$string['teamname'] = 'Csoport: {$a}';
$string['teamsubmission'] = 'Csoportos leadás';
$string['teamsubmission_help'] = 'Bekapcsolása esetén a tanulók alapbeállítás vagy egyedi csoportosítás szerinti csoportokba kerülnek. A csoportos leadást a csoporttagok készítik el, akik látják egymás módosításait.';
$string['teamsubmissiongroupingid'] = 'Csoportosítás';
$string['teamsubmissiongroupingid_help'] = 'A feladat ezt a csoportosítást veszi figyelembe. Ha nincs beállítva, az alapkészletet használja.';
$string['textinstructions'] = 'Feladat utasításai';
$string['timemodified'] = 'Utolsó módosítás';
$string['timeremaining'] = 'Hátralévő idő';
$string['timeremainingcolon'] = 'Hátralévő idő: {$a}';
$string['togglezoom'] = 'Terület nagyítása';
$string['ungroupedusers'] = 'A \'Csoport számára leadás előírása\' be van kapcsolva, de egyes felhasználók nincsenek csoporthoz - vagy több csoporthoz vannak - hozzárendelve, így nem adhatnak le munkát.';
$string['ungroupedusersoptional'] = 'Be van kapcsolva a csoportos tanulói leadás, egyes felhasználók azonban vagy nem csoporttagok, vagy egynél több csoport tagjai. Ezek a tanulók az Alapcsoport tagjaiként fogják leadni munkájukat!';
$string['unlimitedattempts'] = 'Korlátlan';
$string['unlimitedattemptsallowed'] = 'Korlátlan számú próbálkozás lehetséges';
$string['unlimitedpages'] = 'Korlátlan';
$string['unlocksubmissionforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló részére leadások engedélyezése.';
$string['unlocksubmissions'] = 'Leadások feloldása';
$string['unsavedchanges'] = 'Nem mentett módosítások';
$string['unsavedchangesquestion'] = 'Az osztályzat és a visszajelzés nem mentett módosításokat tartalmaz. Biztosan menti ezeket, majd folytatja?';
$string['updategrade'] = 'Osztályzat frissítése';
$string['updatetable'] = 'Táblázat mentése és frissítése';
$string['upgradenotimplemented'] = '({$a->type} {$a->subtype}) segédprogram esetén a verziófrissítés nem történt meg.';
$string['userassignmentdefaults'] = 'Felhasználói feladat alapadatai';
$string['userextensiondate'] = 'Halasztás engedélyezve eddig: {$a}';
$string['usergrade'] = 'Felhasználói osztályzat';
$string['useridlistnotcached'] = 'Az osztályzat módosításának a mentése NEM történt meg, mivel nem lehetett megállapítani, kinek a leadott munkájáról van szó.';
$string['useroverrides'] = 'Felhasználói felülírások';
$string['useroverridesdeleted'] = 'Felhasználói felülírások törölve';
$string['usersnone'] = 'A hozzárendeléshez egy tanuló sem fér hozzá.';
$string['usersubmissioncannotberemoved'] = '{$a} leadott munkája nem távolítható el.';
$string['userswhoneedtosubmit'] = 'Leadásra kötelezett tanulók: {$a}';
$string['validmarkingworkflowstates'] = 'Értékelési folyamat érvényes állapotai';
$string['viewadifferentattempt'] = 'Másik próbálkozás megtekintése';
$string['viewbatchmarkingallocation'] = 'Értékelők ömlesztett hozzárendelésének megtekintése';
$string['viewbatchsetmarkingworkflowstate'] = 'Értékelési folyamatállapot ömlesztett megtekintése';
$string['viewfeedback'] = 'Visszajelzés megtekintése';
$string['viewfeedbackforuser'] = '{$a} felhasználó visszajelzésének megtekintése';
$string['viewfull'] = 'Teljes megtekintés';
$string['viewfullgradingpage'] = 'Visszajelzéshez nyissa meg a teljes osztályozó oldalt.';
$string['viewgradebook'] = 'Osztályozónapló megtekintése';
$string['viewgrading'] = 'Minden leadott munka megtekintése';
$string['viewgradingformforstudent'] = '(id={$a->id}, fullname={$a->fullname}) tanuló osztályozó oldalának a megtekintése.';
$string['viewownsubmissionform'] = 'Saját feladatleadó oldal megtekintése';
$string['viewownsubmissionstatus'] = 'Saját leadott munka állapotát mutató oldal megtekintése';
$string['viewrevealidentitiesconfirm'] = 'Tanulók kilétének felfedését megerősítő oldal megtekintése';
$string['viewsubmission'] = 'Leadott munka megtekintése';
$string['viewsubmissionforuser'] = '{$a} leadott munkájának megtekintése';
$string['viewsubmissiongradingtable'] = 'Leadott munka osztályozó táblázatának megtekintése';
$string['viewsummary'] = 'Összegzés megtekintése';
$string['workflowfilter'] = 'Folyamatszűrő';
$string['xofy'] = '{$a->y} / {$a->x}';
