<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'es', version '3.8'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Dirección';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Insertar/editar ancla';
$string['advanced:backcolor_desc'] = 'Seleccionar color de fondo';
$string['advanced:block'] = 'Formato';
$string['advanced:blockquote'] = 'Cita';
$string['advanced:blockquote_desc'] = 'Cita';
$string['advanced:bold_desc'] = 'Negrita (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Insertar/eliminar lista con viñetas';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Insertar caracteres Insertar caracteres especiales';
$string['advanced:cleanup_desc'] = 'Limpiar código basura';
$string['advanced:clipboard_msg'] = 'Copiar/Cortar/Pegar no se encuentran disponibles en Mozilla y Firefox. ¿Desea obtener más información acerca de este tema?';
$string['advanced:code'] = 'Código';
$string['advanced:code_desc'] = 'Editar código HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copiar';
$string['advanced:custom1_desc'] = 'Su descripción personal aquí';
$string['advanced:cut_desc'] = 'Cortar';
$string['advanced:dd'] = 'Descripción de definición';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Término de definición';
$string['advanced:font_size'] = 'Tamaño';
$string['advanced:fontdefault'] = 'Fuente';
$string['advanced:forecolor_desc'] = 'Seleccionar color del texto';
$string['advanced:h1'] = 'Encabezado 1';
$string['advanced:h2'] = 'Encabezado 2';
$string['advanced:h3'] = 'Encabezado 3';
$string['advanced:h4'] = 'Encabezado 4';
$string['advanced:h5'] = 'Encabezado 5';
$string['advanced:h6'] = 'Encabezado 6';
$string['advanced:help_desc'] = 'Ayuda';
$string['advanced:help_shortcut'] = 'Pulse ALT-F10 para la barra de herramientas. Pulse ALT-0 para ayuda';
$string['advanced:hr_desc'] = 'Insertar línea horizontal';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Insertar/editar imagen';
$string['advanced:image_props_desc'] = 'Propiedades de imagen';
$string['advanced:indent_desc'] = 'Aumentar sangría';
$string['advanced:italic_desc'] = 'Cursiva (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Alinear al centro';
$string['advanced:justifyfull_desc'] = 'Justificar';
$string['advanced:justifyleft_desc'] = 'Alinear a la izquierda';
$string['advanced:justifyright_desc'] = 'Alinear a la derecha';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Insertar/editar hipervínculo';
$string['advanced:more_colors'] = 'Más colores..';
$string['advanced:newdocument'] = '¿Está seguro que desea limpiar todo el contenido?';
$string['advanced:newdocument_desc'] = 'Nuevo documento';
$string['advanced:numlist_desc'] = 'Insertar/eliminar lista numerada';
$string['advanced:outdent_desc'] = 'Reducir sangría';
$string['advanced:paragraph'] = 'Párrafo';
$string['advanced:paste_desc'] = 'Pegar';
$string['advanced:path'] = 'Ruta';
$string['advanced:pre'] = 'Preformateado';
$string['advanced:redo_desc'] = 'Rehacer (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Limpiar formato';
$string['advanced:rich_text_area'] = 'Área de texto enriquecido';
$string['advanced:samp'] = 'Ejemplo de código';
$string['advanced:shortcuts_desc'] = 'Ayuda de accesibilidad';
$string['advanced:striketrough_desc'] = 'Tachado';
$string['advanced:style_select'] = 'Estilos';
$string['advanced:sub_desc'] = 'Subíndice';
$string['advanced:sup_desc'] = 'Superíndice';
$string['advanced:toolbar'] = 'Barra de herramientas';
$string['advanced:toolbar_focus'] = 'Ir a los botones de herramientas - Alt+Q, ir al editor - Alt-Z, ir a la ruta del elemento - Alt-X';
$string['advanced:underline_desc'] = 'Subrayado (Ctrl+U)';
$string['advanced:undo_desc'] = 'Deshacer (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Quitar hipervínculo';
$string['advanced:visualaid_desc'] = 'Mostrar/ocultar líneas/elementos invisibles';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'Acerca de';
$string['advanced_dlg:about_help'] = 'Ayuda';
$string['advanced_dlg:about_license'] = 'Licencia';
$string['advanced_dlg:about_loaded'] = 'Complementos cargados';
$string['advanced_dlg:about_plugin'] = 'Complemento';
$string['advanced_dlg:about_plugins'] = 'Complementos';
$string['advanced_dlg:about_title'] = 'Acerca de TinyMCE';
$string['advanced_dlg:about_version'] = 'Versión';
$string['advanced_dlg:accessibility_help'] = 'Ayuda para accesibilidad';
$string['advanced_dlg:accessibility_usage_title'] = 'Uso general';
$string['advanced_dlg:anchor_invalid'] = 'Por favo,r especifique un nombre de ancla válido';
$string['advanced_dlg:anchor_name'] = 'Nombre del ancla';
$string['advanced_dlg:anchor_title'] = 'Insertar/editar ancla';
$string['advanced_dlg:charmap_title'] = 'Seleccionar carácter especial';
$string['advanced_dlg:charmap_usage'] = 'Usa las flechas de izquierda y derecha para navegar.';
$string['advanced_dlg:code_title'] = 'Editor de código fuente HTML';
$string['advanced_dlg:code_wordwrap'] = 'Ajustar al margen';
$string['advanced_dlg:colorpicker_color'] = 'Color:';
$string['advanced_dlg:colorpicker_name'] = 'Nombre:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Nombrados';
$string['advanced_dlg:colorpicker_named_title'] = 'Colores nombrados';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta de colores';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Selector';
$string['advanced_dlg:colorpicker_picker_title'] = 'Paleta de color';
$string['advanced_dlg:colorpicker_title'] = 'Seleccionar color';
$string['advanced_dlg:image_align'] = 'Alineación';
$string['advanced_dlg:image_align_baseline'] = 'Línea base';
$string['advanced_dlg:image_align_bottom'] = 'Debajo';
$string['advanced_dlg:image_align_left'] = 'Izquierda';
$string['advanced_dlg:image_align_middle'] = 'Medio';
$string['advanced_dlg:image_align_right'] = 'Derecha';
$string['advanced_dlg:image_align_textbottom'] = 'Texto debajo';
$string['advanced_dlg:image_align_texttop'] = 'Texto arriba';
$string['advanced_dlg:image_align_top'] = 'Arriba';
$string['advanced_dlg:image_alt'] = 'Descripción de la Imagen';
$string['advanced_dlg:image_border'] = 'Borde';
$string['advanced_dlg:image_dimensions'] = 'Dimensión';
$string['advanced_dlg:image_hspace'] = 'Espacio horizontal';
$string['advanced_dlg:image_list'] = 'Lista de la Imagen';
$string['advanced_dlg:image_src'] = 'URL de la Imagen';
$string['advanced_dlg:image_title'] = 'Insertar/editar imagen';
$string['advanced_dlg:image_vspace'] = 'Espacio vertical';
$string['advanced_dlg:invalid_color_value'] = 'Valor de color no válido';
$string['advanced_dlg:link_is_email'] = 'La URL que introdujo parece ser una dirección de email. ¿Desea agregar el prefijo necesario mailto: ?';
$string['advanced_dlg:link_is_external'] = 'La URL que introdujo parece ser un enlace externo. ¿Desea agregar el prefijo necesario http:// ?';
$string['advanced_dlg:link_list'] = 'Lista de hipervínculos';
$string['advanced_dlg:link_target'] = 'Destino';
$string['advanced_dlg:link_target_blank'] = 'Abrir vínculo en una ventana nueva';
$string['advanced_dlg:link_target_same'] = 'Abrir vínculo en la misma ventana';
$string['advanced_dlg:link_title'] = 'Insertar/editar hipervínculo';
$string['advanced_dlg:link_titlefield'] = 'Título';
$string['advanced_dlg:link_url'] = 'URL del hipervínculo';
$string['advhr:advhr_desc'] = 'Insertar línea horizontal';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Sin sombra';
$string['advhr_dlg:size'] = 'Alto';
$string['advhr_dlg:width'] = 'Ancho';
$string['advhr_dlg:widthunits'] = 'Unidades';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Insertar/editar imagen';
$string['advimage_dlg:align'] = 'Alineación';
$string['advimage_dlg:align_baseline'] = 'Línea base';
$string['advimage_dlg:align_bottom'] = 'Debajo';
$string['advimage_dlg:align_left'] = 'Izquierda';
$string['advimage_dlg:align_middle'] = 'Medio';
$string['advimage_dlg:align_right'] = 'Derecha';
$string['advimage_dlg:align_textbottom'] = 'Texto abajo';
$string['advimage_dlg:align_texttop'] = 'Texto arriba';
$string['advimage_dlg:align_top'] = 'Arriba';
$string['advimage_dlg:alt'] = 'Descripción de la imagen';
$string['advimage_dlg:alt_image'] = 'Imagen alternativa';
$string['advimage_dlg:border'] = 'Bordes';
$string['advimage_dlg:classes'] = 'Clases';
$string['advimage_dlg:constrain_proportions'] = 'Bloquear relación de aspecto';
$string['advimage_dlg:dialog_title'] = 'Insertar/editar imagen';
$string['advimage_dlg:dimensions'] = 'Dimensiones';
$string['advimage_dlg:example_img'] = 'Vista previa de la imagen';
$string['advimage_dlg:general'] = 'General';
$string['advimage_dlg:height'] = 'Alto';
$string['advimage_dlg:hspace'] = 'Espacio horizontal';
$string['advimage_dlg:id'] = 'Identificación';
$string['advimage_dlg:image_list'] = 'Lista de imagen';
$string['advimage_dlg:langcode'] = 'Código del idioma';
$string['advimage_dlg:langdir'] = 'Dirección del idioma';
$string['advimage_dlg:list'] = 'Lista de imagen';
$string['advimage_dlg:long_desc'] = 'Vínculo para descripción larga';
$string['advimage_dlg:ltr'] = 'Izquierda a derecha';
$string['advimage_dlg:map'] = 'Mapa de imagen';
$string['advimage_dlg:misc'] = 'Misceláneo';
$string['advimage_dlg:missing_alt'] = '¿Esta seguro de continuar sin introducir una descripción de la imagen? Sin ella, la imagen puede no ser accesible para usuarios con discapacidades, o para aquellos que usen navegadores de modo texto, o tengan deshabilitadas las imágenes de la página.';
$string['advimage_dlg:mouseout'] = 'para mouseout';
$string['advimage_dlg:mouseover'] = 'para mouseover';
$string['advimage_dlg:preview'] = 'Vista previa';
$string['advimage_dlg:rtl'] = 'Derecha a izquierda';
$string['advimage_dlg:src'] = 'URL de la imagen';
$string['advimage_dlg:style'] = 'Estilos';
$string['advimage_dlg:swap_image'] = 'Intercambiar imagen';
$string['advimage_dlg:tab_advanced'] = 'Avanzado';
$string['advimage_dlg:tab_appearance'] = 'Apariencia';
$string['advimage_dlg:tab_general'] = 'General';
$string['advimage_dlg:title'] = 'Título';
$string['advimage_dlg:vspace'] = 'Espacio vertical';
$string['advimage_dlg:width'] = 'Ancho';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Insertar/editar hipervínculo';
$string['advlink_dlg:accesskey'] = 'Tecla de acceso';
$string['advlink_dlg:advanced_props'] = 'Propiedades avanzadas';
$string['advlink_dlg:advanced_tab'] = 'Avanzado';
$string['advlink_dlg:anchor_names'] = 'Anclas';
$string['advlink_dlg:classes'] = 'Clases';
$string['advlink_dlg:encoding'] = 'Codificación de caracteres del Target';
$string['advlink_dlg:event_props'] = 'Eventos';
$string['advlink_dlg:events_tab'] = 'Eventos';
$string['advlink_dlg:general_props'] = 'Propiedades generales';
$string['advlink_dlg:general_tab'] = 'General';
$string['advlink_dlg:height'] = 'Alto';
$string['advlink_dlg:id'] = 'Identificación';
$string['advlink_dlg:is_email'] = 'La URL que ha introducido parece ser una dirección de correo,  ¿desea agregar el prefijo mailto: necesario?';
$string['advlink_dlg:is_external'] = 'La URL que ha introducido parece ser un vínculo externo,  ¿Desea agregar el prefijo http:// necesario?';
$string['advlink_dlg:langcode'] = 'Código del idioma';
$string['advlink_dlg:langdir'] = 'Dirección del idioma';
$string['advlink_dlg:link_list'] = 'Lista de vínculo';
$string['advlink_dlg:list'] = 'Lista de vínculos';
$string['advlink_dlg:ltr'] = 'Izquierda a derecha';
$string['advlink_dlg:mime'] = 'Tipo MIME del Target';
$string['advlink_dlg:popup'] = 'Ventana emergente Javascript';
$string['advlink_dlg:popup_dependent'] = 'Dependientes (sólo Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Barra de localización';
$string['advlink_dlg:popup_menubar'] = 'Barra de menú';
$string['advlink_dlg:popup_name'] = 'Nombre de la ventana';
$string['advlink_dlg:popup_opts'] = 'Opciones';
$string['advlink_dlg:popup_position'] = 'Posición (X/Y)';
$string['advlink_dlg:popup_props'] = 'Propiedades de ventanas emergentes';
$string['advlink_dlg:popup_resizable'] = 'Permitir cambiar el tamaño de la ventana';
$string['advlink_dlg:popup_return'] = 'Insertar \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Barras de desplazamiento';
$string['advlink_dlg:popup_size'] = 'Tamaño';
$string['advlink_dlg:popup_statusbar'] = 'Barra de estado';
$string['advlink_dlg:popup_tab'] = 'Ventana emergente';
$string['advlink_dlg:popup_toolbar'] = 'Barra de herramientas';
$string['advlink_dlg:popup_url'] = 'URL de la ventana emergente';
$string['advlink_dlg:rel'] = 'Relación página a target';
$string['advlink_dlg:rev'] = 'Relación target a página';
$string['advlink_dlg:rtl'] = 'Derecha a izquierda';
$string['advlink_dlg:style'] = 'Estilo';
$string['advlink_dlg:tabindex'] = 'Índice de tabulación';
$string['advlink_dlg:target'] = 'Destino';
$string['advlink_dlg:target_blank'] = 'Abrir en ventana nueva';
$string['advlink_dlg:target_langcode'] = 'Lenguaje del Target';
$string['advlink_dlg:target_name'] = 'Nombre del Target';
$string['advlink_dlg:target_parent'] = 'Abrir en ventana padre/marco';
$string['advlink_dlg:target_same'] = 'Abrir en esta ventana/marco';
$string['advlink_dlg:target_top'] = 'Abrir en el marco superior (reemplaza todos los marcos)';
$string['advlink_dlg:title'] = 'Insertar/editar hipervínculo';
$string['advlink_dlg:titlefield'] = 'Título';
$string['advlink_dlg:url'] = 'URL del hipervínculo';
$string['advlink_dlg:width'] = 'Ancho';
$string['advlist:circle'] = 'Círculo';
$string['advlist:def'] = 'Por defecto';
$string['advlist:disc'] = 'Disco';
$string['advlist:lower_alpha'] = 'Alfa minúscula';
$string['advlist:lower_greek'] = 'Letra griega minúscula';
$string['advlist:lower_roman'] = 'Letra latina minúscula';
$string['advlist:square'] = 'Cuadrado';
$string['advlist:types'] = 'Tipos';
$string['advlist:upper_alpha'] = 'Alfa mayúscula';
$string['advlist:upper_roman'] = 'Letra latina mayúscula';
$string['aria:rich_text_area'] = 'Área de texto enriquecido';
$string['autosave:restore_content'] = 'Restaurar el contenido guardado automáticamente.';
$string['autosave:unload_msg'] = 'Los cambios realizados se perderán si sale de esta página.';
$string['autosave:warning_message'] = 'Si restaura el contenido guardado, perderá todo el contenido que se encuentra actualmente en el editor.

¿Está seguro de que desea restaurar el contenido guardado?';
$string['availablebuttons'] = 'Botones disponibles';
$string['colors:000000'] = 'Negro';
$string['colors:000080'] = 'Azul marino';
$string['colors:0000FF'] = 'Azul';
$string['colors:003300'] = 'Verde oscuro';
$string['colors:003366'] = 'Azul oscuro';
$string['colors:008000'] = 'Verde';
$string['colors:008080'] = 'Verde azulado';
$string['colors:00CCFF'] = 'Celeste';
$string['colors:00FF00'] = 'Lima';
$string['colors:00FFFF'] = 'Agua';
$string['colors:333300'] = 'Oliva oscuro';
$string['colors:333333'] = 'Gris oscuro';
$string['colors:333399'] = 'Añil';
$string['colors:3366FF'] = 'Azul real';
$string['colors:339966'] = 'Verde mar';
$string['colors:33CCCC'] = 'Turquesa';
$string['colors:666699'] = 'Azul grisáceo';
$string['colors:800000'] = 'Granate';
$string['colors:800080'] = 'Púrpura';
$string['colors:808000'] = 'Oliva';
$string['colors:808080'] = 'Gris';
$string['colors:993300'] = 'Naranja quemado';
$string['colors:993366'] = 'Marrón';
$string['colors:999999'] = 'Gris medio';
$string['colors:99CC00'] = 'Amarillo verde';
$string['colors:99CCFF'] = 'Azul cielo';
$string['colors:C0C0C0'] = 'Plata';
$string['colors:CC99FF'] = 'Ciruela';
$string['colors:CCFFCC'] = 'Verde pálido';
$string['colors:CCFFFF'] = 'Cian pálido';
$string['colors:FF0000'] = 'Rojo';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Naranja';
$string['colors:FF9900'] = 'Ámbar';
$string['colors:FF99CC'] = 'Rosa';
$string['colors:FFCC00'] = 'Dorado';
$string['colors:FFCC99'] = 'Melocotón';
$string['colors:FFFF00'] = 'Amarillo';
$string['colors:FFFF99'] = 'Amarillo claro';
$string['colors:FFFFFF'] = 'Blanco';
$string['common:apply'] = 'Aplicar';
$string['common:browse'] = 'Examinar';
$string['common:cancel'] = 'Cancelar';
$string['common:class_name'] = 'Clase';
$string['common:clipboard_msg'] = 'Copiar/Cortar/Pegar no se encuentra disponible en Mozilla y Firefox. ¿Desea obtener más información acerca de este problema?';
$string['common:clipboard_no_support'] = 'Su navegador no soporta las funciones de cortapapeles, use los accesos por teclado.';
$string['common:close'] = 'Cerrar';
$string['common:edit_confirm'] = '¿Desea utilizar el modo WYSIWYG para esta caja de texto?';
$string['common:insert'] = 'Insertar';
$string['common:invalid_data'] = 'Error: Introdujo un valor no válido, están marcados en rojo.';
$string['common:invalid_data_min'] = '{#field} debe ser un número mayor a {#min}';
$string['common:invalid_data_number'] = '{#field} debe ser un número';
$string['common:invalid_data_size'] = '{#field} debe ser un número o porcentaje';
$string['common:more_colors'] = 'Más colores...';
$string['common:not_set'] = '-- Ninguno --';
$string['common:popup_blocked'] = 'Lo sentimos, su bloqueo de ventanas emergentes ha deshabilitado una ventana que provee funcionalidades a la aplicación. Necesita deshabilitar este bloqueo en este sitio para poder utilizar todas las funciones.';
$string['common:update'] = 'Actualizar';
$string['common:value'] = '(valor)';
$string['contextmenu:align'] = 'Alineación';
$string['contextmenu:center'] = 'Centrado';
$string['contextmenu:full'] = 'Justificado';
$string['contextmenu:left'] = 'Izquierda';
$string['contextmenu:right'] = 'Derecha';
$string['customconfig'] = 'Configuración personalizada';
$string['customconfig_desc'] = 'Configuración personalizada avanzada de TinyMCE en formato JSON, por ejemplo {"option1" : "value2", "option2" : "value2"}. Caulquier opción especificada aquí sobrescribe la configuraciones estándar y la de las extensiones.';
$string['customtoolbar'] = 'Barra de herramientas del editor';
$string['customtoolbar_desc'] = 'Cada línea contiene una lista, separada por comas, con los nombres de los botones; utilice "|" como separador de grupo, las líneas vacías se ignoran. Vea <a href="{$a}" target="_blank">{$a}</a> con la lista de botones TinyMCE por defecto. <br /> La primera línea siempre se muestra, mientras que la visibilidad de la segunda y tercera barra de herramientas  se puede alternar.';
$string['directionality:ltr_desc'] = 'Dirección izquierda a derecha';
$string['directionality:rtl_desc'] = 'Dirección derecha a izquierda';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emoticones';
$string['emotions_dlg:cool'] = 'Todo bien';
$string['emotions_dlg:cry'] = 'Llora';
$string['emotions_dlg:desc'] = 'Emoticones';
$string['emotions_dlg:embarassed'] = 'Vergüenza';
$string['emotions_dlg:foot_in_mouth'] = 'Pie en la boca';
$string['emotions_dlg:frown'] = 'Triste';
$string['emotions_dlg:innocent'] = 'Inocente';
$string['emotions_dlg:kiss'] = 'Beso';
$string['emotions_dlg:laughing'] = 'Risa';
$string['emotions_dlg:money_mouth'] = 'Dinero boca';
$string['emotions_dlg:sealed'] = 'Sellado';
$string['emotions_dlg:smile'] = 'Sonrisa';
$string['emotions_dlg:surprised'] = 'Sorprendido';
$string['emotions_dlg:title'] = 'Insertar emoticon';
$string['emotions_dlg:tongue_out'] = 'Lengua fuera';
$string['emotions_dlg:undecided'] = 'Indeciso';
$string['emotions_dlg:usage'] = 'Use flechas izquierda y derecha para navegar.';
$string['emotions_dlg:wink'] = 'Guiño';
$string['emotions_dlg:yell'] = 'Enfadado';
$string['fontselectlist'] = 'Lista de fuentes disponibles';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Propiedades del documento';
$string['fullpage_dlg:active_color'] = 'Color activo';
$string['fullpage_dlg:add'] = 'Agregar nuevo elemento';
$string['fullpage_dlg:add_base'] = 'Elemento Base';
$string['fullpage_dlg:add_comment'] = 'Nodo Comment';
$string['fullpage_dlg:add_link'] = 'Elemento Link';
$string['fullpage_dlg:add_meta'] = 'Elemento Meta';
$string['fullpage_dlg:add_script'] = 'Elemento Script';
$string['fullpage_dlg:add_style'] = 'Elemento Style';
$string['fullpage_dlg:add_title'] = 'Elemento Title';
$string['fullpage_dlg:advanced_props'] = 'Avanzado';
$string['fullpage_dlg:advanced_tab'] = 'Avanzado';
$string['fullpage_dlg:appearance_bgprops'] = 'Propiedades del fondo';
$string['fullpage_dlg:appearance_linkprops'] = 'Colores del vínculo';
$string['fullpage_dlg:appearance_marginprops'] = 'Márgenes';
$string['fullpage_dlg:appearance_style'] = 'Propiedades de hoja de estilos y estilo';
$string['fullpage_dlg:appearance_tab'] = 'Apariencia';
$string['fullpage_dlg:appearance_textprops'] = 'Propiedades de texto';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Elemento Base';
$string['fullpage_dlg:bgcolor'] = 'Color de fondo';
$string['fullpage_dlg:bgimage'] = 'Imagen de fondo';
$string['fullpage_dlg:bottom_margin'] = 'Margen inferior';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Comentario';
$string['fullpage_dlg:content'] = 'Contenido';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Tipo de doc.';
$string['fullpage_dlg:encoding'] = 'Codificación de caracteres';
$string['fullpage_dlg:font_face'] = 'Fuente';
$string['fullpage_dlg:font_size'] = 'Tamaño de fuente';
$string['fullpage_dlg:fontface'] = 'Fuente';
$string['fullpage_dlg:fontsize'] = 'Tamaño de fuente';
$string['fullpage_dlg:general_props'] = 'General';
$string['fullpage_dlg:head_elements'] = 'Elemento Head';
$string['fullpage_dlg:hover_color'] = 'Color ratón encima';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Información';
$string['fullpage_dlg:langcode'] = 'Código del idioma';
$string['fullpage_dlg:langdir'] = 'Dirección del idioma';
$string['fullpage_dlg:langprops'] = 'Idioma y codificación';
$string['fullpage_dlg:language'] = 'Idioma';
$string['fullpage_dlg:left_margin'] = 'Margen izquierdo';
$string['fullpage_dlg:link_color'] = 'Color de vínculo';
$string['fullpage_dlg:link_element'] = 'Elemento Link';
$string['fullpage_dlg:ltr'] = 'Izquierda a derecha';
$string['fullpage_dlg:media'] = 'Medio';
$string['fullpage_dlg:meta_description'] = 'Descripción';
$string['fullpage_dlg:meta_element'] = 'Elemento Meta';
$string['fullpage_dlg:meta_index_follow'] = 'Indexar y seguir los vínculos';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexar y no seguir los vínculos';
$string['fullpage_dlg:meta_keywords'] = 'Palabras clave';
$string['fullpage_dlg:meta_noindex_follow'] = 'No indexar pero seguir vínculos';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'No indexar y no seguir vínculos';
$string['fullpage_dlg:meta_props'] = 'Información Meta';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'General';
$string['fullpage_dlg:meta_title'] = 'Título';
$string['fullpage_dlg:movedown'] = 'Mover elemento seleccionado hacia abajo';
$string['fullpage_dlg:moveup'] = 'Mover elemento seleccionado hacia arriba';
$string['fullpage_dlg:name'] = 'Nombre';
$string['fullpage_dlg:properties'] = 'Propiedades';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Eliminar elemento seleccionado';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Margen derecho';
$string['fullpage_dlg:rtl'] = 'Derecha a izquierda';
$string['fullpage_dlg:script_element'] = 'Elemento Script';
$string['fullpage_dlg:src'] = 'Src';
$string['fullpage_dlg:style'] = 'Estilo';
$string['fullpage_dlg:style_element'] = 'Elemento Style';
$string['fullpage_dlg:stylesheet'] = 'Hoja de estilo';
$string['fullpage_dlg:target'] = 'Target';
$string['fullpage_dlg:text_color'] = 'Color del texto';
$string['fullpage_dlg:textcolor'] = 'Color';
$string['fullpage_dlg:title'] = 'Propiedades del documento';
$string['fullpage_dlg:title_element'] = 'Elemento Title';
$string['fullpage_dlg:top_margin'] = 'Margen superior';
$string['fullpage_dlg:type'] = 'Tipo';
$string['fullpage_dlg:value'] = 'Valor';
$string['fullpage_dlg:visited_color'] = 'Color visitado';
$string['fullpage_dlg:xml_pi'] = 'Declaración XML';
$string['fullscreen:desc'] = 'Cambiar a modo pantalla completa';
$string['iespell:download'] = 'No se detectó \'ieSpell\'.  ¿Desea instalarlo ahora?';
$string['iespell:iespell_desc'] = 'Corregir  ortografía';
$string['insertdatetime:date_fmt'] = '%d-%m-%Y';
$string['insertdatetime:day_long'] = 'Domingo,Lunes,Martes,Miércoles,Jueves,Viernes,Sábado,Domingo';
$string['insertdatetime:day_short'] = 'Dom,Lun,Mar,Mie,Jue,Vie,Sab,Dom';
$string['insertdatetime:insertdate_desc'] = 'Insertar fecha';
$string['insertdatetime:inserttime_desc'] = 'Insertar hora';
$string['insertdatetime:months_long'] = 'Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre';
$string['insertdatetime:months_short'] = 'Ene,Feb,Mar,Abr,May,Jun,Jul,Ago,Sep,Oct,Nov,Dic';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Cambiar a posición absoluta';
$string['layer:backward_desc'] = 'Retroceder';
$string['layer:content'] = 'Nueva capa...';
$string['layer:forward_desc'] = 'Avanzar';
$string['layer:insertlayer_desc'] = 'Insertar nueva capa';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Insertar/editar multimedia embebida';
$string['media:edit'] = 'Editar multimedia embebida';
$string['media_dlg:advanced'] = 'Avanzado';
$string['media_dlg:align'] = 'Alineación';
$string['media_dlg:align_bottom'] = 'Debajo';
$string['media_dlg:align_bottom_left'] = 'Debajo Izda.';
$string['media_dlg:align_bottom_right'] = 'Debajo Dcha.';
$string['media_dlg:align_center'] = 'Centrado';
$string['media_dlg:align_left'] = 'Izquierda';
$string['media_dlg:align_right'] = 'Derecha';
$string['media_dlg:align_top'] = 'Arriba';
$string['media_dlg:align_top_left'] = 'Arriba Izda.';
$string['media_dlg:align_top_right'] = 'Arriba Dcha.';
$string['media_dlg:altsource1'] = 'Orígen alternativo 1';
$string['media_dlg:altsource2'] = 'Orígen alternativo 2';
$string['media_dlg:audio'] = 'Audio HTML5';
$string['media_dlg:autogotourl'] = 'Ir a URL automát.';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Comienzo Automático';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'URL Base';
$string['media_dlg:bgcolor'] = 'Fondo';
$string['media_dlg:cache'] = 'Caché';
$string['media_dlg:captioningid'] = 'Captioning ID';
$string['media_dlg:center'] = 'Centrado';
$string['media_dlg:class_name'] = 'Clase';
$string['media_dlg:console'] = 'Consola';
$string['media_dlg:constrain_proportions'] = 'Bloquear relación de aspecto';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controles';
$string['media_dlg:correction'] = 'Sin correción';
$string['media_dlg:currentmarker'] = 'Marcador actual';
$string['media_dlg:currentposition'] = 'Posición actual';
$string['media_dlg:defaultframe'] = 'Frame predet.';
$string['media_dlg:embedded_audio_options'] = 'Opciones de audio incrustado';
$string['media_dlg:embeddedaudio'] = 'Audio incrustado';
$string['media_dlg:enabled'] = 'Habilitado';
$string['media_dlg:enablejavascript'] = 'Habilitar JavaScript';
$string['media_dlg:endtime'] = 'Fin';
$string['media_dlg:file'] = 'Archivo/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Opciones Flash';
$string['media_dlg:flashvars'] = 'Flash vars';
$string['media_dlg:fullscreen'] = 'Pantalla completa';
$string['media_dlg:general'] = 'General';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Space';
$string['media_dlg:html5_audio_options'] = 'Opciones de audio';
$string['media_dlg:html5_video_options'] = 'Opciones de video HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'iframe';
$string['media_dlg:imagestatus'] = 'Estado de imagen';
$string['media_dlg:invokeurls'] = 'Invocar URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Repetitivo';
$string['media_dlg:maintainaspect'] = 'Mantener aspecto';
$string['media_dlg:menu'] = 'Mostrar Menú';
$string['media_dlg:mute'] = 'Silenciar';
$string['media_dlg:name'] = 'Nombre';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Núm. repeticiones';
$string['media_dlg:play'] = 'Comienzo Automático';
$string['media_dlg:playcount'] = 'Cuantas reproducciones';
$string['media_dlg:playeveryframe'] = 'Reproducir todo los frames';
$string['media_dlg:poster'] = 'Póster';
$string['media_dlg:prefetch'] = 'Prebúsqueda';
$string['media_dlg:preload'] = 'Precargar';
$string['media_dlg:preload_auto'] = 'Lo decide el navegador del usuario';
$string['media_dlg:preload_metadata'] = 'Precargar metadatos de video';
$string['media_dlg:preload_none'] = 'No precargar';
$string['media_dlg:preview'] = 'Vista Previa';
$string['media_dlg:progress'] = 'Progreso';
$string['media_dlg:qt_options'] = 'Opciones de Quicktime';
$string['media_dlg:qt_stream_warn'] = 'Los recursos RTSP de Streaming deberían añadirse en el campo QT Src de la pestaña avanzada.
Además debería añadir una versión no Streaming en el campo Src.';
$string['media_dlg:qtsrc'] = 'Fuente QT';
$string['media_dlg:qtsrcchokespeed'] = 'Vel. de choque';
$string['media_dlg:quality'] = 'Calidad';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Ratio';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opciones de Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Scale';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Opciones Shockwave';
$string['media_dlg:shuffle'] = 'Orden al azar';
$string['media_dlg:size'] = 'Dimensiones';
$string['media_dlg:sound'] = 'Sonido';
$string['media_dlg:source'] = 'Orígen';
$string['media_dlg:starttime'] = 'Inicio';
$string['media_dlg:stretchtofit'] = 'Estirar para ajustar';
$string['media_dlg:swstretchhalign'] = 'Alin. H. Estiramiento';
$string['media_dlg:swstretchstyle'] = 'Estilo estiramiento';
$string['media_dlg:swstretchvalign'] = 'Alin. V. Estiramiento';
$string['media_dlg:target'] = 'Target';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'Insertar/editar multimedia embebida';
$string['media_dlg:type'] = 'Tipo';
$string['media_dlg:uimode'] = 'Modo UI';
$string['media_dlg:video'] = 'Video HTML5';
$string['media_dlg:volume'] = 'Volumen';
$string['media_dlg:vspace'] = 'V-Space';
$string['media_dlg:windowlessvideo'] = 'Video sin ventana';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Opciones de Windows Media Player';
$string['nonbreaking:nonbreaking_desc'] = 'Insertar caracter de espacio \'non-breaking\'';
$string['pagebreak:desc'] = 'Insertar fin de página para imprimir';
$string['paste:paste_text_desc'] = 'Pegar como texto plano';
$string['paste:paste_word_desc'] = 'Pegar desde Word';
$string['paste:plaintext_mode'] = '\'Pegar\' está ahora en modo de texto plano. Haga clic de nuevo para habilitar \'pegar\' en modo normal. Tras pegar algo, podrá volver a \'pegar\' en modo normal.';
$string['paste:plaintext_mode_stick'] = '\'Pegar\' está ahora en modo de texto simple. Haga clic de nuevo para habilitar \'Pegar\' en modo regular.';
$string['paste:selectall_desc'] = 'Seleccionar todo';
$string['paste_dlg:text_linebreaks'] = 'Keep linebreaks';
$string['paste_dlg:text_title'] = 'Use Ctrl+v en su teclado para pegar el texto en la ventana.';
$string['paste_dlg:word_title'] = 'Use Ctrl+v en su teclado para pegar el texto en la ventana.';
$string['pluginname'] = 'Editor TinyMCE HTML';
$string['preview:preview_desc'] = 'Vista previa';
$string['print:print_desc'] = 'Imprimir';
$string['save:cancel_desc'] = 'Cancelar todos los cambios';
$string['save:save_desc'] = 'Guardar';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Buscar/Reemplazar';
$string['searchreplace:search_desc'] = 'Buscar';
$string['searchreplace_dlg:allreplaced'] = 'Se ha reemplazado el texto.';
$string['searchreplace_dlg:direction'] = 'Dirección';
$string['searchreplace_dlg:down'] = 'Abajo';
$string['searchreplace_dlg:findnext'] = 'Buscar siguiente';
$string['searchreplace_dlg:findwhat'] = 'Qué buscar';
$string['searchreplace_dlg:mcase'] = 'Minús./Mayús.';
$string['searchreplace_dlg:notfound'] = 'La búsqueda ha finalizado. No se encontró el texto introducido.';
$string['searchreplace_dlg:replace'] = 'Reemplazar';
$string['searchreplace_dlg:replace_title'] = 'Buscar/Reemplazar';
$string['searchreplace_dlg:replaceall'] = 'Reemplazar todo';
$string['searchreplace_dlg:replacewith'] = 'Reemplazar por';
$string['searchreplace_dlg:search_title'] = 'Buscar';
$string['searchreplace_dlg:searchnext_desc'] = 'Buscar de nuevo';
$string['searchreplace_dlg:up'] = 'Arriba';
$string['settings'] = 'Ajustes generales';
$string['simple:bold_desc'] = 'Negrita (Ctrl+B)';
$string['simple:bullist_desc'] = 'Insertar/eliminar lista con viñetas';
$string['simple:cleanup_desc'] = 'Limpiar código basura';
$string['simple:italic_desc'] = 'Cursiva (Ctrl+I)';
$string['simple:numlist_desc'] = 'Insertar/eliminar lista numerada';
$string['simple:redo_desc'] = 'Rehacer (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Tachado';
$string['simple:underline_desc'] = 'Subrayado (Ctrl+U)';
$string['simple:undo_desc'] = 'Deshacer (Ctrl+Z)';
$string['spellchecker:desc'] = 'Cambiar corrector ortográfico';
$string['spellchecker:ignore_word'] = 'Ignorar';
$string['spellchecker:ignore_words'] = 'Ignorar todo';
$string['spellchecker:langs'] = 'Idiomas';
$string['spellchecker:learn_word'] = 'Aprender palabra';
$string['spellchecker:menu'] = 'Configuración del corrector ortográfico';
$string['spellchecker:no_mpell'] = 'No se encontraron errores.';
$string['spellchecker:no_sug'] = 'Sin sugerencias';
$string['spellchecker:sug'] = 'Sugerencias';
$string['spellchecker:wait'] = 'Espere...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Editar estilo CSS';
$string['style_dlg:apply'] = 'Aplicar';
$string['style_dlg:background'] = 'Fondo';
$string['style_dlg:background_attachment'] = 'Adjunto';
$string['style_dlg:background_color'] = 'Color de fondo';
$string['style_dlg:background_hpos'] = 'Posición horizontal';
$string['style_dlg:background_image'] = 'Imagen de fondo';
$string['style_dlg:background_repeat'] = 'Repetición';
$string['style_dlg:background_tab'] = 'Fondo';
$string['style_dlg:background_vpos'] = 'Posición vertical';
$string['style_dlg:block'] = 'Bloque';
$string['style_dlg:block_display'] = 'Display';
$string['style_dlg:block_letterspacing'] = 'Espacio entre letra';
$string['style_dlg:block_tab'] = 'Bloque';
$string['style_dlg:block_text_align'] = 'Alineación del texto';
$string['style_dlg:block_text_indent'] = 'Sangría';
$string['style_dlg:block_vertical_alignment'] = 'Alineación vertical';
$string['style_dlg:block_whitespace'] = 'Espacio en blanco';
$string['style_dlg:block_wordspacing'] = 'Espacio entre palabra';
$string['style_dlg:border'] = 'Borde';
$string['style_dlg:border_tab'] = 'Borde';
$string['style_dlg:bottom'] = 'Debajo';
$string['style_dlg:box'] = 'Caja';
$string['style_dlg:box_clear'] = 'Clear';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Alto';
$string['style_dlg:box_tab'] = 'Caja';
$string['style_dlg:box_width'] = 'Ancho';
$string['style_dlg:bullet_image'] = 'Imagen de la viñeta';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Color';
$string['style_dlg:height'] = 'Alto';
$string['style_dlg:left'] = 'Izquierda';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Tipo';
$string['style_dlg:margin'] = 'Margen';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Placement';
$string['style_dlg:position'] = 'Posición';
$string['style_dlg:positioning_tab'] = 'Posición';
$string['style_dlg:positioning_type'] = 'Tipo';
$string['style_dlg:right'] = 'Derecha';
$string['style_dlg:same'] = 'Lo mismo en todos';
$string['style_dlg:style'] = 'Estilo';
$string['style_dlg:text'] = 'Texto';
$string['style_dlg:text_blink'] = 'Parpadea';
$string['style_dlg:text_case'] = 'Minús./Mayús.';
$string['style_dlg:text_color'] = 'Color';
$string['style_dlg:text_decoration'] = 'Decorativos';
$string['style_dlg:text_font'] = 'Fuente';
$string['style_dlg:text_lineheight'] = 'Ancho de la fila';
$string['style_dlg:text_none'] = 'Ningun';
$string['style_dlg:text_overline'] = '';
$string['style_dlg:text_props'] = 'Texto';
$string['style_dlg:text_size'] = 'Tamaño';
$string['style_dlg:text_striketrough'] = 'Tachar';
$string['style_dlg:text_style'] = 'Estilo';
$string['style_dlg:text_tab'] = 'Texto';
$string['style_dlg:text_underline'] = 'Subrayar';
$string['style_dlg:text_variant'] = 'Variante';
$string['style_dlg:text_weight'] = 'Peso';
$string['style_dlg:title'] = 'Editar estilo CSS';
$string['style_dlg:toggle_insert_span'] = 'Insertar extensión en selección';
$string['style_dlg:top'] = 'Arriba';
$string['style_dlg:visibility'] = 'Visibilidad';
$string['style_dlg:width'] = 'Ancho';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Complemento';
$string['subplugintype_tinymce_plural'] = 'Extensiones';
$string['table:cell'] = 'Celda';
$string['table:cell_desc'] = 'Propiedades de la celda';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Columna';
$string['table:col_after_desc'] = 'Insertar columna (después)';
$string['table:col_before_desc'] = 'Insertar columna (antes)';
$string['table:copy_row_desc'] = 'Copiar fila';
$string['table:cut_row_desc'] = 'Cortar fila';
$string['table:del'] = 'Eliminar Tabla';
$string['table:delete_col_desc'] = 'Eliminar columna';
$string['table:delete_row_desc'] = 'Suprimir fila';
$string['table:desc'] = 'Insertar/editar tabla';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Vincular celdas';
$string['table:paste_row_after_desc'] = 'Pegar filas (después)';
$string['table:paste_row_before_desc'] = 'Pegar filas (antes)';
$string['table:props_desc'] = 'Propiedades de la tabla';
$string['table:row'] = 'Fila';
$string['table:row_after_desc'] = 'Insertar fila (después)';
$string['table:row_before_desc'] = 'Insertar fila (antes)';
$string['table:row_desc'] = 'Propiedades de la fila';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Dividir celdas';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Propiedades avanzadas';
$string['table_dlg:advanced_tab'] = 'Avanzado';
$string['table_dlg:align'] = 'Alineación';
$string['table_dlg:align_bottom'] = 'Debajo';
$string['table_dlg:align_default'] = 'Predet.';
$string['table_dlg:align_left'] = 'Izquierda';
$string['table_dlg:align_middle'] = 'Centrado';
$string['table_dlg:align_right'] = 'Derecha';
$string['table_dlg:align_top'] = 'Arriba';
$string['table_dlg:bgcolor'] = 'Color de fondo';
$string['table_dlg:bgimage'] = 'Imagen de fondo';
$string['table_dlg:border'] = 'Borde';
$string['table_dlg:bordercolor'] = 'Color del borde';
$string['table_dlg:caption'] = 'Subtítulo de la tabla';
$string['table_dlg:cell_all'] = 'Actualizar todas las celdas en la tabla';
$string['table_dlg:cell_cell'] = 'Actualizar celda actual';
$string['table_dlg:cell_col'] = 'Actualizar todas las celdas de la columna';
$string['table_dlg:cell_limit'] = 'Ha superado el número máximo de celdas: {$cells}.';
$string['table_dlg:cell_row'] = 'Actualizar todas las celdas en la fila';
$string['table_dlg:cell_title'] = 'Propiedades de la celda';
$string['table_dlg:cell_type'] = 'Tipo de celda';
$string['table_dlg:cellpadding'] = 'Relleno de celda';
$string['table_dlg:cellspacing'] = 'Espaciado de celda';
$string['table_dlg:col_limit'] = 'Ha superado el número máximo de columnas: {$cols}.';
$string['table_dlg:colgroup'] = 'Colgroup';
$string['table_dlg:cols'] = 'Columnas';
$string['table_dlg:frame'] = 'Recuadro';
$string['table_dlg:frame_all'] = 'todos';
$string['table_dlg:frame_cols'] = 'cols';
$string['table_dlg:frame_groups'] = 'grupos';
$string['table_dlg:frame_none'] = 'ninguno';
$string['table_dlg:frame_rows'] = 'filas';
$string['table_dlg:general_props'] = 'Propiedades generales';
$string['table_dlg:general_tab'] = 'General';
$string['table_dlg:height'] = 'Alto';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Código del lenguaje';
$string['table_dlg:langdir'] = 'Dirección del idioma';
$string['table_dlg:ltr'] = 'Izquierda a derecha';
$string['table_dlg:merge_cells_title'] = 'Vincular celdas';
$string['table_dlg:mime'] = 'Tipo MIME';
$string['table_dlg:missing_scope'] = '¿Está seguro que desea continuar sin especificar el alcance del encabezado de celda? Sin él podría ser difícil para usuarios con discapacidades entender el contenido o los datos mostrados en la tabla.';
$string['table_dlg:row_all'] = 'Actualizar todas las filas';
$string['table_dlg:row_even'] = 'Actualizar filas pares';
$string['table_dlg:row_limit'] = 'Ha superado el número máximo de filas: {$rows}.';
$string['table_dlg:row_odd'] = 'Actualizar filas impares';
$string['table_dlg:row_row'] = 'Actualizar fila actual';
$string['table_dlg:row_title'] = 'Propiedades de la fila';
$string['table_dlg:rowgroup'] = 'Grupo de filas';
$string['table_dlg:rows'] = 'Filas';
$string['table_dlg:rowtype'] = 'Tipo de fila';
$string['table_dlg:rtl'] = 'Derecha a izquierda';
$string['table_dlg:rules'] = 'Reglas';
$string['table_dlg:rules_above'] = 'encima';
$string['table_dlg:rules_below'] = 'debajo';
$string['table_dlg:rules_border'] = 'border';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'vacío';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Alcance';
$string['table_dlg:style'] = 'Estilo';
$string['table_dlg:summary'] = 'Resumen';
$string['table_dlg:tbody'] = 'Cuerpo';
$string['table_dlg:td'] = 'Datos';
$string['table_dlg:tfoot'] = 'Pie de página';
$string['table_dlg:th'] = 'Encabezado';
$string['table_dlg:thead'] = 'Encabezado';
$string['table_dlg:title'] = 'Insertar/editar tabla';
$string['table_dlg:valign'] = 'Alineación vertical';
$string['table_dlg:width'] = 'Ancho';
$string['template:desc'] = 'Insertar contenido de plantilla predefinida';
$string['template_dlg:cdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Domingo,Lunes,Martes,Miércoles,Jueves,Viernes,Sábado,Domingo';
$string['template_dlg:day_short'] = 'Dom,Lun,Mar,Mie,Jue,Vie,Sab,Dom';
$string['template_dlg:desc'] = 'Insertar contenido de plantilla predefinida';
$string['template_dlg:desc_label'] = 'Descripción';
$string['template_dlg:label'] = 'Plantilla';
$string['template_dlg:mdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Enero,Febrero,Marzo,Abril,Mayo,Junio,Julio,Agosto,Septiembre,Octubre,Noviembre,Diciembre';
$string['template_dlg:months_short'] = 'Ene,Feb,Mar,Abr,May,Jun,Jul,Ago,Sep,Oct,Nov,Dic';
$string['template_dlg:preview'] = 'Vista previa';
$string['template_dlg:select'] = 'Seleccionar plantilla';
$string['template_dlg:title'] = 'Plantillas';
$string['template_dlg:warning'] = 'Cuidado: Actualizar una plantilla con otra puede causar pérdida de datos.';
$string['visualblocks:desc'] = 'Mostrar/ocultar elementos';
$string['visualchars:desc'] = 'Mostrar/ocultar caracteres de control';
$string['wordcount:words'] = 'Palabras:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abreviatura';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acrónimo';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Insertar/editar atributos';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Cita';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Borrado';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Inserción';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributos';
$string['xhtmlxtras_dlg:attribs_title'] = 'Insertar/editar atributos';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributos';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Eventos';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Tecla de acceso';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Cita';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Clase';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Fecha/hora';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Idioma';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Dirección del texto';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Estilo';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Orden de tabulación';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Título';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Izquierda a derecha';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Derecha a izquierda';
$string['xhtmlxtras_dlg:events_tab'] = 'Eventos';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributos de elemento';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Eventos';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Ajustes generales';
$string['xhtmlxtras_dlg:general_tab'] = 'General';
$string['xhtmlxtras_dlg:insert_date'] = 'Insertar fecha/hora actuales';
$string['xhtmlxtras_dlg:option_ltr'] = 'Izquierda a derecha';
$string['xhtmlxtras_dlg:option_rtl'] = 'Derecha a izquierda';
$string['xhtmlxtras_dlg:remove'] = 'Suprimir';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Elemento de abreviación';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Elemento acrónimo';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Elemento cita';
$string['xhtmlxtras_dlg:title_del_element'] = 'Elemento borrar';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Elemento insertar';
