<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'atto_charmap', language 'el', version '3.8'.
 *
 * @package     atto_charmap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aacute'] = 'a - acute (οξεία)';
$string['aacute_caps'] = 'A - acute (οξεία)';
$string['acircumflex'] = 'a - circumflex (περισπωμένη)';
$string['acircumflex_caps'] = 'A - circumflex (περισπωμένη)';
$string['acuteaccent'] = 'acute accent (τονισμός με οξεία)';
$string['adiaeresis'] = 'a - diaeresis (διαλυτικά)';
$string['adiaeresis_caps'] = 'A - diaeresis (διαλυτικά)';
$string['agrave'] = 'a - grave (βαρεία)';
$string['agrave_caps'] = 'A - grave (βαρεία)';
$string['alefsymbol'] = 'σύμβολο άλεφ';
$string['almostequalto'] = 'σχεδόν ίσο με';
$string['alpha'] = 'άλφα';
$string['alpha_caps'] = 'Άλφα (Alpha)';
$string['amacron'] = 'a - macron (μακρό)';
$string['amacron_caps'] = 'A - macron (μακρό)';
$string['ampersand'] = 'και (εμπορικό), συμπλεκτικό σύμβολο (ampersand)';
$string['angle'] = 'γωνία (angle)';
$string['approximatelyequalto'] = 'περίπου ίσο με';
$string['aringabove'] = 'a - ring above (δακτύλιος πάνω)';
$string['aringabove_caps'] = 'A - ring above (δακτύλιος πάνω)';
$string['asteriskoperator'] = 'τελεστής αστερίσκος (asterisk operator)';
$string['atilde'] = 'a - tilde (ισπανική/κυματιστή περισπωμένη)';
$string['atilde_caps'] = 'A - tilde (ισπανική/κυματιστή περισπωμένη)';
$string['backwarddifference'] = 'διαφορά προς τα πίσω (backward difference)';
$string['beta'] = 'βήτα (beta)';
$string['beta_caps'] = 'Βήτα (Beta)';
$string['blackclubsuit'] = 'μαύρο σπαθί (black club suit)';
$string['blackdiamondsuit'] = 'μαύρο καρό (black diamond suit)';
$string['blackheartsuit'] = 'μαύρη κούπα (black heart suit)';
$string['blackspadesuit'] = 'μαύρο μπαστούνι (black spade suit)';
$string['brokenbar'] = 'διακεκομμένη μπάρα (broken bar)';
$string['bullet'] = 'κουκίδα (bullet)';
$string['carriagereturn'] = 'carriage return (επαναφορά φορείου, δρομέας στην αρχή γραμμής, enter)';
$string['ccedilla'] = 'c - cedilla (c ζεντίλα, c με υπογεγραμμένη)';
$string['ccedilla_caps'] = 'C - cedilla (C ζεντίλα, C με υπογεγραμμένη)';
$string['cedilla'] = 'cedilla (υπογεγραμμένη)';
$string['centsign'] = 'cent sign (σεντ)';
$string['chi'] = 'χι (chi)';
$string['chi_caps'] = 'Χι (Chi)';
$string['circledplus'] = 'circled plus (κυκλωμένο συν/και/σταυρός)';
$string['circledtimes'] = 'circled times (κυκλωμένο επί/χι)';
$string['circumflexaccent'] = 'circumflex accent (τονισμός με περισπωμένη)';
$string['containsasmember'] = 'contains as member (ανήκει στο)';
$string['copyrightsign'] = 'Πνευματική ιδιοκτησία, πνευματικά δικαιώματα κρατημένα, copyright';
$string['currencysign'] = 'σύμβολο νομίσματος, currency sign, τέλος κελιού/σειράς πίνακα word';
$string['dagger'] = 'παραπομπή, στιλέτο (dagger)';
$string['degreesign'] = 'μοίρες (degree sign)';
$string['delta'] = 'δέλτα (delta)';
$string['delta_caps'] = 'Δέλτα (Delta)';
$string['diaeresis'] = 'διαλυτικά (diaeresis)';
$string['diameter'] = 'διάμετρος (diameter)';
$string['divisionsign'] = 'σύμβολο διαίρεσης (division sign), άνω-κάτω τελεία και παύλα';
$string['dotoperator'] = 'τελεστής τελείας (dot operator), επί (ως τελεία)';
$string['doubledagger'] = 'δίσταυρο, διπλό στιλέτο (double dagger), 2η παραπομπή σελίδας';
$string['doublelow9quotationmark'] = 'λατινικά διπλά κάτω δεξιά εισαγωγικά σαν μικρό 9 (double low-9 quotation mark)';
$string['downwardsarrow'] = 'βελάκι κάτω (downwards arrow)';
$string['downwardsdoublearrow'] = 'διπλό βελάκι κάτω (downwards double arrow)';
$string['eacute'] = 'e - acute (οξεία)';
$string['eacute_caps'] = 'E - acute (οξεία)';
$string['ecircumflex'] = 'e - circumflex (περισπωμένη)';
$string['ecircumflex_caps'] = 'E - circumflex (περισπωμένη)';
$string['ediaeresis'] = 'e - diaeresis (διαλυτικά)';
$string['ediaeresis_caps'] = 'E - diaeresis (διαλυτικά)';
$string['egrave'] = 'e - grave (βαρεία)';
$string['egrave_caps'] = 'E - grave (βαρεία)';
$string['elementof'] = 'ανήκει στο, στοιχείο του (element of)';
$string['emacron'] = 'e - macron (μακρό)';
$string['emacron_caps'] = 'E - macron (μακρό)';
$string['emdash'] = 'διπλή παύλα, πλατιά όσο το Μ (em dash)';
$string['emspace'] = 'κενό μήκους όσο το Μ (em space)';
$string['endash'] = 'παύλα πλατιά όσο το Ν (en dash)';
$string['enspace'] = 'κενό πλάτους όσο το Ν (en space)';
$string['epsilon'] = 'έψιλον (epsilon)';
$string['epsilon_caps'] = 'Έψιλον (Epsilon)';
$string['eta'] = 'ήτα (eta)';
$string['eta_caps'] = 'Ήτα (Eta)';
$string['eth'] = 'eth (d σαν δ)';
$string['eth_caps'] = 'ETH (D με πλην, προφ. σαν δ)';
$string['eurosign'] = 'Ευρώ (σύμβολο νομίσματος)';
$string['feminineordinalindicator'] = 'feminine ordinal indicator (τακτικός ενδείκτης θηλυκού γένους λατιν. π.χ. 1a=prima)';
$string['finalsigma'] = 'τελικό σίγμα';
$string['forall'] = 'για κάθε, ανεστραμμένο κεφ. Α';
$string['fractiononehalf'] = 'κλάσμα ενός δευτέρου (fraction one half)';
$string['fractiononequarter'] = 'κλάσμα ενός τετάρτου (fraction one quarter)';
$string['fractionslash'] = 'κάθετος κλάσματος (fraction slash)';
$string['fractionthreequarters'] = 'κλάσμα τριών τετάρτων (fraction three quarters)';
$string['functionflorin'] = 'συνάρτηση (function), φιορίνι (florin)';
$string['gamma'] = 'γάμα (gamma)';
$string['gamma_caps'] = 'Γάμα (Gamma)';
$string['greaterthanorequalto'] = 'μεγαλύτερο ή ίσο με (greater-than or equal to)';
$string['greaterthansign'] = 'μεγαλύτερο από (greater-than)';
$string['iacute'] = 'i - acute (οξεία)';
$string['iacute_caps'] = 'I - acute (οξεία)';
$string['icircumflex'] = 'i - circumflex (περισπωμένη)';
$string['icircumflex_caps'] = 'I - circumflex (περισπωμένη)';
$string['identicalto'] = 'ταυτίζεται με (identical to)';
$string['idiaeresis'] = 'i - diaeresis (διαλυτικά)';
$string['idiaeresis_caps'] = 'I - diaeresis (διαλυτικά)';
$string['igrave'] = 'i - grave (βαρεία)';
$string['igrave_caps'] = 'I - grave (βαρεία)';
$string['imacron'] = 'i - macron (μακρό)';
$string['imacron_caps'] = 'I - macron (μακρό)';
$string['imaginarypart'] = 'φανταστικό μέρος (imaginary part)';
$string['infinity'] = 'άπειρο (infinity)';
$string['insertcharacter'] = 'Εισαγωγή χαρακτήρα';
$string['integral'] = 'ολοκλήρωμα (integral)';
$string['interrobang'] = 'interrobang (ερωτηματικό και θαυμαστικό μαζί)';
$string['intersection'] = 'τομή (intersection)';
$string['invertedexclamationmark'] = 'ανάποδο αγγλικό θαυμαστικό (inverted exclamation mark)';
$string['iota'] = 'γιώτα (iota)';
$string['iota_caps'] = 'Γιώτα (Iota)';
$string['kappa'] = 'κάππα (kappa)';
$string['kappa_caps'] = 'Κάππα (Kappa)';
$string['lambda'] = 'λάμδα (lambda)';
$string['lambda_caps'] = 'Λάμδα (Lambda)';
$string['leftceiling'] = 'αριστερή στρογγυλοποίηση προς τα πάνω (left ceiling)';
$string['leftdoublequotationmark'] = 'λατινικά πάνω αριστερά διπλά εισαγωγικά (left double quotation mark)';
$string['leftfloor'] = 'αριστερή παρένθεση στρογγυλοποίησης προς τα κάτω (left floor)';
$string['leftpointinganglebracket'] = 'αριστερή γωνιώδης αγκύλη (left-pointing angle bracket)';
$string['leftpointingguillemet'] = 'αριστερά ελληνικά εισαγωγικά (left pointing guillemet)';
$string['leftrightarrow'] = 'βελάκι αριστερά-δεξιά (left right arrow)';
$string['leftrightdoublearrow'] = 'διπλό βέλος αριστερά-δεξιά (left right double arrow)';
$string['leftsinglequotationmark'] = 'αριστερό απλό εισαγωγικό (left single quotation mark)';
$string['lefttorightmark'] = 'left-to-right mark (από αριστερά προς τα δεξιά)';
$string['leftwardsarrow'] = 'αριστερό βελάκι (leftwards arrow)';
$string['leftwardsdoublearrow'] = 'αριστερό διπλό βέλος (leftwards double arrow)';
$string['lessthanorequalto'] = 'μικρότερο από ή ίσο με (less-than or equal to)';
$string['lessthansign'] = 'μικρότερο από (less-than sign)';
$string['ligatureae'] = 'ligature ae (διπλό γράμμα, λιγατούρα, τυπογρ.σύμπλεγμα)';
$string['ligatureae_caps'] = 'ligature AE (διπλό γράμμα, λιγατούρα, τυπογρ.σύμπλεγμα)';
$string['ligatureoe'] = 'ligature oe (διπλό γράμμα, λιγατούρα, τυπογρ.σύμπλεγμα)';
$string['ligatureoe_caps'] = 'ligature OE (διπλό γράμμα, λιγατούρα, τυπογρ.σύμπλεγμα)';
$string['logicaland'] = 'λογικό και (logical and)';
$string['logicalor'] = 'λογικό ή (logical or)';
$string['lozenge'] = 'ρόμβος (lozenge)';
$string['macron'] = 'μακρό (macron)';
$string['masculineordinalindicator'] = 'masculine ordinal indicator (τακτικός ενδείκτης αρσενικού γένους λατιν. π.χ. 1o=primo)';
$string['microsign'] = 'micro (πρόθεμα μονάδων στο SI ίσο με 10^-6)';
$string['middledot'] = 'άνω τελεία (middle dot)';
$string['minussign'] = 'πλην, μείον (minus sign)';
$string['minutesfeet'] = 'λεπτά, πόδια (ft)';
$string['mu'] = 'μι (mu)';
$string['mu_caps'] = 'Μι (Mu)';
$string['multiplicationsign'] = 'σύμβολο πολλαπλασιασμού (multiplication sign), αγγλ. x';
$string['naryproduct'] = 'ν-οστό γινόμενο (n-ary product), τελεστής γινομένου (product sign), κεφ. Πι';
$string['narysumation'] = 'ν-οστό άθροισμα (n-ary sumation), σύμβολο της άθροισης, κεφ. Σ';
$string['nobreakspace'] = 'no-break space (διάστημα χωρίς διακοπή/αλλαγή γραμμής)';
$string['notanelementof'] = 'δεν ανήκει σε (not an element of)';
$string['notasubsetof'] = 'δεν είναι υποσύνολο του (not a subset of)';
$string['notequalto'] = 'δεν ισούται με (not equal to)';
$string['notsign'] = 'σύμβολο του όχι (λογικό όχι)';
$string['ntilde'] = 'n - tilde (περισπωμένη κυματιστή)';
$string['ntilde_caps'] = 'N - tilde (περισπωμένη κυματιστή)';
$string['nu'] = 'νι (nu)';
$string['nu_caps'] = 'Νι (Nu)';
$string['oacute'] = 'o - acute (οξεία)';
$string['oacute_caps'] = 'O - acute (οξεία)';
$string['ocircumflex'] = 'o - circumflex (περισπωμένη)';
$string['ocircumflex_caps'] = 'O - circumflex (περισπωμένη)';
$string['odiaeresis'] = 'o - diaeresis (διαλυτικά)';
$string['odiaeresis_caps'] = 'O - diaeresis (διαλυτικά)';
$string['ograve'] = 'o - grave (βαρεία)';
$string['ograve_caps'] = 'O - grave (βαρεία)';
$string['omacron'] = 'o - macron (μακρό)';
$string['omacron_caps'] = 'O - macron (μακρό)';
$string['omega'] = 'ωμέγα (omega)';
$string['omega_caps'] = 'Ωμέγα (Omega)';
$string['omicron'] = 'όμικρον (omicron)';
$string['omicron_caps'] = 'Όμικρον (Omicron)';
$string['oslash'] = 'Σκανδιναβικό ο με πλάγια γραμμή (o slash)';
$string['oslash_caps'] = 'Σκανδιναβικό Ο με πλάγια γραμμή (O slash), διάμετρος, κενό σύνολο';
$string['otilde'] = 'o - tilde (περισπωμένη κυματιστή)';
$string['otilde_caps'] = 'O - tilde (περισπωμένη κυματιστή)';
$string['overline'] = 'overline (γραμμή από πάνω)';
$string['paragraphsign'] = 'σύμβολο παραγράφου (paragraph sign) ((καθρεφτισμένο κεφ. Ρ))';
$string['partialdifferential'] = 'μερικές διαφορές μαθημ. (partial differential) ((καλλιγρ. θ))';
$string['permillesign'] = 'επί τοις χιλίοις (per mille sign)';
$string['perpendicular'] = 'κάθετος (perpendicular) ((ανάποδο Τ))';
$string['phi'] = 'φι (phi)';
$string['phi_caps'] = 'Φι (Phi)';
$string['pi'] = 'πι (pi)';
$string['pi_caps'] = 'Πι (Pi)';
$string['pisymbol'] = 'σύμβολο π (pi symbol)';
$string['pluginname'] = 'Παρεμβολή χαρακτήρα (Insert, INS)';
$string['plusminussign'] = 'συν/πλην (plus-minus sign)';
$string['poundsign'] = 'σύμβολο αγγλικής λίρας (pound sign)';
$string['privacy:metadata'] = 'Το πρόσθετο «atto_charmap» δεν αποθηκεύει κανένα προσωπικό δεδομένο.';
$string['proportionalto'] = 'σε αναλογία με (proportional to)';
$string['psi'] = 'ψι (psi)';
$string['psi_caps'] = 'Ψι (Psi)';
$string['quotationmark'] = 'λατινικά διπλά εισαγωγικά (quotation mark)';
$string['realpartsymbol'] = 'σύμβολο πραγματικού μέρους (real part symbol)';
$string['registeredsign'] = 'καταχωρημένο σήμα κατατεθέν (registered sign)';
$string['rho'] = 'ρο (rho)';
$string['rho_caps'] = 'Ρο (Rho)';
$string['rightceiling'] = 'δεξιά παρένθεση στρογγυλοποίησης προς τα πάνω (right ceiling)';
$string['rightdoublequotationmark'] = 'right double quotation mark (λατινικό δεξιό διπλό εισαγωγικό)';
$string['rightfloor'] = 'δεξιά παρένθεση στρογγυλοποίησης προς τα κάτω (right floor)';
$string['rightpointinganglebracket'] = 'δεξιά γωνιώδης αγκύλη (right-pointing angle bracket)';
$string['rightpointingguillemet'] = 'δεξιά ελληνικά εισαγωγικά (right pointing guillemet)';
$string['rightsinglequotationmark'] = 'δεξί μονό εισαγωγικό (right single quotation mark)';
$string['righttoleftmark'] = 'right-to-left mark (σήμα δεξιά προς αριστερά)';
$string['rightwardsarrow'] = 'δεξί βελάκι (rightwards arrow)';
$string['rightwardsdoublearrow'] = 'διπλό δεξί βέλος (rightwards double arrow)';
$string['scaron'] = 's - caron (ανεστραμμένη περισπωμένη)';
$string['scaron_caps'] = 'S - caron (ανεστραμμένη περισπωμένη)';
$string['secondsinches'] = 'δευτερόλεπτα (seconds), ίντσες (inches)';
$string['sectionsign'] = 'δίσιγμα, σύμβολο τμήματος/ενότητας/παραγράφου (section sign)';
$string['sharpsesszed'] = 'sharp s / ess-zed (γερμανικό ες-τσετ)';
$string['sigma'] = 'σίγμα (sigma)';
$string['sigma_caps'] = 'Σίγμα (Sigma)';
$string['similarto'] = 'όμοιο με (similar to)';
$string['singleleftpointinganglequotationmark'] = 'αριστερό μονό γωνιώδες εισαγωγικό (single left-pointing angle quotation mark)';
$string['singlelow9quotationmark'] = 'μονή κάτω αριστερή παρένθεση σαν μικρό 9 (single low-9 quotation mark)';
$string['singlerightpointinganglequotationmark'] = 'αριστερό δεξί γωνιώδες εισαγωγικό (single right-pointing angle quotation mark)';
$string['smalltilde'] = 'small tilde (μικρή περισπωμένη κυματιστή)';
$string['softhyphen'] = 'soft hyphen (προαιρετικό ενωτικό, επιλεκτική παύλα)';
$string['squareroot'] = 'τετραγωνική ρίζα (square root)';
$string['subsetof'] = 'υποσύνολο του (subset of)';
$string['subsetoforequalto'] = 'υποσύνολο του ή ίσο με (subset of or equal to)';
$string['superscriptone'] = 'υψωμένο ένα (superscript one)';
$string['superscriptthree'] = 'υψωμένο τρία (superscript three)';
$string['superscripttwo'] = 'υψωμένο δύο (superscript two)';
$string['supersetof'] = 'υπερσύνολο του (superset of)';
$string['supersetoforequalto'] = 'υπερσύνολο του ή ίσο με';
$string['tau'] = 'ταφ (tau)';
$string['tau_caps'] = 'Ταφ (Tau)';
$string['thereexists'] = 'υπάρχει (τουλάχ. 1) (there exists), καθρεφτ. Ε';
$string['therefore'] = 'γι\'αυτό, συνεπάγεται, οπότε, άρα (therefore) ((τρίγωνο με 3 τελείες))';
$string['theta'] = 'θήτα (theta)';
$string['theta_caps'] = 'Θήτα (Theta)';
$string['thetasymbol'] = 'σύμβολο θήτα (theta symbol) ((καλλιγραφικό))';
$string['thinspace'] = 'μικρό κενό (thin space)';
$string['thorn'] = 'σω αρχαίο ελλ., σκανδιναβικό γράμμα αγκάθι (thorn)';
$string['thorn_caps'] = 'Σω αρχαίο ελλ., σκανδιναβικό γράμμα αγκάθι (THORN)';
$string['threedotleader'] = 'αποσιωπητικά, τρεις τελείες (three dot leader, ellipsis)';
$string['trademarksign'] = '((εμπορικό)) σήμα κατατεθέν (trade mark sign, TM)';
$string['turnedquestionmark'] = 'ανάποδο λατινικό ερωτηματικό (turned question mark)';
$string['uacute'] = 'u - acute (οξεία)';
$string['uacute_caps'] = 'U - acute (οξεία)';
$string['ucircumflex'] = 'u - circumflex (περισπωμένη)';
$string['ucircumflex_caps'] = 'U - circumflex (περισπωμένη)';
$string['udiaeresis'] = 'u - diaeresis (διαλυτικά)';
$string['udiaeresis_caps'] = 'U - diaeresis (διαλυτικά)';
$string['ugrave'] = 'u - grave (βαρεία)';
$string['ugrave_caps'] = 'U - grave (βαρεία)';
$string['umacron'] = 'u - macron (υ μακρό)';
$string['umacron_caps'] = 'U - macron (μακρό)';
$string['union'] = 'ένωση (union)';
$string['upsilon'] = 'ύψιλον (upsilon)';
$string['upsilon_caps'] = 'Ύψιλον (Upsilon)';
$string['upsilonhooksymbol'] = 'Ύψιλον με γάντζο (upsilon - hook symbol)';
$string['upwardsarrow'] = 'βελάκι επάνω (upwards arrow)';
$string['upwardsdoublearrow'] = 'Διπλό πάνω βέλος (upwards double arrow)';
$string['weierstrassp'] = 'Weierstrass p';
$string['xi'] = 'χι (xi)';
$string['xi_caps'] = 'Χι (Xi)';
$string['yacute'] = 'y - acute (οξεία)';
$string['yacute_caps'] = 'Y - acute (οξεία)';
$string['ydiaeresis'] = 'y - diaeresis (διαλυτικά)';
$string['ydiaeresis_caps'] = 'Y - diaeresis (διαλυτικά)';
$string['yensign'] = 'σύμβολο του νομίσματος Γιεν (yen sign)';
$string['zerowidthjoiner'] = 'ενωτικό μηδενικού πλάτους (zero width joiner)';
$string['zerowidthnonjoiner'] = 'μη-ενωτικό μηδενικού πλάτους (zero width non-joiner)';
$string['zeta'] = 'ζήτα (zeta)';
$string['zeta_caps'] = 'Ζήτα (Zeta)';
