<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_intelliboard', language 'el', version '3.8'.
 *
 * @package     local_intelliboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a0'] = 'Ταμπλό Προσόντων';
$string['a13'] = 'Όνομα Προσόντος';
$string['a19'] = 'Ημερομηνία Αξιολόγησης Προσόντος';
$string['a20'] = 'Αξιολογητής Προσόντος';
$string['a26'] = 'Αυτός ο πίνακας εμφανίζει τον αριθμό των προσόντων που έχουν ανατεθεί σε ένα μάθημα, τους μαθητές που έχουν αξιολογηθεί (είτε ως επαρκείς είτε όχι) και οι εκπαιδευόμενοι που έχουν χαρακτηριστεί επαρκείς σε σχέση με το προσόν.';
$string['a27'] = 'στα';
$string['a28'] = 'Λεπτομέρειες';
$string['a29'] = 'Ενεργοποίηση Ταμπλό Δεξιοτήτων';
$string['a30'] = 'Ενεργοποίηση Αναφορών Προσόντων';
$string['a31'] = 'Πλαίσια';
$string['a32'] = 'Σχέδια μάθησης';
$string['a33'] = 'Αξιολογημένο, Επαρκές';
$string['a34'] = 'Αξιολογημένο, Ανεπαρκές';
$string['a35'] = 'Μη αξιολογημένο';
$string['a36'] = 'Επισκόπηση Προσόντων';
$string['a37'] = 'Δεν έχει δημιουργηθεί ένα προσόν. Παρακαλούμε, επικοινωνήστε με το διαχειριστή του συστήματός σας.';
$string['a38'] = 'Μαθήματα που συνδέονται με προσόντα';
$string['a39'] = 'Σύνολα Προσόντων';
$string['a4'] = 'Πρόοδος επάρκειας';
$string['a40'] = 'Συνδεδεμένα μαθήματα';
$string['a5'] = 'Αξιολογημένες ικανότητες';
$string['a7'] = 'Εκπαιδευόμενοι που αξιολογήθηκαν';
$string['a8'] = 'Πρόοδος';
$string['a9'] = 'Επαρκείς εκπαιδευόμενοι';
$string['account'] = 'Πληροφορίες εγγραφής';
$string['actions'] = 'Ενέργειες';
$string['active'] = 'Ενεργός';
$string['activities'] = 'Δραστηριότητες';
$string['activities_resources'] = 'Δραστηριότητες/Πόροι';
$string['activity'] = 'Δραστηριότητα';
$string['activity_grades'] = 'Βαθμοί δραστηριότητας';
$string['activity_name'] = 'Όνομα δραστηριότητας';
$string['activity_participation'] = 'Συμμετοχή δραστηριότητας';
$string['activity_progress'] = 'Πρόοδος δραστηριότητας';
$string['address'] = 'Διεύθυνση';
$string['adm_dshb_adm_dashb_totals'] = 'Σύνολα';
$string['adm_dshb_course_enrollments_types'] = 'Τύποι εγγραφής μαθήματος';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Εγγραφή χρήστη, Σύνοδος, Επίπεδα δραστηριότητας ολοκλήρωσης';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Εγγραφές μαθήματος με επισκόπηση ολοκλήρωσης';
$string['adm_dshb_user_map'] = 'Χάρτης χρήστη';
$string['adm_dshb_user_site_summary_details'] = 'Λεπτομέρειες περίληψης ιστοτόπου χρήστη';
$string['admin_dashboard'] = 'Ταμπλό διαχειριστή';
$string['adv_settings'] = 'Προχωρημένες ρυθμίσεις';
$string['ajax'] = 'Συχνότητα';
$string['all_cohorts'] = 'Όλα τα σύνολα χρηστών';
$string['all_courses'] = 'Όλα τα μαθήματα';
$string['all_data'] = 'Όλα τα δεδομένα';
$string['all_fields_required'] = 'όλα τα πεδία είναι υποχρεωτικά';
$string['all_modules'] = 'Όλα τα αρθρώματα';
$string['all_time'] = 'Πάντα';
$string['allmod'] = 'Όλες οι δραστηριότητες';
$string['analityc_3_name'] = 'Επισκόπηση κουίζ & λεπτομέρειες ερώτησης';
$string['analytics'] = 'Αναλυτική';
$string['answers'] = 'Απαντήσεις';
$string['api'] = 'Εναλλακτικό API';
$string['api_desc'] = 'Χρήση εναλλακτικού εξυπηρετητή API (για αποφυγή μπλοκαρίσματος firewall)';
$string['assignment_name'] = 'Όνομα ανάθεσης (εργασίας)';
$string['assignments'] = 'Αναθέσεις (εργασιών)';
$string['attendance'] = 'Παρουσίες';
$string['attendanceapikey'] = 'Κλειδί API παρουσιών';
$string['attendanceapisecret'] = 'Μυστικό API παρουσιών';
$string['attendanceconsumerkey'] = 'Κλειδί καταναλωτή';
$string['attendancesharedsecret'] = 'Κοινόχρηστο μυστικό';
$string['attendancetoolurl'] = 'Διεύθυνση URL εργαλείου';
$string['authentication'] = 'Δημιουργία λογαριασμού';
$string['average_grade'] = 'μέση βαθμολογία';
$string['avg_score'] = 'Μέσος όρος σκορ';
$string['avg_time_spent_per_stud'] = 'Μέσος χρόνος ενασχόλησης ανά μαθητή';
$string['avg_visits_per_stud'] = 'Μέσος όρος επισκέψεων ανά μαθητή';
$string['bbbapiendpoint'] = 'Τελικό σημείο API BBB';
$string['bbbmeetings'] = 'Συναντήσεις BigBlueButton';
$string['bbbserversecret'] = 'Μυστικό εξυπηρετητή BBB';
$string['billingcycles'] = 'Κύκλοι χρέωσης';
$string['cache_compresstracking'] = 'Αποθήκευση στην κρυφή μνήμη του Moodle';
$string['cachedef_instructor_course_data'] = 'Κρυφή μνήμη για δεδομένα μαθημάτων';
$string['cachedef_reports_list'] = 'Κρυφή μνήμη για λίστα αναφορών';
$string['cancel_subscription'] = 'Ακύρωση συνδρομής';
$string['canceled'] = 'Ακυρώθηκε';
$string['categories'] = 'Κατηγορίες';
$string['category'] = 'Κατηγορία';
$string['check_active_meetings'] = 'Έλεγχος ενεργών συναντήσεων';
$string['city'] = 'Πόλη/χωριό';
$string['class_average'] = 'Μέσος όρος τάξης';
$string['click_link_below_support_pages'] = 'Κάντε κλικ στον παρακάτω σύνδεσμο για πρόσβαση στις σελίδες υποστήριξης του IntelliBoard:';
$string['close'] = 'Κλείσιμο';
$string['closed'] = 'Κλειστό';
$string['cohorts'] = 'Σύνολα χρηστών';
$string['completed'] = 'Ολοκληρώθηκε';
$string['completed_activities'] = 'Ολοκληρωμένες Δραστηριότητες';
$string['completed_activities_resources'] = 'Ολοκληρωμένες Δραστηριότητες/Πόροι';
$string['completed_courses'] = 'Ολοκληρωμένα μαθήματα';
$string['completed_on'] = 'Ολοκληρώθηκε στις {$a}';
$string['completion'] = 'Ολοκλήρωση';
$string['completion_is_not_enabled'] = 'Η ολοκλήρωση δεν είναι ενεργοποιημένη για αυτό το μάθημα';
$string['completion_not_enabled'] = 'Η ολοκλήρωση δεν είναι ενεργοποιημένη';
$string['completion_status'] = 'Κατάσταση ολοκλήρωσης';
$string['completions'] = 'Κατάσταση ολοκλήρωσης δραστηριότητας';
$string['completions_completed'] = 'Κατάσταση ολοκλήρωσης (ολοκληρώθηκε)';
$string['completions_fail'] = 'Κατάσταση ολοκλήρωσης (αποτυχία)';
$string['completions_pass'] = 'Κατάσταση ολοκλήρωσης (επιτυχία)';
$string['compresstracking'] = 'Συμπίεση παρακολούθησης';
$string['confirm_and_sign_up'] = 'Επιβεβαίωση και εγγραφή';
$string['congratulations_intb_register'] = 'Συγχαρητήρια';
$string['cor_incor_answers'] = 'Σωστές/Λανθασμένες απαντήσεις';
$string['correct'] = 'Σωστό';
$string['correct_number'] = 'Σωστό {$a}';
$string['correlations'] = 'Συσχετίσεις';
$string['country'] = 'Χώρα';
$string['course'] = 'Μάθημα';
$string['course_activities'] = 'Ενεργοποίηση δραστηριοτήτων μαθήματος';
$string['course_category'] = 'Κατηγορία Μαθήματος';
$string['course_chart'] = 'Ενεργοποίηση γραφήματος μαθημάτων';
$string['course_completion_status'] = 'Κατάσταση ολοκλήρωσης μαθήματος';
$string['course_completions'] = 'Ολοκληρώσεις μαθήματος';
$string['course_enrollment_types'] = 'Τύποι εγγραφής μαθήματος';
$string['course_enrollments_with_completion_overview'] = 'Εγγραφές μαθήματος με επισκόπηση ολοκλήρωσης';
$string['course_grade'] = 'Βαθμός μαθήματος';
$string['course_idnumber'] = 'Αναγνωριστικός αριθμός';
$string['course_max_grade'] = 'Μέγιστος βαθμός μαθήματος';
$string['course_name'] = 'Όνομα μαθήματος';
$string['course_name_a'] = 'Μάθημα: {$a}';
$string['course_overview'] = 'Επισκόπηση μαθήματος';
$string['course_progress'] = 'Πρόοδος μαθήματος';
$string['course_short_name'] = 'Σύντομο όνομα μαθήματος';
$string['course_start_date'] = 'Ημερομηνία έναρξης μαθήματος';
$string['course_started'] = 'Το μάθημα ξεκίνησε';
$string['course_status'] = 'Κατάσταση';
$string['course_success'] = 'Επιτυχία μαθήματος';
$string['courseaverage'] = 'Μέσος όρος μαθήματος';
$string['courses'] = 'Μαθήματα';
$string['courses_avg_grade'] = 'Μέσος όρος μαθημάτων';
$string['courses_in_progress'] = 'Μαθήματα σε εξέλιξη';
$string['coursessessions'] = 'Συνεδρίες μαθημάτων';
$string['coursessessionspage'] = 'Σελίδα συνεδριών μαθημάτων';
$string['created'] = 'Δημιουργήθηκε';
$string['criteria_all_courses'] = 'Όλα τα ακόλουθα μαθήματα πρέπει να ολοκληρωθούν';
$string['criteria_any_course'] = 'Οποιοδήποτε από τα παρακάτω μαθήματα πρέπει να ολοκληρωθεί';
$string['criteria_method'] = 'Μέθοδος κριτηρίων';
$string['csv'] = 'CSV';
$string['current_grade'] = 'Τρέχων βαθμός';
$string['customod'] = 'Προσαρμοσμένες δραστηριότητες';
$string['daily'] = 'Καθημερινά';
$string['dashboard'] = 'Ταμπλό';
$string['dashboard_link'] = 'Κάντε κλικ για να δείτε την (Μαθησιακή) Αναλυτική';
$string['dashboard_settings'] = 'Ρυθμίσεις ταμπλό';
$string['date_created'] = 'Ημερομηνία δημιουργίας';
$string['date_format'] = 'Μορφότυπος ημερομηνίας';
$string['debug'] = 'Αποσφαλμάτωση αιτημάτων CURL';
$string['debug_desc'] = '';
$string['delete_message'] = 'Διαγραφή αναφοράς SQL;';
$string['department'] = 'Τμήμα';
$string['details'] = 'Λεπτομέρειες';
$string['disable_time_and_visits_users_overview'] = 'Απενεργοποίηση του χρόνου που πέρασε και τις επισκέψεις στην Επισκόπηση χρηστών';
$string['disabled'] = 'Απενεργοποιημένο';
$string['do_not_use_compresstracking'] = 'Μην χρησιμοποιείτε την συμπίεση παρακολούθησης';
$string['done'] = 'Ολοκληρώθηκε!';
$string['downloadinvoice'] = 'Λήψη τιμολογίου';
$string['due_date'] = 'Οφειλόμενη ημερομηνία';
$string['email'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['email_is_required'] = 'Η διεύθυνση ηλε.ταχυδρομείου απαιτείται';
$string['email_subscr'] = 'Διεύθυνση ηλε.ταχυδρομείου εγγραφής';
$string['enable_badges_report'] = 'Ενεργοποίηση αναφοράς «Διακριτικά»';
$string['enable_sso'] = 'Ενεργοποίηση συνδέσμου ενιαίας σύνδεσης (SSO)';
$string['enable_time_tracking'] = 'Ενεργοποίηση παρακολούθησης χρόνου';
$string['enable_transcripts'] = 'Ενεργοποίηση μεταγραφών';
$string['enable_webservice'] = 'Ενεργοποίηση υπηρεσιών ιστού';
$string['enableattendance'] = 'Ενεργοποίηση παρουσιών';
$string['enablebbbdebug'] = 'Λειτουργία αποσφαλμάτωσης BigBlueButton';
$string['enablebbbmeetings'] = 'Ενεργοποίηση παρακολούθησης των συσκέψεων BigBlueButton';
$string['enabled'] = 'Ενεργοποιήθηκε Παρακολούθηση';
$string['enabled_desc'] = 'Ενεργοποίηση Παρακολούθησης';
$string['enroled_on'] = 'Ημερομηνία εγγραφής';
$string['enrolled'] = 'Εγγεγραμμένοι';
$string['enrolled_completed'] = 'Εγγεγραμμένος: {$a->courses}, Ολοκληρώθηκε: {$a->complete_courses}';
$string['enrolled_date'] = 'Ημερομηνία εγγραφής';
$string['enrollments'] = 'Εγγραφές';
$string['enrolment_expiration'] = 'Λήξη εγγραφής';
$string['enrolment_method'] = 'Μέθοδος εγγραφής';
$string['enter_course_and_quiz'] = 'Παρακαλώ επιλέξτε μάθημα και κουίζ.';
$string['enter_quiz'] = 'Παρακαλώ επιλέξτε κουίζ.';
$string['excel'] = 'Excel';
$string['expired'] = 'Έληξε';
$string['failed'] = 'Απέτυχε';
$string['failed_on'] = 'Ολοκληρώθηκε (fail) on {$a}';
$string['file_compresstracking'] = 'Αποθήκευση στα δεδομένα Moodle';
$string['filter1'] = 'Διαγραμμένοι χρήστες';
$string['filter1_desc'] = 'Εμφάνιση διαγραμμένων χρηστών';
$string['filter2'] = 'Χρήστες σε αναστολή';
$string['filter2_desc'] = 'Εμφάνιση χρηστών σε αναστολή';
$string['filter3'] = '(Χρήστης) επισκέπτης';
$string['filter3_desc'] = 'Εμφάνιση (χρήστη) επισκέπτη στις αναφορές';
$string['filter4'] = 'Φίλτρο μαθήματος';
$string['filter4_desc'] = 'Εμφάνιση μη ορατών μαθημάτων';
$string['filter5'] = 'Φίλτρο μεθόδου εγγραφής';
$string['filter5_desc'] = 'Εμφάνιση μη ενεργών μεθόδων εγγραφής';
$string['filter6'] = 'Φίλτρο εγγραφής χρήστη';
$string['filter6_desc'] = 'Εμφάνιση χρηστών με μη ενεργή κατάσταση εγγραφής';
$string['filter7'] = 'Φίλτρο δραστηριοτήτων/πόρων';
$string['filter7_desc'] = 'Εμφάνιση μη ορατών δραστηριοτήτων/πόρων';
$string['filter8'] = 'Φίλτρο εγγεγραμμένων χρηστών';
$string['filter8_desc'] = 'Εμφάνιση μόνο εγγεγραμμένων χρηστών (δεν συνιστάται)';
$string['filter_all_time'] = 'Φίλτρο χρόνου: Πάντα';
$string['filter_dates'] = 'Φίλτρο ημερομηνιών:';
$string['filter_last_year'] = 'Φίλτρο χρόνου: Τελευταίο έτος';
$string['filter_this_year'] = 'Φίλτρο χρόνου: Τρέχον έτος';
$string['filters'] = 'Φίλτρα ταμπλό';
$string['first_access'] = 'Πρώτη πρόσβαση';
$string['first_name'] = 'Μικρό/Βαπτιστικό όνομα';
$string['firstname_lastname'] = '{Όνομα} {Επώνυμο}';
$string['goal_grade'] = 'Βαθμός στόχου';
$string['grade'] = 'Βαθμός';
$string['grade_activities_overview'] = 'Επισκόπηση βαθμολογημένων δραστηριοτήτων';
$string['graded'] = 'Βαθμολογήθηκε';
$string['grades'] = 'Βαθμοί';
$string['grades_alt_text'] = 'Εναλλακτικό κείμενο για το μενού πλοήγησης';
$string['grid_view'] = 'Εμφάνιση πλέγματος';
$string['group_aggregation'] = 'Συσσωμάτωση ομάδων';
$string['help'] = 'Χρειάζεται βοήθεια;';
$string['ianalytics'] = 'Αναλυτική IntelliBoard';
$string['import'] = 'Εισαγωγή';
$string['importing_logs'] = 'Εισαγωγή καταγραφών';
$string['importing_totals'] = 'Εισαγωγή συνόλων';
$string['in1'] = 'Επισκόπηση';
$string['in11'] = 'Πρόοδος μαθητευόμενου';
$string['in12'] = 'Πρόοδος βαθμού';
$string['in14'] = '% Πρόοδος';
$string['in16'] = 'Τελευταία πρόσβαση';
$string['in201'] = 'Επιστροφή στις Δραστηριότητες';
$string['in22'] = 'Ενεργοποιημένο';
$string['in23'] = 'Δεν έχετε κανένα μαθητευόμενο για εμφάνιση.';
$string['in24'] = 'Άρθρωμα';
$string['in25'] = 'Βαθμός επιτυχίας';
$string['in27'] = 'Σύνολο μαθητών';
$string['in29'] = 'Ενεργοί μαθητές';
$string['in3'] = 'Σύνολο μαθημάτων';
$string['in30'] = 'Μη ενεργοί μαθητές';
$string['in31'] = 'Χρήση δραστηριότητας';
$string['in32'] = 'Μέσος όρος χρόνου μέσα στην επιλεγμένη περίοδο';
$string['in33'] = 'Χρήση θέματος';
$string['in4'] = 'Σύνολο μαθητευόμενων';
$string['in5'] = 'Σύνολο βαθμών μαθήματος';
$string['in6'] = 'Μαθητευόμενοι που ολοκλήρωσαν';
$string['in7'] = 'Μαθητευόμενοι που δεν ολοκλήρωσαν';
$string['in8'] = 'Μέσος όρος βαθμού μαθητευόμενων';
$string['inactivity'] = 'Αδράνεια';
$string['inactivity_desc'] = 'Χρόνος αδράνειας χρήστη (σε δευτερόλεπτα)';
$string['incomplete'] = 'Ανολοκλήρωτο';
$string['incorrect'] = 'Λάθος';
$string['incorrect_number'] = 'Λάθος {$a}';
$string['inprogress'] = 'Σε εξέλιξη';
$string['institution'] = 'Ίδρυμα';
$string['instructor_course_shortname'] = 'Εμφάνιση σύντομου ονόματος μαθήματος αντί για το πλήρες';
$string['instructor_course_visibility'] = 'Εμφάνιση μαθημάτων σε απόκρυψη/αναστολή για [instructor]';
$string['instructor_courses_table_name'] = 'Βαθμοί μαθήματος';
$string['instructor_courses_table_name_activities'] = 'Μάθημα {$a->fullname}, Δραστηριότητες';
$string['instructor_courses_table_name_activity'] = 'Μάθημα {$a->course}, Δραστηριότητα {$a->name}, Βαθμοί';
$string['instructor_courses_table_name_learner'] = 'Μάθημα {$a->course}, Εκπαιδευόμενος {$a->learner}, Βαθμοί';
$string['instructor_courses_table_name_learners'] = 'Μάθημα {$a->fullname}, Εκπαιδευόμενοι';
$string['instructor_custom_groups'] = 'Προσαρμοσμένες ομάδες εκπαιδευτή';
$string['instructor_hide_need_help'] = 'Απόκρυψη πλήκτρου «Χρειάζομαι βοήθεια»';
$string['instructor_mode'] = 'Εμφάνιση όλων των μαθηματων που είναι διαθέσιμα για [instructor]';
$string['instructor_redirect'] = 'Ανακατεύθυνση εκπαιδευτή';
$string['instructor_show_suspended_enrollments'] = 'Εμφάνιση εγγεγραμμένων σε αναστολή';
$string['intelliboard:competency'] = 'IntelliBoard [προσόν]';
$string['intelliboard_totals'] = 'Σύνολα IntelliBoard';
$string['intelliboard_tracking'] = 'Παρακολούθηση IntelliBoard';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['issuer'] = 'Εκδότης';
$string['items_per_query'] = 'Στοιχεία ανά ερώτημα';
$string['key'] = 'Κλειδί';
$string['last_access_on_course'] = 'Τελευταία πρόσβαση στο μάθημα: {$a}';
$string['last_day'] = 'ημέρα';
$string['last_hour'] = 'ώρα';
$string['last_month'] = 'Τελευταίες 30 ημέρες';
$string['last_quarter'] = 'Τελευταίοι 3 μήνες';
$string['last_semester'] = 'Τελευταίοι 6 μήνες';
$string['last_week'] = 'Τελευταίες 7 ημέρες';
$string['last_year'] = 'Τελευταίο έτος';
$string['lastname_firstname'] = '{Επώνυμο} {Όνομα}';
$string['learner_name'] = 'Όνομα μαθητευόμενου';
$string['learner_tf_last_week'] = 'Φίλτρο χρόνου: 7 ημέρες';
$string['learners'] = 'Μαθητευόμενοι';
$string['learners_enrolled'] = 'Εγγεγραμμένοι μαθητευόμενοι';
$string['learners_enrolled_period'] = 'Εκπαιδευόμενοι που έκαναν την εγγραφή τους στην επιλεγμένη περίοδο';
$string['learning'] = 'Μάθηση';
$string['learning_progress'] = 'Πρόοδος μάθησης';
$string['letter'] = 'Γράμμα';
$string['list_view'] = 'Εμφάνιση λίστας';
$string['load'] = 'Απόδοση';
$string['loading'] = 'Φόρτωση...';
$string['loading2'] = 'Παρακαλούμε, περιμένετε, φόρτωση...';
$string['messages'] = 'Μηνύματα';
$string['monthly'] = 'Μηνιαία';
$string['n10'] = 'Ταμπλό Εκπαιδευτή';
$string['n101'] = 'Ενεργοποίηση Ταμπλό Εκπαιδευτή';
$string['name'] = 'Όνομα';
$string['number_of_sessions'] = 'Αριθμός συνόδων';
$string['number_of_visits'] = 'Επίσκεψη/-έψεις';
$string['number_this_week'] = '{$a} αυτή την εβδομάδα';
$string['number_today'] = '{$a} σήμερα';
$string['numberofseats'] = 'Αριθμός θέσεων';
$string['ok'] = 'ΟΚ';
$string['overall_course_average'] = 'συνολικός μέσος όρος μαθημάτων (όλοι οι μαθητές· όλα τα μαθήματα)';
$string['participation'] = 'Συμμετοχή';
$string['passed'] = 'Επιτυχία';
$string['passing_score_for'] = 'Βαθμός επιτυχίας για {$a}';
$string['password'] = 'Κωδικός πρόσβασης';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'Ποσοστό εκπαιδευόμενων που έχουν ολοκληρώσει';
$string['please_accept_terms_and_conditions'] = 'Αποδεχτείτε τους όρους και τις προϋποθέσεις';
$string['powered_by'] = 'Παρέχεται μέσω <a href="https://intelliboard.net/">IntelliBoard.net</a>';
$string['price'] = 'Τιμή';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'Αναγνωριστικό στιγμιότυπου συνδεδεμένου Moodle';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Τύπος στιγμιότυπου Moodle';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Λίστα συμμετεχόντων με συνάντηση συνεργασίας';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Όνομα χρήστη';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Ρόλος συνόδου';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Αναγνωριστικό UUID συνόδου';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Λίστα παρακολουθούμενων συνόδων';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'Αναγνωριστικό καταγραφών παρακολούθησης';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Αναγνωριστικό UUID συνόδου';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Καταγραφή για παρόντες συναντήσεων BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Ώρα σύνδεσης στη συνάντηση';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Ώρα αποσύνδεσης από τη συνάντηση';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Πλήρες όνομα παρόντος συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Σημαιοδότηση. Ο παρόντας έχει συνδέσει το μικρόφωνο';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Σημαιοδότηση. Ο παρόντας έχει συνδεδεμένη βιντεοκάμερα ιστού';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'Αναγνωριστικό παρόντος';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Σημαιοδότηση. Ο παρόντας δεν έχει συνδεδεμένο μικρόφωνο ή βιντεοκάμερα ιστού';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Σημαιοδότηση. Ο παρόντας είναι παρουσιαστής.';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'Αναγνωριστικό συνάντησης (Αναγνωριστικό στον πίνακα local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'Αναγνωριστικό συνάντησης (Αναγνωριστικό στον εξυπηρετητή BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Ρόλος παρόντος συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'Αναγνωριστικό χρήστη (γραμμή στον πίνακα «user» (χρήστης)';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Καταγραφές σχετικά με συναντήσεις BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Ο κωδικός πρόσβασης που θα απαιτηθεί για ένταξη ως παρόντος σε συνάντηση';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'Αναγνωριστικό γραμμής στον πίνακα bigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'Αναγνωριστικό αρθρώματος μαθήματος';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'Αναγνωριστικό μαθήματος';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Δημιουργία ημερομηνίας (συμβολοσειρά)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Δημιουργία ώρας (χρονοσφραγίδα)';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Διάρκεια συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'Αναγνωριστικό καταγραφών συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'Εσωτερικό (σε εξυπηρετητή BBB) αναγνωριστικό συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Αριθμός ακροατών';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Μέγιστος αριθμός συμμετεχόντων';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'Αναγνωριστικό συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Όνομα συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Αριθμός συντονιστών';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'Αναγνωριστικό ιδιοκτήτη (χρήστη που δημιούργησε την συνάντηση)';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Αριθμός παρόντων';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Σημαιοδότηση. Θα γίνει εγγραφή ήχου/βίντεο της συνάντησης.';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Κατάσταση της συνάντησης (ενεργή|σταματημένη)';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Ώρα έναρξης της συνάντησης';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Αριθμός συμμετεχόντων με συνδεδεμένη βιντεοκάμερα';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Αριθμός συμμετεχόντων με συνδεδεμένο μικρόφωνο';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Χρονοσφραγίδα της ημέρας στο έτος';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'Το αναγνωριστικό του πίνακα [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Επισκέψεις, κλικ ποντικιού, ανά ημέρα';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Συνημμένο ειδοποίησης';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Μήνυμα ηλε.ταχυδρομείου ειδοποίησης';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Αναγνωριστικό ειδοποίησης';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Χρονοσφραγίδα της ημέρας στο έτος';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Αναγνωριστικό μαθήματος το οποίο επισκέπτεται ο χρήστης';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Πρώτη πρόσβαση χρήστη';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Τελευταία πρόσβαση χρήστη';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Τύπος σελίδας [μάθημα,άρθρωμα,προφίλ,ιστότοπος]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Τύπος αναγνωριστικού σελίδας';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Τύπος περιηγητή χρήστη';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'Αναγνωριστικό χρήστη που επισκέπτεται την σελίδα Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Η τελευταία διεύθυνση IP του χρήστη';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Γλώσσα περιηγητή χρήστη';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Λειτουργικό σύστημα χρήστη';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Επισκέψεις χρήστη σε μια σελίδα';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Κατάσταση μεταγραφής';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Διεύθυνση ηλε.ταχυδρομείου χρήστη';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'Αναγνωριστικό χρήστη';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Αναγνωριστικό αρθρώματος μαθήματος';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Ημερομηνία ολοκλήρωσης';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Αναγνωριστικό μαθήματος';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Τελικός βαθμός';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Μέγιστος βαθμός';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Ελάχιστος βαθμός';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Αναγνωριστικό αρθρώματος';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Όνομα δραστηριότητας';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Τύπος αρθρώματος';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Ημερομηνία έναρξης';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Κατάσταση';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'Αναγνωριστικό χρήστη';
$string['privacy_policy'] = 'Πολιτική απορρήτου';
$string['product'] = 'Προϊόν';
$string['progress'] = 'Πρόοδος';
$string['protocol'] = 'Πρωτόκολλο';
$string['quiz_finished'] = 'Το κουίζ τελείωσε';
$string['quiz_grades'] = 'Βαθμολογία κουίζ';
$string['quiz_name'] = 'Όνομα κουίζ';
$string['quiz_name_a'] = 'Κουίζ: {$a}';
$string['quizzes'] = 'Κουίζ';
$string['registered'] = 'Καταχωρημένο';
$string['registrations'] = 'Καταχωρήσεις';
$string['report'] = 'Αναφορά';
$string['report1_name'] = 'Κατάσταση χρήστη';
$string['report2_name'] = 'Στατιστικά μαθήματος';
$string['report3_name'] = 'Σύνοψη στατιστικών δραστηριότητας';
$string['report45_name'] = 'Λεπτομέρειες δραστηριότητας κουίζ';
$string['report_activity_stats_summary'] = 'Σύνοψη στατιστικών δραστηριότητας';
$string['report_user_profile_information'] = 'Πληροφορίες προφίλ χρήστη';
$string['reports'] = 'Αναφορές';
$string['rest'] = 'REST';
$string['return_to_courses'] = 'Επιστροφή στα μαθήματα';
$string['return_to_grades'] = 'Επιστροφή στους βαθμούς';
$string['return_to_home'] = 'Επιστροφή στην αρχική';
$string['return_to_sessions'] = 'Επιστροφή στις συνόδους';
$string['review_support_doc'] = 'Εξέταση τεκμηρίωσης υποστήριξης';
$string['role1'] = 'Πρώτος ρόλος';
$string['role2'] = 'Δεύτερος ρόλος';
$string['s25'] = 'Χρόνος στην δραστηριότητα';
$string['s45'] = 'Δραστηριότητα';
$string['s46'] = 'Ποσοστό των μαθητών που προσπαθούν';
$string['s47'] = 'Θέμα';
$string['s48'] = 'Χρόνος στο θέμα';
$string['save'] = 'Αποθήκευση';
$string['scale_percentage'] = 'Ποσοστό';
$string['scale_raw'] = 'Απενεργοποίηση κλίμακας';
$string['scale_real'] = 'Εμφάνιση πραγματικού βαθμού αντί ποσοστού';
$string['scale_total'] = 'Συνολικός βαθμός';
$string['scale_value'] = 'Τιμή';
$string['scales'] = 'Ενεργοποίηση προσαρμοσμένης κλίμακας';
$string['scalesettings'] = 'Ρυθμίσεις κλίμακας';
$string['score'] = 'Βαθμός';
$string['seatnumber'] = 'Αριθμός καθίσματος';
$string['seatscode'] = 'Κωδικός καθίσματος';
$string['seatsused'] = 'Κάθισμα που χρησιμοποιήθηκε';
$string['section'] = 'Τμήμα';
$string['sections'] = 'Τμήματα';
$string['select'] = 'Επιλογή';
$string['select_course'] = 'Επιλογή μαθήματος';
$string['select_date'] = 'Επιλογή ημερομηνίας';
$string['select_quiz'] = 'Επιλέξτε κουίζ';
$string['select_user'] = 'Επιλογή χρήστη';
$string['selectall'] = 'Επιλογή όλων';
$string['server'] = 'Εξυπηρετητής IntelliBoard';
$string['server_au'] = 'IntelliBoard Αυστραλίας';
$string['server_eu'] = 'IntelliBoard Ευρώπης';
$string['server_usa'] = 'IntelliBoard ΗΠΑ';
$string['session_name'] = 'Όνομα συνόδου';
$string['session_time'] = 'Χρόνος συνόδου';
$string['settings'] = 'Ρυθμίσεις';
$string['setup'] = 'Σύνδεση τώρα';
$string['show_dashboard_tab'] = 'Σελίδα ταμπλό';
$string['sign_in'] = 'Σύνδεση';
$string['sign_up'] = 'Εγγραφή';
$string['soap'] = 'SOAP';
$string['sqlreport'] = 'Αναφορά SQL';
$string['sqlreportactive'] = 'Ενεργοποιημένη';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'Δημιουργία αναφοράς';
$string['sqlreportdate'] = 'Δημιουργήθηκε στις';
$string['sqlreportinactive'] = 'Απενεργοποιημένη';
$string['sqlreportname'] = 'Όνομα αναφοράς';
$string['sqlreports'] = 'Αναφορές SQL';
$string['sso'] = 'Σύνδεσμος SSO';
$string['sso_desc'] = 'Σύνδεσμος SSO προς το IntelliBoard.net';
$string['ssodomain'] = 'SSO υποτομέας';
$string['status'] = 'Κατάσταση';
$string['support'] = 'Υποστήριξη';
$string['support_close'] = 'Κλείσιμο';
$string['support_demo'] = 'Χρονοπρογραμματισμός ενός δοκιμαστικού';
$string['support_terms'] = 'Με επιφύλαξη παντός δικαιώματος.';
$string['t1'] = 'Ενεργοποίηση Ταμπλό Μαθητή';
$string['t16'] = 'Ενεργοποίηση διδάσκοντα μαθήματος';
$string['t17'] = 'Ενεργοποίηση κατηγορίας μαθήματος';
$string['t18'] = 'Ενεργοποίηση ολοκλήρωση μαθήματος';
$string['t19'] = 'Ενεργοποίηση βαθμού μαθήματος';
$string['t2'] = 'Ενεργοποίηση Ταμπλό';
$string['t20'] = 'Ενεργοποίηση μέσου όρου τάξης μαθήματος';
$string['t21'] = 'Ενεργοποίηση χρόνου παρακολούθησης μαθήματος';
$string['t22'] = 'Ενεργοποίηση ημερομηνίας έναρξης μαθήματος';
$string['t23'] = 'Ενεργοποίηση στήλης [Ημερομηνία έναρξης μαθήματος]';
$string['t24'] = 'Ενεργοποίηση στήλης [Ημερομηνία εγγραφής]';
$string['t3'] = 'Ενεργοποίηση μαθημάτων';
$string['table_set_iag'] = 'Μάθημα εκπαιδευτή > Δραστηριότητες';
$string['table_set_iag1'] = 'Μάθημα εκπαιδευτή > Δραστηριότητες > Βαθμοί';
$string['table_set_iag1_c1'] = 'Όνομα μαθητευόμενου';
$string['table_set_iag1_c2'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['table_set_iag1_c3'] = 'Κατάσταση';
$string['table_set_iag1_c4'] = 'Βαθμός';
$string['table_set_iag1_c5'] = 'Βαθμολογήθηκε';
$string['table_set_iag1_c6'] = 'Επισκέψεις';
$string['table_set_iag1_c7'] = 'Χρόνος που χρησιμοποιήθηκε';
$string['table_set_iag_c1'] = 'Όνομα δραστηριότητας';
$string['table_set_iag_c2'] = 'Τύπος';
$string['table_set_iag_c3'] = 'Μαθητευόμενοι που ολοκλήρωσαν';
$string['table_set_iag_c4'] = 'Μέσος βαθμός';
$string['table_set_iag_c5'] = 'Επισκέψεις';
$string['table_set_iag_c6'] = 'Χρόνος που χρησιμοποιήθηκε';
$string['table_set_iag_c7'] = 'Ενέργειες';
$string['table_set_icg'] = 'Μαθήματα εκπαιδευτή';
$string['table_set_icg_c1'] = 'Όνομα μαθήματος';
$string['table_set_icg_c11'] = 'Ενέργειες - Δραστηριότητες';
$string['table_set_icg_c12'] = 'Ενέργειες - Μαθητευόμενοι';
$string['table_set_icg_c2'] = 'Σύντομο όνομα';
$string['table_set_icg_c3'] = 'Κατηγορία';
$string['table_set_icg_c4'] = 'Μαθητευόμενοι που έκαναν εγγραφή/που ολοκλήρωσαν';
$string['table_set_icg_c5'] = 'Μέσος όρος βαθμών μαθήματος';
$string['table_set_icg_c6'] = 'Τμήματα';
$string['table_set_icg_c7'] = 'Δραστηριότητες/Πόροι';
$string['table_set_icg_c8'] = 'Επισκέψεις';
$string['table_set_icg_c9'] = 'Χρόνος που χρησιμοποιήθηκε';
$string['table_set_ilg'] = 'Μαθήματα εκπαιδευτή > Εκπαιδευόμενοι';
$string['table_set_ilg1'] = 'Μαθήματα εκπαιδευτή > Εκπαιδευόμενοι > Βαθμοί';
$string['table_set_ilg1_c1'] = 'Όνομα δραστηριότητας';
$string['table_set_ilg1_c2'] = 'Τύπος';
$string['table_set_ilg1_c3'] = 'Βαθμός';
$string['table_set_ilg1_c4'] = 'Βαθμολογήθηκε';
$string['table_set_ilg1_c5'] = 'Κατάσταση';
$string['table_set_ilg1_c6'] = 'Επισκέψεις';
$string['table_set_ilg1_c7'] = 'Χρόνος που χρησιμοποιήθηκε';
$string['table_set_ilg_c1'] = 'Όνομα μαθητευόμενου';
$string['table_set_ilg_c10'] = 'Ενέργειες';
$string['table_set_ilg_c2'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['table_set_ilg_c3'] = 'Εγγεγραμμένος';
$string['table_set_ilg_c4'] = 'Τελευταία πρόσβαση';
$string['table_set_ilg_c5'] = 'Κατάσταση';
$string['table_set_ilg_c6'] = 'Βαθμός';
$string['table_set_ilg_c7'] = 'Ολοκληρωμένες Δραστηριότητες/Πόροι';
$string['table_set_ilg_c8'] = 'Επισκέψεις';
$string['table_set_ilg_c9'] = 'Χρόνος που χρησιμοποιήθηκε';
$string['te1'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['te12'] = 'Μικρό/Βαπτιστικό όνομα';
$string['te13'] = 'Επώνυμο';
$string['te1_desc'] = 'Εισάγετε τη διεύθυνση ηλε.ταχυδρομείου που χρησιμοποιείται με τη συνδρομή IntelliBoard.net. Αν δεν έχετε ενεργή συνδρομή, εγγραφείτε στο <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a>. Τα Ταμπλό Μαθητή και Εκπαιδευτή είναι διαθέσιμα με συνδρομή Επιπέδου 4 και άνω.';
$string['teacher'] = 'Διδάσκων';
$string['telephone1'] = 'Τηλέφωνο 1';
$string['telephone2'] = 'Τηλέφωνο 2';
$string['term_of_use'] = 'Όροι χρήσης';
$string['terms_msg'] = 'Επιλέγοντας αυτό το κουτάκι επιλογής, επιβεβαιώνετε ότι έχετε διαβάσει και αποδέχεστε τους Όρους Χρήσης.';
$string['tex1'] = 'Το Ταμπλό Μαθητή IntelliBoard δεν είναι ενεργοποιημένο.';
$string['this_year'] = 'Αυτό το έτος';
$string['time'] = 'Ώρα';
$string['time_1'] = 'Πρωί';
$string['time_2'] = 'Μεσημέρι';
$string['time_3'] = 'Απόγευμα';
$string['time_4'] = 'Εκτός ωρών';
$string['time_period_due'] = 'Χρονική περίοδος (Ημερομηνία λήξης)';
$string['time_spent'] = 'Ώρα που πέρασε';
$string['timespent'] = '------ Ώρα που πέρασε ----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Σύνθετες ρυθμίσεις: TLS v1.2';
$string['topics'] = 'Θέματα';
$string['total'] = 'Σύνολο';
$string['total_activities_resources'] = 'Σύνολο Δραστηριοτήτων/Πόρων';
$string['total_numbers'] = 'Ημερομηνία: {$a->timepoint}, Σύνοδοι: {$a->sessions}, Επισκέψεις: {$a->visits},  Χρόνος που χρειάστηκε: {$a->timespend}';
$string['total_numbers2'] = 'ΧΡΗΣΤΗΣ: {$a->userid}, Σελίδα: {$a->page}, Παράμετρος:{$a->param}, Επισκέψεις: {$a->visits},  Χρόνος που χρειάστηκε: {$a->timespend}';
$string['total_numbers3'] = '----Ημερομηνία: {$a->timecreated}, Αναγνωριστικό κομματιού: {$a->trackid}, Επισκέψεις: {$a->visits},  Χρόνος που χρειάστηκε: {$a->timespend}';
$string['total_time_spent'] = 'Συνολικός χρόνος που χρειάστηκε';
$string['total_time_spent_enrolled_learners'] = 'Συνολικός χρόνος που χρειάστηκε στους Εγγεγραμμένους Εκπαιδευόμενους στο Μάθημα';
$string['total_values_include'] = 'Οι συνολικές τιμές περιλαμβάνουν μοναδικές συνεδρίες, μαθήματα, επισκέψεις, χρόνο που αφιερώνεται.';
$string['total_visits_enrolled_learners'] = 'Συνολικές Επισκέψεις από Εγγεγραμμένους Εκπαιδευόμενους στο Μάθημα';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'Παρακολούθηση διαχειριστών';
$string['trackadmin_desc'] = 'Ενεργοποίηση παρακολούθησης χρόνου για χρήστες διαχειριστή (δεν συνιστάται)';
$string['trackdetails'] = 'Παρακολούθηση χρόνου ανά χρήστη - Ωριαία';
$string['tracking'] = 'Παρακολούθηση συνόδου';
$string['tracking_title'] = 'Παρακολούθηση χρόνου';
$string['tracklogs'] = 'Παρακολούθηση χρόνου ανά χρήστη - Καθημερινά';
$string['trackmedia'] = 'Παρακολούθηση πολυμέσων HTML5';
$string['trackmedia_desc'] = 'Παρακολούθηση βίντεο και ήχου HTML5';
$string['tracktotals'] = 'Συνάθροιση χρόνου παρακολούθησης - Καθημερινά';
$string['transcripts'] = 'Μεταγραφές';
$string['transcriptssyncrecordsnum'] = 'Μέγεθος επεξεργασίας μεταγραφών';
$string['transcriptssyncrecordsnum_desc'] = 'Ο αριθμός εγγραφών εγγραφής χρηστών που θα υποβληθούν σε επεξεργασία κάθε φορά';
$string['ts1'] = 'Ταμπλό Μαθητή';
$string['ts2'] = 'Σελίδα Ταμπλό Μαθητή';
$string['ts3'] = 'Μαθήματα Ταμπλό Μαθητή';
$string['ts4'] = 'Βαθμοί Ταμπλό Μαθητή';
$string['ts5'] = 'Αναφορές Ταμπλό Μαθητή';
$string['type'] = 'Τύπος';
$string['type_here'] = 'Πληκτρολογήστε εδώ...';
$string['used'] = 'Χρησιμοποιούμενο';
$string['user_enrollments_sessions_completion'] = 'Εγγραφή χρήστη, Σύνοδος, Επίπεδα δραστηριότητας ολοκλήρωσης';
$string['user_enrolments'] = 'Εγγραφές χρηστών';
$string['user_grade_avg'] = '{$a->user} βαθμός: {$a->grade}, Μέσος βαθμός: {$a->avg_grade_site})';
$string['user_map'] = 'Χάρτης χρήστη';
$string['user_site_summary_detail'] = 'Λεπτομέρειες περίληψης ιστότοπου χρήστη';
$string['user_time_avg'] = '{$a->user} ώρα: {$a->timespend}, Μέσος χρόνος: {$a->avg_timespend_site}';
$string['user_visit_avg'] = '{$a->user} επισκέψεις: {$a->visits}, Μέσος όρος επισκέψεων: {$a->avg_visits_site}';
$string['username'] = 'Όνομα χρήστη';
$string['users'] = 'Χρήστες';
$string['users_activity'] = 'Δραστηριότητα χρηστών';
$string['users_overview'] = 'Επισκόπηση χρηστών';
$string['view_course_details'] = 'Δείτε λεπτομέρειες μαθήματος';
$string['viewed'] = 'Εμφανίστηκε/-αν';
$string['visits'] = 'Επισκέψεις';
$string['weekday_0'] = 'Δευτέρα';
$string['weekday_1'] = 'Τρίτη';
$string['weekday_2'] = 'Τετάρτη';
$string['weekday_3'] = 'Πέμπτη';
$string['weekday_4'] = 'Παρασκευή';
$string['weekday_5'] = 'Σάββατο';
$string['weekday_6'] = 'Κυριακή';
$string['weekly'] = 'Τελευταίες 90 ημέρες';
$string['widget_name27'] = 'Αθροιστικές εγγραφές';
$string['widget_name28'] = 'Σύμπλεξη';
$string['widget_name29'] = 'Μοναδικές συνδέσεις';
$string['widget_name30'] = 'Εγγραφές ανά μάθημα';
$string['x_completions'] = '{$a} Ολοκληρώσεις';
$string['you_have_certificates'] = 'Έχετε {$a} πιστοποιητικά';
$string['you_need_to_enable_at_least_one_protocol'] = 'Πρέπει να ενεργοποιήσετε τουλάχιστον ένα πρωτόκολλο';
