<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'et', version '3.8'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Uut Active Directory kasutajakontot ei saa luua. Veenduge, et kõik toimimiseks vajalikud nõuded (LDAPS-ühendus, kirjutusõigustega LDAP-kasutaja jms) oleksid täidetud.';
$string['auth_ldap_attrcreators'] = 'Loend rühmadest või kontekstidest, mille liikmetel on lubatud atribuute luua. Eralda rühmad sümboliga \';\'. Näiteks \'cn=teachers,ou=staff,o=myorg\\';
$string['auth_ldap_attrcreators_key'] = 'Atribuudi loojad';
$string['auth_ldap_auth_user_create_key'] = 'Loo kasutajad väliselt';
$string['auth_ldap_bind_dn'] = 'Kui soovite kasutajaid otsida LDAP kasutaja abil, määrake see siin. Nt \'cn=ldapuser,ou=public,o=org\\';
$string['auth_ldap_bind_dn_key'] = 'Eristusnimi';
$string['auth_ldap_bind_pw'] = 'LDAP kasutaja parool.';
$string['auth_ldap_bind_pw_key'] = 'Parool';
$string['auth_ldap_bind_settings'] = 'LDAP kasutaja sätted';
$string['auth_ldap_changepasswordurl_key'] = 'Parooli muutmise URL';
$string['auth_ldap_contexts'] = 'Loend kontekstidest, kust kasutajaid otsitakse. Eraldage erinevad kontekstid semikooloniga \';\'. Näiteks: \'ou=users,o=org; ou=others,o=org\\';
$string['auth_ldap_contexts_key'] = 'Kontekstid';
$string['auth_ldap_create_context'] = 'Kui lubate kasutajate loomise e-posti teel kinnitamisega, määrake kontekst, kus kasutajaid luuakse. Turbeprobleemide ärahoidmiseks peaks see kontekst erinema teiste kasutajate omast. Seda konteksti pole vaja lisada muutujale ldap_context, Moodle otsib sellest kontekstist kasutajaid automaatselt.<br /><b>Tähelepanu!</b>Kasutajate loomise toimimiseks peate failis auth/ldap/lib.php. muutma meetodit user_create().';
$string['auth_ldap_create_context_key'] = 'Uutele kasutajatele mõeldud kontekst';
$string['auth_ldap_create_error'] = 'LDAP kasutaja loomisel ilmnes tõrge.';
$string['auth_ldap_expiration_desc'] = 'Valige Ei, kui soovite keelata aegunud paroolide kontrolli või LDAP-l lugeda paroolide aegumise aega otse LDAP-st.';
$string['auth_ldap_expiration_key'] = 'Aegumine';
$string['auth_ldap_expiration_warning_desc'] = 'Päevade arv, pärast mida kuvatakse parooli aegumise hoiatus.';
$string['auth_ldap_expiration_warning_key'] = 'Aegumishoiatus';
$string['auth_ldap_expireattr_desc'] = 'Valikuline: alistab LDAP-atribuudi, mis määrab parooli aegumisaja.';
$string['auth_ldap_expireattr_key'] = 'Aegumisatribuut';
$string['auth_ldap_graceattr_desc'] = 'Valikuline: alistab ajapikendusega sisselogimise atribuudi';
$string['auth_ldap_gracelogin_key'] = 'Ajapikendusega sisselogimise atribuut';
$string['auth_ldap_gracelogins_desc'] = 'Saate lubada LDAP ajapikendusega sisselogimise toe. Pärast parooli aegumist saab kasutaja õpikeskkonda siseneda seni, kuni sisselogimiseks eraldatud aja loenduri väärtuseks saab 0. Kui see säte on lubatud, kuvatakse parooli aegumisel ajapikendusega sisselogimise teade.';
$string['auth_ldap_gracelogins_key'] = 'Ajapikendusega sisselogimised';
$string['auth_ldap_groupecreators'] = 'Loend rühmadest või kontekstidest, mille liikmetel on lubatud rühmi luua. Eralda rühmad sümboliga \';\'. Näiteks \'cn=teachers,ou=staff,o=myorg\\';
$string['auth_ldap_groupecreators_key'] = 'Rühma loojad';
$string['auth_ldap_host_url'] = 'Määrake LDAP-host URL-vormingus, nt „ldap://ldap.myorg.com/“ või „ldaps://ldap.myorg.com/“. Rikkeümberlülitustoe tagamiseks eraldage serverid semikooloniga (;).';
$string['auth_ldap_host_url_key'] = 'Hosti URL';
$string['auth_ldap_ldap_encoding'] = 'Saate määrata kodeeringu, mida LDAP-server kasutab. Kõige tõenäolisemalt on see utf-8, MS AD v2 kasutab platvormi vaikekodeeringut, nt cp1252, cp1250 jne.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP kodeering';
$string['auth_ldap_login_settings'] = 'Sisenemise seaded';
$string['auth_ldap_memberattribute'] = 'Valikuline: alistab kasutaja liikmesuse atribuudi (tavaliselt \'member\'), mis näitab kasutajate rühmakuuluvust.';
$string['auth_ldap_memberattribute_isdn'] = 'Valikuline: alistab liikmesusatribuudi väärtuste käsitsemise, kas 0 või 1.';
$string['auth_ldap_memberattribute_isdn_key'] = 'Liikmesuse atribuut kasutab dn-i';
$string['auth_ldap_memberattribute_key'] = 'Liikmesuse atribuut';
$string['auth_ldap_no_mbstring'] = 'Kasutajate loomiseks Active Directorys on teil vaja laiendust mbstring.';
$string['auth_ldap_noconnect'] = 'LDAP moodul ei saa ühenduda serveriga: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-moodul ei saa ühegagi neist serveritest ühendust luua: {$a}';
$string['auth_ldap_noextension'] = '<em>Paistab, et PHP LDAP-moodulit pole. Kui soovite kasutada seda autentimislisandmoodulit, veenduge, et see oleks installitud ja lubatud.</em>';
$string['auth_ldap_objectclass'] = 'Valikuline: alistab objektiklassi (objectClass), mida kasutatakse kasutajate nimetamiseks/otsimiseks parameetris ldap_user_type. Tavaliselt ei pea te seda muutma.';
$string['auth_ldap_objectclass_key'] = 'Objekti klass';
$string['auth_ldap_opt_deref'] = 'Määrab, kuidas otsingu ajal aliaseid kasutatakse. Valige üks järgnevatest väärtustest: „Ei“ (LDAP_DEREF_NEVER) või „Jah“ (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Tühista aliaste suunamine';
$string['auth_ldap_passtype'] = 'Saate LDAP-serveris määrata uute või muudetud paroolide vormingu.';
$string['auth_ldap_passtype_key'] = 'Parooli vorming';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP parooli aegumise sätted';
$string['auth_ldap_preventpassindb'] = 'Valige väärtus Jah, kui soovite, et paroole Moodle’i andmebaasis ei säilitataks.';
$string['auth_ldap_preventpassindb_key'] = 'Takista paroolide vahemällu salvestamist';
$string['auth_ldap_rolecontext'] = '{$a->localname} kontekst';
$string['auth_ldap_rolecontext_help'] = '"cn={$a->shortname},ou=staff,o=myorg".<i>{$a-> localname} </i> kaardistamiseks valitud LDAP-kontekst. Eraldage mitu rühma numbriga ";". Tavaliselt on midagi sellist nagu "cn={$a->shortname},ou=staff,o=myorg".';
$string['auth_ldap_search_sub'] = 'Kasutajaid saab otsida alamkontekstidest.';
$string['auth_ldap_search_sub_key'] = 'Otsi alamkontekste';
$string['auth_ldap_server_settings'] = 'LDAP-serveri sätted';
$string['auth_ldap_suspended_attribute'] = 'Valikuline: Olemasolu korral kasutatakse seda atribuuti kohalikult loodud kasutajakontode lubamiseks ja peatamiseks.';
$string['auth_ldap_suspended_attribute_key'] = 'Peatatud atribuut';
$string['auth_ldap_unsupportedusertype'] = 'auth: LDAP user_create() ei toeta valitud kasutajatüüpi: {$a}';
$string['auth_ldap_update_userinfo'] = 'Uuenda kasutajainfot (eesnimi, perekonnanimi, aadress,..) LDAP-ist Moodle\'isse. Vaata /auth/ldap/attr_mappings.php andmete vastendamise kohta info saamiseks.';
$string['auth_ldap_user_attribute'] = 'Valikuline: tühistab atribuudi (tavaliselt \'cn\'), mida kasutatakse kasutajate nimetamiseks/otsimiseks.';
$string['auth_ldap_user_attribute_key'] = 'Kasutaja atribuut';
$string['auth_ldap_user_exists'] = 'LDAP kasutajanimi on juba olemas.';
$string['auth_ldap_user_settings'] = 'Kasutajaotsingu sätted';
$string['auth_ldap_user_type'] = 'Valige, kuidas kasutajad LDAP-s talletatakse. Selle sättega saab määrata, kuidas toimib sisenemise aegumine, ajapikendusega sisenemine ja kasutajate loomine.';
$string['auth_ldap_user_type_key'] = 'Kasutaja tüüp';
$string['auth_ldap_usertypeundefined'] = 'config.user_type on määratlemata või funktsioon ldap_expirationtime2unix ei toeta valitud tüüpi.';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type on määratlemata või funktsioon ldap_unixi2expirationtime ei toeta valitud tüüpi.';
$string['auth_ldap_version'] = 'Teie serveri LDAP protokolli versioon.';
$string['auth_ldap_version_key'] = 'Versioon';
$string['auth_ldapdescription'] = 'Selle meetodi korral kasutatakse autentimiseks välist LDAP-serverit.
                                  Kui sisestatud kasutajanimi ja parool sobivad, loob Moodle oma
                                  andmebaasis uue kasutajakirje. See moodul oskab LDAP-serverist lugeda kasutaja atribuute
                                  ja eeltäita soovitud väljad Moodle’is.  Edaspidi kontrollitakse sisselogimise korral
                                  ainult kasutajanime ja parooli.';
$string['auth_ldapextrafields'] = 'Nende väljade täitmine on valikuline. Kui soovite, et mõni Moodle’i kasutajaväli eeltäidetaks <b>LDAP väljadelt</b> pärit teabega, siis määrake vastavad LDAP väljad siin. <p>Kui jätate need väljad tühjaks, ei kanta LDAP-st midagi üle ja kasutatakse Moodle’i vaikesätteid.</p><p>Mõlemal juhul saab kasutaja pärast õpikeskkonda sisselogimist muuta kõiki välju.</p>';
$string['auth_ldapnotinstalled'] = 'LDAP-autentimist ei saa kasutada. PHP LDAP laiendus on installimata.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'NTLM domeeniga ühekordseks sisselogimiseks (SSO) valige väärtus Jah. <strong>Märkus.</strong> Selle toimima saamiseks on vaja lisaks seadistada veebiserver. Vt <a href="http://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>';
$string['auth_ntlmsso_enabled_key'] = 'Luba';
$string['auth_ntlmsso_ie_fastpath'] = 'Lubage NTLM SSO kiirtee (jätab teatud toimingud vahele, kui kliendi brauser on MS Internet Explorer).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Proovi NTML-i kõikide brauseritega';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE kiirtee?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Jah, proovi NTML-i muid brausereid';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Jah, kõik ülejäänud brauserid kasutavad standardset sisselogimisvormi';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Kasutajanime ei saanud päisest REMOTE_USER ekstraktida. Kas konfigureeritud vorming on õige?';
$string['auth_ntlmsso_missing_username'] = 'Peate kaugkasutajanime vormingus määrama vähemalt parameetri %username%';
$string['auth_ntlmsso_remoteuserformat'] = 'Kui olete autentimise tüübiks valinud NTLM-i, saate kaugkasutajanime vormingu määrata siin. Kui jätate selle välja tühjaks, siis kasutatakse vaikevormingut DOMAIN\\username. Saate kasutada valikulist kohatäidet <b>%domain%</b>, et määrata, kus domeeninimi kuvatakse, ja kohustuslikku kohatäidet <b>%username%</b>, et määrata, kus kasutajanimi kuvatakse. <br /><br />Mõned levinud vormingud on <tt>%domain%%username%</tt> (MS Windowsi vaikevorming), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> ja lihtsalt <tt>%username%</tt> (kui domeeniosa pole).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Kaugkasutajanime vorming';
$string['auth_ntlmsso_subnet'] = 'Kui see on määratud, proovitakse SSO-d ainult selle alamvõrgu klientidega. Vorming: xxx.xxx.xxx.xxx/bitmask. Eraldage alamvõrgud komaga (\',\').';
$string['auth_ntlmsso_subnet_key'] = 'Alamvõrk';
$string['auth_ntlmsso_type'] = 'Veebiserveris kasutajate autentimiseks konfigureeritud autentimisviis (kahtluse korral valige NTLM)';
$string['auth_ntlmsso_type_key'] = 'Autentimise tüüp';
$string['cannotmaprole'] = 'Rolli "{$a->rolename}"  ei saa kaardistada, kuna selle lühinimi "{$a->shortname}" on liiga pikk ja / või sisaldab sidekriipsusid. Selle kaardistamiseks tuleb lühendada maksimaalselt {$a-> charlimit} tähemärki ja eemaldada sidekriipsud. <a href="{$a->link} ">Muutke rolli</a>';
$string['connectingldap'] = 'LDAP-serveriga ühenduse loomine...';
$string['connectingldapsuccess'] = 'Teie LDAP-serveriga on nüüd ühendus loodud.';
$string['creatingtemptable'] = 'Ajutise tabeli {$a} loomine';
$string['diag_contextnotfound'] = 'Konteksti {$a} pole olemas või seda ei saa siduva DN abil lugeda.';
$string['diag_emptycontext'] = 'Leitud tühi kontekst';
$string['diag_genericerror'] = 'LDAP viga {$a->code} lugedes {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Rühma {$a->group} rolli {$a->localname} jaoks pole olemas või seda ei saa siduva DN abil lugeda.';
$string['diag_toooldversion'] = 'On väga ebatõenäoline, et kaasaegne LDAP-server kasutab LDAPv2-protokolli. Valed sätted võivad kasutajaväljadel väärtusi rikkuda. Pöördu oma LDAP administraatori poole.';
$string['didntfindexpiretime'] = 'password_expire () ei leidnud aegumisaega.';
$string['didntgetusersfromldap'] = 'LDAP-ist ei toodud ühtegi kasutajat -- tõrge? -- väljumine';
$string['gotcountrecordsfromldap'] = 'LDAP-st saadi {$a} kirjet';
$string['ldapnotconfigured'] = 'LDAP hosti URL pole praegu konfigureeritud.';
$string['morethanoneuser'] = 'Veider lugu! LDAP-st leiti rohkem kui üks kasutajakirje. Kasutatakse esimest.';
$string['needbcmath'] = 'Ajapikendusega sisselogimiste kasutamiseks koos Active Directoryga on teil vaja laiendit BCMath';
$string['needmbstring'] = 'Active Directorys paroolide muutmiseks on teil vaja laiendit mbstring';
$string['nodnforusername'] = 'user_update_password(): tõrge. Järgmise üksuse jaoks pole domeeninime: {$a->username}';
$string['noemail'] = 'Teile prooviti saata meilisõnumit, kuid saatmine nurjus.';
$string['notcalledfromserver'] = 'Ei tohiks kutsuda veebiserverist!';
$string['noupdatestobedone'] = 'Värskendusi pole';
$string['nouserentriestoremove'] = 'Eemaldatavaid kasutajakirjeid pole.';
$string['nouserentriestorevive'] = 'Taastatavaid kasutaja sissekandeid pole';
$string['nouserstobeadded'] = 'Lisatavaid kasutajakirjeid pole';
$string['ntlmsso_attempting'] = 'Ühekordse sisselogimise (Single Sign On) katse NTLM-i kaudu';
$string['ntlmsso_failed'] = 'Automaatne sisselogimine nurjus, proovige sisse logida tavapärasel viisil...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO on keelatud.';
$string['ntlmsso_unknowntype'] = 'Tundmatu NTLM SSO tüüp!';
$string['pagedresultsnotsupp'] = 'LDAP-i lehekülgedeks jagatud tulemeid ei toetata (teie PHP versiooni ei toetata või olete konfigureerinud Moodle’i kasutama LDAP-protokolli versiooni 2 või Moodle ei saa teie LDAP-serveriga ühendust luua, et kontrollida, kas lehekülgedeks jaotatud tulemite tugi on saadaval).';
$string['pagesize'] = 'See väärtus peab olema väiksem, kui LDAP-serveri tulemuste limiit (maksimumarv tulemusi, mis ühe päringuga saadakse).';
$string['pagesize_key'] = 'Lehekülje suurus';
$string['pluginname'] = 'LDAP-server';
$string['pluginnotenabled'] = 'Lisandmoodul pole lubatud.';
$string['privacy:metadata'] = 'LDAP serveri autentimisplugin ei salvesta isiklikku informatsiooni.';
$string['renamingnotallowed'] = 'LDAP-s pole kasutaja ümbernimetamine lubatud';
$string['rootdseerror'] = 'Tõrge Active Directory rootDSE päringus';
$string['start_tls'] = 'Kasuta tavapärast LDAP-teenust (port 389) koos TLS-krüptimisega';
$string['start_tls_key'] = 'Kasuta TLS-protokolli';
$string['syncroles'] = 'Sünkroniseeri rollid LDAPist';
$string['synctask'] = 'LDAP-i kasutajate sünkroonimistöö';
$string['systemrolemapping'] = 'Süsteemi rolli kaardistamine';
$string['updatepasserror'] = 'user_update_password(): tõrge. Tõrkekood: {$a->errno}; Tõrkestring: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Parooli aegumise aja lugemisel ilmnes tõrge parameetris user_update_password(). Tõrkekood: {$a->errno}; Tõrkestring: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Stringi user_update_password() tõrge aegumiskellaaja ja/või ajapikendusega sisselogimiste muutmisel. Tõrkekood: {$a->errno}; Tõrkestring: {$a->errstring}';
$string['updateremfail'] = 'LDAP-i kirje värskendamise tõrge. Tõrkekood: {$a->errno}; Tõrkestring: {$a->errstring}<br/>Võti ({$a->key}) - vana moodle’i väärtus: \'{$a->ouvalue}\' uus väärtus: \'{$a->nuvalue}';
$string['updateremfailamb'] = 'Ei saanud uuendada LDAP-i hägusa välja {$a->key} tõttu; vana moodle’i väärtus: \'{$a->ouvalue}\', uus väärtus: \'{$a->nuvalue}\\';
$string['updateremfailfield'] = 'LDAP värskendamine olematu väljaga (\'{$a->ldapkey}\') nurjus. Klahv ({$a->key}) - vana Moodle\'i väärtus: \'{$a->ouvalue}\' uus väärtus: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Kasutajateabe värskendamisel ei leitud välist kasutajat. Üksikasjalik teave: otsingu lähtekoht: \'{$a->userdn}\'; otsingufilter: \'(objectClass=*)\'; otsingu atribuudid: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: LDAP user_activate() ei toeta valitud kasutajatüüpi: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ei toeta valitud kasutajatüüpi: {$a}';
$string['useracctctrlerror'] = 'Tõrge parameetri userAccountControl hankimisel {$a} kohta';
$string['userentriestoadd'] = 'Lisatavad kasutaja sissekanded: {$a}';
$string['userentriestoremove'] = 'Eemaldatavad kasutaja sissekanded: {$a}';
$string['userentriestorevive'] = 'Taastatavad kasutaja sissekanded: {$a}';
$string['userentriestoupdate'] = 'Värskendatavad kasutaja sissekanded: {$a}';
$string['usernotfound'] = 'Kasutajat ei leitud LDAP-st';
