<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'et', version '3.8'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'Hüljatud';
$string['abandonhotpot'] = 'Teie senised tulemused salvestatakse, kuid te ei saa seda tegevust hiljem uuesti alustada ega jätkata.';
$string['activitycloses'] = 'Tegevus suletakse';
$string['activitygrade'] = 'Tegevuse hinne';
$string['activityopens'] = 'Tegevus avatakse';
$string['added'] = 'Lisatud';
$string['addquizchain'] = 'Lisa testide ahel';
$string['addquizchain_help'] = 'Kas kõik testid testide ahelas peavad olema lisatud?

** Ei**
: ainult üks test võib olla kursusel lisatud

**Jah**
: kui lähtefail on **testi fail**, on see näidatud testide ahela alguses ja kõik selle ahela testid lisatakse kursusele koos identsete sätetega. Ahela igal testil peab olema link järgmisele failile ahelas.

Kui lähtefail on **kaust**, siis kõik äratuntavad testid selles kaustas lisatakse kursusele, et moodustuks ühesuguste sätetega testide ahel.

Kui lähtefail on **õppetükifail**, nagu Hot Potatoes Masheri fail või index.html, siis õpitükifailis olevad testid lisatakse kursusse identsete sätetega testidena.';
$string['allowpaste'] = 'Luba kleepimine';
$string['allowpaste_help'] = 'Kui see säte on lubatud, siis võivad õppijad teksti kopeerida, kleepida ja pukseerida tekstisisestusväljadele.';
$string['allowreview'] = 'Luba läbivaatus';
$string['allowreview_help'] = 'Kui see säte on lubatud, siis saavad õppijad oma soorituskatsed pärast testi sulgemist läbi vaadata.';
$string['analysisreport'] = 'Analüüsiaruanne';
$string['attempted'] = 'Mõni soorituskatse on juba tehtud';
$string['attemptlimit'] = 'Soorituskatsete piirarv';
$string['attemptlimit_help'] = 'Maksimaalne arv soorituskatseid, mida õppija võib selles HotPot-tegevuses teha';
$string['attemptnumber'] = 'Soorituskatse number';
$string['attempts'] = 'Soorituskatsed';
$string['attemptscore'] = 'Soorituskatse punktisumma';
$string['attemptsunlimited'] = 'Piiramatu arv soorituskatseid';
$string['average'] = 'Keskmine';
$string['averagescore'] = 'Keskmine punktisumma';
$string['bodystyles'] = 'Sisu laadid';
$string['bodystylesbackground'] = 'Taustavärv ja -pilt';
$string['bodystylescolor'] = 'Teksti värv';
$string['bodystylesfont'] = 'Fondi suurus ja pere';
$string['bodystylesmargin'] = 'Vasak- ja paremveeris';
$string['cacherecords'] = 'HotPoti vahemälu kirjed';
$string['canrestarthotpot'] = 'Teie senised tulemused salvestatakse ja saate testi „{$a}“ hiljem uuesti teha.';
$string['canresumehotpot'] = 'Teie senised tulemused salvestatakse ja saate testi „{$a}“ hiljem jätkata.';
$string['checks'] = 'Kontrollid';
$string['checksomeboxes'] = 'Märkige mõni ruut';
$string['clearcache'] = 'Puhasta HotPoti vahemälu';
$string['cleardetails'] = 'Eemalda HotPoti üksikasjad';
$string['clearedcache'] = 'HotPoti vahemälu on tühjendatud';
$string['cleareddetails'] = 'HotPoti üksikasjad on eemaldatud';
$string['clickreporting'] = 'Luba klõpsamisaruandlus';
$string['clickreporting_help'] = 'Kui see säte on lubatud, siis peetakse eraldi arvestust nuppude „Vihje“, „Näpunäide“ ja „Kontrolli“ klõpsamise kohta. See võimaldab õpetajal pärast iga klõpsamist saada testi oleku kohta üksikasjaliku ülevaate. Muul juhul säilitatakse üks kirje iga soorituskatse kohta.';
$string['clicktrailreport'] = 'Klõpsamisjäljed';
$string['closed'] = 'See tegevus on suletud.';
$string['clues'] = 'Näpunäited';
$string['completed'] = 'Lõpetatud';
$string['completioncompleted'] = 'Nõua lõpuleviimist';
$string['completionmingrade'] = 'Nõua miinimumhinnet';
$string['completionpass'] = 'Nõua läbimiseks vajalikku hinnet';
$string['completionwarning'] = 'Need väljad pole saadaval, kui selle tegevuse hindelimiit on „Hinnet pole“ või kui hinde kaalumiseks on määratud „Kaalumist pole“.';
$string['configbodystyles'] = 'Moodle’i kujunduslaadid kirjutavad HotPoti tegevuste laadid vaikimisi üle. Kuid kõigi siin valitud laadide puhul on HotPoti tegevuste laadid Moodle’i kujunduslaadide suhtes ülimuslikud.';
$string['configenablecache'] = 'HotPoti testide hoidmine vahemälus aitab tunduvalt kiirendada testide õppijate jaoks ettevalmistamist.';
$string['configenablecron'] = 'Määrake aeg, millal HotPot croni skript peaks töötama (teie ajavööndi järgi).';
$string['configenablemymoodle'] = 'Selle sättega määratakse, kas HotPoti testid kuvatakse lehel „Minu Moodle“ (MyMoodle) või mitte';
$string['configenableobfuscate'] = 'Javascripti koodis tekststringide ja URL-ide sogastamine muudab brauseris HTML-lehe lähtekoodi põhjal vastuste äraarvamise keerulisemaks.';
$string['configenableswf'] = 'Saate lubada SWF-failide manustamise HotPot-tegevustes. Kui see säte on lubatud, siis see säte tühistab filtri filter_mediaplugin_enable_swf.';
$string['configfile'] = 'Konfiguratsioonifail';
$string['configframeheight'] = 'Kui test kuvatakse paneelis, siis selle väärtusega määratakse Moodle’i navigeerimisriba sisaldava ülapaneeli kõrgus (pikslites).';
$string['configlocation'] = 'Konfigureeri failiasukohta';
$string['configlockframe'] = 'Kui see säte on lubatud, saab navigeerimispaneeli (kui kasutusel) lukustada, nii et seda ei saa kerida, selle suurust ei saa muuta ja sellel pole äärist.';
$string['configmaxeventlength'] = 'Kui HotPot-tegevuse jaoks on määratud avamis- ja sulgemiskuupäev ja kahe kuupäeva vahe on suurem kui siin määratud päevaarv, siis lisatakse kursusekalendrisse kaks erinevat kalendrisündmust. Lühemate perioodide puhul või kui ainult üks kuupäev on määratud, lisatakse ainult üks kalendrisündmus. Kui mõlemad kuupäevad on määramata, ei lisata ühtegi kalendrisündmust.';
$string['configstoredetails'] = 'Kui see säte on lubatud, siis HotPoti testide soorituskatsete töötlemata XML-andmed salvestatakse andmebaasi tabelisse hotpot_details. See võimaldab testide sooritamise katseid uuesti hinnata tulevikus, et näha erinevusi HotPoti testitulemuste süsteemis. Kui aga see säte lubatakse suure koormusega saidil, võib tabel hotpot_details andmebaasis väga kiiresti suureneda.';
$string['confirmdeleteattempts'] = 'Kas soovite kindlasti need sooritused kustutada?';
$string['confirmstop'] = 'Kas soovite sellelt lehelt kindlasti lahkuda?';
$string['correct'] = 'Õige';
$string['couldnotinsertsubmissionform'] = 'Esitusvormi ei saanud lisada';
$string['d_index'] = 'Eristamisindeks';
$string['delay1'] = 'Viivitus 1';
$string['delay1_help'] = 'Minimaalne viivitus esimese ja teise soorituskatse vahel.';
$string['delay1summary'] = 'Viivitus esimese ja teise soorituskatse vahel';
$string['delay2'] = 'Viivitus 2';
$string['delay2_help'] = 'Minimaalne viivitus pärast teist soorituskatset';
$string['delay2summary'] = 'Viivitus hilisemate soorituskatsete vahel';
$string['delay3'] = 'Viivitus 3';
$string['delay3_help'] = 'Selle sättega määratakse viivitus testi lõpetamise ja Moodle’ile juhtimise tagasiandmise vahel.

**Kasuta kindlat viivitust**
: juhtimine antakse Moodle’ile tagasi määratud ajavahemiku pärast.

**Kasuta lähte-/mallifailis olevaid sätteid**
: juhtimine antakse Moodle’ile tagasi pärast teatud arvu sekundeid, mis on lähte- või mallifailis määratud selle väljundvormingu jaoks.

**Oota, kuni õppija klõpsab nuppu OK**
: juhtimine antakse Moodle’ile tagasi, kui õppija klõpsab testi sooritamise lõpetamise teates nuppu OK.

**Ära jätka automaatselt**
: juhtimist ei anta Moodle’ile tagasi pärast testi lõpetamist. Õppija võib testilehelt lahkuda.

Testitulemused saadetakse Moodle’ile kohe pärast testi lõpetamist või testi sooritamisest loobumist (olenemata sellest sättest).';
$string['delay3afterok'] = 'Oota, kuni õppija klõpsab nuppu OK';
$string['delay3disable'] = 'Ära jätka automaatselt';
$string['delay3specific'] = 'Kasuta konkreetset viivitust (sekundites)';
$string['delay3summary'] = 'Ajaviivitus testi lõpus';
$string['delay3template'] = 'Kasuta lähte-/mallifaili sätteid';
$string['deleteallattempts'] = 'Kustuta kõik soorituskatsed';
$string['deleteattempts'] = 'Kustuta soorituskatsed';
$string['detailsrecords'] = 'Hotpoti üksikasjade kirjed';
$string['duration'] = 'Kestus';
$string['enablecache'] = 'Luba HotPoti vahemälu';
$string['enablecron'] = 'Luba HotPoti cron';
$string['enablemymoodle'] = 'Kuva HotPoti tegevused lehel „Minu Moodle“';
$string['enableobfuscate'] = 'Luba teksti ja meediumipleieri koodi sogastamine';
$string['enableswf'] = 'Luba HotPot-tegevustesse SWF-faile manustada';
$string['entry_attempts'] = 'Soorituskatsed';
$string['entry_dates'] = 'Kuupäevad';
$string['entry_grading'] = 'Hindamine';
$string['entry_title'] = 'Õppetüki nimi pealkirjaks';
$string['entrycm'] = 'Eelmine tegevus';
$string['entrycm_help'] = 'Selle sättega määratakse Moodle’i tegevus ja miinimumhinne, mis peab olema saadud, enne kui seda HotPoti tegevust on võimalik teha.

Õpetaja võib valida teatud kindla tegevuse või ühe neist järgmistest üldsätetest.

* Eelmine tegevus sellel kursusel
* Eelmine tegevus selles jaotises
* Eelmine HotPoti tegevus sellel kursusel
* Eelmine HotPot tegevus selles jaotises';
$string['entrycmcourse'] = 'Eelnev tegevus sellel kursusel';
$string['entrycmsection'] = 'Eelnev tegevus selles kursusejaotises';
$string['entrycompletionwarning'] = 'Enne selle tegevuse alustamist peate vaatama järgmist: {$a}.';
$string['entrygrade'] = 'Eelmise tegevuse hinne';
$string['entrygradewarning'] = 'Selle tegevuse alustamiseks peab teil tegevuse {$a->entryactivity} punktisumma olema vähemalt {$a->entrygrade}% Praegu on teie selle tegevuse hinne {$a->usergrade}%';
$string['entryhotpotcourse'] = 'Eelnevad selle kursuse HotPot-tegevused';
$string['entryhotpotsection'] = 'Eelnevad HotPot-tegevused selles kursusejaotises';
$string['entryoptions'] = 'Sisenemislehe valikud';
$string['entryoptions_help'] = 'Siin saate valida, mis tuleks HotPoti sisenemislehel kuvada.

**Õppetüki nimi pealkirjaks**
: kui see ruut on märgitud, siis kuvatakse õppetüki nimi sisenemislehe pealkirjana.

**Hindamine**
: kui see ruut on märgitud, siis kuvatakse sisenemislehel HotPoti hindamisteave.

**Kuupäevad**
: kui see ruut on märgitud, kuvatakse sisenemislehel HotPot-tegevuse avamis- ja sulgemiskuupäevad.

**Soorituskatsed**
: kui see ruut on märgitud, kuvatakse sisenemislehel tabel, mis sisaldab teavet kasutaja selle HotPot-tegevuse eelmiste soorituskatsete kohta. Nende soorituskatsete korral, mida saab jätkata, kuvatakse parempoolseimas veerus nupp Jätka.';
$string['entrypage'] = 'Kuva sisenemisleht';
$string['entrypage_help'] = 'Kas õppijatele kuvatakse enne HotPot-tegevuse alustamist sisenemisleht?

**Jah**
: õppijatele kuvatakse enne HotPot-tegevuse alustamist sisenemisleht. Sisenemislehe sisu määratletakse HotPoti sisenemislehe valikutega.

**Ei**
: õppijatele kuvatakse sisenemislehe asemel kohe HotPot-tegevuse leht.

Aruannetele juurdepääsuks ja testide lehe muutmise võimaldamiseks kuvatakse sisenemisleht alati õpetajale.';
$string['entrypagehdr'] = 'Sisenemisleht';
$string['entrytext'] = 'Sisenemislehe tekst';
$string['event_attempt_reviewed'] = 'HotPoti soorituskatse vaadati läbi';
$string['event_attempt_reviewed_description'] = 'Kasutaja ID-ga {$a->userid} vaatas üle HotPoti tegevuse soorituskatse kursusemoodulis ID-ga {$a->cmid}.';
$string['event_attempt_reviewed_explanation'] = 'Kasutaja vaatas just üle HotPoti tegevuse soorituskatse.';
$string['event_attempt_started'] = 'HotPoti soorituskatset alustati';
$string['event_attempt_started_description'] = 'Kasutaja ID-ga {$a->userid} alustas HotPoti tegevuses soorituskatset kursusemoodulis ID-ga {$a->cmid}.';
$string['event_attempt_started_explanation'] = 'Kasutaja alustas HotPoti tegevuses soorituskatset.';
$string['event_attempt_submitted'] = 'HotPoti soorituskatse esitati';
$string['event_attempt_submitted_description'] = 'Kasutaja ID-ga {$a->userid} esitas HotPoti tegevuse soorituskatse kursusemoodulis ID-ga {$a->cmid}.';
$string['event_attempt_submitted_explanation'] = 'Kasutaja esitas HotPoti tegevuse soorituskatse.';
$string['event_base'] = 'Tuvastati HotPoti sündmus.';
$string['event_base_description'] = 'Kasutaja ID-ga {$a->userid} käivitas HotPoti tegevuse sündmuse kursusemoodulis ID-ga {$a->cmid}.';
$string['event_base_explanation'] = 'HotPoti moodul tuvastas sündmuse.';
$string['event_report_viewed'] = 'HotPoti aruannet vaadati';
$string['event_report_viewed_description'] = 'Kasutaja ID-ga {$a->userid} vaatas HotPoti tegevuse soorituskatsete aruannet kursusemoodulis ID-ga {$a->cmid}.';
$string['event_report_viewed_explanation'] = 'Kasutaja vaatas just HotPoti tegevuse soorituskatsete aruannet.';
$string['exit_areyouok'] = 'Kas olete veel siin?';
$string['exit_attemptscore'] = 'Teie selle soorituskatse punktisumma oli {$a}';
$string['exit_course'] = 'Kursus';
$string['exit_course_text'] = 'Tagasi kursuse põhilehele';
$string['exit_encouragement'] = 'Innustamine';
$string['exit_excellent'] = 'Suurepärane!';
$string['exit_feedback'] = 'Väljumislehe tagasiside';
$string['exit_feedback_help'] = 'Siin saate määrata, mis laadi tagasiside HotPoti väljumislehel kuvatakse.

**Õppetüki nimi pealkirjaks**
: kui see ruut on märgitud, siis kuvatakse õppetüki nimi väljumislehe pealkirjana.

**Innustamine**
: kui see ruut on märgitud, siis kuvatakse väljumislehel mõni innustustekst. Innustamine sõltub HotPoti hindest:
**&gt;  90%** Väga hea! –
**&gt;  60%** Tubli! –
**&gt;  0%** Hea vastus –
**=0%** Kas kõik on korras?

**Õppetüki soorituskatse hinne**
: kui see ruut on märgitud, siis kuvatakse lõpetatud õppetüki soorituskatse hinne väljumislehel.

**Õppetüki hinne**
: kui see ruut on märgitud, siis kuvatakse väljumislehel HotPoti hinne.

Kui õppetüki hindamise viis on ülimuslik, siis kuvatakse kasutajale teade, kui viimane soorituskatse oli võrdne varasema katsega või sellest parem.';
$string['exit_goodtry'] = 'Hea vastus!';
$string['exit_grades'] = 'Hinded';
$string['exit_grades_text'] = 'Vaadake oma selle kursuse seniseid hindeid';
$string['exit_hotpotgrade'] = 'Teie selle tegevuse hinne on {$a}';
$string['exit_hotpotgrade_average'] = 'Teie selle tegevuse senine keskmine hinne on {$a}';
$string['exit_hotpotgrade_highest'] = 'Teie selle tegevuse senine kõrgeim hinne on {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'Kordasite oma tulemust!';
$string['exit_hotpotgrade_highest_previous'] = 'Teie selle tegevuse suurim punktisumma oli {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'Teie selle tegevuse praegune punktisumma on {$a}';
$string['exit_index'] = 'Register';
$string['exit_index_text'] = 'Mine tegevuste registrisse';
$string['exit_links'] = 'Väljumislehe lingid';
$string['exit_links_help'] = 'Nende valikutega saab lubada ja keelata teatud navigeerimislinkide kuvamise HotPoti väljumislehel.

**Proovi uuesti**
: kui selles HotPotis on lubatud mitu soorituskatset ja õppijal on veel mõni katse järel, siis kuvatakse link, mis võimaldab õppijal HotPoti tegevust uuesti sooritada

**Register**
: kui see ruut on märgitud, siis kuvatakse HotPoti registrilehe link.

**Kursus**
: kui see ruut on märgitud, siis kuvatakse Moodle’i kursuselehe link.

**Hinded**
: kui see ruut on märgitud, siis kuvatakse Moodle’i hinnetelehe link.';
$string['exit_next'] = 'Edasi';
$string['exit_next_text'] = 'Proovi järgmist tegevust';
$string['exit_noscore'] = 'Olete selle tegevuse edukalt lõpetanud!';
$string['exit_retry'] = 'Proovige uuesti';
$string['exit_retry_text'] = 'Proovi veel seda tegevust';
$string['exit_welldone'] = 'Tubli!';
$string['exit_whatnext_0'] = 'Mida sooviksite järgmiseks teha?';
$string['exit_whatnext_1'] = 'Valige, mida soovite teha...';
$string['exit_whatnext_default'] = 'Valige üks järgmistest:';
$string['exitcm'] = 'Järgmine tegevus';
$string['exitcm_help'] = 'Selle sättega määratakse, milline Moodle’i tegevus tehakse pärast selle HotPot-tegevuse lõpetamist. Valikuline hinne on vastava HotPoti tegevuse miinimumhinne, mida on vaja enne järgmise tegevuse juurde asumist.

Õpetaja saab valida kindla tegevuse või ühe üldsätetest:

* Selle kursuse järgmine tegevus
* Selle jaotise järgmine tegevus
* Selle kursuse järgmine HotPoti tegevus
* Selle jaotise järgmine HotPoti tegevus

Kui muud väljumislehe valikud on keelatud ja õppija on saanud selle HotPoti tegevuse eest vajaliku hinde,kuvatakse kohe järgmine tegevus. Muul juhul kuvatakse järgmise tegevuse link.';
$string['exitcmcourse'] = 'Selle kursuse järgmine tegevus';
$string['exitcmsection'] = 'Selle kursusejaotise järgmine tegevus';
$string['exitgrade'] = 'Järgmise tegevuse hinne';
$string['exithotpotcourse'] = 'Kursuse järgmine HotPot';
$string['exithotpotsection'] = 'Järgmine HotPot selles kursusejaotises';
$string['exitoptions'] = 'Väljumislehe valikud';
$string['exitpage'] = 'Kuva väljumisleht';
$string['exitpage_help'] = 'Kas pärast HotPoti testi lõpetamist tuleks kuvada väljumisleht?

**Jah**
: õppijatele kuvatakse väljumislehte, kui HotPoti tegevus on lõpetatud. Väljumislehe sisu määratakse HotPoti väljumislehe tagasiside ja linkide sätetega.

**Ei**
: õppijatele ei kuvata väljumislehte. Nad liiguvad otse järgmise tegevuse juurde või kursuse esilehele.';
$string['exitpagehdr'] = 'Väljumisleht';
$string['exittext'] = 'Väljumislehe tekst';
$string['feedbackdiscuss'] = 'Arutlege selle testi üle foorumis';
$string['feedbackformmail'] = 'Tagasisidevorm';
$string['feedbackmoodleforum'] = 'Moodle’i foorum';
$string['feedbackmoodlemessaging'] = 'Moodle’i sõnum';
$string['feedbacknone'] = 'Pole';
$string['feedbacksendmessage'] = 'Saada juhendajale teade';
$string['feedbackwebpage'] = 'Veebileht';
$string['firstattempt'] = 'Esimene soorituskatse';
$string['forceplugins'] = 'Sunni kasutama meediumilisandmooduleid';
$string['forceplugins_help'] = 'Kui see säte on lubatud, siis saab Moodle’iga ühilduvates meediumipleierites esitada sellistes failivormingutes faile nagu AVI, MPEG, MPG, MP3, MOV ja WMV. Moodle ei muuda testis ühtegi meediumipleieritega seotud sätet.';
$string['frameheight'] = 'Raami kõrgus';
$string['giveup'] = 'Loobu';
$string['grademethod'] = 'Hindamisviis';
$string['grademethod_help'] = 'Selle sättega määratakse, kuidas HotPoti hinne soorituskatsete punktisummade põhjal arvutatakse.

**Suurim punktisumma**
: hinne määratakse selle HotPoti tegevuse soorituskatse suurima punktisumma järgi.

**Keskmine punktisumma**
: hinne määratakse selle HotPoti tegevus soorituskatsete keskmise punktisumma järgi .

**Esimene soorituskatse**
: hinne määratakse selle HotPoti tegevuse esimese soorituskatse punktisumma järgi.

**Viimane soorituskatse**
: hinne määratakse selle HotPoti tegevuse viimase soorituskatse punktisumma järgi.';
$string['gradeweighting'] = 'Hinde kaal';
$string['gradeweighting_help'] = 'Selle HotPoti tegevuse hinded arvutatatakse Moodle’i hinnetelehel selle arvulise skaala alusel.';
$string['highestscore'] = 'Suurim punktisumma';
$string['hints'] = 'Vihjed';
$string['hotpot:addinstance'] = 'Lisa uus HotPot-tegevus';
$string['hotpot:attempt'] = 'HotPot-tegevuse soorituskatse ja esita tulemused';
$string['hotpot:deleteallattempts'] = 'Kustuta kõigi kasutajate HotPot-tegevuse soorituskatsed';
$string['hotpot:deletemyattempts'] = 'Kustuta enda soorituskatsed, mis on seotud selle HotPot-tegevusega';
$string['hotpot:ignoretimelimits'] = 'Eira HotPot-tegevuse ajapiiranguid';
$string['hotpot:manage'] = 'Muuda HotPot-tegevuse sätteid';
$string['hotpot:preview'] = 'HotPot tegevuse eelvaade';
$string['hotpot:reviewallattempts'] = 'Kuva kõigi kasutajate HotPot-tegevusega seotud soorituskatsed';
$string['hotpot:reviewmyattempts'] = 'Kuva minu HotPot-tegevusega seotud soorituskatsed';
$string['hotpot:view'] = 'Kuva HotPot-tegevuse sisenemisleht';
$string['hotpotname'] = 'HotPot tegevuse nimi';
$string['ignored'] = 'Eiratud';
$string['inprogress'] = 'Pooleli';
$string['isgreaterthan'] = 'on suurem kui';
$string['islessthan'] = 'on väiksem kui';
$string['lastaccess'] = 'Viimane külastus';
$string['lastattempt'] = 'Viimane soorituskatse';
$string['lockframe'] = 'Lukusta paneel';
$string['maxeventlength'] = 'Suurim päevade arv ühe kalendrisündmuse kohta';
$string['mediafilter_hotpot'] = 'HotPoti meediumifilter';
$string['mediafilter_moodle'] = 'Moodle’i standardsed meediumifiltrid';
$string['migratingfiles'] = 'Hot Potatoese testifailide migreerimine';
$string['migratinglogs'] = 'Hot Potatoesi logide migreerimine';
$string['missingsourcetype'] = 'HotPoti kirjes pole lähtetüüpi';
$string['modulename'] = 'HotPoti test';
$string['modulename_help'] = 'HotPoti moodul võimaldab õpetajatel Moodle’is jaotada oma õppijatele interaktiivseid õppematerjale ja vaadata õppijate vastuste ja tulemuste aruandeid.

HotPoti tegevus koosneb valikulisest sissejuhatavast lehest, ühest e-õppe harjutusest ja valikulisest kokkuvõttelehest. E-õppe harjutus võib olla staatiline veebileht või interaktiivne veebileht teksti, heli ja visuaalsete viipadega ning õppijate vastuste salvestamise funktsiooniga. E-õppe harjutuse loob õpetaja enda arvutis sisuloomerakenduses ja laadib seejärel Moodle’isse üles.

HotPoti tegevus toetab harjutusi, mis on loodud järgmiste sisuloomerakendustega:

* Hot Potatoes (versioon 6)
* Qedoc
* Xerte
* iSpring
* ja kõik HTML-i redaktorid.';
$string['modulename_link'] = 'mod/hotpot/view';
$string['modulenameplural'] = 'HotPoti testid';
$string['nameadd'] = 'Nimi';
$string['nameadd_help'] = 'Nimi võib olla õpetaja sisestatud või automaatselt genereeritud.

**Too lähtefailist**
: nimi võetakse lähtefailist.

**Kasuta lähtefaili nime**
: nimeks pannakse lähtefaili nimi.

**Kasuta lähtefaili teed**
: nimeks pannakse lähtefaili tee. Failitee kõik kaldkriipsud (/) asendatakse tühikutega.

**Tekst**
: nime saab õppejõud ise sisestada';
$string['nameedit'] = 'Nimi';
$string['nameedit_help'] = 'Teatud tekst, mis õppijatele kuvatakse';
$string['navigation'] = 'Navigeerimine';
$string['navigation_embed'] = 'Manustatud veebileht';
$string['navigation_frame'] = 'Moodle’i navigeerimispaneel';
$string['navigation_give_up'] = 'Üksik nupp Loobu';
$string['navigation_help'] = 'Selle sättega määratakse, mis tüüpi navigeerimist testis kasutatakse.

**Moodle’i navigeerimisriba**
: Moodle’i navigeerimisriba kuvatakse testiga samas aknas, lehe päises.

**Moodle’i navigeerimispaneel**
: Moodle’i navigeerimisriba kuvatakse lehe päises eraldi paneelina

**Manustatud veebileht**
: Moodle’i navigeerimisriba kuvatakse HotPoti testi sees, manustatuna samas aknas

**Algsed navigeerimisribad**
: testis kuvatakse algse navigeerimisriba nupud (kui neid on) ja need määratletakse testis.

**Üksik nupp „Loobu“**
: testi lehe päises kuvatakse üksainus loobumisnupp

**Pole**
: test kuvatakse ilma ühegi navigeerimisribata. Kui test on tehtud, siis olenevalt sätte „Kas kuvada järgmine test?“ väärtusest, suunatakse õppija kas kursuse esilehele või järgmise testi juurde.';
$string['navigation_moodle'] = 'Moodle’i tavapärased navigeerimisribad (päises ja külgservas)';
$string['navigation_none'] = 'Pole';
$string['navigation_original'] = 'Algupärased navigeerimise abivahendid';
$string['navigation_topbar'] = 'Ainult Moodle’i päises olev navigeerimisriba (külgribasid pole)';
$string['noactivity'] = 'Tegevusi pole';
$string['nohotpots'] = 'HotPote ei leitud';
$string['nomoreattempts'] = 'Kahjuks on selle tegevuse korral lubatud soorituskatsete arv täis.';
$string['noresponses'] = 'Individuaalsete küsimuste ja vastuste kohta teavet ei leitud.';
$string['noreview'] = 'Kahjuks pole teil selle testi soorituskatse üksikasjade vaatamise õigust.';
$string['noreviewafterclose'] = 'Kahjuks on see test suletud. Teil pole enam selle testi soorituskatse üksikasjade vaatamise õigust.';
$string['noreviewbeforeclose'] = 'Kahjuks pole teil selle testi soorituskatse üksikasjade vaatamise õigust kuni {$a}';
$string['nosourcefilesettings'] = 'HotPoti kirjes puudub teave lähtefaili kohta.';
$string['notattemptedyet'] = 'Soorituskatseid pole.';
$string['notavailable'] = 'Kahjuks pole see tegevus enam saadaval.';
$string['outputformat'] = 'Väljundvorming';
$string['outputformat_best'] = 'Parim';
$string['outputformat_help'] = 'Väljundvorminguga määratakse, kuidas sisu õppijale kuvatakse.

Saadaolevad väljundvormingud sõltuvad lähtefaili tüübist. Teatud tüüpi lähtefailidel on ainult üks väljundformaat, muud tüüpi lähtefailidel võib olla mitu väljundformaati.

Sätte „Parim“ korral valitakse olenevalt õppija brauserist sisu kuvamiseks optimaalne väljundformaat.';
$string['outputformat_hp_6_jcloze_html'] = 'JCloze (v6) from html';
$string['outputformat_hp_6_jcloze_html_dropdown'] = 'JCloze HP6 html: Rottmeier DropDown';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) html-is';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) html-is';
$string['outputformat_hp_6_jcloze_html_jgloss'] = 'JCloze HP6 html: Rottmeier JGloss';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'ANCT-Scan from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'DropDown from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (b) from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'JGloss from HP6 JCloze xml';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'JCloze (v6) from HP6 xml';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'JCloze (v6) HP6 xml-is (automaatne edasiminek)';
$string['outputformat_hp_6_jcross_html'] = 'JCross (v6) from html';
$string['outputformat_hp_6_jcross_xml_v6'] = 'JCross (v6) from xml';
$string['outputformat_hp_6_jmatch_html'] = 'JMatch (v6) from html';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch Sort html-is';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'JMatch (flashcard) from xml';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'JMemori from xml';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'JMatch Sort xml-is';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'HP6 XML JMatch\'st : Standard';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'JMatch (v6+) XML-ist';
$string['outputformat_hp_6_jmix_html'] = 'JMix (v6) HTML-ist';
$string['outputformat_hp_6_jmix_xml_v6'] = 'JMix (v6) XML-ist';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'JMix (v6+) XML-ist';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'JMix (v6+ eesliitega, segajatega järelliide) xml-is';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'JMix (v6+ klahvivajutusega) XML-ist';
$string['outputformat_hp_6_jquiz_html'] = 'JQuiz (v6) HTML-ist';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'JQuiz (v6) XML-ist';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'JQuiz (v6) XML-ist (automaatne edasiminek)';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'JQuiz (v6) XML-ist (Eksam)';
$string['outputformat_hp_6_rhubarb_html'] = 'Rhubarb (v6) HTML-ist';
$string['outputformat_hp_6_rhubarb_xml'] = 'WebRhubarb (v6) XML-ist';
$string['outputformat_hp_6_sequitur_html'] = 'Rhubarb (v6) HTML-ist';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Sequitur (v6) HTML-ist, astmeline arvestus';
$string['outputformat_hp_6_sequitur_xml'] = 'Sequitur (v6) XML-ist';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Sequitur (v6) XML-ist, astmeline arvestus';
$string['outputformat_html_ispring'] = 'iSpring HTML-fail';
$string['outputformat_html_xerte'] = 'Xerte HTML-fail';
$string['outputformat_html_xhtml'] = 'Standardne HTML-fail';
$string['outputformat_qedoc'] = 'Qedoci fail';
$string['overviewreport'] = 'Ülevaade';
$string['penalties'] = 'Trahvid';
$string['percent'] = 'Protsenti';
$string['pluginadministration'] = 'HotPoti haldus';
$string['pluginname'] = 'HotPoti moodul';
$string['pressoktocontinue'] = 'Jätkamiseks klõpsake nuppu OK, praegusele lehele jäämiseks klõpsake nuppu Loobu.';
$string['questionshort'] = 'K-{$a}';
$string['quizname_help'] = 'Testi abitekst';
$string['quizzes'] = 'Testid';
$string['responses'] = 'Vastused';
$string['responsesreport'] = 'Vastused';
$string['reviewafterattempt'] = 'Luba pärast soorituskatset läbi vaadata';
$string['reviewafterclose'] = 'Luba pärast HotPoti sulgemist läbi vaadata';
$string['reviewduringattempt'] = 'Luba soorituskatse ajal läbi vaadata';
$string['reviewoptions'] = 'Läbivaatusvalikud';
$string['score'] = 'Punktisumma';
$string['scoresreport'] = 'Punktisummad';
$string['selectattempts'] = 'Valige soorituskatsed';
$string['showerrormessage'] = 'HotPoti tõrge: {$a}';
$string['sourcefile'] = 'Lähtefail';
$string['sourcefile_help'] = 'Selle sättega määratakse fail, mis sisaldab õppijatele kuvatavat sisu.

Enamasti on lähtefailid loodud väljaspool Moodle’it ja seejärel Moodle’i kursuse failialasse üles laaditud.
See võib olla HTML-fail või muud tüüpi fail, mis on loodud sellise loometarkvaraga nagu Hot Potatoes või Qedoc.

Lähtefaili saab määrata kausta- ja failiteega Moodle’i kursusefailide alas või aadressiga, mille algus on http:// või https://.

Qedoci lähtefailiks peab olema aadress Qedoci moodulist, mis on üles laaditud Qedoci serverisse.

* näiteks: http://www.qedoc.net/library/ABCDE_123.zip
* Lisateavet Qedoci moodulite kohta leiate siit: [Qedoc documentation:Uploading_modules](http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'Lähtefaili ei leitud (või on tühi): {$a}';
$string['status'] = 'Olek';
$string['stopbutton'] = 'Kuva nupp Peata';
$string['stopbutton_help'] = 'Kui see säte on lubatud, lisatakse testi nupp Peata.

Kui õppija klõpsab peatamisnuppu, siis tagastatakse tulemused Moodle’isse ja testi soorituskatse olekuks määratakse Loobutud.

Stoppnupul kuvatav tekst saab olla mõni Moodle’i keelepakettide valmisfraas või õpetaja määratud tekst.';
$string['stopbutton_langpack'] = 'Keelepakist';
$string['stopbutton_specific'] = 'Kasuta määratud teksti';
$string['stoptext'] = 'Peatamisnupu tekst';
$string['storedetails'] = 'Salvesta HotPoti testi soorituskatsete töötlemata XML-andmed';
$string['studentfeedback'] = 'Õppija tagasiside';
$string['studentfeedback_help'] = 'Kui see on lubatud, siis kuvatakse alati, kui õppija klõpsab nuppu Kontrolli, tagasiside hüpikakna link. Tagasisideaken võimaldab õppijatel testi üle arutleda õpetaja või kaasõppijatega.

**Veebileht**
: veebilehe aadress, näiteks http://myserver.com/feedbackform.html

**Tagasisidevorm**
: vormiskripti aadress, näiteks http://myserver.com/cgi-bin/formmail.pl

**Moodle’i foorum**
: kuvatakse kursuse foorumiteemade register

**Moodle’i sõnumid**
: kuvatakse Moodle’i kiirsõnumsideaken. Kui kursusel on mitu õpetajat, peab õppija valima õpetaja, kellele sõnum saata, ja sõnumsideaken kuvatakse pärast õpetaja valimist.';
$string['submits'] = 'Esitatud tööd';
$string['subplugintype_hotpotattempt'] = 'Väljundvorming';
$string['subplugintype_hotpotattempt_plural'] = 'Väljundvormingud';
$string['subplugintype_hotpotreport'] = 'Aruanne';
$string['subplugintype_hotpotreport_plural'] = 'Aruanded';
$string['subplugintype_hotpotsource'] = 'Lähtefail';
$string['subplugintype_hotpotsource_plural'] = 'Lähtefailid';
$string['textsourcefile'] = 'Too lähtefailist';
$string['textsourcefilename'] = 'Kasuta lähtefaili nime';
$string['textsourcefilepath'] = 'Kasuta lähtefaili teed';
$string['textsourcequiz'] = 'Too testist';
$string['textsourcespecific'] = 'Kindel tekst';
$string['timeclose'] = 'Saadaval kuni';
$string['timedout'] = 'Aegunud';
$string['timelimit'] = 'Ajapiirang';
$string['timelimit_help'] = 'Selle sättega määratakse ühe soorituskatse lubatud maksimumkestuse.

**Kasuta lähte-/mallifaili sätteid**
: selle väljundvormingu jaoks võetakse ajapiirang lähtefailist või mallifailist

**Kasuta konkreetset aega**
: selle testi soorituskatse ajapiiranguna kasutatakse HotPoti testisätetelehel määratud ajapiirangut. See säte alistab selle väljundvormingu korral lähte-, konfiguratsiooni- ja mallifaili ajapiirangud.

**Keela**
: selle testi soorituskatsetele ajapiirangut ei määrata.

Märkus. Soorituskatse jätkamisel jätkab ajaloendur pooleli jäänud kohast.';
$string['timelimitexpired'] = 'Selle soorituskatse ajapiirang on läbi saanud';
$string['timelimitspecific'] = 'Kasuta konkreetset aega';
$string['timelimitsummary'] = 'Ühe katse ajapiirang';
$string['timelimittemplate'] = 'Kasuta lähte-/mallifaili sätteid';
$string['timeopen'] = 'Saadaval alates';
$string['timeopenclose'] = 'Avamis- ja sulgemisajad';
$string['timeopenclose_help'] = 'Saate määrata, millal on test sooritamiseks juurdepääsetav. Enne avamis- ja pärast sulgemisaega pole test saadaval.';
$string['title'] = 'Pealkiri';
$string['title_help'] = 'Selle sättega määratakse veebilehel kuvatav pealkiri.

**HotPoti tegevuse nimi**
: HotPoti tegevuse nimi kuvatakse veebilehe pealkirjana

**Too lähtefailist**
: veebilehe pealkiri (kui see on olemas) võetakse HotPoti lähtefailist.

**Kasuta lähtefaili nime**
: veebilehe pealkirjana kuvatakse lähtefaili nimi (ilma kaustanimedeta).

**Kasuta lähtefaili teed**
: veebilehe pealkirjana kuvatakse lähtefaili tee, mis sisaldab kõiki kaustanimesid.';
$string['toolsindex'] = 'HotPoti tööriistade indeks';
$string['unitname_help'] = 'õppetüki nime abitekst';
$string['unrecognizedsourcefile'] = 'Kahjuks ei saanud HotPoti moodul tuvastada lähtefaili „{$a}“ tüüpi.';
$string['updated'] = 'Värskendatud';
$string['updatinggrades'] = 'HotPoti hinnete värskendamine';
$string['usefilters'] = 'Kasuta filtreid';
$string['usefilters_help'] = 'Kui see säte on lubatud, siis läbib sisu enne brauserisse edastamist Moodle’i filtrid.';
$string['useglossary'] = 'Kasuta sõnastikku';
$string['useglossary_help'] = 'Kui see säte on lubatud, siis läbib sisu enne brauserisse edastamist Moodle’i sõnastiku automaatlinkimise filtri.

Arvestage, et see säte tühistab saidiadministraatori sätte, mis lubab või keelab sõnastiku automaatlinkimise filtri.';
$string['usemediafilter'] = 'Kasuta meediumifiltreid';
$string['usemediafilter_help'] = 'Selle sättega määratakse kasutatav meediumifilter.

**Pole**
: sisu edastatakse meediumifiltreid läbimata.

**Moodle’i tavalised meediumifiltrid**
: sisu edastatakse läbi Moodle’i tavaliste meediumifiltrite. Need filtrid otsivad levinumat tüüpi heli -ja videofailidele suunavaid linke ja teisendavad need lingid sobivate meediumipleierite jaoks.

**HotPoti meediumifilter**
: sisu edastatakse läbi filtri, mis otsib linke, pilte, heli ja filme, mida tähistatakse nurksulgudega.

Nurksulgudega esitusel on järgmine süntaks:
<code>[url player width height options]</code>

**URL**
: relatiivne või absoluutne meediumifaili URL

**pleier** (valikuline)
: lisatava pleieri nimi. Selle sätte vaikeväärtus on „moodle“. HotPoti mooduli standardversioonis on järgmised pleierid:
: **dew**: mp3-pleier
: **dyer**: Bernard Dyeri loodud mp3-pleier
: **hbs**: Half-Baked Software’i mp3.pleier
: **image**: lisage pilt veebilehele
: **link**: lisage link mõnele muule veebilehele

**laius** (valikuline)
: nõutav pleieri laius

**kõrgus** (valikuline)
: nõutav pleieri kõrgus. Kui määramata jäetud, siis on kõrguseks laiuse väärtus.

**valikud** (valikuline)
: komaeraldusega loend valikutest, mis pleierile edastatakse. Iga valik võib olla lüliti kujul või nime ja väärtuse paar:
: **nimi=väärtus
: **nimi="mingi väärtus koos tühikutega"';
$string['viewreports'] = 'Vaata {$a} kasutaja aruandeid';
$string['views'] = 'Vaatamised';
$string['weighting'] = 'Kaal';
$string['wrong'] = 'Vale';
$string['zeroduration'] = 'Kestust pole';
$string['zeroscore'] = 'Null';
