<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlecloudsignup', language 'es_mx', version '3.8'.
 *
 * @package     local_moodlecloudsignup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['FOSUserBundle:change_password.flash.success'] = 'La contraseña ha sido cambiada';
$string['FOSUserBundle:change_password.submit'] = 'Cambiar contraseña';
$string['FOSUserBundle:form.current_password'] = 'Contraseña actual:';
$string['FOSUserBundle:form.email'] = 'Email:';
$string['FOSUserBundle:form.group_name'] = 'Nombre del grupo:';
$string['FOSUserBundle:form.new_password'] = 'Nueva contraseña:';
$string['FOSUserBundle:form.new_password_confirmation'] = 'Repetir contraseña nueva:';
$string['FOSUserBundle:form.password'] = 'Contraseña:';
$string['FOSUserBundle:form.password_confirmation'] = 'Repetir contraseña:';
$string['FOSUserBundle:form.username'] = 'Nombre_de_usuario:';
$string['FOSUserBundle:group.edit.submit'] = 'Actualizar grupo';
$string['FOSUserBundle:group.flash.created'] = 'El grupo ha sido creado';
$string['FOSUserBundle:group.flash.deleted'] = 'El grupo ha sido eliminado';
$string['FOSUserBundle:group.flash.updated'] = 'El grupo ha sido actualizado';
$string['FOSUserBundle:group.new.submit'] = 'Crear grupo';
$string['FOSUserBundle:group.show.name'] = 'Nombre del grupo';
$string['FOSUserBundle:layout.logged_in_as'] = 'Ingresado como %username%';
$string['FOSUserBundle:layout.login'] = 'Ingreso';
$string['FOSUserBundle:layout.logout'] = 'Salida';
$string['FOSUserBundle:layout.register'] = 'Registro';
$string['FOSUserBundle:profile.edit.submit'] = 'Actualizar';
$string['FOSUserBundle:profile.flash.updated'] = 'El perfil ha sido actualizado';
$string['FOSUserBundle:profile.show.email'] = 'Email';
$string['FOSUserBundle:profile.show.username'] = 'Nombre_de_usuario';
$string['FOSUserBundle:registration.back'] = 'Regresar a la página original.';
$string['FOSUserBundle:registration.check_email'] = 'Se ha enviado un Email a %email%. El Email contiene un enlace para activación al cual Usted debe hacerle click para activar su cuenta.';
$string['FOSUserBundle:registration.confirmed'] = 'Felicitaciones %username%, su cuenta ha sido activada.';
$string['FOSUserBundle:registration.email.message'] = 'Hola %username%!

Para terminar la activación de su cuenta - por favor visite %confirmationUrl%

Saludos,
el Equipo.';
$string['FOSUserBundle:registration.email.subject'] = '¡BienVenido %username%!';
$string['FOSUserBundle:registration.flash.user_created'] = 'El usuario ha sido creado exitosamente';
$string['FOSUserBundle:registration.submit'] = 'Registro';
$string['FOSUserBundle:resetting.check_email'] = 'Se ha enviado un email a %email%. Contiene un enlace al que tiene que hacerle click para reiniciar su contraseña..';
$string['FOSUserBundle:resetting.email.message'] = 'Hola %username%!

Para reiniciar su contraseña - por favor visite %confirmationUrl%

Saludos,
el Equipo.';
$string['FOSUserBundle:resetting.email.subject'] = 'Reiniciar contraseña';
$string['FOSUserBundle:resetting.flash.success'] = 'La contraseña ha sido reiniciada exitosamente';
$string['FOSUserBundle:resetting.password_already_requested'] = 'La contraseña para este usuario ya había sido solicitada dentro de las 24 horas anteriores.';
$string['FOSUserBundle:resetting.request.invalid_username'] = 'El nombre_de_usuario o la dirección email para "%username%" no existe.';
$string['FOSUserBundle:resetting.request.submit'] = 'Reiniciar contraseña';
$string['FOSUserBundle:resetting.request.username'] = 'Nombre_de_usuario o dirección Email:';
$string['FOSUserBundle:resetting.reset.submit'] = 'Cambiar contraseña';
$string['FOSUserBundle:security.login.password'] = 'Contraseña:';
$string['FOSUserBundle:security.login.remember_me'] = 'Recuérdame';
$string['FOSUserBundle:security.login.submit'] = 'Ingreso';
$string['FOSUserBundle:security.login.username'] = 'Nombre_de_usuario';
$string['homepage:Table.activities'] = 'Actividades ilimitadas';
$string['homepage:Table.annualprice'] = 'Precio anual*';
$string['homepage:Table.button'] = 'Apuntarse';
$string['homepage:Table.conferencing'] = 'Video conferencia';
$string['homepage:Table.gb'] = '%limit% Gb';
$string['homepage:Table.maxuploads'] = 'Subida de archivo máximo';
$string['homepage:Table.maxusers'] = 'Usuarios máximo';
$string['homepage:Table.mb'] = '%limit% Mb';
$string['homepage:Table.mobile'] = 'Mobile habilitado';
$string['homepage:Table.noplugins'] = 'Sin paquete de plugin extra';
$string['homepage:Table.notheme'] = 'Sin tema avanzado';
$string['homepage:Table.plan'] = 'Plan';
$string['homepage:Table.plugins'] = 'Paquete de plugin extra';
$string['homepage:Table.sitename'] = 'Nombre personalizado del sitio';
$string['homepage:Table.theme'] = 'Tema avanzado';
$string['homepage:Table.uptodate'] = 'Siempre actualizado';
$string['homepage:body.intro'] = 'por las personas que hacen a Moodle';
$string['homepage:body.title'] = 'Alojamiento Moodle';
$string['homepage:general.faq'] = 'FAQ (Preguntas Frecuentes)';
$string['homepage:general.servicestatus'] = 'Estatus del Servicio';
$string['homepage:needmore'] = '¿Necesita un plan más grande? <a href="https://moodle.com/contact">Contáctenos</a>.';
$string['homepage:notfound.badnews'] = 'La mala noticia es que el sitio que Usted está buscando no existe - ha sido borrado o todavía no esta en-línea.';
$string['homepage:notfound.button'] = 'Apuntarse y obtener este sitio';
$string['homepage:notfound.goodnews'] = 'La buena noticia es que este sitio está disponible y es suyo si lo quiere.';
$string['homepage:notfound.title'] = 'Le tenemos buenas noticias y malas noticias.';
$string['homepage:page.description'] = 'Soluciones de alojamiento Moodle por Moodle disponibles para cualquiera que desee implementar el programa de aprendizaje en la nube';
$string['homepage:page.title'] = 'MoodleCloud: Servicios de Alojamiento Gratuitos por los fabricantes de Moodle';
$string['homepage:plans.free.description'] = 'Para clases individuales o simplemente para probar Moodle';
$string['homepage:plans.free.name'] = 'Moodle Gratuito';
$string['homepage:plans.free.plan_free'] = 'Gratuito';
$string['homepage:plans.school1.description'] = 'Perfecto para múltiples clases';
$string['homepage:plans.school1.name'] = 'Moodle para Escuela';
$string['homepage:plans.school1.plan_idmedium'] = 'Mediano';
$string['homepage:plans.school1.plan_idsmall'] = 'Pequeño';
$string['homepage:plans.school1.plan_tiny'] = 'Pequeñisimo';
$string['homepage:sitelimit'] = '** Límite de uno por cliente';
$string['homepage:taxes'] = '* Más impuestos aplicables';
$string['langconfig:direction'] = 'izquierda-a-derecha';
$string['langconfig:langname'] = 'Español - México';
$string['login:brandname'] = 'MoodleCloud';
$string['login:gotoportal'] = 'Ir al Portal';
$string['login:logout'] = 'Salida';
$string['login:security.login.password'] = 'Contraseña';
$string['login:security.login.password_placeholder'] = 'Contraseña';
$string['login:security.login.submit'] = 'Ingresar';
$string['login:security.login.username'] = 'Nombre del sitio MoodleCloud';
$string['login:security.login.username_placeholder'] = 'misitio';
$string['login:security.token.invalid'] = 'Falló el ingreso al portal. Por favor inténtelo nuevamente.';
$string['login:signup.login.panel.title'] = 'Ingresar';
$string['messages:auditlog.administrator'] = 'Equidpo de Adminstración de MoodleCloud';
$string['messages:auditlog.automatedtool'] = 'Bot de MoodleCloud';
$string['messages:auditlog.site.removalComplete'] = 'El sitio fue quitado';
$string['messages:auditlog.site.removalQueued'] = 'Se puso en cola para quitar el sitio';
$string['messages:close'] = 'Cerrar';
$string['plans:packages.free'] = 'Moodle Gratuito';
$string['plans:packages.school'] = 'Moodle para Escuela';
$string['plans:plans.free.0.description'] = 'Moodle Gratuito';
$string['plans:plans.free.0.name'] = 'Gratuito';
$string['plans:plans.school_1000.0.description'] = 'Moodle para Escuela / Mediana';
$string['plans:plans.school_1000.0.name'] = 'Mediana';
$string['plans:plans.school_250.0.description'] = 'Moodle para Escuela / Pequeñísima';
$string['plans:plans.school_250.0.name'] = 'Pequeñísima';
$string['plans:plans.school_500.0.description'] = 'Moodle para Escuela / Pequeña';
$string['plans:plans.school_500.0.name'] = 'Pequeña';
$string['pluginname'] = 'Cadenas para Ingreso y Portal de MoodleCloud';
$string['portal:addons.School_1000_0.description'] = '';
$string['portal:addons.School_1000_0.title'] = 'Moodle para Escuela / Mediana';
$string['portal:addons.School_250_0.description'] = '';
$string['portal:addons.School_250_0.title'] = 'Moodle para Escuela / Pequeñísima';
$string['portal:addons.School_500_0.description'] = '';
$string['portal:addons.School_500_0.title'] = 'Moodle para Escuela / Pequeña';
$string['portal:addons.buttons.add'] = 'Añadir';
$string['portal:addons.buttons.remove'] = 'Quitar';
$string['portal:addons.buttons.removing'] = 'Quitando';
$string['portal:addons.errors.doesnotexist'] = 'El complemento que Usted intentó especificar no existe.';
$string['portal:addons.nostudentads.description'] = 'Los administradores y profesores todavía pueden ver anuncios relacionados con servicios Moodle.';
$string['portal:addons.nostudentads.flashes.disabled'] = 'A Usted no se le volverá a cobrar por este complemento. Se les mostrarán anuncios a los estudiantes al finalizar este periodo de facturación, %billingendperiod%.';
$string['portal:addons.nostudentads.flashes.disabled.failed'] = 'Ocurrió un error al deshabilitar los anuncios. Por favor inténtelo nuevamente más tarde o contáctenos.';
$string['portal:addons.nostudentads.flashes.enabled'] = '¡Gracias por su apoyo! Ya no se mostrarán anuncios a estudiantes en su sitio.';
$string['portal:addons.nostudentads.label'] = 'Anuncios';
$string['portal:addons.nostudentads.removalconfirmation.body'] = 'A Usted no se le volverá a cobrar por este complemento. Se les mostrarán anuncios a los estudiantes al finalizar este periodo de facturación.';
$string['portal:addons.nostudentads.removalconfirmation.title'] = 'Quitar anuncio';
$string['portal:addons.nostudentads.states.disabled'] = 'Actualmente su sitio muestra Anuncios Google Ads a estudiantes para ayudar a pagar por nuestro alojamiento gratuito.';
$string['portal:addons.nostudentads.states.enabled'] = 'Su sitio actualmente ya no muestra anuncios Google Ads a estudantes porque Usted ha pagado para quitarlos.';
$string['portal:addons.nostudentads.title'] = 'Ocultar anuncios de la vista del estudiante';
$string['portal:addons.panel.lead'] = 'Aquí hay algunas características adicionales para mejorar su sitio';
$string['portal:addons.panel.title'] = 'Complementos';
$string['portal:addons.pay'] = 'Proceda a pagar';
$string['portal:addons.strings.cost'] = '%price% %currency%';
$string['portal:addons.strings.month'] = 'mes';
$string['portal:addons.strings.price'] = '%price% %currency% / %period%';
$string['portal:billing.billingdetails.change.fields.cancel'] = 'Cancelar';
$string['portal:billing.billingdetails.change.fields.save'] = 'Hacer pago';
$string['portal:billing.billingdetails.change.labels.ccname'] = 'Nombre del tarjetahabiente';
$string['portal:billing.billingdetails.change.labels.ccnumber'] = 'Número de Tarjeta de Crédito';
$string['portal:billing.billingdetails.change.labels.cvv'] = 'CVV';
$string['portal:billing.billingdetails.change.labels.expiration'] = 'Fecha de Caducidad MM/AA';
$string['portal:billing.billingdetails.change.panel.cardrequiredbecause'] = 'Los detalles de su tarjeta de crédito son almacenados en nuestro confiable procesador de pagos, PayPal.';
$string['portal:billing.billingdetails.change.panel.title'] = 'Detalles de tarjeta de crédito';
$string['portal:billing.billingdetails.change.panel.verificationamount'] = 'Nota, Para verificar los detalles de su tarjeta, se autorizará un pequeño cargo (típicamente $1) a su tarjeta y desaparecerá de su estado de cuenta después de unos cuantos días.';
$string['portal:billing.billingdetails.change.placeholders.ccname'] = 'Juan Camaney';
$string['portal:billing.billingdetails.change.placeholders.ccnumber'] = '';
$string['portal:billing.billingdetails.change.placeholders.cvv'] = '';
$string['portal:billing.billingdetails.change.placeholders.expiration'] = 'MM/AA';
$string['portal:billing.billingdetails.set.fields.pay'] = 'Hacer pago';
$string['portal:billing.billingdetails.set.fields.save'] = 'Siguiente';
$string['portal:billing.billingdetails.strings.changepaymentdetails'] = 'Cambiar detalles del pago';
$string['portal:billing.billingdetails.strings.usethis'] = 'Usar este método de pago';
$string['portal:billing.errors.hard.addnewmethod'] = 'Ocurrió un problema duirante el procesamiento del pago. Usted podría querer revisar la información proporcionada e intentarlo nuevamente.';
$string['portal:billing.errors.hard.cancellation'] = 'Ocurrió un problema duirante el procesamiento del pago. Nosotros lo contactaremos en cuanto el problema haya sido resuelto.';
$string['portal:billing.errors.hard.gateway'] = 'No podemos procesar pagos en este momento. Por favor inténtelo nuevamente más tarde.';
$string['portal:billing.errors.hard.generic'] = 'Ocurrió un problema duirante el procesamiento del pago. Por favor revise los detalles de su método de pago.';
$string['portal:billing.errors.hard.updatenewmethod'] = 'Su nueva información de pago fue almacenada exitosamente, pero ocurrió un error akl actualizar su suscripción actual. Nosotros lo contactaremos en cuanto el problema haya sido resuelto.';
$string['portal:billing.errors.soft.contactbank'] = 'Ocurrió un problema duirante el procesamiento del pago. Por favor contacte a su banco o inténtelo de nuevo en un momento.';
$string['portal:billing.errors.soft.duplicate'] = '';
$string['portal:billing.errors.soft.generic'] = 'Ocurrió un problema duirante el procesamiento del pago. Por favor inténtelo nuevamente en un momento.';
$string['portal:billing.errors.soft.wrongcardtype'] = 'No podemos aceptar el tipo de tarjeta que Usted uha usado. Por favor use una diferente';
$string['portal:billing.events.chargedsuccessfully.html'] = '<h1>Su pago del paquete MoodleCloud fue exitoso</h1>
<p>Gracias por renovar su servicio de MoodleCloud. Le deseamos lo mejor en su viaje de aprendizaje con nosotros.</p>
<p>Los detalles de su paquete
<ul><li><a href="%url%">%fqdn%</a></li>
<li>Fecha del próximo pago: %nextBillingDate%</li>
</p>
<p>¿Quiere opinar?</p>
<p>Únase a la <a href="https://moodleassociation.org">Moodle Users Association</a> para contribuir a encauzar la dirección del futuro de Moodle.</p>
<p>Gracias por usar MoodleCloud!</p>
<p>El equipo de MoodleCloud</p>';
$string['portal:billing.events.chargedsuccessfully.plain'] = 'Su pago del paquete MoodleCloud fue exitoso

Gracias por su renovación del servicio MoodleCloud. Le deseamos lo mejor en su viaje de aprendizaje con nosotros.
Los detalles de su paquete
* %url%
* Fecha del próximo pago: %nextBillingDate%

¿Quiere opinar?

Únase a la asociación \'Moodle Users Association\' (https://moodleassociation.org) para contribuir a encaminar la dirección del mapa de crecimiento deMoodle.

Gracias por usar MoodleCloud!

El equipo de MoodleCloud';
$string['portal:billing.events.chargedsuccessfully.title'] = 'Su pago delpaquete MoodleCloud fue exitoso';
$string['portal:billing.events.chargedunsuccessfully.title'] = '¡Oh no! Falló su pago de MoodleCloud';
$string['portal:billing.events.wentpastdue.title'] = '¡Oh oh! Su pago de MoodleCloud ha sido declinado otra vez';
$string['portal:billing.paymentMethods.mastercard'] = 'MasterCard';
$string['portal:billing.paymentMethods.panel.title'] = 'Por favor seleccione un método de pago';
$string['portal:billing.paymentMethods.types.creditcard'] = 'Tarjeta de Crédito';
$string['portal:billing.paymentMethods.types.paypal'] = 'PayPal';
$string['portal:billing.paymentMethods.visa'] = 'Visa';
$string['portal:billing.receipt.abn'] = 'Australian Business Number';
$string['portal:billing.receipt.amount'] = 'Cantidad';
$string['portal:billing.receipt.billedto'] = 'Facturado a';
$string['portal:billing.receipt.cardnumber'] = 'Número de tarjeta';
$string['portal:billing.receipt.date'] = 'Fecha de facturación';
$string['portal:billing.receipt.email'] = 'Email';
$string['portal:billing.receipt.gstlegend'] = '* Impuesto GST solamente es aplicable a Residentes Australianos';
$string['portal:billing.receipt.lineitems.description'] = 'Descripción';
$string['portal:billing.receipt.lineitems.gst'] = 'AU GST*';
$string['portal:billing.receipt.lineitems.total'] = 'Cantidad total';
$string['portal:billing.receipt.name'] = 'Nombre';
$string['portal:billing.receipt.pagetitle'] = 'Factura con impuesto de MoodleCloud  %reference% para %url% en %date%';
$string['portal:billing.receipt.paypalaccount'] = 'Cuenta PayPal';
$string['portal:billing.receipt.pleaseretain'] = 'Por favor conserve una copia de esta factura con impuestos para sus registros.';
$string['portal:billing.receipt.reference'] = 'Referencia de factura';
$string['portal:billing.receipt.summary.chargedto'] = 'Cobrado a';
$string['portal:billing.receipt.summary.outstanding'] = 'Pendiente';
$string['portal:billing.receipt.tandc'] = 'Términos y Condiciones';
$string['portal:billing.receipt.termsaturl'] = 'Usted puede encontrar los Términos del Servicio en <a href="%termsurl%">%termsfullurl%</a>.';
$string['portal:billing.receipt.title'] = 'Factura con impuestos';
$string['portal:billing.receipt.url'] = 'URL';
$string['portal:billing.strings.gstnotice'] = 'El precio incluye impuesto GST';
$string['portal:billing.subscriptions.panel.title'] = 'Pago recurrente';
$string['portal:billing.subscriptions.statuses.Active.title'] = 'Activa';
$string['portal:billing.subscriptions.statuses.Canceled.title'] = 'Cancelada';
$string['portal:billing.subscriptions.statuses.Expired.title'] = 'Caducada';
$string['portal:billing.subscriptions.statuses.Pending.title'] = 'Pendiente';
$string['portal:billing.subscriptions.table.nextBillingDate.title'] = 'Fecha del próximo pago';
$string['portal:billing.subscriptions.table.nextBillingPeriodAmount.title'] = 'Cantidad';
$string['portal:billing.subscriptions.table.planId.title'] = 'Plan';
$string['portal:billing.subscriptions.table.status.title'] = 'Estatus';
$string['portal:billing.transactions.panel.title'] = 'Historia de cuentas';
$string['portal:billing.transactions.statuses.authorization_expired.title'] = 'Falló';
$string['portal:billing.transactions.statuses.authorized.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.authorizing.title'] = 'Procesando';
$string['portal:billing.transactions.statuses.failed.title'] = 'Falló';
$string['portal:billing.transactions.statuses.gateway_rejected.title'] = 'Falló';
$string['portal:billing.transactions.statuses.processor_declined.title'] = 'Falló';
$string['portal:billing.transactions.statuses.settled.title'] = 'Transacción completada';
$string['portal:billing.transactions.statuses.settlement_confirmed.title'] = 'Transacción completada';
$string['portal:billing.transactions.statuses.settlement_declined.title'] = 'Falló';
$string['portal:billing.transactions.statuses.settlement_pending.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.settling.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.submitted_for_settlement.title'] = 'Autorizada';
$string['portal:billing.transactions.statuses.unrecognized.title'] = 'Desconocida';
$string['portal:billing.transactions.statuses.voided.title'] = 'Falló';
$string['portal:billing.transactions.table.amount.title'] = 'Cantidad';
$string['portal:billing.transactions.table.creationDate.title'] = 'Fecha';
$string['portal:billing.transactions.table.invoice.title'] = 'Factura';
$string['portal:billing.transactions.table.planId.title'] = 'Plan';
$string['portal:billing.transactions.table.status.title'] = 'Estatus';
$string['portal:export.html'] = '<h1>¡Hola de parte de MoodleCloud!</h1>
<p>Su sitio MoodleCloud ha sido exportado. El archivo puede descargarse de <a href="%url%">%url%</a>.
<p>Gracias por usar nuestro servicio,</p>
<p>El equipo de MoodleCloud</p>';
$string['portal:export.plain'] = '¡Hola de parte de MoodleCloud!

Su sitio MoodleCloud ha sido exportado. El archivo puede descargarse de %url%.

Gracias por usar nuestro servicio,
El equipo de MoodleCloud';
$string['portal:export.title'] = 'Su exportación de MoodleCloud está lista para descargarse';
$string['portal:graphs.axes.dbsize'] = 'Tamaño de la BasedeDatos';
$string['portal:graphs.axes.filesize'] = 'Tamño de archivo';
$string['portal:graphs.axes.users'] = 'Usuarios';
$string['portal:graphs.filetypes.application'] = 'Datos de aplicación';
$string['portal:graphs.filetypes.audio'] = 'Audio';
$string['portal:graphs.filetypes.example'] = 'Ejemplo';
$string['portal:graphs.filetypes.image'] = 'Imágenes';
$string['portal:graphs.filetypes.message'] = 'Mensajes';
$string['portal:graphs.filetypes.model'] = 'Modelos';
$string['portal:graphs.filetypes.multipart'] = 'Ítems Multi-partes';
$string['portal:graphs.filetypes.text'] = 'Texto';
$string['portal:graphs.filetypes.video'] = 'Videos';
$string['portal:historical.fetchfailure.lead'] = 'Lo sentimos, no pudimos recuperar sus datos históricos. Si Usted regresa después, puede que tengamos algo para Usted.';
$string['portal:historical.fetchfailure.title'] = '¡Oh no!';
$string['portal:list.body.lead'] = '';
$string['portal:list.body.title'] = 'Portal';
$string['portal:list.table.titles.location'] = 'Localización';
$string['portal:list.table.titles.package'] = 'Paquete';
$string['portal:list.table.titles.site'] = 'Sitio';
$string['portal:list.table.titles.subdomain'] = 'Subdominio';
$string['portal:messages.csrffailure'] = 'No se pudo confirmar los cambios. Por favor inténtelo de nuevo.';
$string['portal:messages.pendingprovision'] = '<span class="mc-spin glyphicon glyphicon-refresh"></span> Este sitio está siendo creado . Por favor aguarde, estará en línea prontamente.';
$string['portal:messages.removalfailed'] = 'Falló la remoción. Se ha notificado al soporte de MoodleCloud. Por favor inténtolo nuevamente más tarde.';
$string['portal:messages.removalqueued'] = 'Esperando para remoción';
$string['portal:messages.sitenotfound'] = 'No pudo cargarse el sitio. Por favor inténtelo de nuevo.';
$string['portal:page.body.title'] = 'Portal';
$string['portal:page.button'] = 'Obtener otro sitio';
$string['portal:page.tabs.billing'] = 'Facturación';
$string['portal:page.tabs.package'] = 'Paquete';
$string['portal:page.tabs.paymentdetails'] = 'Detalles del pago';
$string['portal:page.tabs.statistics'] = 'Estadísticas';
$string['portal:page.tabs.support'] = 'Soporte';
$string['portal:page.tabs.tools'] = 'Herramientas';
$string['portal:page.title'] = 'MoodleCloud: Portal';
$string['portal:plans.plans.MCFREE.cost'] = 'Gratuito';
$string['portal:plans.plans.MCFREE.invoicetitle'] = 'Anuncios para Alojamiento MoodleCloud Gratuito';
$string['portal:plans.plans.MCFREE.invoicetitleurl'] = 'Anuncios para Alojamiento Gratuito MoodleCloud en %url%';
$string['portal:plans.plans.MCFREE.title'] = 'Anuncios para Moodle Gratuito';
$string['portal:plans.plans.MCSCHOOL.invoicetitle'] = 'Moodle para Escuela';
$string['portal:plans.plans.MCSCHOOL.title'] = 'Moodle para Escuela';
$string['portal:plans.strings.plan'] = 'Plan';
$string['portal:purchases.confirmationpage.cancel'] = 'No Gracias';
$string['portal:purchases.confirmationpage.continue'] = 'Pagar ahora';
$string['portal:purchases.confirmationpage.lead'] = 'Usted está comprando:';
$string['portal:purchases.confirmationpage.paymentnotice'] = 'A Usted se le cobrará esta cantidad hoy, y cada mes siguiente, alrededor del día  %dayofmonth%  de cada mes, hasta que Usted quite este complemento.';
$string['portal:purchases.confirmationpage.title'] = 'Método de pago - confirmación';
$string['portal:siteinfo.page.title'] = 'MoodleCloud: Información del sitio para SUBDOMAIN';
$string['portal:siteinfo.panels.historical.title'] = 'Estadísticas históricas';
$string['portal:siteinfo.panels.info.limit_disk'] = 'Espacio de Disco %maxbytes% Mb';
$string['portal:siteinfo.panels.info.limit_users'] = '%maxusers% usuarios';
$string['portal:siteinfo.panels.info.limits'] = 'Límites';
$string['portal:siteinfo.panels.info.location'] = 'Localizacion del alojamiento';
$string['portal:siteinfo.panels.info.package'] = 'Paquete';
$string['portal:siteinfo.panels.info.sitename'] = 'Nombre del sitio';
$string['portal:siteinfo.panels.info.status'] = 'Estatus';
$string['portal:siteinfo.panels.info.title'] = 'Información';
$string['portal:siteinfo.panels.info.version'] = 'Versión';
$string['portal:siteinfo.panels.statistics.title'] = 'Estadísticas';
$string['portal:statistics.fetchfailure.lead'] = 'Los entimos, no pudimos recuperar sus estadísticas actuales. Si Usted regresa después, puede que tengamos algo para Usted.';
$string['portal:statistics.fetchfailure.title'] = '¡Oh no!';
$string['portal:statistics.graphs.databasesize'] = 'Tamño de la BasedeDatos';
$string['portal:statistics.graphs.files'] = 'Archivos';
$string['portal:statistics.graphs.users'] = 'Usuarios';
$string['portal:support.certifiedpartner'] = 'Su socio Moodle certificado local amistoso es:';
$string['portal:support.contact.button'] = 'Contactar ahora';
$string['portal:support.contact.flash'] = '¡Su solicitud ha sido enviada, gracias!';
$string['portal:support.contact.sendbutton'] = 'Enviar consulta';
$string['portal:support.contact.title'] = 'Contactar a su socio';
$string['portal:support.title'] = '¿Necesita ayuda con su sitio Moodle?';
$string['portal:tasks.removal.warning.html'] = '<h1>¡Hola de parte de MoodleCloud!</h1>
<p>Hemos notado que Usted no ha estado usando su sitio MoodleCloud <a href="%url%">%fqdn%</a> en los últimos 60 días.</p>
<p>De acuerdo con nuestros Términos y Condiciones, nosotros estaremos eliminando su sitio después del %day% %month% %year%.</p>
<p>
Usted puede evitar que suceda esto al <a href="%url%/login/index.php">ingresar al sitio</a> antes de esta fecha.</p>
<p>Si Usted quisiera proporcionarnos una retroalimentación respecto a prqué Usted no está usando su sitio MoodleCloud , por favor complete  <a href="https://www.surveymonkey.com/r/moodlecloud-inactive">esta pequeña encuesta</a>.</p>

<p>Gracias por probar nuestro servicio,,</p>
<p>El equipo de MoodleCloud</p>';
$string['portal:tasks.removal.warning.plain'] = '¡Hola!

Hemos notado que Usted no ha estado usando su sitio MoodleCloud %fqdn% en los últimos 60 días.

De acuerdo con nuestros Términos y Condiciones, nosotros estaremos eliminando su sitio después del %day% %month% %year%.

Usted puede evitar que suceda esto al ingresar antes de esta fecha en %url%/login/index.php.

Si Usted quisiera proporcionarnos una retroalimentación respecto a prqué Usted no está usando su sitio MoodleCloud , por favor complete esta pequeña encuesta: https://www.surveymonkey.com/r/moodlecloud-inactive

Gracias por probar nuestro servicio,
El equipo de MoodleCloud';
$string['portal:tasks.removal.warning.title'] = 'El  "%subdomain%" del sitio MoodleCloud está inactivo y será eliminado pronto';
$string['portal:view.actionpending.panel.body'] = 'Cambios en progreso';
$string['portal:view.actionpending.panel.lead'] = 'Están en progreso modificaciones para este sitio y estarán bloqueados nuevos cambios hasta que se hayan completado las acciones en curso.</p>';
$string['portal:view.actionpending.panel.title'] = 'Modificaciones pendientes';
$string['portal:view.billing.addcc.button'] = 'Guardar arjeta de crédito';
$string['portal:view.billing.addcc.success'] = 'Método de pago guardado exitosamente';
$string['portal:view.billing.panel.empty'] = 'sted no ha hecho compra alguna. Cuando Usted compre un complemento para su sitio MoodleCloud, entonces los detalles de su facturación y la historia de su facturación se mostrarán aquí.';
$string['portal:view.billing.panel.title'] = 'Detalles de tarjeta de crédito';
$string['portal:view.billing.payment.success'] = 'Su pago fue exitoso.';
$string['portal:view.billing.paymentmethod.title'] = 'Método actual de pago';
$string['portal:view.danger.modal.buttons.cancel'] = 'Cancelar';
$string['portal:view.danger.modal.buttons.continue'] = 'Si, por favor quite mi sitio';
$string['portal:view.danger.modal.lead'] = 'Asegúrese de estar listo para decir adios. Al confirmar debajo, Usted acepta que su sitio sea eliminado permanentemente y consiente a perder el derecho a cualquier cantidad  por el concepto de inscripción no utilizada.';
$string['portal:view.danger.modal.title'] = 'Confirmar remoción';
$string['portal:view.danger.panel.body.buttons.remove'] = 'Remover (quitar) mi sitio MoodleCloud';
$string['portal:view.danger.panel.body.buttons.title'] = '¿Está Usted seguro de querer dejarnos?';
$string['portal:view.danger.panel.body.lead'] = '<p>Una vez que Usted remueva (quite) este sitio MoodleCloud, será real y permanentemente eliminado.</p>
<p>Por favor asegúrese de que ya ha acabado de hacer lo que necesitaba y de que ya ha recuperado cualquier contenido que pudiera necesitar.</p>';
$string['portal:view.danger.panel.body.title'] = 'Remover (quitar) mi sitio MoodleCloud';
$string['portal:view.danger.panel.title'] = 'Cosas terroríficas';
$string['portal:view.export.flash'] = 'Ahora mismo estamos exportando su sitio "%subdomain%". Se le enviará un Email cuando el proceso esté completo.';
$string['portal:view.export.panel.body.intro'] = 'El exportar su sitio le dará a Usted la BasedeDatos y todos sus archivos. Usted puede usar esto para alojar su sitio Moodle en su propio servidor o en el servidor de su  <a href="https://moodle.com/partners/">Moodle Partner</a>. Por favor tenga en cuenta que el proceso de esportación tardará un tiempo. Usted recibirá un Email con un enlace para descarga cuando esté listo.';
$string['portal:view.export.panel.body.link'] = 'Su sitio fue exportadao por última vez en  %day% %month% %year%. Usted puede  <a href="%linktobackup%">descargarlo aquí</a>.';
$string['portal:view.export.panel.body.requested'] = 'Su solicitud para exportar su sitio está siendo procesada. Se le enviará un Email cuando la exportación esté disponible para descargarse.';
$string['portal:view.export.panel.button'] = 'Exportar este sitio';
$string['portal:view.export.panel.lead'] = 'Exportar este sitio';
$string['portal:view.export.panel.title'] = 'Datos de su MoodleCloud';
$string['regions:au'] = 'Autralia';
$string['regions:eu'] = 'Irlanda';
$string['regions:us'] = 'Estados Unidos';
$string['signup:auditlog.account.created'] = 'Se creó nueva cuenta de usuario';
$string['signup:auditlog.account.linked'] = 'Enlazado a cuenta existente';
$string['signup:auditlog.account.validated'] = 'Validación completa de cuenta de usuario';
$string['signup:auditlog.account.validationstarted'] = 'Mensaje de validación de cuenta enviado';
$string['signup:auditlog.site.automaticallyconfirmed'] = 'Sitio confirmado sin validación de cuenta';
$string['signup:auditlog.site.provisionQueued'] = 'Sitio puesto en cola para aprovisionamiento';
$string['signup:auditlog.site.provisionmailedout'] = 'Mensaje Email de Aprovisionamiento de finalización enviado';
$string['signup:auditlog.site.reserved'] = 'El sitio fue reservado';
$string['signup:authcode.body.lead_email'] = '¡Revise su buzón de Email! Le hemos enviado un código de verificación temporal a  %email%. Escriba debajo su código de verificación.';
$string['signup:authcode.body.lead_phone'] = 'Hemos mandado un código temporal de verificación a  %phonenumber%. Ingrese debajo su código de verificación.';
$string['signup:authcode.body.links.nocodereceived'] = 'No recibí mi código';
$string['signup:authcode.body.links.startover'] = '¿Desea empezar nuevamente? <a href="%link%">Regresemos al principio</a>.';
$string['signup:authcode.body.title'] = 'Verifique su identidad';
$string['signup:authcode.form.fields.authcode'] = 'Código de verificación';
$string['signup:authcode.form.fields.continue'] = 'Siguiente';
$string['signup:authcode.form.placeholders.authcode'] = '123456';
$string['signup:authcode.modal.button'] = 'Cerrar';
$string['signup:authcode.modal.lead_email'] = 'Si nuestro mensaje de Email no ha llegado a su buzón o a su carpeta de \'spam\'  (correo no deseado), es posible que lo estemos enviando al lugar equivocado; asegúrese de que se lo estemos enviando a Usted al revisar su dirección Email en la página de verificación (cierre esta caja para verla).';
$string['signup:authcode.modal.lead_phone'] = 'Si nuestro mensaje de texto SMS no ha llegado a su teléfono móvil/celular, es posible que lo estemos enviando al lugar equivocado; asegúrese de que se lo estemos enviando a Usted al revisar su número de teléfono  en la página de verificación (cierre esta caja para verla).';
$string['signup:authcode.modal.link'] = 'Visite las FAQ para más detalles.';
$string['signup:authcode.modal.title'] = 'No recibí mi código';
$string['signup:errors.blacklistinline'] = 'Lo sentimos, ese sitio no está disponible.';
$string['signup:errors.invalidinline'] = 'Cree su nombre del sitio con 3-53 letras, números y guiones. No comience ni termine con un guión.';
$string['signup:errors.maxsites'] = 'Ya existe una cuenta de usuario con un número de teléfono que coincide. Los usuarios solamente pueden crear un único sitio de Moodle Gratuito.';
$string['signup:errors.mustlogin'] = 'Este número de teléfono está enlazado a una cuenta existente. <a href="%loginurl%">Por favor ingrese</a> o use un número de teléfono diferente.';
$string['signup:errors.reserved'] = '¡Oh no! Alguien más ya tomó este.';
$string['signup:errors.sessiontimeout'] = 'Debido a inactividad, su sesión se ha desconectado.';
$string['signup:freesitelimit.buttons.buy_a_plan'] = 'Comprar Un Plan';
$string['signup:freesitelimit.buttons.go_to_portal'] = 'Ir al Portal';
$string['signup:freesitelimit.text'] = 'Existe un límite de un sitio gratuito por cuenta y al parecer Usted ya tiene un sitio gratuito.';
$string['signup:freesitelimit.title'] = 'Demasiado de algo bueno';
$string['signup:messages.emailverified'] = '¡Gracias por completar la verificación del Email!';
$string['signup:messages.failedvalidationcode'] = 'Algo no está completamente bien con eso. ¿Lo escribió correctamente?';
$string['signup:messages.passwordupdated'] = '¡Genial! Hemos actualizado tu contraseña. Usted puede usarla para ingresar a su sitio MoodleCloud.';
$string['signup:messages.sessionmoved'] = 'El proceso de creación del sitio ha sido continuado en otra parte y se interrumpió aquí por razones de seguridad.';
$string['signup:messages.validationcode'] = '%code% es código de verificación para  %subdomain%.moodlecloud.com';
$string['signup:nopassword.body.continue'] = 'Siguiente';
$string['signup:nopassword.body.lead'] = '(aquí podría haber un poco de texto)';
$string['signup:nopassword.body.text'] = 'Su contraseña para este sitio es la misma que su cuenta existente de MoodleCloud';
$string['signup:nopassword.body.title'] = 'Asi que, acerca de su contraseña.';
$string['signup:page.description'] = '\'\'Software\'\' de apredizaje Moodle gratuito alojado en servidores en la nube para que profesores e instructores  puedan implementar sitios Moodle en un instante.';
$string['signup:page.title'] = 'Apuntarse a MoodleCloud';
$string['signup:password.body.lead'] = 'Usted usará esta contraseña para ingresar tanto a a su sitio  como al Portal MoodleCloud.';
$string['signup:password.body.title'] = 'Elegir una contraseña';
$string['signup:password.form.fields.password'] = 'Nueva contraseña (mínimo 5 caracteres)';
$string['signup:password.form.fields.password_confirmation'] = 'Y nuevamente, solo para asegurarnos';
$string['signup:password.form.fields.save'] = 'Siguiente';
$string['signup:password.form.placeholders.password'] = '';
$string['signup:password.form.placeholders.password_confirmation'] = '';
$string['signup:payment.body.charges.taxfree'] = 'Usted seleccionó el paquete %package% , plan %plan%. Su pago de (dólares australianos) AUD %costperyear% es para una suscripción de 12 meses a este plan.';
$string['signup:payment.body.charges.withgst'] = 'Usted seleccionó el paquete %package% , plan %plan%. Su pago de (dólares australianos) AUD %costperyear% (incluyendo impuesto GST) es para una suscripción de 12 meses a este plan.';
$string['signup:payment.body.lead'] = '';
$string['signup:payment.body.title'] = 'Selecione su método de pago';
$string['signup:payment.form.fields.continue'] = 'Siguiente';
$string['signup:personal.body.lead'] = '';
$string['signup:personal.body.title'] = 'Ingrese sus detalles';
$string['signup:personal.form.fields.city'] = 'Ciudad';
$string['signup:personal.form.fields.continue'] = 'Siguiente';
$string['signup:personal.form.fields.country'] = 'País';
$string['signup:personal.form.fields.email'] = 'Dirección email';
$string['signup:personal.form.fields.email_confirmation'] = 'Confirmación de dirección Email';
$string['signup:personal.form.fields.firstname'] = 'Nombre(s)';
$string['signup:personal.form.fields.lastname'] = 'Apellido(s)';
$string['signup:personal.form.fields.marketing'] = 'Deseo recibir novedades de MoodleCloud, sugerencias y actualizaciones.';
$string['signup:personal.form.fields.marketingnote'] = 'Nosotros solamente le enviaremos notificaciones Email cuando estemos avisando de novedades, sugerencias o actualizaciones de cualquiera de nuestros productos. Usted puede des-suscribirse  en cualquier momento. Vea nuestra  <a href="%privacyurl%" target="_blank">Política de Privacidad</a> para más detalles.';
$string['signup:personal.form.fields.organisationname'] = 'Nombre de la Organización';
$string['signup:personal.form.fields.organisationtype.charity'] = 'Beneficiencia';
$string['signup:personal.form.fields.organisationtype.charter_school'] = 'Escuela Autónoma';
$string['signup:personal.form.fields.organisationtype.college'] = 'Colegio';
$string['signup:personal.form.fields.organisationtype.college_department'] = 'Departamento del Colegio';
$string['signup:personal.form.fields.organisationtype.company_course_provider'] = 'Proveedor de curso de Compañía';
$string['signup:personal.form.fields.organisationtype.company_department'] = 'Departamento de Compañía';
$string['signup:personal.form.fields.organisationtype.company_internal'] = 'Interno de Compañía';
$string['signup:personal.form.fields.organisationtype.government'] = 'Gobierno';
$string['signup:personal.form.fields.organisationtype.high_school'] = 'Escuela Secundaria/Preparatoria';
$string['signup:personal.form.fields.organisationtype.high_school_department'] = 'Desprtamento de Escuela Secundaria/Preparatoria';
$string['signup:personal.form.fields.organisationtype.high_school_district'] = 'Distrito de Escuela Secundaria/Preparatoria';
$string['signup:personal.form.fields.organisationtype.independant_teacher'] = 'Profesor independiente';
$string['signup:personal.form.fields.organisationtype.other'] = 'Otro';
$string['signup:personal.form.fields.organisationtype.primary_school'] = 'Escuela Primaria';
$string['signup:personal.form.fields.organisationtype.school_district'] = 'Distrito Escolar';
$string['signup:personal.form.fields.organisationtype.university'] = 'Universidad Completa';
$string['signup:personal.form.fields.organisationtype.university_department'] = 'Departamento de Universidad';
$string['signup:personal.form.fields.organisationtype_label'] = 'Tipo de organización';
$string['signup:personal.form.fields.password'] = 'Contraseña';
$string['signup:personal.form.fields.personalrole'] = 'Su rol';
$string['signup:personal.form.fields.phonenumber'] = 'Número de teléfono móvil/celular';
$string['signup:personal.form.fields.postcode'] = 'Código Postal';
$string['signup:personal.form.fields.state'] = 'Estado';
$string['signup:personal.form.fields.street'] = 'Dirección';
$string['signup:personal.form.fields.streetaddress'] = 'Dirección';
$string['signup:personal.form.fields.tandc'] = 'Estoy de acuerdo con los <a href="/terms" target="_blank">Términos y Condiciones del Servicio</a> de MoodleCloud y conozco la <a href="/privacy" target="_blank">Política sobre Privacidad</a>';
$string['signup:personal.form.fields.timezone'] = 'Su Zona Horaria';
$string['signup:personal.form.placeholders.city'] = '';
$string['signup:personal.form.placeholders.country'] = 'Seleccionar...';
$string['signup:personal.form.placeholders.email'] = '';
$string['signup:personal.form.placeholders.firstname'] = '';
$string['signup:personal.form.placeholders.lastname'] = '';
$string['signup:personal.form.placeholders.organisationname'] = '';
$string['signup:personal.form.placeholders.organisationtype'] = 'Seleccionar...';
$string['signup:personal.form.placeholders.password'] = '';
$string['signup:personal.form.placeholders.personalrole'] = '';
$string['signup:personal.form.placeholders.phonenumber'] = '';
$string['signup:personal.form.placeholders.postcode'] = '';
$string['signup:personal.form.placeholders.state'] = '';
$string['signup:personal.form.placeholders.street'] = '';
$string['signup:personal.form.placeholders.timezone'] = 'Seleccionar Zona Horaria';
$string['signup:privacy.title'] = 'Política de Privacidad de MoodleCloud';
$string['signup:provision_mail.page.html'] = '<h1>¡Bienvenido a MoodleCloud!</h1>
<p>Su sitio Moodle gratuito<a href="%url%">%url%</a> ha sido creado ya.</p>
<p>Usted puede ingresar a su sitio Moodle usando el nombre_de_usuario "admin" y la contraseña que Usted mismo configuró al apuntarse.</p>
<p>Su sitio gratuito está limitado a 50 cuentas de usuario activas y una cuota de disco de 200Mb.</p>
<p>Sugerencias:</p>
<ul>
<li>Usted puede eliminar a los usuarios no-deseados en la Administración del Sitio para hacer espacio para más usuarios.</li>
<li>Para evitar que el contenido le agote su cuota de disco, use recursos públicos que estén disponibles en internet, tales como páginas web, videos YouTube y similares.</li>
</ul>
<p>Para monitorer su uso en cualquier momento, visite su portal MoodleCloud en moodlecloud.com. Ingrese usando el nombre de su sitio "%subdomain%" y la misma contraseña que usó para su cuenta de administrador en su sitio.</p>
<p>Saludos,</p>
<p>El equipo de MoodleCloud</p>';
$string['signup:provision_mail.page.plain'] = '¡Bienvenido a MoodleCloud!
Su sitio Moodle gratuito %url% ha sido creado ya.
Usted puede ingresar a su sitio Moodle usando el nombre_de_usuario "admin" y la contraseña que Usted mismo configuró al apuntarse.
Su sitio gratuito está limitado a 50 cuentas de usuarios activas y una cuota de disco de 200Mb.
Sugerencias:
 - Usted puede eliminar a  los usuarios no-deseados en la Administración del Sitio para hacer espacio para más usuarios.
 - Para evitar que el contenido le agote su cuota de disco, use recursos públicos que estén disponibles en internet, tales como páginas web, videos YouTube y similares.

Para monitorer su uso en cualquier momento, visite su portal MoodleCloud en moodlecloud.com. Ingrese usando el nombre de su sitio "%subdomain%" y la misma contraseña que usó para su cuenta de administrador en su sitio.

Saludos,
El equipo de MoodleCloud';
$string['signup:provision_mail.page.title'] = '¡Su sitio MoodleCloud %fqdn% está listo!';
$string['signup:provision_mail.subject'] = '¡Su sitio MoodleCloud %site.fqdn% está listo!';
$string['signup:reserve.available'] = '¡Órale! Su nombre para el sitio está disponible.';
$string['signup:reserve.body.lead'] = '¡Aquí está la parte interesante! Dele a su sitio un nombre  y un lugar para vivir. Elija sabiamente - no podrán cambiarlo después.';
$string['signup:reserve.body.title'] = 'Darle un nombre a su sitio MoodleCloud';
$string['signup:reserve.form.fields.continue'] = 'Siguiente';
$string['signup:reserve.form.fields.region'] = 'Localización del alojamiento';
$string['signup:reserve.form.fields.subdomain'] = 'Nombre del sitio';
$string['signup:reserve.form.placeholders.subdomain'] = 'susitio';
$string['signup:reserve.form.tooltips.region'] = 'Aquí es donde será alojado su sitio. Nosotros recomendamos elegir la localización más cercana a Usted y sus estudiantes.';
$string['signup:signin.body.lead'] = 'Ingresar usando su nombre y contraseña del sitio MoodleCloud.';
$string['signup:signin.body.title'] = 'Ingresar a MoodleCloud para comenzar';
$string['signup:status.body.ariasetupcomplete'] = 'La configuración de su nuevo sitio ha sido completada. Ahora puede Usted ingresar.';
$string['signup:status.body.lead'] = '<p>¡Hey amigo!</p>
<p>Usted lo quiso, ahora Usted tiene su propio sitio Moodle.</p>
<p>Continúe creando su espacio de aprendizaje en-línea perfecto.</p>';
$string['signup:status.body.login'] = 'Ingresar';
$string['signup:status.body.title'] = '¡Todo heco! Su propio sitio Moodle, gratuito!';
$string['signup:steps.x'] = 'Paso %x%';
$string['signup:steps.xofy'] = 'Paso %x% de %y%';
$string['signup:support.body.notready'] = 'Siéntese, ¡su sitio MoodleCloud ya casi está listo!';
$string['signup:support.body.portal.text'] = 'En su <a href="%portalurl%">Portal de MoodleCloud</a> Usted puede revisar sus paquetes y pagos vigentes, información de facturación y más. Para ingresar al portal, su  <strong>nombre_de_usuario</strong> es la URL de su sitio, y su <strong>contraseña</strong> es su contraseña de administador Moodle. El portal es accesible desde su sitio MoodleCloud o desde moodlecloud.com.';
$string['signup:support.body.portal.title'] = 'Portal';
$string['signup:support.body.support.text'] = '<p>El alojamiento en MoodleCloud es barato  porque no incluimos mucho soporte. Vea nuestra página de <a href="https://moodle.com/cloud/faq/">FAQ</a> para conocer algunas respuestas a preguntas frecuentes que Usted pudiera tener, o <a href="http://docs.moodle.org">Moodle Docs</a> para información más detallada acerca del uso de Moodle.</p>
<p>Si Usted necesita más ayuda, le sugerimos que platique con alguno de nuestros expertos Socios Moodle (Moodle Partners). Ellos ofrecen un rango de servicios, tales como entrenamiento y personalización de temas. Cuando Usted esté listo para verdaderamente turbo-cargar su experiencia Moodle, ellos pueden mover su sitio MoodleCloud hacia su propio alojamiento con más espacio, personalización y otras características.</p>';
$string['signup:support.body.support.title'] = 'Soporte';
$string['signup:support.form.fields.continue'] = 'Gracias, ¡ahora lléveme a mi sitio Moodle!';
$string['signup:support.head.lead'] = 'Antes de dirigirse a su nuevo y reluciente sitio Moodle en %siteurl%, nos gustaría comunicarle algunos detalles importantes.';
$string['signup:support.head.lead_paid'] = 'Gracias. Su pago ha sido procesado exitosamente.';
$string['signup:support.head.title'] = '¡Éxito!';
$string['signup:support.link'] = '¡LLéveme ahora a mi sitio MoodleCloud!';
$string['signup:support.partner.link'] = 'Usted puede contactar a su Socio Moodle mediante la <a href="%supporturl%">pestaña de Soporte en su Portal</a>.';
$string['signup:support.partner.title'] = 'Basándonos en la información que Usted nos dió, lo hemos apareado con este Socio Moodle:';
$string['signup:terms.title'] = 'Condiciones del servicio del Sitio MoodleCloud';
$string['signup:texts.statusintro'] = 'POR-HACER';
$string['signup:texts.statustitle'] = 'Usted lo quiso. Su propio sitio Moodle, gratuito.';
$string['signup:usertype.body.lead_create'] = '¿Es nuevo en MoodleCloud? Crear ahora una cuenta nueva.';
$string['signup:usertype.body.lead_login'] = '¿Ya tiene un sitio MoodleCloud? Ingrese para conectar sus sitios a una sola cuenta.';
$string['signup:usertype.body.title'] = 'Comencemos';
$string['signup:usertype.form.fields.existing'] = 'Ingresar';
$string['signup:usertype.form.fields.new'] = 'Crear cuenta nueva';
$string['signup:verification_mail.page.html'] = '<h1>Verifique su dirección Email</h1>
<p>Su código de verificación MoodleCloud es: %code%. Copie este código en la pantalla de verificación para validar su cuenta..</p>
<p>El equipo MoodleCloud</p>';
$string['signup:verification_mail.page.plain'] = 'Verifique su dirección Email

Su código de verificación MoodleCloud es: %code%. Copie este código en la pantalla de verificación para validar su cuenta.

El equipo MoodleCloud';
$string['signup:verification_mail.page.title'] = 'Código de verificación MoodleCloud';
$string['signup:verification_mail.subject'] = 'Verificación de cuenta MoodleCloud';
$string['status:label.expired'] = 'Removido por inactividad';
$string['status:label.pendingIdentityConfirmation'] = 'Pendiente de verificación';
$string['status:label.pendingPayment'] = 'Pago pendiente';
$string['status:label.pendingProvision'] = 'Esperando la creación';
$string['status:label.pendingRemoval'] = 'Esperando la remoción';
$string['status:label.provisioned'] = 'Vivo';
$string['status:label.removed'] = 'Removido';
$string['status:label.reserved'] = 'Reservado';
$string['status:tooltip.expired'] = 'Este sitio ha sido removido de nuestro sistema por causa de inactividad';
$string['status:tooltip.pendingIdentityConfirmation'] = 'Este sitio ha sido reservado y se ha enviado un mensaje de verificación de identidad.';
$string['status:tooltip.pendingPayment'] = 'Este sitio ha sido reservado; sin embargo, actualmente el pago está incompleto.';
$string['status:tooltip.pendingProvision'] = '¡Su sitio ha sido enviado a nuestro sistema de aprovisionamiento y muy pronto estará con Usted!';
$string['status:tooltip.pendingRemoval'] = 'Este sitio ha sido colocando en espera para ser removido (eliminado) y pronto será removido de nuestros sistemas.';
$string['status:tooltip.provisioned'] = 'Este sitio actualmente está vivo y disponible.';
$string['status:tooltip.removed'] = 'Este sitio ha sido removido (quitado).';
$string['status:tooltip.reserved'] = 'Este sitio ha sido reservado pero el proceso de registro todavía no ha sido completado.';
$string['telephony:lookup.apifailure'] = 'Oh no. Algo salió mal con nuestro sistema de mensajería. Por favor inténtelo de nuevo en un momento posterior.';
$string['telephony:lookup.invalidnumber'] = 'Número de teléfono inválido';
$string['telephony:lookup.notacellphone'] = 'Usted debe de proporcionar un número válido de teléfono celular.';
$string['telephony:validator.apifailure'] = 'Oh no. Algo salió mal con nuestro sistema de mensajería. Por favor inténtelo de nuevo en un momento posterior.';
$string['validators:billing.ccname.mustexist'] = 'Usted debe de proporcionar el nombre del titular de la tarjeta de crédito.';
$string['validators:fos_user.current_password.invalid'] = 'La contraseña ingresada es inválida';
$string['validators:fos_user.email.already_used'] = 'El Email ya está en uso';
$string['validators:fos_user.email.blank'] = 'Por favor escriba una dirección de Email';
$string['validators:fos_user.email.invalid'] = 'El Email no es válido';
$string['validators:fos_user.email.long'] = '[-Inf,Inf]El Email es demasiado largo';
$string['validators:fos_user.email.short'] = '[-Inf,Inf]El Email es demasiado corto';
$string['validators:fos_user.group.blank'] = 'Por favor escriba un nombre';
$string['validators:fos_user.group.long'] = '[-Inf,Inf]El nombre es demasiado largo';
$string['validators:fos_user.group.short'] = '[-Inf,Inf]El nombre es demasiado corto';
$string['validators:fos_user.new_password.blank'] = 'Por favor escriba una contraseña nueva';
$string['validators:fos_user.new_password.short'] = '[-Inf,Inf]La contraseña nueva es demasiado corta';
$string['validators:fos_user.password.blank'] = 'Por favor escriba una contraseña';
$string['validators:fos_user.password.mismatch'] = 'Las contraseñas introducidas no coinciden';
$string['validators:fos_user.password.short'] = '[-Inf,Inf]La contraseña es demasiado corta';
$string['validators:fos_user.username.already_used'] = 'El nombre_de_usuario ya está en uso';
$string['validators:fos_user.username.blank'] = 'Por favor escriba un nombre_de_usuario';
$string['validators:fos_user.username.long'] = '[-Inf,Inf]El nombre_de_usuario es demasiado largo';
$string['validators:fos_user.username.short'] = '[-Inf,Inf]El nombre_de_usuario es demasiado corto';
$string['validators:signup.country.mustexist'] = 'Por favor elija su país';
$string['validators:signup.email.format'] = 'Por favor ingrese una dirección Email válida.';
$string['validators:signup.email.mismatch'] = 'Las direcciones Email que ingresó no coinciden.';
$string['validators:signup.email.mustexist'] = 'Por favor ingrese una dirección Email válida.';
$string['validators:signup.phone.mustexist'] = 'Por favor ingrese su número de teléfono móvil/celular.';
$string['validators:signup.phone.notacellphone'] = 'Por favor proporcione un número de teléfono móvil/celular válido en formato internacional. Nosotros le enviaremos un código de validación a este número.';
$string['validators:signup.phone.wrongformat'] = 'Por favor proporcione su número de telkéfono en formato internacional, comenzando con \'+\' e incluyendo su código de país.';
$string['validators:signup.status.password_length'] = 'Su contraseña debe de tener 5 caracteres o más.';
$string['validators:signup.status.password_mismatch'] = 'Las contraseñas que ingresó no coinciden.';
$string['validators:signup.tandc.mustagree'] = 'Para poder usar MoodleCloud, Usted debe de aceptar los Términos y Condiciones del Servicio.';
$string['validators:signup.timezone.mustselect'] = 'Por favor seleccione su huso horario.';
$string['validators:site.firstname.mustexist'] = 'Por favor especifique su Nombre(s)';
$string['validators:site.lastname.mustexist'] = 'Por favor especifique su Apellido(s)';
$string['validators:site.subdomain.format'] = 'Los subdominios deben de empezar con una letra. deben de contener una combinación de letras, números y guiones solamente. (no usar eñe ni vocales acentuadas).';
$string['validators:site.subdomain.maxlength'] = 'Los subdominios no pueden tener más de 53 caracteres.';
$string['validators:site.subdomain.minlength'] = 'Los subdominios deben de tener al menos tres caracteres';
$string['validators:site.subdomain.mustexist'] = 'Usted necesita especificar un subdominio';
