<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_aigne', language 'es_mx', version '3.8'.
 *
 * @package     theme_aigne
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'accesibilidad';
$string['accessibilitydesc'] = 'Información sobre accesibilidad';
$string['accessibilitypage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Accesibilidad</h2>
<p>Aquí puede introducir las herramientas que estan instaladas en el sitio web para
   facilitar la navegación a personas con dificultades visuales o mobilidad reducida.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <p>&nbsp;</p>';
$string['aco5alt1'] = 'Escriba aquí el texto alterno para la imagen 1 del fuelle';
$string['aco5alt2'] = 'Escriba aquí el texto alterno para la imagen 2 del fuelle';
$string['aco5alt3'] = 'Escriba aquí el texto alterno para la imagen 3 del fuelle';
$string['aco5alt4'] = 'Escriba aquí el texto alterno para la imagen 4 del fuelle';
$string['aco5alt5'] = 'Escriba aquí el texto alterno para la imagen 5 del fuelle';
$string['aco5cap1'] = 'Raia venenosa _ Texto de fuelle 1';
$string['aco5cap2'] = 'Tubarão _ Texto de fuelle 2';
$string['aco5cap3'] = 'Polvo _ Texto de fuelle 3';
$string['aco5cap4'] = 'Peixe _ Texto de fuelle 4';
$string['aco5cap5'] = 'Mergulho _ Texto de fuelle 5';
$string['acoaalt1'] = 'Escriba aquí el texto alterno para la imagen del fuelle 1';
$string['acoaalt2'] = 'Escriba aquí el texto alterno para la imagen del fuelle 2';
$string['acoaalt3'] = 'Escriba aquí el texto alterno para la imagen del fuelle 3';
$string['acoaalt4'] = 'Escriba aquí el texto alterno para la imagen del fuelle 4';
$string['acoaalt5'] = 'Escriba aquí el texto alterno para la imagen del fuelle 5';
$string['acoacap1'] = 'Pastenague _ Texto del fuelle 1';
$string['acoacap2'] = 'Requin _ Texto del fuelle 2';
$string['acoacap3'] = 'Pieuvre _ Texto del fuelle 3';
$string['acoacap4'] = 'Poisson _ Texto del fuelle 4';
$string['acoacap5'] = 'Bouteilles _ Texto del fuelle 5';
$string['acoainfo1'] = 'Escriba aquí información interesante para mostrar en el fuelle 1';
$string['acoainfo2'] = 'Escriba aquí información interesante para mostrar en el fuelle 2';
$string['acoainfo3'] = 'Escriba aquí información interesante para mostrar en el fuelle 3';
$string['acoainfo4'] = 'Escriba aquí información interesante para mostrar en el fuelle 4';
$string['acoainfo5'] = 'Escriba aquí información interesante para mostrar en el fuelle 5';
$string['afternoon_greeting'] = '¡ Buenas tardes !';
$string['aim'] = 'URL de AIM';
$string['aimdesc'] = 'Escriba la URL de su perfil en AIM.
<a href="http://www.aim.com/" target="_blank"> (www.aim.com) .</a>';
$string['aletters'] = 'Efecto de Separación de Letras';
$string['alettersdesc'] = 'Cuando se pasa el ratón encima, se puede configurar un efecto de separación de letras. Seleccione aquí el intervalo entre letras, y si se equivocó, seleccione la primera opción.
Tenga en cuenta que algunos enlaces no tienen espaciamiento de letra por defecto.';
$string['alettersno'] = 'Sin espaciamiento de letra';
$string['backbody'] = 'Fondo de la página';
$string['backbodydesc'] = 'Si lo desea, puede añadir una imagen para que aparezca en el fondo de todas las páginas. <br />
La imagen debe ser un archivo JPG / PNG / GIF con un mínimo de 775 pixeles de ancho. También debe recordar que se repetirá en el eje de las Y (verticalmente).';
$string['backcolor'] = 'Color del fondo';
$string['backcolordesc'] = 'Si lo dese, puede configurar un color en lugar de sobreponer una imagen de fondo. <br />
Si quiere mantener el color original, seleccione blanco o escriba # FFFFFF.';
$string['backlogo'] = 'Imagen de fondo del logo';
$string['backlogodesc'] = 'Si lo desea, puede añadir una imagen de fondo para el logo. <br />
Esta imagen debe ser un archivo JPG / PNG / GIF con 200 pixeles de ancho por 75 pixeles de alto.';
$string['banner1alt'] = 'Escriba aquí el texto alterno para la imagen del banner';
$string['banner1ttl'] = 'Escrina aquí el título del banner';
$string['banner1txt'] = 'Escriba aquí el texto que desea que aparezca en el banner';
$string['bcsep'] = 'Separador de la Ruta de Navegación';
$string['bcsep1'] = 'Flecha convencional ( ► )';
$string['bcsep2'] = 'Comillas Latinas de cierre ( » )';
$string['bcsep3'] = 'Línea vertical ( | )';
$string['bcsep4'] = 'Barra inclinada ( / )';
$string['bcsep5'] = 'Guión bajo ( _ )';
$string['bcsep6'] = 'Dos puntos repetidos ( ::: )';
$string['bcsep7'] = 'Espacio en blanco ( &nbsp; )';
$string['bcsepdesc'] = 'Seleccione el tipo de separador a usar en la Rta de Navegación';
$string['bgposition'] = 'Posición de la imagen del fondo';
$string['bgposition00'] = 'En punto 0.0';
$string['bgposition01'] = 'superior';
$string['bgposition02'] = 'centro';
$string['bgposition03'] = 'fondo';
$string['bgposition04'] = 'izquierda';
$string['bgposition05'] = 'derecha';
$string['bgposition06'] = 'superior izquierda';
$string['bgposition07'] = 'superior centro';
$string['bgposition08'] = 'superior derecha';
$string['bgposition09'] = 'centro izquierda';
$string['bgposition10'] = 'centro centro';
$string['bgposition11'] = 'centro derecha';
$string['bgposition12'] = 'fondo izquierda';
$string['bgposition13'] = 'fondo centro';
$string['bgposition14'] = 'fondo derecha';
$string['bgposition15'] = 'a mitad de la pantalla';
$string['bgpositiondesc'] = 'Cuando Usted configura la opción anterior, dependiendo de su tipo de imagen, Usted puede configurar su comportamiento, elegir si se repite y en cual dirección.';
$string['bgrepeat'] = 'Repetición del fondo de página';
$string['bgrepeat01'] = 'Sin repetir';
$string['bgrepeat02'] = 'Mosaico';
$string['bgrepeat03'] = 'Repetir sobre X';
$string['bgrepeat04'] = 'Repetir sobre Y';
$string['bgrepeatdesc'] = 'Cuando Usted configura la opción anterior, dependiendo del tipo de imagen, Usted puede configurar su comportamiento, elegir si se repite, y en cual dirección.';
$string['blogger'] = 'URL de Blogger';
$string['bloggerdesc'] = 'Escriba la URL de su página de Blogger.
<a href="http://www.blogger.com/" target="_blank"> (www.blogger.com) .</a>';
$string['bodyfont'] = 'Tamaño de letra';
$string['bodyfontdesc'] = 'Si lo desea, puede configurar una referencia de tipo de letra (font). Se sabe que puede causar problemas de visualización con ciertos bloques si Usted configura letras muy grandes. Inténtelo y decida.';
$string['bottomphead'] = 'Elementos del pie de página';
$string['breadcrumbhead'] = 'Opciones de Ruta de Navegación';
$string['browser_1'] = 'Explorador de Internet de Microsoft';
$string['browser_2'] = 'Firefox (Mozilla)';
$string['browser_3'] = 'Chrome (Webkit)';
$string['browser_4'] = 'Opera (Webkit)';
$string['catstyle'] = 'Estilo de Lista de Categorías';
$string['catstyle1'] = 'Estilo Estándar de Moodle';
$string['catstyle2'] = 'Estilo de imagen en rejilla';
$string['catstyle3'] = 'Lista con íconos de 32 por 32';
$string['catstyledesc'] = 'Estilo de Lista de Categorías.<br />
<br />';
$string['choosereadme'] = '<div class="clearfix">
  <div class="theme_screenshot">

    <h2>aigne</h2>
    <img src="aigne/pix/screenshot.jpg" />

    <h3>Forum de Divulgación:</h3>
    <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

    <h3>Documentación:</h3>
    <p><a href="http://docs.moodle.org/en/Themes">http://docs.moodle.org/en/Themes</a></p>

    <h3>Para informar incidencias:</h3>
    <p><a href="http://www.github.com/francpombal/moodle-theme_aigne/">http://www.github.com/francpombal/moodle-theme_aigne/</a></p>
  </div>

  <div class="theme_description">
    <h3>Acerca de:</h3>
    <p>Tema para Moodle 2.5.x _ Optimización del tema Afterburner. Principales características:</p>
    <ul>
      <li>Diseño simple y totalmente compatible con CSS.</li>
      <li>Solo utiliza 3 tonalidades del color principal.</li>
      <li>Pie de página con varias secciones personalizables:</li>
      <li>Sección NavHelp con todos los enlaces administrativos requeridos a páginas personalizables según el idioma<br />
          (mapa web, ayuda, búsqueda, estadísticas, aviso legal, politicas del sitio, privacidad, seguridad y accesibilidad)</li>
      <li>Sección de Contacto (con la adaptación de los enlaces sociales del tema aardvark)</li>
      <li>Sección de Créditos</li>
      <li>Sección de Derechos de propiedad intelectual</li>
      <li>Una página principal (sin terminar) con zonas para banner e información de marketing.</li>
      <li>Gran cantidad de opciones de personalización en Administración del sitio -> Apariencia -> Temas -> AIGNE</li>
      <li>Logotipo personalizado, lema del sitio y una imagen de fondo del logotipo.</li>
    </ul>
    <h3>Créditos:</h3>
    <p>This design was created by Franc Pombal ("www.piratininga.tk/moodle"), improving the AfterBurner Theme in the Moodle core, what was an original design by Mary Evans & Patrick Malley & Rocket Themes.</p>
    <h3>Licencia:</h3>
    <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
  </div>
</div>';
$string['colorsch'] = 'Esquema de Colores del Sitio';
$string['colorschdesc'] = 'Seeccione el Esquema por defecto de Color del Sitio. [El diseño aún sin terminar] <br />
<table class="headerop" Style="width: 275px; border: 2px solid #322C65;">
<tr Style="height:25px">
<td Style="background-color:#322C65">&nbsp;</td>
<td Style="background-color:#007EBA">&nbsp;</td>
<td Style="background-color:#CCDDEE">&nbsp;</td>
<td Style="background-color:#F3F7FF">&nbsp;</td>
<td Style="background-color:#FFFFFF">{$a->css_color1}</td>
<td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
</tr>
<tr Style="height:25px">
<td Style="background-color:#F3F7FF">&nbsp;</td>
<td Style="background-color:#CCDDEE">&nbsp;</td>
<td Style="background-color:#322C65">&nbsp;</td>
<td Style="background-color:#000033">&nbsp;</td>
<td Style="background-color:#FFFFFF">{$a->css_color2}</td>
<td Style="background-color:#000033; color:#FFFFFF">A</td>
</tr>
<tr Style="height:25px">
<td Style="background-color:#001A1A">&nbsp;</td>
<td Style="background-color:#004040">&nbsp;</td>
<td Style="background-color:#4CA9BC">&nbsp;</td>
<td Style="background-color:#F2FFEB">&nbsp;</td>
<td Style="background-color:#FFFFFF">{$a->css_color3}</td>
<td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
</tr>
<tr Style="height:25px">
<td Style="background-color:#522500">&nbsp;</td>
<td Style="background-color:#EB8324">&nbsp;</td>
<td Style="background-color:#F6CC87">&nbsp;</td>
<td Style="background-color:#FFFFCC">&nbsp;</td>
<td Style="background-color:#FFFFFF">{$a->css_color4}</td>
<td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
</tr>
<tr Style="height:25px">
<td Style="width:25px; background-color:#520000">&nbsp;</td>
<td Style="width:25px; background-color:#AA0000">&nbsp;</td>
<td Style="width:25px; background-color:#F1A78E">&nbsp;</td>
<td Style="width:25px; background-color:#FFF2F2">&nbsp;</td>
<td Style="width:150px; background-color:#FFFFFF">{$a->css_color5}</td>
<td Style="width:25px; background-color:#FFFFFF; color:#3C3C3C">A</td>
</tr>
</table>';
$string['compatbrowser'] = 'Navegadores';
$string['compatbrowserdesc'] = 'Navegadores';
$string['compatcredit'] = 'Compatibilidades';
$string['compatcreditdesc'] = 'Si desea que aparezca en el pie de página una lista con los logotipos de las distintas validaciones conseguidas, active esta opción';
$string['compatdevice'] = 'Dispositivos probados';
$string['compatdevicedesc'] = 'Dispositivos probados';
$string['compatnotedesc'] = 'En esta sección, Usted puede activar las compatibilidades que validan exitosamente su sitio. <br />
Siga con su maravilloso ...';
$string['compatos'] = 'Sistemas Operativos';
$string['compatosdesc'] = 'Sistemas Operativos';
$string['compatsocial'] = 'Políticas sociales';
$string['compatsocialdesc'] = 'Políticas sociales';
$string['compattested'] = 'Compatibilidades Validadas';
$string['compattesteddesc'] = 'Seleccione los logotipos que desea mostrar, teniendo en cuenta que usted haya validado su Web, bajo su responsabilidad';
$string['compatwai'] = 'Validación de Accesibilidad';
$string['compatwai1'] = 'aún no probada';
$string['compatwai2'] = 'Nivel A';
$string['compatwai3'] = 'Nivel AA';
$string['compatwai4'] = 'Nivel AAA';
$string['compatwaidesc'] = 'Seleccione el logotipo de accesibilidad que desea mostrar, teniendo en cuenta que usted haya validado su Web, bajo su responsabilidad.
<a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['configtitle'] = 'Configuraciones personalizadas de Aigne';
$string['contacthead'] = 'Opciones para contacto';
$string['contactlink'] = 'Contáctenos:';
$string['contactnote'] = 'Contacto';
$string['contactnotedesc'] = 'Aquí puede añadir información de contacto que aparecerá en medio de la zona de contacto del pie de página';
$string['contentact'] = 'Contenido Solamente en Página de Actividad';
$string['contentactdesc'] = 'Si se habilita, se muestra solamente el contenido de las actividades, sin los bloques laterales, para darle más espacio a la actividad.';
$string['contentcur'] = 'Contenido solamente en Página de Curso';
$string['contentcurdesc'] = 'Si se habilita, se muestra solamente el contenido de los cursos, sin los bloques laterales, para darle más espacio al curso.';
$string['copyrightstg'] = 'Mensaje de Propiedad';
$string['copyrightstgdesc'] = 'Aquí puede Usted escribir un mensaje que aparecerá al final del pie de página, que describe la propiedad del sitio.
Si Usted deja esto vacío, se compondrá un mensaje corto con el nombre del sitio y el año actual.
Recuerde que Usted puede usar cualquiera de los modelos reconocidos internacionalmente: <br />
    ► COPYRIGHT © AÑO, COMPAÑÍA     ► COMPAÑÍA © AÑO     ► AÑO © COMPAÑÍA     ► Derechos Reservados (DR) AÑO, COMPAÑÍA';
$string['corpweb'] = 'URL del sitio web';
$string['corpwebdesc'] = 'Escriba la URL de su institución / Organización / Sitio web corporativo. (por ejemplo. http://www.dominio_corporativo.com.mx/) <br />
Este enlace no tiene conexión alguna con  www root en config.php.';
$string['cortesyhead'] = 'Opciones para Mensajes de cortesía';
$string['creditshead'] = 'Opciones para publicaciones de créditos';
$string['csocial_1'] = 'Protección y Cuidado de la Niñez';
$string['csocial_2'] = 'Igualdad de Oportunidad a Mujeres';
$string['csocial_3'] = 'Conformidad Multi-Cultural';
$string['css_color1'] = 'Azul Claro';
$string['css_color2'] = 'Verde Musgo';
$string['css_color3'] = 'Naranja _ Primavera';
$string['css_color4'] = 'Rojo Rubí _ Verano';
$string['css_color5'] = 'Marrón _ Otoño';
$string['css_color6'] = 'Gris _ Invierno';
$string['css_color7'] = 'Azul Marino en contraste';
$string['csshead'] = 'Opciones para personalización del diseño CSS';
$string['ctested_1'] = 'Validador WIA CSS probado <a href="http://jigsaw.w3.org/css-validator/#validate_by_upload" target="_blank"> (WIA CSS) .</a>';
$string['ctested_2'] = 'Validador WIA HTML 5.0 o 4.0 probado <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_3'] = 'Validador WIA XHTML 1.0 probado <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_4'] = 'Validador reserved _ Cynthia <a href="http://www.cynthiasays.com/" target="_blank"> (Cynthia) .</a>';
$string['ctested_5'] = 'Validador reserved _ Children Free <a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Las reglas CSS que añada en esta área se reflejarán en todas las páginas, haciendo más fácil la personalización del tema.';
$string['custommenudesc'] = 'Para diseñar un menú personalizado, debe configurarse en la Administración del Sitio ► Apariencia ► Temas ► <a href="settings.php?section=themesettings">"Settings"</a> ► "custommenuitems" .<br />';
$string['custommenuhead'] = 'Opciones personalizadas del menú';
$string['custommtag'] = 'Meta Marcas Personalizadas';
$string['custommtagdesc'] = 'Si desea personalizar al máximo, puede añadir aquí las Meta Etiquetas que necesita.<br />
Por favor, tenga en cuenta el formato y el contenido, escribiendo el código entero, como lo haría en un editor Web, siguiendo el siguiente ejemplo:<br />
<pre>
&lt;META name="distribution" content="global" /&gt;
&lt;META name="revisit-after" content="31 Days" /&gt;
&lt;META name="robots" content="index,nofollow" /&gt;
</pre>';
$string['dailymotion'] = 'Enlace a DailyMotion';
$string['dailymotiondesc'] = 'Introduzca el enlace (URL) a su página en DailyMotion.
<a href="http://www.dailymotion.com/" target="_blank"> (www.dailymotion.com) .</a>';
$string['datemessage'] = 'Mensaje especial';
$string['datemessage1'] = '¡¡¡Feliz año Nuevo!!!';
$string['datemessage2'] = '¡Disfruta del Carnaval!';
$string['datemessage3'] = '¡Buenas Pascuas, y disfruta de la Semana Santa!';
$string['datemessage4'] = '¡Disfruta del día de la Independencia!';
$string['datemessage5'] = 'Feliz Halloween y celebra el día de muertos';
$string['datemessage6'] = '¡Feliz Navidad!';
$string['datemessage7'] = 'Disfruta del puente de ...';
$string['datemessage8'] = '¡Qué disfrutes de las Vacaciones de Verano!';
$string['datemessage9'] = '¡Qué disfrutes de las Vacaciones de Invierno!';
$string['datemessagedesc'] = 'Defina el mensaje que desea mostrar durante un período de tiempo determinado<br />
Por ejemplo, puede poner un saludo para una época o festivo "Feliz Navidad...", <br />
indicar algún tipo de acontecimiento especial de la plataforma "Estamos inaugurando un nuevo diseño web..." <br />
o también puede anunciar un nuevo tipo de curso "Compruebe nuestros nuevos cursos de idiomas"<br />';
$string['datemessagefinis'] = 'Fecha de finalización';
$string['datemessagestart'] = 'Fecha de inicio';
$string['dayviews'] = 'Enlace a DayViews';
$string['dayviewsdesc'] = 'Introduzca el enlace (URL) a su página en DayViews.
<a href="http://dayviews.com/" target="_blank"> (dayviews.com) .</a>';
$string['decfontsizetxt'] = 'Pulse para disminuir el tamaño de la fuente. (Disminuir el tamaño del texto para mejorar la accesibilidad)';
$string['defaultfontsizetxt'] = 'Pulse para restaurar el tamaño de la fuente. (Recuperar el tamaño normal del diseño web)';
$string['defaultstyletxt'] = 'Pulse para recuperar el aspecto original del diseño web';
$string['deviantart'] = 'Enlace a DeviantArt';
$string['deviantartdesc'] = 'Introduzca el enlace (URL) a su cuenta en DeviantArt.
<a href="http://www.deviantart.com/" target="_blank"> (www.deviantart.com) .</a>';
$string['device_1'] = 'HDTV y SmartTV';
$string['device_2'] = 'Servidores, PCs de escritorio y Estaciones de Trabajo';
$string['device_3'] = 'Laptop, Netbook y Notebook';
$string['device_4'] = 'Tableta';
$string['device_5'] = 'Teléfono Móvil y Teléfono Inteligente';
$string['disclaimer'] = 'aviso legal';
$string['disclaimerdesc'] = 'Advertencia legal obligatoria (por ejemplo: La información aquí presentada es responsabilidad exclusiva de los fulanos que la escribieron y la institución ABCDEFG no se hace responsable por nada malo que pudiera pasarle a alguien si les hace caso...)';
$string['disclaimerpage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Información legal:</h2>
<p> El presente documento regula la utilización de los sitios Web adscritos al dominio de Internet
    "{$a->sitenamelow}.com"... o algo así.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->sitename}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <p>&nbsp;</p>';
$string['dropbox'] = 'Enlace a DropBox';
$string['dropboxdesc'] = 'Introduzca el enlace (URL) a su cuenta en DropBox.
<a href="http://www.dropbox.com/" target="_blank"> (www.dropbox.com) .</a>';
$string['dublinmtag'] = 'Meta Etiquetas Dublin Core';
$string['dublinmtagdesc'] = 'Si activa esta opción, se generarán 3 etiquetas básicas (language, description, publisher) compatibles con el estándar "Dublin Core Metadata Initiative"';
$string['emailimg'] = 'Imagen para eMail';
$string['emailimgdesc'] = 'Aquí puede añadir una imagen con la dirección eMail de soporte. Esto ayudará a prevenir que herramientas maliciosas de spam capturen su dirección eMail. <br />
Configure esta dirección eMail en Administración del sitio ► Servidor ► <a href="settings.php?section=supportcontact">"Contacto de soporte"</a> ► "supportemail" .
Tenga en cuenta las proporciones en el diseño y añada una imagen de 32px de alto.';
$string['facebook'] = 'Enlace a Facebook';
$string['facebookdesc'] = 'Introduzca el enlace (URL) a su página en Facebook.
<a href="http://www.facebook.com/" target="_blank"> (www.facebook.com) .</a>';
$string['fisicallink'] = 'Visítenos en:';
$string['flickr'] = 'Enlace a Flickr';
$string['flickrdesc'] = 'Introduzca el enlace (URL) a su página en Flickr.
<a href="http://www.flickr.com" target="_blank"> (www.flickr.com) .</a>';
$string['fontfam'] = 'Familia de tipo de letra (font)';
$string['fontfam1'] = 'Eras Bk Bt';
$string['fontfam2'] = 'eras';
$string['fontfam3'] = 'afta';
$string['fontfam4'] = 'Arial';
$string['fontfam5'] = 'Tahoma';
$string['fontfamdesc'] = 'Si Usted lo desea, puede especificar una referencia de familia de tipo de letra (font)';
$string['footnote'] = 'Nota al pie de página';
$string['footnotedesc'] = 'Si desea puede añadir contenido personalizado en el pie de página. Este contenido será insertado a continuación de la zona de créditos.';
$string['footnoteshow'] = 'Mostrar nota al pie';
$string['footnoteshowdesc'] = 'Si se habilita, muestra en el pie de página el contenido de la "nota al pie" inferior.';
$string['footsearch'] = 'búsqueda';
$string['footsearchdesc'] = 'Búsqueda global';
$string['footsearchpage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Buscar:</h2>
  <p>Aquí puede introducir herramientas generales de búsqueda.</p>
  <p>&nbsp;</p>';
$string['fotolog'] = 'Enlace a FotoLog';
$string['fotologdesc'] = 'Introduzca el enlace (URL) a su página en FotoLog.
<a href="http://www.fotolog.com/" target="_blank"> (www.fotolog.com) .</a>';
$string['frontmsgttl'] = 'Escriba aquí el título del mensaje';
$string['frontmsgtxt'] = 'Introduzca aquí un mensaje de bienvenida conciso e interesante<br />
Escríbalo en su editor HTML favorito, después busque dentro del archivo de idioma /theme/aigne/lang/ xx /theme_aigne.php y péguelo en $string[frontmsgtxt]<br />
<strong>Usted puede usar el archivo aigne_style.csspara sus preferencias de formato  CSS </strong>';
$string['general_greeting'] = '¡Hola!';
$string['generalhead'] = 'Apariencia general';
$string['googleplus'] = 'Enlace a Google+';
$string['googleplusdesc'] = 'Introduzca el enlace (URL) a su perfil en Google+.
<a href="http://plus.google.com/" target="_blank"> (plus.google.com) .</a>';
$string['headactivity'] = 'Mostrar encabezado en #Actividades"';
$string['headactivitydesc'] = 'Si fuera \'Si\', muestra el nuevo encabezado en "Actividades" (Solamente en la versión para Moodle 2.7.xx)';
$string['headbanner'] = 'Banner del Encabezado';
$string['headbannerdesc'] = 'Seleccionar el tipo de información a mostrar en el encabezado de la página principal.';
$string['headerhead'] = 'Elementos del Encabezado';
$string['headerinfo'] = 'Encabezado de presentación';
$string['headerinfodesc'] = 'Si lo desea, puede añadir una imagen fija en la cabecera de la página principal, .<br />
Esta imagen debe ser un  JPG / PNG / GIF con un mínimo de 1000 pixeles de ancho y 150 pixeles máximo de alto.';
$string['help'] = 'ayuda';
$string['helpdesc'] = 'Soporte General';
$string['helppage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Ayuda a la navegación:</h2>
  <p>Aquí puede introducir todas las referencias necesarias para facilitar la
     navegación por sus cursos. Además, puede crear una sección para enlazar con
     el "Manual del alumnado" o manuales de utilización.</p>
<h2>Moodle:</h2>
  <p>Nuestra plataforma de enseñanza está basada en Moodle. Si desea ampliar
     información sobre la usabilidad de Moodle, puede acceder a los
     <a href="http://docs.moodle.org">documentos de ayuda oficiales</a>.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->link}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <p>&nbsp;</p>';
$string['incfontsizetxt'] = 'Pulse para aumentar el tamaño de la fuente. (Aumentar el tamaño del texto para mejorar la accesibilidad)';
$string['infobanner'] = 'Área de Información';
$string['infobanner0'] = 'Banner de Ninguna Información';
$string['infobanner1'] = 'Mostrar una caja estática con un mensaje de texto';
$string['infobanner10'] = 'Mostrar el acordeón horizontal AIGNE';
$string['infobanner2'] = 'Mostrar una imagen estática';
$string['infobanner3'] = 'Mostrar hasta tres cajas estáticas con diferentes tipos de contenido';
$string['infobanner4'] = 'Mostrar una caja de información, en estilo de acordeón horizontal';
$string['infobanner5'] = 'Mostrar una presentación deslizante vertical automatizada';
$string['infobanner6'] = 'Mostrar una presentación deslizante horizontal automatizada';
$string['infobanner7'] = 'Mostrar formato estándar de ingreso';
$string['infobannerdesc'] = 'Seleccione el tipo de información a mostrar en el contenido de la portada.<br />';
$string['instagram'] = 'Enlace a Instagram';
$string['instagramdesc'] = 'Introduzca el enlace (URL) a su página en Instagram.
<a href="http://instagram.com/" target="_blank"> (instagram.com) .</a>';
$string['lastmodifiedmsg'] = 'Última actualización';
$string['lastmodifiedmsgdesc'] = 'Si desea que aparezca un mensaje al final del pie de página con la fecha de actualización del sitio web, active esta opción';
$string['lastpageupdate'] = 'Esta página fue modificada por última vez en';
$string['linkedin'] = 'Enlace a LinkedIn';
$string['linkedindesc'] = 'Introduzca el enlace (URL) a su perfil en LinkedIn.
<a href="http://www.linkedin.com/" target="_blank"> (www.linkedin.com) .</a>';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'Si lo desea puede añadir un logotipo personalizado.<br />
El logotipo debe ser una imagen JPG/PNG/GIF con 150px de largo y 55px de alto';
$string['logohead'] = 'Configuración del logotipo';
$string['maplink'] = 'URL de servidor de mapa';
$string['maplinkdesc'] = 'Escriba la URL de un servidor de mapa con la localización de la organización (por ejemplo, google maps / bing maps).';
$string['marketinghead'] = 'Opciones de diseño en la página de presentación del sitio';
$string['marketingheaddesc'] = 'En esta sección Usted puede personalizar los elementos mostrados en la portada, antes de que los usuarios ingresen.
Usted puede configurar información acerca de su institución, o el lanzamiento de nuevos cursos. <br /> Esto puede resaltarse / programarse para mostrar cualquier información acerca del sitio o de los cursos, en el diseño de  "frontinfo.php" y en la carpeta themeaignepixcarroussel.';
$string['menucolor'] = 'Color del menú personalizado';
$string['menucolordesc'] = 'Seleccione el color de fondo del menú personalizado. Las demás opciones deben ser configuradas directamente en el archivos css (aigne_menu.css).';
$string['menucolorhl'] = 'Color de contraste del menú personalizado';
$string['menucolorhldesc'] = 'Seleccione el color de contraste del menú personalizado. Tenga en cuenta la combinación con el color anterior, para mantener un diseño agradable';
$string['menulogout'] = 'Enlace para salir';
$string['menulogoutdesc'] = 'Si activa esta opción, aparecerá un enlace en el menú personalizado para salir/entrar en la plataforma.';
$string['metadescription'] = 'Bienvenido a {$a->sitename}.';
$string['metakeywords'] = 'aigne, formación, educación, enseñanza, pedagogía';
$string['microsoftid'] = 'URL de Microsoft Live';
$string['microsoftiddesc'] = 'Escriba la URL de su perfil de Microsoft Live.
<a href="http://profile.live.com/" target="_blank"> (profile.live.com) .</a>';
$string['moodlecredit'] = 'Créditos a Moodle';
$string['moodlecreditdesc'] = 'Si desea que aparezca en el pie de página un mensaje de agradecimiento y un enlace a la página original de <a href="http://moodle.org/" target="_blank">moodle.org.</a>, active esta opción';
$string['moodledocsdesc'] = 'Enlace de ayuda a las páginas originales de MoodleDocs en <a href="http://docs.moodle.org/" target="_blank">docs.moodle.org.</a>';
$string['moodlehead'] = 'Opciones de elementos de Moodle';
$string['moreinfo'] = 'Lea más ...';
$string['morning_greeting'] = 'Buenos días... !';
$string['mtaghead'] = 'Opciones de Meta Marcas';
$string['mtagheaddesc'] = 'Las Meta Etiquetas pueden ser utilizadas para mejorar el posicionamiento en algunos buscadores, así como ofrecer
información fiable sobre nuestro sitio a multitud de servicios de indexación y clasificación que rondan por Internet.';
$string['mtdescription'] = 'Meta Marca de Descripción';
$string['mtdescriptiondesc'] = 'Si lo desea puede escribir un contenido personalizado para la Meta Etiqueta "description".<br />
Por favor, tenga en cuenta el formato y el contenido, añadiendo un máximo de 250 caracteres<br />
Si deja en blanco esta opción, se generará una expresión de bienvenida según el idioma';
$string['mtkeywords'] = 'Meta Etiqueta Keywords';
$string['mtkeywordsdesc'] = 'Si lo desea puede escribir un contenido personalizado para la Meta Etiqueta "keywords".<br />
Por favor, tenga en cuenta el formato y el contenido, separando las palabras por coma y añadiendo un máximo de 25 palabras.<br />
Si deja en blanco esta opción, se generará una expresión automática con 5 palabras según el idioma';
$string['myspace'] = 'Enlace a MySpace';
$string['myspacedesc'] = 'Introduzca el enlace (URL) a su perfil en MySpace.
<a href="http://www.myspace.com/" target="_blank"> (www.myspace.com) .</a>';
$string['navhelp'] = 'Enlace de la ayuda a la navegación';
$string['navhelpdesc'] = 'Dirección de la página donde están configuradas las opciones de la barra de ayuda a la navegación';
$string['navhelphead'] = 'Opciones de ayuda a la navegación';
$string['navhelplinks'] = 'Enlaces activos';
$string['navhelplinksdesc'] = 'Active los enlaces a mostrar en la barra de ayuda de navegación y en el pie de página.';
$string['navhelppage'] = 'Página de ayuda para Navegación';
$string['navhelppagetitle'] = 'Ayuda a la Navegación';
$string['newsinfo'] = 'Información académica';
$string['newsinfo1'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p> </p>
<p>Aquí puede Usted crear una página de información.</p>
<p> </p>';
$string['newsinfo2'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p> </p>
<p>Aquí puede Usted crear una página de información.</p>
<p> </p>';
$string['newsinfo3'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p> </p>
<p>Aquí puede Usted crear una página de información.</p>
<p> </p>';
$string['newsinfo4'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p> </p>
<p>Aquí puede Usted crear una página de información.</p>
<p> </p>';
$string['newsinfo5'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p> </p>
<p>Aquí puede Usted crear una página de información.</p>
<p> </p>';
$string['night_greeting'] = 'Buenas noches... !';
$string['nocontentdrag'] = 'Debido a la protección del Derecho de Autoor de nuestros cursos, se ha deshabilitado el arrastrar y soltar de algunos contenidos.';
$string['nocontentprint'] = '<h2 style="text-align: center">Prevención de impresión</h2>
<h3><b>Copyright:</b></h3>
  <p>Todo el contenido de {$a->sitename} está amparado por la legislación vigente
     que protege los derechos de autor. Si desea obtener más información,
     visite nuestra página de {$a->disclaimer}.</p>
  <p>&nbsp;</p>
<h3><b>Impresión:</b></h3>
  <p>Para evitar posibles fraudes en la utilización del contenido de nuestros
     cursos, se han instalado algunas herramientas básicas para prevenir la
     impresión de ese contenido y proteger dichos derechos de autor.</p>
  <p>&nbsp;</p>
<h3><b>Obtener una copia:</b></h3>
  <p>Si usted está matriculado en alguno de nuestros cursos y necesita una
     copia del contenido, que no esté incluida en el proprio curso, póngase en
     contacto con su Profesor o con el Administrador del Sitio para obtener
     ayuda sobre el tema.</p>
  <p>&nbsp;</p>
<hr>
  <p style="text-align: center">Disculpe las molestias.</p>';
$string['nocontentselect'] = 'Debido a la protección de Derechos de Autor de nuestros cursos, el seleccionar (copiar y arrastra) el contenido está deshabilitado.';
$string['noimplemented'] = 'Opción no implementada. Disculpe las molestías';
$string['notes'] = 'Notas del tema aigne';
$string['notesdesc'] = 'Para aplicar cualquier cambio en la configuración presione "Guardar cambios" al final de la página. Si no tiene habilitado el "Modo de diseño de temas", quizás necesite forzar la actualización entrando en Administración del sitio ► Desarrollo ►  <a href="purgecaches.php">"Purgar todas las Cachés"</a>.';
$string['openid'] = 'URL de Open ID';
$string['openiddesc'] = 'Escriba la URL de su perfil de Open ID.
<a href="http://openid.net/" target="_blank"> (openid.net) .</a>';
$string['optionalmtag'] = 'Meta Etiquetas Opcionales';
$string['optionalmtagdesc'] = 'Si activa esta opción, se generarán Meta Etiquetas adicionales, con información automática sobre su sitio.';
$string['original_theme'] = 'Diseño inspirado en un tema original de Patrick Malley & Mary Evans';
$string['orkut'] = 'Enlace a Orkut';
$string['orkutdesc'] = 'Introduzca el enlace (URL) a su perfil en Orkut.
<a href="http://www.orkut.com/" target="_blank"> (www.orkut.com) .</a>';
$string['osystem_1'] = 'Windows';
$string['osystem_2'] = 'Linux';
$string['osystem_3'] = 'Mac / Apple';
$string['osystem_4'] = 'Androide';
$string['osystem_5'] = 'BlackBerry';
$string['outbutton'] = 'Opción de salir al estilo de botón';
$string['outmoodle'] = 'Opción de salir al estilo moodle, con un enlace';
$string['outnone'] = 'Sin la opción de salir';
$string['panoramio'] = 'URL de Panoramio';
$string['panoramiodesc'] = 'Escriba la URL de su página de Panoramio.
<a href="http://www.panoramio.com" target="_blank"> (www.panoramio.com) .</a>';
$string['photobucket'] = 'URL de Photobucket';
$string['photobucketdesc'] = 'Escriba la URL de su página de Photobucket.
<a href="http://www.photobucket.com/" target="_blank"> (www.photobucket.com) .</a>';
$string['picasa'] = 'Enlace a Picasa';
$string['picasadesc'] = 'Introduzca el enlace (URL) a su página en Picasa.
<a href="http://picasa.google.com/" target="_blank"> (picasa.google.com) .</a>';
$string['pinterest'] = 'Enlace a Pinterest';
$string['pinterestdesc'] = 'Introduzca el enlace (URL) de su página en Pinterest.
<a href="http://pinterest.com/" target="_blank"> (pinterest.com) .</a>';
$string['pixabay'] = 'Enlace a PixaBay';
$string['pixabaydesc'] = 'Introduzca el enlace (URL) a su página en PixaBay.
<a href="http://pixabay.com/" target="_blank"> (pixabay.com) .</a>';
$string['pluginname'] = 'Aigne';
$string['policies'] = 'política del sitio';
$string['policiesdesc'] = 'Políticas del sitio';
$string['policiespage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Politicas del sitio:</h2>
  <p>Aquí puede introducir las políticas de uso del sitios web, los deberes y derechos
     de los alumnos, .</p>
  <p>&nbsp;</p>';
$string['powered'] = 'Con la potencia de:';
$string['privacy'] = 'privacidad';
$string['privacydesc'] = 'Privacidad en la navegación dentro de la plataforma';
$string['privacypage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Privacidad de los datos de usuario y alumnos</h2>
<p>Aquí puede introducir la información sobre la privacidad de los datos en la navegación
   por el sitio web, además de las diferentes clausulas legales obligatorias.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendadminemail}</ul>
  <ul>{$a->remoteaddr}</ul>
  <ul>{$a->remotehost}</ul>
  <ul>{$a->remoteuser}</ul>
  <ul>{$a->language}</ul>
  <ul>{$a->useragent}</ul>
  <ul>{$a->referer}</ul>
  <p>&nbsp;</p>';
$string['quadro1alt'] = 'Escriba aquí el texto alterno para la imagen del cuadro 1';
$string['quadro1ttl'] = 'Escriba aquí el título del cuadro 1';
$string['quadro1txt'] = '<h2>Cuadros de texto:</h2>
Aquí puede introducir un párrafo conciso e interesante<br /><br />
Escriba un texto en su editor HTML favorito, a continuación entre en el archivo del idioma
<MARQUEE>(/theme/aigne/lang/xx/theme_aigne.php -> $string[quadro1txt])</MARQUEE> y péguelo allí<br /><br />
<strong>Puede darle el formato CSS que quiera en el archivo aigne_style.css</strong>';
$string['quadro2alt'] = 'Escriba aquí el texto alterno para la imagen del cuadro 2';
$string['quadro2ttl'] = 'Escriba aquí el título del cuadro 2';
$string['quadro2txt'] = '<h2>Cuadros de texto:</h2>
Aquí puede introducir un párrafo interesante y conciso <br /><br />
Escriba un texto en su editor HTML favorito, a continuación entre en el archivo del idioma
<MARQUEE>(/theme/aigne/lang/xx/theme_aigne.php -> $string[quadro2txt])</MARQUEE> y péguelo allí<br /><br />
<strong>Puede darle el formato CSS que quiera en el archivo aigne_style.css</strong>';
$string['quadro3alt'] = 'Escriba aquí el texto alterno para la imagen del cuadro 3';
$string['quadro3ttl'] = 'Escriba aquí el título del cuadro 3';
$string['quadro3txt'] = '<h2>Cuadros de texto:</h2>
Aquí puede introducir un párrafo interesante y conciso<br /><br />
Escriba un texto en su editor HTML favorito, a continuación entre en el archivo del idioma
<MARQUEE>(/theme/aigne/lang/xx/theme_aigne.php -> $string[quadro3txt])</MARQUEE> y péguelo allí<br /><br />
<strong>Puede darle el formato CSS que quiera en el archivo aigne_style.css</strong>';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['reservedrights'] = 'Reservados todos los derechos';
$string['schooltube'] = 'Enlace a SchoolTube';
$string['schooltubedesc'] = 'Introduzca el enlace (URL) a su página en SchoolTube.
<a href="https://www.schooltube.com/" target="_blank"> (www.schooltube.com) .</a>';
$string['security'] = 'seguridad';
$string['securitydesc'] = 'Información sobre la seguridad en la navegación dentro de la plataforma';
$string['securitypage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Seguridad:</h2>
<p>Aquí puede introducir las medidas de seguridad que se utilizan para prevenir el SPAM,
   la herramientas antivirus y los procedimientos de copia de seguridad.</p>
  <p>&nbsp;</p>';
$string['sendemailsubj'] = 'Información acerca de {$a}';
$string['sendemailtitle'] = '::: mandar un eMail al Administrador del Sitio Web :::';
$string['sep_bhr'] = '<br /><hr>';
$string['sep_br'] = '<br />';
$string['sep_hr'] = '<hr>';
$string['sep_hr2'] = '<hr width="50%" align="center">';
$string['sitelicensemsg'] = 'Tipo de licencia';
$string['sitelicensemsgdesc'] = 'Si desea que aparezca un mensaje al final del pie de página con el tipo de licencia que rige el contenido de este sitio, active esta opción.<br />
El tipo de licencia se puede configurar en Administración del sitio ► Extensiones ► Licencias ► <a href="settings.php?section=managelicenses">"Administrar licencias"</a> ► "sitedefaultlicense"  .';
$string['sitenewsi'] = 'Mostrar información del autor y opciones en "Novedades"';
$string['sitenewsidesc'] = 'Si fuera \'Si\', muestra información del autor en el encabezado y las opciones en fila en el pie de página de cualquier (Foro de) "Novedades del sitio")';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Introduzca el nombre de usuario de su Organización / Institución educativa / Empresa matriz, en la red de Skype.';
$string['sli5alt1'] = 'Escriba aquí el texto alterno para la imagen deslizable 1';
$string['sli5alt2'] = 'Escriba aquí el texto alterno para la imagen deslizable 2';
$string['sli5alt3'] = 'Escriba aquí el texto alterno para la imagen deslizable 3';
$string['sli5alt4'] = 'Escriba aquí el texto alterno para la imagen deslizable 4';
$string['sli5alt5'] = 'Escriba aquí el texto alterno para la imagen deslizable 5';
$string['sli5cap1'] = 'Subtítulo 1';
$string['sli5cap2'] = 'Subtítulo 2';
$string['sli5cap3'] = 'Subtítulo 3';
$string['sli5cap4'] = 'Subtítulo 4';
$string['sli5cap5'] = 'Subtítulo 5';
$string['slogan'] = 'Lema';
$string['sloganaigne'] = '.. insertar aquí un slogan ...';
$string['slogandesc'] = 'Si lo desea puede añadir una pequeña frase que aparecerá bajo el logotipo, en forma de lema.<br />
Tenga en cuenta el tamaño de la frase para mantener el diseño del encabezado.';
$string['social1ico'] = 'Ícono para la Red Social Personalizada';
$string['social1icodesc'] = 'Escriba el nombre del ícono para la Red Social Personalizada. <br />
Recuerde copiar una imagen de ícono de 32x32 a la carpeta theme/aigne/pix/brands/ con el mismo nombre introducido';
$string['social1url'] = 'URL de Red Social Personalizada';
$string['social1urldesc'] = 'Escriba la URL (completa) de una Red Social que no está en la lista.';
$string['socialcontenthead'] = 'Enlaces a las direcciones de las redes sociales (con contenido de medios del curso)';
$string['socialhead'] = 'Opciones para enlaces a redes sociales';
$string['sociallinks'] = '... y en las Redes Sociales:';
$string['stats'] = 'estadísticas';
$string['statsdesc'] = 'Estadísticas de uso';
$string['statspage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Estadísticas:</h2>
  <p>Aquí puede introducir los resultados de estadísticas de navegación o
     informes de avaliación de la formación dentro de su organización.</p>
  <p>&nbsp;</p>';
$string['styletxt'] = 'Pulse para aplicar una combinación de colores diferente al diseño web';
$string['thanksvisit'] = 'Gracias por su confianza';
$string['thanksvisitmsg'] = 'Mensaje de agradecimiento';
$string['thanksvisitmsgdesc'] = 'Si desea que aparezca un mensaje de agradecimiento al final del pie de página, active esta opción';
$string['tumblr'] = 'Enlace a Tumblr';
$string['tumblrdesc'] = 'Introduzca el enlace (URL) a su blog en Tumblr.
<a href="http://tumblr.com/" target="_blank"> (tumblr.com) .</a>';
$string['twitter'] = 'Enlace a Twitter';
$string['twitterdesc'] = 'Introduzca el enlace (URL) a su cuenta de Twitter.
<a href="http://twitter.com/" target="_blank"> (twitter.com) .</a>';
$string['useraigne'] = 'En el Encabezado, al estilo aigne (login + saludo + usuario + foto + logout)';
$string['usermenu'] = 'En el encabezado, en el estilo de menú de usuario nuevo (saludo + nuevo menú desplegable)';
$string['usermoodle'] = 'En el encabezado, en el estilo antiguo de Moodle (ingresar + saludo + nombre_de_usuario + Salir)';
$string['usernav'] = 'Area de Información del Usuario.';
$string['usernavdesc'] = 'Seleccione el tipo de información del usuario a ser mostrada, en el área del encabezado, en el bloque de navegación o ninguna información del usuario.
La segunda opción (estilo de menú de usuario nuevo) correrá solamente a partir de la versión de Moodle 2.8 o superiores.';
$string['usernavhead'] = 'Opciones del area de Información del Usuario';
$string['usernavheaddesc'] = 'Las siguientes opciones configuran la información que aparecerá en el area del encabezado de Navegación del Usuario en el estilo aigne.
Recuerde que el Area deNavegación del Usuario al estilo moodle es estándar y tiene un formato fijo.<br />"';
$string['usernavinfo'] = 'Nombre del usuario';
$string['usernavinfodesc'] = 'Si activa esta opción, aparecerá el nombre del usuario en el area de Información del Usuario en el encabezado.';
$string['usernavout'] = 'Botón de salida';
$string['usernavoutdesc'] = 'Si activa esta opción, aparecerá un botón de salida de la plataforma en el area de Información del Usuario en el encabezado.';
$string['usernavpic'] = 'Foto del usuario';
$string['usernavpicdesc'] = 'Si activa esta opción, aparecerá una foto del usuario en el area de Información del Usuario en el encabezado.';
$string['usernavsalut'] = 'Saludo';
$string['usernavsalutdesc'] = 'Si activa esta opción, aparecerá un mensaje o saludoen el área del encabezado de información del usuario.<br />
Si deja en blanco el Mensaje de saludo o Bienvenida, se muestra un mensaje de saludo condicionado a la hora del día.<br>
Inserte una comunicación fija en el mensaje de Bienvenida.<br>
Inserte una una comunicación correspondiente a la fecha en el mensaje de saludo.';
$string['usernone'] = 'Sin ningún tipo de información del usuario';
$string['usersalut'] = 'En el encabezado, solamente mostrar un saludo';
$string['videolog'] = 'Enlace a VideoLog';
$string['videologdesc'] = 'Introduzca el enlace (URL) a su página en VideoLog.
<a href="http://videolog.tv/" target="_blank"> (videolog.tv) .</a>';
$string['vimeo'] = 'Enlace a Vimeo';
$string['vimeodesc'] = 'Introduzca el enlace (URL) a su canal en Vimeo.
<a href="http://www.vimeo.com/" target="_blank"> (www.vimeo.com) .</a>';
$string['vkontakte'] = 'Enlace a VKontakte';
$string['vkontaktedesc'] = 'Introduzca el enlace (URL) de su página en Vkontakte.
<a href="http://www.vk.com/" target="_blank"> (www.vk.com) .</a>';
$string['webmap'] = 'mapa web';
$string['webmapdesc'] = 'Esquema de páginas del sitio web, que formará el Mapa Web';
$string['webmappage'] = '<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<p>Aquí puede crear un mapa con la estructura de páginas que necesita
   para dar a conocer su organización, sus filosofía de trabajo y el
   equipo humano que conforma su proyecto formativo.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitename}</ul>
<p>&nbsp;</p>';
$string['welcomemsg'] = 'Mensaje de Bienvenida';
$string['welcomemsgdesc'] = 'Defina un mensaje de bienvenida, que será mostrado en el area de Información del Usuario en el encabezado';
$string['xing'] = 'URL de Xing';
$string['xingdesc'] = 'Escriba la URL de su perfil de Xing.
<a href="http://www.xing.com/" target="_blank"> (www.xing.com) .</a>';
$string['yahooid'] = 'URL de Yahoo';
$string['yahooiddesc'] = 'Escriba la URL de su perfil deYahoo .
<a href="http://profile.yahoo.com/" target="_blank"> (profile.yahoo.com) .</a>';
$string['yelp'] = 'URL de Yelp';
$string['yelpdesc'] = 'Escriba la URL de su perfil de Yelp.
<a href="http://www.yelp.com/" target="_blank"> (www.yelp.com) .</a>';
$string['youtube'] = 'Enlace a YouTube';
$string['youtubedesc'] = 'Introduzca el enlace (URL) a su canal en YouTube.
<a href="http://www.youtube.com/" target="_blank"> (www.youtube.com) .</a>';
