<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'es_mx', version '3.8'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Arriba';
$string['activitynavigationposition'] = 'Posición de navegación de actividad';
$string['activitynavigationpositiondesc'] = 'Elegir entre \'Arriba\' y \'Debajo\' para la navegación de la actividad. Donde \'Arriba\' es arriba de la actividad y \'Debajo\' es debajo de ella. Si Usted desea usar CSS personalizado, entonces use el selector \'#activitynavigation\'.';
$string['advert_alttext'] = 'Diseño del Tema Nivel 1 banner promocional';
$string['advert_heading'] = 'Diseño del Tema Nivel 1';
$string['advert_tagline'] = 'Si Usted quiere aprender a personalizar temas, pero no posee formación previa en desarrollo, ni tiene experiencia con PHP y experiencia con Temas de Moodle, ¡ entonces  \'MoodleBites Theme Design Level 1\' es para Usted ! Le dará una amable introducción al  desarrollo de Temas de Moodle, y le proporcionará una buena preparación si desea progresar más adelante. Por favor haga clic aquí para más información.';
$string['aftercontent'] = 'Después del contenido';
$string['alert1'] = 'Primera alerta';
$string['alert2'] = 'Segunda alerta';
$string['alert3'] = 'Tercera alerta';
$string['alert_edit'] = 'Editar alertas';
$string['alert_general'] = 'Anuncio';
$string['alert_info'] = 'Información';
$string['alert_warning'] = 'Advertencia';
$string['alertinfodesc'] = 'Escriba las configuraciones para su alerta.';
$string['alertsdesc'] = 'Esto mostrará una (o múltiples) alerta(s) en tres diferentes estilos a sus usuarios en la portada de Moodle. Por favor, recuerde deshabilitarlas cuando ya no las necesite.';
$string['alertsheading'] = 'Alertas a usuarios';
$string['alertsheadingsub'] = 'Mostrar mensajes importantes a sus usuarios en la portada';
$string['alerttext'] = 'Texto de la alerta';
$string['alerttextdesc'] = 'Cual es el texto a mostrar en su alerta..';
$string['alerttitle'] = 'Título';
$string['alerttitledesc'] = 'Título/encabezado principal para su alerta.';
$string['alerttype'] = 'Nivel';
$string['alerttypedesc'] = 'Configure el nivel/tipo de alerta apropiado para informar mejor a sus usuarios.';
$string['allclasses'] = 'Todas las clases';
$string['allcourses'] = 'Todos los cursos';
$string['allmodules'] = 'Todos los módulos';
$string['allunits'] = 'Todas las unidades';
$string['alternativecolors'] = 'Colores Alternos {$a}';
$string['alternativethemecolor'] = 'Color de Tema Alterno {$a}';
$string['alternativethemecolordesc'] = '¿De qué color debería de ser su tema para los colores alternos del tema {$a} ?.';
$string['alternativethemecolorname'] = 'Nombre del conjunto de colores alternos {$a}';
$string['alternativethemecolornamedesc'] = 'Proporcione un nombre reconocible para este conjunto de colores alternos del tema';
$string['alternativethemecolors'] = 'Colores del tema alterno';
$string['alternativethemecolorsdesc'] = 'Define colores alternos del tema que el usuario puede seleccionar.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Color por defecto del fondo del botón {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Configurar el color del fondo para todos  los botones por defecto {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Color por defecto al pasarle el ratón encima al fondo del botón {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Configurar el color del fondo al pasarle el ratón encima a todos los botones por defecto {$a}';
$string['alternativethemedefaultbuttontextcolour'] = 'Color del texto del botón por defecto {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Configurar el color del texto para todos los botones por defecto {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Color del texto del botón al pasarle el ratón encima {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Configurar el color del texto al pasarle el ratón encima  para todos los botones por defecto {$a}';
$string['alternativethemefooterblockbackgroundcolour'] = 'Color del fondo del pie de página para colores del tema alternos {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Configurar el color para el fondo del bloque en el pie de página para los colores del tema alternos {$a}';
$string['alternativethemefooterblockhovercolour'] = 'Color  al pasarle el ratón encima  al enlace del bloque en el pie de página para los colores alternativos del tema {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Configurar el color para su texto del bloque enlazado  al pasarle el ratón encima  al  en el pie de página para los colores alternos del tema {$a}';
$string['alternativethemefooterblocktextcolour'] = 'Color del texto del bloque del pie de página para colores del tema alternos {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Configurar el color que Usted quiere que sea su texto del bloque que esté en el pie de página para los colores del tema alternos {$a}';
$string['alternativethemefooterblockurlcolour'] = 'Color del enlace del bloque del pie de página para colores del tema alternativo {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Configurar el color para su texto del bloque enlazado en el pie de página para colores del tema alternativo {$a}';
$string['alternativethemefootercolor'] = 'Color del fondo del pie de página para colores del tema alternativo {$a}';
$string['alternativethemefootercolordesc'] = 'Configurar de que color debería de ser el fondo de la caja del Pie de página para colores del tema alternativo {$a}';
$string['alternativethemefooterheadingcolor'] = 'Color del encabezado del pie de página para colores del tema alternativo {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Configurar el color para los encabezados para los para colores del tema alternativo {$a}';
$string['alternativethemefooterhovercolor'] = 'Color al pasar el ratón encima del enlace del pie de página para los colores del tema alternativo {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Configurar el color para el texto enlazado cuando le pasa el ratón encima para los colores del tema alternativo {$a}.';
$string['alternativethemefootersepcolor'] = 'Color del separador del pie de página para los colores del tema alterno {$a}';
$string['alternativethemefootersepcolordesc'] = 'Los separadores son líneas usadas para separar contenido. Configure su color aquí para los colores del tema alterno {$a}.';
$string['alternativethemefootertextcolor'] = 'Color del texto del pie de página para colores  del tema alternativo  {$a}';
$string['alternativethemefootertextcolordesc'] = 'Configurar el color que Usted quiere que esté en el pie de página para colores  del tema alternativo  {$a}.';
$string['alternativethemefooterurlcolor'] = 'Color del enlace del pie de página para colores  del tema alternativo  {$a}';
$string['alternativethemefooterurlcolordesc'] = 'Configurar el color para su texto enlazado en el pie de página para colores  del tema alternativo  {$a}.';
$string['alternativethemehovercolor'] = 'Color del tema alterno  al pasar el ratón encima {$a}';
$string['alternativethemehovercolordesc'] = '¿De qué color debería de ser al pasar el ratón encima para los colores alternos del tema  {$a} ?.';
$string['alternativethemeiconcolor'] = 'Color alterno del ícono {$a}';
$string['alternativethemeiconcolordesc'] = 'Configurar el color {$a} alterno para todos los íconos.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Color alternativo {$a} del fondo para curso inscrito y que no ha accesado';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Configurar color del fondo {$a} alternativo para cursos inscritos pero no accesados. Para cuando \'mycoursesorder\' Está configurado en \'Último acceso...\'.';
$string['alternativethemename'] = 'Nombre del Esquema de Color';
$string['alternativethemenamedesc'] = 'Proporcione un nombre para sus colores alternos del tema';
$string['alternativethemenavcolor'] = 'Color del texto en Navegación {$a}';
$string['alternativethemenavcolordesc'] = 'Configura el color {$a} alterno del texto para navegación. Esto es la Barra de Navegación y la ruta de navegación de estilo elegante.';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Color del fondo {$a} para \'Enviar todo y terminar\' del examen';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Configurar el color del fondo {$a} alternativo para el botón de  \'enviar todo y terminar\' del examen.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Color del fondo al pasarle el ratón encima {$a} para \'Enviar todo y terminar\' del examen';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Configurar el color alternativo del fondo al pasarle el ratón encima {$a} para el botón de \'Enviar todo y terminar\' del examen.';
$string['alternativethemequizsubmittextcolour'] = 'Color del texto {$a} para el botón de \'Enviar todo y terminar\' del examen';
$string['alternativethemequizsubmittextcolourdesc'] = 'Configurar el color del texto alternativo {$a} para el botón de \'Enviar todo y terminar\' del examen.';
$string['alternativethemequizsubmittexthovercolour'] = 'Color del texto alternativo al pasarle el ratón encima para \'Enviar todo y terminar\' del examen {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Configurar el color del texto alternativo al pasarle el ratón encima {$a} para el botón de \'Enviar todo y terminar\' del examen.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Color alternativo del fondo del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Configurar el color alternativo del fondo del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblockhovercolour'] = 'Color alternativo al pasar el ratón encima del enlace del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Configurar el color alternativo al pasar el ratón encima del enlace del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblocktextcolour'] = 'Color alternativo del texto del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Configurar el color alternativo del texto del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblockurlcolour'] = 'Color alternativo del enlace del bloque {$a} \'lateral-pre\'';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Configurar el color alternativo del enlace del bloque {$a} \'lateral-pre\'';
$string['alternativethemeslidebuttoncolor'] = 'Color de botón de diapositiva del tema alterno {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'De cual color debería de ser el de botón de diapositiva del tema alterno {$a}';
$string['alternativethemeslidebuttonhovercolor'] = 'Color de botón al pasar el ratón encima de diapositiva del tema alterno {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'De cual color debería de ser al pasar el ratón encima del botón de diapositiva del tema alterno {$a}';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Color del fondo de  subtítulo de diapositiva en tema alternativo {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Cual color debería tener el fondo del subtítulo de la diapositiva de su tema para los colores alternativos {$a}. No aplica para la opción de \'A un lado\' (Beside) de subtítulo de dispositiva.';
$string['alternativethemeslidecaptiontextcolor'] = 'Color del texto de  subtítulo de diapositiva en tema alternativo {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Cual color debería tener el texto del subtítulo de la diapositiva de su tema para los colores alternativos {$a}. No aplica para la opción de \'A un lado\' (Beside) de subtítulo de dispositiva.';
$string['alternativethemeslidecolors'] = 'Colores de diapositiva de tema alterno';
$string['alternativethemeslidecolorsdesc'] = 'Define colores de diapositiva de tema alterno que el usuario puede seleccionar.';
$string['alternativethemestripebackgroundcolour'] = 'Color del fondo de barra alterno {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Configurar el color {$a} del fondo alterno para barras en tablas.';
$string['alternativethemestripetextcolour'] = 'Color del texto de barra alterno {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Configurar el color {$a} del texto alterno para barras en tablas.';
$string['alternativethemestripeurlcolour'] = 'Color de URL de barra alterna {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Configurar el color alterno {$a} de URL para barras en tablas.';
$string['alternativethemetextcolor'] = 'Color del texto alterno {$a}';
$string['alternativethemetextcolordesc'] = 'Configure el color para su texto  alterno{$a}';
$string['alternativethemeurlcolor'] = 'Color alterno del enlace {$a}';
$string['alternativethemeurlcolordesc'] = 'Configure el color para su texto enlazado alterno {$a}';
$string['alwaysdisplay'] = 'Mostrar siempre';
$string['android'] = 'Androide (Google Play)';
$string['androiddesc'] = 'Proporcione una URL hacia su App para móvil en la tienda de Google Play. Si Usted no tiene una App propia allí, por favor considere enlazar a la App Movil Moodle oficial.  (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = 'URL de Android (Google Play)';
$string['asconfigintlower'] = '{$a->value} es menor que el límite del rango inferior de {$a->lower}';
$string['asconfigintnan'] = '{$a->value} no es un número';
$string['asconfigintupper'] = '{$a->value} es mayor que el límite del rango superior de {$a->upper}';
$string['backtotop'] = 'Regresar a la parte superior';
$string['badgepreferences'] = 'Insignia';
$string['badgesmi'] = 'Insignias';
$string['badgesmidesc'] = 'Mostrar el ítem del menú de insignias si el usuario tiene la capacidad \'moodle/badges:manageownbadges\' y las insignias están habilitadas al nivel del sitio.';
$string['beforecontent'] = 'Antes del contenido';
$string['below'] = 'Debajo';
$string['breadcrumbsimple'] = 'Simple';
$string['breadcrumbstyle'] = 'Estilo de la Ruta de Navegación';
$string['breadcrumbstyled'] = 'Elegante';
$string['breadcrumbstyledesc'] = 'Aquí puede Usted cambiar el estilo de la ruta de navegación';
$string['breadcrumbstylednocollapse'] = 'Elegante sin colapsar';
$string['breadcrumbthin'] = 'Delgado';
$string['cachesused'] = 'Se usó lo cacheado';
$string['calendarmi'] = 'Calendario';
$string['calendarmidesc'] = 'Mostrar el ítem del menú del calendario si el usuario tiene la capacidad \'moodle/calendar:manageownentries\'.';
$string['categoryctidesc'] = 'Si se habilita, esto le permitirá configurar imágenes para cada categoría.';
$string['categoryctiheading'] = 'Imágenes del título de categorías de curso';
$string['categoryctiheadingcategory'] = 'Imágenes del título de categoría de curso: {$a->category}';
$string['categoryctiheadingcs'] = 'Configuración de imágenes de título de categoría de curso';
$string['categoryctiheadingsub'] = 'Use imágenes para representar sus categorias dentro de un curso';
$string['categoryctiheight'] = 'Altura de la imagen de título de la Categoría de Curso \'{$a->category}\'';
$string['categoryctiheightdesc'] = 'Altura de la imagen para el título de categoría de curso \'{$a->category}\' entre {$a->lower} y {$a->upper} pixeles. No escriba al final \'px\', solamente ngrese el número.';
$string['categoryctiinfo'] = 'Configuraciones de {$a->category}';
$string['categoryctiinfodesc'] = 'Configuraciones de la imagen del título de Categoría de Curso para: {$a->category}.';
$string['categoryctimage'] = 'Ar4chivo de imagen de título de la Categoría de Curso \'{$a->category}\'';
$string['categoryctimagedesc'] = 'Archivo de la imagen para el título del curso en la categoría \'{$a->category}\'.';
$string['categoryctimageurl'] = 'URL de la imagen del título del curso en la categoría \'{$a->category}\'';
$string['categoryctimageurldesc'] = 'URL de la imagen para el título del curso en la categoría  \'{$a->category}\'. Si se sube el archivo entonces se anulará esto.';
$string['categoryctitextbackgroundcolour'] = 'Color del fondo del texto del título del curso en categoría \'{$a->category}\'';
$string['categoryctitextbackgroundcolourdesc'] = 'Color del fondo del texto para el título del curso en categoría \'{$a->category}\'.';
$string['categoryctitextbackgroundopacity'] = 'Opacidad del fondo del texto para el título del curso en categoría \'{$a->category}\'';
$string['categoryctitextbackgroundopacitydesc'] = 'Opacidad del fondo del texto para el título del curso en categoría \'{$a->category}\'.';
$string['categoryctitextcolour'] = 'Color del texto para el título del curso en categoría \'{$a->category}\'';
$string['categoryctitextcolourdesc'] = 'Color del texto para el título del curso en categoría \'{$a->category}\'.';
$string['categoryiconcategory'] = 'El ícono para la categoría: {$a->category}.';
$string['categoryicondesc'] = 'Si se habilita, esto le permitirá configurar íconos / imágenes para cada categoría.';
$string['categoryiconheading'] = 'Íconos / imágenes  por Categoría';
$string['categoryiconheadingsub'] = 'Usar íconos para representar sus categorías';
$string['categoryiconinfo'] = 'Configurar íconos personalizados para Categorías';
$string['categoryiconinfodesc'] = 'Escriba el nombre del ícono que Usted desea usar. La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que está después de "fa-".';
$string['categoryimagecategory'] = 'La imagen de la categoría: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Categorías dentro de la ruta de navegación del curso';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Mostrar los enlaces a categoría dentro de la ruta de navegación del curso.';
$string['ccd'] = 'Fecha de curso creado';
$string['ced'] = 'Fecha de fin de curso';
$string['cfn'] = 'Nombre completo del curso';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>Acerca de Essential</h3>
<p>Essential esta basado en el tema Bootstrap, que fuera creado para  Moodle 2.5, con la ayuda def:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Créditos del tema</h3>
<p>Autor Original: Julian Ridden<br>
Trabajo continuado a partir de Julio 2014 por:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Trabajo continuado a partir del 9 de Octubre 2014 por:<br>
Gareth J. Barnard<br>
</p>
<h3>Patrocinios</h3>
<p>Este tema se le proporciona a Usted gratuitamente, y si Usted desea expresar su gratitud por usar este tema, por favor considere patrocinarlo por:
<h4>PayPal</h4>
<p>Por favor contácteme via mi <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Perfil Moodle\'</a> para los detalles, pues soy un individuo y por eso no puedo tener  botones para  \'buy me now\' (cómpreme ahora) bajo sus términos de Paypal.</p>
<br>Los patrocinios ayudan para facilitar el mantenimiento y me permiten proporcionarle a Usted más y mejores características. Sin su apoyo este tema no puede ser mantenidoS.</p>
<p>
<h3>Patrocinadores</h3>
<p>Patrocinios gentilmente ceribidos con agradecimientos de:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Essential for Moodle 3.2 amablemente patrocinado por:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM International Institute</li>
</ul>
</p>
<h3>Personalización</h3>
<p>Si a Usted le gusta este tema y quisiera que yo se lo personalice, le traspase funcionalidad a otro tema, le haga un tema nuevo desde cero o que cree un tema hijo, entonces yo le offrezco tarifas competitivas. Por favor contácteme via \'http://moodle.org/user/profile.php?id=442195\' para discutir sus requisitos.</p>
</div></div>';
$string['cid'] = 'ID del curso';
$string['colordesc'] = 'Aquí puede encontrar varias configuraciones para cambiar muchos de los colores encontrados en este tema.';
$string['colorheading'] = 'Color';
$string['colorheadingsub'] = 'Configure los colores usados en su tema';
$string['configtitle'] = 'Essential (Esencial)';
$string['contactinfo'] = 'Información de contacto';
$string['contactinfodesc'] = 'Escriba su información de contacto';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'El nombre de su organización';
$string['coursecategorysettingstitle'] = 'Configuraciones de categoría de curso';
$string['coursecontentsearch'] = 'Búsqueda del contenido del curso';
$string['coursecontentsearchdesc'] = 'Habilitar la búsqueda de contenido en el curso en la página del \'Tablero\'. Solamente funciona cuando Essential no está en   \'\\$CFG->themedir\'.';
$string['coursecontentsearchsortattribute'] = 'Atributo de búsqueda de contenido del curso';
$string['coursecontentsearchsortattributedesc'] = 'Ordenar los resultados de la b´squeda por este atributo.';
$string['coursecontentsearchsortorder'] = 'Orden de búsqueda de contenido del curso';
$string['coursecontentsearchsortorderdesc'] = 'Ordenar los resultados de la búsqueda descendente o ascendentemente';
$string['coursegrades'] = 'Calificaciones del curso';
$string['coursegradesmi'] = 'Calificaciones del curso';
$string['coursegradesmidesc'] = 'Mostrar el ítem del menú de calificaciones del curso si el usuario tiene la capacidad \'gradereport/user:view\' y la configuración \'showgrades\' del curso está configurada en un curso.';
$string['courselistteachericon'] = 'Ícono de profesor de lista de cursos';
$string['courselistteachericondesc'] = 'Nombre del ícono que desea usar o déjelo vacío para ninguno. La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Simplemente escriba lo que sigue después de  "fa-",como por ejemplo  "star".';
$string['coursesettingstitle'] = 'Configuraciones del curso';
$string['coursetitleposition'] = 'Posición del título del curso';
$string['coursetitlepositiondesc'] = 'Elegir entre \'Arriba\' y \'Adentro\' para el curso. Donde \'Arriba\' es arriba de las regiones lateral-pre, página-superior y contenido-curso y \'Adentro\' es adentro de ña región del contenido-curso como era antes de que esta configuración fuera introducida.';
$string['csd'] = 'Fecha de inicio del curso';
$string['ctioverride'] = 'Anulando imágenes de categoría en un curso';
$string['ctioverridedesc'] = 'Si Usted desea anular la imagen del título de categoría de curso en un curso cuando esto está habilitado con la configuración de \'enablecategorycti\', entonces edite el resumen del curso en las configuraciones del curso y añada una imagen. Después, edite en modo HTML, quite las marcas \'p\' y \'br\'; después quite los atributos \'style\', \'width\' y \'height\' y cualquier \'classes\' añadidas por el editor de texto en la marca \'img\'. Después, añada la clase \'categorycti\'. Para especificar la altura (px) y el color del texto del título contenido, opacidad y color del fondo, use los siguientes atributos: \'ctih\', \'ctit\', \'ctib\' y \'ctio\' respectivamente; por ejemplo:<br/><br/><img src="https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" alt="Replacement image" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0.5"><br/><br/>Esta imagen no se mostrará en el resumen mismo al ver la lista de cursos.';
$string['ctioverrideheight'] = 'Altura anulada por defecto de imagen de título de curso';
$string['ctioverrideheightdesc'] = 'Altura anulada por defecto de la imagen para el título del curso entre {$a->lower} y {$a->upper} pixeles. No escriba al final \'px\', solamente ingrese el número.';
$string['ctioverridetextbackgroundcolour'] = 'Color anulado por defecto del fondo del texto del título de curso';
$string['ctioverridetextbackgroundcolourdesc'] = 'Color anulado por defecto del fondo del texto para el título del curso.';
$string['ctioverridetextbackgroundopacity'] = 'Opacidad anulada por defecto del fondo del texto para el título del curso';
$string['ctioverridetextbackgroundopacitydesc'] = 'Opacidad anulada por defecto del fondo del texto para el título del curso.';
$string['ctioverridetextcolour'] = 'Color anulado por defecto del texto para el título del curso';
$string['ctioverridetextcolourdesc'] = 'Color anulado por defecto del texto para el título del curso.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Las reglas CSS que añada en esta área se reflejarán en todas las páginas, haciendo más fácil la personalización del tema.';
$string['customscrollbars'] = 'Barras de deslizamiento personalizadas';
$string['customscrollbarsdesc'] = 'Usar barras deslizables personalizadas. Éstas remplazarán a las barras estándar del navegador.';
$string['dbqueries'] = 'Leer/Escribir de/a BasedeDatos';
$string['dbtime'] = 'Tiembo de solicitud a BasedeDatos';
$string['defaultcategoryicon'] = 'Íconos por Defecto para Categoría';
$string['defaultcategoryicondesc'] = 'Configurar un ícono predeterminado para categoría';
$string['defaultcategoryimage'] = 'Imagen por defecto de la categoría';
$string['defaultcategoryimagedesc'] = 'Configurar una Imagen por defecto de la categoría. Anulará el ícono cuando sea poblada.';
$string['defaultcolors'] = 'Colores predeterminados';
$string['displayafterlogin'] = 'Mostrar solamente después de ingresar';
$string['displaybeforelogin'] = 'Mostrar solamente antes de ingresar';
$string['displayeditingmenu'] = 'Mostrar botón para edición';
$string['displayeditingmenudesc'] = 'Muestra un botón con la misma funcionalidad que el botón por defecto para editar la página en el encabezado.';
$string['displayhiddenmycourses'] = 'Mostrar cursos ocultos';
$string['displayhiddenmycoursesdesc'] = 'Mostrar cursos ocultos para usuarios en el \'Menú de Cursos\' si ellos tienen permiso para ver cursos ocultos';
$string['displaymycourses'] = 'Mostrar cursos';
$string['displaymycoursesdesc'] = 'Mostrar cursos inscritos para los usuarios en la \'Barra de Navegación\'.';
$string['docking'] = 'Habilitar apartar .';
$string['dockingdesc'] = 'Si se habilita, estará disponible la opción de apartar.';
$string['dontdisplay'] = 'Nunca mostrar';
$string['dropdownmenumaxheight'] = 'Altura máxima del menú desplegable';
$string['dropdownmenumaxheightdesc'] = 'Altura máxima del menú desplegable cuando están habilitadas as barras de desplazamiento. Entre {$a->lower} y {$a->upper} pixeles.';
$string['dropdownmenuscroll'] = 'Barras de desplazamiento en los menúes desplegables';
$string['dropdownmenuscrolldesc'] = 'Tener una barar de desplazamiento en el menú desplegable cuando la altura delmenú sea limitada.';
$string['editingmenu'] = 'Switch para editar página';
$string['editingmenudesc'] = 'Mostrar un botón para cambiar la edición de la página actual y activarla/desactivarla si se le permite al usuario editar la página. La misma funcionalidad del botón normal para editar la página.';
$string['enablealert'] = 'Habilitar alertas';
$string['enablealertdesc'] = 'Habilitar o deshabilitar alerta';
$string['enablealternativethemecolors'] = 'Habilitar colores alternos del tema {$a}';
$string['enablealternativethemecolorsdesc'] = 'Si se habilita, el usuario podrá elegir los colores alternos del tema {$a}.';
$string['enablecategorycti'] = 'Habilitar imágenes de título de categoría de curso';
$string['enablecategoryctics'] = 'Habilitar páginas de configuración de imágenes de título de categoría de curso';
$string['enablecategorycticsdesc'] = 'Si se habilita, cada categoría de nivel superior tendrá su propia página de configuraciones';
$string['enablecategoryctidesc'] = 'Si se habilita, Usted podrá seleccionar imágenes de títulos de categoría de curso después de hacer clic en  "Guardar cambios".';
$string['enablecategoryicon'] = 'Habilitar íconos / imágenes por categoría';
$string['enablecategoryicondesc'] = 'Si se habilita, Usted podrá seleccionar íconos / imágenes de categorías  después de elegir "Guardar cambios".';
$string['enablecustomcategoryicon'] = 'Habilitar íconos/ imágenes por categorías';
$string['enablecustomcategoryicondesc'] = 'Si se habilita, debajo de esta sección Usted verá una categoría con una opción personalizable debajo de cada categoría. Por favor, guarde después de habilitar o deshabilitar esta opción.';
$string['extperfinfoheading'] = 'Información Extensiva sobre Desempeño';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Escriba la URL de su página de Facebook. (por ejemplo: https://es-es.facebook.com/UNAM.MX.Oficial o https://www.facebook.com/ipn.mx o https://www.facebook.com/UAMXochimilco)';
$string['facebookurl'] = 'URL de Facebook';
$string['favicon'] = 'Favicom personalizado';
$string['favicondesc'] = 'Suba su favico favorito. Debe de ser un archivo .ico.';
$string['featuredesc'] = 'Aquí puede Usted encontrar varias configuraciones para cambiar varias de las características encontradas en este tema.';
$string['featureheading'] = 'Características';
$string['featureheadingsub'] = 'Configurar las características usadas en su tema';
$string['findcoursecontent'] = 'Buscar en curso:';
$string['fitvids'] = 'Usar FitVids';
$string['fitvidsdesc'] = 'Habilitar FitVids (fitvidsjs.com) para hacer sus videos incrustados responsivos. Si FitVids está activado y Usted quiere que un  video sea excluido, entonces añada  \'class="fitvidsignore"\' a la etiqueta (\'\'tag\'\') \'iframe\' en el  modo HTML del editor. Por ejemplo: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Ancho Fijo - Angosto';
$string['fixedwidthnormal'] = 'Ancho fijo - Normal';
$string['fixedwidthwide'] = 'Ancho Fijo - Ancho';
$string['flatnavigation'] = 'Habilitar navegación plana.';
$string['flatnavigationdesc'] = 'Si se habilita, se usará navegación plana  en lugar de los bloques de navegación y configuraciones.';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Escriba la URL de su página de Flickr. (por ejemplo: http://www.flickr.com/people/ciecounam/)';
$string['flickrurl'] = 'URL de Flickr';
$string['floatingsubmitbuttons'] = 'Botones de enviar flotantes';
$string['floatingsubmitbuttonsdesc'] = 'Tener una área \'flotante\' que contiene a los botones usados al enviar un formato en dispositivos de escritorio. Esto ayuda a reducir el tener que deslizar el curso en algunas páginas. No se usa en inscripciones a curso o en publicacioens en foros.';
$string['fontcharacterset'] = 'Conjunto de caracteres adicionales de Tipos de letras de Google';
$string['fontcharactersetcyrillic'] = 'Cirílico';
$string['fontcharactersetcyrillicext'] = 'Cirílico extendido';
$string['fontcharactersetdesc'] = 'Elija conjuntos de caracteres adicionales para diferentes idiomas. Al usar muchos conjuntos de caracteres se puede alentar su Moodle, por lo que se le recomienda que solamente seleccione los conjuntos de caracteres que reaalmente necesita.';
$string['fontcharactersetgreek'] = 'Griego';
$string['fontcharactersetgreekext'] = 'Griego extendido';
$string['fontcharactersetlatinext'] = 'Latín extendido';
$string['fontcharactersetvietnamese'] = 'Vietnamita';
$string['fontfileeotbody'] = 'Archivo del tipo de letra (\'\'font\'\') EOT del cuerpo (\'\'body\'\')';
$string['fontfileeotheading'] = 'Archivo del tipo de letra (\'\'font\'\') EOT del encabezado (\'\'heading\'\')';
$string['fontfileotfbody'] = 'Archivo del tipo de letra (\'\'font\'\') OTF del cuerpo (\'\'body\'\')';
$string['fontfileotfheading'] = 'Archivo del tipo de letra (\'\'font\'\') OTF del encabezado (\'\'heading\'\')';
$string['fontfiles'] = 'Archivos de \'Fonts\'';
$string['fontfilesdesc'] = 'Suba aquí sus archivos de \'fonts\'.';
$string['fontfilesvgbody'] = 'Archivo de tipo de letra (\'\'font\'\') SVG del cuerpo (\'\'body\'\')';
$string['fontfilesvgheading'] = 'Archivo de tipo de letra (\'\'font\'\') SVG del encabezado (\'\'heading\'\')';
$string['fontfilettfbody'] = 'Archivo de font TTF para cuerpo';
$string['fontfilettfheading'] = 'Archivo de font TTF para encabezado';
$string['fontfilewoffbody'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF del encabezado (\'\'heading\'\')';
$string['fontfilewoffheading'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF del encabezado (\'\'heading\'\')';
$string['fontfilewofftwobody'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF2 del cuerpo (\'\'body\'\')';
$string['fontfilewofftwoheading'] = 'Archivo de tipo de letra (\'\'font\'\') WOFF2 del encabezado (\'\'heading\'\')';
$string['fontheadingdesc'] = 'Seleccione y escriba los tipos de letra (\'\'fonts\'\') que quiera usar en su ambiente Moodle';
$string['fontheadingsub'] = 'Configuraciones del tipo de letra (\'\'font\'\')';
$string['fontnamebody'] = 'Font para texto';
$string['fontnamebodydesc'] = 'Escriba el nombre exacto del \'font\' a usar para todo el demás texto.';
$string['fontnameheading'] = 'Font para encabezado';
$string['fontnameheadingdesc'] = 'Escriba el nombre exacto del \'font\' a usar para encabezados.';
$string['fontselect'] = 'Selector de tipos de letras (Fonts)';
$string['fontselectdesc'] = 'Elija de entre la lista disponible de mecanismos de definición de tipos de letra (fonts) disponibles:<ul><li>\'Los tipos (fonts) del usuario\' estan en donde los tipos de letra (fonts) ya están instalados en la máquina del usuario y Usted solamente especifica su nombre.</li><li>\'Google web fonts\' están en donde Usted encuentre un tipo de letra (font) en \'{$a->googlewebfonts}\' y especifica su nombre.</li><li>\'Los tipos de letra personalizados (Custom fonts)\' están en donde Usted especifique el nombre y suba los archivos de los tipos (fonts) para ellos.</li></ul>Por favor, guarde para mostrar las opciones para su elección.';
$string['fontsettings'] = 'Tipo de letra (\'\'font\'\')';
$string['fonttypecustom'] = 'Tipos de letra (Fonts) personalizados';
$string['fonttypegoogle'] = '\'Fonts\' de web de Google';
$string['fonttypeuser'] = 'Tipos de letras (fonts) del usuario';
$string['footerblockbackgroundcolour'] = 'Color del fondo del bloque del pie de página';
$string['footerblockbackgroundcolourdesc'] = 'Configurar el color para el fondo del bloque  en el pie de página.';
$string['footerblockhovercolour'] = 'Color al pasar el ratón encima del enlace del bloque del pie de página';
$string['footerblockhovercolourdesc'] = 'Configurar el color para el texto del bloque enlazado al pasar el ratón encima en el pie de página.';
$string['footerblocktextcolour'] = 'Color del texto del bloque del pie de página';
$string['footerblocktextcolourdesc'] = 'Configurar el color que Usted quiere pare el texto del bloque del pie de página.';
$string['footerblockurlcolour'] = 'Color del enlace del bloque del pie de página';
$string['footerblockurlcolourdesc'] = 'Configurar el color para su texto del bloque enlazado en el pie de página.';
$string['footercolor'] = 'Color del Fondo del Pie de página';
$string['footercolordesc'] = 'Configure de qué color debería de ser la caja del Pie de Página.';
$string['footercolors'] = 'Colores del pie de página';
$string['footercolorsdesc'] = 'Cambiar los colores del pie de página';
$string['footerheading'] = 'Pie de página';
$string['footerheadingcolor'] = 'Color del Encabezado del Pie de Página';
$string['footerheadingcolordesc'] = 'Configure el color para los encabezados del Pie de Página.';
$string['footerhovercolor'] = 'Color al pasar Ratón encima para Enlace del Pie de Página';
$string['footerhovercolordesc'] = 'Configure el Color para el Texto Enlazado cuando le pase el ratón por encima en el Pie de Página';
$string['footersepcolor'] = 'Color de Separador del Pie de Página';
$string['footersepcolordesc'] = 'Los separadores son líneas usadas para separar contenidos. Configure aquí sus colores.';
$string['footertextcolor'] = 'Color del Texto del Pie de página';
$string['footertextcolordesc'] = 'Configure el color que quiera para el texto del Pie de Página';
$string['footerurlcolor'] = 'Color del enlace del Pie de Página';
$string['footerurlcolordesc'] = 'Configure el color que quiera para el texto enlazado del Pie de Página.';
$string['footnote'] = 'Nota al pie';
$string['footnotedesc'] = 'Lo que añada a esta área de texto se reflejará en el pie de página de todo su sitio Moodle.';
$string['forumdiscussionsmi'] = 'Discusiones';
$string['forumdiscussionsmidesc'] = 'Mostrar el ítem del menú de discusiones (foro) si el usuario tiene la capacidad \'mod/forum:viewdiscussion\'.';
$string['forumpostsmi'] = 'Publicaciones en foro';
$string['forumpostsmidesc'] = 'Mostrar el ítem del menú de publicaciones en foro si el usuario tiene la capacidad \'mod/forum:viewdiscussion\'.';
$string['fppagetopblocks'] = 'Habilitar bloques de portada de \'Superior de la página\'';
$string['fppagetopblocksdesc'] = 'Si se habilita, esto mostrará una ubicación de bloque adicional a un lado de los bloques laterales y arriba del área del contenido. Nota: El número de bloques por fila depende de la configuración \'pagetopblocksperrow\'.';
$string['fppagetopblocksperrow'] = 'Bloques por fila en la parte superior de la página';
$string['fppagetopblocksperrowdesc'] = 'Especifíque cuantos bloques por fila entre {$a->lower} y {$a->upper} para la región de \'Parte superior de la página\' en la Portada.';
$string['frontcontent'] = 'Habilitar área de contenido en Portada';
$string['frontcontentarea'] = 'Contenidos del área de contenidos de la Portada';
$string['frontcontentareadesc'] = 'Todo lo que escriba en esta caja se mostrará a todo lo ancho de la página entre el carrusel de imágenes y los Bloques Publicitarios.';
$string['frontcontentdesc'] = 'Si se habilita, esto añade un área de contenido personalizado, entre la presentación de imágenes y las cajas de Publicidad, para su propio contenido personalizado';
$string['frontcontentheading'] = 'Área de contenidos de la Portada';
$string['frontpageblocks'] = 'Alineación de bloques de la portada';
$string['frontpageblocksdesc'] = 'Aquí puede Usted determinar si es que los bloques estándar en Moodle en la Portada se alinean antes o después del contenido.';
$string['frontpageblocksheading'] = 'Bloques de la página de Portada';
$string['frontpageheading'] = 'Página de Portada';
$string['frontpageheadingdesc'] = 'Configure aquí los ítems adicionales que desee mostrar en la página de la Portada.';
$string['frontpagehomeblocksperrow'] = 'Bloques por fila en Hogar (era EnMedio)';
$string['frontpagehomeblocksperrowdesc'] = 'Diga cuantos bloque por fila entre {$a->lower} y {$a->upper} para la región de bloque de \'Bloques en Hogar\'. Nota: Para facilidad al editar, se mostrarán dos bloques por fila sin importar esta configuración.';
$string['frontpagemiddleblocks'] = 'Habilitar bloques adicionales el el \'Hogar\' (lo que eran bloques de enmedio) de la portada';
$string['frontpagemiddleblocksdesc'] = 'Si se habilita, esto mostrará una nueva ubicación para bloque, justo debajo de los Bloques Publicitarios.';
$string['frontpagesettingstitle'] = 'Configuraciones de portada';
$string['fullname'] = 'Nombre completo del sitio';
$string['fullnamesummary'] = 'Nombre completo y resumen';
$string['generalheadingdesc'] = 'Configure aquí las configuraciones globales para el tema.';
$string['generalheadingsub'] = 'Configuraciones generales';
$string['genericsettings'] = 'Generales';
$string['googleplus'] = 'Google +';
$string['googleplusdesc'] = 'Escriba la URL de su perfil de Google+ (por ejemplo https://plus.google.com/+moodle )';
$string['googleplusurl'] = 'URL de Google +';
$string['gotobottom'] = 'Ir al fondo de la página';
$string['gotopeople'] = 'Ir a gente';
$string['haveheaderblock'] = 'Región del bloque del encabezado';
$string['haveheaderblockdesc'] = 'Tener una región del bloque del encabezado justo debajo de la ruta de navegación.';
$string['headerbackground'] = 'Imagen del fondo del encabezado';
$string['headerbackgrounddesc'] = 'Suba su propia imagen de fondo';
$string['headerbackgroundstyle'] = 'Estilo del fondo del encabezado';
$string['headerbackgroundstyledesc'] = 'Seleccione el estilo para el fondo del encabezado.';
$string['headerblocksperrow'] = 'Bloques de encabezado por fila';
$string['headerblocksperrowdesc'] = 'Ponga cuantos bloques por fila entre {$a->lower} y {$a->upper} para páginas con \'Región de bloque del encabezado\'.';
$string['headerheading'] = 'Encabezado';
$string['headertextcolor'] = 'Color del texto del encabezado';
$string['headertextcolordesc'] = 'Configurar el color del texto del encabezado';
$string['headertitle'] = 'Título del encabezado';
$string['headertitledesc'] = 'Configure aquí el título a mostrar en el encabezado. Tenga en cuenta que el título del encabezado solamente se usará si no hubiera LOGO.';
$string['helplink'] = 'Enlace de ayuda';
$string['helplinkdesc'] = 'Si Usted elige la URL de arriba, llene la URL completa hacia la ayuda de su sitio (debe incluir http:// o https://). Si Usted elige una dirección de Email, ponga su dirección de Email.';
$string['helplinktype'] = 'Habilitar enlace de ayuda en el menú';
$string['helplinktypedesc'] = 'Elija si es que desea habilitar una opción para ayuda en el menú del usuario; Usted puede elegir si proporciona una URL que se abrirá en una nueva ventana o una dirección de Email.';
$string['hidedefaulteditingbutton'] = 'Ocultar botón para editar en página por defecto';
$string['hidedefaulteditingbuttondesc'] = 'Oculta el botón por defecto para edtar página de cualquier página. esta configuración solamente tiene efecto si se habilita la configuración de \'Mostrar botón para editar\'.';
$string['hideonphone'] = 'Ocultar presentación con imágenes en dispositivos móviles';
$string['hideonphonedesc'] = 'Elija si desea deshabilitar o no  la presentación con imágenes en dispositivos móviles.';
$string['hideontablet'] = 'Ocultar presentación con imágenes en tabletas';
$string['hideontabletdesc'] = 'Elija si Usted desea deshabilitar la presentación con imágenes en tabletas.';
$string['hvpcustomcss'] = 'CSS Personalizado de H5P';
$string['hvpcustomcssdesc'] = 'CSS Personalizado para el módulo H5P (moodle.org/plugins/mod_hvp) si estuviera instalado.';
$string['icon'] = 'ícono';
$string['image'] = 'imagen';
$string['included'] = 'Archivos incluidos';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Escriba la URL de su pagina de Instagram. (ejemplo: http://instagram.com/micolegio)';
$string['instagramurl'] = 'URL de Instagram';
$string['ios'] = 'iPhone/iPad (Tienda de App)';
$string['iosdesc'] = 'Proporciona una URL para su App de dispositivo móvil en la Tienda de Apple. Si Usted no tiene una App propia, puede considerar enlazar a la App oficial de Moodle para móvil (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Íconos de pantalla para Hogar para IOs';
$string['iosicondesc'] = 'El tema proporciona un ícono por defecto para la pantalla de inicio para  IOs y Androide . Usted puede subir sus íconos personalizados si lo desea.';
$string['iosurl'] = 'URL de iPhone/iPad (App Store)';
$string['ipadicon'] = 'Ícono de Ipad (No Retina)';
$string['ipadicondesc'] = 'Los íconos deberían de ser archivos PNG de 72 pixeles por 72 pixeles.';
$string['ipadretinaicon'] = 'Ícono de Ipad (Retina)';
$string['ipadretinaicondesc'] = 'Los íconos deberían de ser archivos PNG de 144 pixeles por 144 pixeles.';
$string['iphoneicon'] = 'Ícono de iPhone/iPod Touch (No Retina)';
$string['iphoneicondesc'] = 'Los íconos deberían de ser archivos PNG de 57 pixeles por 57 pixeles.';
$string['iphoneretinaicon'] = 'Ícono de iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Los íconos deberían de ser archivos PNG de 114 pixeles por 114 pixeles.';
$string['layout'] = 'Usar un diseño gráfico de curso estándar';
$string['layoutdesc'] = 'Este tema está diseñado para poner ambas columnas de bloques al lado. Si Usted prefiere el diseño gráfico estándar de Moodle, Usted puede seleccionar esta casilla y regresar al diseño gráfico antiguo de tres columnas.';
$string['left'] = 'Izquierda';
$string['linkedin'] = 'Linkedln';
$string['linkedindesc'] = 'Escriba la URL de su perfil en Linkedln aquí (por ejemplo: https://www.linkedin.com/company/moodle/)';
$string['linkedinurl'] = 'URL de Linkedln';
$string['loadtime'] = 'Tiempo para subir';
$string['loggedinas'] = 'Ingresado como';
$string['loggedinfrom'] = 'Ingresado desde';
$string['loggedinfrommi'] = 'Ingresado desde';
$string['loggedinfrommidesc'] = 'Mostrar desde donde está ingresado si el usuario es un usuario remoto MNET.';
$string['loginbackground'] = 'Imagen del fondo al ingresar';
$string['loginbackgrounddesc'] = 'Suba su propia imagen del fondo al ingresar. Seleccione el estilo de la imagen debajo.';
$string['loginbackgroundopacity'] = 'Opacidad del fondo de caja al ingresar cuando hay una imagen de fondo';
$string['loginbackgroundopacitydesc'] = 'Opacidad del fondo de caja para ingresar cuando hay una imagen de fondo.';
$string['loginbackgroundstyle'] = 'Estilo de fondo al ingresar';
$string['loginbackgroundstyledesc'] = 'Seleccionar el estilo para la imagen subida.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Por favor suba aquí su logo personalizado si quiere añadirlo al encabezado..<br>La imagen será escalada para que quepa en el ancho de porcentaje disponible especificado debajo para el dispositivo. Esto da una solución responsiva. Si Usted tiene muchos íconos de App / sociales, entonces revise dos veces el resultado.<br>Si Usted sube un logo, remplazará al ícono estándar y el nombre que se muestran por defecto.';
$string['logodesktopwidth'] = 'Ancho de logo de escritorio';
$string['logodesktopwidthdesc'] = 'El ancho de la imagen del contenedor del logo en una PC de escritorio, < 980px.<br>Por favor póngalo como un porcentaje del espacio disponible entre {$a->lower} y {$a->upper}.<br>El espacio disponible es el ancho permitido por la configuración \'pagewith\' (ancho_de_página). La imagen cabrá en el porcentaje especificado hasta el ancho de la resolución.';
$string['logodimerror'] = 'es inválido. Por favor escriba \'px\' o \'em\' inmediatamente después del valor de unidades y no ponga nada antes del valor de unidades.';
$string['logomobilewidth'] = 'Ancho del logo en dispositivo móvil';
$string['logomobilewidthdesc'] = 'El ancho de la imagen del contenedor del logo en un dispositivo móvil, < 980px.<br>Por favor póngalo como un porcentaje del espacio disponible entre {$a->lower} y {$a->upper}.<br>El espacio disponible es el ancho permitido por la configuración \'pagewith\' (ancho_de_página). La imagen cabrá en el porcentaje especificado hasta el ancho de la resolución.';
$string['marketing1'] = 'Bloque Publicitario Uno';
$string['marketing2'] = 'Bloque Publicitario Dos';
$string['marketing3'] = 'Bloque Publicitario Tres';
$string['marketingbuttontext'] = 'Texto del Enlace';
$string['marketingbuttontextdesc'] = 'Texto que aparecerá en el botón';
$string['marketingbuttonurl'] = 'URL a enlazar';
$string['marketingbuttonurldesc'] = 'URL a donde apuntará el botón';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido a mostrar en la Caja Promocional. Hágalo corto y dulce.';
$string['marketingdesc'] = 'Este tema proporciona la opción para habilitar tres puntos de "anuncio" o "promoción" justo debajo de la presentación de imágenes. Estos puntos le premiten identificar facilmente información básica para sus usuarios, y proporcionarles enlaces directos.';
$string['marketingheading'] = 'Bloques Publicitarios';
$string['marketingheadingsub'] = 'Tres lugares en la portada para añadir información y enlaces';
$string['marketingheight'] = 'Altura (px) de contenedor de Anuncios';
$string['marketingheightdesc'] = 'Si Usted quiere mostrar imágenes en las cajas de Anuncios, aquí puede especificar sus alturas.';
$string['marketingicon'] = 'Ícono';
$string['marketingicondesc'] = 'Nombre del ícono que Usted desea usar. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que aparece después de "fa-", por ejemplo "star" .';
$string['marketingimage'] = 'Imagen';
$string['marketingimagedesc'] = 'Esto proporciona la opción para mostrar una imagen arriba del texto en el Bloque Publicitario';
$string['marketingimageheight'] = 'Altura de imágenes promocionales (px)';
$string['marketingimageheightdesc'] = 'Si Usted quiere mostrar imágenes en las cajas promocionales, Usted puede especificar su altura en pixeles aquí.';
$string['marketinginfodesc'] = 'Escriba las configuraciones para su Bloque Publicitario.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a mostrar en el Bloque Publicitario';
$string['marketingurltarget'] = 'Enlazar destino';
$string['marketingurltargetdesc'] = 'Elegir cómo debiera abrirse el enlace';
$string['marketingurltargetnew'] = 'Página nueva';
$string['marketingurltargetparent'] = 'Marco Padre';
$string['marketingurltargetself'] = 'Página Actual';
$string['memused'] = 'Memoria utilizada';
$string['messagesmi'] = 'Mensajes';
$string['messagesmidesc'] = 'Mostrar el ítem del menú de mensajes si está habilitado.';
$string['mobileappsdesc'] = '¿ Tiene Usted una App Web en la Tienda de Apps o la Tienda de Google Play ? Proporcione aquí un enlace, para que sus usuarios puedan adquirir las Apps en línea';
$string['mobileappsheading'] = 'Apps';
$string['mobileappsheadingsub'] = 'Enlace a su App para que sus alumnos usen dispositivos móviles';
$string['modulesettingstitle'] = 'Configuraciones del módulo';
$string['myclasses'] = 'Mis Clases';
$string['mycourses'] = 'Mis Cursos';
$string['mycoursescatsubmenu'] = 'Sub-menú de categoría y curso';
$string['mycoursescatsubmenudesc'] = 'Organiza los cursos en un sub-menú basado en la categoría de nivel superior en la que están. Cuando \'enablecategoryicon\' es \'falso\' entonces el ícono de categoría usado será el de por defecto del tema; cuando sea \'verdadero\' entonces será, o bien el valor de \'defaultcategoryicon\' o el de la categoría misma si \'enablecustomcategoryicon\' es verdadero. La configuración de \'mycoursesmax\' se seguirá aplicando pero a un nivel por-categoría.';
$string['mycoursesinfo'] = 'Menú de Cursos';
$string['mycoursesinfodesc'] = 'Muestra una lista dinámica de cursos inscritos para el usuario';
$string['mycoursesmax'] = 'Máximo de cursos';
$string['mycoursesmaxdesc'] = 'Diga cuantos cursos deberán enlistarse; entre {$a->lower} y  {$a->upper} en donde \'{$a->lower}\' representa todos.';
$string['mycoursesorder'] = 'Orden de cursos';
$string['mycoursesorderdesc'] = 'Diga como deberían de ordenarse los cursos. El orden para ordenar cursos puede configurarse por la configuración de navegación \'navsortmycoursessort\'.';
$string['mycoursesorderenrolbackcolour'] = 'Color del fondo para curso inscrito y no accesado';
$string['mycoursesorderenrolbackcolourdesc'] = 'El color del fondo para cursos inscritos pero no accesados. Para cuando \'mycoursesorder\' se configura en  \'Último accesado...\'.';
$string['mycoursesorderid'] = 'ID del curso';
$string['mycoursesorderidasc'] = 'Ascendente';
$string['mycoursesorderiddes'] = 'Descendiente';
$string['mycoursesorderidorder'] = 'Orden de ID del curso';
$string['mycoursesorderidorderdesc'] = 'Orden de ID de curso para cuando \'ID del curso\' se confgura como \'El orden de cursos\'.';
$string['mycoursesorderlast'] = 'Hora de último accesado u hora de inicio de inscripción si nuca fue accesado.';
$string['mycoursesordersort'] = 'Orden del ordenamiento de cursos';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología para el título del menú de "Mis Cursos". Cuando se configura \'mycoursesorder\' a \'Último acceso...\' entonces se añadirá la frase \'más recientes\'.';
$string['mygrades'] = 'Mis calificaciones';
$string['mygradesmi'] = 'Mis Calificaciones';
$string['mygradesmidesc'] = 'Mostrar el ítem del menú si el usuario tiene la capacidad \'gradereport/overview:view\' en un curso. No es revisada al nivel del sitio.';
$string['mylatestclasses'] = 'Mis clases recientes';
$string['mylatestcourses'] = 'Mis cursos recientes';
$string['mylatestmodules'] = 'Mis módulos recientes';
$string['mylatestunits'] = 'Mis unidades recientes';
$string['mymodules'] = 'Mis Módulos';
$string['myunits'] = 'Mis Unidades';
$string['navbarabove'] = 'Barra de Navegación arriba del encabezado';
$string['navbarbelow'] = 'Barra de Navegación debajo del encabezado';
$string['navbartitle'] = 'Título de Barra de Navegación';
$string['navbartitledesc'] = 'Configure aquí el título a usar en la barra de navegación.';
$string['nextsection'] = 'Sección Siguiente';
$string['nobreadcrumb'] = 'Ocultar';
$string['noenrolments'] = 'Usted no tiene inscripciones vigentes';
$string['noslidetitle'] = 'No tiene título la imágen {$a->slide}';
$string['notitle'] = 'Sin título';
$string['numberofcoursesandsubcatcourses'] = 'Número de cursos - cursos en sub-categoría';
$string['numberofslides'] = 'Número de imágenes';
$string['numberofslides_desc'] = 'Número de imágenes en el pasador de imágenes';
$string['oldnavbar'] = 'Use la posición de la antigua Barra de Navegación';
$string['oldnavbardesc'] = 'Habilite esta opción para usar la posición de la antigua Barra de Navegación, poniéndola debajo del encabezado.';
$string['pagebackground'] = 'Imágenes de Fondo de la Página';
$string['pagebackgrounddesc'] = 'Suba su propia imagen de fondo. Seleccione debajo el estilo de la imagen.';
$string['pagebackgroundstyle'] = 'Estilo del fondo de la página';
$string['pagebackgroundstyledesc'] = 'Seleccione el estilo para la imagen subida.';
$string['pagebottomblocksperrow'] = 'Bloques por fila de fondo de página';
$string['pagebottomblocksperrowdesc'] = 'Diga cuantos bloques por fila; entre {$a->lower} y {$a->upper} para páginas con \'Bloques de fondo de páginas\'. Las páginas actuales son: Admin, Gestión del Curso, Calificación y Editar examen.';
$string['pagetopblocks'] = 'Habilitar bloques de página adicionales de \'Parte superior de la página\'';
$string['pagetopblocksdesc'] = 'Si se habilita, esto mostrará una ubicación adicional de bloques a un lado de los bloques laterales y arriba del área de contenido en todas las páginas excepto en Portada, que tiene su propia configuración. Nota: El número de bloques por fila depende de la configuración \'pagetopblocksperrow\'.';
$string['pagetopblocksperrow'] = 'Bloques por fila en parte superior de la página';
$string['pagetopblocksperrowdesc'] = 'Especifique cuantos bloques por fila, entre {$a->lower} y {$a->upper} para páginas con \'Bloques en parte superior de página\'. Las páginas actuales son: Curso, Categoría de Curso, Tablero, Mi Pública e Imprimir.';
$string['pagewidth'] = 'Configurar Ancho de Página';
$string['pagewidthdesc'] = 'Elija de entre la lista de anchos de página disponibles para su sitio.';
$string['participantsmenu'] = 'Menú de participantes';
$string['participantsmenudesc'] = 'Mostrar el menú de participantes en las páginas del curso y del módulo.';
$string['paypal_click'] = 'Perfil de Moodle';
$string['paypal_desc'] = '{$a->url}\' para los detalles, porque como soy un  individuo, no puedo tener botones para recibir \'donativos\' ni \'cómpreme ahora\' bajo sus condiciones o';
$string['peakmem'] = 'Pico de Memoria';
$string['perf_max'] = 'Detallada';
$string['perf_min'] = 'Mínima';
$string['perfinfo'] = 'Modo de Información de Desempeño';
$string['perfinfodesc'] = 'Muchos sitios no necesitan la información detallada completa sobre el desempeño, especialmente cuando los ven los usuarios. Cuando se habilita, esto muestra un formato mínimo arreglado, con información básica acerca de carga de la página.';
$string['perfinfoheading'] = 'Información del Desempeño';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Ingrese la URL de su página de Pinterest. (por ejemplo http://pinterest.com/mi_escuela)';
$string['pinteresturl'] = 'URL de Pinterest';
$string['pluginname'] = 'Essential (Esencial)';
$string['preferencesmi'] = 'Preferencias';
$string['preferencesmidesc'] = 'Mostrar el ítem del menú de preferencias.';
$string['previoussection'] = 'Sección Anterior';
$string['privacy:metadata:preference:courseitemsearchtype'] = 'La elección del usuario de búsqueda en curso (\'nombre completo del curso\' - \'0\' o todo el contenido del curso - \'1\') si alguna vez se almacenó cuando se seleccionó  \'coursecontentsearch\'. Si no se pone nada, entonces ya sea porque está desactivada la búsqueda  o el usuario nunca ha visto el Tablero cuando estaba activada.';
$string['privacy:request:preference:courseitemsearchtype'] = 'El usuario ha elegido "{$a->value}" para la preferencia del usuario para búsqueda en curso "{$a->name}" donde \'0\' es el \'nombre completo del curso solamente\' y \'1\' es \'todo el contenido del curso\'.';
$string['privatefilesmi'] = 'Archivos privados';
$string['privatefilesmidesc'] = 'Mostrar el ítem del menú de archivos privados si el usuario tiene la capacidad \'moodle/user:manageownfiles\'.';
$string['profilebarcustomtitle'] = 'Título personalizado del Bloque de Barra de Perfil';
$string['profilebarcustomtitledesc'] = 'Título para el bloque personalizado de la Barra de Perfil.';
$string['profilelinkmi'] = 'Enlace al perfil';
$string['profilelinkmidesc'] = 'Mostrar el ítem de menú del enlace al perfil.';
$string['properties'] = 'Propiedades';
$string['propertiesdesc'] = 'Lista de propiedades.';
$string['propertiesexport'] = 'Exportar propiedades a una cadena de caracteres JSON';
$string['propertiesproperty'] = 'Propiedad';
$string['propertiesreturn'] = 'Regresar';
$string['propertiessub'] = 'Las propiedades';
$string['propertiesvalue'] = 'Valor';
$string['putpropertiesadded'] = 'Añadido:';
$string['putpropertieschanged'] = 'Cambiado:';
$string['putpropertiesdesc'] = 'Pegar la cadena de caracteres  JSON y \'Guardar cambios\'. ¡Advertencia! No valida los valores de configuración y realiza un \'Purgar todas las cachés\'.';
$string['putpropertiesfrom'] = 'de';
$string['putpropertiesignorecti'] = 'Ignorando todas las configuraciones de imagen del título del curso.';
$string['putpropertiesignored'] = 'Ignorado:';
$string['putpropertiesname'] = 'Poner propiedades - Experimental';
$string['putpropertiesreportfiles'] = 'Recuerde subir los siguientes archivos a sus configuraciones:';
$string['putpropertiessettingsreport'] = 'Reporte de configuraciones:';
$string['putpropertiesunchanged'] = 'Sin cambios:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Nuestro/a';
$string['putpropertyproperties'] = 'Propiedades';
$string['putpropertyreport'] = 'reporte:';
$string['putpropertyversion'] = 'versión:';
$string['readme_click'] = 'Haga clic aquí para README.md';
$string['readme_desc'] = 'Por favor, haga clic sobre de \'{$a->url}\' para más información acerca del tema Essential, incluyendo personalización.';
$string['readme_title'] = 'Lee-me de Essential';
$string['readmore'] = 'Leer Más';
$string['region-footer-left'] = 'Pie de página (Izquierdo)';
$string['region-footer-middle'] = 'Pie de página (Medio)';
$string['region-footer-right'] = 'Pie de página (Derecho)';
$string['region-header'] = 'Encabezado';
$string['region-hidden-dock'] = 'Oculto a los usuarios';
$string['region-home'] = 'Hogar';
$string['region-page-top'] = 'Superior de la página';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['returntosection'] = 'Regresar a: {$a->section}';
$string['returntosectionfeature'] = 'Regresar a sección';
$string['returntosectionfeaturedesc'] = 'Habilitar el regresar a característica de sección dentro de módulos del curso.';
$string['returntosectiontextlimitfeature'] = 'Límite del texto del nombre de Regresar a sección';
$string['returntosectiontextlimitfeaturedesc'] = 'Límite de longitud para el \'nombre\' de la sección en el botón entre los caracteres {$a->lower} y {$a->upper}.';
$string['right'] = 'Derecha';
$string['searchallcoursecontent'] = 'Buscar todo el contenido del curso';
$string['searchallcoursecontentdefault'] = 'Buscar por defecto todo el contenido del curso';
$string['searchallcoursecontentdefaultdesc'] = 'Configurar el valor para la casilla \'Buscar todo el contenido del curso\' en la búsqueda de contenido del curso. Si está desactivado \'Buscar todo el contenido del curso\', entonces solamente es buscado el nombre completo del curso para una coincidencia.';
$string['searchallcoursecontentenable'] = 'Habilitar búsqueda de contenido de todo el curso';
$string['searchallcoursecontentenabledesc'] = 'Permitirle al usuario decidir si desea buscar todo el contenido del curso. Si se deshabilita, entonces el valor de \'searchallcoursecontentdefault\'  será aplicado para la búsqueda del curso.';
$string['serverload'] = 'Carga del servidor';
$string['sessionsize'] = 'Tamaño de la sesión';
$string['shortname'] = 'Nombre corto del sitio';
$string['shortnamesummary'] = 'Nombre corto y resumen';
$string['siteicon'] = 'Ícono del sitio';
$string['siteicondesc'] = '¿No tiene un logo propio? Escriba el nombre del ícono que desea usar. La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que aparece después de "fa-".';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Escriba el nombre_de_usuario URI  Skype de su cuenta Skype institucional (por ejemplo skype://mi.colegio)';
$string['skypeuri'] = 'URI de cuenta Skype';
$string['slidebuttoncolor'] = 'Color del Botón de Presentación';
$string['slidebuttoncolordesc'] = 'De qué color debería de ser el botón para navegación de imagen.';
$string['slidebuttonhovercolor'] = 'Color al pasar ratón encima para el botón del desplazador de imágenes';
$string['slidebuttonhovercolordesc'] = '¿De qué color debería de ser al pasar el ratón encima el botón de navegación de imágenes';
$string['slidecaption'] = 'Subtítulo de la imagen';
$string['slidecaptionbackgroundcolor'] = 'Color del fondo de subtítulo de diapositiva';
$string['slidecaptionbackgroundcolordesc'] = 'De qué color debería de ser el fondo del subtítulo de la  diapositiva. No aplica para la opción del subtítulo de (Beside) \'A un lado\'.';
$string['slidecaptionbelow'] = 'Subtítulos debajo de la imágen';
$string['slidecaptionbelowdesc'] = 'Si los subtítulos deberían estar debajo de la imagen.';
$string['slidecaptionbeside'] = 'Además de';
$string['slidecaptioncentred'] = 'Subtítulo de la diapositiva centrado';
$string['slidecaptioncentreddesc'] = 'Si es que el subtítulo de la diapositiva debería ir centrado.';
$string['slidecaptiondesc'] = 'Escriba el texto del subtítulo a emplear para la imagen';
$string['slidecaptionontop'] = 'En parte superior';
$string['slidecaptionoptions'] = 'Opciones para subtítulos de imagen';
$string['slidecaptionoptionsdesc'] = 'En donde deberían de aparecer los subtítulos con relación a la imagen.';
$string['slidecaptiontextcolor'] = 'Color del texto de subtítulo de diapositiva';
$string['slidecaptiontextcolordesc'] = 'De qué color debería de ser el texto del subtítulo de la  diapositiva. No aplica para la opción del subtítulo de (Beside) \'A un lado\'.';
$string['slidecaptionunderneath'] = 'Debajo';
$string['slidecolor'] = 'Color del Texto de Diapositiva';
$string['slidecolordesc'] = '¿ De qué color debería de ser el texto de la Diapositiva ?';
$string['slideimage'] = 'Imagen de presentación';
$string['slideimagedesc'] = 'La imagen funciona mejor si es transparente.';
$string['slideinterval'] = 'Intervalo entre imágenes';
$string['slideintervaldesc'] = 'Intervalo de transciciónentre imágenes, en milisegundos.';
$string['slideno'] = 'Imagen {$a->slide}';
$string['slidenodesc'] = 'Escriba las configuraciones para la imagen {$a->slide}.';
$string['slideshowdesc'] = 'Esto crea un carrusel dinámico de hasta 16 imágenes, para que Usted promueva elementos importantes para su sitio. La presentación es responsiva, en donde la altura de la imagen se configura de acuerdo a la altura de la pantalla. La altura recomendada es de 300 pixeles. El ancho se configura al 100% y por lo tanto, la altura actual puede ser menor si el ancho fuera mayor que el tamaño de la pantalla. En tamaños de pantalla más pequeños, la altura se reduce dinámicamente sin necesidad de proporcionar imágenes separadas. Para referencia, los anchos de pantalla  < 767px = altura165px, anchos entre 768px y 979px = altura 225px y ancho  > 980px = altura 300px. Si no se selecciona imagen para un carrusel, entonces se usa  default_slide image de la carpeta pix.';
$string['slideshowheading'] = 'Carrusel';
$string['slideshowheadingsub'] = 'Presentación dinámica de imágenes para la Portada';
$string['slidetitle'] = 'Título de la imagen';
$string['slidetitledesc'] = 'Escriba un título descriptivo para su imagen.';
$string['slideurl'] = 'Enlace de imagen';
$string['slideurldesc'] = 'Escriba el destino para el enlace de la imagen';
$string['slideurltarget'] = 'Enlazar Destino';
$string['slideurltargetdesc'] = 'Elegir cómo debiera abrirse el enlace';
$string['slideurltargetnew'] = 'Página Nueva';
$string['slideurltargetparent'] = 'Marco Padre';
$string['slideurltargetself'] = 'Página Actual';
$string['socialdesc'] = 'Proporcionar enlaces directos hacia las redes sociales que promueven su marca/empresa/institución. Estos aparecerán en el encabezado de cada página.';
$string['socialheading'] = 'Redes sociales';
$string['socialheadingsub'] = 'Atrape a sus usuarios con Redes Sociales';
$string['socialnetworks'] = 'Redes sociales';
$string['sponsor_desc'] = 'Por favor patrocine mediante PayPal al contactarme mediante mi  \'';
$string['sponsor_desc2'] = 'para conservar andando al tema Essencial o simplemente expresar su gratitud.';
$string['sponsor_title'] = 'Patrocinar Esencial';
$string['stylecover'] = 'Cubierta';
$string['stylefixed'] = 'Fijo';
$string['styleguide'] = 'Guía de estilo';
$string['styleguidedesc'] = 'Código de documentación original \'{$a->origcodelicenseurl}\' licenciada. Holder.js está licenciada por \'{$a->holderlicenseurl}\' licensed. Código adicional \'{$a->thiscodelicenseurl}\' , la que es una licencia de tipo  \'{$a->compatible}\'. Contenido licenciado  \'{$a->contentlicenseurl}\' . La documentación ha sido formateada para salida de Moodle con íconos donde sean apropiados de FontAwesome. CSS adicional puede encontrarse en el archivo \'essential_admin_setting_styleguide.php\' debajo del comentario \'// Beyond docs.css.\'. La sección \'{$a->globalsettings}\' ha sido removida.';
$string['styleguidesub'] = 'Guía de estilo de Arranque (Botstrap) V2.3.2';
$string['stylestretch'] = 'Estirado';
$string['styletiled'] = 'Mosaico';
$string['switchrolemi'] = 'Cambiar rol';
$string['switchrolemidesc'] = 'Mostrar el ítem del menú para cambiar roles si el usuario puede cambiar roles.';
$string['tallyinoftotal'] = '{$a->rtally} en {$a->ctally} de {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} de {$a->total}';
$string['themecolor'] = 'Color del tema';
$string['themecolordesc'] = 'De qué color debería ser su tema. Esto cambiará varios componentes para producir el color que Usted desea en todo el sitio Moodle.';
$string['themecolors'] = 'Colores del Tema';
$string['themedefaultbuttonbackgroundcolour'] = 'Color del fondo del botón por defecto';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Configurar el color del fondo para todos los botones por defecto.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Color al pasar el ratón encima del fondo del botón por defecto';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Configurar el color al pasar el ratón encima del fondo de todos los botones por defecto.';
$string['themedefaultbuttontextcolour'] = 'Color del texto del botón por defecto';
$string['themedefaultbuttontextcolourdesc'] = 'Configurar el color del texto para todos los botones por defecto.';
$string['themedefaultbuttontexthovercolour'] = 'Color al pasar el ratón encima del texto del botón por defecto';
$string['themedefaultbuttontexthovercolourdesc'] = 'Configurar el color del texto al pasar el ratón encima para todos los botones por defecto.';
$string['themehovercolor'] = 'Color del tema al pasar el ratón encima';
$string['themehovercolordesc'] = 'De qué color deberá ser cuando pasa el ratón encima. Esto se usa para enlaces, menús, etc.';
$string['themeiconcolor'] = 'Color del ícono';
$string['themeiconcolordesc'] = 'Configure el color para todos los íconos';
$string['themenavcolor'] = 'Color del texto en navegación';
$string['themenavcolordesc'] = 'Configurar el color del texto para la navegación. Esto es la Barra de Navegación y el estilo elegante de la ruta de navegación.';
$string['themequizsubmitbackgroundcolour'] = 'Color del fondo para el botón del examen de  \'Enviar todo y terminar\'';
$string['themequizsubmitbackgroundcolourdesc'] = 'Configurar el color del fondo para el botón del examen de  \'Enviar todo y terminar\'.';
$string['themequizsubmitbackgroundhovercolour'] = 'Color del fondo al pasarle el ratón encima para  \'Enviar todo y terminar\'';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Configurar el color del fondo al pasarle el ratón encima para el botón del examen de  \'Enviar todo y terminar\'.';
$string['themequizsubmittextcolour'] = 'Color del texto para  \'Enviar todo y terminar\'';
$string['themequizsubmittextcolourdesc'] = 'Configurar el color del texto para el botón del examen de  \'Enviar todo y terminar\'.';
$string['themequizsubmittexthovercolour'] = 'Color del texto al pasarle el ratón encima para el botón del examen de  \'Enviar todo y terminar\'';
$string['themequizsubmittexthovercolourdesc'] = 'Configurar el color del texto al pasarle el ratón encima para el botón del examen de  \'Enviar todo y terminar\'.';
$string['themesidepreblockbackgroundcolour'] = 'Color del fondo del bloque \'lateral-pre\'';
$string['themesidepreblockbackgroundcolourdesc'] = 'Configurar el color del fondo del bloque \'lateral-pre\'';
$string['themesidepreblockhovercolour'] = 'Color del fondo al pasar el ratón encima del bloque \'lateral-pre\'';
$string['themesidepreblockhovercolourdesc'] = 'Configurar el color del fondo al pasar el ratón encima del bloque \'lateral-pre\'';
$string['themesidepreblocktextcolour'] = 'Color del texto del bloque \'lateral-pre\'';
$string['themesidepreblocktextcolourdesc'] = 'Configurar el color del texto del bloque \'lateral-pre\'';
$string['themesidepreblockurlcolour'] = 'Color del enlace del bloque \'lateral-pre\'';
$string['themesidepreblockurlcolourdesc'] = 'Configurar el color del enlace del bloque \'lateral-pre\'';
$string['themestripebackgroundcolour'] = 'Color del fondo de barra';
$string['themestripebackgroundcolourdesc'] = 'Configurar el color del fondo para barras en tablas.';
$string['themestripetextcolour'] = 'Color del texto en barra';
$string['themestripetextcolourdesc'] = 'Configurar el color del texto para barras en tablas.';
$string['themestripeurlcolour'] = 'Color de URL de barra';
$string['themestripeurlcolourdesc'] = 'Seleccionar el color de URL para barras en tablas.';
$string['themetextcolor'] = 'Color del texto';
$string['themetextcolordesc'] = 'Configure el color para su texto.';
$string['themeurlcolor'] = 'Color del enlace';
$string['themeurlcolordesc'] = 'Configure el color para su texto enlazado';
$string['thiscourse'] = 'Este curso';
$string['togglemarketing'] = 'Alternar visibilidad de Bloque Publicitario';
$string['togglemarketingdesc'] = 'Elija si quiere mostrar, o si prefiere ocultar, los 3  Bloques Publicitarios.';
$string['toggleslideshow'] = 'Alternar visualización de Presentación de imágenes';
$string['toggleslideshowdesc'] = 'Decida si desea mostrar u ocultar la presentación de imágenes';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Escriba la URL de su canal de Twitter (ejemplo: https://twitter.com/moodle, https://twitter.com/unam_mx o https://twitter.com/IPN_MX o https://twitter.com/uamx).';
$string['twitterurl'] = 'URL de Twitter';
$string['userimageborderradius'] = 'Radio del borde de la imagen del usuario';
$string['userimageborderradiusdesc'] = 'Especificar el borde del radio entre {$a->lower} y {$a->upper} pixeles de la imagen del usuario en el ssitio excepto el encabezado, el cual usa la configuración \'usermenuuserimageborderradius\'.';
$string['usermenu'] = 'Menú del usuario';
$string['usermenudesc'] = 'El menú para el usuario.';
$string['usermenuuserimageborderradius'] = 'Radio del borde de imagen del menú del usuario';
$string['usermenuuserimageborderradiusdesc'] = 'Especificar el radio del borde entre {$a->lower} y {$a->upper} pixeles de la imagen del usuario en el menú del usuario.';
$string['usersettingstitle'] = 'Configuraciones del usuario';
$string['usesiteicon'] = 'Usar ícono del sitio';
$string['usesiteicondesc'] = 'Usar el ícono del sitio si no hay logo.';
$string['variablewidth'] = 'Ancho Variable';
$string['versionalerttext1'] = 'Tema no diseñado para versión de Moodle.';
$string['versionalerttext2'] = 'Pueden ocurrir problemas inesperados; por favor, obtenga la versión correcta del tema para su versión de Moodle.';
$string['versionalerttitle'] = 'Advertencia sobre versión:';
$string['visibleadminonly'] = 'Los bloque movidos dentro del área inferior solamente serán vistos por Administradores';
$string['vk'] = 'VKontakte';
$string['vkdesc'] = 'Escriba la URL de su página de Vkontakte page. (ejemplo: http://www.vk.com/micolegio)';
$string['vkurl'] = 'URL de VKontakte';
$string['website'] = 'Página Web';
$string['websitedesc'] = 'Escriba la URL de su propio sitio web. (por ejemplo http://www.unam.mx)';
$string['websiteurl'] = 'URL  de sitio web';
$string['windows'] = 'Escritorio de Windows';
$string['windowsdesc'] = 'Proporcione una URL hacia su App para dispositivos móviles en la Tienda de Windows (\'\'Windows Store\'\'). Si Usted no tiene una App propia, considere enlazar hacia la App para móviles oficial de Moodle. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'URL de Escritorio de Windows';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Proporcione una URL hacia su App para dispositivos móviles en la \'Google Play Store\'. Si Usted no tiene una App propia, considere enlazar hacia la App para móviles oficial de Moodle. (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'URL de Windows Móvil';
$string['within'] = 'Adentro';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Escriba la URL de su canal de YouTube (por ejemplo: http://www.youtube.com/unam o http://www.youtube.com/user/CanalOnceIPN).';
$string['youtubeurl'] = 'URL de YouTube';
