<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_uikit', language 'es_mx', version '3.8'.
 *
 * @package     theme_uikit
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Aceptar';
$string['alert-background'] = 'Color de fondo';
$string['alert-border'] = 'Color de borde';
$string['alert-color'] = 'Color de texto';
$string['alert-danger-background'] = 'Color de fondo (Peligro)';
$string['alert-danger-border'] = 'Color del borde (Peligro)';
$string['alert-danger-color'] = 'Color del texto (Peligro)';
$string['alert-success-background'] = 'Color de fondo (Éxito)';
$string['alert-success-border'] = 'Color del borde (Éxito)';
$string['alert-success-color'] = 'Color del texto (Éxito)';
$string['alert-warning-background'] = 'Color de fondo (Advertencia)';
$string['alert-warning-border'] = 'Color del fondo (Advertencia)';
$string['alert-warning-color'] = 'Color del fondo (Advertencia)';
$string['allclasses'] = 'Todas las Clases';
$string['allcourses'] = 'Todos los Cursos';
$string['allmodules'] = 'Todos los Módulos';
$string['allsubjects'] = 'Todas las Asignaturas';
$string['allunits'] = 'Todas las Unidades';
$string['almost-flat'] = 'Casi plano';
$string['alwaysdisplay'] = 'Mostrar siempre';
$string['analyticsadmin'] = 'Tracking de Usuarios Administradores';
$string['analyticsadmindesc'] = 'Activar para habilitar el tracking de usuarios administradores.';
$string['analyticsclean'] = 'Enviar URLs limpias';
$string['analyticscleandesc'] = 'Esta fantástica característica fue creada por <a href="https://moodle.org/user/profile.php?id=281671" target="_blank">Gavin Henrick</a> and <a href="https://moodle.org/user/view.php?id=907814" target="_blank">Bas Brands</a> y es implementada en este tema. En lugar de enviar URLs Moodle estandar el tema enviará URLs limpias facilitando la identificación de la página y proporcionando información avanzada. Más información puede <b><a href="http://www.somerandomthoughts.com/blog/2012/04/18/ireland-uk-moodlemoot-analytics-to-the-front/" target="_blank">encontrarse aquí</a></b>.';
$string['analyticsdesc'] = 'Aquí puedes habilitar Google Analytics para tu sitio moodle. Necesitaras crear una cuenta gratuita en el sitio de Google Analytics (<a href="http://analytics.google.com" target="_blank">http://analytics.google.com</a>)';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticsheadingsub'] = 'Potentes análisis de Google';
$string['analyticsid'] = 'Tracking ID';
$string['analyticsiddesc'] = 'Introduce el Tracking ID proporcionado. Normalmente tiene el formato UA-XXXXXXXX-X';
$string['android'] = 'Androide (Google Play)';
$string['androiddesc'] = 'URL de su aplicación móvil en Google Play Store. Si usted no posee una propia, tal vez podría considerar enlazar la aplicación oficial gratuita que Moodle proporciona.';
$string['auto'] = 'Auto';
$string['auto_refresh'] = 'Auto refrescar';
$string['autohide'] = 'Incluir funcionalidad de ocultamiento automático';
$string['autohidedesc'] = 'La funcionalidad de ocultamiento automático está diseñada para hacer menos confusa la interface de la plataforma. Al estar activo el modo de edición, los iconos de modificación solo aparecerán al ubicarse sobre cada bloque.';
$string['backtotop'] = 'Volver arriba';
$string['base-body-background'] = 'Color de fondo';
$string['base-body-color'] = 'Color del texto';
$string['base-body-font-family'] = 'Tipo de letra';
$string['base-body-font-size'] = 'Tamaño de letra';
$string['base-body-gradient-inner'] = 'Color de fondo - Degradado (interior)';
$string['base-body-gradient-outer'] = 'Color de fondo - Degradado (exterior)';
$string['base-body-line-height'] = 'Altura de línea';
$string['base-heading-color'] = 'Cabeceras - Color';
$string['base-heading-font-family'] = 'Cabeceras - Tipo de letra';
$string['base-heading-font-weight'] = 'Cabeceras - Peso de la letra';
$string['base-link-color'] = 'Color de enlaces';
$string['base-link-hover-color'] = 'Color de enlaces al pasar ratón encima (hover)';
$string['base-link-hover-text-decoration'] = 'Decoración de enlaces al pasar ratón encima (hover)';
$string['base-link-text-decoration'] = 'Decoración de enlaces';
$string['base_theme'] = 'Tema base';
$string['basic'] = 'Básico';
$string['bootstrapcdn'] = 'FontAwesome de CDN';
$string['bootstrapcdndesc'] = 'Si se activa, carga el tipo de letra FontAwesome  del CDN online de Bootstrap. Activa esta opción si tienes problemas para mostrar los iconos de Font Awesome en tu sitio.';
$string['breadcrumbsplacement'] = 'Localización de la ruta de navegación';
$string['breadcrumbsplacement-mainregion'] = 'región principal';
$string['breadcrumbsplacement-pagenavbar'] = 'Barra de Navegación Superior de la página';
$string['button-active-background'] = 'Normal - Fondo (activo)';
$string['button-active-color'] = 'Normal - Texto (activo)';
$string['button-background'] = 'Normal - Fondo';
$string['button-border'] = 'Color de borde';
$string['button-border-bottom'] = 'Color de borde (inferior)';
$string['button-color'] = 'Normal - Texto';
$string['button-contrast-hover-border'] = 'Color de borde (contraste)';
$string['button-contrast-text-shadow'] = 'Sombra del texto (contraste)';
$string['button-danger-active-background'] = 'Peligro - Fondo (activo)';
$string['button-danger-active-color'] = 'Peligro - Texto (activo)';
$string['button-danger-background'] = 'Peligro - Fondo';
$string['button-danger-color'] = 'Peligro - Texto';
$string['button-danger-gradient-bottom'] = 'Peligro - Degradado (inferior)';
$string['button-danger-gradient-top'] = 'Peligro - Degradado (superior)';
$string['button-danger-hover-background'] = 'Peligro - Fondo al pasar ratón encima  (hover)';
$string['button-danger-hover-color'] = 'Peligro - Texto (hover)';
$string['button-disabled-background'] = 'Desactivado - Fondo';
$string['button-disabled-color'] = 'Desactivado - Texto';
$string['button-gradient-bottom'] = 'Normal - Degradado (inferior)';
$string['button-gradient-top'] = 'Normal - Degradado (superior)';
$string['button-height'] = 'Altura del botón';
$string['button-hover-background'] = 'Normal - Fondo (hover)';
$string['button-hover-border'] = 'Color de borde (hover)';
$string['button-hover-color'] = 'Normal - Texto (hover)';
$string['button-primary-active-background'] = 'Primario - Fondo (activo)';
$string['button-primary-active-color'] = 'Primario - Texto (activo)';
$string['button-primary-background'] = 'Primario - Fondo';
$string['button-primary-color'] = 'Primario - Texto';
$string['button-primary-gradient-bottom'] = 'Primario - Degradado (inferior)';
$string['button-primary-gradient-top'] = 'Primario - Degradado (superior)';
$string['button-primary-hover-background'] = 'Primario - Fondo al pasar ratón encima (hover)';
$string['button-primary-hover-color'] = 'Primario - Texto al pasar ratónencima (hover)';
$string['button-small-height'] = 'Altura del botón (pequeño)';
$string['button-success-active-background'] = 'Éxito - Fondo (activo)';
$string['button-success-active-color'] = 'Éxito - Texto (activo)';
$string['button-success-background'] = 'Éxito - Fondo';
$string['button-success-color'] = 'Éxito - Texto';
$string['button-success-gradient-bottom'] = 'Éxito - Degradado (inferior)';
$string['button-success-gradient-top'] = 'Éxito - Degradado (superior)';
$string['button-success-hover-background'] = 'Éxito - Fondo (hover)';
$string['button-success-hover-color'] = 'Éxito - Texto (hover)';
$string['button-text-shadow'] = 'Sombra del texto';
$string['cancel'] = 'Cancelar';
$string['choosereadme'] = 'Tema construido con UIKit. Incluye un gestor de estilos visual avanzado';
$string['combolistshowonlyenrrolled'] = 'Mostrar solamente cursos inscritos en la lista combo';
$string['combolistshowonlyenrrolleddesc'] = 'Si está activado, al utilizar una lista combo en la pagina principal, solamente se mostrarán las categorías y cursos en los que el usuario esté inscrito.';
$string['componentclass-danger'] = 'Peligro';
$string['componentclass-link'] = 'Enlace';
$string['componentclass-normal'] = 'Normal';
$string['componentclass-primary'] = 'Primario';
$string['componentclass-success'] = 'Éxito';
$string['componentplacement-bottom'] = 'Fondo';
$string['componentplacement-center'] = 'Centro';
$string['componentplacement-left'] = 'Izquierda';
$string['componentplacement-right'] = 'Derecha';
$string['componentplacement-top'] = 'Superior';
$string['configtitle'] = 'UIKit';
$string['contactinfo'] = 'Información de contacto';
$string['contactinfodesc'] = 'Introduzca su información de contacto';
$string['continue_refreshing'] = '¿Continuar refrescando?';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'El nombre de su organización.';
$string['courselist'] = 'Mostrar lista simple de cursos';
$string['custom_less'] = 'Utilizar tu propio código CSS/LESS';
$string['custom_less_default'] = 'Tu código CSS o LESS aquí...
    Será añadido al final de la hoja de estilos';
$string['custommenudesc'] = 'Estos ajustes afectan al menú personalizado (menú desplegable)';
$string['custommenuheading'] = 'Menú Personalizado';
$string['custommenuheadingsub'] = 'Añadir funcionalidad personalizada a tu menú.';
$string['displayafterlogin'] = 'Mostrar despúes de ingresar sólamente';
$string['displaybeforelogin'] = 'Mostrar antes de ingresar sólamente';
$string['displayloggedusermode'] = 'Modo de visualización de usuario ingresado';
$string['displayloggedusermodecomplete'] = 'Información completa';
$string['displayloggedusermodedesc'] = 'Esta configuración define como se muestra el usuario ingresado en el Menú Personalizado';
$string['displayloggedusermodehide'] = 'Ocultar';
$string['displayloggedusermodeonlylogout'] = 'Solamente salida';
$string['displayloggedusermodeshort'] = 'Información breve';
$string['displaymycourses'] = 'Mostrar cursos inscritos';
$string['displaymycoursesdesc'] = 'Muestra una lista de cursos inscritos de usuario en el menú.';
$string['displaymycoursesmode'] = 'Modo de mostrar los cursos inscritos';
$string['displaymycoursesmodedesc'] = 'Esta opción define la manera en la que se listan los cursos inscritos en el menú';
$string['displaymydashboard'] = 'Mostrar Mi panel de control';
$string['displaymydashboarddesc'] = 'Mostrar el panel de control con enlaces de usuario en el menú';
$string['displaysitename'] = 'Mostrar nombre del sitio';
$string['dontdisplay'] = 'Nunca mostrar';
$string['dropdown-background'] = 'Color del Fondo del Desplegable';
$string['dropdown-navbar-background'] = 'Menú desplegable - Fondo';
$string['export_less'] = 'Exportar LESS';
$string['export_less_tooltip'] = 'Exportar personalizaciones de estilo en un archivo LESS';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Introduzca el URL de su página en Facebook. (ej. http://www.facebook.com/micolegio)';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Por favor suba aquí su favicon personalizado si quiere añadirlo a la página';
$string['flickr'] = 'Flickr URL';
$string['flickrdesc'] = 'Introduzca el URL de su página en Flickr. (ej. http://www.flickr.com/micolegio)';
$string['footerbackground'] = 'Imagen de fondo de pie de página';
$string['footerbackgrounddesc'] = 'Sube tu propia imagen de fondo para el pie de página. Será repetida en el fondo del pie de página de todas las páginas.';
$string['footerblocks'] = 'Activar bloques del pie de página';
$string['footerblocksdesc'] = 'Si se activa muestra 3 lugares adicionales donde colocar bloques en el pie de página';
$string['footerimage'] = 'Imagen del Pie';
$string['footerimagedesc'] = 'Por favor suba su imagen personalizada aquí si quiere añadirla al pie de página. <br>Si sube una imagen aparecerá encima del HTML personalizado del pie (si lo hay).';
$string['footerplacement'] = 'Posición del pie de página';
$string['footerplacementaftermaincontent'] = 'Después del contenido principal de la página';
$string['footerplacementpageend'] = 'Al final de la página';
$string['footnote'] = 'Nota al pie de página';
$string['footnotedesc'] = 'Cualquier texto que agregue en este campo se mostará en el pie de página de todo su sitio Moodle';
$string['frontcontentarea'] = 'Contenido personalizado';
$string['frontcontentareadesc'] = 'Lo que se escriba aquí aparecerá  a todo lo ancho de la página entre el carrusel de imágenes y los bloques publicitariosal principio de la caja principal de la página inicial';
$string['frontcontentdesc'] = 'Añade un área de contenido personalizado al principio de la caja principal de la página inicial';
$string['frontcontentheading'] = 'Ajustes de la Página Inicial';
$string['frontcontentheadingsub'] = 'Cambia qué características activar en la página inicial';
$string['frontpageblocks'] = 'Alineación de los bloques de la página principal';
$string['frontpageblocksdesc'] = 'Aquí puede determinar si los bloques de la página principal aparecen en la parte izquierda o derecha de la página';
$string['frontpagemiddleblocks'] = 'Activar bloques centrales';
$string['frontpagemiddleblocksdesc'] = 'Si se activa muestra 3 lugares adicionales donde colocar bloques debajo del contenido personalizado y otros 2 lugares adicionales de ancho completo encima y debajo de los 3 bloques';
$string['fullhierarchy'] = 'Mostrar los cursos con jerarquía completa de categorías';
$string['geneicsettings'] = 'Ajustes generales';
$string['global-border'] = 'Color de bordes';
$string['global-border-radius'] = 'Radio de bordes';
$string['global-contrast-color'] = 'Color de texto de contraste';
$string['global-danger-background'] = 'Fondo peligro';
$string['global-danger-gradient-bottom'] = 'Fondo peligro - Degradado (inferior)';
$string['global-danger-gradient-top'] = 'Fondo peligro - Degradado (superior)';
$string['global-muted-color'] = 'Color del texto atenuado';
$string['global-primary-background'] = 'Fondo primario';
$string['global-primary-gradient-bottom'] = 'Fondo primario - Degradado (inferior)';
$string['global-primary-gradient-top'] = 'Fondo primario - Degradado (superior)';
$string['global-success-background'] = 'Fondo éxito';
$string['global-success-gradient-bottom'] = 'Fondo éxito - Degradado (inferior)';
$string['global-success-gradient-top'] = 'Fondo éxito - Degradado (superior)';
$string['googlefontname'] = 'Tipo de letra número {$a->number}';
$string['googlefontsheading'] = 'Google Fonts';
$string['googlefontsheadingsub'] = 'Aquí puedes añadir hasta 10 tipos de letra de Google Fonts que estarán disponibles en todas las páginas de Moodle';
$string['googlefontsnofont'] = '--Ningún tipo de letra--';
$string['googleplus'] = 'URL de Google+';
$string['googleplusdesc'] = 'Introduzca el URL de su perfil en Google+. (ej. http://plus.google.com/107817105228930159735)';
$string['gradient'] = 'Degradado';
$string['group-alerts'] = 'Alertas';
$string['group-breadcrumbs'] = 'Ruta de navegación';
$string['group-buttons'] = 'Botones';
$string['group-global'] = 'Global';
$string['group-layout'] = 'Disposición';
$string['group-login-page'] = 'Página de Acceso';
$string['group-main-region'] = 'Contenido Principal';
$string['group-mdl-blocks'] = 'Bloques';
$string['group-navbar'] = 'Navegación (diseño en Cuadrícula)';
$string['group-navbar-layout2'] = 'Navegación (diseño Flex)';
$string['group-other'] = 'Otros';
$string['group-to-top-button'] = 'Botón volver arriba';
$string['group-typography'] = 'Tipografía';
$string['headerbackground'] = 'Imagen de fondo de cabecera';
$string['headerbackgrounddesc'] = 'Sube tu propia imagen de fondo para la cabecera. Será repetida en el fondo de la cabecera de todas las páginas.';
$string['headerprofilepic'] = 'Mostrar fotografía del usuario';
$string['headerprofilepicdesc'] = 'Si se selecciona, se mostrará la fotografía del perfil del usuario en el encabezado del sitio.';
$string['hideonphone'] = 'Oculto para Móviles';
$string['hideonphonedesc'] = 'Escoja si desea mostrar el carrusel en móviles';
$string['import_less'] = 'Importar LESS';
$string['import_less_tooltip'] = 'Importar personalizaciones de estilo de un archivo LESS';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Introduzca el URL de su página en Instagram. (ej. http://instagram.com/micolegio)';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'URL de su aplicación móvil en App Store. Si usted no posee una propia, tal vez podría considerar enlazar la aplicación oficial gratuita que Moodle proporciona.';
$string['iosicon'] = 'Iconos para iOS';
$string['iosicondesc'] = 'El tema proporciona un icono por defecto para los menús principales de iOS, Androide y Windows. Usted puede subir sus íconos personalizados si lo desea.';
$string['ipadicon'] = 'Ïcono de iPad (No Retina)';
$string['ipadicondesc'] = 'El icono debería ser una imagen .PNG de 72px por 72px';
$string['ipadretinaicon'] = 'Ícono de iPad (Retina)';
$string['ipadretinaicondesc'] = 'El icono debería ser una imagen .PNG de 144px por 144px';
$string['iphoneicon'] = 'Ícono de iPhone/iPod Touch (No Retina)';
$string['iphoneicondesc'] = 'El icono debería ser una imagen .PNG de 57px por 57px';
$string['iphoneretinaicon'] = 'Ícono de iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'El icono debería ser una imagen .PNG de 114px por 114px';
$string['js-compile-error'] = 'Ocurrió un error al construir los estilos';
$string['js-externalpage-disallowed'] = 'No se permite ir a una página externa';
$string['js-font-family-placeholder'] = 'Escribe el tipo o tipos de letra deseados';
$string['js-home'] = 'Hogar';
$string['js-less-error-help'] = 'Por favor intente limpiar su caché del navegador y asegúrese de que su CSS/LESS sea correcto';
$string['js-ok'] = 'Ok';
$string['js-reset-all-confirm'] = '¿Reiniciar TODAS las variables a valores por defecto?';
$string['js-reset-group'] = 'Reiniciar valores del grupo';
$string['js-reset-group-confirm'] = '¿Reiniciar valores del grupo <i>{0}</i>?';
$string['js-reset-var-confirm'] = '¿Reiniciar <i>{0}</i>?';
$string['js-styles-saved'] = '¡Estilos guardados con éxito!';
$string['js-styles-saved-error'] = 'Ocurrió un error al guardar los estilos';
$string['keep_variables'] = 'Mantener los valores de las variables en la medida de lo posible';
$string['layoutheading'] = 'Opciones del diseño';
$string['left'] = 'Izquierda';
$string['linkedin'] = 'URL de LinkedIn';
$string['linkedindesc'] = 'Introduzca el URL de su perfil en LinkedIn. (ej. http://www.linkedin.com/company/micolegio)';
$string['loginheaderimage'] = 'Imagen de la cabecera de la caja de login';
$string['loginheaderimagedesc'] = 'Si se sube una imagen, reemplazará la cabecera de la caja de ingreso';
$string['loginpagehasfooter'] = 'Mostrar Pie de Página';
$string['loginpagehasheader'] = 'Mostrar Cabecera';
$string['loginpagehasnavigation'] = 'Mostrar Navegación';
$string['loginpageheading'] = 'Ajustes de la página de Ingreso';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'Por favor suba su logotipo personalizado aquí si quiere agregarlo a la cabecera de la página.<br>Si usted sube un logotipo, éste reemplazará el ícono y texto mostrado por defecto.';
$string['logoshowsummary'] = 'Mostrar resumen del sitio debajo del logo';
$string['logout'] = 'Salir';
$string['marketing1'] = 'Bloque Publicitario Uno';
$string['marketing2'] = 'Bloque Publicitario Dos';
$string['marketing3'] = 'Bloque Publicitario Tres';
$string['marketingbuttontext'] = 'Texto del enlace';
$string['marketingbuttontextdesc'] = 'Texto que aparecerá en el botón.';
$string['marketingbuttonurl'] = 'URL del enlace';
$string['marketingbuttonurldesc'] = 'URL al que apunta el botón.';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido a mostrar en el spot publicitario. Manténgalo corto y genial.';
$string['marketingdesc'] = 'Este tema ofrece la opción de habilitar tres "bloques publicitarios" justo debajo del carrusel de diapositivas. Estos le permitirán identificar fácilmente información importante para sus usuarios y proveer enlaces directos.';
$string['marketingheading'] = 'Bloques Publicitarios';
$string['marketingheadingsub'] = 'Bloques en la página principal diseñados para agregar información y enlaces';
$string['marketingicon'] = 'Ícono';
$string['marketingicondesc'] = 'Nombre del ícono que desea usar. La lista de íconos disponibles esta <a href="http://www.getuikit.com/docs/icon.html" target="_new">aquí</a>. Solo coloque lo que esta justo después de "icon-".';
$string['marketingimage'] = 'Imagen';
$string['marketingimagedesc'] = 'Este tema ofrece la opción de desplegar una imagen sobre el texto en el bloque publicitario';
$string['marketinginfodesc'] = 'Introduce los ajustes de tu bloque publicitario.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a mostrar en el bloque publicitario';
$string['mdl-block-header-font-family'] = 'Cabecera - Tipo de letra';
$string['mdl-block-header-font-size'] = 'Cabecera - Tamaño de letra';
$string['mdl-block-header-font-weight'] = 'Cabecera - Peso de la letra';
$string['mdl-block-header-icon-color'] = 'Cabecera - Color del icono';
$string['mdl-block-header-text-color'] = 'Cabecera - Color del texto';
$string['mdl-block-icon-color'] = 'Elementos - Color del icono';
$string['mdl-block-link-color'] = 'Elementos - Enlaces';
$string['mdl-block-link-color-hover'] = 'Elementos - Enlaces al pasar ratón encima (hover)';
$string['mdl-block-menu-item-font-family'] = 'Elementos - Tipo de letra';
$string['mdl-block-menu-item-font-size'] = 'Elementos - Tamaño de letra';
$string['mdl-block-menu-item-font-weight'] = 'Elementos - Peso de la letra';
$string['mdl-block-text-color'] = 'Elementos - Color del texto';
$string['mdl-breadcrumb-link-color'] = 'Color de enlaces';
$string['mdl-breadcrumb-link-hover-color'] = 'Color de enlaces al pasar ratón encima (hover)';
$string['mdl-layout2-left-width'] = 'Diseño Flex - Ancho de columna izquierda';
$string['mdl-login-box-background'] = 'Caja de acceso - Fondo';
$string['mdl-login-box-border'] = 'Caja de acceso - Borde';
$string['mdl-login-box-width'] = 'Caja de acceso - Ancho';
$string['mdl-main-region-background'] = 'Color de fondo';
$string['mdl-main-region-border'] = 'Color de borde';
$string['mdl-main-region-padding'] = 'Relleno';
$string['mdl-max-additional-frontpage-content-width'] = 'Sección de publicidad de la página principal - Ancho máximo';
$string['mdl-max-page-content-width'] = 'Contenido de Página - Ancho máximo';
$string['mdl-max-page-footer-width'] = 'Pie de página - Ancho máximo';
$string['mdl-max-page-header-content-width'] = 'Cabecera - Ancho máximo';
$string['mdl-max-page-navbar-content-width'] = 'Navegación - Ancho máximo';
$string['mdl-navbar-side-margin'] = 'Margen lateral';
$string['mdl-page-breadcrumbs-background'] = 'Color del Fondo (región principal)';
$string['mdl-page-breadcrumbs-border'] = 'Color dl Borde (región principal)';
$string['mdl-page-footer-background'] = 'Pie de Página  - Color del Fondo';
$string['mdl-page-footer-background-gradient-bottom'] = 'Pie de Página  - Gradiente del Fondo';
$string['mdl-page-footer-background-gradient-top'] = 'Pie de Página  - Gradiente  Superior';
$string['mdl-page-header-background'] = 'Encabezado de la Página  - Color del Fondo';
$string['mdl-page-header-background-gradient-bottom'] = 'ado de la Página  - Gradiente del Fondo';
$string['mdl-page-header-background-gradient-top'] = 'ado de la Página  - Gradiente Superior';
$string['mdl-page-header-content-padding'] = 'Cabecera - Relleno';
$string['mdl-page-navbar-background'] = 'Color del Fondo (región superior)';
$string['mdl-page-navbar-border'] = 'Color del Borde (región superior)';
$string['mdl-page-side-margin'] = 'Contenido de Página - Márgen lateral';
$string['mdl-page-top-margin'] = 'Contenido de Página - Márgen superior';
$string['mdl-social-heading-color'] = 'Social - Color de título';
$string['mdl-to-top-background'] = 'Fondo';
$string['mdl-to-top-background-hover'] = 'Fondo al pasar ratón encima (hover)';
$string['mdl-to-top-color'] = 'Color del icono';
$string['mdl-to-top-color-hover'] = 'Color del icono al pasar ratón encima (hover)';
$string['mdl-to-top-shadow-background'] = 'Sombra';
$string['mdl-to-top-shadow-background-hover'] = 'Sombra al pasar ratón encima (hover)';
$string['mobileappsdesc'] = '¿Posee una aplicación registrada en App Store o Google Play Store? Ofrezca aquí un enlace para que sus usuarios puedan aprovecharla';
$string['mobileappsheading'] = 'Aplicaciones móviles';
$string['mobileappsheadingsub'] = 'Ofrezca enlaces a sus aplicaciones móviles para sus usuarios';
$string['myclasses'] = 'Mis Clases';
$string['mycourses'] = 'Mis Cursos';
$string['mycoursesinfo'] = 'Lista dinámica de cursos inscritos';
$string['mycoursesinfodesc'] = 'Muestra una lista de cursos inscritos por el usuario.';
$string['mycoursetitle'] = 'Teminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología del elemento "Mis Cursos" en el menú desplegable';
$string['mydashboard'] = 'Mi panel de control';
$string['mydashboardinfo'] = 'Mi panel de control personalizado';
$string['mydashboardinfodesc'] = 'Muestra una lista de funciones comunes utilizadas por los usuarios.';
$string['mymodules'] = 'Mis Módulos';
$string['mysubjects'] = 'Mis Asignaturas';
$string['myunits'] = 'Mis Unidades';
$string['nav-dropdown-color'] = 'Color del Texto del Desplegable';
$string['nav-dropdown-hover-background'] = 'Color del Fondo del Desplegable al pasar el ratón encima';
$string['nav-dropdown-hover-color'] = 'Color del Texto del Desplegable al pasar el ratón encima';
$string['nav-dropdown-nested-color'] = 'Enlace Anidado del Desplegable';
$string['nav-dropdown-nested-hover-color'] = 'Enlace Anidado del Desplegable al pasar el ratón encima';
$string['nav-navbar-color'] = 'Menú desplegable - Texto';
$string['nav-navbar-hover-background'] = 'Menú desplegable - Fondo al pasar ratón encima (hover)';
$string['nav-navbar-hover-color'] = 'Menú desplegable - Texto al pasar ratón encima (hover)';
$string['nav-navbar-nested-color'] = 'Menú desplegable - Enlaces anidados';
$string['nav-navbar-nested-hover-color'] = 'Menú desplegable - Enlaces anidados al pasar ratón encima (hover)';
$string['navbar-background'] = 'Color de fondo';
$string['navbar-border'] = 'Borde';
$string['navbar-border-bottom'] = 'Borde (inferior)';
$string['navbar-brand-color'] = 'Brand - Color del texto';
$string['navbar-brand-hover-color'] = 'Brand - Color del texto al pasar ratón encima  (hover)';
$string['navbar-color'] = 'Color del texto';
$string['navbar-gradient-bottom'] = 'Color de fondo - Degradado inferior';
$string['navbar-gradient-top'] = 'Color de fondo - Degradado superior';
$string['navbar-link-color'] = 'Color de enlaces';
$string['navbar-link-hover-color'] = 'Color de enlaces al pasar ratón encima (hover)';
$string['navbar-nav-active-background'] = 'Elementos - Fondo (activo)';
$string['navbar-nav-active-color'] = 'Elementos - Texto (activo)';
$string['navbar-nav-color'] = 'Elementos - Color';
$string['navbar-nav-font-family'] = 'Elementos - Tipo de letra';
$string['navbar-nav-font-size'] = 'Elementos - Tamaño de letra';
$string['navbar-nav-font-weight'] = 'Elementos - Peso de la letra';
$string['navbar-nav-hover-background'] = 'Elementos - Fondo al pasar ratón encima  (hover)';
$string['navbar-nav-hover-color'] = 'Elementos - Color al pasar ratón encima (hover)';
$string['navbar-nav-onclick-background'] = 'Elementos - Fondo (click)';
$string['navbar-nav-onclick-color'] = 'Elementos - Texto (click)';
$string['navbar-text-shadow'] = 'Sombra';
$string['navbar-toggle-color'] = 'Botón menú lateral - Color';
$string['navbar-toggle-hover-color'] = 'Botón menú lateral - Color al pasar ratón encima (hover)';
$string['navigationbuttonsclass'] = 'Clase de botones de Navegación';
$string['navigationbuttonsclass-danger'] = 'Peligro';
$string['navigationbuttonsclass-link'] = 'Enlace';
$string['navigationbuttonsclass-normal'] = 'Normal';
$string['navigationbuttonsclass-primary'] = 'Primario';
$string['navigationbuttonsclass-success'] = 'Éxito';
$string['navigationbuttonssize'] = 'Tamaño de botones de navegación';
$string['navigationbuttonssize-large'] = 'Grande';
$string['navigationbuttonssize-mini'] = 'Mini';
$string['navigationbuttonssize-normal'] = 'Normal';
$string['navigationbuttonssize-small'] = 'Pequeño';
$string['navigationtoggletext'] = 'Navegación';
$string['nextsection'] = 'Siguiente Sección';
$string['noenrolments'] = 'No estás inscrito actualmente';
$string['onlytoplevelhierarchy'] = 'Mostrar listas de cursos bajo su categoría de mayor nivel';
$string['page_description'] = 'Esta página permite personalizar el estilo y comportamiento de su sitio.';
$string['page_description_sub'] = 'Puede configurar el logo, favicon y otras muchas opciones aquí.';
$string['pagebackground'] = 'Imagen de fondo de página';
$string['pagebackgrounddesc'] = 'Suba su propia imagen de fondo para la página. Será repetida en el fondo de todas las páginas.';
$string['pagenavbarcontent'] = 'Contenido de Barar de Navegación superior de la página';
$string['pagenavbarcontent-custom'] = 'Personalizado';
$string['pagenavbarcontent-dontshow'] = 'No mostrar';
$string['pagenavbarcontent-pageheading'] = 'Encabezado de página';
$string['pagenavbarcontent-pagetitle'] = 'Título de pagina';
$string['pagenavbarcontent-sitename'] = 'Nombre del sitio';
$string['pagenavbarcontent-siteshortname'] = 'Nombre corto del sitio';
$string['pagenavbarcontent-sitessummary'] = 'Resumen del sitio';
$string['pagenavbarcustomcontent'] = 'Contenido personalizado de Barra de Navegación superior de la página';
$string['panel'] = 'Panel';
$string['panel-box-background'] = 'Color de fondo';
$string['panel-box-border'] = 'Borde';
$string['panel-box-color'] = 'Color del texto';
$string['panel-box-padding'] = 'Relleno';
$string['panel-header-title-border'] = 'Cabecera - Color del separador';
$string['panel-header-title-padding'] = 'Cabecera - Relleno de separación';
$string['pinterest'] = 'URL de Pinterest';
$string['pinterestdesc'] = 'Introduzca el URL de su página en Pinterest. (ej. http://pinterest.com/micolegio)';
$string['pluginname'] = 'UIKit';
$string['previoussection'] = 'Sección Anterior';
$string['readmore'] = 'Leer más';
$string['refresh'] = 'Refrescar';
$string['region-footer-left'] = 'Pie de página (Izquierda)';
$string['region-footer-middle'] = 'Pie de página (Centro)';
$string['region-footer-right'] = 'Pie de página (Derecha)';
$string['region-hidden-dock'] = 'Oculto para los usuarios';
$string['region-home-down'] = 'Página Principal (Abajo)';
$string['region-home-left'] = 'Página Principal (Izquierda)';
$string['region-home-middle'] = 'Página Principal (Centro)';
$string['region-home-right'] = 'Página Principal (Derecha)';
$string['region-home-up'] = 'Página Principal (Arriba)';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['reset'] = 'Reiniciar';
$string['reset_all'] = 'Reiniciar todo';
$string['right'] = 'Derecha';
$string['save_styles'] = 'Guardar y utilizar estilos';
$string['save_styles_tooltip'] = 'Guarda y utiliza los estilos actualmes para el sitio real';
$string['showmoodledocs'] = 'Mostrar la sección de "Moodle Docs para esta página" al pie de página';
$string['siteicon'] = 'Ícono del sitio';
$string['siteicondesc'] = '¿No tiene un logotipo? Coloque el nombre del icono que desea utilizar. La lista está <a href="http://www.getuikit.com/docs/icon.html" target="_blank">aquí</a>. Sólo coloque lo que está después de "uk-icon-".';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Introduzca el nombre_de_usuario de Skype utilizado por su organización.';
$string['slidecaption'] = 'Subtítulo de la Diapositiva';
$string['slidecaptionplacement'] = 'Posicionamiento de subtítulo de la imagen';
$string['slideheader'] = 'Diapositiva {$a->n}';
$string['slideimage'] = 'Imagen de presentación';
$string['slideshowanimation'] = 'Animación del carrusel';
$string['slideshowanimation-boxes'] = 'Cajas';
$string['slideshowanimation-boxes-reverse'] = 'Reverso de cajas';
$string['slideshowanimation-fade'] = 'Atenuar';
$string['slideshowanimation-fold'] = 'Doblar';
$string['slideshowanimation-puzzle'] = 'Acerijo';
$string['slideshowanimation-random-fx'] = 'Efecto aleatorio';
$string['slideshowanimation-scale'] = 'Escalar';
$string['slideshowanimation-scroll'] = 'Deslizar';
$string['slideshowanimation-slice-down'] = 'Bajar';
$string['slideshowanimation-slice-up'] = 'Subir';
$string['slideshowanimation-slice-up-down'] = 'Subir y Bajar';
$string['slideshowanimation-swipe'] = 'Desplazar';
$string['slideshowarrowscolor'] = 'Color de Flechas de Navegación';
$string['slideshowautoplay'] = 'Habilitar autoinicio';
$string['slideshowbuttontype'] = 'Tipo del Botón de Imagen';
$string['slideshowcaptioncolor'] = 'Color del subtítulos de las diapositivas';
$string['slideshowdesc'] = 'Esto genera un carrusel de hasta 4 diapositivas que le permiten promover elementos importantes de su sitio.';
$string['slideshowheading'] = 'Diapositivas de Página Inicial';
$string['slideshowheadingsub'] = 'Diapositivas Dinámicas para la Página Inicial';
$string['slideshowheight'] = 'Altura del carrusel';
$string['slideshowkenburns'] = 'Habilitar efecto de Ken Burns';
$string['slideshownumber'] = 'Número de diapositivas';
$string['slideshowsizingmode'] = 'Modo del tamaño de imagen';
$string['slideshowsizingmode-fullheight'] = 'Usar altura completa';
$string['slideshowsizingmode-fullwidth'] = 'Usar ancho completo';
$string['slideshowtitlecolor'] = 'Color del título de las diapositivas';
$string['slidetitle'] = 'Título de la Diapositiva';
$string['slideurl'] = 'Enlace del botón de la diapositiva';
$string['slideurltext'] = 'Texto del botón de la diapositiva';
$string['socialdesc'] = 'Provea enlaces directos a las principales redes sociales que usa para promover su marca. Esta sección aparecerá en la cabecera de todas las páginas.';
$string['socialheading'] = 'Redes Sociales';
$string['socialheadingsub'] = 'Enlace a sus usuarios con sus Redes Sociales';
$string['socialnetworks'] = 'Redes Sociales';
$string['stickynavigationbar'] = 'Habilitar Barra de Navegación pegajosa';
$string['stickynavigationbardelay'] = 'Retraso (pixeles) de Barra de Navegación pegajosa';
$string['stickynavigationbardelaydesc'] = 'Añadir un retraso a la Barra de Navegación, para que se vuelva pegajosa después de desplazarse una cierta distancia en pixeles';
$string['stickynavigationbardesc'] = 'Hacer que la Barra de Navagación permanezaca en la parte superior de la vista';
$string['styleswritepermissionsfail'] = 'Error: No se pudo escribir en el directorio theme/uikit/styles. Por favor comprueba que tu servidor web tiene permisos de escritura en este directorio';
$string['themedesignerenabled'] = 'El modo de diseño de temas ha sido activado';
$string['themelayout'] = 'Modo de Diseño';
$string['themelayout1'] = 'Diseño de Rejilla';
$string['themelayout2'] = 'Diseño Flex';
$string['themelayoutdesc'] = 'Aquí puede Usted elegir entre diferentes modos de diseño para este tema';
$string['themenavigationelementsmode'] = 'Modo de visualización de los ítems del menú personalizado Ulkit';
$string['themenavigationelementsmodeafter'] = 'Ítems del menú personalizado después del sitio';
$string['themenavigationelementsmodebefore'] = 'Ítems del menú personalizado antes del sitio';
$string['togglemarketing'] = 'Intercambiar Pantalla de Mensaje Publicitario';
$string['togglemarketingdesc'] = 'Escoja si desea mostrar o esconder los tres Mensajes Publicitarios.';
$string['toggleslideshow'] = 'Mostrar/Ocultar diapositivas';
$string['toggleslideshowdesc'] = 'Elige si quieres ocultar o mostrar las diapositivas.';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Introduzca el URL de su cuenta de Twitter. (ej. http://www.twitter.com/micolegio)';
$string['uikit_not_selected'] = 'El tema UIKit no está seleccionado actualmente.';
$string['uikit_select_link'] = 'Por favor selecciónalo aquí';
$string['useanalytics'] = 'Habilitar Google Analytics';
$string['useanalyticsdesc'] = 'Habilitar o deshabilitar Google Analytics.';
$string['usefrontcontent'] = 'Activar contenido personalizado';
$string['usefrontcontentdesc'] = 'Si se activa, mostrará el contenido personalizado al principio de la caja principal de la página inicial.';
$string['visibleadminonly'] = 'Los bloques colocados en esta área serán vistos únicamente por los administradores';
$string['visualstylemanager'] = 'Gestor visual de estilos para UIKit';
$string['vk'] = 'URL de VKontakte';
$string['vkdesc'] = 'Introduzca el URL de su página en Vkontakte. (ej. http://www.vk.com/mycollege)';
$string['warning_saved_styles_different_theme_version'] = 'Alparecer Usted guardó estilos personalziados para este sitio con una versión antigua del tema UIKit';
$string['warning_saved_styles_different_theme_version_action'] = 'Por favor actualice los estilos del sitio al ir al personalizador y hacer click en guardar. Limpie el caché de su navegador para asegurar un comportamiento correcto';
$string['warning_theme_designer_disable'] = 'Lo puede desactivar aquí';
$string['warning_theme_designer_enabled'] = 'El modo de diseño de temas ha sido activado automáticamente. Asegúrate de desactivarlo para mejorar el rendimiento cuando haya acabado de personalizar los estilos.';
$string['warning_variables_changed'] = 'Está a punto de cambiar el tema base y algunas variables tiene valores diferentes a los iniciales.';
$string['website'] = 'URL de su sitio web';
$string['websitedesc'] = 'Introduzca el URL de su sitio web institucional. (ej. http://www.unam.mx)';
$string['youtube'] = 'URL de YouTube';
$string['youtubedesc'] = 'Introduzca el URL de su canal en YouTube. (ej. http://www.youtube.com/micolegio)';
