<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'sr_cr', version '3.8'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Све подређене компетенције су завршене';
$string['competencies'] = 'Компетенције';
$string['competenciesarenotenabled'] = 'Компетенције нису омогућене.';
$string['competenciessettings'] = 'Подешавања компетенција';
$string['completeplanstask'] = 'Заврши планове учења којима се приближава рок';
$string['coursecompetencyoutcome_complete'] = 'Заврши компетенцију';
$string['coursecompetencyoutcome_evidence'] = 'Приложи доказ';
$string['coursecompetencyoutcome_none'] = 'Не ради ништа';
$string['coursecompetencyoutcome_recommend'] = 'Пошаљи на преглед';
$string['coursemodulecompetencyoutcome_complete'] = 'Заврши компетeнцију';
$string['coursemodulecompetencyoutcome_evidence'] = 'Приложи доказ';
$string['coursemodulecompetencyoutcome_none'] = 'Не ради ништа';
$string['coursemodulecompetencyoutcome_recommend'] = 'Пошаљи на преглед';
$string['deletecompetencyratings'] = 'Обриши процене компетенције';
$string['duplicateditemname'] = '{$a} (копија)';
$string['enablecompetencies'] = 'Омогући компетенције';
$string['enablecompetencies_desc'] = 'Компетенције дозвољавају оцењивање корисника према плановима учења.';
$string['errorcannotchangeapastduedate'] = 'Крајњи рок је истекао; не може се мењати.';
$string['errorcannotsetduedateinthepast'] = 'Крајњи рок није могуће поставити у прошлости.';
$string['errorcannotsetduedatetoosoon'] = 'Крајњи рок ускоро истиче.';
$string['errorcompetencyrule'] = 'Правило компетенције курса \'{$a}\' није познато';
$string['errorcoursecompetencyrule'] = 'Правило компетенције курса \'{$a}\' није познато';
$string['errorinvalidcourse'] = 'Неисправан курс';
$string['errornocompetency'] = '{$a} компетенција не може бити пронађена';
$string['errorplanstatus'] = 'Статус планова учења \'{$a}\' је непознат';
$string['errorscalealreadyused'] = 'Скала не може бити измењена јер се већ користи.';
$string['errorscaleconfiguration'] = 'Скала треба да се подеси одабиром подразумеваних и напредних ставки.';
$string['errorusercomptencystatus'] = 'Кориснички статус компетенција \'{$a}\' је непознат';
$string['eventcompetencycreated'] = 'Компетенција је креирана.';
$string['eventcompetencydeleted'] = 'Компетенција је обрисана.';
$string['eventcompetencyframeworkcreated'] = 'Оквир компетенција је креиран.';
$string['eventcompetencyframeworkdeleted'] = 'Оквир компетенција је обрисан.';
$string['eventcompetencyframeworkupdated'] = 'Оквир компетенција је ажуриран.';
$string['eventcompetencyframeworkviewed'] = 'Оквир компетенција приказан.';
$string['eventcompetencyupdated'] = 'Компетенција ажурирана.';
$string['eventcompetencyviewed'] = 'Компетенција приказан.';
$string['eventevidencecreated'] = 'Доказ креиран.';
$string['eventplanapproved'] = 'План учења одобрен.';
$string['eventplancompleted'] = 'План учења испуњен.';
$string['eventplancreated'] = 'План учења креиран.';
$string['eventplandeleted'] = 'План учења обрисан.';
$string['eventplanreopened'] = 'План учења поново активиран.';
$string['eventplanreviewrequestcancelled'] = 'Захтевани преглед плана учења отказан.';
$string['eventplanreviewrequested'] = 'Преглед плана учења затражен.';
$string['eventplanreviewstarted'] = 'Преглед плана учења започет.';
$string['eventplanreviewstopped'] = 'Преглед плана учења заустављен.';
$string['eventplanunapproved'] = 'План учења неодобрен.';
$string['eventplanunlinked'] = 'План учења није више повезан.';
$string['eventplanupdated'] = 'План учења ажуриран.';
$string['eventplanviewed'] = 'План учења приказан.';
$string['eventtemplatecreated'] = 'Шаблон плана учења креиран.';
$string['eventtemplatedeleted'] = 'Шаблон плана учења обрисан.';
$string['eventtemplateupdated'] = 'Шаблон плана учења ажуриран.';
$string['eventtemplateviewed'] = 'Шаблон плана учења приказан.';
$string['eventusercompetencyplanviewed'] = 'План компетенције корисника  приказан.';
$string['eventusercompetencyrated'] = 'Компетенција корисника рангирана.';
$string['eventusercompetencyratedincourse'] = 'Компетенција корисника рангирана у оквиру курса.';
$string['eventusercompetencyratedinplan'] = 'Компетенција корисника рангирана у плану учења.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Захтевани преглед компетенција корисника отказан.';
$string['eventusercompetencyreviewrequested'] = 'Преглед компетенција корисника затражен.';
$string['eventusercompetencyreviewstarted'] = 'Преглед компетенције корисника започет.';
$string['eventusercompetencyreviewstopped'] = 'Преглед компетенције корисника заустављен.';
$string['eventusercompetencyviewed'] = 'Компетенција корисника приказан.';
$string['eventusercompetencyviewedincourse'] = 'Компетенција корисника приказана у оквиру курса.';
$string['eventusercompetencyviewedinplan'] = 'Компетенција корисника приказана у плану учења.';
$string['eventuserevidencecreated'] = 'Доказ о претходном учењу креиран.';
$string['eventuserevidencedeleted'] = 'Доказ о претходном учењу обрисан.';
$string['eventuserevidenceupdated'] = 'Доказ о претходном учењу ажуриран.';
$string['evidence_competencyrule'] = 'Правило компетенције испуњено.';
$string['evidence_coursecompleted'] = 'Курс \'{$a}\' је завршен.';
$string['evidence_coursemodulecompleted'] = 'Активност \'{$a}\' је завршена.';
$string['evidence_courserestored'] = 'Процена компетенција је рестаурисана заједно са курсом \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Доказ о претходном учењу \'{$a}\' је повезан.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Веза са доказа о претходном учењу \'{$a}\' је уклоњена.';
$string['evidence_manualoverride'] = 'Процена компетенције је ручно подешена';
$string['evidence_manualoverrideincourse'] = 'Процена компетенције је ручно подешена на курсу \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'Процена компетенције је ручно подешена плану учења \'{$a}\'.';
$string['invalidevidencedesc'] = 'Неисправан опис доказа';
$string['invalidgrade'] = 'Неисправна процена';
$string['invalidpersistenterror'] = 'Грешка: {$a}';
$string['invalidplan'] = 'Неисправан план учења';
$string['invalidtaxonomy'] = 'Неисправна таксономија: {$a}';
$string['invalidurl'] = 'URL адреса није исправна. Побрините се да почне са \'http://\' или \'https://\'.';
$string['nouserplanswithcompetency'] = 'Ниједан план за учење не садржи ову компетенцију.';
$string['planstatusactive'] = 'Активан';
$string['planstatuscomplete'] = 'Испуњен';
$string['planstatusdraft'] = 'Радна верзија';
$string['planstatusinreview'] = 'На прегледу';
$string['planstatuswaitingforreview'] = 'Чека на преглед';
$string['pointsrequiredaremet'] = 'Достигнут је тражени број поена';
$string['privacy:evidence:action:complete'] = 'Заврши компетенцију ако је неоцењена';
$string['privacy:evidence:action:log'] = 'Акција записа';
$string['privacy:evidence:action:override'] = 'Измена оцене компетенције';
$string['privacy:metadata:competency'] = 'Евиденција компетенција';
$string['privacy:metadata:competency_coursecomp'] = 'Евиденција компетенција везаних за курс';
$string['privacy:metadata:competency_coursecompsetting'] = 'Евиденција о подешавањима компетенција на курсу';
$string['privacy:metadata:competency_evidence'] = 'Евиденција доказа који утичу на стање компетенције';
$string['privacy:metadata:competency_framework'] = 'Евиденција оквира компетенција';
$string['privacy:metadata:competency_modulecomp'] = 'Евиденција компетенција повезаних са модулом';
$string['privacy:metadata:competency_plan'] = 'Евиденција планова учења';
$string['privacy:metadata:competency_plancomp'] = 'Евиденција компетенција у плану учења';
$string['privacy:metadata:competency_relatedcomp'] = 'Евиденција о односу између компетенција';
$string['privacy:metadata:competency_template'] = 'Евиденција шаблона плана учења';
$string['privacy:metadata:competency_templatecohort'] = 'Евиденција о кохортама повезаним са шаблоном плана учења';
$string['privacy:metadata:competency_templatecomp'] = 'Евиденција компетенција у шаблону плана учења';
$string['privacy:metadata:competency_usercomp'] = 'Евиденција стања компетенција корисника';
$string['privacy:metadata:competency_usercompcourse'] = 'Евиденција стања компетенција корисника на курсу';
$string['privacy:metadata:competency_usercompplan'] = 'Евиденција стања компетенција у плану учења';
$string['privacy:metadata:competency_userevidence'] = 'Евиденција доказа о претходном учењу';
$string['privacy:metadata:competency_userevidencecomp'] = 'Евиденција компетенција повезаних са доказима о претходном учењу';
$string['privacy:metadata:core_comments'] = 'Коментари о плановима учења и компетенцијама';
$string['privacy:metadata:evidence:action'] = 'Врста акције предузете са доказима';
$string['privacy:metadata:evidence:actionuserid'] = 'Корисник који изводи акцију';
$string['privacy:metadata:evidence:desca'] = 'Опциони параметри описа доказа који се могу превести';
$string['privacy:metadata:evidence:desccomponent'] = 'Компонента описа доказа који се могу превести';
$string['privacy:metadata:evidence:descidentifier'] = 'Идентификатор описа доказа који се могу превести';
$string['privacy:metadata:evidence:grade'] = 'Оцена повезана са доказима';
$string['privacy:metadata:evidence:note'] = 'Нелокализована белешка приложена уз доказе';
$string['privacy:metadata:evidence:url'] = 'URL адреса повезана са доказима';
$string['privacy:metadata:plan:description'] = 'Опис плана учења';
$string['privacy:metadata:plan:duedate'] = 'Рок завршетка плана учења';
$string['privacy:metadata:plan:name'] = 'Назив плана учење';
$string['privacy:metadata:plan:reviewerid'] = 'ID ознака рецензента плана учења';
$string['privacy:metadata:plan:status'] = 'Статус плана учења';
$string['privacy:metadata:plan:userid'] = 'ID ознака корисника чији је план учења';
$string['privacy:metadata:timecreated'] = 'Време када је евиденција креирана';
$string['privacy:metadata:timemodified'] = 'Време када је евиденција уређивана';
$string['privacy:metadata:usercomp:grade'] = 'Оцена која се даје за компетенцију';
$string['privacy:metadata:usercomp:proficiency'] = 'Да ли је постигнута стручност';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID ознака рецензента';
$string['privacy:metadata:usercomp:status'] = 'Статус компетенције';
$string['privacy:metadata:usercomp:userid'] = 'ID ознака корисника чији је компетенција';
$string['privacy:metadata:userevidence:description'] = 'Опис доказа';
$string['privacy:metadata:userevidence:name'] = 'Назив доказа о претходном учењу';
$string['privacy:metadata:userevidence:url'] = 'URL адреса повезана са доказима';
$string['privacy:metadata:usermodified'] = 'Корисник који је креирао или изменио евиденцију';
$string['privacy:path:plans'] = 'Планови учења';
$string['privacy:path:relatedtome'] = 'Повезано са мном';
$string['privacy:path:userevidence'] = 'Докази о претходном учењу';
$string['pushcourseratingstouserplans'] = 'Помери процене компетенција курса у индивидуалне планове учења';
$string['pushcourseratingstouserplans_desc'] = 'Подразумевана вредност за подешавање курса која служи за ажурирање индивидуалних планова учења кад се вреднују компетенције курса.';
$string['syncplanscohorts'] = 'Планови за синхронизацију из кохорти шаблона планова учења';
$string['taxonomy_behaviour'] = 'Понашање';
$string['taxonomy_competency'] = 'Компетенција';
$string['taxonomy_concept'] = 'Концепт';
$string['taxonomy_domain'] = 'Домен';
$string['taxonomy_indicator'] = 'Индикатор';
$string['taxonomy_level'] = 'Ниво';
$string['taxonomy_outcome'] = 'Исход';
$string['taxonomy_practice'] = 'Пракса';
$string['taxonomy_proficiency'] = 'Стручност';
$string['taxonomy_skill'] = 'Вештина';
$string['taxonomy_value'] = 'Вредност';
$string['usercommentedonacompetency'] = '{$a->fullname} је коментарисао/ла компетенцију "{$a->competency}":

{$a->comment}

Погледајте: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} је коментарисао/ла компетенцију "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Погледајте: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} је коментарисао/ла компетенцију "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} је коментарисао/ла компетенцију.';
$string['usercommentedonaplan'] = '{$a->fullname} је коментарисао/ла план учења "{$a->plan}":

{$a->comment}

Погледајте: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} је коментарисао/ла план учења "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Погледајте: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} је коментарисао/ла план учења "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} је коментарисао/ла план учења.';
$string['usercompetencystatus_idle'] = 'У стању мировања';
$string['usercompetencystatus_inreview'] = 'На прегледу';
$string['usercompetencystatus_waitingforreview'] = 'Чека на преглед';
$string['userplans'] = 'Планови учења';
