<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'no', version '3.8'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Legger til avtale';
$string['addingappointments'] = 'Legger til avtaler';
$string['addingsession'] = 'Legger til en ny økt i {$a}';
$string['addmanageremailaddress'] = 'Legg til e-postadresse for leder';
$string['addmanageremailinstruction'] = 'Du har ikke tidligere oppgitt lederens e-postadresse. Skriv inn det nedenfor for å registrere deg på denne økten.';
$string['addnewfield'] = 'Legg til et nytt tilpasset felt';
$string['addnewfieldlink'] = 'Opprett et nytt tilpasset felt';
$string['addremoveattendees'] = 'Legg til / fjern deltakere';
$string['addsession'] = 'Legg til økt';
$string['addstudent'] = 'Legg til student';
$string['addtimeframe'] = 'Legg til tidsramme';
$string['advanced'] = 'Avansert';
$string['alllocations'] = 'Alle lokasjoner';
$string['allowcancellations'] = 'Tillat avbestilling';
$string['allowcancellations_help'] = 'Hvis det er merket av, vil deltakere kunne avbryte påmeldingene sine';
$string['allowcancellationsdefault'] = 'Tillat å avbestille - som standard';
$string['allowcancellationsdefault_help'] = 'Hvis avkrysset, vil standardinnstillingen, når du oppretter nye økter for denne aktiviteten, være å tillate avbestillinger';
$string['allowwaitlist'] = 'Tillat venteliste';
$string['allowwaitlist_help'] = 'Når "Tillat venteliste" er krysset av, vil elevene kunne registrere seg på en avtale selv om den allerede er full. <br />Når en elev melder seg på en økt som allerede er full, vil de motta en e-post med beskjed om at de har blitt lagt til på venteliste og vil bli varslet om økten blir tilgjengelig.';
$string['allsessionsin'] = 'Alle økter i  {$a}';
$string['alreadysignedup'] = 'Du har allerede registrert deg for denne avtalen.';
$string['answer'] = 'Logg inn';
$string['answercancel'] = 'Logg ut';
$string['appointment'] = 'Avtale';
$string['appointment:addattendees'] = 'Legg deltakere til en avtalesesjon';
$string['appointment:addinstance'] = 'Legg til instans';
$string['appointment:configurecancellation'] = 'Tillat konfigurering av påmeldingsavbestillinger, når du legger til / redigerer en avtaleaktivitet.';
$string['appointment:editsessions'] = 'Legg til, redigere, kopiere og slette avtaleøkter';
$string['appointment:managecustomfields'] = 'Administrer egendefinerte felt for avtaler.';
$string['appointment:overbook'] = 'Registrer deg på hele økter som ikke har venteliste aktivert.';
$string['appointment:removeattendees'] = 'Fjern deltakerne fra en avtaleøkt';
$string['appointment:signup'] = 'Registrer deg for en økt';
$string['appointment:takeattendance'] = 'Delta';
$string['appointment:view'] = 'Se avtaleaktiviteter og økter';
$string['appointment:viewattendees'] = 'Vis deltakerliste og deltagere';
$string['appointment:viewcancellations'] = 'Vis kanselleringer';
$string['appointmentactivity'] = 'Aktiviteten Avtale';
$string['appointmentbooking'] = 'Avtalebestilling';
$string['appointmentcustomfields'] = 'Tilpassede felt for avtale';
$string['appointmentname'] = 'Avtalenavn';
$string['appointments'] = 'Avtaler';
$string['appointmentsession'] = 'Avtaleøkt';
$string['appointmentsessions'] = 'Avtaleøkter';
$string['approvalreqd'] = 'Godkjenning kreves';
$string['approvalreqd_help'] = 'Når "Godkjenning kreves" er avmerket, trenger en elev godkjenning fra lederen sin for å få lov til å delta på en avtaleøkt.';
$string['approve'] = 'Godkjenn';
$string['assessmentyour'] = 'Din vurdering';
$string['attendance'] = 'Deltakelse';
$string['attendanceinstructions'] = 'Velg brukere som deltok på økten:';
$string['attendedsession'] = 'Deltatt på økt';
$string['attendees'] = 'Deltakere';
$string['attendeestablesummary'] = 'Folk som planlegger eller har deltatt på denne økten.';
$string['availableseats'] = '{$a} plasser ledige';
$string['book'] = 'Reserver';
$string['booked'] = 'Reservert';
$string['bookedvscapacity'] = 'Reservert / Max antall plasser';
$string['bookingcancelled'] = 'Din reservasjon er kansellert.';
$string['bookingcompleted'] = 'Din reservasjon er fullført.';
$string['bookingfull'] = 'Fullt';
$string['bookingopen'] = 'Åpen';
$string['break'] = 'Pausetid';
$string['break_help'] = 'Denne innstillingen bestemmer ventetiden mellom hver avtale. 0 betyr at det ikke blir satt noen ventetid.';
$string['calendareventdescriptionbooking'] = 'Du er reservert for denne <a href="{$a}"> avtaleøkten </a>.';
$string['calendareventdescriptionsession'] = 'Du har opprettet denne <a href="{$a}"> avtaleøkten </a>.';
$string['calendaroptions'] = 'Kalenderalternativer';
$string['cancel'] = 'Avbryt';
$string['cancelbooking'] = 'Avbryt reservering';
$string['cancelbookingfor'] = 'Avbryt reserveringen for {$a}';
$string['cancellation'] = 'Kansellering';
$string['cancellationconfirm'] = 'Er du sikker på at du vil kansellere din reservering til denne økten?';
$string['cancellationinstrmngr'] = '# Merknad til leder';
$string['cancellationinstrmngr_help'] = 'Når ** Send varsel til leder ** er merket av, sendes teksten i ** Merknad for leder ** -feltet til en elevs leder med beskjed om at de har kansellert en avtalebestilling.';
$string['cancellationmessage'] = 'Avbestillingsmelding';
$string['cancellationmessage_help'] = 'Denne meldingen blir sendt ut når brukere avbryter bookingen for en økt.';
$string['cancellations'] = 'Kanselleringer';
$string['cancellationsent'] = 'Du bør umiddelbart motta en e-post om avbestilling.';
$string['cancellationsentmgr'] = 'Du og lederen din bør umiddelbart motta en e-post om avbestilling.';
$string['cancellationstablesummary'] = 'Liste over personer som har kansellert påmeldte økter.';
$string['cancelreason'] = 'Årsaken til kansellering';
$string['cannotapproveatcapacity'] = 'Du kan ikke godkjenne flere deltagere ettersom denne økten er full.';
$string['cannotsignupsessioninprogress'] = 'Du kan ikke registrere deg, denne økten pågår';
$string['cannotsignupsessionover'] = 'Du kan ikke registrere deg, denne økten er over.';
$string['capacity'] = 'Kapasitet';
$string['capacity_help'] = '** Kapasitet ** er antall ledige plasser i en økt.

Når en avtaler øker kapasiteten, vises ikke sesjonsdetaljene på kurssiden. Detaljene vises gråtonet på siden "Se alle økter", og eleven kan ikke registrere seg på økten.&nbsp;';
$string['changemanageremailaddress'] = 'Endre e-postadresse for leder';
$string['changemanageremailinstruction'] = 'Vennligst skriv inn e-postadressen til din nåværende leder nedenfor.';
$string['clearall'] = 'Fjern alt';
$string['closed'] = 'Stengt';
$string['confirm'] = 'Bekreft';
$string['confirmation'] = 'Bekreftelse';
$string['confirmationinstrmngr'] = '# Merknad til leder';
$string['confirmationinstrmngr_help'] = 'Når "Send varsel til leder" er krysset av, blir teksten i "Varsel for leder" -feltet sendt til en leder med beskjed om at en medarbeider har meldt seg på en avtaleøkt.';
$string['confirmationmessage'] = 'Bekreftelsesmelding';
$string['confirmationmessage_help'] = 'Denne meldingen blir sendt ut når brukere melder seg på en økt.';
$string['confirmationsent'] = 'Du bør umiddelbart motta en bekreftelsesmail.';
$string['confirmationsentmgr'] = 'Du og lederen din skal umiddelbart motta en bekreftelsesmail.';
$string['confirmcancelbooking'] = 'Bekreft kansellering';
$string['confirmmanageremailaddress'] = 'Bekreft lederens e-postadresse';
$string['confirmmanageremailaddressquestion'] = 'Er <b> {$a} </b> fremdeles e-postadressen til lederen din?';
$string['confirmmanageremailinstruction1'] = 'Du har tidligere skrevet inn følgende som lederens e-postadresse:';
$string['confirmmanageremailinstruction2'] = 'Er dette fortsatt lederens e-postadresse?';
$string['continuetologin'] = 'Klikk fortsett for å logge inn';
$string['copy'] = 'Kopier';
$string['cost'] = 'Koste';
$string['costheading'] = 'Øktkostnad';
$string['courseresetsessions'] = 'Fjern alle avtaler';
$string['courseresetsignups'] = 'Fjern alle reservasjoner';
$string['crontask'] = 'Vedlikeholdsjobb for Avtaler';
$string['currentstatus'] = 'Gjeldende status';
$string['customfieldsheading'] = 'Egendefinerte felter for økter';
$string['customisednotifications'] = 'Egendefinerte meldinger';
$string['date'] = 'Dato';
$string['dateadd'] = 'Legg til en ny dato';
$string['dateremove'] = 'Fjern denne datoen';
$string['datesignedup'] = 'Dato påmeldt';
$string['datetext'] = 'Du er påmeldt for datoen';
$string['decidelater'] = 'Bestem senere';
$string['decline'] = 'Avslå';
$string['delete'] = 'Slett';
$string['deleteall'] = 'Slett alle';
$string['deleteappointment'] = 'Slett avtale';
$string['deleteappointmentconfirm'] = 'Er du helt sikker på at du vil slette denne avtalen og alle påmeldinger?';
$string['deletedate'] = 'Slett dato';
$string['deletesession'] = 'Slett økt';
$string['deletetimeframe'] = 'Slett tidsrammen';
$string['deletingsession'] = 'Sletter økt i  {$a}';
$string['description'] = 'Introduksjonstekst';
$string['description_help'] = '** Beskrivelse ** vises når en elev melder seg på en avtalerøkt.

** Beskrivelse ** vises også i treningskalenderen.';
$string['details'] = 'Detaljer';
$string['details_help'] = 'Detaljer spores per sesjonsbasis.Hvis tekst er lagt til i detaljfeltet, vises detaljerteksten på brukeroppmeldingssiden.Som standard vises detaljerteksten også i e-postmeldinger med bekreftelse, påminnelse, venteliste og kansellering.';
$string['discountcode'] = 'Rabattkode';
$string['discountcode_help'] = 'Rabattkode er koden som kreves for at rabattkostnadene kan spores for opplæring av en ansatt.
Hvis medarbeideren ikke oppgir rabattkoden, vises de normale kostnadene i opplæringsprotokollen.';
$string['discountcodelearner'] = 'Rabattkode';
$string['discountcodelearner_help'] = 'Hvis du kjenner til rabattkoden, skriv den inn her. Hvis du lar dette feltet stå tomt, blir du belastet den normale kostnaden for dette arrangementet';
$string['discountcost'] = 'Rabattert pris';
$string['discountcost_help'] = 'Rabattert pris er dollarbeløpet som belastes medarbeidere som har et medlems-ID.Hvis en medarbeider angir et medlemskaps-id når du registrerer deg for en økt, vises rabattert pris i kostnadskolonnen i kursets karakterbok.';
$string['due'] = 'grunn';
$string['duplicate'] = 'Duplisér';
$string['duplicateappointment'] = 'Duplisér avtale';
$string['duration'] = 'Varighet';
$string['duration_help'] = '** Varighet ** er den totale lengden på treningene i timer.
For eksempel:
* "2 timer" angis som ** 2 ** eller ** 2: 00 **
* "1 time og 30 minutter" er angitt som ** 1: 30 **
* "45 minutter" er angitt som ** 0: 45 **
* "20 minutter" legges inn som ** 0: 20 **.

Hvis treningen foregår over to eller flere tidsperioder, er varigheten den samlede totalen.';
$string['early'] = '{$a} tidlig';
$string['edit'] = 'Endre';
$string['editappointment'] = 'Endre avtale';
$string['editingappointment'] = 'Endrer avtale';
$string['editingsession'] = 'Endrer økt i {$a}';
$string['editsession'] = 'Endre økt';
$string['email:instrmngr'] = 'Varsel for leder';
$string['email:message'] = 'Melding';
$string['email:subject'] = 'Emne';
$string['emailmanager'] = 'Send varsel til leder';
$string['emailmanagercancellation'] = '# Send varsel til leder';
$string['emailmanagercancellation_help'] = 'Når "Send varsel til leder" er krysset av, vil det bli sendt en e-post til elevens leder som ber dem om at avbestillingen er kansellert.';
$string['emailmanagerconfirmation'] = '# Send varsel til leder';
$string['emailmanagerconfirmation_help'] = 'Når "Send varsel til leder" er krysset av, vil en bekreftelses-e-post bli sendt til elevens leder når eleven melder seg på en avtaleøkt.';
$string['emailmanagerreminder'] = '# Send varsel til leder';
$string['emailmanagerreminder_help'] = 'Når "Send varsel til leder" er krysset av, blir en påminnelsesmelding sendt til elevens leder noen dager før startdatoen for avtalsøkten.';
$string['empty'] = 'Tom';
$string['emptylocation'] = 'Sted var tom';
$string['enablewaitlist'] = 'Aktivér venteliste';
$string['endtime'] = 'Slutt-tid';
$string['enrolled'] = 'påmeldt';
$string['entitiyappointment'] = 'Avtale';
$string['entitiysession'] = 'Økt';
$string['error:addalreadysignedupattendee'] = '{$a} er allerede påmeldt for denne avtalsaktiviteten.';
$string['error:addattendee'] = 'Kunne ikke legge til {$a} til økten.';
$string['error:appointmentfailedupdatestatus'] = 'Avtaler kunne ikke oppdatere brukerens status';
$string['error:cancelbooking'] = 'Det oppsto et problem med å kansellere påmeldingen';
$string['error:cancellationsnotallowed'] = 'Du har ikke lov til å kansellere denne registreringen.';
$string['error:cannotconfigurecustomfields'] = 'Du har ikke lov til å konfigurere tilpassede felt.';
$string['error:cannotemailmanager'] = 'Sendt påminnelsemail for innsendings-id {$a->submissionid} til bruker {$a-> userid}, men kunne ikke sende meldingen for brukerens leder-e-postadresse ({$a-> manageremail}).';
$string['error:cannotemailuser'] = 'Kunne ikke sende ut e-post for innsendings-id {$a->submissionid} til bruker {$a->userid} ({$a->useremail}).';
$string['error:cannotsendconfirmationmanager'] = 'En bekreftelsesmelding ble sendt til e-postkontoen din, men det oppstod et problem med å sende bekreftelsesmeldingen til lederens e-postadresse.';
$string['error:cannotsendconfirmationthirdparty'] = 'En bekreftelsesmelding ble sendt til e-postkontoen din og lederens e-postkonto, men det oppsto et problem med å sende bekreftelsesmeldingen til tredjepartens e-postadresse.';
$string['error:cannotsendconfirmationuser'] = 'Det oppsto et problem med å sende bekreftelsesmeldingen til e-postkontoen din.';
$string['error:cannotsendconfirmationusermanager'] = 'En bekreftelsesmelding kunne ikke sendes til din e-postadresse og til lederens e-postadresse.';
$string['error:cannotsendrequestmanager'] = 'Det oppsto et problem med å sende meldingen om påmeldingsforespørsel til lederens e-postkonto.';
$string['error:cannotsendrequestuser'] = 'Det oppsto et problem med å sende meldingsforespørselsmeldingen til e-postkontoen din.';
$string['error:canttakeattendanceforunstartedsession'] = 'Kan ikke delta på en økt som ennå ikke har startet.';
$string['error:couldnotaddfield'] = 'Kunne ikke legge til tilpasset øktfelt.';
$string['error:couldnotaddsession'] = 'Kunne ikke legge til økt';
$string['error:couldnotaddtrainer'] = 'Kunne ikke lagre den nye avtalen';
$string['error:couldnotcopysession'] = 'Kunne ikke kopiere økten';
$string['error:couldnotdeletefield'] = 'Kunne ikke slette det tilpassede øktfeltet';
$string['error:couldnotdeletesession'] = 'Kunne ikke slette økten';
$string['error:couldnotdeletetrainer'] = 'Kan ikke slette en trener i avtaleøkten';
$string['error:couldnotfindsession'] = 'Kunne ikke finne den nylig innsatte økten';
$string['error:couldnotsavecustomfield'] = 'Kunne ikke lagre tilpasset felt';
$string['error:couldnotupdateappointmentrecord'] = 'Kunne ikke oppdatere avtalsoppføringsoppføringen i databasen';
$string['error:couldnotupdatecalendar'] = 'Kunne ikke oppdatere økthendelsen i kalenderen.';
$string['error:couldnotupdatefield'] = 'Kunne ikke oppdatere tilpasset øktfelt.';
$string['error:couldnotupdatemanageremail'] = 'Kunne ikke oppdatere lederens e-postadresse.';
$string['error:couldnotupdatesession'] = 'Kunne ikke oppdatere økten';
$string['error:coursemisconfigured'] = 'Kurs er feilkonfigurert';
$string['error:cronprefix'] = 'Feil: Avtale cron:';
$string['error:emptylocation'] = 'Plasseringen var tom.';
$string['error:emptymanageremail'] = 'Lederens-e-postadresse er tom.';
$string['error:emptyvenue'] = 'Lokalet var tomt.';
$string['error:enrolmentfailed'] = 'Kunne ikke melde {$a} inn i kurset.';
$string['error:eventoccurred'] = 'Du kan ikke avbryte en begivenhet som allerede har skjedd.';
$string['error:fieldidincorrect'] = 'Felt-ID er feil: {$a}';
$string['error:incorrectappointmentid'] = 'Avtale ID var feil';
$string['error:incorrectcoursemodule'] = 'Kursmodulen er feil';
$string['error:incorrectcoursemoduleid'] = 'Kursmodul-ID var feil';
$string['error:incorrectcoursemodulesession'] = 'Avtaleøkt for kursmodul var feil';
$string['error:incorrectnotificationtype'] = 'Feil varslingstype gitt';
$string['error:invaliduserid'] = 'Ugyldig bruker-ID';
$string['error:manageremailaddressmissing'] = 'Du er for øyeblikket ikke tilordnet en leder i systemet. Kontakt nettstedets administrator.';
$string['error:mustspecifycoursemoduleappointment'] = 'Må spesifisere en kursmodul eller en avtale-ID';
$string['error:nomanageremail'] = 'Du oppga ikke en e-postadresse til lederen din';
$string['error:nomanagersemailset'] = 'Ingen leder-e-post er angitt';
$string['error:nopermissiontosignup'] = 'Du har ikke tillatelse til å registrere deg på denne avtalen.';
$string['error:noticeidincorrect'] = 'Merknads-ID er feil: {$a}';
$string['error:problemsigningup'] = 'Det oppstod et problem med å registrere deg.';
$string['error:removeattendee'] = 'Kunne ikke fjerne {$a} fra økten.';
$string['error:sessionstartafterend'] = 'Starttid for økten er etter sluttdatoen';
$string['error:shortnametaken'] = 'Tilpasset felt med dette kortnavnet eksisterer allerede.';
$string['error:signedupinothersession'] = 'Du er allerede registrert i en annen økt for denne aktiviteten. Du kan bare registrere deg for en økt per avtaleaktivitet.';
$string['error:unknownbuttonclicked'] = 'Ingen handlinger knyttet til knappen som ble klikket';
$string['errorcannoteditsessions'] = 'Du har ikke tillatelse til å redigere økter';
$string['errorcannotmanagecustomfields'] = 'Du har ikke lov til å administrere tilpassede felt.';
$string['errorcannotviewappointment'] = 'Du har ikke tillatelse til å se denne avtalen';
$string['errorcannotviewattendees'] = 'Du har ikke tillatelse til å se deltakere';
$string['errornosessionid'] = 'Ingen økt-ID gitt.';
$string['errornosstartdate'] = 'Ingen startdato gitt.';
$string['errornosstarttime'] = 'Ingen starttid gitt.';
$string['eventaddsession'] = 'Økten lagt til';
$string['eventaddsessionfailed'] = 'Legg til økt feilet';
$string['eventapproverequests'] = 'Forespørselsgodkjenninger for økten';
$string['eventattendancetaken'] = 'Øktoppmøte tatt';
$string['eventattendeesviewed'] = 'Møtedeltakere sett';
$string['eventcancelbooking'] = 'Økten avbryter bestillingen';
$string['eventcancelbookingfailed'] = 'Øktens kansellering av bestillingen (mislyktes)';
$string['eventcourseappointmentviewed'] = 'Forekomster av kursavtalen sett';
$string['eventcoursemoduleviewed'] = 'Avtalemodulforekomst sett';
$string['eventdeletesession'] = 'Økt slettet';
$string['eventdeletesessionfailed'] = 'Sletting av økt mislykkes';
$string['eventsignup'] = 'Øktpåmelding';
$string['eventsignupfailed'] = 'Øktpåmelding mislykkes';
$string['eventtakeattendancefailed'] = 'Angi frammøte for økten mislykkes';
$string['eventupdatemanageremailfailed'] = 'Oppdatering av leders e-post mislykkes';
$string['eventupdatesession'] = 'Økten oppdatert';
$string['eventupdatesessionfailed'] = 'Oppdatering av økten mislykkes';
$string['excelformat'] = 'Excel';
$string['export'] = 'Eksport';
$string['exportattendance'] = 'Eksporér frammøte';
$string['exporttofile'] = 'Eksport til fil';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackupdated'] = 'Tilbakemelding oppdatert for \\{$a} personer';
$string['field:multiselect'] = 'Flere valg';
$string['field:select'] = 'Valgmeny';
$string['field:text'] = 'Tekst';
$string['fielddeleteconfirm'] = 'Vil du slette felt \'{$a}\' og alle sesjonsdata knyttet til det?';
$string['floor'] = 'Etasje';
$string['format'] = 'Format';
$string['full'] = 'Datoen er fullt okkupert';
$string['fullfilter'] = 'Fullt';
$string['goback'] = 'Tilbake';
$string['guestsno'] = 'Beklager, gjester har ikke lov til å registrere seg på økter.';
$string['icalendarheading'] = 'iCalendar vedlegg';
$string['import'] = 'Import';
$string['info'] = 'Info';
$string['joinwaitlist'] = 'Bli med på venteliste';
$string['late'] = '\\{$a} sen';
$string['location'] = 'Plassering';
$string['location_help'] = '** Plassering ** beskriver nærområdet til økten (by, fylke, region osv.).

** Plassering ** vises på kurssiden, \'Registreringsside\', \'Vis alle økter\' -siden og i alle e-postvarsler.

På siden "Vis alle økter" kan de oppgitte økter filtreres etter plassering.';
$string['lookfor'] = 'Søk';
$string['managecustomfields'] = 'Administrer tilpassede felt';
$string['manageradded'] = 'Din leders e-postadressen er akseptert.';
$string['managerchanged'] = 'Din leders e-postadressen er endret.';
$string['manageremail'] = 'Lederens e-post';
$string['manageremailaddress'] = 'Lederens e-postadresse';
$string['manageremailformat'] = 'E-postadressen må være av formatet \'{$a}\' for å bli akseptert.';
$string['manageremailheading'] = 'Leder epost';
$string['manageremailinstruction'] = 'Når du registrerer deg til en treningsøkt vil en bekreftelsesepost sendes til epostadressen din, samt en kopi til lederen din.';
$string['manageremailinstructionconfirm'] = 'Vennligst bekreft leders epostadresse';
$string['managername'] = 'Leders navn';
$string['managerupdated'] = 'Leders epostadresse oppdatert';
$string['maximumpoints'] = 'Maks antall poeng';
$string['maximumsize'] = 'Maks antall deltakere';
$string['modulename'] = 'Avtalereservering';
$string['modulenameplural'] = 'Avtaler';
$string['moreinfo'] = 'Mer informasjon';
$string['multipleappointments'] = 'Multiple avtaler';
$string['newmanageremailaddress'] = 'Leders epostadresse';
$string['noappointments'] = 'Ingen avtaleaktiviteter';
$string['nocustomfields'] = '<p>Ingen egendefinerte felt</p>';
$string['none'] = 'ingen';
$string['normalcost'] = 'Vanlig kostnad';
$string['nosignedupusers'] = 'Ingen brukere har registrert seg for denne økten.';
$string['onehour'] = '1 time';
$string['oneminute'] = '1 minutt';
$string['options'] = 'Valg';
$string['or'] = 'eller';
$string['place'] = 'Rom';
$string['pluginadministration'] = 'Avtaleadministrasjon';
$string['pluginname'] = 'Avtale';
$string['points'] = 'Poeng';
$string['pointsplural'] = 'Poeng';
$string['registrations'] = 'Registreringer';
$string['room'] = 'Rom';
$string['saveallfeedback'] = 'Lagre alle svar';
$string['saveattendance'] = 'Lagre deltakelse';
$string['scheduledsession'] = 'Planlagt økt';
$string['scheduledsessions'] = 'Planlagte økter';
$string['seatsavailable'] = 'Ledige plasser';
$string['seatsbooked'] = 'Reserverte plasser';
$string['seeattendees'] = 'Vis deltakere';
$string['sessionavailability'] = 'Økt tilgjengelighet';
$string['sessiondate'] = 'Øktdato';
$string['sessiondatetime'] = 'Øktedat/tid';
$string['sessiondescription'] = 'Beskrivelse';
$string['sessionended'] = 'Økt avsluttet:';
$string['sessionfinished'] = 'Ferdig';
$string['sessionroles'] = 'Øktroller';
$string['sessions'] = 'Økter';
$string['sessionstartdate'] = 'Øktens startdato';
