<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'no', version '3.8'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har innleveringer som behøver din oppmerksomhet.';
$string['addattempt'] = 'Tillat et nytt forsøk';
$string['addnewattempt'] = 'Legg til et nytt forsøk';
$string['addnewattempt_help'] = 'Dette oppretter en ny tom innlevering som du kan jobbe med.';
$string['addnewattemptfromprevious'] = 'Legg til et nytt forsøk basert på forrige innlevering';
$string['addnewattemptfromprevious_help'] = 'Dette kopierer innholdet fra din forrige innlevering til en ny innlevering som du kan jobbe videre med.';
$string['addnewgroupoverride'] = 'Legg til gruppeoverstyring';
$string['addnewuseroverride'] = 'Leggtil brukeroverstyring';
$string['addsubmission'] = 'Legg til innlevering';
$string['addsubmission_help'] = 'Du har ikke levert noe ennå.';
$string['allocatedmarker'] = '';
$string['allocatedmarker_help'] = 'Markør tildelt til denne innleveringen.';
$string['allowsubmissions'] = 'Tillat brukeren å fortsette og levere inn besvarelser til denne innleveringen.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Informasjon om innleveringen og innsendingsskjemaet finner du her: <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Tillat innsending fra';
$string['allowsubmissionsfromdate_help'] = 'Hvis denne funksjonen er aktivert, kan ikke studentene levere før denne datoen. Hvis den er deaktivert, kan studentene levere inn med en gang.';
$string['allowsubmissionsfromdatesummary'] = 'Denne innleveringsoppgaven godtar innleveringer som er sendt inn fra <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Tillat endring av innsending';
$string['alwaysshowdescription'] = 'Vis alltid beskrivelse';
$string['alwaysshowdescription_help'] = 'Hvis denne funksjonen er deaktivert, blir innleveringsbeskrivelsen ovenfor først bli synlig for studentene på "Tillat innleveringer fra"-datoen.';
$string['applytoteam'] = 'Gjør karakterer og tilbakemeldinger gjeldende for helle gruppen';
$string['assign:addinstance'] = 'Legg til ny innlevering';
$string['assign:editothersubmission'] = 'Rediger en annen students innlevering';
$string['assign:exportownsubmission'] = 'Eksporter din innlevering';
$string['assign:grade'] = 'Karaktergivere';
$string['assign:grantextension'] = 'Gi utsettelse';
$string['assign:manageallocations'] = 'Administrer karaktersettere for denne innleveringen.';
$string['assign:managegrades'] = 'Forhåndsvis og publiser karakterer';
$string['assign:manageoverrides'] = 'Administrer innleveringsoverstyringer';
$string['assign:receivegradernotifications'] = 'Motta varsler om karaktersatte innleveringer';
$string['assign:releasegrades'] = 'Publiser karakterer';
$string['assign:revealidentities'] = 'Vis studentenes identitet';
$string['assign:reviewgrades'] = 'Forhåndsvis karakterer';
$string['assign:showhiddengrader'] = 'Se identiteten til den skjulte karaktergiveren.';
$string['assign:submit'] = 'Send inn oppgavesvaret';
$string['assign:view'] = 'Se på oppgave';
$string['assign:viewblinddetails'] = 'Vis brukernes identitet når anonym retting er aktivert.';
$string['assign:viewgrades'] = 'Se karakterer';
$string['assignfeedback'] = 'Tilbakemeldingsmodul';
$string['assignfeedbackpluginname'] = 'Tilbakemeldingsmodul';
$string['assignmentisdue'] = 'Frist for innlevering';
$string['assignmentmail'] = '{$a->grader} har lagt ut en tilbakemelding på din innlevering for \'{$a->assignment}\'.

Du kan se tilbakemeldingen her: {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} har lagt ut en tilbakemelding på din innlevering til \'<i>{$a->assignment}</i>\'</p>
<p> Du kan se tilbakemeldingen <a href="{$a->url}">her</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} har lagt ut en tilbakemelding på din innlevering for \'{$a->assignment}\'.

Den er lagt til innleveringen din.';
$string['assignmentname'] = 'Oppgavenavn';
$string['assignmentplugins'] = 'Oppgavemoduler';
$string['assignmentsperpage'] = 'Oppgaver pr. side';
$string['assignsubmission'] = 'Innsendingsmodul';
$string['assignsubmissionpluginname'] = 'Innsendingsmodul';
$string['attemptheading'] = 'Forsøk {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Tidligere forsøk';
$string['attemptnumber'] = 'Forsøk nummer';
$string['attemptreopenmethod'] = 'Forsøk gjenåpnet';
$string['attemptreopenmethod_help'] = 'Bestemmer hvordan studentinnleveringer skal gjenåpnes. De tilgjengelige alternativene er:
* Aldri - Studentens innlevering kan ikke gjenåpnes.
* Manuelt - Studentens innlevering kan gjenåpnes av en lærer.
* Tillat nytt forsøk helt til innleveringen er bestått - Studentens innlevering blir gjenåpnet automatisk fram til studenten oppnår ståkarakteren som er oppgitt i karakterboken (delen for kategorier og elementer) for denne oppgaven.';
$string['attemptreopenmethod_manual'] = 'Manuelt';
$string['attemptreopenmethod_none'] = 'Aldri';
$string['attemptreopenmethod_untilpass'] = 'Tillat nytt forsøk helt til innleveringen er bestått';
$string['attemptsettings'] = 'Forsøksinnstillinger';
$string['availability'] = 'Tilgjengelighet';
$string['backtoassignment'] = 'Tilbake til innleveringen';
$string['batchoperationconfirmaddattempt'] = 'Tillat et forsøk til for valgte innleveringer?';
$string['batchoperationconfirmdownloadselected'] = 'Laste ned valgte innleveringer?';
$string['batchoperationconfirmgrantextension'] = 'Gi utsettelse til alle valgte innleveringer?';
$string['batchoperationconfirmlock'] = 'Skal alle valgte innsendinger låses?';
$string['batchoperationconfirmremovesubmission'] = 'Fjern valgte innleveringer';
$string['batchoperationconfirmreverttodraft'] = 'Gjøre om de valgte innleveringene til utkast?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Angi tildeling av oppgaver for alle valgte innleveringer?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Angi status for arbeidsflyt for vurdering for alle valgte  innleveringer?';
$string['batchoperationconfirmunlock'] = 'Låse opp alle de valgte innleveringene?';
$string['batchoperationlock'] = 'lås innsendinger';
$string['batchoperationreverttodraft'] = 'Tilbakestill innsendinger til kladd';
$string['batchoperationsdescription'] = 'Med valgte...';
$string['batchoperationunlock'] = 'lås opp innsendinger';
$string['batchsetallocatedmarker'] = 'Angi tildeling for vurdering for {$a} valgte brukere.';
$string['batchsetmarkingworkflowstateforusers'] = 'Angi status for vurderingsarbeidsflyt for {$a} valgte brukere.';
$string['blindmarking'] = 'Anonym karaktersetting';
$string['blindmarking_help'] = 'Anonym karaktersetting skjuler studentenes identitet for den som setter karakter. Innstillingene for anonym karaktersetting låses når en innlevering eller karakter er utført i forbindelse med denne oppgaven.';
$string['blindmarkingenabledwarning'] = 'Anonym karaktersetting er aktivert i denne aktiviteten';
$string['calendardue'] = '{$a} må leveres';
$string['calendargradingdue'] = '{$a} må vurderes';
$string['changefilters'] = 'Endre filtere';
$string['changeuser'] = 'Endre bruker';
$string['choosegradingaction'] = 'Handling for karaktersetting';
$string['choosemarker'] = 'Velg...';
$string['chooseoperation'] = 'Velg handling';
$string['clickexpandreviewpanel'] = 'Klikk for å utvide gjennomgangspanelet';
$string['collapsegradepanel'] = 'Minimer karakterpanelet';
$string['collapsereviewpanel'] = 'Minimer gjennomgangspanelet';
$string['comment'] = 'Kommentar';
$string['completionsubmit'] = 'Studenten må levere inn noe til denne aktiviteten for å fullføre den.';
$string['configshowrecentsubmissions'] = 'Alle kan se merknader til innleveringer i de siste aktivitetsrapporter.';
$string['confirmbatchgradingoperation'] = 'Er du sikker på at du vil {$a->operation} for {$a->count} studenter?';
$string['confirmsubmission'] = 'Er du sikker på at du vil levere inn arbeidet ditt til vurdering? Da kan du ikke gjøre flere endringer.';
$string['confirmsubmissionheading'] = 'Bekreft innlevering';
$string['conversionexception'] = 'Kunne ikke konvertere innleveringen. Unntaket var: {$a}.';
$string['couldnotconvertgrade'] = 'Kunne ikke konvertere innleveringskarakteren til bruker {$a}.';
$string['couldnotconvertsubmission'] = 'Kunne ikke konvertere innleveringen til bruker {$a}.';
$string['couldnotcreatecoursemodule'] = 'Kunne ikke opprette kursmodulen.';
$string['couldnotcreatenewassignmentinstance'] = 'Kunne ikke opprette ny innleveringsinstans.';
$string['couldnotfindassignmenttoupgrade'] = 'Kunne ikke finne noen gammel innleveringsinstanse å oppgradere.';
$string['crontask'] = 'Bakgrunnsprosessering for innleveringsmodulen.';
$string['currentassigngrade'] = 'Nåværende karakter i oppgave';
$string['currentattempt'] = 'Dette er forsøk {$a}.';
$string['currentattemptof'] = 'Dette er forsøk {$a->attemptnumber} ( {$a->maxattempts} forsøk tillatt ).';
$string['currentgrade'] = 'Nåværende karakter i karakterboka';
$string['cutoffdate'] = 'Siste dato for innlevering';
$string['cutoffdate_help'] = 'Hvis denne funksjonen brukes, vil ikke innleveringen godta innsendinger etter denne datoen uten forlengelse.';
$string['cutoffdatecolon'] = 'Stopp-dato: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Siste dato for innlevering må være etter åpningsdatoen for innleveringer.';
$string['cutoffdatevalidation'] = 'Siste dato for innlevering må være etter innleveringsfristen.';
$string['defaultlayout'] = 'Tilbakestil til standardoppsettet';
$string['defaultsettings'] = 'Standardinnstillinger for innleveringsmodulen';
$string['defaultsettings_help'] = 'Disse innstillingene bestemmer standardinnstillingene for alle nye innleveringer.';
$string['defaultteam'] = 'Standardgruppe';
$string['deleteallsubmissions'] = 'Slett alle innleveringer';
$string['description'] = 'Beskrivelse';
$string['disabled'] = 'Deaktivert';
$string['downloadall'] = 'Last ned alle innsendinger';
$string['downloadasfolders'] = 'Last ned innleveringene i separate mapper';
$string['downloadasfolders_help'] = 'Innleveringer kan lastes ned som mapper. Hver innlevering plasseres da i egne mapper og filstrukturen beholdes for eventuelle undermapper. Filene vil beholde filnavnene.';
$string['downloadselectedsubmissions'] = 'Last ned valgte innleveringer';
$string['duedate'] = 'Innleveringsfrist';
$string['duedate_help'] = 'Dette er fristen for innleveringen. Hvis for sene innleveringer tillates, vil alle besvarelser som er levert inn etter denne datoen merkes som forsinket. Angi en siste frist for å forhindre innleveringer etter siste frist.';
$string['duedatecolon'] = 'Frist: {$a}';
$string['duedateno'] = 'Ingen innleveringsfrist';
$string['duedatereached'] = 'Fristen for denne innleveringen har passert.';
$string['duedatevalidation'] = 'Innleveringsfristen må være etter innleveringens åpningsdato.';
$string['duplicateoverride'] = 'Dupliser overstyring';
$string['editaction'] = 'Handlinger...';
$string['editattemptfeedback'] = 'Rediger karakteren og tilbakemeldingen for forsøk nummer {$a}';
$string['editingpreviousfeedbackwarning'] = 'Du redigerer tilbakemeldingen til et tidligere forsøk. Dette er forsøk {$a->attemptnumber} av {$a->totalattempts}.';
$string['editingstatus'] = 'Redigerer status';
$string['editonline'] = 'Rediger online';
$string['editoverride'] = 'Rediger overstyringer';
$string['editsubmission'] = 'Rediger innleveringen';
$string['editsubmission_help'] = 'Du kan fortsatt gjøre endringer på din innlevering';
$string['editsubmissionother'] = 'Rediger innlevering for {$a}';
$string['enabled'] = 'Aktivert';
$string['errornosubmissions'] = 'Det er ingen innleveringer å laste ned';
$string['errorquickgradingvsadvancedgrading'] = 'Karakterene ble ikke lagret fordi denne innleveringen bruker avansert karaktersetting.';
$string['errorrecordmodified'] = 'Karakterene ble ikke lagret fordi noen har endret en eller flere oppføringer siden du lastet siden.';
$string['eventallsubmissionsdownloaded'] = 'Alle innleveringene bli lastet ned.';
$string['eventassessablesubmitted'] = 'En innlevering har blitt levert inn.';
$string['eventbatchsetmarkerallocationviewed'] = 'Innstillinger for automatisk karaktersetting vist';
$string['eventbatchsetworkflowstateviewed'] = 'Innstillinger for automatisk arbeidsflyt vist';
$string['eventextensiongranted'] = 'Det har blitt gitt en utsettelse.';
$string['eventfeedbackupdated'] = 'Feedback er oppdatert';
$string['eventfeedbackviewed'] = 'Feedback er vist';
$string['eventgradingformviewed'] = 'Vurderingsskjema vist';
$string['eventgradingtableviewed'] = 'Vurderingstabell vist';
$string['eventidentitiesrevealed'] = 'Alle identitene har blitt avslørt.';
$string['eventmarkerupdated'] = 'Oppgavetildelingen er oppdatert.';
$string['eventoverridecreated'] = 'Innleveringsoverstyring opprettet';
$string['eventoverridedeleted'] = 'Innleveringsoverstyring slettet';
$string['eventoverrideupdated'] = 'Innleveringsoverstyring slettet';
$string['eventremovesubmissionformviewed'] = 'Fjern innleveringsbekreftelse vist.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Bekreftelsesside for avsløring av brukerindentiteter vist';
$string['eventstatementaccepted'] = 'Brukeren har akseptert innleveringserklæringen';
$string['eventsubmissionconfirmationformviewed'] = 'Bekreftelsesside for innleveringsskjema vist';
$string['eventsubmissioncreated'] = 'Innlevering opprettet';
$string['eventsubmissionduplicated'] = 'Brukeren duplikerte innleveringen sin';
$string['eventsubmissionformviewed'] = 'Innleveringsskjema vist';
$string['eventsubmissiongraded'] = 'Det har blitt satt en karakter på innleveringen.';
$string['eventsubmissionlocked'] = 'Innleveringen har blitt låst for en bruker';
$string['eventsubmissionstatusupdated'] = 'Innleveringsstatusen har blitt oppdatert';
$string['eventsubmissionstatusviewed'] = 'Innleveringsstatus har blitt sett.';
$string['eventsubmissionunlocked'] = 'Innleveringen har blitt låst opp for en bruker.';
$string['eventsubmissionupdated'] = 'Brukeren har lagret en innlevering';
$string['eventsubmissionviewed'] = 'Innlevering sett.';
$string['eventworkflowstateupdated'] = 'Status for vurderingsarbeidsflyt er oppdatert.';
$string['expandreviewpanel'] = 'Utvid gjennomgangspanel';
$string['extensionduedate'] = 'Frist for forlengelse';
$string['extensionnotafterduedate'] = 'Frist for forlengelse må være etter ordinær frist.';
$string['extensionnotafterfromdate'] = 'Frist for forlengelse må være etter åpningsdatoen for innleveringer.';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackavailableanonhtml'] = 'Du har tilbakeeldinger på innleveringen din for <i>{$a->assignment}</i>\'<br /><br />
Du kan se den som vedlegg til  <a href="{$a->url}">innleveringen</a>.';
$string['feedbackavailableanonsmall'] = 'Ny tilbakemelding for innleveringen {$a->assignment}';
$string['feedbackavailableanontext'] = 'Du har fått en ny tilbakemelding på innleveringen din for \'{$a->assignement}\'

Du kan se den her: {$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} har postet tilbakemeldinger på innleveringen din for \'<i>{$a->assignment}</i>\'<br /><br /> Du kan se tilbakemeldingen <a href="{$a->url}">her</a>.';
$string['feedbackavailablesmall'] = '{$a->username} har gitt tilbakemelding på innleveringen {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} har postet en tilbakemelding på innleveringen for \'{$a->assignment}\'

Du kan se tilbakemeldingen her: {$a->url}';
$string['feedbackplugin'] = 'Tilbakemeldingsmodul';
$string['feedbackpluginforgradebook'] = 'Modul for tilbakemeldinger som vil presse kommentarer til karakterboken.';
$string['feedbackpluginforgradebook_help'] = 'Bare en modul for tilbakemeldinger kan flytte tilbakemeldinger inn i karakterboken.';
$string['feedbackplugins'] = 'Tilbakemeldingsmoduler';
$string['feedbacksettings'] = 'Innstillinger for tilbakemelding';
$string['feedbacktypes'] = 'Tilbakemeldingstyper';
$string['filesubmissions'] = 'Filinnsendiger';
$string['filter'] = 'Filter';
$string['filtergrantedextension'] = 'Innvilget utsettelse';
$string['filternone'] = 'Ingen filter';
$string['filternotsubmitted'] = 'Ikke levert';
$string['filterrequiregrading'] = 'Ikke vurdert ennå';
$string['filtersubmitted'] = 'Levert';
$string['fixrescalednullgrades'] = 'Innleveringen inneholder noen karakterer med feil. Du kan  <a href="{$a->link}"> automatisk fikse disse feilene. </a> Dette kan få betydning for beregning av kurstotaler.';
$string['fixrescalednullgradesconfirm'] = 'Er du sikker på at du vil fikse karakter med feil automatisk? Alle berørte karakterer blir fjernet. Dette kan få betydning for beregning av kurstotaler.';
$string['fixrescalednullgradesdone'] = 'Karakterer fikset.';
$string['gradeabovemaximum'] = 'Karakteren må være mindre enn eller lik {$a}.';
$string['gradebelowzero'] = 'Karakteren må være høyere enn eller lik null.';
$string['gradecanbechanged'] = 'Karakter kan endres';
$string['gradechangessaveddetail'] = 'Endringene i vurdering og tilbakemelding ble lagret';
$string['graded'] = 'Karaktersatt';
$string['gradedby'] = 'Vurdert av';
$string['gradedfollowupsubmit'] = 'Vurdert - oppfølgingsinnlevering mottatt';
$string['gradedon'] = 'Vurdert den';
$string['gradeitem:submissions'] = 'Innleveringer';
$string['gradelocked'] = 'Denne karakteren er låst eller overstyrt i karakterboken.';
$string['gradeoutof'] = 'Karakter av {$a} mulige.';
$string['gradeoutofhelp'] = 'Karakter';
$string['gradeoutofhelp_help'] = 'Skriv karakteren på studentens innlevering her. Du kan bruke desimaler hvis du ønsker det.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} har oppdatert sin innlevering
for <i>\'{$a->assignment}\'  {$a->timeupdated}</i><br /><br />
Den er <a href="{$a->url}">tilgjengelig på nettstedet</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} har oppdatert besvarelsen sin for innleveringen {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} har oppdatert innleveringen sin for \'{$a->assignment}\'  {$a->timeupdated}

Den er tilgjengelig her:

{$a->url}';
$string['gradestudent'] = 'Gi karakter til student: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Karakter {$a}';
$string['grading'] = 'Karaktersetting';
$string['gradingchangessaved'] = 'Karakterendringene ble lagret';
$string['gradingduedate'] = 'Påminn meg om å vurdere innen';
$string['gradingduedate_help'] = 'Den forventede datoen for fullføring av karaktersetting/vurdering av innleveringene. Denne datoen brukes til å prioritere startside-varsler for lærere.';
$string['gradingdueduedatevalidation'] = 'Datobasert "minn meg på å vurdere" kan ikke være tidligere enn fristen for innleveringen.';
$string['gradingduefromdatevalidation'] = 'Datobasert "minn meg på å vurdere" kan ikke være tidligere enn fristen for når innleveringer kan starte.';
$string['gradingmethodpreview'] = 'Kriterier for karaktersetting';
$string['gradingoptions'] = 'Innstillinger';
$string['gradingstatus'] = 'Karaktersettingsstatus';
$string['gradingstudent'] = 'Gir karakter til student';
$string['gradingsummary'] = 'Oversikt over karakterer';
$string['grantextension'] = 'Gi forlengelse';
$string['grantextensionforusers'] = 'Gi forlengelse til {$a} studenter';
$string['groupoverrides'] = 'Gruppeoverstyring';
$string['groupoverridesdeleted'] = 'Gruppeoverstyring slettet';
$string['groupsnone'] = 'Det er ingen grupper i dette kurset som du har tilgang til.';
$string['groupsubmissionsettings'] = 'Innstillinger for gruppeinnleveringer';
$string['hiddenuser'] = 'Deltaker';
$string['hidegrader'] = 'Skjul karaktergivers identitet for studentene';
$string['hidegrader_help'] = 'Hvis det er aktivert, vises ikke identiteten til brukeren som bedømmer en oppgaveinnlevering, slik at studentene ikke kan se hvem som vurderte arbeidet.

Merk at denne innstillingen ikke har noen innvirkning på kommentarfeltet på karaktersiden.';
$string['hideshow'] = 'Skjul/Vis';
$string['inactiveoverridehelp'] = '*Deltakeren har ikke den korrekte rollen eller gruppen til å gjennomføre innleveringen';
$string['indicator:cognitivedepth'] = 'Kognitiv innlevering';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på den kognitive dybden en student oppnår gjennom en innleveringsaktivitet.';
$string['indicator:cognitivedepthdef'] = 'Kognitive ferdigheter';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av oppdragsaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, Vis, Send, Se tilbakemelding, Kommenter tilbakemelding, Send inn igjen etter å ha sett tilbakemelding)';
$string['indicator:socialbreadth'] = 'Sosial innlevering';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på den sosiale bredden en student oppnår gjennom en innleveringsaktivitet.';
$string['indicator:socialbreadthdef'] = 'Sosiale ferdigheter';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av oppdragsaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene, deltaker med andre)';
$string['instructionfiles'] = 'Instruksjonsfiler';
$string['introattachments'] = 'Tilleggsfiler';
$string['introattachments_help'] = 'Tilleggsfiler for bruk i innleveringen, f.eks. en svarmal, kan legges til. Nedlastingslenker vil bli vist under beskrivelsen av innleveringen.';
$string['invalidfloatforgrade'] = 'Den oppgitte karakteren ble ikke forstått: {$a}';
$string['invalidgradeforscale'] = 'Den oppgitte karakteren var ikke gyldig for den gjeldende skalaen.';
$string['invalidoverrideid'] = 'Ugylidg overstyringsID';
$string['lastmodifiedgrade'] = 'Sist endret (karakter)';
$string['lastmodifiedsubmission'] = 'Sist endret (innsending)';
$string['latesubmissions'] = 'Sene innleveringer';
$string['latesubmissionsaccepted'] = 'Tillat inntil {$a}';
$string['loading'] = 'Laster...';
$string['locksubmissionforstudent'] = 'Forhindre flere innleveringer fra student: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Lås innsendinger';
$string['manageassignfeedbackplugins'] = 'Administrere moduler for tilbakemeldinger på innleveringer';
$string['manageassignsubmissionplugins'] = 'Administrere moduler for innsending av innleveringer';
$string['marker'] = 'Karaktersetter';
$string['markerfilter'] = 'Rettefilter';
$string['markerfilternomarker'] = 'Ingen markering';
$string['markingallocation'] = 'Bruk tildeling av oppgaver for vurdering';
$string['markingallocation_help'] = 'Når aktivert vil denne innstillingen gjøre det mulig å tildele studenter individuelt til karaktersetterne. Dette krever at arbeidsflyt for vurdering er aktivert.';
$string['markingworkflow'] = 'Bruk arbeidsflyt for karaktersetting';
$string['markingworkflow_help'] = 'Hvis aktivert, vil vurderingen foregå som en del av en arbeidsflyt før den publiseres til studentene. Dette åpner for flere runder med vurdering av oppgavene og at endelig vurdering publiseres til studentene til samme tid.';
$string['markingworkflowstate'] = 'Status for arbeidsflyt';
$string['markingworkflowstate_help'] = 'Mulige arbeidsflytstadier kan inkludere (avhengig av dine rettigheter):

* Ikke vurdert - vurderingen har ennå ikke startet.
* Under vurdering - vurderingen pågår, men er ikke avsluttet.
* Til gjennomgang - vurderingen er nå til gjennomgang av en ansvarlig lærer for kvalitetssjekk.
* Klar for publisering - ansvarlig lærer er fornøyd med vurderingen, men vil vente med å publisere resultatene for studentene.
* Publisert - studenten gis tilgang til vurdering og tilbakemelding.';
$string['markingworkflowstateinmarking'] = 'Under retting';
$string['markingworkflowstateinreview'] = 'Blir vurdert';
$string['markingworkflowstatenotmarked'] = 'Ikke vurdert';
$string['markingworkflowstatereadyforrelease'] = 'Klar for publisering';
$string['markingworkflowstatereadyforreview'] = 'Karaktersetting fullført';
$string['markingworkflowstatereleased'] = 'Publisert';
$string['maxattempts'] = 'Maks antall forsøk';
$string['maxattempts_help'] = 'Maks antall innleveringsforsøk som kan gjøres av en student. Etter dette antallet har blitt levert kan ikke studenten gjenåpne innleveringen.';
$string['maxgrade'] = 'Høyeste karakter';
$string['maxperpage'] = 'Maks antall innleveringer pr side';
$string['maxperpage_help'] = 'Maksimum antall innleveringer en som vurderer kan vise samtidig på en vurderingsside. Nyttig når det er veldig mange innleveringer.';
$string['messageprovider:assign_notification'] = 'Innleveringsvarsler';
$string['modulename'] = 'Innlevering';
$string['modulename_help'] = 'Aktivitetsmodulen "Innlevering" gjør det mulig for læreren å annonsere oppgaver, samle inn studentenes arbeid, og gi karakterer og tilbakemeldinger.

Studentene kan levere inn alt slags digitalt innhold (filer), for eksempel tekstbehandlingsdokumenter, regneark, bilder, eller lyd- og videoklipp. Som et alternativ, eller i tillegg, kan innleveringen kreve at studentene skal skrive inn tekst direkte i teksteditoren. Innleveringer kan også brukes til å minne studentene på praktiske oppgaver som de må fullføre utenfor internett som ikke krever noe digitalt innhold, for eksempel en oppgave innen kunst og håndverk. Studentene kan levere inn arbeider individuelt eller som medlem av en gruppe.

Når innleveringene gjennomgås, kan lærerne legge til tilbakemeldinger og kommentarer og laste opp filer, f.eks. ferdig vurderte innleveringer, dokumenter med kommentarer, eller innspilte lydfiler med tilbakemeldinger. Vurdering av innleveringer kan skje ved bruk av numerisk eller egendefinert karaktersettingsmetode, f.eks. en rubrikk. Endelige karakterer registreres i karakterboken.';
$string['modulenameplural'] = 'Innleveringer';
$string['moreusers'] = '{$a} mer...';
$string['multipleteams'] = 'Medlem av mer enn en gruppe';
$string['multipleteams_desc'] = 'Denne innleveringen krever gruppeinnlevering. Du er medlem av mer enn en gruppe. For å kunne levere kan du kun være medlem av en enkelt gruppe. Vennligst kontakt læreren din for å endre gruppemedlemsskapene dine.';
$string['multipleteamsgrader'] = 'Medlem av mer enn en gruppe, så kan ikke levere inn noe.';
$string['mysubmission'] = 'Min innlevering:';
$string['newsubmissions'] = 'Leverte besvarelser';
$string['noattempt'] = 'Ingen forsøk';
$string['noclose'] = 'Ingen avslutningsdato';
$string['nofiles'] = 'Ingen filer.';
$string['nofilters'] = 'Ingen filtere';
$string['nograde'] = 'Ingen karakter.';
$string['nolatesubmissions'] = 'Ingen sene innleveringer godtas.';
$string['nomoresubmissionsaccepted'] = 'Kun for deltakere som har fått innvilget en utsettelse';
$string['none'] = 'Ingen';
$string['noonlinesubmissions'] = 'Denne innleveringen krever ikke at du skal levere inn noe på nett.';
$string['noopen'] = 'Ingen startdato';
$string['nooverridedata'] = 'Du må overstyre minst en av innleveringsinnstillingene';
$string['nosavebutnext'] = 'Neste';
$string['nosubmission'] = 'Ingenting har blitt levert inn til denne innleveringen.';
$string['nosubmissionsacceptedafter'] = 'Ingen innleveringer godtas etter';
$string['noteam'] = 'Ikke medlem av noen grupper.';
$string['noteam_desc'] = 'Denne innleveringen krever gruppeinnlevering. Du er ikke medlem av noen gruppe, og kan dermed ikke levere inn noe. Vennligst kontakt læreren din for å bli lagt til i en gruppe.';
$string['noteamgrader'] = 'Ikke medlem av noen grupper, så kan ikke levere inn noe.';
$string['notgraded'] = 'Ikke vurdert';
$string['notgradedyet'] = 'Ikke satt karakter enda';
$string['notifications'] = 'Meldinger';
$string['notsubmittedyet'] = 'Ikke levert enda';
$string['nousers'] = 'Ingen brukere';
$string['nousersselected'] = 'Ingen brukere valgt';
$string['numberofdraftsubmissions'] = 'Utkast';
$string['numberofparticipants'] = 'Deltakere';
$string['numberofsubmissionsneedgrading'] = 'Må vurderes';
$string['numberofsubmittedassignments'] = 'Levert';
$string['numberofteams'] = 'Grupper';
$string['offline'] = 'Ingen innleveringer på nett påkrevd';
$string['open'] = 'Åpen';
$string['outlinegrade'] = 'Karakter: {$a}';
$string['outof'] = '{$a->current} av {$a->total}';
$string['overdue'] = '<font color="red">Innleveringen er forsinket med: {$a}</font>';
$string['override'] = 'OVerstyr';
$string['overridedeletegroupsure'] = 'Er du sikker på at du ønsker å slette overstryingen for gruppe {$a}?';
$string['overridedeleteusersure'] = 'Er du sikker på at du ønsker å slette overstryingen for bruker {$a}?';
$string['overridegroup'] = 'Overstyr gruppe';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Overstyringer';
$string['overrideuser'] = 'Overstyr bruker';
$string['overrideusereventname'] = '{$a->assign} - Overstyr';
$string['page-mod-assign-view'] = 'Forsiden og innleveringssiden i innleveringsmodulen';
$string['page-mod-assign-x'] = 'Alle sider i oppgavemodulen';
$string['paramtimeremaining'] = '{$a} igjen';
$string['participant'] = 'Deltaker';
$string['pluginadministration'] = 'Administrering av innlevering';
$string['pluginname'] = 'Innlevering';
$string['preventsubmissionnotingroup'] = 'Krev gruppe for å levere inn';
$string['preventsubmissionnotingroup_help'] = 'Når aktivert, vil elever som ikke er meldt inn i en gruppe ikke få lov til å levere inn.';
$string['preventsubmissions'] = 'Forhindre brukeren fra å levere inn flere besvarelser til denne innleveringen.';
$string['preventsubmissionsshort'] = 'Forhindre endringer i innleveringer';
$string['previous'] = 'Forrige';
$string['privacy:attemptpath'] = 'forsøk {$a}';
$string['privacy:blindmarkingidentifier'] = 'Indentifikatoren brukt for anonym karaktergiving';
$string['privacy:gradepath'] = 'Karakter';
$string['privacy:metadata:assigndownloadasfolders'] = 'En brukerpreferanse for om massefilinnleveringer skal lastes ned i mapper.';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Tilbakemeldingsdata for innleveringen.';
$string['privacy:metadata:assignfilter'] = 'Filtreringsvalg som \'Levert\', \'Ikke lever\', \'Trenger karakter\' og \'Innvilget utsettelse\\';
$string['privacy:metadata:assigngrades'] = 'Lagrer brukernes karakterer i innleveringen.';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtrer innleveringsoversiktetn på tildelt karaktersetter.';
$string['privacy:metadata:assignmentid'] = 'InnleveringsID';
$string['privacy:metadata:assignmessageexplanation'] = 'Meldinger sendes til deltakerne gjennom meldingssystemet.';
$string['privacy:metadata:assignoverrides'] = 'Lagrer overstyringsinformasjon for innleveringen';
$string['privacy:metadata:assignperpage'] = 'Antall innleveringer vist per side.';
$string['privacy:metadata:assignquickgrading'] = 'En preferanse for om hurtig karaktergiving skal brukes eller ikke.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Lagrer brukerinnleveringsinformasjon';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Innleveringsinformasjon for innleveringsoppgaven.';
$string['privacy:metadata:assignuserflags'] = 'Lagrer brukermetadata som utsettelsesdatoer';
$string['privacy:metadata:assignusermapping'] = 'Mappingen for anonym kkaraktergiving';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtrer etter ulike arbeidsflytstadier.';
$string['privacy:metadata:grade'] = 'Den numeriske karakteren for denne innleveringen. Kan bestemmes av skalaer eller karaktersettingsskjemaer e.l. men vil alltid konverteres tilbake til et tall.';
$string['privacy:metadata:grader'] = 'BrukerID\'en til personen som karaktersetter.';
$string['privacy:metadata:groupid'] = 'GruppeID\'en som brukeren er medlem av.';
$string['privacy:metadata:latest'] = 'En stor forenkling i spørringer for å finne informasjonen knyttet til det siste forsøket.';
$string['privacy:metadata:mailed'] = 'Har denne brukeren fått epost?';
$string['privacy:metadata:timecreated'] = 'Opprettet';
$string['privacy:metadata:userid'] = 'Brukerens ID';
$string['privacy:studentpath'] = 'studentinnleveringer';
$string['privacy:submissionpath'] = 'innnlevering';
$string['quickgrading'] = 'Hurtig karaktersetting';
$string['quickgrading_help'] = 'Hurtig karaktersetting lar deg tildele karakterer (og resultater) direkte i innleveringstabellen. Hurtig karaktersetting er ikke forenelig med avansert karaktersetting, og er ikke anbefalt når det er flere lærere involvert i karaktersettingen.';
$string['quickgradingchangessaved'] = 'Endringene i karakterene ble lagret';
$string['quickgradingresult'] = 'Hurtig karaktersetting';
$string['recordid'] = 'Identifikator';
$string['relativedatessubmissionduedateafter'] = '{$a->datediffstr} etter kursstart';
$string['relativedatessubmissionduedatebefore'] = '{$a->datediffstr} før kursstart';
$string['relativedatessubmissiontimeleft'] = 'Beregnet for hver student';
$string['removeallgroupoverrides'] = 'Slett alle gruppeoverstyringer';
$string['removealluseroverrides'] = 'Slett alle brukeroverstyringer';
$string['removesubmission'] = 'Fjern innlevering';
$string['removesubmissionconfirm'] = 'Er du sikker på at du ønsker å fjerne innleveringen?';
$string['removesubmissionconfirmforstudent'] = 'Er du sikker på at du ønsker å fjerne innleveringen for {$a}?';
$string['removesubmissionforstudent'] = 'Fjern innlevering for: (id = {$a->id}, navn = {$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Åpen til bestått er ikke kombatibelt med anonym retting fordi karakterene ikke sendes til karakterboka før brukernes identitet er avslørt.';
$string['requireallteammemberssubmit'] = 'Krev at alle gruppemedlemmer leverer';
$string['requireallteammemberssubmit_help'] = 'Hvis denne funksjonen er aktivert, må alle medlemmene i studentgruppen klikke på send-knappen i denne innleveringen for at gruppeinnleveringen skal telle som levert. Hvis den er deaktivert, blir gruppeinnleveringen registrert som levert så fort et medlem av studentgruppen klikker på send-knappen.';
$string['requiresubmissionstatement'] = 'Krev at studentene skal godta innleveringserklæringen';
$string['requiresubmissionstatement_help'] = 'Krev at studentene skal godta innleveringserklæringen for alle innleveringene på denne oppgaven.';
$string['revealidentities'] = 'Vis studentidentiteter';
$string['revealidentitiesconfirm'] = 'Er du sikker på at du vil vise studentidentitetene i denne innleveringen? Denne handlingen kan ikke omgjøres. Så fort studentidentitetene har blitt vist, blir karakterene frigitt til karakterboken.';
$string['reverttodefaults'] = 'Tilbakestill til innleveringens standardinnstillinger';
$string['reverttodraft'] = 'Tilbakestill innleveringen til utkast-status';
$string['reverttodraftforstudent'] = 'Tilbakestill innleveringen til utkast for student:  (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Tilbakestill innleveringen til utkast';
$string['reviewed'] = 'Gjennomlest';
$string['save'] = 'Lagre';
$string['saveallquickgradingchanges'] = 'Lagre alle endringene i hurtig karaktersetting';
$string['saveandcontinue'] = 'Lagre og fortsett';
$string['savechanges'] = 'Lagre endringer';
$string['savegradingresult'] = 'Karakter';
$string['savenext'] = 'Lagre og vis neste';
$string['saveoverrideandstay'] = 'Lagre og opprett en ny overstyring';
$string['savingchanges'] = 'Lagrer endringer...';
$string['scale'] = 'Skala';
$string['search:activity'] = 'Innlevering - aktivitetsinformasjon';
$string['selectedusers'] = 'Valgte brukere';
$string['selectlink'] = 'Velg...';
$string['selectuser'] = 'Velg {$a}';
$string['sendlatenotifications'] = 'Varsle karaktergivere om sene innleveringer';
$string['sendlatenotifications_help'] = 'Hvis denne funksjonen er aktivert, vil karaktergivere (vanligvis lærere) motta en melding når studenter leverer en besvarelse sent. Meldingsmetoder kan konfigureres.';
$string['sendnotifications'] = 'Varsle karaktergivere om innleveringer';
$string['sendnotifications_help'] = 'Hvis denne funksjonen er aktivert, vil karaktergivere (vanligvis lærere) motta en melding når studenter leverer en besvarelse tidlig, til rett tid og sent. Meldingmetoder kan konfigureres.';
$string['sendstudentnotifications'] = 'Varsle studenter';
$string['sendstudentnotifications_help'] = 'Hvis aktivert vil studentene få en melding om oppdatert karakter eller tilbakemelding. Hvis arbeidsflyt er aktivert i innleveringen, vil varsling først sendes når karaktereren har status publisert.';
$string['sendstudentnotificationsdefault'] = 'Standardinnstilling for å varsle studenter';
$string['sendstudentnotificationsdefault_help'] = 'Bestem standardinnstillingen for avkrysningsboksen "Varsle studenter" på karakterskjemaet';
$string['sendsubmissionreceipts'] = 'Send innleveringskvittering til studentene';
$string['sendsubmissionreceipts_help'] = 'Denne bryteren vil aktivere innleveringskvitteringer for studenter. Studentene vil motta en melding hver gang de leverer inn en besvarelse.';
$string['setmarkerallocationforlog'] = 'Angi vurderingstildelig : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Angi hvem som skal vurdere';
$string['setmarkingworkflowstate'] = 'Angi fase i vurderingsarbeidsflyt';
$string['setmarkingworkflowstateforlog'] = 'Angi fase i arbeidsflyt: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Innleveringsinnstillinger';
$string['showrecentsubmissions'] = 'Vis nylige innleveringer';
$string['status'] = 'Status';
$string['studentnotificationworkflowstateerror'] = 'Status for automatisk arbeidsflyt må være satt til "Publisert" for at studentene skal varsles.';
$string['submission'] = 'Innlevering';
$string['submissioncopiedhtml'] = '<p>Du har laget en kopi av din tidligere oppgavebesvarelse for \'<i>{$a->assignment}</i>\'</p>
<p> Du kan se statusen på din <a href="{$a->url}">innlevering</a>.</p>';
$string['submissioncopiedsmall'] = 'Du har laget en kopi av din tidligere oppgavebesvarelse for {$a->assignment}';
$string['submissioncopiedtext'] = 'Du har laget en kopi av din tidligere oppgavebesvarelse for \'{$a->assignment}\'

Du kan se statusen på din innlevering:

 {$a->url}';
$string['submissiondrafts'] = 'Krev at studentene klikker på levér-knappen';
$string['submissiondrafts_help'] = 'Hvis denne funksjonen er aktivert, vil studentene måtte klikke på Lever-knappen for å erklære at innleveringen deres er endelig. Dette gjør det mulig for studentene å beholde et utkast av innleveringen i systemet. Hvis denne innstillingen endres fra "Nei" til "Ja" etter studentene allerede har levert, vil de innleveringene bli regnet som endelige.';
$string['submissioneditable'] = 'Studenter kan redigere denne innleveringen';
$string['submissionempty'] = 'Ingenting ble sendt inn';
$string['submissionlog'] = 'Student: {$a->fullname}, Status: {$a->status}';
$string['submissionmodified'] = 'Du har eksisterende innleveringsdata. Vennligst forlat denne siden og prøv på nytt.';
$string['submissionmodifiedgroup'] = 'Innlevering har blitt endret av noen andre. Vennligst forlat siden og prøv på nytt.';
$string['submissionnotcopiedinvalidstatus'] = 'Innleveringen ble ikke kopiert fordi den har blitt redigert siden den ble gjenåpnet.';
$string['submissionnoteditable'] = 'Studenter kan ikke redigere denne innleveringen';
$string['submissionnotready'] = 'Denne oppgavebesvarelsen er ikke klar til innlevering:';
$string['submissionplugins'] = 'Innleveringsmoduler';
$string['submissionreceipthtml'] = '<p>Du har levert en oppgavebesvarelse for \'<i>{$a->assignment}</i>\'</p>
<p> Du kan se status på din<a href="{$a->url}">innlevering</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Besvarelsen din for oppgaven \'<i>{$a->assignment}</i>\' er nå lever. <br /><br />
Du kan se statusen for <a href="{$a->url}">innleveringen din her</a>.';
$string['submissionreceiptothersmall'] = 'Innleveringen din for oppgaven {$a->assignment} er nå levert.';
$string['submissionreceiptothertext'] = 'Innleveringen din for oppgaven
\'{$a->assignment}\' er nå levert.

Du kan se statusen for besvarelsen din her:

    {$a->url}';
$string['submissionreceipts'] = 'Send innleveringskvitteringer';
$string['submissionreceiptsmall'] = 'Du har levert din oppgavebesvarelse for {$a->assignment}';
$string['submissionreceipttext'] = 'Du har levert en oppgavebesvarelse for {$a->assignment}

Du kan se status på din innlevering:  {$a->url}';
$string['submissionsclosed'] = 'Innleveringene er stengt';
$string['submissionsettings'] = 'Innstillinger for innlevering';
$string['submissionslocked'] = 'Denne innleveringen tar ikke imot innleveringer';
$string['submissionslockedshort'] = 'Endringer i innleveringer ikke tillatt';
$string['submissionsnotgraded'] = 'Innleveringer ikke karaktersatt: {$a}';
$string['submissionstatement'] = 'Innleveringserklæring';
$string['submissionstatement_help'] = 'Brukeravtale som hver student må akseptere for å få levert inn arbeidet sitt.';
$string['submissionstatementacceptedlog'] = 'Innleveringserklæring godtatt av bruker {$a}';
$string['submissionstatementdefault'] = 'Denne innleveringen er mitt eget arbeid, unntatt der hvor jeg har erkjent at jeg har brukt andres ideer og arbeid.';
$string['submissionstatementteamsubmission'] = 'Gruppeinnleveringserklæring';
$string['submissionstatementteamsubmission_help'] = 'Brukeravtale studenten må akseptere for å levere inn gruppens arbeid.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Gruppeinnleveringserklæring der alle gruppemedlemmer skal levere inn';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Brukeravtale studenten må akseptere for å levere inn som et gruppemedlem.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Denne innleveringen er mitt eget arbeid som et gruppemedlem, med unntak av der jeg har anerkjent bruken av andres arbeid.';
$string['submissionstatementteamsubmissiondefault'] = 'Denne innlevering er min gruppes arbeid, med unntak av der vi har anerkjent bruken av andres arbeid.';
$string['submissionstatus'] = 'Status på innlevering';
$string['submissionstatus_'] = 'Ingen innlevering';
$string['submissionstatus_draft'] = 'Utkast (ikke levert)';
$string['submissionstatus_marked'] = 'Karaktersatt';
$string['submissionstatus_new'] = 'Ingen innlevering';
$string['submissionstatus_reopened'] = 'Gjenåpnet';
$string['submissionstatus_submitted'] = 'Levert til vurdering';
$string['submissionstatusheading'] = 'Status på innlevering';
$string['submissionsummary'] = '{$a->status}. Sist endret {$a->timemodified}';
$string['submissionteam'] = 'Gruppe';
$string['submissiontypes'] = 'Innleveringstyper';
$string['submitaction'] = 'Levér';
$string['submitassignment'] = 'Levér besvarelsen';
$string['submitassignment_help'] = 'Når du har levert denne oppgavebesvarelsen, vil du ikke kunne gjøre flere endringer.';
$string['submitforgrading'] = 'Lever for karaktersetting';
$string['submitted'] = 'Levert';
$string['submittedearly'] = 'Oppgavebesvarelsen ble levert {$a} for tidlig.';
$string['submittedlate'] = 'Oppgavebesvarelsen ble levert {$a} for sent.';
$string['submittedlateshort'] = '{$a} for sent';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Feedbackmodul';
$string['subplugintype_assignfeedback_plural'] = 'Feedbackmoduler';
$string['subplugintype_assignsubmission'] = 'Innleveringsmodul';
$string['subplugintype_assignsubmission_plural'] = 'Innleveringsmoduler';
$string['teamname'] = 'Team: {$a}';
$string['teamsubmission'] = 'Studenter leverer i grupper';
$string['teamsubmission_help'] = 'Hvis denne funksjonen er aktivert, blir studentene delt inn i grupper basert på standard gruppesett eller egendefinert tilgangsgruppe. En gruppeinnlevering vil bli delt mellom gruppemedlemmene, og alle gruppens medlemmer vil se hverandres endringer på innleveringen.';
$string['teamsubmissiongroupingid'] = 'Tilgangsgruppe for studentgrupper';
$string['teamsubmissiongroupingid_help'] = 'Dette er tilgangsgruppen som innleveringen vil bruke for å finne grupper til studentgrupper. Hvis ingenting er angitt, blir standard gruppesett brukt.';
$string['textinstructions'] = 'Innleveringsanvisninger';
$string['timemodified'] = 'Sist endret';
$string['timeremaining'] = 'Tid som gjenstår';
$string['timeremainingcolon'] = 'Tid som gjenstår: {$a}';
$string['togglezoom'] = 'Zoom inn/ut av region';
$string['ungroupedusers'] = 'Innstillingen \'Krev gruppe for å levere\' er slått på, men noen brukere er enten ikke medlem av noen grupper eller medlem i flere grupper. Dette vil forhindre dem fra å levere inn noe.';
$string['ungroupedusersoptional'] = 'Innstillingen \'Studenter kan levere i grupper\' er aktivert og noen brukere er enten ikke medlemmer av noen gruppe eller i mer enn en gruppe. Vennligst vær klar over at disse studentene vil foreta innleveringen som medlem av \'Standard gruppe\'.';
$string['unlimitedattempts'] = 'Ubegrenset';
$string['unlimitedattemptsallowed'] = 'Ubegrenset antall forsøk tillatt.';
$string['unlimitedpages'] = 'Ubegrenset';
$string['unlocksubmissionforstudent'] = 'Tillat innleveringer for student: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Lås opp innleveringer';
$string['unsavedchanges'] = 'Ulagrede endringer';
$string['unsavedchangesquestion'] = 'Det er ulagrede endringer på vurderinger og tilbakemeldinger. Ønsker du å lagre endringene og fortsette?';
$string['updategrade'] = 'Oppdater karakter';
$string['updatetable'] = 'Lagre og oppdater tabell';
$string['upgradenotimplemented'] = 'Oppgradering ikke implementert i modul ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Standarder for brukerinnleveringer';
$string['userextensiondate'] = 'Forlengelse innvilget til: {$a}';
$string['usergrade'] = 'Brukers karakter';
$string['useridlistnotcached'] = 'Kunne ikke lagre. Moodle kunne ikke finne ut hvilken bruker som skulle ha karakteren.';
$string['useroverrides'] = 'Brukeroverstyringer';
$string['useroverridesdeleted'] = 'Brukeroverstyringer slettet';
$string['usersnone'] = 'Ingen deltakere har tilgang til denne innleveringen';
$string['usersubmissioncannotberemoved'] = 'Innleveringen til {$a} kan ikke fjernes.';
$string['userswhoneedtosubmit'] = 'Brukere som må levere: {$a}';
$string['validmarkingworkflowstates'] = 'Gyldig fase i vurderingsarbeidsflyt';
$string['viewadifferentattempt'] = 'Vis et annet forsøk';
$string['viewbatchmarkingallocation'] = 'Vis massehåndteringssiden for tildeling av oppgaver.';
$string['viewbatchsetmarkingworkflowstate'] = 'Vis massehåndteringsside for vurderingsarbeidsflyt.';
$string['viewfeedback'] = 'Vis tilbakemelding';
$string['viewfeedbackforuser'] = 'Vis tilbakemelding for bruker: {$a}';
$string['viewfull'] = 'Vis hele';
$string['viewfullgradingpage'] = 'Åpne karaktersettingssiden fullt ut for å gi tilbakemelding';
$string['viewgradebook'] = 'Vis karakterboken';
$string['viewgrading'] = 'Vis alle innleveringer';
$string['viewgradingformforstudent'] = 'Vis karaktersiden for student: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Vis egen innleveringsside for oppgavebesvarelse.';
$string['viewownsubmissionstatus'] = 'Vis statussiden for egen innlevering';
$string['viewrevealidentitiesconfirm'] = 'Se side for visning av bekreftelse på studentidentitet';
$string['viewsubmission'] = 'Vis innlevering';
$string['viewsubmissionforuser'] = 'Vis innlevering for bruker: {$a}';
$string['viewsubmissiongradingtable'] = 'Vis karaktersettingstabell for innlevering';
$string['viewsummary'] = 'Vis oppsummering';
$string['workflowfilter'] = 'Filter for arbeidsflyt';
$string['xofy'] = '{$a->x} av {$a->y}';
