<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_mongodb', language 'no', version '3.8'.
 *
 * @package     cachestore_mongodb
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['database'] = 'Database';
$string['database_help'] = 'Navnet på databasen du vil bruke.';
$string['extendedmode'] = 'Bruk utvidede nøkler';
$string['extendedmode_help'] = 'Hvis aktivert vil fulle nøkkelsett brukes når du arbeider med modulen. Dette er ikke i bruk internt ennå, men vil tillate deg å enkelt søke og undersøke MongoDB modulen manuelt hvis du ønsker det. Slås dette på vil det medføre en liten overhead, så du bør bare gjøres hvis du trenger det.';
$string['password'] = 'Passord';
$string['password_help'] = 'Passordet til brukeren som benyttes for tilkoblingen.';
$string['pleaseupgrademongo'] = 'Du bruker en gammel versjon av PHP Mongo-tillegget (< 1.3). Support for eldre versjoner av Mongo-tillegget vil bli droppet i framtiden. Vennligst vurder om du skal oppgradere med det samme.';
$string['pluginname'] = 'MongoDB';
$string['privacy:metadata:mongodb'] = 'Modulen "MongoDB cachestore" lagrer data i kort tid som en del av sin mellomlagringsfunksjonalitet. Dataene lagres på en MongoDBserver der data regelmessig blir fjernet.';
$string['privacy:metadata:mongodb:data'] = 'De ulike dataene lagret i cachen.';
$string['replicaset'] = 'Replikering satt';
$string['replicaset_help'] = 'Navnet på replikasett som skal kobles til. Hvis dette er  gitt, vil "master" bli bestemt ved å bruke "ismaster" database kommandoen på frøene, slik at sjåføren kan ende opp med å koble til en server som ikke var engang nevnt.';
$string['server'] = 'Server';
$string['server_help'] = 'Dette er tilkoblingsstrengen for serveren du vil bruke. Flere servere kan angis ved hjelp av en kommadelt liste.';
$string['testserver'] = 'Testserver';
$string['testserver_desc'] = 'Dette er tilkoblingsstrengen for test-server du ønsker å bruke. Hvis en testserver er oppgitt, kan MongoDB-ytelsen testes ved å bruke mellomlagerytelsessiden i Administrasjonsblokka.
Som et eksempel: mongodb://127.0.0.1:27017';
$string['username'] = 'Brukernavn';
$string['username_help'] = 'Brukernavnet som benyttes ved tilkobling.';
$string['usesafe'] = 'Bruk sikker';
$string['usesafe_help'] = 'Hvis aktivert vil usesafe alternativet bli brukt under legg til, hent, og fjerne-operasjoner. Hvis du har angitt et replikasett dette vil bli tvunget på uansett.';
$string['usesafevalue'] = 'Bruk sikker verdi';
$string['usesafevalue_help'] = 'Du kan velge å angi en bestemt verdi for trygg bruk. Dette vil avgjøre antallet servere som operasjoner må fullføres på før de anses å ha blitt ferdigstilt.';
