<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'course', language 'no', version '3.8'.
 *
 * @package     course
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aria:coursecategory'] = 'Kurskategori';
$string['aria:courseimage'] = 'Kursbilde';
$string['aria:coursename'] = 'Kursnavn';
$string['aria:courseshortname'] = 'Kursets kortnavn';
$string['aria:favourite'] = 'Kurset er lagt til som favoritt';
$string['coursealreadyfinished'] = 'Kurset er allered ferdig';
$string['coursenotyetfinished'] = 'Kurset er ikke ferdig';
$string['coursenotyetstarted'] = 'Kurset har ikke startet';
$string['coursetoolong'] = 'Kurset er for langt';
$string['customfield_islocked'] = 'Låst';
$string['customfield_islocked_help'] = 'Når feltet er låst kan bare brukere med tillatelsen "Rediger låste felt" være i stand til å endre det i kursinnstillingene.';
$string['customfield_notvisible'] = 'Ingen';
$string['customfield_visibility'] = 'Synlig for';
$string['customfield_visibility_help'] = 'Denne innstillingen bestemmer hvem som kan se det egendefinerte feltnavnet og verdien i listen over kurs eller i det tilgjengelige tilpassede feltfilteret på startsiden.';
$string['customfield_visibletoall'] = 'Alle';
$string['customfield_visibletoteachers'] = 'Lærere';
$string['customfieldsettings'] = 'Innstillinger for egendefinerte kursfelt';
$string['errorendbeforestart'] = 'Sluttdatoen ({$a}) er før kursets startdato.';
$string['favourite'] = 'Favoritt';
$string['gradetopassnotset'] = 'Dette kurset har ingen karakter for besttt. Det kan settes i karakterboka i kurset.';
$string['noaccesssincestartinfomessage'] = 'Hei {$a->userfirstname},

</br><br/>Flere studenter i kurset {$a->coursename} har aldri besøkt kurssiden.';
$string['nocourseactivity'] = 'Ikke nok kursaktivitet mellom starten og slutten av kurset';
$string['nocourseendtime'] = 'Kurset har ikke noen slutttid';
$string['nocoursesections'] = 'Ingen seksjoner';
$string['nocoursestudents'] = 'Ingen studenter';
$string['norecentaccessesinfomessage'] = 'Hei {$a->userfirstname},

</br><br/>Flere studenter i kurset {$a->coursename} har ikke besøkt kurssiden i det siste.';
$string['noteachinginfomessage'] = 'Hei {$a->userfirstname},

</br><br/>Det finnes kurs med startdato i løpet av kommende uke som mangler lærere eller studenter.';
$string['privacy:completionpath'] = 'Kursfullføring';
$string['privacy:favouritespath'] = 'Informasjon om kursfavoritter';
$string['privacy:metadata:completionsummary'] = 'Kurset inneholder kursfullføringsinformasjon om brukeren.';
$string['privacy:metadata:favouritessummary'] = 'Kurset inneholder informasjon relatert til om kurset er lagt til som favoritt av brukeren.';
$string['privacy:perpage'] = 'Antall kurs som skal vises per side.';
$string['studentsatriskincourse'] = 'Studenter i faresonen i {$a} i kurs';
$string['studentsatriskinfomessage'] = 'Hei {$a->userfirstname},

</br><br/>Studenter i kurset {$a->coursename} har blitt identifisert for å være i faresonen for å falle fra.';
$string['target:coursecompetencies'] = 'Studenter i faresonen for å ikke oppnå læringsmål tildelt et kurs';
$string['target:coursecompetencies_help'] = 'Dette målet beskriver om en student risikerer ikke å oppnå kompetansen som er tildelt et kurs. Dette målet vurderer at alle kompetanser som tildeles kurset må oppnås innen slutten av kurset.';
$string['target:coursecompletion'] = 'Studenter i faresonen for å ikke oppnå kursfullføringskriteriene';
$string['target:coursecompletion_help'] = 'Dette målet beskriver om studentene er i faresonen for å ikke fullføre kursfullføringskriteriene.';
$string['target:coursedropout'] = 'Studenter i fare for å falle fra.';
$string['target:coursedropout_help'] = 'Dette målet beskriver om studentene er i fare for å falle fra.';
$string['target:coursegradetopass'] = 'Studenter i faresonen for å ikke oppnå ståkarakteren som kreves for å bestå kurset';
$string['target:coursegradetopass_help'] = 'Dette målet beskriver om studentene er i fare for å ikke oppnå ståkarakteren som kreves for å bestå kurset.';
$string['target:noaccesssincecoursestart'] = 'Studenter som ikke har besøkt kurssiden ennå';
$string['target:noaccesssincecoursestart_help'] = 'Dette målet beskriver studenter som aldri startet på et kurs de er påmeldt.';
$string['target:noaccesssincecoursestartinfo'] = 'Følgende studenter er påmeldt et kurs som er i gang men de har aldri startet på kurset.';
$string['target:norecentaccesses'] = 'Studenter som ikke har besøkt kurssiden nylig';
$string['target:norecentaccesses_help'] = 'Dette målet identifiserer studenter som ikke har startet på et kurs de er påmeldt i det angitte analyseintervallet (som standard den siste måneden).';
$string['target:norecentaccessesinfo'] = 'Følgende studenter har ikke startet på et kurs de er påmeldt innen det angitte analyseintervallet (som standard den siste måneden).';
$string['target:noteachingactivity'] = 'Kurs uten lærere eller studenter';
$string['target:noteachingactivity_help'] = 'Dette målet beskriver om kurs som starter kommende uke vil ha undervisningsaktivitet.';
$string['target:noteachingactivityinfo'] = 'Følgende kurs risikerer, på grunn av start de kommende dagene, ikke å starte fordi de ikke har lærere eller studenter';
$string['targetlabelstudentcompetenciesno'] = 'Studenter som sannsynligvis vil oppnå læringsmåle';
$string['targetlabelstudentcompetenciesyes'] = 'Studenter i fare for å ikke oppnå læringsmålene i kurset';
$string['targetlabelstudentcompletionno'] = 'Studenter som sannsynligvis vil oppnå kursfullføringskriteriene';
$string['targetlabelstudentcompletionyes'] = 'Studenter i fare for å ikke oppnå kursfullføringskriteriene';
$string['targetlabelstudentdropoutno'] = 'Ikke i faresonen';
$string['targetlabelstudentdropoutyes'] = 'Studenter i fare for å falle ut';
$string['targetlabelstudentgradetopassno'] = 'Studenter som sannsynligvis vil oppnå ståkarakteren som kreves for å bestå kurset';
$string['targetlabelstudentgradetopassyes'] = 'Studenter i fare for å ikke oppnå ståkarakteren som kreves for å bestå kurset';
$string['targetlabelteachingno'] = 'Kurs uten lærere eller studenter';
$string['targetlabelteachingyes'] = 'Brukere med lærerrettigheter som har tilgang til kurset';
