<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'ja', version '3.8'.
 *
 * @package     hub
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'スクリーンショットを追加する';
$string['advertise'] = '人が参加できるようこのコースを共有する';
$string['advertised'] = '人が参加するため';
$string['advertiseon'] = '{$a} でこのコースを共有する';
$string['advertisepublication_help'] = 'このコースは他の人が登録および参加できるコースとしてMoodle.netに一覧表示されます。サイトではメールによる自己登録を有効にしてください。また、あなたはこのコースの自己登録を有効にする必要があります。';
$string['analyticsactions'] = '生成済み予測に実行されたアクション数 ({$a})';
$string['analyticsactionsnotuseful'] = '予測に有用ではないとマークされたアクション数 ({$a})';
$string['analyticsenabledmodels'] = '有効にされた予測モデル数 ({$a})';
$string['analyticspredictions'] = '生成済み予測数 ({$a})';
$string['audience'] = 'オーディエンス';
$string['audience_help'] = 'コースが対象とするオーディエンスを選択してください。';
$string['audienceadmins'] = 'Moodle管理者';
$string['audienceeducators'] = '教育者';
$string['audiencestudents'] = '学生';
$string['badgesnumber'] = 'バッジ数 ({$a})';
$string['communityremoved'] = 'あなたのリストからコースリンクが削除されました。';
$string['completeregistration'] = 'Moodle.netの登録を完了する';
$string['confirmregistration'] = '登録を承認する';
$string['contributornames'] = '他の寄稿者';
$string['contributornames_help'] = 'このフィールドを使用することで、あなたはこのコースに寄稿した人の氏名を一覧表示することができます。';
$string['coursename'] = '名称';
$string['coursepublished'] = 'このコースが「 {$a} 」に正常に共有されました。';
$string['courseshortname'] = '省略名';
$string['courseshortname_help'] = 'あなたのコース省略名を入力してください。省略名はユニークである必要はありません。';
$string['coursesnumber'] = 'コース数 ({$a})';
$string['courseunpublished'] = 'コース {$a->courseshortname} は {$a->hubname} に共有されません。';
$string['courseurl'] = 'コースURL';
$string['courseurl_help'] = 'あなたのコースのURLです。このURLは検索結果のリンクとして表示されます。';
$string['creatorname'] = '作成者';
$string['creatorname_help'] = '作成者はコース作成者です。';
$string['creatornotes'] = '作成者ノート';
$string['creatornotes_help'] = '作成者ノートはこのコースの使い方に関する教師ガイドです。';
$string['deletescreenshots'] = 'これらのスクリーンショットを削除する';
$string['deletescreenshots_help'] = '現在アップロードされているすべてのスクリーンショットを削除します。';
$string['demourl'] = 'デモURL';
$string['demourl_help'] = 'あなたのコースのデモURLを入力してください。デフォルトはあなたのコースのURLです。デモURLは検索結果のリンクとして表示されます。';
$string['description'] = '説明';
$string['description_help'] = 'この説明テキストはMoodle.netのコース一覧に表示されます。';
$string['detectednotexistingpublication'] = '{$a->hubname} はすでに存在しないコースを一覧表示しています。{$a->hubname} 管理者に公開ナンバー {$a->id} を削除するよう報告してください。';
$string['downloadable'] = 'ダウンロード可';
$string['educationallevel'] = '教育レベル';
$string['educationallevel_help'] = 'コースにあてはまる最も適切な学習レベルを選択してください。';
$string['edulevelassociation'] = '団体';
$string['edulevelcorporate'] = '法人';
$string['edulevelgovernment'] = '政府';
$string['edulevelother'] = '他';
$string['edulevelprimary'] = '初等教育';
$string['edulevelsecondary'] = '中等教育';
$string['eduleveltertiary'] = '第三次教育';
$string['emailalert'] = 'メール通知';
$string['emailalert_help'] = 'この設定を有効にした場合、ハブ管理者はセキュリティおよび他の重要なニュースに関してあなたにメール送信します。';
$string['enrollable'] = '登録可';
$string['errorbadimageheightwidth'] = 'イメージの最大サイズは $a->width} X {$a->height} にしてください。';
$string['errorcourseinfo'] = '{$a} からのコースメタデータ検索中にエラーが発生しました。後でこのページをリロードした後、再度コースメタデータを検索してください。そうでない場合、あなたは以下のデフォルトメタデータを使用して登録処理を継続することができます。';
$string['errorcoursepublish'] = 'コース公開中にエラーが発生しました ({$a})。後で再度お試しください。';
$string['errorcoursewronglypublished'] = 'Moodle.netから公開エラーが通知されました。後で再度お試しください。';
$string['errorotherhubsnotsupported'] = 'このページはカスタムサイトディレクトリ以外のサイトへの登録には使用できません。';
$string['errorregistration'] = '登録中にエラーが発生しました。後ほど再度お試しください ({$a})。';
$string['errorregistrationupdate'] = '登録更新中にエラーが発生しました ({$a})。';
$string['errorunpublishcourses'] = '予期しないエラーが発生したためMoodle.netからコースを削除できませんでした。再度お試しいただくか (推奨) Moodle.net管理者にご連絡ください。';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}。このサイトの登録トークンがリセットされました。あなたのサイトを再度登録することができます。';
$string['existingscreenshotnumber'] = '{$a} 件のスクリーンショットがあります。Moodle.net管理者があなたのコースを有効にした後、これらのスクリーンショットを閲覧できるようになります。';
$string['existingscreenshots'] = '既存のスクリーンショット';
$string['geolocation'] = 'ジオロケーション';
$string['geolocation_help'] = '	
将来的に私たちはロケーションベースの検索を提供します。あなたのコースロケーションを指定したい場合、ここに緯度/経度情報を入力してください (例: -31.947884,115.871285)。この値を求める1つの方法はGoogleマップを使用することです。';
$string['imageurl'] = 'イメージURL';
$string['imageurl_help'] = 'このイメージはハブに表示されます。このイメージを常に利用できるようにしてください。イメージの最大サイズは {$a->width} X {$a->height} です。';
$string['issuedbadgesnumber'] = '発行済みバッジ数 ({$a})';
$string['language'] = '言語';
$string['language_help'] = 'このコースの主言語です。';
$string['lasttimechecked'] = '最終確認日時';
$string['licence'] = 'ライセンス';
$string['licence_help'] = 'あなたのコース公開に関するライセンスを選択してください。';
$string['logourl'] = 'ロゴURL';
$string['mobilenotificationsenabled'] = 'モバイル通知有効 ({$a})';
$string['mobileservicesenabled'] = 'モバイルサービス有効 ({$a})';
$string['modulenumberaverage'] = 'コースモジュールの平均数 ({$a})';
$string['mustselectsubject'] = 'あなたは学習テーマを選択する必要があります。';
$string['name'] = '名称';
$string['name_help'] = 'この名称はコース一覧に表示されます。';
$string['neverchecked'] = '未チェック';
$string['next'] = '次へ';
$string['no'] = 'No';
$string['nocheckstatusfromunreghub'] = 'サイトがハブに登録されていないため、ステータスをチェックすることができません。';
$string['nohubselected'] = 'ハブが選択されていません。';
$string['none'] = 'なし
';
$string['nosearch'] = 'ハブまたはコースを公開しない';
$string['notregisteredonhub'] = 'あなたのコースを共有する前に管理者は少なくとも1つのコースをMoodle.netに登録する必要があります。';
$string['operation'] = '操作';
$string['participantnumberaverage'] = '平均参加者数 ({$a})';
$string['policyagreed'] = 'プライバシー通知およびデータ処理に関する同意書';
$string['policyagreeddesc'] = '私は<a href="{$a}" target="_blank">プライバシー通知およびデータ処理に関する同意書</a>に同意します。';
$string['postaladdress'] = '住所';
$string['postaladdress_help'] = 'このサイトの住所またはこのサイトが存在する場所です。';
$string['postsnumber'] = '投稿数 ({$a})';
$string['previousregistrationdeleted'] = '以前の登録は {$a} から削除されました。あなたは登録処理を再開することができます。ありがとうございます。';
$string['publicationinfo'] = 'コース公開情報';
$string['publish'] = '共有';
$string['publishcourse'] = '{$a} を共有する';
$string['publishcourseon'] = '{$a} に共有する';
$string['publishedon'] = 'コース共有';
$string['publisheremail'] = '公開者メール';
$string['publisheremail_help'] = 'ハブ管理者は公開済みコースのステータス変更等の情報を公開者メールアドレス宛に通知することができます。';
$string['publishername'] = '公開者';
$string['publishername_help'] = '公開者は公式にコースを公開する個人または組織です。他の人の代理としてコースを公開しない限り、あなたが公開者となります。';
$string['questionsnumber'] = '問題数 ({$a})';
$string['readvertiseon'] = '{$a} の広告情報を更新する';
$string['registeredactiveuserdevices'] = '通知を受信する登録モバイルデバイスのアクティブユーザ数 ({$a})';
$string['registeredcourses'] = '登録済みコース';
$string['registeredsites'] = '登録済みサイト';
$string['registereduserdevices'] = '登録モバイルデバイスのユーザ数 ({$a})';
$string['registersite'] = '{$a} に登録する';
$string['registerwithmoodleorg'] = 'あなたのサイトを登録する';
$string['registerwithmoodleorgcomplete'] = 'あなたのサイト登録を完了する';
$string['registerwithmoodleorginfo'] = '私たちはあなたのMoodleサイトに重要事項の提供を継続したいと思います。登録することにより:

* あなたは新しいMoodleのリリース、セキュリティ警告およびその他重要なニュースの通知を購読して受信できます。
* あなたは私たちの無料Moodleアプリを使用してあなたのサイトにアクセスおよびモバイルプッシュ通知を有効にすることができます。
* あなたは私たちのMoodleおよびコミュニティサイトの改善の一助となる世界的コミュニティのMoodle統計に貢献できます。
* 希望により、あなたのサイトを登録済みMoodleサイト一覧のあなたの国の中に収録できます。';
$string['registerwithmoodleorginfoapp'] = 'Moodleアプリに関して';
$string['registerwithmoodleorginfosites'] = '私の国の他のサイト';
$string['registerwithmoodleorginfostats'] = 'Moodle統計';
$string['registerwithmoodleorgremove'] = 'あなたはあなたのサイトを登録解除しようとしています。続ける場合、あなたは重要な通知およびセキュリティ警告にアクセスできなくなります。あなたのユーザはMoodleモバイルアプリからプッシュ通知を受信できなくなります。本当にあなたのサイトを登録解除してもよろしいですか?';
$string['registerwithmoodleorgupdate'] = 'あなたのサイト登録を更新する';
$string['registrationconfirmed'] = 'サイト登録承認';
$string['registrationconfirmedon'] = 'あなたのサイトを登録していただきまして、ありがとうございます。';
$string['registrationinfo'] = '登録情報';
$string['removefromhub'] = 'Moodle.netから登録解除する';
$string['renewregistration'] = '登録を更新する';
$string['resourcesnumber'] = 'リソース数 ({$a})';
$string['restartregistration'] = '登録を再開する';
$string['roleassignmentsnumber'] = 'ロール割り当て数 ({$a})';
$string['screenshots'] = 'スクリーンショット';
$string['screenshots_help'] = 'コースのスクリーンショットすべて検索結果に表示されます。';
$string['search'] = '検索';
$string['sendfollowinginfo'] = '詳細情報';
$string['sendfollowinginfo_help'] = '次の情報はあなたのサイト登録が更新されるたびにMoodleに送信されます (デフォルトでは毎週の「サイト登録」スケジュールタスクの実行時)。この情報は全体的な統計にのみ寄与します。また、どのサイトリストでも公開されません。';
$string['sendingcourse'] = 'コース送信';
$string['sendingsize'] = 'お待ちください、コースファイルアップロード中です ({$a->total}Mb) ...';
$string['sent'] = '... 完了しました。';
$string['share'] = '人がダウンロードできるようこのコースを共有する';
$string['shared'] = '人がダウンロードするため';
$string['shareon'] = 'このコースを {$a} にアップロードする';
$string['sharepublication_help'] = 'このコースのバックアップは他の人がMoodle.netで入手して自分のサイトでリストアおよび利用することができます。';
$string['siteadmin'] = '管理者';
$string['siteadmin_help'] = 'サイト管理者のフルネームです。';
$string['sitecommnews'] = 'Moodleニュースレター';
$string['sitecommnews_help'] = 'あなたには私たちのMoodleニュースレターを購読するオプションがあります。あなたはいつでも購読解除できます。';
$string['sitecommnewsno'] = 'いいえ、私はどのようなメールも受信したくありません';
$string['sitecommnewsyes'] = 'はい、私はMoodleニュースレターの受信を希望します';
$string['sitecountry'] = '国';
$string['sitecountry_help'] = 'あなたの組織が存在する国です。';
$string['sitedesc'] = '説明';
$string['sitedesc_help'] = 'あなたがどのようにMoodleを利用しているか情報をご提供ください。';
$string['siteemail'] = '管理者メールアドレス';
$string['siteemail_help'] = '必要に応じてMoodle HQがあなたに連絡できるようメールアドレスを提供する必要があります。あなたが以下を許可する場合、このメールアドレスは他の目的に使用される場合があります。個人のメールアドレスではなく役職に関係する一般的なメールアドレス (例: sitemanager@example.com) の入力をお勧めします。';
$string['sitegeolocation'] = 'ジオロケーション';
$string['sitegeolocation_help'] = '将来的に私たちはロケーションベースのハブ検索を提供します。あなたのサイトロケーションを指定したい場合、ここに緯度/経度情報を入力してください (例: -31.947884,115.871285)。この値を求める1つの方法はGoogleマップを使用することです。';
$string['sitelang'] = '言語';
$string['sitelang_help'] = 'あなたのMoodleサイトの主言語は何ですか?';
$string['sitename'] = '名称';
$string['sitename_help'] = 'ハブが許可する場合、サイト名はサイト一覧に表示されます。';
$string['sitephone'] = '電話';
$string['sitephone_help'] = 'あなたの電話番号はハブ管理者のみ閲覧することができます。';
$string['siteprivacy'] = 'サイトリスティング';
$string['siteprivacy_help'] = 'あなたのサイトをリンク付きまたはリンクなしで登録サイト一覧に公開することができます。';
$string['siteprivacylinked'] = '私のサイト名をリンク付きで表示してください';
$string['siteprivacynotpublished'] = '私のサイトを表示しないでください';
$string['siteprivacypublished'] = 'サイト名のみ表示してください';
$string['siteregistrationcontact'] = 'コンタクトフォームを表示する';
$string['siteregistrationcontact_help'] = 'この設定を有効にした場合、私たちのMoodleコミュニティの他の人 (ログインアカウントが必要な人) は私たちのMoodleコミュニティサイトのフォーム経由であなたに連絡することができます。他の人はあなたのメールアドレスを閲覧することはできません。';
$string['siteregistrationemail'] = '新しいMoodleリリース、セキュリティ警告およびその他重要ニュースの通知';
$string['siteregistrationemail_help'] = 'あなたには新しいMoodleリリース、セキュリティ警告およびその他重要ニュースの通知に関して私たちの配信頻度の低いメーリングリストを購読するオプションがあります。';
$string['siteregistrationupdated'] = 'サイト登録が更新されました。';
$string['siterelease'] = 'Moodleリリース';
$string['siterelease_help'] = 'このサイトのMoodleリリースナンバーです。';
$string['sitereleasenum'] = 'Moodleリリース ({$a})';
$string['siteurl'] = 'サイトURL';
$string['siteurl_help'] = 'URLはこのサイトのアドレスです。プライバシー設定で人のサイトアドレス閲覧を許可している場合、このURLが使用されます。';
$string['siteversion'] = 'Moodleバージョン';
$string['siteversion_help'] = 'このサイトのMoodleバージョン';
$string['skipregistration'] = 'スキップ';
$string['status'] = '一覧状態';
$string['statuspublished'] = '掲載済み';
$string['statusunpublished'] = '未掲載';
$string['subject'] = '学習テーマ';
$string['subject_help'] = 'コースがカバーする主学習領域を選択してください。';
$string['tags'] = 'タグ';
$string['tags_help'] = 'タグはあなたのコースをカテゴリ別けして探しやすくします。シンプルで意味のある言葉を使用してください。また、タグはカンマで区切ってください。例: 数学, 代数学, 幾何学';
$string['type'] = '共有';
$string['unpublish'] = '共有停止';
$string['unpublishalladvertisedcourses'] = 'Moodle.netで人が参加するために共有されているすべてのコースを削除する';
$string['unpublishalluploadedcourses'] = 'Moodle.netで人がダウンロードするために共有されているすべてのコースを削除する';
$string['unpublishconfirmation'] = '本当にコース「 {$a->courseshortname} 」を「 {$a->hubname} 」から削除してもよろしいですか?';
$string['unpublishcourse'] = '{$a} を共有停止する';
$string['unregister'] = '登録解除';
$string['unregisterexplained'] = 'URL {$a} のサイトが登録されている場合、その登録は削除されます。';
$string['unregisterfrom'] = '{$a} から登録解除する';
$string['unregistrationerror'] = 'サイト登録解除中にエラーが発生しました: {$a}';
$string['update'] = '更新';
$string['updatesite'] = '{$a} の登録を更新する';
$string['updatesiteregistration'] = '登録を更新する';
$string['updatestatus'] = 'チェックする';
$string['urlalreadyregistered'] = 'あなたのサイトはすでに登録されているようです。これは何らかの問題が生じたことを意味します。再度登録できるようサイトディレクトリ管理者にあなたの登録解除を申請してください。';
$string['usedifferentemail'] = '異なるメールを使用する';
$string['usersnumber'] = 'ユーザ数 ({$a})';
$string['wrongtoken'] = '不明な理由により登録に失敗しました (ネットワーク?)。再度お試しください。';
