<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'eu', version '3.8'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ekintza';
$string['addedandupdatedpp'] = '{$a->%new} H5P liburutegi berri gehitu dira eta zaharkituta zeuden beste {$a->%old} eguneratu dira.';
$string['addedandupdatedps'] = '{$a->%new} H5P liburutegi berri gehitu dira eta zaharkituta zegoen beste {$a->%old} eguneratu da.';
$string['addedandupdatedsp'] = 'H5P liburutegi berri {$a->%new} gehitu da eta zaharkituta zeuden beste {$a->%old} eguneratu dira.';
$string['addedandupdatedss'] = 'H5P liburutegi berri {$a->%new} gehitu da eta zaharkituta zegoen beste {$a->%old} eguneratu da.';
$string['addednewlibraries'] = '{$a->%new} H5P liburutegi berri gehitu dira.';
$string['addednewlibrary'] = 'H5P liburutegi berri {$a->%new} gehitu da.';
$string['additionalinfo'] = 'Informazio gehigarria';
$string['additionallicenseinfo'] = 'Lizentziari buruzko informazio gehigarria';
$string['addlibraries'] = 'Gehitu liburutegiak';
$string['ajaxfailed'] = 'Datuak kargatzeak huts egin du.';
$string['anunexpectedsave'] = 'Ezustekoren bat gertatu da. Ezin izan dugu eduki hau gorde.';
$string['attribution'] = 'Aitortza 4.0';
$string['attributionnc'] = 'Aitortu-EzKomertziala 4.0';
$string['attributionncnd'] = 'Aitortu-EzKomertziala-LanEratorririkGabe 4.0';
$string['attributionncsa'] = 'Aitortu-EzKomertziala-PartekatuBerdin 4.0';
$string['attributionnd'] = 'Aitortu-LanEratorririkGabe 4.0';
$string['attributionsa'] = 'Aitortu-PartekatuBerdin 4.0';
$string['author'] = 'Egilea';
$string['authorcomments'] = 'Egilearen iruzkinak';
$string['authorcommentsdescription'] = 'Eduki-sortzailearentzako iruzkinak (Testu hau ez da argitaratuko egile-eskubidearen informazio gisa)';
$string['authorname'] = 'Egilearen izena';
$string['authorrole'] = 'Egilearen baimena';
$string['by'] = 'egilea';
$string['cancellabel'] = 'Utzi';
$string['ccattribution'] = 'Aitortu (CC BY)';
$string['ccattributionnc'] = 'Aitortu-EzKomertziala (CC BY-NC)';
$string['ccattributionncnd'] = 'Aitortu-EzKomertziala-LanEratorririkGabe (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Aitortu-EzKomertziala-PartekatuBerdin (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Aitortu-LanEratorririkGabe (CC BY-ND)';
$string['ccattributionsa'] = 'Aitortu-PartekatuBerdin (CC BY-SA)';
$string['ccpdd'] = 'Domeinu Publikoaren Lagapena (CC0)';
$string['ccpdm'] = 'Domeinu Publikoko Marka (PDM)';
$string['changedby'] = 'Honek aldatua:';
$string['changedescription'] = 'Aldaketaren deskribapena';
$string['changelog'] = 'Aldaketen erregistroa';
$string['changeplaceholder'] = 'Ebakitako argazkia, aldatutako testua, etab.';
$string['close'] = 'Itxi';
$string['completionpass'] = 'Gainditzeko kalifikazioa behar du';
$string['completionpass_help'] = 'Gaituz gero, jarduera hau osatutzat hartuko da ikasleak gainditzeko kalifikazioa edo altuagoa jasotzen duenean (H5P jardueraren ezarpenetako Kalifikazioa atalean ezarritakoaren araberakoa).';
$string['completionpassdesc'] = 'Ikasleak gainditzeko kalifikazioa behar du jarduera hau osatutzat emateko';
$string['confirmdialogbody'] = 'Mesedez bBaieztatu aurrera jarraitu nahi duzula. Ekintza hau ezin da desegin.';
$string['confirmdialogheader'] = 'Baieztatu ekintza';
$string['confirmlabel'] = 'Baieztatu';
$string['connectionlost'] = 'Konexioa galdu da. Emaitzak gorde eta konexioa berreskuratzean bidaliko dira.';
$string['connectionreestablished'] = 'Konexioa berreskuratu da.';
$string['contentchanged'] = 'Eduki hau erabili zenuen azken alditik aldatu da.';
$string['contentcopied'] = 'Edukia arbelera kopiatzen da';
$string['contentstatefrequency'] = 'Edukiaren egoeraren gordetze-maiztasuna';
$string['contentstatefrequency_help'] = 'Segundotan, zenbatean behin nahi duzun erabiltzailearen aurrerapena automatikoki gordetzea. Zenbakia handitu ezazu AJAX eskaera gehiegi egoteagatik arazoak badituzu.';
$string['contenttype'] = 'Eduki mota';
$string['contenttypecacheheader'] = 'Eduki motaren cache-a';
$string['copyright'] = 'Erabilera-eskubideak';
$string['copyrightinfo'] = 'Copyright informazioa';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'Ikusi eduki honetarako copyright informazioa.';
$string['couldnotcopy'] = 'Ezin izan da fitxategia kopiatu.';
$string['couldnotparsejsonfromzip'] = 'Ezin izan da paketeko JSON edukia aztertu: %fileName';
$string['couldnotparsepostdata'] = 'Bidalitako datuak ezin izan dira aztertu.';
$string['couldnotreadfilefromzip'] = 'Ezin izan da paketeko fitxategia irakurri: %fileName';
$string['couldnotsave'] = 'Ezin izan da fitxategia gorde.';
$string['create'] = 'Sortu';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Eguneratu eduki motaren cache-a';
$string['ctcacheconnectionfailed'] = 'Ezin izan da H5P Bilgunearekin komunikatu. Saiatu berriro beranduago, mesedez.';
$string['ctcachedescription'] = 'Eduki motaren cache-a eguneratuta izateak ziurtatzen du azken liburutegiak ikusi, jaitsi erabil ditzakezula. Honek ez du liburutegiak eurak eguneratzen.';
$string['ctcachelastupdatelabel'] = 'Azken eguneraketa';
$string['ctcacheneverupdated'] = 'Inoiz ez';
$string['ctcachenolibraries'] = 'Ez da eduki motarik jaso H5P Bilgunetik. Saiatu berriro beranduago, mesedez.';
$string['ctcachesuccess'] = 'Liburutegi-cache-a ondo eguneratu da!';
$string['ctcachetaskname'] = 'Eguneratu eduki motaren cache-a';
$string['currentpage'] = '$current. orria $total orritatik';
$string['dataviewreportlabel'] = 'Ikusi erantzunak';
$string['date'] = 'Data';
$string['disablefileextensioncheck'] = 'Desgaitu fitxategi-luzapenen egiaztatzea';
$string['disablefileextensioncheckwarning'] = 'Kontuz! Fitxategi-luzapenen egiaztatzea desgaitzeak segurtasun-arazoak sor daitezke, PHP fitxategien igoera ahalbidetzen duelako. Horrela, erasotzaileek zure gunean kode maltzurra exekutatu ahalko lukete. Kontuz ibili igotzen duzunarekin, mesedez.';
$string['disablefullscreen'] = 'Desgaitu pantaila osoa';
$string['disablehubconfirmationmsg'] = 'Oraindik ere bilgunea gaitu nahi al duzu?';
$string['disablehubdescription'] = 'Aukera hau gaitzea irmoki gomendatzen da. H5P Bilguneak interfaze erraza eskaintzen du eduki mota berriak lortu eta oraingo eduki motak eguneratuta mantentzeko. Aurrerago edukia partekatu eta berrerabiltzea errazago egingo du. Aukera hau desgaituz gero, eduki motak fitxategiak igotzeko formularioen bidez instalatu eta eguneratu beharko dituzu.';
$string['displayoptionalwaysshow'] = 'Erakutsi beti';
$string['displayoptionauthoroff'] = 'Egileak kontrolatua, berez desgaituta';
$string['displayoptionauthoron'] = 'Egileak kontrolatua, berez gaituta';
$string['displayoptiondownloadalways'] = 'Beti';
$string['displayoptiondownloadnever'] = 'Inoiz ez';
$string['displayoptiondownloadpermission'] = 'Soilik erabiltzaileak H5P esportatzeko baimena badu';
$string['displayoptionnevershow'] = 'Ez erakutsi inoiz';
$string['displayoptionpermissions'] = 'Erakutsi soilik erabiltzaileak H5P esportatzeko baimena badauka';
$string['displayoptionpermissionsembed'] = 'Erakutsi soilik erabiltzaileak H5P txertatzeko baimena badauka';
$string['displayoptions'] = 'Erakusteko aukerak';
$string['download'] = 'Jaitsi';
$string['downloadfailed'] = 'Eskatutako liburutegiaren deskargak huts egin du.';
$string['downloadtitle'] = 'Jaitsi eduki hau H5P fitxategi gisa.';
$string['editor'] = 'Editorea';
$string['emailconfirmbody'] = 'Kaixo, {$a->username}:

Eskerrik asko \'{$a->coursename}\' ikastaroko \'{$a->hvpname}\' jardueran zure erantzunak bidaltzeagatik.

Mezu honen bitartez zure erantzunak ondo gorde direla baieztatzen dizugu.

H5P hau hurrengo estekan ikusi dezakezu: {$a->hvpurl}';
$string['emailconfirmsmall'] = 'Eskerrik asko \'{$a->hvpname}\\ jardueran zure erantzunak bidaltzeagatik';
$string['emailconfirmsubject'] = 'Bidalketaren baieztapena: {$a->hvpname}';
$string['emailnotifybody'] = 'Kaixo, {$a->username}:

{$a->studentname} ikasleak \'{$a->coursename}\' ikastaroko \'{$a->hvpname}\' jarduera ({$a->hvpurl}) osatu du.

Saiakera hau hurrengo estekan berrikusi dezakezu: {$a->hvpreporturl}';
$string['emailnotifysmall'] = '{$a->studentname} ikasleak \'{$a->hvpname}\' jarduera osatu du. Ikusi {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} ikasleak \'{$a->hvpname}\' jarduera osatu du';
$string['embed'] = 'Enbotatu';
$string['embedloginfailed'] = 'Ez duzu sarbiderik eduki honetara. Saioa hasten saiatu zaitez.';
$string['embedtitle'] = 'Ikusi eduki hau enbotatzeko kodea.';
$string['empty'] = 'Ez dago emaitzarik eskuragarri';
$string['enableabout'] = 'H5P botoiari buruz';
$string['enablecopyright'] = 'Copyright botoia';
$string['enabledlrscontenttypes'] = 'Gaitu LRS-ren mendeko eduki motak';
$string['enabledlrscontenttypes_help'] = 'Learning Record Store funtzioan oinarritutako eduki mota erabiltzea ahalbidetzen du, Questionnaire eduki mota adibidez.';
$string['enabledownload'] = 'Baimendu jaistea';
$string['enableembed'] = 'Enbotatzeko botoia';
$string['enableframe'] = 'Erakutsi ekintza-barra eta markoa';
$string['enablehublabel'] = 'Erabili H5P Bilgunea';
$string['enablejavascript'] = 'Mesedez JavaScript gaitu ezazu.';
$string['enablesavecontentstate'] = 'Gorde edukiaren egoera';
$string['enablesavecontentstate_help'] = 'Automatikoki gorde uneko eduki interaktiboaren egoera erabiltzaile bakoitzarentzat. Horrela erabiltzaileak utzi zuen lekuan jarraitzeko aukera du.';
$string['failedtodownloadh5p'] = 'Eskatutako H5Paren deskargak huts egin du.';
$string['fileexceedsmaxsize'] = 'Paketeko fitxategietako batek gehienezko fitxategi-tamaina gainditzen du. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Fitxategia ez da zerbitzarian aurkitu. Egiaztatu fitxategiak igotzeko ezarpenak.';
$string['filenotimage'] = 'Fitxategia ez da irudi bat.';
$string['filetypenotallowed'] = 'Fitxategi mota hau ez da onartzen.';
$string['finished'] = 'Amaitu da';
$string['fullscreen'] = 'Pantaila osoa';
$string['gpl'] = 'Lizentzia Publiko Orokorra 3';
$string['gradetopassmustbeset'] = 'Gainditzeko kalifikazioa ezin da 0 izan H5P jarduera honek gainditzeko baldintza duen osaketa-metodoa erabiltzen duelako. Mesedez 0 ez den balio bat zehaztu ezazu.';
$string['gradetopassnotset'] = 'H5P jarduera honek oraindik ez dauka gainditzeko kalifikazioa zehaztuta. H5P jardueraren ezarpenetako Kalifikazioa atalean zehaztu daiteke.';
$string['h5pfile'] = 'H5P Fitxategia';
$string['h5ptitle'] = 'Bisitatu H5P.org eduki interesgarri gehiago aurkitzeko.';
$string['hide'] = 'Ezkutatu';
$string['hideadvanced'] = 'Ezkutatu aurreratuak';
$string['hubcommunicationdisabled'] = 'H5P Bilgunearekiko komunikazioa desgaitu da H5Pren eskakizun batek edo gehiagok huts egin dutelako.';
$string['hubisdisabled'] = 'Bilgunea desgaitu da. H5P ezarpenetan berriro gaitu dezakezu.';
$string['hubisdisableduploadlibraries'] = 'H5P Bilgunea desgaitu da arazoak konpondu arte. Hala ere, liburutegiak igotzen jarrai dezakezu "H5P Liburutegiak" orriaren bidez.';
$string['hubsettingsheader'] = 'Eduki motak';
$string['hvp:addinstance'] = 'Gehitu H5P jarduera berria';
$string['hvp:emailconfirmsubmission'] = 'Jaso baieztapen-mezu bat bidaltzerakoan';
$string['hvp:emailnotifysubmission'] = 'Jaso jakinarazpen-mezu bat saiakera bat bidaltzen denean';
$string['hvp:getcachedassets'] = 'H5P jarduerak ikusteko beharrezkoa da';
$string['hvp:getembedcode'] = 'Ikusi H5P txertatutako kodea \'baimenen bidez kontrolatua\' aukera gaituta dagoenean';
$string['hvp:getexport'] = 'Jaitsi H5P fitxategia \'baimenen bidez kontrolatua\' aukera gaituta dagoenean';
$string['hvp:installrecommendedh5plibraries'] = 'Instalatu H5P.org-k gomendatutako H5P eduki motak';
$string['hvp:manage'] = 'Editatu dauden H5P jarduerak';
$string['hvp:restrictlibraries'] = 'Mugatu H5P eduki mota batzuen eskuragarritasuna';
$string['hvp:savecontentuserdata'] = 'Gorde H5P jardueretako erabiltzaileen aurrerapena';
$string['hvp:saveresults'] = 'Gorde osatutako H5P jardueren emaitzak';
$string['hvp:updatelibraries'] = 'Instalatu H5P eduki mota berriak edo eguneratu daudenak';
$string['hvp:userestrictedlibraries'] = 'Erabili murriztutako H5P eduki motak';
$string['hvp:view'] = 'Ikusi eta eragin H5P jarduerekin';
$string['hvp:viewallresults'] = 'Ikusi osatutako H5P jardueren emaitza guztiak';
$string['hvp:viewresults'] = 'Ikusi zure osatutako H5P jardueren emaitzak';
$string['installdenied'] = 'Ez duzu baimenik eduki mota hau instalatzeko. Jarri harremanetan zure guneko kudeatzailearekin.';
$string['installedlibraries'] = 'Instalatutako liburutegiak';
$string['intro'] = 'Sarrera';
$string['invalidaudioformat'] = 'Soinuko fitxategi-formatu baliogabea. Erabili mp3 edo wav.';
$string['invalidcontentfolder'] = 'Eduki-karpeta baliogabea';
$string['invalidcontenttype'] = 'Aukeratutako eduki mota baliogabea da.';
$string['invalidfieldtype'] = 'Fitxategi mota baliogabea.';
$string['invalidfile'] = 'Ez da "{$a->%filename}" fitxategia onartzen. Luzapen hauek dituzten fitxategiak bakarrik onartzen dira: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Ezin izan da H5Pa argitaratu.';
$string['invalidimageformat'] = 'Irudi formatu baliogabea. Erabili jpg, png edo gif.';
$string['invalidlanguagefile'] = '{$a->%file} hizkuntza-fitxategi baliogabea {$a->%library} liburutegian';
$string['invalidlanguagefile2'] = '{$a->%languageFile} hizkuntza-fitxategi baliogabea gehitu da {$a->%name} liburutegian';
$string['invalidlibrary'] = 'Liburutegi baliogabea';
$string['invalidlibrarydata'] = 'Datu baliogabea eman da {$a->%library} liburutegiaren {$a->%property} ezaugarrirako';
$string['invalidlibrarydataboolean'] = 'Datu baliogabea eman da  {$a->%library} liburutegiaren {$a->%property} ezaugarrirako. Boolearra espero zen.';
$string['invalidlibraryname'] = 'Liburutegi-izen baliogabea: {$a->%name}';
$string['invalidlibrarynamed'] = 'Edukian erabilitako {$a->%library} H5P liburutegia baliogabea da';
$string['invalidlibraryoption'] = '{$a->%option} aukera ez da onartzen {$a->%library} liburutegian';
$string['invalidlibraryproperty'] = 'Ezin da irakurri {$a->%property} ezaugarria {$a->%library} liburutegian';
$string['invalidmainjson'] = 'h5p.json fitxategi baliagarria falta da';
$string['invalidmultiselectoption'] = 'Aukera-anitzean hautatutako aukera baliogabea da.';
$string['invalidparameters'] = 'Parametro baliogabeak';
$string['invalidselectoption'] = 'Hautatutako aukera baliogabea da.';
$string['invalidsemanticsjson'] = 'Semantics.json fitxategi baliogabea sartu da {$a->%name} liburutegian';
$string['invalidsemanticstype'] = 'H5P barruko errorea: semantikako "{$a->@type}" eduki mota ezezaguna. Edukia ezabatzen!';
$string['invalidstring'] = 'Emandako katea ez da baliagarria regexp semantikaren arabera. (balioa: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Segurtasun-token baliogabea.';
$string['invalidvideoformat'] = 'Bideoko fitxategi-formatu baliogabea. Erabili mp4 edo webm.';
$string['invalidxapiresult'] = 'Ez da xAPI emaitzarik aurkitu emandako eduki eta id konbinaziorako';
$string['javascriptloading'] = 'JavaScript-aren zain...';
$string['libraries'] = 'H5P liburutegiak';
$string['librarydirectoryerror'] = 'Liburutegi-direktorioaren izenak machineName edo machineName-majorVersion.minorVersion bertsioekin bateragarria izan behar du (library.json fitxategitik). (Direktorioa: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Ekintzak';
$string['librarylistinstancedependencies'] = 'Instantziaren mendekotasunak';
$string['librarylistinstances'] = 'Instantzia';
$string['librarylistlibrarydependencies'] = 'Liburutegi-mendekotasunak';
$string['librarylistrestricted'] = 'Murriztua';
$string['librarylisttitle'] = 'Izenburua';
$string['librarynotselected'] = 'Eduki mota bat aukeratu behar duzu.';
$string['license'] = 'Lizentzia';
$string['licenseCC010'] = 'CC0 1.0 Unibertsala (CC0 1.0) Domeinu Publikoaren Lagapena';
$string['licenseCC010U'] = 'CC0 1.0 Unibertsala';
$string['licenseCC10'] = '1.0 Generikoa';
$string['licenseCC20'] = '2.0 Generikoa';
$string['licenseCC25'] = '2.5 Generikoa';
$string['licenseCC30'] = '3.0 Generikoa';
$string['licenseCC40'] = '4.0 Nazioartekoa';
$string['licenseGPL'] = 'Lizentzia Publiko Orokorra';
$string['licenseV1'] = '1. bertsioa';
$string['licenseV2'] = '2. bertsioa';
$string['licenseV3'] = '3. bertsioa';
$string['licensee'] = 'Lizentzia';
$string['licenseextras'] = 'Lizentzia gehigarriak';
$string['licenseversion'] = 'Lizentziaren bertsioa';
$string['loadingdata'] = 'Datuak kargatzen.';
$string['lookforupdates'] = 'Bilatu H5P eguneraketak';
$string['maximumgrade'] = 'Kalifikazio altuena';
$string['maximumgradeerror'] = 'Sartu zenbaki oso eta positibo baliagarria ekintza honetarako gehienezko puntuazio-gisa';
$string['maxpostsizetoosmall'] = 'Zure PHPko post_max_size parametroaren balioa nahiko baxua da. Ezarpen horrekin ezin duzu igo {$a->%number} MBtik gorako tamaina duen fitxategirik. Hori arazo bihur daiteke H5Pak, irudiak eta bideoak igotzerakoan. Azter ezazu 5 MB baino muga handiagoa ezartzea, mesedez.';
$string['maxscore'] = 'Puntuazio altuena';
$string['maxuploadsizetoosmall'] = 'Zure PHPko max_upload_size parametroaren balioa nahiko baxua da. Ezarpen horrekin ezin duzu igo {$a->%number} MBtik gorako tamaina duen fitxategirik. Hori arazo bihur daiteke H5Pak, irudiak eta bideoak igotzerakoan. Azter ezazu 5 MB baino muga handiagoa ezartzea, mesedez.';
$string['messageprovider:confirmation'] = 'Zure H5P bidalketen baieztapena';
$string['messageprovider:submission'] = 'H5P bidalketen jakinarazpena';
$string['missingcontentfolder'] = 'Eduki-karpeta baliagarria falta da';
$string['missingcontentuserdata'] = 'Errorea: Ezin izan da edukiaren erabiltzaile-daturik aurkitu';
$string['missingcoreversion'] = 'Sistemak ezin izan du <em>{$a->%component}</em> osagarria paketetik instalatu, H5P pluginaren bertsio berriagoa behar baitu. Gune honetan {$a->%current} bertsioa dago martxan, eta {$a->%required} bertsioa edo ondorengoa behar da. Eguneratu eta berriro saiatu beharko zenuke.';
$string['missingdependency'] = '{$a->@lib} liburutegiak behar zuen {$a->@dep} mendekotasuna falta da.';
$string['missinglibrary'] = 'Beharrezkoa den {$a->@library} liburutegia falta da';
$string['missinglibraryfile'] = '"{$a->%file}" fitxategia falta da liburutegian: "{$a->%name}"';
$string['missinglibraryjson'] = 'Ezin izan da aurkitu library.json fitxategia {$a->%name} liburutegirako formatu egokia duen json fitxategirik';
$string['missinglibraryproperty'] = 'Eskatutako {$a->%property} ezaugarria falta da {$a->%library} liburutegian';
$string['missingmbstring'] = 'Mbstring PHP hedapena ez dago kargatuta. H5Pk funtzio hori behar du';
$string['missingparameters'] = 'Parametroak falta dira';
$string['missinguploadpermissions'] = 'Kontuan izan igo duzun fitxategian liburutegiak egon daitezkeela, baina ezin duzu liburutegi berririk igo. Jarri zaitez harremanetan guneko kudeatzailearekin.';
$string['modulename'] = 'Eduki interaktiboa';
$string['modulename_help'] = 'H5P jarduera-moduluak eduki interaktiboa sortzen ahalbidetzen dizu, hala nola, Bideo Interaktiboak, Galdera Sortak, Arrastatu eta Jaregin moduko Galderak, Aukera Anitzeko Galderak, Aurkezpenak eta askoz gehiago.

Eduki aberatseko egile-tresna izateaz gain, H5Pk fitxategiak inportatzea eta esportatzea ahalbidetzen dizu edukia berrerabili eta partekatzeko.

Erabiltzaileen agerraldiak eta emaitzak xAPI erabiliz gordetzen dira eta Moodleren kalifikazio-liburuan eskuragarri daude.

H5P eduki interaktiboa gehitu dezakezu txertatutako egile-tresna erabiliz edo H5P gaituta duten beste guneetako H5P fitxategiak igoz.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Eduki Interaktiboak';
$string['nextpage'] = 'Hurrengo orria';
$string['noanswersubmitted'] = 'Erabiltzaile honek oraindik ez du H5Pren erantzuna bidali';
$string['nocontent'] = 'Ezin da content.json fitxategia aurkitu edo aztertu';
$string['nocontenttype'] = 'Ez da eduki motarik zehaztu.';
$string['nocopyright'] = 'Ez dago eskuragarri eduki honetarako copyright informaziorik.';
$string['nodata'] = 'Ez dago eskuragarri zure irizpideekin bat datorren daturik.';
$string['noextension'] = 'Igo duzun fitxategia ez da HTML5 pakete baliagarria (Ez dauka .h5p fitxategi-luzapena)';
$string['noh5ps'] = 'Ikastaro honetan ez dago eduki interaktiborik.';
$string['nojson'] = 'h5p.json fitxategi nagusia ez da baliagarria';
$string['nombstringexteension'] = 'Mbstring PHP hedapena ez dago kargatuta. H5Pk funtzio hori behar du';
$string['noparameters'] = 'Parametrorik ez';
$string['noparse'] = 'Ezin da h5p.json fitxategia aztertu';
$string['nopermissiontogettranslations'] = 'Ez duzu itzulpenak eskuratzeko baimenik';
$string['nopermissiontorestrict'] = 'Ez duzu baimenik liburutegiak murrizteko.';
$string['nopermissiontosavecontentuserdata'] = 'Ez duzu baimenik edukiaren erabiltzaile-datuak gordetzeko.';
$string['nopermissiontosaveresult'] = 'Ez duzu baimenik eduki honetako emaitzak gordetzeko.';
$string['nopermissiontoupgrade'] = 'Ez duzu baimenik liburutegiak eguneratzeko.';
$string['nopermissiontouploadcontent'] = 'Ez duzu baimenik hona edukia igotzeko.';
$string['nopermissiontouploadfiles'] = 'Ez duzu baimenik hona fitxategiak igotzeko.';
$string['nopermissiontoviewcontenttypes'] = 'Ez duzu baimenik eduki motak ikusteko.';
$string['nopermissiontoviewresult'] = 'Ez duzu baimenik eduki honetako emaitzak ikusteko.';
$string['nosuchlibrary'] = 'Ez dago holako liburutegirik';
$string['notapplicable'] = 'E/A';
$string['nounzip'] = 'Igo duzun fitxategia ez da HTML5 pakete baliagarria (Ezin dugu deskonprimatu)';
$string['noversionattribution'] = 'Aitortza';
$string['noversionattributionnc'] = 'Aitortu-EzKomertziala';
$string['noversionattributionncnd'] = 'Aitortu-EzKomertziala-LanEratorririkGabe';
$string['noversionattributionncsa'] = 'Aitortu-EzKomertziala-PartekatuBerdin';
$string['noversionattributionnd'] = 'Aitortu-LanEratorririkGabe';
$string['noversionattributionsa'] = 'Aitortu-PartekatuBerdin';
$string['nowriteaccess'] = 'Zerbitzariaren idazteko baimenekin zerikusia duen arazoa aurkitu da. Ziurtatu ezazu mesedez zure zerbitzariak datuen direktorioan idazteko baimena duela.';
$string['noziparchive'] = 'Zure PHP bertsioak ez du ZipArchive onartzen.';
$string['offlinedialogbody'] = 'Ezin izan dugu zeregin honen osaketaren inguruko informaziorik bidali. Egiaztatu ezazu mesedez zure Internet-erako konexioa.';
$string['offlinedialogheader'] = 'Zure zerbitzariarekiko konexioa eten egin da';
$string['offlinedialogretrybuttonlabel'] = 'Berriz saiatu orain';
$string['offlinedialogretrymessage'] = 'Berriz saiatuko :num-(e)tan...';
$string['offlinesuccessfulsubmit'] = 'Emaitzak ondo bidali dira.';
$string['oldphpversion'] = 'Zure PHP bertsioa zaharkituta dago. H5Pk ondo funtzionatzeko gutxienez 5.2 bertsioa behar du, eta 5.6 edo berriagoa erabiltzea gomendatzen da.';
$string['olduploadoldcontent'] = 'H5P bertsio zahar bateko edukiak igotzen saiatzen ari zara. Mesedez eguneratu ezazu edukia sortu zenueneko zerbitzari eta ondoren saiatu zaitez berriz igotzen edo gaitu ezazu H5P Bilgunea zerbitzari hau automatikoki eguneratu dadin.';
$string['onlyupdate'] = 'Eguneratu oraingo liburutegiak soilik';
$string['options'] = 'Aukerak';
$string['originator'] = 'Sortzailea';
$string['pd'] = 'Domeinu Publikoa';
$string['pddl'] = 'Domeinu Publikoaren Lagapena eta Lizentzia';
$string['pdm'] = 'Domeinu Publikoaren Marka';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Emandako amaiera-puntura sartzeko argitaratze-mezua behar da';
$string['previouspage'] = 'Aurreko orria';
$string['privacy:metadata:core_files'] = 'H5P jarduerak H5P edukiaren parte gisa igotako fitxategiak gordetzen ditu.';
$string['privacy:metadata:core_grades'] = 'H5P jarduerak H5P edukiari erabiltzaileek emandako erantzunen kalifikazioak gordetzen ditu.';
$string['privacy:metadata:hvp_content_user_data'] = 'Erabiltzaile baten eduki baten oraingo egoera deskribatzen du. Edukia aurreko egoera batera bueltatzeko erabiltzen da.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Gordetako erabiltzaile-datuak.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Datu motaren identifikatzailea.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Edukia aldatzean datuak ezabatu behar diren adierazteko marka.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'Datuei dagokien H5P edukiaren IDa.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'Erabiltzaile-datuei dagokien H5P edukiaren IDa.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Datuak edukietan aurrez kargatu behar diren adierazteko marka.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'H5Pren azpiedukia, 0 azpiedukia ez bada.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'Datuen jabea den erabiltzailearen IDa.';
$string['privacy:metadata:hvp_events'] = 'Erregistratutako H5P ekitaldien jarraipena egiten du.';
$string['privacy:metadata:hvp_events:content_id'] = 'Ekintza egin zen edukiaren IDa, 0 berria bada edo edukirik ez badago.';
$string['privacy:metadata:hvp_events:content_title'] = 'Edukiaren izenburua';
$string['privacy:metadata:hvp_events:created_at'] = 'Ekitaldia sortu zeneko unea';
$string['privacy:metadata:hvp_events:id'] = 'Ekitaldiaren ID bakarra.';
$string['privacy:metadata:hvp_events:library_name'] = 'Ekitaldiak eragin dion liburutegia.';
$string['privacy:metadata:hvp_events:library_version'] = 'Ekitaldiak eragin dion liburutegiaren bertsioa.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Ekitaldiaren azpiko mota edo ekintza.';
$string['privacy:metadata:hvp_events:type'] = 'Ekitaldi mota.';
$string['privacy:metadata:hvp_events:user_id'] = 'Ekintza egin zuen erabiltzailearen IDa.';
$string['privacy:metadata:hvp_xapi_results'] = 'H5P edukiaren xAPI ekitaldiak gordetzen ditu.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'H5Pk bidali dezakeen informazio gehigarria.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'Ekitaldia egin zeneko edukiaren IDa.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Erantzun zuzenaren patroia.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Ekitaldia egin zeneko edukiaren deskribapena, zeregina edo galdera.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'xAPI ekitaldiaren ID bakarra.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Elkarrekintza mota.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Ekitaldian lortu daitekeen gehienezko puntuazioa.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'Ekitaldi hau egin zeneko edukiaren goragoko edukiaren IDa. Hutsik goragoko edukirik ez badu.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Ekitaldian lortutako puntuazioa.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Erabiltzaileak bidalitako erantzuna.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'Ekintza burutu zuen erabiltzailearen IDa.';
$string['question'] = 'Galdera';
$string['removeoldlogentries'] = 'Ezabatu H5P erregistroko sarrera zaharrak';
$string['removeoldmobileauthentries'] = 'Ezabatu H5P mobile autentifikazio erregistro zaharrak';
$string['removetmpfiles'] = 'Ezabatu aldi baterako H5P fitxategi zaharrak';
$string['reportingquestionsremaininglabel'] = 'galdera kalifikatzea falta da';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Kalifikazio-liburuko puntuazioa:';
$string['reportingscoredelimiter'] = 'hauen artean';
$string['reportingscorelabel'] = 'Puntuazioa:';
$string['reportnotsupported'] = 'Ez onartua';
$string['reportsubmitgradelabel'] = 'Bidali kalifikazioa';
$string['resizescript'] = 'Gehitu script hau zure webgunean txertatutakoo edukiaren tamaina dinamikoki egokitzea nahi baduzu:';
$string['resubmitscores'] = 'Gordetako emaitzak bidaltzen saiatzen.';
$string['reuse'] = 'Berrerabili';
$string['reusecontent'] = 'Berrerabili edukia';
$string['reusedescription'] = 'Berrerabili eduki hau';
$string['reveal'] = 'Jakinarazi';
$string['reviseserversetupandretry'] = 'Zure zerbitzariaren ezarpenak berrikusi ondoren H5P bilgunearekiko komunikazioa berriro gai dezakezu H5P ezarpenetan.';
$string['score'] = 'Puntuazioa';
$string['search'] = 'Bilatu';
$string['sendusagestatistics'] = 'Partekatu erabilpen-estatistikak';
$string['sendusagestatistics_help'] = 'Erabilpen-estatistiken zenbakiak automatikoki bidaliko dira garatzaileei H5P nola erabiltzen den hobeto ulertzen laguntzeko eta hobekuntza-arloak identifikatzeko. Irakurri gehiago <a {$a}>h5p.or webgunean biltzen diren datuen</a> inguruan.';
$string['settings'] = 'H5P ezarpenak';
$string['showadvanced'] = 'Erakutsi aurreratuak';
$string['showless'] = 'Erakutsi gutxiago';
$string['showmore'] = 'Erakutsi gehiago';
$string['sitecouldnotberegistered'] = 'Zure gunea ezin izan da bilgunean erregistratu. Mesedez jarri harremanetan zure guneko kudeatzailearekin.';
$string['sitekey'] = 'Gunearen gakoa';
$string['sitekeydescription'] = 'Gunearen kodea gune hau Bilgunean identifikatzen duen sekretua da.';
$string['sitekeyregistered'] = 'Gako bakarra eman zaizu eguneraketa berriak jasotzean Bilgunean identifikatzen zaituena. Gakoa "H5P ezarpenak" orrian ikusi dezakezu.';
$string['size'] = 'Tamaina';
$string['source'] = 'Iturria';
$string['sslnotenabled'] = 'Zure zerbitzariak ez du SSL-a gaituta. SSL-a gaitu beharko zenuke H5P bilgunearekiko konexioa segurua dela bermatzeko.';
$string['startingover'] = 'Berriro hasiko zara.';
$string['sublevel'] = 'Azpimaila';
$string['successfullyregisteredwithhub'] = 'Zure webgunea H5P Bilgunean ondo erregistratu da.';
$string['thumbnail'] = 'Irudi txikia';
$string['title'] = 'Izenburua';
$string['unabletocreatedir'] = 'Ezin da direktorioa sortu.';
$string['unabletogetfieldtype'] = 'Ezin da eremu mota lortu.';
$string['undisclosed'] = 'Ez da ezagutarazi';
$string['unpackedfilesexceedsmaxsize'] = 'Erauzitako fitxategien guztirako tamainak baimendutako gehienezko tamaina gainditzen dute. (%used > %max)';
$string['updatedlibraries'] = '{$a->%old} H5P liburutegi zahar eguneratu dira.';
$string['updatedlibrary'] = 'H5P liburutegi zahar {$a->%old} eguneratu da.';
$string['updatelibraries'] = 'Eguneratu liburutegi guztiak';
$string['upgrade'] = 'Eguneratu H5P';
$string['upgradebuttonlabel'] = 'Eguneratu';
$string['upgradedone'] = '{$a} eduki-instantzia ondo eguneratu dira.';
$string['upgradeerror'] = 'Errorea gertatu da parametroak prozesatzerakoan:';
$string['upgradeerrorcontent'] = '%id edukia ezin izan da eguneratu:';
$string['upgradeerrordata'] = '%lib liburutegiko datuak ezin izan dira kargatu.';
$string['upgradeerrormissinglibrary'] = 'Beharrezko %lib liburutegia falta da.';
$string['upgradeerrornotsupported'] = 'Parametroek %used daukate eta hori ez da onartzen.';
$string['upgradeerrorparamsbroken'] = 'Parametroak hautsi dira.';
$string['upgradeerrorscript'] = '%lib(e)rako eguneratze-scripta ezin izan da kargatu.';
$string['upgradeerrortoohighversion'] = 'Parametroek %used daukate eta soilik %supported edo zaharragoak onartzen dira.';
$string['upgradeheading'] = 'Eguneratu {$a} edukia';
$string['upgradeinprogress'] = '%ver bertsiora eguneratzen...';
$string['upgradeinvalidtoken'] = 'Errorea: Segurtasun-token baliogabea!';
$string['upgradelibrarycontent'] = 'Eguneratu liburutegiaren edukia';
$string['upgradelibrarymissing'] = 'Errorea: Zure liburutegia falta da!';
$string['upgrademessage'] = '{$a} eduki-instantzia eguneratzera zoaz. Aukeratu mesedez eguneratzeko bertsioa.';
$string['upgradenoavailableupgrades'] = 'Ez dago eskuragarri liburutegi honetarako ez dago eguneraketarik.';
$string['upgradenothingtodo'] = 'Ez dago eguneratzeko eduki-instantziarik.';
$string['upgradereturn'] = 'Itzuli';
$string['upload'] = 'Igo';
$string['uploadlibraries'] = 'Igo liburutegiak';
$string['uploadsizelargerthanpostsize'] = 'PHPn ezarritako igotzeko gehienezko tamaina argitaratze-tamaina baino handiago da. Hainbat instalaziotan honek arazoak sortu izan ditu.';
$string['user'] = 'Erabiltzailea';
$string['validatingh5pfailed'] = 'H5P paketearen balioztatzeak huts egin du.';
$string['validationfailed'] = 'Eskatutako H5P fitxategia baliogabea zen';
$string['viewreportlabel'] = 'Txostena';
$string['welcomecommunity'] = 'H5P gustukoa izatea eta etengabe hazten ari den gure komunitatearen partaide egitea espero dugu gure <a {$a->forums}>foroen</a> bitartez.';
$string['welcomecontactus'] = 'Feedbacken bat baduzu, jar zaitez <a {$a}>gurekin harremanetan</a>. Zure iruzkinak kontuan hartzen ditugu, H5P gero eta hobeagoa izatea gure zeregina baita!';
$string['welcomegettingstarted'] = 'H5P eta Moodlerekin hasteko, emaiozu begiratua gure <a {$a->moodle_tutorial}>eskuliburuari</a> eta inspiratzeko ikusi itzazu <a {$a->example_content}>adibideak</a> H5P.org webgunean.';
$string['welcomeheader'] = 'Ongi etorri H5Pren mundura!';
$string['wrongversion'] = 'Eduki honetan erabilitako H5P {$a->%machineName} liburutegiaren bertsioa baliogabea da. Edukia {$a->%contentLibrary} liburutegia erabiltzen ari da, baina {$a->%semanticsLibrary} izan beharko luke.';
$string['year'] = 'Urtea';
$string['years'] = 'Urte(ak)';
$string['yearsfrom'] = 'Urteak (noiztik)';
$string['yearsto'] = 'Urteak (noiz arte)';
