<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'de', version '3.8'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Unsere Demo-Website ist eine vollständige Moodle-Instanz mit Beispielkursen, die Sie in den Rollen Trainer, Teilnehmer und Administrator ausprobieren können. Haben Sie bitte keine Sorge, dabei etwas kaputt zu machen ... die Website wird jede Stunde auf einen ordentlichen Zustand zurückgesetzt.';
$string['aboutdemositetitle'] = 'Demo-Website';
$string['aboutintro'] = 'Moodle ist ein Open Source Course Management System (CMS - deutsch: Kursverwaltungssystem), auch bekannt als ein Learning Management System (LMS - deutsch: Lernbetreuungssystem) oder ein Virtual Learning Environment (VLE - deutsch: Virtuelle Lernumgebung). Moodle ist inzwischen auf der ganzen Welt zu einem bei Unterrichtenden sehr beliebten Werkzeug geworden, um dynamische Webseiten für die Lernenden zu erstellen. Moodle muss irgendwo auf einem Webserver installiert werden, entweder auf einem Ihrer eigenen Computer oder bei einer Firma für Webhosting.';
$string['aboutoverview'] = '<p>Im Mittelpunkt des gesamten Moodle-Projekts steht immer, Lehrenden die besten Werkzeuge zur Unterstützung und Verwaltung von Lernen bereitzustellen, aber es gibt zahlreiche weitere Möglichkeiten zur Moodle-Nutzung:</p>
<ul>
<li>Moodle besitzt Elemente, die es erlauben, das Programm auf sehr große Anwendungen mit hunderttausend Lernenden zu skalieren, aber gleichzeitig auch in kleinem Rahmen einer Grundschule oder bei Lernexperimenten zu benutzen.</li>
<li>Viele Institutionen verwenden Moodle als Plattform, um ihre Kurse ausschließlich online anzubieten, während andere damit einen einfachen Weg gefunden haben, ihre Präsenzkurse mit zusätzlichen Online-Materialien zu ergänzen (bekannt auch als Blended Learning).</li>
<li>Viele unserer Nutzer/innen mögen die zahlreichen Aktivitäten (etwa Foren, Wikis, Datenbanken usw.), um höchst kooperative Lerngruppen und Communities zu fördern, die sich (in sozial-konstruktionistischer Tradition) um die eigentlichen Lerngegenstände herum bilden. Andere dagegen bevorzugen Moodle als Transportmittel, um Lernmaterialien auszuliefern (etwa in Form von SCORM-Paketen) und Lernfortschritte über Aufgaben und Test zu steuern.</li>
</ul>';
$string['aboutoverviewtitle'] = 'Was ist Moodle?';
$string['aboutstatistics'] = 'Moodle kann kostenfrei heruntergeladen und installiert werden. Eine Registrierung ist freiwillig, weswegen uns keine vollständigen Informationen über die Nutzerzahlen zur Verfügung stehen. Aus den Registrierungsdaten werden auf unserer Website automatisch Statistiken und grafische Darstellungen erstellt.';
$string['aboutstatisticsheading'] = 'Moodle-Statistiken';
$string['aboutstatisticstitle'] = 'Moodle.org: Moodle-Statistiken';
$string['activeusers24hours'] = 'Zugriff von registrierten Nutzer/innen (letzter Tag):';
$string['activeuserspastmonth'] = 'Zugriff von registrierten Nutzer/innen (letzter Monat):';
$string['browsegittitle'] = 'Hier finden Sie den Programmcode';
$string['cachedef_frontpagecolumn'] = 'Startseitenspalten';
$string['cachedef_usefulposts'] = 'Hilfreiche Beiträge';
$string['communities'] = 'Communities';
$string['communitiesmy'] = 'Meine Communities';
$string['community'] = 'Community';
$string['communityadministration'] = 'Community-Verwaltung';
$string['communitycurrent'] = 'Diese Community';
$string['communityenrolme'] = 'Werden Sie Mitglied in dieser Community';
$string['communityenrolmentoptions'] = 'Der Community beitreten';
$string['communityintro'] = 'Moodle hat eine große und vielfältige Community mit mehr als <a href="http://moodle.org/userpics">{$a->usercount} registrierten Nutzer/innen</a> alleine auf dieser Moodle-Seite. Sie sprechen mehr als <a verschiedene  href="http://download.moodle.org/langpack/">{$a->langcount} Sprachen</a> und kommen aus <a href="http://moodle.org/sites">{$a->countrycount} Ländern</a>. (<a href="http://moodle.org/stats">Weitere Statistiken</a>).';
$string['communityjoinbyyourself'] = 'Tragen Sie sich selber ein';
$string['communityjoinbyyourselfas'] = 'Tragen Sie sich ein als {$a->rolename}';
$string['communitynoguestaccess'] = 'Gäste können auf diese Community nicht zugreifen. Versuchen Sie sich einzuloggen.';
$string['communitynotenrollable'] = 'Sie können sich in diese Community nicht selber eintragen. Bitte nehmen Sie mit einem der Facilitator Kontakt auf.';
$string['communitysomeallowguest'] = 'Einige - genauer, die meisten - Communities ermöglichen Gästen den Zutritt.';
$string['communityunenrolme'] = 'Die Community {$a} wieder verlassen';
$string['conferencecenter'] = 'Moodle-Konferenzzentrum';
$string['connectedsites'] = 'Einige Moodle-Systeme sind über ein Moodle-Netzwerk mit moodle.org verbunden. Wen Sie hier authentifiziert sind, können Sie sich direkt in diesen Systemen einloggen.';
$string['contactbugs'] = 'Sie können Probleme mit der Moodle-Software und mit jeder Website von Moodle.org melden, indem Sie einen Fehlerbericht in den Moodle-Tracker eintragen.';
$string['contactbugstitle'] = 'Fehlerberichte';
$string['contactintro'] = 'Bitte wählen Sie eine der folgenden Kontaktmöglichkeiten:';
$string['contactlogin'] = 'Für alle übrigen Fragen loggen Sie sich bitte auf der Website ein. Benutzen Sie anschließend das Kontaktformular, das auf dieser Seite erscheinen wird.';
$string['contactmoodlecom'] = 'Für alle Fragen zu Lizensierung, Warenzeichen oder kommerzieller Nutzung wenden Sie sich bitte an das Hilfesystem von <a href="http://moodle.com/">Moodle.com</a>. Dies gilt auch für spezielle Moodle-Entwicklungen.';
$string['contactmoodlecomhelpdesk'] = 'Hilfesystem von Moodle.com';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Bei Problemen mit Ihren Zugangsdaten bei Moodle.org schreiben Sie bitte eine E-Mail an diese Adresse:';
$string['contactmoodleorglogin'] = 'Melden Sie sich jetzt bitte für diese Website an';
$string['contactmoodleorgother'] = 'Für alle weiteren Fragen nutzen Sie bitte das folgende Kontaktformular.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'Erkannte Sicherheitprobleme können in den Tracker eingetragen werden, wobei Sie die Sicherheitsstufe ebenfalls einschätzen sollen.';
$string['contactsent'] = 'Ihre Nachricht wurde per E-Mail an den Manager der Moodle-Community gesandt.';
$string['contactsupport'] = 'Zur Unterstützung bei der Nutzung der Moodle-Software lesen Sie bitte unsere Support-Seiten, wo Sie  unendlich viele hilfreiche Ressoursen finden werden.';
$string['contactsupporttitle'] = 'Support';
$string['demomoodlenet'] = 'Demo-Website';
$string['developercredits'] = 'Entwickler';
$string['developerlist'] = 'Vollständige Liste der Entwickler mit Schreibrechten';
$string['developermeetings'] = 'Entwicklertreffen';
$string['developers'] = 'Die Entwicklung von Moodle wird durch das Kernteam bei Moodle.com geleitet, unterstützt durch hunderte weiterer Entwickler weltweit. Viele dieser Entwickler sind direkt verantwortlich für unterschiedliche Module, Plugins oder Sprachpakete.';
$string['developerstitle'] = 'Entwickler';
$string['developmentdocs'] = 'Der Hauptteil unserer Dokumentation befindet sich in den Moodle Docs - einschließlich aller Spezifikationen, Gedanken, Diskussionen, Funktionen und Standards wie auch aller Anleitungen für die Endbenutzer.';
$string['developmentdocstitle'] = 'Entwicklerdokumentation';
$string['developmentintro'] = 'Wir streben einen transparenten und offenen Entwicklungsprozess an, der die gesamte Nutzer-Community zum Mitmachen einlädt. Wir begrüßen besonders PHP-Programmierer, aber Sie können sich auch durch Diskussionen, Testing, Feedback und Dokumentation beteiligen.';
$string['developmenttracker'] = 'Alle Entwicklungsergebnisse (wie Fehlerkorrekturen, Verbesserungen und neue Features) werden im Moodle-Tracker aufgezeichnet und verwaltet. Sie können beobachten, wer an was gerade arbeitet und sich selber an den Unterhaltungen beteiligen. Sie sollten immer zuerst im Tracker suchen, falls Sie etwas über spezielle Vorgänge herausfinden möchten. Bitte stimmen Sie über die Kernfragen ab (<strong>vote</strong>), die Sie vorrangig bearbeitet haben möchten, um uns bei der Einschätzung von Entwicklungsentscheidungen zu unterstützen.';
$string['donations'] = 'Moodle ist finanziell völlig unabhängig.Viele Mitglieder der Community haben Moodle bereits finanziell unterstützt, um damit die Softwareentwickler zu bezahlen, die Moodle pflegen und weiterentwickeln.';
$string['donations10over'] = 'Andere Spenden von 10$ oder mehr';
$string['donationsassociation'] = 'Treten Sie der <a href="https://moodleassociation.org/">Moodle Users Association</a> bei - Helfen Sie mit zu entscheiden, wie die Mitgliedsbeiträge für Elemente der Moodle-Roadmap ausgegeben werden sollen';
$string['donationsdevelopment'] = 'Die Entwicklung von Moodle und die Pflege aller unserer Gemeinschaftsseiten kostet uns jedoch viel Geld, und wir können immer zusätzliche Unterstützung gebrauchen. Wenn Sie Moodle lieben oder es für Ihr Unternehmen, Ihre Schule oder Institution nützlich gefunden haben, dann spenden Sie bitte. Jedes Bisschen hilft.';
$string['donationsdonatenow'] = 'Jetzt spenden';
$string['donationsensure'] = 'Spenden stellen sicher, dass die wesentlichen Zahnrädchen der Moodle-Maschine (unsere Entwickler) weiterhin neue Funktionen erschaffen und Fehler beheben, um Moodle für uns alle besser zu machen.';
$string['donationsmoney'] = 'Sie können Ihre Spende direkt dem Fond zukommen lassen. Alle Beiträge werden genutzt, um Wünsche auf der Roadmap Wirklichkeit werden zu lassen. Wenn Sie per Kreditkarte zahlen wollen können Sie den Paypal-Button verwenden und in vielen verschiedenen Währungen unkompliziert bezahlen.<br/><br/>Wenn Sie einen Betrag von mehr als 10 $ spenden, wird Ihr Name auf dieser Seite für ein Jahr angezeigt. Dazu klicken Sie nach dem Zahlvorgang auf den \'Fortsetzen (Continue)\'-Button. Auf der folgenden Seite legen Sie fest, wie Ihr Eintrag erscheinen soll.';
$string['donationsmoodle'] = 'Spenden für Moodle';
$string['donationsopensource'] = 'Moodle ist echte Open Source und völlig frei von finanziellen Verpflichtungen für unsere Nutzer - so sollte Software sein!';
$string['donationsover1000'] = 'Frühere Spenden über 1000$';
$string['donationsover200'] = 'Andere Spenden über 200$';
$string['donationsover500'] = 'Andere Spenden über 500$';
$string['donationspartner'] = 'Nutzen Sie einen <a href="https://moodle.com/partners/">zertifizierten Moodle-Partner</a> für Dienstleistungen – 10% ihrer Einnahmen fließen in das Moodle-Projekt.';
$string['donationsservices'] = 'Falls Sie für sich einen Bedarf an Moodle-Dienstleistungen wie etwa Hosting, Support, Installation, kundenspezifische Anpassungen, Kursentwicklung oder die Beratung haben, kontaktieren Sie bitte Ihren lokalen autorisierten <a href="http://moodle.com/">Moodle-Partner aus Moodle.com</ a>. Sie sollten die entsprechenden Werbebanner auf dieser Seite sehen können. Die Moodle-Partner führen einen festen Prozentsatz ihrer Einnahmen an den Fond des Moodle-Trusts ab und gewährleisten damit die Weiterentwicklung von Moodle ... und davon profitieren dann wiederum alle.';
$string['donationsshop'] = 'Kaufen Sie etwas aus unserem <a href="http://www.zazzle.com/moodle_hq/">Moodle store</a> und benutzen Sie es mit Stolz!';
$string['donationsthankeveryone'] = 'Vielen Dank an alle, die zum Moodle-Projekt beigetragen haben.';
$string['donationsthankyou'] = 'Vielen Dank';
$string['donationstitle'] = 'Spenden';
$string['donationstrust'] = 'Moodle besitzt einen Entwicklerfond des Moodle-Trusts, aus dem Arbeitsverträge bezahlt und alle Ausgaben für Moodle.org geleistet werden.';
$string['donationsways'] = 'Andere Möglichkeiten, finanziell zu Moodle beizutragen:';
$string['download_forandroid'] = 'Für Android';
$string['download_forios'] = 'Für iOS';
$string['download_helpbox_partners'] = 'Moodle-Partner';
$string['download_hero_headline'] = 'Moodle ist freie Software.';
$string['downloadcore'] = 'Unser vorrangiger Vertriebskanal ist die Bereitstellung der Standardpakete (standard core packages), die das Moodle-Kernsystem zusammen mit einer gewissen Anzahl von Modulen enthalten und von den Kernentwicklern gewartet werden. Diese Pakete eignen sich zur Installation auf den fast allen Plattformen, auf denen bereits PHP und eine Datenbank vorhanden sind.';
$string['downloadcoretitle'] = 'Moodle-Standardpakete';
$string['downloadintro'] = 'Moodle ist Open Source unter der <a href="http://docs.moodle.org/dev/License">GPL Lizenz</a>. Alles, was wir produzieren, ist für Sie frei zugänglich, herunterladbar und nutzbar.';
$string['downloadlang'] = 'In allen aktuellen Moodle-Versionen wurde das Nachladen zusätzlicher Sprachpakete über das Administrationsmenü automatisiert. In älteren Versionen müssen die Sprachpakete teilweise manuell heruntergeladen werden.';
$string['downloadlangtitle'] = 'Sprachpakete';
$string['downloadlogotitle'] = 'Moodle-Logos';
$string['downloadmac'] = 'Auch ohne einen eigenen Webserver zu haben, erlauben Ihnen diese All-in-one Pakete die einfache Moodle-Installation auf jedem Apple-Computer mit Mac OS X.';
$string['downloadmactitle'] = 'Moodle für Mac OS X';
$string['downloadmodules'] = 'Stöbern Sie in unserer umfassenden Datenbank von zusätzlichen Modulen und Plugins, die Sie in Ihre Moodle-Website integrieren können, um erweiterte Funktionalitäten über die Standardpakete hinaus zu erhalten.';
$string['downloadmodulestitle'] = 'Module und Plugins';
$string['downloadthemes'] = 'Das äußere Erscheinungsbild einer Moodle-Website kann entscheidend durch die Benutzung unterschiedlicher Designs (themes) verändert werden. Wir verfügen über eine Datenbank mit unterschiedlichen Designs, die Moodle-Nutzer/innen entwickelt haben und mit anderen teilen.';
$string['downloadthemestitle'] = 'Designs';
$string['downloadviagit'] = 'Sie können Moodle auch<a href="http://docs.moodle.org/en/Git_for_Administrators">mit Git herunterladen</a>.';
$string['downloadviagitcvs'] = 'Weitere Möglichkeiten Moodle herunterzuladen: <a href="http://docs.moodle.org/en/Git_for_Administrators">Download über Git</a> oder <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">Download über CVS</a>.';
$string['downloadwin'] = 'Falls Sie bisher keinen eigenen Webserver betreiben, so ist es mit diesen All-in-one Paketen sehr einfach, ein Moodle auf einem beliebigen Computer mit Microsoft Windows zu installieren.';
$string['downloadwintitle'] = 'Moodle für Windows';
$string['erroradminonly'] = 'Auf diese Schnittstelle dürfen nur Administratoren zugreifen';
$string['erroralreadyvoted'] = 'Sie haben bereits für {$a} abgestimmt';
$string['errormaxmessages'] = 'Sie dürfen nicht mehr als 3 Nachrichten versenden';
$string['errornomainnews'] = 'Ein Nachrichtenforum für diese Website wurde nicht gefunden';
$string['errorsendingmail'] = 'Fehler beim Senden einer Nachricht -  versuchen Sie es später nochmal oder kontaktieren Sie den Administrator';
$string['eventdonation_submitted'] = 'Spende eingereicht';
$string['events'] = 'Auch wenn wir uns auf Online-Lernen spezialisieren, ist es immer wieder nett, sich gemeinsam in einem realen Raum zu treffen! Schauen Sie sich bitte die Links an, die Sie mit umfassenden Informationen zu unseren Konferenzen (wir nennen sie MoodleMoots) und zu anderen Veranstaltungen versorgen.';
$string['eventstitle'] = 'Veranstaltungen';
$string['feed_events'] = 'Events';
$string['feed_events_more'] = 'Weitere Kalendereinträge';
$string['feed_news'] = 'Ankündigungen';
$string['feed_news_more'] = 'Alle Ankündigungen anzeigen';
$string['feed_resources'] = 'Ressourcen';
$string['feed_useful'] = 'Hilfreiche Beiträge';
$string['feed_useful_more'] = 'Weitere Beiträge';
$string['focusbox_community'] = 'Community-Diskussionen';
$string['focusbox_community_text'] = 'Treten Sie unserer Community bei. Teilen Sie Ihre Ideen und Lösungen mit anderen Moodlern weltweit.';
$string['focusbox_community_viewall'] = 'Liste aller Communities';
$string['focusbox_future'] = 'Gestalten Sie die Moodle-Zukunft mit';
$string['focusbox_future_crowdfund'] = 'Crowd-Funding-Projekte';
$string['focusbox_future_gdf'] = 'Entwicklerdiskussionen';
$string['focusbox_future_research'] = 'Moodle-Forschung';
$string['focusbox_future_roadmap'] = 'Roadmap';
$string['focusbox_future_text'] = 'Finden Sie heraus, welche Entwicklungen demnächst kommen, und helfen Sie dabei mit.';
$string['focusbox_settingup'] = 'Installieren';
$string['focusbox_settingup_community'] = 'Community-Support';
$string['focusbox_settingup_download'] = 'Freier Download';
$string['focusbox_settingup_hosting'] = 'Hosting';
$string['focusbox_settingup_install'] = 'Installation';
$string['focusbox_settingup_own'] = 'Auf Ihrem eigenen Server';
$string['focusbox_settingup_partner'] = 'Über einen Moodle-Partner';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Kommerzieller Support';
$string['focusbox_teaching'] = 'Mit Moodle unterrichten';
$string['focusbox_teaching_books'] = 'Bücher';
$string['focusbox_teaching_courses'] = 'Kurse und Inhalt';
$string['focusbox_teaching_docs'] = 'Dokumentation';
$string['focusbox_teaching_text'] = 'Lernen Sie die große Vielzahl von Werkzeugen und verfügbaren Materialien kennen.';
$string['focusbox_theproject'] = 'Das Moodle-Projekt';
$string['focusbox_theproject_about'] = 'Über Moodle';
$string['focusbox_theproject_devs'] = 'Entwickler';
$string['focusbox_theproject_hq'] = 'Moodle-Headquarter';
$string['focusbox_theproject_partners'] = 'Moodle-Partner';
$string['focusbox_theproject_stats'] = 'Statistiken';
$string['focusbox_theproject_text'] = 'Lernen Sie das Moodle-Projekt und unsere offenen kollaborativen Partnerschaften kennen.';
$string['focusbox_uptodate'] = 'Up-to-date bleiben';
$string['focusbox_uptodate_buzz'] = 'Moodle-Buzz';
$string['focusbox_uptodate_news'] = 'Ankündigungen';
$string['focusbox_uptodate_planet'] = 'Planet-Moodle';
$string['focusbox_uptodate_security'] = 'Sicherheits-Informationen';
$string['focusbox_uptodate_social'] = 'Social Media';
$string['focusbox_uptodate_text'] = 'Die letzten Moodle-News, Updates und Erfahrungen weltweit';
$string['frontpagewelcome1'] = 'Moodle ist ein Course Management System (CMS - deutsch: Kursverwaltungssystem), auch bekannt als ein Learning Management System (LMS - deutsch: Lernmanagementsystem) oder ein Virtual Learning Environment (VLE - deutsch: Virtuelle Lernumgebung). Moodle ist eine freie Webapplikation, die Lehrende zur Gestaltung von Seiten für effektives Online-Lernen nutzen können.';
$string['frontpagewelcome2'] = 'Moodle.org ist unsere Community-Website, auf der Moodle diskutiert und weiterentwickelt wird. Bitte benutzen Sie die Menüs, um sich umzuschauen und der Community beizutreten.';
$string['frontpagewelcometitle'] = 'Herzlich willkommen in der Moodle-Community!';
$string['generaldeveloperforum'] = 'Allgemeines Entwicklerforum';
$string['graphpopulation'] = 'Moodle-Nutzergrafik';
$string['graphregistrationmap'] = 'Karte der Moodle-Registrierungen';
$string['graphregistrationmapdesc'] = 'Top 10 aus den registrierten Websites in {$a} Ländern';
$string['graphusersites'] = 'Vergleich Moodle-Nutzer/innen gegen Websites';
$string['heroslide_community_description'] = 'Willkommen in der Moodle-Community. Moodle ist eines der größten Open-Source-Teams der Welt. Nutzen Sie dieses Potenzial.';
$string['heroslide_community_headline'] = 'Von der Community vorangetrieben, weltweiter Support.';
$string['heroslide_community_slidecontrol'] = 'Eine globale Community';
$string['heroslide_donate_headline'] = 'Helfen Sie uns, mit offener und qualitativ hochwertiger Bildung für alle etwas zu bewirken';
$string['heroslide_getstarted_description'] = 'Moodle ist die weltweit beliebteste Lernplattform. Erstellen Sie Ihre Online-Lernseite in wenigen Minuten!';
$string['heroslide_getstarted_headline'] = 'Der Einstieg ist leicht';
$string['heroslide_getstarted_slidecontrol'] = 'Beginnen Sie noch heute';
$string['heroslide_global_description'] = 'Verfügbar in mehr als 100 Sprachen. Kleine und große Institutionen, Organisationen und Unternehmen mit Millionen von Nutzer/innen weltweit vertrauen auf Moodle.';
$string['heroslide_global_headline'] = 'Unterstützung von Lernen weltweit';
$string['heroslide_global_slidecontrol'] = 'Unterstützung von Lernen weltweit';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_donate'] = 'Spenden';
$string['heroslide_link_features'] = 'Funktionen';
$string['heroslide_link_forums'] = 'Community-Foren';
$string['heroslide_link_getstarted'] = 'Jetzt loslegen';
$string['heroslide_link_sites'] = 'Registrierte Websites';
$string['heroslide_link_stats'] = 'Statistiken';
$string['heroslide_link_stories'] = 'Weiterlesen';
$string['heroslide_power_description'] = 'Die weltweit kostenlose Lernplattform, die Ihnen online zu effektiven Lehr- und Lernerfahrungen in einem gemeinsamen vertraulichen Umfeld verhilft.';
$string['heroslide_power_headline'] = 'Leistungsstark. Sicher. Open-Source.';
$string['heroslide_power_slidecontrol'] = 'Robuste Lernplattform';
$string['heroslide_story1_description'] = '"Führendes technologiegestützten Lernen ermöglicht es uns, die Entdeckungen, Kreativität und Chancen der Schüler zu fördern". - Professor Darrell Evans, Pro Vice-Chancellor (Learning and Teaching), Monash University';
$string['heroslide_story1_headline'] = 'Verbesserung des Lehrens und Lernens überall';
$string['heroslide_story2_description'] = 'Der weltweite Versand-, Logistik- und Seedienstleister GAC bietet mit seiner Corporate Academy Lern- und Entwicklungsinitiativen für mehr als 10.000 Mitarbeiter in über 70 Ländern an.';
$string['heroslide_story2_headline'] = 'Exzellenz in Corporate Learning';
$string['heroslide_story3_description'] = 'Das Forth Valley College ist eines der größten Colleges in Schottland, das mehr als 750 Kurse mit über 20.000 aktiven Nutzern auf seinen Seiten anbietet.';
$string['heroslide_story3_headline'] = 'Rundum flexible Ausbildung anbieten';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas (VSO) bietet interaktives Lernen und Unterstützung für Freiwillige auf internationaler Ebene, um globale Ausbildungsansätze zu ermöglichen.';
$string['heroslide_story4_headline'] = 'Unterstützung von Freiwilligen bei der Durchführung von Programmen zur Armutsbekämpfung';
$string['heroslide_story_description'] = '“Leading in technology-enabled learning enables us to facilitate student discovery, creativity and opportunity.” - Professor Darrell Evans, Pro Vice-Chancellor (Learning and Teaching), Monash University';
$string['heroslide_story_headline'] = 'Verbesserung von Lehren und Lernen überall';
$string['heroslide_story_slidecontrol'] = 'Moodle-Stories aus der ganzen Welt';
$string['jobs'] = 'Besuchen Sie unsere Job-Datenbank, um Informationen zu Moodle-bezogenen Angeboten weltweit zu erhalten.';
$string['logoinfo'] = 'Der Name Moodle™ ist eine eingetragenes Markenzeichen der Moodle Trust.

Falls Sie beabsichtigen, den Namen und/oder das Logo zu verwenden, um typische Moodle-Dienstleistungen (z.B. Moodle-Hosting, Moodle-Support, Moodle-Zertifizierung, Moodle-Training, Moodle-Consulting, Moodle-Anpassung, Moodle-Kursentwicklung, Moodle-Design, Moodle-Integration, Moodle-Installation) anzubieten oder als Namen einer Software zu verwenden, dann müssen Sie aufgrund der üblichen Markenbeschränkungen vorher ausdrücklich eine schriftliche Genehmigung von der Moodle Trust einholen. Wenden Sie sich bitte an den  <a href="http://moodle.com/helpdesk/">Moodle Helpdesk</a>.

Keine Beschränkungen gibt es für die Nutzung des Namens in anderen Zusammenhängen (z.B. um Moodle-Kurse anzubieten). Wenn Sie bezüglich Ihrer Nutzung nicht ganz sicher sind, ob Sie den Namen verwenden dürfen, fragen Sie uns bitte über den <a href="http://moodle.com/helpdesk/">Moodle Helpdesk</a>. Wir würden uns freuen, Ihnen entweder die offizielle Erlaubnis zu erteilen oder Sie bei der Änderung Ihrer Produktbeschreibung zu unterstützen.';
$string['logotitle'] = 'Moodle-Logo';
$string['moodledocs'] = 'Moodle-Docs';
$string['moodlepartner_corporate'] = 'Unternehmenstraining';
$string['moodlepartner_other'] = 'Andere Bereiche';
$string['moodlepartner_school'] = 'Schule';
$string['moodlepartner_university'] = 'Universität';
$string['mycoursesintro'] = 'Sie sind aktuell in den folgenden "Kursen" auf der Community-Website eingetragen, wobei jeder Bereich mindestens ein Forum beinhaltet.';
$string['nameabout'] = 'Über';
$string['nameaboutmoodle'] = 'Über Moodle';
$string['namecommercial'] = 'Kommerzielle Dienste';
$string['namecommunity'] = 'Community';
$string['namecontact'] = 'Kontakt';
$string['namedevelopment'] = 'Entwicklung';
$string['namedocumentation'] = 'Dokumentation';
$string['namedownloads'] = 'Downloads';
$string['nameevents'] = 'Veranstaltungen';
$string['nameforums'] = 'Foren';
$string['namemycourses'] = 'Meine Kurse';
$string['namenetwork'] = 'Verbundene Websites';
$string['namenews'] = 'Neuigkeiten';
$string['namesecurity'] = 'Sicherheitsmitteilungen';
$string['namesupport'] = 'Support';
$string['networkinfo'] = 'Die folgenden Moodle-Websites sind mit Moodle.org über das Moodle-Netzwerk verbunden, so dass Sie sich direkt von hier anmelden können.';
$string['networkintro'] = 'Die folgenden Moodle-Websites wurden über Moodle-Networking mit Moodle.org verbunden, so dass Sie direkt darauf zugreifen können.';
$string['networktitle'] = 'Verbundene Seiten';
$string['newregistrations'] = 'Neue Registrierungen';
$string['newstitle'] = 'Ankündigungen';
$string['noenrolledcoursesyet'] = 'Sie sind bisher in keinem der Kurse auf dieser Website eingetragen';
$string['partnerslogan'] = 'Das Moodle-Projekt wird weltweit von 60 zertifizierten <a href="http://moodle.com/partners/about/">Moodle-Partnern</a> unterstützt.';
$string['permalink'] = 'Dauerlink';
$string['pluginname'] = 'Moodle.org-Site';
$string['popularissues'] = 'Beliebteste Punkte';
$string['privacy:metadata:db:registerdonations:amount'] = 'Gespendeter Betrag';
$string['recentlyratedposts'] = 'Kürzlich bewertete Beiträge';
$string['recentpart'] = 'Diese Seite zeigt einige der Personen an, die die Website von Moodle.org heute besucht haben.';
$string['registeredsites'] = 'Institutionen müssen nicht bekannt geben, ob sie Moodle verwenden, weil Moodle ist frei und Open Source ist. Trotzdem haben sich viele Moodle-Websites entschieden, sich bei uns zu registrieren und in unserer Übersicht zu erscheinen.';
$string['registeredsitestitle'] = 'Registrierte Websites';
$string['registereduserslastday'] = 'Neue Nutzer/innen während der letzten 24 Stunden:';
$string['registereduserstotal'] = 'Registrierte Nutzer/innen insgesamt:';
$string['registrationgraphalt'] = 'Alle Moodle-Registrierungen über die Zeit';
$string['registrationgraphdesc'] = 'Wir führen regelmäßige <a href="http://docs.moodle.org/en/Usage">Website-Untersuchungen</ a> durch, um die Existenz der Websites sicherzustellen, was auch zur Verminderung der gezeigten Zahlen führen könnte';
$string['registrationslast6months'] = 'Alle Registrierungen während der letzten 6 Monate';
$string['registrationslastmonths'] = 'Registrierungen während der letzten {$a} Monate';
$string['registrationstotal'] = 'Alle aktuellen Registrierungen';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Kurse';
$string['resources_jobs'] = 'Jobs';
$string['resources_plugins'] = 'Plugins';
$string['roadmap'] = 'Moodle-Roadmap';
$string['rssdescription'] = 'Neue oder als hilfreich bewertete Beiträge auf Moodle.org';
$string['rsstitle'] = 'Foren bei Moodle.org';
$string['schooldemommoodlenet'] = 'Orange School aufrufen';
$string['searchmoodleorg'] = 'Moodle.org durchsuchen';
$string['securitytitle'] = 'Sicherheitsankündigungen';
$string['shop'] = 'Möchten Sie anderen zeigen, dass Sie Teil der Moodle-Community sind? Besuchen Sie unseren Shop mit Buttons, Shirts, Tassen, Notizheften und vielen anderen Dingen.';
$string['social-facebook-moodle'] = 'Offizielle Moodle-Seite bei Facebook';
$string['social-googleplus-community'] = 'Offizielle Moodle-Community-Seite bei Google+';
$string['social-googleplus-moodle'] = 'Offizielle Moodle-Seite bei Google+';
$string['social-linkedin-moodle'] = 'Offizielle Moodle-Seite bei LinkedIn';
$string['social-twitter-moodle'] = 'Offizielle Moodle-Ankündigungen zusammengefasst von Planet Moodle, Moodle Buzz und weitere hilfreiche Moodle-Forenbeiträge.';
$string['social-twitter-moodledev'] = 'Moodle-News aus der Entwicklung und zu Updates';
$string['social-twitter-moodlehq'] = 'Tweets aus dem Moodle-HQ';
$string['social-twitter-moodlejobs'] = 'Moodle-Jobbörse';
$string['social-twitter-moodlenet'] = 'Bereitgestellte Kurse und Inhalte';
$string['social-twitter-moodleplugins'] = 'Kürzlich veröffentlichte Moodle-AddOns';
$string['social-twitter-moodleresearch'] = 'News und Ankündigungen zur jährlichen MoodleResearch Conference und Moodle-bezogene Forschungsarbeiten';
$string['social-twitter-moodlesecurity'] = 'Moodle-Sicherheitsankündigungen';
$string['social-twitter-moodlesites'] = 'Statusupdates von Seiten und Diensten des Moodle-HQ-Netzwerks';
$string['social-twitter-moodlethemes'] = 'Kürzlich veröffentlichte Moodle-Themes';
$string['social-youtube-moodle'] = 'Offizieller Moodle-Channel auf Youtube';
$string['socialinfo'] = 'Wir sind in verschiedenen Sozialen Netzwerken vertreten, um das Bewusstsein für das Moodle-Projekt zu verbreiten und neue Nachrichten aus der Moodle-Welt zu teilen. Folgen Sie uns, um up-to-date zu bleiben und andere in der Community tu treffen.';
$string['socialtitle'] = 'Social Media';
$string['statscountries'] = 'Länder';
$string['statscourses'] = 'Kurse';
$string['statsenrolments'] = 'Einschreibungen';
$string['statsposts'] = 'Forumsbeiträge';
$string['statsquestions'] = 'Testfragen';
$string['statsresources'] = 'Materialien';
$string['statsteachers'] = 'Trainer/innen';
$string['statsusers'] = 'Nutzer/innen';
$string['supportbooks'] = 'Wir führen eine umfangreiche Liste von Moodle-Büchern, die Sie kaufen können.';
$string['supportcommercial'] = 'Die <a href="http://moodle.com/">Moodle-Partner</a> sind eine weltweite Gruppe von authorisierten Dienstleistern, die Ihnen ein Spektrum von zusätzlichen Moodle-Diensten anbieten.';
$string['supportdocs1'] = 'Die Moodle-Docs sind der richtige Ausgangspunkt für eine Unterstützung - besonders die häufig gestellten Fragen (FAQ) und deren Antworten.';
$string['supportdocs2'] = 'Eine einfache Möglichkeit, auf eine relevante Dokumentation zuzugreifen, ist der Klick auf den Link "Moodle Docs für diese Seite" am Ende jeder Seite in Ihrer eigenen Moodle-Website.';
$string['supportdocsfaq'] = 'FAQ - Häufig gestellte Fragen';
$string['supportdocslang'] = 'Moodle-Dokumentation in anderen Sprachen';
$string['supportforums'] = 'Unsere Nutzer-Community unterhält sich in Foren innerhalb von "Kursen" auf dieser Moodle-Website. Sie müssen sich in den Kurs "einschreiben", um einen Forumsbeitrag schreiben zu können. Die Einschreibung ist freiwillig und vollkommen kostenlos.';
$string['supportforumsenglish'] = 'Die wichtigste Anlaufstelle für Support und Diskussion mit Nutzern und Entwicklern finden Sie hier in englischer Sprache:';
$string['supportforumsenglishname'] = 'Using Moodle';
$string['supportforumslang'] = 'Das Hauptforum für Moodler für soziale Kontakte finden Sie hier in englischer Sprache:';
$string['supportforumslangname'] = 'Moodle-Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Wir haben zahlreiche weitere Foren in vielen Sprachen:';
$string['supportforumslistname'] = 'Liste aller Foren';
$string['supportintro'] = 'Sie sind nicht alleine! Es gibt zahlreiche Möglichkeiten, um bei Bedarf Hilfen zu Moodle zu erhalten.';
$string['top10countriesbyregistration'] = 'Top 10 Länder nach Registrierungen';
$string['top10sitesbycourses'] = 'Top 10 nach Kursen';
$string['top10sitesbyusers'] = 'Top 10 nach Nutzer/innen';
$string['url-about'] = 'http://docs.moodle.org/de/Was_ist_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/de/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'https://docs.moodle.org/de/';
$string['versionsused'] = 'Verwendete Versionen';
