<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'de', version '3.8'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Neue Rolle wird hinzugefügt';
$string['addrole'] = 'Neue Rolle hinzufügen';
$string['advancedoverride'] = 'Erweiterte Rollenänderung';
$string['allow'] = 'Erlauben';
$string['allowassign'] = 'Rollenzuweisung erlauben';
$string['allowed'] = 'Erlaubt';
$string['allowoverride'] = 'Rollenänderung erlauben';
$string['allowroletoassign'] = 'Nutzer/innen mit der Rolle {$a->fromrole} erlauben, die Rolle {$a->targetrole} zuzuweisen';
$string['allowroletooverride'] = 'Nutzer/innen mit der Rolle {$a->fromrole} erlauben, die Rolle {$a->targetrole} zu verändern';
$string['allowroletoswitch'] = 'Nutzer/innen mit der Rolle {$a->fromrole} erlauben, in die Rolle {$a-targetrole} zu wechseln';
$string['allowroletoview'] = 'Nutzer/innen mit der Rolle {$a->fromrole} erlauben, die Rolle {$a->targetrole} zu sehen';
$string['allowswitch'] = 'Rollenwechsel erlauben';
$string['allowview'] = 'Rollenansicht erlauben';
$string['allsiteusers'] = 'Alle Nutzer/innen der Website';
$string['analytics:listinsights'] = 'Einschätzungen auflisten';
$string['analytics:listowninsights'] = 'Eigene Erkenntnisse auflisten';
$string['analytics:managemodels'] = 'Modelle verwalten';
$string['archetype'] = 'Grundform der Rolle';
$string['archetype_help'] = 'Die Basisrolle legt alle Rechte fest, die eine Rolle in ihrem Ausgangszustand besitzt. Hier werden auch alle neuen Rechte für eine Rolle eingefügt, wenn die Website aktualisiert wird.';
$string['archetypecoursecreator'] = 'Basisrolle: Kursersteller/in';
$string['archetypeeditingteacher'] = 'Basisrolle: Trainer/in';
$string['archetypefrontpage'] = 'Basisrolle: Authentifizierte/r Nutzer/in der Startseite';
$string['archetypeguest'] = 'Basisrolle: Gast';
$string['archetypemanager'] = 'Basisrolle: Manager/in';
$string['archetypestudent'] = 'Basisrolle: Teilnehmer/in';
$string['archetypeteacher'] = 'Basisrolle: Trainer/in ohne Bearbeitungsrecht';
$string['archetypeuser'] = 'Basisrolle: Authentifizierte/r Nutzer/in';
$string['assignanotherrole'] = 'Weitere Rolle zuweisen';
$string['assignedroles'] = 'Rollen zuweisen';
$string['assignerror'] = 'Fehler beim Zuweisen der Rolle {$a->role} zum Nutzerkonto {$a->user}';
$string['assignglobalroles'] = 'Globale Rollen';
$string['assignmentcontext'] = 'Zuweisungskontext';
$string['assignmentoptions'] = 'Zuweisungsoptionen';
$string['assignrole'] = 'Rollen zuweisen';
$string['assignrolenameincontext'] = 'Rolle \'{$a->role}\' in \'{$a->context}\' zuweisen';
$string['assignroles'] = 'Rollen zuweisen';
$string['assignroles_help'] = 'Durch die Rollenzuweisung in einem Kontext werden alle Fähigkeiten der Rolle übertragen, u.z. im aktuellen Kontext und in allen nachrangigen Kontexten. Wird z.B. Nutzer/innen die Teilnehmerrolle in einem Kurs zugewiesen, so haben sie die Teilnehmerrolle auch für alle Aktivitäten und Blöcke innerhalb des Kurses.';
$string['assignrolesin'] = 'Rollen zuweisen in {$a}';
$string['assignrolesrelativetothisuser'] = 'Rollen relativ zu diesem Nutzerkonto zuweisen';
$string['backtoallroles'] = 'Zurück zur Rollenliste';
$string['backup:anonymise'] = 'Nutzerdaten bei Sicherung anonymisieren';
$string['backup:backupactivity'] = 'Aktivitäten sichern';
$string['backup:backupcourse'] = 'Kurse sichern';
$string['backup:backupsection'] = 'Abschnitte sichern';
$string['backup:backuptargetimport'] = 'Sicherung für Import';
$string['backup:configure'] = 'Sicherungsoptionen konfigurieren';
$string['backup:downloadfile'] = 'Sicherungsdateien herunterladen';
$string['backup:userinfo'] = 'Nutzerdaten sichern';
$string['badges:awardbadge'] = 'Badge an Nutzer/in verleihen';
$string['badges:configurecriteria'] = 'Badge-Kriterien erstellen';
$string['badges:configuredetails'] = 'Badge-Details erstellen';
$string['badges:configuremessages'] = 'Badge-Mitteilungen schreiben';
$string['badges:createbadge'] = 'Badges verwalten';
$string['badges:deletebadge'] = 'Badges löschen';
$string['badges:earnbadge'] = 'Badge erwerben';
$string['badges:manageglobalsettings'] = 'Website-Einstellungen für Badges verwalten';
$string['badges:manageownbadges'] = 'Eigene Badges anzeigen und verwalten';
$string['badges:revokebadge'] = 'Badge von Nutzer/in zurückziehen';
$string['badges:viewawarded'] = 'Personen mit  einem bestimmten Badge anzeigen, ohne selber den Badge erwerben können';
$string['badges:viewbadges'] = 'Verfügbare Badges anzeigen, ohne sie erworben zu haben';
$string['badges:viewotherbadges'] = 'Öffentliche Badges von anderen Personen anzeigen';
$string['block:edit'] = 'Blockeinstellungen ändern';
$string['block:view'] = 'Block sehen';
$string['blog:create'] = 'Neue Blogeinträge erstellen';
$string['blog:manageentries'] = 'Blogeinträge verwalten';
$string['blog:manageexternal'] = 'Externe Blogs verwalten';
$string['blog:search'] = 'Blogeinträge suchen';
$string['blog:view'] = 'Blogeinträge sehen';
$string['blog:viewdrafts'] = 'Blogeinträge als Entwürfe sehen';
$string['calendar:manageentries'] = 'Alle Kalendereinträge verwalten';
$string['calendar:managegroupentries'] = 'Kalendereinträge für Gruppen verwalten';
$string['calendar:manageownentries'] = 'Eigene Kalendereinträge verwalten';
$string['capabilities'] = 'Fähigkeiten';
$string['capability'] = 'Fähigkeit';
$string['category:create'] = 'Kursbereiche anlegen';
$string['category:delete'] = 'Kursbereiche löschen';
$string['category:manage'] = 'Kursbereiche verwalten';
$string['category:update'] = 'Kursbereiche aktualisieren';
$string['category:viewcourselist'] = 'Liste von Kursen anzeigen, in denen Sie nicht eingeschrieben sind';
$string['category:viewhiddencategories'] = 'Verborgene Kursbereiche sehen';
$string['category:visibility'] = 'Verborgene Kursbereiche sehen';
$string['checkglobalpermissions'] = 'Systemrechte prüfen';
$string['checkpermissions'] = 'Rechte prüfen';
$string['checkpermissionsin'] = 'Rechte prüfen in {$a}';
$string['checksystempermissionsfor'] = 'Systemrechte für {$a->fullname} prüfen';
$string['checkuserspermissionshere'] = 'Rechte für {$a->fullname} in {$a->contextlevel} prüfen';
$string['chooseroletoassign'] = 'Wählen Sie eine Rolle zur Zuweisung aus';
$string['cohort:assign'] = 'Mitglieder von globalen Gruppen verwalten';
$string['cohort:manage'] = 'Globale Gruppen anlegen, löschen und bewegen';
$string['cohort:view'] = 'Globale Gruppen anzeigen';
$string['comment:delete'] = 'Kommentare löschen';
$string['comment:post'] = 'Kommentare schreiben';
$string['comment:view'] = 'Kommentare anzeigen';
$string['competency:competencygrade'] = 'Kompetenzwertung setzen';
$string['competency:competencymanage'] = 'Kompetenzrahmen verwalten';
$string['competency:competencyview'] = 'Kompetenzrahmen anzeigen';
$string['competency:coursecompetencyconfigure'] = 'Einstellungen zu Kurskompetenzen konfigurieren';
$string['competency:coursecompetencygradable'] = 'Kompetenzmarkierungen empfangen';
$string['competency:coursecompetencymanage'] = 'Kurskompetenzen verwalten';
$string['competency:coursecompetencyview'] = 'Kurskompetenzen anzeigen';
$string['competency:evidencedelete'] = 'Beleg löschen';
$string['competency:plancomment'] = 'Lernplan kommentieren';
$string['competency:plancommentown'] = 'Eigenen Lernplan kommentieren';
$string['competency:planmanage'] = 'Lernpläne verwalten';
$string['competency:planmanagedraft'] = 'Lernplanentwürfe verwalten';
$string['competency:planmanageown'] = 'Eigene Lernpläne verwalten';
$string['competency:planmanageowndraft'] = 'Eigene Lernplanentwürfe verwalten';
$string['competency:planrequestreview'] = 'Überprüfung eines Lernplans anfordern';
$string['competency:planrequestreviewown'] = 'Überprüfung eines eigenen Lernplans anfordern';
$string['competency:planreview'] = 'Lernplan überprüfen';
$string['competency:planview'] = 'Alle Lernpläne anzeigen';
$string['competency:planviewdraft'] = 'Lernplanentwürfe anzeigen';
$string['competency:planviewown'] = 'Eigene Lernpläne anzeigen';
$string['competency:planviewowndraft'] = 'Eigene Lernplanentwürfe anzeigen';
$string['competency:templatemanage'] = 'Lernplanvorlagen verwalten';
$string['competency:templateview'] = 'Lernplanvorlagen anzeigen';
$string['competency:usercompetencycomment'] = 'Nutzerkompetenz kommentieren';
$string['competency:usercompetencycommentown'] = 'Eigene Nutzerkompetenz kommentieren';
$string['competency:usercompetencyrequestreview'] = 'Überprüfung der Nutzerkompetenz anfragen';
$string['competency:usercompetencyrequestreviewown'] = 'Überprüfung der eigenen Nutzerkompetenz anfragen';
$string['competency:usercompetencyreview'] = 'Nutzerkompetenz überprüfen';
$string['competency:usercompetencyview'] = 'Nutzerkompetenz anzeigen';
$string['competency:userevidencemanage'] = 'Beleg über Vorkenntnisse verwalten';
$string['competency:userevidencemanageown'] = 'Beleg über Vorkenntnisse verwalten';
$string['competency:userevidenceview'] = 'Beleg über Vorkenntnisse einer Person anzeigen';
$string['confirmaddadmin'] = 'Möchten Sie wirklich <strong>{$a}</strong> als neue/n Administrator/in hinzufügen?';
$string['confirmdeladmin'] = 'Möchten Sie \'{$a}\' wirklich aus der Administrationsliste löschen?';
$string['confirmroleprevent'] = 'Möchten Sie wirklich <strong>{$a->role}</strong> aus der Liste der Rollen entfernen, für die das Recht {$a->cap} im Kontext {$a->context} erlaubt ist?';
$string['confirmroleunprohibit'] = 'Möchten Sie wirklich <strong>{$a->role}</strong> aus der Liste der Rollen entfernen, für die das Recht {$a->cap} im Kontext {$a->context} verboten ist?';
$string['confirmunassign'] = 'Möchten Sie die Rolle wirklich bei dieser Person löschen?';
$string['confirmunassignno'] = 'Abbrechen';
$string['confirmunassigntitle'] = 'Rollenwechsel bestätigen';
$string['confirmunassignyes'] = 'Löschen';
$string['context'] = 'Kontext';
$string['course:activityvisibility'] = 'Aktivitäten anzeigen / verbergen';
$string['course:bulkmessaging'] = 'Mitteilungen an viele Personen senden';
$string['course:changecategory'] = 'Kursbereich ändern';
$string['course:changefullname'] = 'Vollständigen Kursnamen ändern';
$string['course:changeidnumber'] = 'Kurs-ID-Nummer ändern';
$string['course:changelockedcustomfields'] = 'Gesperrte Kursfelder ändern';
$string['course:changeshortname'] = 'Kurzen Kursnamen ändern';
$string['course:changesummary'] = 'Kursbeschreibung ändern';
$string['course:configurecustomfields'] = 'Kursfelder konfigurieren';
$string['course:create'] = 'Kurse anlegen';
$string['course:creategroupconversations'] = 'Gruppenkommunikation erstellen';
$string['course:delete'] = 'Kurse löschen';
$string['course:enrolconfig'] = 'Einschreibeverfahren in Kursen konfigurieren';
$string['course:enrolreview'] = 'Kurseinschreibungen überprüfen';
$string['course:ignoreavailabilityrestrictions'] = 'Verfügbarkeitseinschränkungen ignorieren';
$string['course:ignorefilesizelimits'] = 'Dateien verwenden, die Größenbeschränkung überschreiten';
$string['course:isincompletionreports'] = 'In Abschlussverfolgung anzeigen';
$string['course:manageactivities'] = 'Aktivitäten verwalten';
$string['course:managefiles'] = 'Dateien verwalten';
$string['course:managegrades'] = 'Bewertungen verwalten';
$string['course:managegroups'] = 'Gruppen verwalten';
$string['course:managescales'] = 'Bewertungskalen verwalten';
$string['course:markcomplete'] = 'Nutzer/innen in \'Kursabschluss\' als \'abgeschlossen\' markieren';
$string['course:movesections'] = 'Abschnitte verschieben';
$string['course:overridecompletion'] = 'Abschlussstatus für Aktivität überschreiben';
$string['course:renameroles'] = 'Rollen umbenennen';
$string['course:request'] = 'Neue Kurse beantragen';
$string['course:reset'] = 'Kurs zurücksetzen';
$string['course:reviewotherusers'] = 'Beobachtung anderer Nutzer/innen';
$string['course:sectionvisibility'] = 'Abschnitte anzeigen/verbergen';
$string['course:setcurrentsection'] = 'Kursabschnitt als \'aktuell\' markieren';
$string['course:setforcedlanguage'] = 'Kurssprache festlegen';
$string['course:tag'] = 'Kurs-Tags ändern';
$string['course:togglecompletion'] = 'Manuell Aktivitäten als abgeschlossen markieren.';
$string['course:update'] = 'Kurseinstellungen aktualisieren';
$string['course:useremail'] = 'E-Mail-Adresse ein-/ausschalten';
$string['course:view'] = 'Kurse ohne Beteiligung ansehen';
$string['course:viewcoursegrades'] = 'Bewertungen sehen';
$string['course:viewhiddenactivities'] = 'Verborgene Aktivitäten sehen';
$string['course:viewhiddencourses'] = 'Verborgene Kurse sehen';
$string['course:viewhiddensections'] = 'Verborgene Kursabschnitte sehen';
$string['course:viewhiddenuserfields'] = 'Verborgene Nutzerfelder sehen';
$string['course:viewparticipants'] = 'Kursteilnehmer/innen sehen';
$string['course:viewscales'] = 'Bewertungskalen sehen';
$string['course:viewsuspendedusers'] = 'Gesperrte Nutzer/innen anzeigen';
$string['course:visibility'] = 'Kurse anzeigen / verbergen';
$string['createrolebycopying'] = 'Neue Rolle als Kopie von {$a} erzeugen';
$string['createthisrole'] = 'Neue Rolle erzeugen';
$string['currentcontext'] = 'Aktueller Kontext';
$string['currentrole'] = 'Derzeitige Rolle';
$string['customroledescription'] = 'Angepasste Beschreibung';
$string['customroledescription_help'] = 'Die Beschreibung von Standardrollen wird automatisch lokalisiert, wenn dieses Feld leer bleibt';
$string['customrolename'] = 'Angepasster Rollenname';
$string['customrolename_help'] = 'Die Namen von Standardrollen wird automatisch lokalisiert, wenn dieses Feld leer bleibt. Sie müssen den Rollennamen  für alle angepassten Rollen angeben.';
$string['defaultrole'] = 'Standardrolle';
$string['defaultx'] = 'Standard: {$a}';
$string['defineroles'] = 'Rollen verwalten';
$string['deletecourseoverrides'] = 'Alle Änderungen im Kurs löschen';
$string['deletelocalroles'] = 'Alle lokalen Rollenzuordnungen löschen';
$string['deleterolesure'] = '<p>Möchten Sie die Rolle \'{$a->name} ({$a->shortname})\' wirklich löschen?</p>
<p>Aktuell sind dieser Rolle insgesamt {$a->count} Personen zugewiesen.';
$string['deletexrole'] = 'Rolle {$a} löschen';
$string['duplicaterole'] = 'Rolle duplizieren';
$string['duplicaterolesure'] = '<p>Möchten Sie wirklich die Rolle \'{$a->name} ({$a->shortname})\' duplizieren?</p>';
$string['editingrolex'] = 'Rolle \'{$a}\' wird bearbeitet';
$string['editrole'] = 'Rolle bearbeiten';
$string['editxrole'] = 'Rolle \'{$a}\' bearbeiten';
$string['errorbadrolename'] = 'Ungültiger Rollenname';
$string['errorbadroleshortname'] = 'Ungültiger Rollenkurzname';
$string['errorexistsrolename'] = 'Rollenname existiert bereits';
$string['errorexistsroleshortname'] = 'Rollenname existiert bereits';
$string['errorroleshortnametoolong'] = 'Der Kurzname darf nicht länger als 100 Zeichen sein.';
$string['eventcapabilityassigned'] = 'Fähigkeit zugewiesen';
$string['eventcapabilityunassigned'] = 'Fähigkeit entzogen';
$string['eventroleallowassignupdated'] = 'Rollenzuweisung erlauben';
$string['eventroleallowoverrideupdated'] = 'Rollenänderungen erlauben';
$string['eventroleallowswitchupdated'] = 'Rollenwechsel erlauben';
$string['eventroleallowviewupdated'] = 'Rollenansicht erlauben';
$string['eventroleassigned'] = 'Rolle zugewiesen';
$string['eventrolecapabilitiesupdated'] = 'Rollenrechte aktualisiert';
$string['eventroledeleted'] = 'Rolle gelöscht';
$string['eventroleunassigned'] = 'Rolle entfernt';
$string['eventroleupdated'] = 'Rolle aktualisiert';
$string['existingadmins'] = 'Aktuelle Administrator/innen';
$string['existingusers'] = '{$a} Nutzer/innen';
$string['explanation'] = 'Erklärung';
$string['export'] = 'Export';
$string['extusers'] = 'Vorhandene Nutzer/innen';
$string['extusersmatching'] = 'Nutzer/innen, die zu \'{$a}\' passen';
$string['filter:manage'] = 'Lokale Filterinstellungen verwalten';
$string['frontpageuser'] = 'Authentifizierte/r Nutzer/in der Startseite';
$string['frontpageuserdescription'] = 'Alle authentifizierten Nutzer/innen auf der Startseite';
$string['globalrole'] = 'Globale Rolle';
$string['globalroleswarning'] = 'ACHTUNG! Jede hier zugewiesene Rolle wird für die gesamte Webseite angelegt. Die jeweiligen Nutzer/innen besitzen die Rolle dann wirklich für alle Kurse und auch für die Startseite.';
$string['gotoassignroles'] = 'Gehe zu Rollen zuweisen für {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Globale Rollen zuweisen';
$string['grade:edit'] = 'Bewertungen bearbeiten';
$string['grade:export'] = 'Bewertungen exportieren';
$string['grade:hide'] = 'Bewertungen oder Aspekte anzeigen / verbergen';
$string['grade:import'] = 'Bewertungen importieren';
$string['grade:lock'] = 'Bewertungen oder Aspekte sperren';
$string['grade:manage'] = 'Bewertungsaspekte verwalten';
$string['grade:managegradingforms'] = 'Erweiterte Bewertungen verwalten';
$string['grade:manageletters'] = 'Bewertungsbuchstaben verwalten';
$string['grade:manageoutcomes'] = 'Lernziele verwalten';
$string['grade:managesharedforms'] = 'Erweiterte Bewertungen aus Vorlagen verwalten';
$string['grade:override'] = 'Bewertungen ändern';
$string['grade:sharegradingforms'] = 'Erweiterte Bewertungen als Vorlage teilen';
$string['grade:unlock'] = 'Bewertungen oder Aspekte freigeben';
$string['grade:view'] = 'Eigene Bewertungen ansehen';
$string['grade:viewall'] = 'Fremde Bewertungen ansehen';
$string['grade:viewhidden'] = 'Verborgene Bewertungen sehen';
$string['h5p:deploy'] = 'Bereitstellen von H5P-Inhalt';
$string['h5p:setdisplayoptions'] = 'H5P-Anzeigeoptionen einstellen';
$string['h5p:updatelibraries'] = 'Verwaltung von H5P-Inhaltstypen';
$string['highlightedcellsshowdefault'] = 'Die in der folgenden Tabelle markierten Rechte sind die Standardwerte für die Basisrolle, die aktuell oben ausgewählt ist.';
$string['highlightedcellsshowinherit'] = 'Die in der folgenden Tabelle markierten Zellen zeigen die (möglicherweise vorhandenen) vererbten Rechte. Mit Ausnahme des zu ändernden Rechts sollten alle Einstellungen unverändert auf \'vererben\' bleiben.';
$string['inactiveformorethan'] = 'länger als {$a->timeperiod} inaktiv';
$string['ingroup'] = 'in der Gruppe \'{$a->group}\'';
$string['inherit'] = 'Vererben';
$string['invalidpresetfile'] = 'Ungültige Rollendefinitionsdatei';
$string['legacy:admin'] = 'Basisrolle: Administrator/in';
$string['legacy:coursecreator'] = 'Basisrolle: Kursersteller/in';
$string['legacy:editingteacher'] = 'Basisrolle: Trainer/in';
$string['legacy:guest'] = 'Basisrolle: Gast';
$string['legacy:student'] = 'Basisrolle: Teilnehmer/in';
$string['legacy:teacher'] = 'Basisrolle: Trainer/in ohne Bearbeitungsrecht';
$string['legacy:user'] = 'Basisrolle: Authentifizierte/r Nutzer/in';
$string['legacytype'] = 'Basisrollentyp';
$string['listallroles'] = 'Alle Rollen auflisten';
$string['localroles'] = 'Lokale Rollen zuweisen';
$string['mainadmin'] = 'Primärer Administrator';
$string['mainadminset'] = 'Primärer Administrator';
$string['manageadmins'] = 'Administrator/innen verwalten';
$string['manager'] = 'Manager/in';
$string['managerdescription'] = 'Manager/innen dürfen alle Kurse ansehen und bearbeiten, ohne in die Kurse eingeschrieben zu sein.';
$string['manageroles'] = 'Rollen verwalten';
$string['maybeassignedin'] = 'Kontexttypen, in denen diese Rolle möglicherweise zugewiesen ist.';
$string['morethan'] = 'Mehr als {$a}';
$string['multipleroles'] = 'Mehrfach-Rollen';
$string['my:configsyspages'] = 'Systemvorlagen für Dashboard konfigurieren';
$string['my:manageblocks'] = 'Blöcke im Dashboard verwalten';
$string['neededroles'] = 'Rollen mit Rechten';
$string['nocapabilitiesincontext'] = 'In diesem Kontext sind keine Fähigkeiten verfügbar';
$string['noneinthisx'] = 'Nichts in dieser {$a}';
$string['noneinthisxmatching'] = 'Keine Nutzer für die Suche nach \'{$a->search}\' im Kontext {$a->contexttype}\' gefunden';
$string['norole'] = 'Keine Rolle';
$string['noroleassignments'] = 'Diesem Nutzerkonto wurde systemweit keine Rolle zuwiesen.';
$string['noroles'] = 'Keine Rollen';
$string['notabletoassignroleshere'] = 'Rollenzuweisungen wurden in diesem Kontext von den Administrator/innen nicht aktiviert.';
$string['notabletooverrideroleshere'] = 'Sie dürfen keine Rechte für eine Rolle ändern.';
$string['notes:manage'] = 'Anmerkungen verwalten';
$string['notes:view'] = 'Anmerkungen sehen';
$string['notset'] = 'Nicht gesetzt';
$string['novisibleroles'] = 'Keine Rollen';
$string['overrideanotherrole'] = 'Andere Rolle ändern';
$string['overridecontext'] = 'Kontext ändern';
$string['overridepermissions'] = 'Rechte ändern';
$string['overridepermissions_help'] = 'Die Änderung von Rollenrechten ermöglicht, ausgewählte Fähigkeiten in bestimmten Kontexten zu erlauben oder zu verbieten.';
$string['overridepermissionsforrole'] = 'Rechte für \'{$a->role}\' in {$a->context} ändern';
$string['overridepermissionsin'] = 'Rechte in {$a} ändern';
$string['overrideroles'] = 'Rollen ändern';
$string['overriderolesin'] = 'Rollen in {$a} ändern';
$string['overrides'] = 'Änderungen';
$string['overridesbycontext'] = 'Änderungen (im Kontext)';
$string['permission'] = 'Recht';
$string['permission_help'] = 'Rechte sind Einstellungen für bestimmte Nutzerfähigkeiten, für die es 4 Optionen gibt:

* Nicht gesetzt - Die Fähigkeit wird vererbt, d.h. sie wird unverändert von einem übergeordneten (weniger speziellen) Kontext übernommen
* Erlauben - Die Fähigkeit wird erlaubt und darf ausgeführt werden
* Entziehen - Die Fähigkeit wird entzogen, auch wenn sie in übergeordnetem Kontext erlaubt ist
* Verbieten - Die Fähigkeit wird vollständig verboten und kann in keinem untergeordneten (spezielleren) Kontext wieder erlaubt werden';
$string['permissions'] = 'Rechte ändern';
$string['permissionsforuser'] = 'Rechte für Nutzerkonto \'{$a}\'';
$string['permissionsincontext'] = 'Rechte für {$a}';
$string['portfolio:export'] = 'In Portfolios exportieren';
$string['potentialusers'] = '{$a} mögliche Nutzer/innen';
$string['potusers'] = 'Mögliche Nutzer/innen';
$string['potusersmatching'] = 'Mögliche Nutzer/innen passend zu \'{$a}\'';
$string['prevent'] = 'Entziehen';
$string['privacy:metadata:preference:showadvanced'] = 'Verfahren, um den erweiterten Modus-Button zu überspringen';
$string['privacy:metadata:role_assignments'] = 'Rollenzuweisungen';
$string['privacy:metadata:role_assignments:component'] = 'Plugin, das für Rollenzuweisungen verantwortlich ist. Leer wenn Rollen manuell zugewiesen werden.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID der Einschreibe-/Authentifizierungsinstanz, die für Rollenzuweisung verantwortlich ist';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID des Nutzers, der die Rollenzuweisung erstellte oder veränderte';
$string['privacy:metadata:role_assignments:roleid'] = 'Rollen-ID';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Die Tabelle speichert die zugewiesenen Rollen in jedem Kontext';
$string['privacy:metadata:role_assignments:timemodified'] = 'Datum an dem die Rollenzuweisung erstellt oder bearbeitet wurde.';
$string['privacy:metadata:role_assignments:userid'] = 'Nutzer-ID';
$string['privacy:metadata:role_capabilities'] = 'Rollenberechtigungen';
$string['privacy:metadata:role_capabilities:capability'] = 'Name der Berechtigung';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ID der Person, die die Berechtigung angelegt oder verändert hat.';
$string['privacy:metadata:role_capabilities:permission'] = 'Berechtigungsumfang: vererbt, erlaubt, verhindert, untersagt';
$string['privacy:metadata:role_capabilities:roleid'] = 'Rollen-ID';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Rechte und überschreibende Rechte für eine bestimmte Rolle in einem angegebenen Kontext';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Datum zu dem die Berechtigung erstellt oder verändert wurde';
$string['privacy:metadata:role_cohortroles'] = 'Rollen für Globale Gruppen';
$string['prohibit'] = 'Verbieten';
$string['prohibitedroles'] = 'Verboten';
$string['question:add'] = 'Neue Fragen hinzufügen';
$string['question:config'] = 'Fragetypen konfigurieren';
$string['question:editall'] = 'Alle Fragen bearbeiten';
$string['question:editmine'] = 'Eigene Fragen bearbeiten';
$string['question:flag'] = 'Fragen während der Beantwortung markieren';
$string['question:managecategory'] = 'Fragenkategorien verwalten';
$string['question:moveall'] = 'Alle Fragen verschieben';
$string['question:movemine'] = 'Eigene Fragen verschieben';
$string['question:tagall'] = 'Alle Fragen mit Tags versehen';
$string['question:tagmine'] = 'Eigene Fragen mit Tags versehen';
$string['question:useall'] = 'Alle Fragen verwenden';
$string['question:usemine'] = 'Eigene Fragen verwenden';
$string['question:viewall'] = 'Alle Fragen sehen';
$string['question:viewmine'] = 'Eigene Fragen sehen';
$string['rating:rate'] = 'Bewertung hinzufügen';
$string['rating:view'] = 'Eigene Gesamtwertung sehen';
$string['rating:viewall'] = 'Alle Teilwertungen sehen';
$string['rating:viewany'] = 'Alle Gesamtwertungen sehen';
$string['resetrole'] = 'Grundeinstellung wiederherstellen';
$string['resettingrole'] = 'Rolle \'{$a}\' wird wiederhergestellt';
$string['restore:configure'] = 'Wiederherstellung konfigurieren';
$string['restore:createuser'] = 'Nutzerkonten beim Wiederherstellen anlegen';
$string['restore:restoreactivity'] = 'Aktivitäten wiederherstellen';
$string['restore:restorecourse'] = 'Kurse wiederherstellen';
$string['restore:restoresection'] = 'Kursabschnitte wiederherstellen';
$string['restore:restoretargetimport'] = 'Aus für Import bestimmten Dateien wiederherstellen';
$string['restore:rolldates'] = 'Beim Wiederherstellen ist das Hinzufügen von Konfigurationsdaten erlaubt';
$string['restore:uploadfile'] = 'Dateien ins Verzeichnis \'Sicherung\' hochladen';
$string['restore:userinfo'] = 'Nutzerdaten wiederherstellen';
$string['restore:viewautomatedfilearea'] = 'Kurse aus automatisch erstellten Sicherungen wiederherstellen';
$string['risks'] = 'Risiken';
$string['role:assign'] = 'Rollen an Nutzer/innen zuweisen';
$string['role:manage'] = 'Rollen erstellen und verwalten';
$string['role:override'] = 'Rechte von anderen ändern';
$string['role:review'] = 'Rechte von anderen prüfen';
$string['role:safeoverride'] = 'Sichere Rechte von anderen ändern';
$string['role:switchroles'] = 'Rollen wechseln';
$string['roleallowheader'] = 'Erlaube Rolle:';
$string['roleallowinfo'] = 'Wählen Sie eine Rolle aus, die zur Liste der erlaubten Rollen hinzugefügt werden soll - Kontext "{$a->context}", Recht "{$a->cap}":';
$string['roleassignments'] = 'Rollenzuweisungen';
$string['roledefinitions'] = 'Rollendefinitionen';
$string['rolefullname'] = 'Name';
$string['roleincontext'] = '{$a->role} in {$a->context}';
$string['roleprohibitheader'] = 'Nichterlaubte Rolle';
$string['roleprohibitinfo'] = 'Wählen Sie eine Rolle aus, die in die Liste der nicht erlaubten Rollen hinzugefügt werden soll - Kontext {$a->context}, Fähigkeit {$a->cap}:';
$string['rolerepreset'] = 'Grundeinstellung benutzen';
$string['roleresetdefaults'] = 'Grundeinstellungen';
$string['roleresetrole'] = 'Rolle oder Basisrolle benutzen';
$string['rolerisks'] = 'Rollenrisiken';
$string['roles'] = 'Rollen';
$string['roles_help'] = 'Eine Rolle ist definiert durch einen Satz von Rechten, die für die gesamte Website festgelegt sind. Rollen können einzelnen Nutzer/innen in bestimmten Kontexten (Zusammenhängen) zugewiesen werden.
';
$string['roleselect'] = 'Rolle aussuchen';
$string['rolesforuser'] = 'Rollen für Nutzer/in {$a}';
$string['roleshortname'] = 'Kurzbezeichnung';
$string['roleshortname_help'] = 'Der Kurzname ist ein direktes Identifizierungsmerkmal der Rolle, bei dem ausschließlich alphanumerische Zeichen erlaubt sind. Ändern Sie niemals die Kurznamen der Standardrollen!';
$string['roletoassign'] = 'Zuzuweisende Rolle';
$string['roletooverride'] = 'Zu überschreibende Rolle';
$string['safeoverridenotice'] = 'Anmerkung: Rechte mit höheren Risiken sind gesperrt. Sie dürfen nur sichere Rechte ändern.';
$string['search:query'] = 'Suche systemweit durchführen';
$string['selectanotheruser'] = 'Weitere Nutzer auswählen';
$string['selectauser'] = 'Nutzer/in auswählen';
$string['selectrole'] = 'Rolle auswählen';
$string['showallroles'] = 'Alle Rollen anzeigen';
$string['showthisuserspermissions'] = 'Rechte für dieses Nutzerkonto';
$string['site:accessallgroups'] = 'Auf alle Gruppen zugreifen';
$string['site:approvecourse'] = 'Kurserstellung genehmigen';
$string['site:backup'] = 'Kurse sichern';
$string['site:config'] = 'Moodle-Konfiguration anpassen';
$string['site:configview'] = 'Administrationsbaum sehen, aber nicht die enthaltenen Seiten';
$string['site:deleteanymessage'] = 'Alle Mitteilungen In der Website löschen';
$string['site:deleteownmessage'] = 'Mitteilungen dieses Nutzers und an diesen Nutzer löschen.';
$string['site:doanything'] = 'Darf alles machen';
$string['site:doclinks'] = 'Links zu den MoodleDocs anzeigen';
$string['site:forcelanguage'] = 'Kurssprache überschreiben';
$string['site:import'] = 'Andere Kurse in eigenen Kurs importieren';
$string['site:maintenanceaccess'] = 'Beim Wartungsmodus auf Seite zugreifen';
$string['site:manageallmessaging'] = 'Kontakte für alle Nutzer/innen hinzufügen, entfernen, blocken oder freigeben';
$string['site:manageblocks'] = 'Blöcke auf einer Seite verwalten';
$string['site:managecontextlocks'] = 'Einfrieren von Kontexten verwalten';
$string['site:messageanyuser'] = 'Einstellungen des Nutzers für Mitteilungen aller Nutzer/innen überschreiben';
$string['site:mnetloginfromremote'] = 'Aus anderem Moodle über MNet einloggen';
$string['site:mnetlogintoremote'] = 'Zu anderem Moodle über MNet verbinden';
$string['site:readallmessages'] = 'Alle Mitteilungen lesen';
$string['site:restore'] = 'Kurse wiederherstellen';
$string['site:sendmessage'] = 'Mitteilungen an alle versenden';
$string['site:trustcontent'] = 'Übermittelten Inhalten vertrauen';
$string['site:uploadusers'] = 'Neue Nutzer/innen aus Datei importieren';
$string['site:viewfullnames'] = 'Vollständige Nutzernamen sehen';
$string['site:viewparticipants'] = 'Alle Nutzer/innen sehen';
$string['site:viewreports'] = 'Berichte sehen';
$string['site:viewuseridentity'] = 'Alle Nutzerinformationen als Liste sehen';
$string['siteadministrators'] = 'Administrator/innen';
$string['tag:edit'] = 'Vorhandene Tags bearbeiten';
$string['tag:editblocks'] = 'Blöcke auf Tag-Seiten bearbeiten';
$string['tag:flag'] = 'Tags als unangemessen markieren';
$string['tag:manage'] = 'Alle Tags verwalten';
$string['thisnewrole'] = 'Diese neue Rolle';
$string['thisusersroles'] = 'Rollenzuweisungen';
$string['unassignarole'] = 'Rollenzuweisung {$a} löschen';
$string['unassignconfirm'] = 'Wollen Sie wirklich Teilnehmer/in "{$a->user}" die Rolle "{$a->role}" entziehen?';
$string['unassignerror'] = 'Es ist ein Fehler während der Entfernung der Rolle {$a->role} des/r Nutzer/in {$a->user} aufgetreten.';
$string['user:changeownpassword'] = 'Eigenes Kennwort ändern';
$string['user:create'] = 'Nutzer/innen anlegen';
$string['user:delete'] = 'Nutzer/innen löschen';
$string['user:editmessageprofile'] = 'Mitteilungseinstellungen';
$string['user:editownmessageprofile'] = 'Eigenes Mitteilungsprofil bearbeiten';
$string['user:editownprofile'] = 'Eigenes Nutzerprofil bearbeiten';
$string['user:editprofile'] = 'Nutzerprofile bearbeiten';
$string['user:ignoreuserquota'] = 'Obergrenze des Nutzerquota ignorieren';
$string['user:loginas'] = 'Login als anderer Nutzer';
$string['user:manageblocks'] = 'Blöcke im Nutzerprofil anderer Nutzer/innen verwalten';
$string['user:manageownblocks'] = 'Blöcke im eigenen öffentlichen Nutzerprofil verwalten';
$string['user:manageownfiles'] = 'Dateien im Bereich \'Meine Dateien\' verwalten';
$string['user:managesyspages'] = 'Standardlayout für die öffentlichen Nutzerprofile konfigurieren';
$string['user:readuserblogs'] = 'Alle Nutzerblogs anzeigen';
$string['user:readuserposts'] = 'Alle Nutzerbeiträge im Forum sehen';
$string['user:update'] = 'Nutzerprofile aktualisieren';
$string['user:viewalldetails'] = 'Alle Nutzerinformationen sehen';
$string['user:viewdetails'] = 'Nutzerprofile sehen';
$string['user:viewhiddendetails'] = 'Verborgene Nutzerdetails sehen';
$string['user:viewlastip'] = 'Letzte Nutzer-IP-Adresse sehen';
$string['user:viewuseractivitiesreport'] = 'Nutzerberichte sehen';
$string['user:viewusergrades'] = 'Nutzerbewertungen sehen';
$string['usersfrom'] = 'Nutzer/innen von {$a}';
$string['usersfrommatching'] = 'Nutzer/innen im Kontext {$a->contextname} passen zur Suche \'{$a->search}\'';
$string['usersinthisx'] = 'Nutzer/innen in diesem {$a}';
$string['usersinthisxmatching'] = 'Nutzer/innen in diesem {$a->contexttype} passen zur Suche \'{$a->search}\'';
$string['userswithrole'] = 'Alle Nutzer/innen mit Rollenzuweisung';
$string['userswiththisrole'] = 'Nutzer/innen mit Rollenzuweisung';
$string['useshowadvancedtochange'] = '\'Optionale Felder anzeigen\', <br />um Änderungen duchzuführen';
$string['viewingdefinitionofrolex'] = 'Definition der Rolle \'{$a}\' anzeigen';
$string['viewrole'] = 'Rollendetails sehen';
$string['webservice:createmobiletoken'] = 'Webservice-Token für mobile Zugriffe erzeugen';
$string['webservice:createtoken'] = 'Webservice-Token erzeugen';
$string['webservice:managealltokens'] = 'Webservice Token für alle Nutzer/innen verwalten';
$string['whydoesuserhavecap'] = 'Warum besitzt {$a->fullname} das Recht {$a->capability} im Kontext {$a->context}?';
$string['whydoesusernothavecap'] = 'Warum fehlt {$a->fullname} das Recht {$a->capability} im Kontext {$a->context}?';
$string['xroleassignments'] = 'Rollenzuweisungen von \'{$a}\'';
$string['xuserswiththerole'] = 'Nutzer/innen mit der Rolle \'{$a->role}\'';
