<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcache', language 'sr_lt', version '3.8'.
 *
 * @package     cachestore_memcache
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['clustered'] = 'Omogući grupisane servere';
$string['clustered_help'] = 'Ova opcija se koristi za podešavanje funkcionalnosti koja dozvoljava jedno čitanje i više postavljanja.

Namera je da se takvo podešavanje koristi radi kreiranje naprednog skladišta za konfiguracije sa balansiranim učitavanjem. Skladište će preuzimati sadržaje sa jednog servera (obično lokalnog), ali će ih smeštati na više servera (sve koji su određeni kao raspoloživi za balansiranje učitavanja). Za keš sa veoma visokim odnosom čitanja i postavljanja ovo obezbeđuje značajno oblažavanje opterećenja mreže.

Kad je ovo podešavanje uključeno gore navedeni serveri se koriste za pribavljanje sadržaja.';
$string['clusteredheader'] = 'Razdvoj servere';
$string['pluginname'] = 'Memcache';
$string['prefix'] = 'Prefiks ključa';
$string['prefix_help'] = 'Ovaj prefiks se koristi za sve nazive ključeva na memcache serveru.
* Ako imate samo jednu instancu Moodlea koja koristi ovaj server, možete da ostavite ovu vrednost kao podrazumevanu.
* Zbog ograničenja dužine ključa, maksimalno je dozvoljeno 5 karaktera.';
$string['prefixinvalid'] = 'Prefiks nije validan. Možete da koristite samo a-z A-Z 0-9-_.';
$string['privacy:metadata:memcache'] = 'Dodatak za keširanje Memcache kratko čuva podatke, kao deo svoje funkcionalnosti. Ovi podaci se čuvaju na Memcache serveru odakle se redovno uklanjaju.';
$string['privacy:metadata:memcache:data'] = 'Različiti podaci koji se čuvaju u kešu';
$string['servers'] = 'Serveri';
$string['servers_help'] = 'Ova opcija podešava servere koje treba da koristi ovaj memcache adapter.
Serveri treba da budu definisani po jedan u svakom redu, a definicija se sastoji od adrese servera, i opciono od porta i težine.
Ako port nije definisan koristi se podrazumevani port (11211).

Na primer:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>

Ako je opcija "Omogući grupisane servere" uključena ispod, onda ovde mora da bude samo jedan server. To je obično ime koje se odnosi na lokalni server, nešto poput 127.0.0.1 ili localhost.';
$string['serversclusterinvalid'] = 'Tačno jedan server je potreban kada je omogućena grupisanje.';
$string['sessionhandlerconflict'] = 'Upozorenje: memcache instanca ({$a}) je podešena tako da koristi isti memcache server kao sesije. Čišćenje keša će sa sobom povući i čišćenje sesija.';
$string['setservers'] = 'Podesi servere';
$string['setservers_help'] = 'Ovo je spisak servera koji će biti ažurirani kada se izmene podaci u kešu. U opštem slučaju naveden je pun naziv svakog servera u grupi raspoloživih. Mora biti uključen server naveden pod opcijom "Serveri" iznad, čak i ako je dat pod drugim nazivom.
Serveri treba da budu definisani po jedan u svakom redu, a definicija se sastoji od adrese servera, i opciono od porta.
Ako port nije definisan koristi se podrazumevani port (11211).

Na primer:
<pre>
server.url.com
ipaddress:port
</pre>';
$string['testservers'] = 'Test serveri';
$string['testservers_desc'] = 'Jedan ili više stringova za konekciju spram kojih će se testirati memcache serveri. Ako je specificiran testni server memcache performanse se mogu testirati korišćenjem stranice za keš performanse u bloku za administraciju.
Na primer: 127.0.0.1:11211';
