<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'vpl', language 'sr_lt', version '3.8'.
 *
 * @package     vpl
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['VPL_COMPILATIONFAILED'] = 'Kompilacija ili priprema izvršavanja nije uspela';
$string['about'] = 'O dodatku';
$string['acceptcertificates'] = 'Prihvati samopotpisane sertifikate';
$string['acceptcertificates_description'] = 'Ako izvršni serveri ne koriste samopotpisane sertifikate isključite ovu opciju';
$string['acceptcertificatesnote'] = '<p>Koristite šifrovanu konekciju.<p/>
<p>Da biste koristili šifrovanu konekciju sa izvršnim serverima neophodno je da prihvatite njene sertifikate.</p>
<p>Ako imate problema sa ovim procesom, možete pokušati da koristite http (nešifrovanu) konekciju ili drugi čitač.</p>
<p>Molimo kliknite na sledeće linkove (server #) i prihvatite ponuđene sertifikate.</p>';
$string['addfile'] = 'Dodaj datoteku';
$string['advanced'] = 'Napredni';
$string['allfiles'] = 'Sve datoteke';
$string['allsubmissions'] = 'Svi predati radovi';
$string['always_use_ws'] = 'Uvek koristite nešifrovani (ws) websocket protokol';
$string['always_use_wss'] = 'Uvek koristite šifrovani (wss) websocket protokol';
$string['anyfile'] = 'Bilo koja datoteka';
$string['attemptnumber'] = 'Pokušaj broj {$a}';
$string['automaticevaluation'] = 'Automatska evaluacija';
$string['automaticgrading'] = 'Automatsko ocenjivanje';
$string['averageperiods'] = 'Prosečni periodi {$a}';
$string['averagetime'] = 'Prosečno vreme {$a}';
$string['basedon'] = 'Bazirano na';
$string['basic'] = 'Osnovni';
$string['browserupdate'] = 'Molimo ažurirajte svoj čitač na poslednju verziju<br />ili koristite drugi koji podržava Websocket.';
$string['calculate'] = 'Izračunaj';
$string['changesNotSaved'] = 'Izmene nisu sačuvane';
$string['check_jail_servers'] = 'Proveri izvršne servere';
$string['check_jail_servers_help'] = '<p>Ova stranica proverava i prikazuje status izvršnih servera korišćenih za ovu aktivnost.</p>';
$string['closed'] = 'Zatvoreno';
$string['comments'] = 'Komentari';
$string['compilation'] = 'Kompajliranje';
$string['connected'] = 'povezan';
$string['connecting'] = 'povezuje se';
$string['connection_closed'] = 'konekcija je zatvorena';
$string['connection_fail'] = 'povezivanje nije uspelo';
$string['console'] = 'Konzola';
$string['copy'] = 'Kopiraj';
$string['create_new_file'] = 'Kreiraj novu datoteku';
$string['currentstatus'] = 'Trenutni status';
$string['cut'] = 'Iseci';
$string['datesubmitted'] = 'Datum kad je predato';
$string['debug'] = 'Ispravi greške';
$string['debugging'] = 'Ispravljanje grešaka';
$string['defaultexefilesize'] = 'Maksimalna podrazumevana veličina izvršne datoteke';
$string['defaultexememory'] = 'Maksimalna podrazumevana iskorišćena memorija';
$string['defaultexeprocesses'] = 'Maksimalni podrazumevani broj procesa';
$string['defaultexetime'] = 'Maksimalno podrazumevano vreme izvršavanja';
$string['defaultfilesize'] = 'Podrazumevana maksimalna veličina učitanih datoteka';
$string['defaultresourcelimits'] = 'Podrazumevana ograničenja resursa za izvršavanje';
$string['delete'] = 'Obriši';
$string['delete_file_fq'] = 'Brisanje datoteke \'{$a}\'?';
$string['delete_file_q'] = 'Brisanje datoteke?';
$string['deleteallsubmissions'] = 'Obriši sve predate radove';
$string['depends_on_https'] = 'Koristi ws ili wss u zavisnosti od toga da li se koristi http ili https';
$string['description'] = 'Opis';
$string['diff'] = 'razlike';
$string['discard_submission_period'] = 'Odbaci period predaje';
$string['discard_submission_period_description'] = 'Za svakog polaznika i zadatak sistem pokušava da odbaci predate radove. Sistem čuva poslednji predat rad i bar jedan rad za svaki period';
$string['download'] = 'Preuzmi';
$string['downloadallsubmissions'] = 'Preuzmi sve predate radove';
$string['duedate'] = 'Rok za izradu';
$string['edit'] = 'Uredi';
$string['editing'] = 'Uređivanje';
$string['evaluate'] = 'Evaluiraj';
$string['evaluateonsubmission'] = 'Evaluiraj samo nakon predaje';
$string['evaluating'] = 'Evaluira se';
$string['evaluation'] = 'Evaluacija';
$string['examples'] = 'Primeri';
$string['execution'] = 'Izvršavanje';
$string['executionfiles'] = 'Izvršne datoteke';
$string['executionfiles_help'] = '<h2>Uvod</h2>
<p>Ovde postavljate datoteke koje su potrebne za pripremu izvršavanja, otkrivanja grešaka ili ocenjivanja predatog rada. Ovo obuhvata skript datoteke, datoteke za testiranje i datoteke sa podacima.</p>
<h2>Podrazumevani skript za izvršavanje ili otkrivanje grešaka</h2>
<p>Ako ne postavite skript datoteku za izvršavanje predatih radova ili otkrivanje grešaka, sistem će prepoznati koji jezik koristite (na osnovu ekstenzija datoteka) i koristiti predefinisani skript.
<h2>Automatska evaluacija</h2>
<p>Obuhvata funkcionalnosti koje omogućavaju evaluaciju predatih radova polaznika.
Ova mogućnost dozvoljava da se izvrši program polaznika i proverava rezultate njegovog rada za zadate ulazne podatke.
Da biste podesili slučajeve za evaluaciju morate popuniti datoteku "vpl_evaluate.cases".
<p>Datoteka "vpl_evaluate.cases" je sledećeg formata:
<ul>
<li> "<strong>case </strong>= Opis slučaja": Opciono. Podesite na početku definicije slučaja za evaluaciju.</li>
<li> "<strong>input </strong>= tekst": Može biti u više linija. Završava se narednom instrukcijom.</li>
<li> "<strong>output </strong>= tekst": Može biti u više linija. Završava se narednom instrukcijom. Slučaj može imati više različitih tačnih izlaza. Postoje tri tipa izlaza: brojevi, tekst i tačan tekst:
<ul>
<li> <strong>brojevi</strong>: Definisan kao niz brojeva (celih i realnih). Na izlazu se proveravaju samo brojne vrednosti, ostatak teksta se ignoriše. Realne vrednosti se proveravaju sa određenim stepenom toleracije.</li>
<li> <strong>tekst</strong>: Definisan kao tekst bez navodnika. Proveravaju se samo reči a ostali karakteri se ignorišu, pri čemu se upoređivanje radi uz ignorisanje razlike između velikih i malih slova.</li>
<li> <strong>tačan tekst</strong>: Definisan kao tekst pod navodnicima. Pri testiranju izlaza traži se potpuno poklapanje sa datim tekstom.</li>
</ul>
</li>
<li> "<strong>grade reduction</strong> = [vrednost|procenat%]" : Podrazumevano greška u predatom kodu smanjuje ocenu polaznika (u startu postavljenu na maksimalnu moguću vrednost) za (opseg ocena/broj slučajeva) ali pomoću ove instrukcije možete izmeniti vrednost, odnosno procenat toj umanjenja.</li>
</ul>
</p>
<h2>Opšta upotreba</h2>
<p>Nova datoteka može biti dodata pisanjem njegov naziva u okvir  "<b>Dodaj datoteku</b>" i potom klikom na dugme sa natpisom "<b>Dodaj datoteku</b>".</p>
<p>Postojeća datoteka se može postaviti korišćenjem opcije "<b>Postavi datoteku</b>".<p>Sve dodate ili postavljene datoteke se mogu uređivati, i sve one, osim tri skript datoteke navedene ispod, mogu da se preimenuju ili brišu.</p>
<h2>Ručno pokretanje, izvršavanje ili evaluacija</h2>
<p>Tri skript datoteke za pripremu svake od navedenih akcija mogu biti podešene. Te datoteke treba da imaju predefinisane nazive: <b>vpl_run.sh</b> (izvršavanje), <b>vpl_debug.sh</b>  (traženje grešaka) i <b>vpl_evaluate.sh</b> (ocenjivanje).</p>
<p>Izvršavanje bilo kog od tih skriptova bi trebalo da generiše datoteku pod nazivom <b>vpl_execution</b>. Ta datoteka mora biti binarna izvršna ili skript datoteka koja počinje sa "#!/bin/sh ". Neuspeh u generisanju te datoteke otežava izvršavanje odabrane akcije.</p>
<p>Ako je aktivnost koju podešavate bazirana na nekoj drugoj aktivnosti, datoteke bazne aktivnosti se automatski dodaju.
Sadržaji datoteka vpl_run.sh, vpl_debug.sh i vpl_evaluate.sh se nadovezuju sa najugnježdenijeg do tekućeg nivoa.</P>
<p>Konačno, datoteka <b>vpl_environment.sh</b> se automatski dodaje.
Ta skript datoteka sadrži informacije o predaji radova.
Informacije pristižu kao varijable okruženja: </p>
<ul> <li> LANG:  korišćeni jezik. </li>
<li> LC_ALL: ista vrednost kao za LANG. </li>
<li> VPL_MAXTIME: maksimalno vreme izvršavanja u sekundama. </li>
<li> VPL_FILEBASEURL: URL za pristup datotekama kursa. </li>
<li> VPL_SUBFILE#:  svaki naziv datoteke koju preda polaznik. # Kreće se u opsegu od 0 do broja predatih datoteka. </Li>
<li> VPL_SUBFILES: lista svih predatih datoteka. </li>
<li> VPL_VARIATION + id: gde je id redosled varijacije koji počinje od 0 a vrednost je vrednost varijacije. </li>
</ul>
Ako je zahtevana akcija evaluacija dodaju se i sledeće varijable.
<ul>
	<li>VPL_MAXTIME: maksimalno vreme izvršavanja u sekundama.</li>
	<li>VPL_MAXMEMORY: maksimalna količina memorije koja se može koristiti</li>
	<li>VPL_MAXFILESIZE: maksimalna veličina datoteke koja se može kreirati, u bajtovima.</li>
	<li>VPL_MAXPROCESSES: maksimalni broj procesa koji se mogu paralelno pokretati.</li>
	<Li>VPL_FILEBASEURL: URL do datoteka kursa.</Li>
	<li>VPL_GRADEMIN: Minimalna ocena za ovu aktivnost</li>
	<li>VPL_GRADEMAX: Maksimalna ocena za ovu aktivnost</li>
</ul>
<h2>Rezultat ocenjivanja</h2>
<p>Izlaz evaluacije se obrađuje da bi se izvukli, ukoliko je to moguće učiniti, komentari i predložena ocena na bazi urađene procene tačnosti rešenja.
Komentari se mogu podesiti na dva načina: linijom komentara definisanom redom koji počinje sa \'Comment :=>>\' ili blok komentarima koji počinju redom koji sadrži  samo \'<|--\' a završavaju se redom koji sadrži samo \'--|>\'. Ocena se uzima iz poslednje linije koja počinje sa \'Grade :=>>\'.
</p>';
$string['executionoptions'] = 'Opcije za izvršavanje';
$string['executionoptions_help'] = '<p>Brojne opcije za izvršavanje se podešavaju na ovoj stranici</p>
<ul>
<li><b>Bazirano na</b>: postavlja druge instance ovog dodatka iz kojih se uvoze neke funkcionalnosti:
<ul><li>Izvršne datoteke (nadovezivanje predefinisanih skript datoteka)</li>
<li>Ograničenja resursa za izvršavanje.</li>
<li>Varijacije, koje se nadovezuju da bi se generisale multivarijacije.</li>
<li>Maksimalna dužina svake datoteke koja će se postavljati sa radom.</li>
</ul>
</li>
<li><b>Izvršavanje</b>, <b>Otkrivanje grešaka</b> and <b>Evaluacija</b>: mora biti postavljeno na \'Da\' ako se odgovarajuća akcija može izvršiti tokom uređivanja rada. To utiče isključivo na polaznike, dok korisnici sa mogućnošću ocenjivanja uvek mogu da izvrše te akcije.</li>
<li><b>Evaluacija samo nakon predaje rada</b>: predat rad se automatski ocenjuje kad se postavi.</li>
<li><b>Automatsko ocenjivanje</b>: ako rezultat evaluacije uključuje kodove ocena, oni se koriste da se automatski postavi ocena.</li>
</ul>';
$string['file'] = 'Datoteka';
$string['fileNotChanged'] = 'Datoteka nije izmenjena';
$string['file_name'] = 'Naziv datoteke';
$string['fileadded'] = 'Datoteka \'{$a}\' je dodata';
$string['filedeleted'] = 'Datoteka \'{$a}\' je obrisana';
$string['filenotadded'] = 'Datoteka nije dodata';
$string['filenotdeleted'] = 'Datoteka \'{$a}\' NIJE obrisana';
$string['filenotrenamed'] = 'Datoteka \'{$a}\' NIJE preimenovana';
$string['filerenamed'] = 'Datoteka \'{$a->from}\' je preimenovana u \'{$a->to}\'';
$string['filesChangedNotSaved'] = 'Datoteke su izmenjene ali nisu sačuvane';
$string['filesNotChanged'] = 'Datoteke nisu izmenjene';
$string['filestoscan'] = 'Datoteke za pregled';
$string['fileupdated'] = 'Datoteka \'{$a}\' je ažurirana';
$string['find'] = 'Nađi';
$string['find_replace'] = 'Nađi/Zameni';
$string['fulldescription'] = 'Pun opis';
$string['fulldescription_help'] = '<p>Ovde morate napisati pun opis aktivnosti.</p>
<p>Ako ništa ovde ne napišete, umesto toga se prikazuje kratak opis.</p>
<p>Ako želite da koristite automatsku evaluaciju, interfejsi za zadatke moraju biti detaljni i nedvosmisleni.</p>';
$string['fullscreen'] = 'Preko celog ekrana';
$string['getjails'] = 'Pribavi izvršne servere';
$string['gradeandnext'] = 'Oceni i pređi na sledeći';
$string['graded'] = 'Ocenjeno';
$string['gradedbyuser'] = 'Ocenio korisnik';
$string['gradedon'] = 'Ocenjeno na dan';
$string['gradedonby'] = 'Ocenjeno na dan {$a->date} od strane korisnika pod imenom {$a->gradername}';
$string['gradenotremoved'] = 'Ocena NIJE uklonjena. Proverite podešavanja aktivnosti u dnevniku ocena.';
$string['gradenotsaved'] = 'Ocena NIJE sačuvana. Proverite podešavanja aktivnosti u dnevniku ocena.';
$string['gradeoptions'] = 'Opcije ocene';
$string['grader'] = 'Ocenjivač';
$string['gradercomments'] = 'Izveštaj o ocenjivanju';
$string['graderemoved'] = 'Ocena je uklonjena';
$string['groupwork'] = 'Grupni rad';
$string['inconsistentgroup'] = 'Niste član samo jedne grupe (0 o >1)';
$string['incorrect_file_name'] = 'Pogrešno ime datoteke';
$string['individualwork'] = 'Individualni rad';
$string['instanceselection'] = 'VPL odabir';
$string['isexample'] = 'Ova aktivnost predstavlja primer';
$string['jail_servers'] = 'Spisak izvršnih servera';
$string['jail_servers_config'] = 'Podešavanje izvršnih servera';
$string['jail_servers_description'] = 'Napišite po jedan red za svaki server';
$string['joinedfiles'] = 'Spojene odabrane datoteke';
$string['keepfiles'] = 'Datoteke koje treba zadržati pri izvršavanju';
$string['keepfiles_help'] = '<p>Iz bezbednosnih razloga, datoteke dodate kao as "Izvršne datoteke" se brišu pre izvršavanja datoteke vpl_execution.</p>
Ako je bilo koja od tih datoteka potrebna tokom izvršavanja (na primer da bi se koristili testni podaci), to mora biti ovde naznačeno.';
$string['lasterror'] = 'Informacije o poslednjoj grešci';
$string['lasterrordate'] = 'Datum poslednje greške';
$string['listofcomments'] = 'Lista komentara';
$string['listsimilarity'] = 'Lista pronađenih sličnosti';
$string['listwatermarks'] = 'Lista vodenih žigova';
$string['local_jail_servers'] = 'Lokalni izvršni serveri';
$string['local_jail_servers_help'] = '<p>Ovde možete podesiti lokalne izvršne servere dodate za ovu aktivnost i one koje su bazirane na njoj.</p>
<p>Unesite pun URL servera u svakom redu. Možete koristiti prazne redove i komentare koji počinju sa "#".</p>
<p>Ova aktivnost će kao listu izvršnih servera koristiti: skupove servera navedene ovde, listu servera unetu u aktivnost na kojoj je bazirana, kao i listu zajedničkih izvršnih servera. Ako želite da sprečite da ova aktivnost i iz nje izvedene aktivnosti koriste druge servere, morate dodati red koji će sadržati "end_of_jails" na kraju liste servera.
</p>';
$string['manualgrading'] = 'Ručno ocenjivanje';
$string['maxexefilesize'] = 'Maksimalna veličina izvršne datoteke';
$string['maxexememory'] = 'Maksimalna iskorišćena memorija';
$string['maxexeprocesses'] = 'Maksimalni broj procesa';
$string['maxexetime'] = 'Maksimalno vreme izvršavanja';
$string['maxfiles'] = 'Maksimalni broj datoteka';
$string['maxfilesexceeded'] = 'Prekoračen je maksimalni broj datoteka';
$string['maxfilesize'] = 'Maksimalna veličina datoteke';
$string['maxfilesizeexceeded'] = 'Prekoračena je maksimalna veličina datoteke';
$string['maximumperiod'] = 'Maksimalni period {$a}';
$string['maxresourcelimits'] = 'Maksimalna ograničenja resursa za izvršavanje';
$string['maxsimilarityoutput'] = 'Maksimalni izlaz po sličnosti';
$string['menucheck_jail_servers'] = 'Proveri izvršne servere';
$string['menuexecutionfiles'] = 'Izvršne datoteke';
$string['menuexecutionoptions'] = 'Opcije';
$string['menukeepfiles'] = 'Datoteke koje treba zadržati';
$string['menulocal_jail_servers'] = 'Lokalni izvršni serveri';
$string['menuresourcelimits'] = 'Ograničenja resursa';
$string['minsimlevel'] = 'Minimalni nivo sličnosti za prikaz';
$string['moduleconfigtitle'] = 'Podešavanje modula VPL';
$string['modulename'] = 'Virtuelna programerska laboratorija';
$string['modulename_help'] = '<p>Virtuelna programerska laboratorija (VPL) je aktivnost koja upravlja programerskim zadacima i koji korisnicima omogućava:
</p>

<ul>
<li>Omogućavanje uređivanja koda programa u čitaču korišćenjem apleta</li>
<li>Interaktivno pokretanje programa u čitaču</li>
<li>Izvršavanje test slučajeva radi kontrole kvaliteta programa</li>
<li>Poređenje predatih radova radi utvrđivanja stepena sličnosti</li>
<li>Podešavanje ograničenja pri uređivanju i blokiranje mogućnosti umetanja teksta kopiranog iz drugih izvora.</li>
</ul>
<p><b>Osnovna definicija aktivnosti Virtuelna programerska laboratorija</b></p>
<p>Da bi se pristupilo ostalim opcijama <b>prvo se mora sačuvati</b> osnovna definicija aktivnosti.</p>
<p>Ograničenja za proces predaje radova se mogu podesiti na panelu <b>Ograničenja predaje radova</b> panel:</p>
<ul>
<li>Maksimalni broj datoteka za predaju. Možete postaviti nazive datoteka na kartici "zahtevane datoteke".</li>
<li>Predaja radova moguća samo putem ograničenog editora koda. Ako aktivirate ovu opciju neće biti dozvoljeno postavljanje datoteka ni umetanje teksta kopiranog iz drugih izvora.</li>
<li>Maksimalna veličina datoteke za postavljanje.</li>
<li>Lozinka za pristup i predaju aktivnosti.
Ako postavite lozinku sistem će je tražiti od korisnika pri pristupu aktivnosti.</li>
<li>Mreže sa kojih je dozvoljena predaja radova.</li>
</ul>
<p>Na ovoj stranici se mogu podesiti i druge uobičajene opcije, kao što su skale za ocenjivanje ili parametri vezani za grupni rad.</p>';
$string['modulenameplural'] = 'Virtuelne programerske laboratorije';
$string['new'] = 'Novo';
$string['new_file_name'] = 'Novi naziv datoteke';
$string['next'] = 'Sledeći';
$string['nojailavailable'] = 'Nema raspoloživih izvršnih servera';
$string['noright'] = 'Nemate pravo pristupa';
$string['nosubmission'] = 'Nema raspoloživih predatih radova';
$string['notexecuted'] = 'Nije izvršeno';
$string['notgraded'] = 'Nije ocenjeno';
$string['notsaved'] = 'Nije sačuvano';
$string['novpls'] = 'Nema definisanih programerskih laboratorija';
$string['nowatermark'] = 'Broj sopstvenih vodenih žigova: {$a}';
$string['nsubmissions'] = 'Broj predatih radova: {$a}';
$string['numcluster'] = 'Klaster {$a}';
$string['open'] = 'Otvoreno';
$string['opnotallowfromclient'] = 'Akcija nije dozvoljena sa ove mašine';
$string['options'] = 'Opcije';
$string['optionsnotsaved'] = 'Opcije nisu sačuvane';
$string['optionssaved'] = 'Opcije su sačuvane';
$string['origin'] = 'Poreklo';
$string['othersources'] = 'Drugi izvori za dodavanje u pregled';
$string['outofmemory'] = 'Sva memorija je zauzeta';
$string['paste'] = 'Nalepi';
$string['pluginadministration'] = 'VPL administracija';
$string['pluginname'] = 'Virtuelna programerska laboratorija';
$string['previoussubmissionslist'] = 'Spisak ranije predatih radova';
$string['proposedgrade'] = 'Predložena ocena: {$a}';
$string['proxy'] = 'Posrednik (proxy)';
$string['proxy_description'] = 'Posrednik (proxy) od Moodle servera do izvršnih servera';
$string['redo'] = 'Uradi ponovo';
$string['regularscreen'] = 'Običan ekran';
$string['removegrade'] = 'Ukloni ocenu';
$string['rename'] = 'Preimenuj';
$string['rename_file'] = 'Preimenuj datoteku';
$string['replace_find'] = 'Zameni/Nađi';
$string['requestedfiles'] = 'Zahtevane datoteke';
$string['requestedfiles_help'] = '<p>Ovde postavljate nazive i početne sadržaje zahtevanih datoteka do maksimalnog broja datoteka određenog u osnovnom opisu aktivnosti.</p>
<p>Ako ne postavite imena za sve datoteke, one koje ostanu neimenovane smatraće se opcionim i moći će da imaju bilo koji naziv.</p>
<p>Možete dodati i sadržaj zahtevanim datotekama tako da on bude na raspolaganju pri prvom otvaranju tih datoteka u editoru, naravno ako ne postoji prethodno predat rad.</p>';
$string['requirednet'] = 'Dozvoljena je predaja radova sa mreže';
$string['requiredpassword'] = 'Lozinka je obavezna';
$string['resetfiles'] = 'Vrati datoteke na početno stanje';
$string['resetvpl'] = 'Vrati {$a} na početno stanje';
$string['resourcelimits'] = 'Ograničenja resursa';
$string['resourcelimits_help'] = '<p>Možete postaviti ograničenja za vreme izvršavanja, korišćenje memorije, veličinu izvršnih datoteka i broj procesa koji će se istovremeno izvršavati.</p>
<p>Ta ograničenja se koriste kad se izvršavaju skript datoteke vpl_run.sh, vpl_debug.sh i vpl_evaluate.sh i datoteka vpl_execution koju one kreiraju.</p>
<p>Ako je ova aktivnost bazirana na drugim aktivnostima na ova ograničenja  mogu uticati ona postavljena u baznoj aktivnosti i njenim precima ili u opštim podešavanjima modula.</p>';
$string['restrictededitor'] = 'Onemogući postavljanje eksternih datoteka, umetanje i prevlačenje eksternog sadržaja';
$string['retrieve'] = 'Preuzmi rezultate';
$string['run'] = 'Izvrši';
$string['running'] = 'Izvršava se';
$string['save'] = 'Sačuvaj';
$string['savecontinue'] = 'Sačuvaj i nastavi';
$string['saved'] = 'Sačuvano';
$string['savedfile'] = 'Datoteka \'{$a}\' je sačuvana';
$string['saveoptions'] = 'opcije za čuvanje';
$string['saving'] = 'Snima se';
$string['scanactivity'] = 'Aktivnost';
$string['scandirectory'] = 'Direktorijum';
$string['scanningdir'] = 'Skenira se direktorijum...';
$string['scanoptions'] = 'Opcije za skeniranje';
$string['scanother'] = 'Skeniraj sličnosti u dodatim izvornim kodovima';
$string['scanzipfile'] = 'Zip datoteka';
$string['select_all'] = 'Odaberi sve';
$string['server'] = 'Server';
$string['serverexecutionerror'] = 'Serverska greška pri izvršavanju';
$string['shortdescription'] = 'Kratak opis';
$string['similarity'] = 'Sličnost';
$string['similarto'] = 'Slično kao';
$string['startdate'] = 'Dostupno od';
$string['submission'] = 'Predat rad';
$string['submissionperiod'] = 'Period za predaju radova';
$string['submissionrestrictions'] = 'Ograničenja pri predaji radova';
$string['submissions'] = 'Predati radovi';
$string['submissionselection'] = 'Odabir predatog rada';
$string['submissionslist'] = 'Spisak predatih radova';
$string['submissionview'] = 'Prikaz predatog rada';
$string['submittedby'] = 'Rad je predao/la {$a}';
$string['submittedon'] = 'Datum predaje:';
$string['submittedonp'] = 'Datum predaje: {$a}';
$string['sureresetfiles'] = 'Da li želite da izgubite sve što ste uradili i vratite datoteke na njihovo početno stanje?';
$string['test'] = 'Aktivnost testa';
$string['testcases'] = 'Test slučajevi';
$string['testcases_help'] = '<p>Ova funkcionalnost omogućava pokretanje studentskog programa i proverava njegov izlaz za dati ulaz.  Da biste podesili test slučajeve morate popuniti datoteku "vpl_evaluate.cases".</p>
<p>Datoteka "vpl_evaluate.cases" je sledećeg formata:
<ul>
<li> "<strong>case </strong>= Opis slučaja": Opciono. Podesite početak definicije test slučaja.</li>
<li> "<strong>input </strong>= tekst": Može zauzimati više linija. Završava se sa drugom instrukcijom.</li>
<li> "<strong>output </strong>= tekst": Može zauzimati više linija. Završava se sa drugom instrukcijom. Slučaj može imati više tačnih izlaza. Postoje tri tipa izlaza: broj, tekst i tačan tekst:
<ul>
<li> <strong>broj</strong>: definiše se kao niz brojeva (celih ili realnih). Samo brojne vrednosti na izlazu se proveravaju, ostatak teksta se ignoriše. Za realne vrednosti toleriše se sitno odstupanje.</li>
<li> <strong>tekst</strong>: definiše se kao tekst bez navodnika. Samo reči se proveravaju dok se ostatak karaktera ignoriše. Pri poređenju se ne pravi razlika između malih i velikih slova.</li>
<li> <strong>tačan tekst</strong>: definiše se kao tekst pod navodnicima. Pri testiranju izlaza traži se tačno poklapanje.</li>
</ul>
</li>
<li> "<strong>redukcija ocene</strong> = [vrednost|procenat%]" : Podrazumevano greška umanjuje ocenu polaznika (počinje od maksimalne ocene) za (opseg ocena /broj slučajeva) ali ovom instrukcijom možete da promenite vrednost ili procenat redukcije.</li>
</ul>';
$string['timelimited'] = 'Ograničeno vreme';
$string['timeout'] = 'Prekoračenje vremena';
$string['timeunlimited'] = 'Neograničeno vreme';
$string['totalnumberoferrors'] = 'Greške';
$string['undo'] = 'Poništi';
$string['unexpected_file_name'] = 'Netačan naziv datoteke: očekivan je \'{$a->expected}\' a nađen \'{$a->found}\'';
$string['unzipping'] = 'Raspakuje se...';
$string['uploadfile'] = 'Postavi datoteku';
$string['usevariations'] = 'Koristi varijacije';
$string['variation'] = 'Varijacija {$a}';
$string['variation_options'] = 'Opcije varijacije';
$string['variations'] = 'Varijacije';
$string['variations_help'] = '<p>Za aktivnost se može definisati skup varijacija. Te varijacije se nasumičnim odabirom dodeljuju studentima.</p>
<p>Ovde možete naznačiti da ova aktivnost ima varijacije, staviti naslov za skup varijacija i dodati željene varijacije.</p>
<p>Svaka varijacija ima identifikacioni kod i opis. Identifikacioni kod koristi datoteka <b>vpl_enviroment.sh</b> da prosledi varijaciju dodeljenu svakom studentu skript datotekama. Opis, formatiran u HTML-u, se prikazuje studentima kojima je dodeljena odgovarajuća varijacija.</p>';
$string['variations_unused'] = 'Ova aktivnost ima varijacije, ali su one onemogućene';
$string['variationtitle'] = 'Naslov varijacije';
$string['varidentification'] = 'Identifikacija';
$string['visiblegrade'] = 'Vidljivo';
$string['vpl'] = 'Virtuelna programerska laboratorija';
$string['vpl:addinstance'] = 'Dodaj nove vpl instance';
$string['vpl:grade'] = 'Oceni VPL zadatak';
$string['vpl:manage'] = 'Upravljaj VPL zadatkom';
$string['vpl:setjails'] = 'Podesi izvršne servere za konkretnu VPL instancu';
$string['vpl:similarity'] = 'Potraži slične VPL zadatke';
$string['vpl:submit'] = 'Predaj VPL zadatak';
$string['vpl:view'] = 'Pogledaj pun opis VPL zadatka';
$string['vpl_debug.sh'] = 'Skript priprema otklanjanje grešaka';
$string['vpl_evaluate.cases'] = 'Test slučajevi za evaluaciju';
$string['vpl_evaluate.sh'] = 'Skript priprema evaluaciju';
$string['vpl_run.sh'] = 'Skript priprema izvršavanje';
$string['websocket_protocol'] = 'WebSocket protokol';
$string['websocket_protocol_description'] = 'Tip WebSocket protokola (ws:// ili wss://) koji koristi čitač da bi se povezao da izvršnim serverima.';
$string['workingperiods'] = 'Periodi rada';
$string['worktype'] = 'Tip rada';
