<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_program', language 'pt_br', version '3.8'.
 *
 * @package     tool_program
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['active'] = 'Ativo';
$string['activeprograms'] = 'Programas ativos';
$string['activeprogramslink'] = '<a href="{$a->href}">Programas ativos: {$a->count}</a>';
$string['addcourses'] = 'Adicionar cursos';
$string['addcourseslist'] = 'Selecionar cursos';
$string['addcourseslist_help'] = 'Um ou mais cursos podem ser selecionados.';
$string['addset'] = 'Adicionar conjunto';
$string['addsetorcourse'] = 'Adicionar um conjunto ou um curso';
$string['afterallocationwindowstarts'] = 'Após a alocação iniciar';
$string['afterallocationwindowstartswithrelativedate'] = '{$a} após a alocação iniciar';
$string['afterduedate'] = 'Após a data limite';
$string['afterduedatewithrelativedate'] = '{$a} após a data limite';
$string['afterstartdate'] = 'Após a data de início';
$string['afterstartdatewithrelativedate'] = '{$a} após a data de início';
$string['afteruserallocationdate'] = 'Após a data da alocação do usuário';
$string['afteruserallocationdatewithrelativedate'] = '{$a} após a data da alocação do usuário';
$string['all'] = 'Todos';
$string['allinanyorder'] = 'Todos em qualquer ordem';
$string['allinorder'] = 'Todos em ordem';
$string['allocateusers'] = 'Alocar usuários';
$string['allocationdate'] = 'Data de alocação';
$string['allocationdateonorafter'] = 'Data de alocação em ou após';
$string['allocationenddate'] = 'Data do fim da alocação';
$string['allocationenddate_help'] = 'Data final para alocar usuários neste programa';
$string['allocationfor'] = 'Alocação para \'{$a}\'';
$string['allocationsource'] = 'Fonte da alocação';
$string['allocationstartdate'] = 'Data de início da alocação';
$string['allocationstartdate_help'] = 'Data para começar a alocar usuários no programa';
$string['allocationwindow'] = 'Janela de alocação';
$string['allowdirectallocation'] = 'Permitir alocação direta';
$string['allowdirectallocation_help'] = 'Permite a alocação direta de usuários no programa';
$string['archive'] = 'Arquivar';
$string['archived'] = 'Arquivado';
$string['archivedconfirmation'] = 'Você tem certeza que quer arquivar o programa \'{$a}\'? O programa arquivado não estará mais disponível para gestores ou estudantes e será visto somente em relatórios históricos.';
$string['archivedon'] = 'Arquivado em';
$string['archivedprograms'] = 'Programas arquivados';
$string['assfirstchildof'] = 'Como primeiro filho de "{$a}"';
$string['associatedcertification'] = 'Certificação associada';
$string['associatedcertifications'] = 'Certificações associadas';
$string['associatedcertificationswithlinks'] = 'Certificações associadas com links';
$string['atleast'] = 'Ao menos';
$string['autocreategroups'] = 'Adicionar aos grupos do curso';
$string['autocreategroups_help'] = 'Quando usuário são inscritos nos cursos do programa eles podem ser automaticamente adicionados ao mesmo grupo. Um grupo com o mesmo nome do programa será criado automaticamente em cada curso. Para cursos que são compartilhados entre tenants o nome do tenant também será adicionado ao nome do grupo.';
$string['autocreategroupsnone'] = 'Não';
$string['autocreategroupsprogram'] = 'Criar grupos para este programa';
$string['availability'] = 'Disponibilidade';
$string['available'] = 'Disponível';
$string['baseset'] = 'Conjunto base';
$string['beforeenddate'] = 'Antes da data de término';
$string['beforeenddatewithrelativedate'] = '{$a} antes da data de término';
$string['calendar'] = 'Agenda';
$string['calendarduedate'] = 'Data limite para o programa {$a}';
$string['calendarenddate'] = 'Data de término para o programa {$a}';
$string['certification'] = 'Certificação';
$string['certificationdateactive'] = 'certificação deve ser concluída em';
$string['certificationdatecompleted'] = 'certificação está concluída';
$string['certificationdatecompletedexpired'] = 'Irá expirar em {$a}';
$string['certificationdateexpired'] = 'certificação expirada em';
$string['certificationdateoverdue'] = 'certificação';
$string['certificationduedate'] = 'Data limite para certificação';
$string['certificationduedatenotset'] = 'Certificação não tem uma data limite definida';
$string['close'] = 'Fechar';
$string['closetoduedate'] = 'Próximas data limite';
$string['collapsed'] = 'Contraído';
$string['completeallinanyorder'] = 'Concluir todos em qualquer ordem';
$string['completeallinorder'] = 'Concluir todos em ordem';
$string['completeatleast'] = 'Concluir ao menos';
$string['completed'] = 'Concluído';
$string['completedprogramslink'] = '<a href="{$a->href}">Programas concluídos: {$a->count}</a>';
$string['completion'] = 'Conclusão';
$string['completion_help'] = 'Tipo de conclusão a ser aplicada no conjunto';
$string['completionatleast'] = 'Concluir ao menos';
$string['completioncriteria'] = 'Critério de conclusão';
$string['completioncriteriagroup'] = 'Conclusão';
$string['completioncriteriagroup_help'] = 'Por favor, seleciona um critério de conclusão para esse conjunto específico';
$string['completiondate'] = 'Data de conclusão';
$string['completiondateonorafter'] = 'Data de conclusão em ou após';
$string['conditionprogramcompleted'] = 'Programa concluído';
$string['conditionprogramcompleteddescription'] = 'Usuários que tem o estado \'Concluído\' no programa \'{$a}\'';
$string['conditionprogramcompleteddescriptionwithdate'] = 'Usuários que tem o estado \'Concluído\' no programa \'{$a->programname}\'<br/>Data de conclusão é a partir de \'{$a->conditiondate}\'';
$string['conditionprogramnotcompleted'] = 'Programa não concluído';
$string['conditionprogramnotcompleteddescription'] = 'Usuários que não tem o estado \'Concluído\' no programa \'{$a}\'';
$string['conditionprogramoverdue'] = 'Programa atrasado';
$string['conditionprogramoverduedescription'] = 'Usuários que tem o estado \'Atrasado\' no programa \'{$a}\'';
$string['conditionprogramoverduedescriptionwithdate'] = 'Usuários que tem o estado \'Atrasado\' no programa \'{$a->programname}\'<br/>
A data de entrega é a partir de \'{$a->conditiondate}\'';
$string['conditionprogramsuspended'] = 'Programa suspenso';
$string['conditionprogramsuspendeddescription'] = 'Usuários que tem o estado \'Suspenso\' no programa \'{$a}\'';
$string['conditionprogramsuspendeddescriptionwithdate'] = 'Usuários que tem o estado \'Suspenso\' no programa \'{$a->programname}\'<br/>
A data da suspensão é a partir de \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Usuários alocados ao programa';
$string['conditionuserallocateddescription'] = 'Usuários alocados ao programa \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Usuários alocados ao programa \'{$a->programname}\'<br/>
Data de alocação é a partir de \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Usuários não alocados ao programa';
$string['conditionusernotallocateddescription'] = 'Usuários não alocados ao programa \'{$a}\'';
$string['confirmdeletecourse'] = 'Você tem certeza que quer remover o curso \'{$a}\' do programa?';
$string['confirmdeleteprogram'] = 'Você tem certeza que quer excluir o programa \'{$a}\' e todos os dados associados? Esta ação não pode ser desfeita.';
$string['confirmdeleteset'] = 'Você tem certeza que quer excluir o conjunto \'{$a}\' e remover os cursos dele?';
$string['confirmdeleteuserallocation'] = 'Você tem certeza que quer excluir completamente a alocação do usuário \'{$a}\' e os dados associados? Esta ação não pode ser desfeita.';
$string['confirmduplicate'] = 'Uma cópia será feita incluindo o conteúdo do programa e sua agenda mas sem os usuários. O ID number do programa será removido.';
$string['confirmresetprogress'] = 'Você tem certeza que quer redefinir o progresso de \'{$a}\'? Se fizer isto, todos os dados de conclusão serão perdidos. Esta ação pode demorar alguns minutos para ser concluída e não pode ser desfeita.';
$string['containscourse'] = 'Contém curso';
$string['content'] = 'Conteúdo';
$string['continue'] = 'Continuar';
$string['copy'] = 'Caopiar';
$string['course'] = 'Curso';
$string['coursealreadyinset'] = 'O curso já está neste conjunto';
$string['courseinformation'] = 'Informação do curso';
$string['coursenotavailable'] = 'Curso não disponível';
$string['courses'] = 'Cursos';
$string['coursesinset'] = 'Cursos no conjunto (separados por vírgula)';
$string['coursesinsetlines'] = 'Cursos no conjunto (um por linha)';
$string['coursesinsetlineslinks'] = 'Cursos no conjunto com links (um por linha)';
$string['coursesinsetlinks'] = 'Cursos no conjunto com links (separados por vírgula)';
$string['dateoverriden'] = 'Data sobreposta';
$string['datetypeabsolute'] = 'Selecionar data';
$string['datetypenone'] = 'Não definido';
$string['dayssinceallocation'] = 'Dias desde a alocação';
$string['daystakingprogram'] = 'Dias fazendo o programa';
$string['default'] = 'Padrão';
$string['deleteuserallocation'] = 'Excluir alocação do usuário';
$string['description'] = 'Descrição';
$string['displaycompletedcourses'] = 'Cursos concluídos no programa';
$string['displaycompletiondate'] = 'Data de conclusão do programa';
$string['displayprogramid'] = 'ID interno do programa utilizado nas URLs';
$string['displayprogramname'] = 'Nome do programa';
$string['duedate'] = 'Data de entrega';
$string['duedate_help'] = 'Data de entrega para este programa';
$string['duedateonorafter'] = 'Data de entrega a partir de';
$string['duplicate'] = 'Duplicar';
$string['dynamic'] = 'Dinâmico';
$string['dynamicrules'] = 'Regras Dinâmicas';
$string['dynamicrulesplugincheck'] = 'Ver a lista de regras dinâmicas é impossível sem o plugin tool_dynamicrule';
$string['dynamicrulewarningdeallocation'] = 'Usuários só podem ser desalocados se foram alocados por outra regra dinâmica. Alocações manuais não serão afetadas.';
$string['editcontent'] = 'Editar conteúdo';
$string['editdetails'] = 'Editar detalhes';
$string['editprogram'] = 'Editar programa \'{$a}\'';
$string['editprogramname'] = 'Editar nome do programa';
$string['editprogramsettings'] = 'Editar configurações do programa';
$string['editsetname'] = 'Editar nome do conjunto';
$string['enddate'] = 'Data de término';
$string['enddate_help'] = 'Data de término para este programa';
$string['enrol'] = 'Inscrever';
$string['enrolled'] = 'Inscrito';
$string['entityprogram'] = 'Programa';
$string['entityprogramcompletion'] = 'Conclusão do usuário';
$string['entityprogramcontent'] = 'Conteúdo do programa';
$string['entityprogramitem'] = 'Item do programa';
$string['entityprogramset'] = 'Conjunto do programa';
$string['entityprogramusers'] = 'Alocação de usuário';
$string['errorallocationenddatepreviousstartdate'] = 'A data de término da alocação não pode ser antes da data de início da alocação';
$string['errorbasesetnotfound'] = 'Conjunto base não encontrado';
$string['errorcannotresetprogram'] = 'Não foi possível redefinir o programa';
$string['errorcantallocateusers'] = 'Não foi possível alocar usuários';
$string['errorcantcreateset'] = 'Não foi possível criar o conjunto';
$string['errorcantdeletenotarchivedprogram'] = 'Não é possível excluir um programa que não esteja arquivado';
$string['errorcantselfenrol'] = 'Não foi possível fazer a auto inscrição';
$string['errorcertificationnotfound'] = 'Certificação não encontrada';
$string['errorduedatepreviousstartdate'] = 'Data de entrega não pode ser antes da data de início';
$string['errorenddatepreviousduedate'] = 'Data de término não pode ser antes da data de entrega';
$string['errorenddatepreviousstartdate'] = 'A data de término não pode ser antes da data de início';
$string['errorhelperactionnotallowed'] = 'Ação de ajuda não permitida';
$string['erroridnumberuniquetenant'] = 'Este ID number já está sendo usado por outro programa';
$string['errorinvaliddate'] = 'Data inválida';
$string['errorinvalidprogram'] = 'Programa inválido';
$string['errorinvalidprogramitemmove'] = 'Movimentação inválida de item de programa';
$string['errorloadingprogram_mobile'] = 'Erro ao carregar o programa';
$string['errormissingenrolprogramplugin'] = 'O plugin de inscrição por programa está faltando';
$string['errornopermissionmanageprograms'] = 'Sem permissão para gerenciar programas';
$string['errornopermissionmanageusers'] = 'Sem permissão para gerenciar usuários';
$string['errornopermissionviewprograms'] = 'Sem permissão para ver programas';
$string['errornopermissionviewreports'] = 'Sem permissão para ver relatórios';
$string['errorprogramnotfound'] = 'Programa não encontrado';
$string['errorreporttypedoesnotexist'] = 'Tipo de relatório não existe';
$string['errorusercantbeallocated'] = 'Usuários não podem ser alocados';
$string['eventcourseadded'] = 'Curso adicionado';
$string['eventcourseremoved'] = 'Curso removido';
$string['eventcourseupdated'] = 'Curso atualizado';
$string['eventprogramcompleted'] = 'Programa concluído';
$string['eventprogramcreated'] = 'Programa criado';
$string['eventprogramdeleted'] = 'Programa excluído';
$string['eventprogramupdated'] = 'Programa atualizado';
$string['eventsetcompleted'] = 'Conjunto concluído';
$string['eventsetcreated'] = 'Conjunto criado';
$string['eventsetdeleted'] = 'Conjunto excluído';
$string['eventsetupdated'] = 'Conjunto atualizado';
$string['eventuserallocated'] = 'Usuário alocado';
$string['eventuserdeallocated'] = 'Usuário desalocado';
$string['expanded'] = 'Expandido';
$string['fullcompletionreport'] = 'Relatório completo de conclusão';
$string['futureallocation'] = 'Alocação futura';
$string['gotocourse'] = 'Ir ao curso';
$string['idnumber'] = 'ID number';
$string['inprogress'] = 'Em progresso';
$string['keepprogramdefaults'] = 'Manter os padrões do programa';
$string['lessthanaday'] = 'Menos de um dia';
$string['locked'] = 'Travado';
$string['lockedreasonparent'] = 'Disponível somente se: cojunto {$a} estiver disponível.';
$string['lockedreasonpreviouscourse'] = 'Disponível somente se: curso anterior {$a} estiver marcado como concluído.';
$string['lockedreasonpreviousset'] = 'Disponível somente se: conjunto anterior {$a} estiver marcado como concluído.';
$string['maincompletion'] = 'Conclusão principal';
$string['manual'] = 'Manual';
$string['messageprovider:programcompleted'] = 'Programa concluído';
$string['messageprovider:programuserallocated'] = 'Usuário alocado';
$string['messageprovider:programuserdeallocated'] = 'Usuário desalocado';
$string['missingcompletion'] = 'Está faltando o critério de conclusão';
$string['missingcourse'] = 'Está faltando o curso';
$string['missingfullname'] = 'Está faltando o nome do programa.';
$string['missingprogram'] = 'Está faltando o programa';
$string['missingsetname'] = 'Está faltando o nome do conjunto';
$string['name'] = 'Nome';
$string['never'] = 'Nunca';
$string['newnameforset'] = 'Novo nome para \'{$a}\'';
$string['newprogram'] = 'Novo programa';
$string['notarchived'] = 'Não arquivado';
$string['notavailable'] = 'Não disponível';
$string['notcompleted'] = 'Não concluído';
$string['notenrolledprograms_mobile'] = 'Você não está inscrito em nenhum programa';
$string['notificationmsgfooter'] = 'Você pode encontrar todos os seus programas no seu <a href="{$a}">Painel</a>';
$string['notificationmsgprogramcompleted'] = 'Parabéns! Você concluiu o programa \'{$a}\'.';
$string['notificationmsgprogramuserallocated'] = 'Você foi alocado ao programa \'{$a}\'.';
$string['notificationmsgprogramuserdeallocated'] = 'Você foi desalocado do programa \'{$a}\'.';
$string['notificationsubjectprogramcompleted'] = 'Programa \'{$a}\' concluído';
$string['notificationsubjectprogramuserallocated'] = 'Alocado ao programa \'{$a}\'';
$string['notificationsubjectprogramuserdeallocated'] = 'Desalocado do programa \'{$a}\'';
$string['notset'] = 'Não definido';
$string['notsuspended'] = 'Não suspenso';
$string['notvisible'] = 'Não visível';
$string['nousersselected'] = 'Você precisa selecionar ao menos um usuário';
$string['numbercoursesinprogramunique'] = 'Número de cursos (único)';
$string['numbercoursesinset'] = 'Número de cursos no conjunto';
$string['numbercurrentallocatedusers'] = 'Número de usuários alocados atualmente';
$string['open'] = 'Aberto';
$string['outcomeallocation'] = 'Alocar usuários aos programas';
$string['outcomeallocationdescription'] = 'Alocar usuários ao programa \'{$a}\'<br/>
Manter a data de início padrão do programa';
$string['outcomeallocationdescriptionwithdate'] = 'Alocar usuários ao programa \'{$a->programname}\'';
$string['outcomedeallocation'] = 'Desalocar usuários dos programas';
$string['outcomedeallocationdescription'] = 'Desalocar usuários do programa \'{$a}\'';
$string['overdue'] = 'Atrasado';
$string['overdueprogramslink'] = '<a href="{$a->href}">Programas atrasados: {$a->count}</a>';
$string['parentname'] = 'Nome do pai';
$string['pending'] = 'Pendente';
$string['pendingreasonhiddencourse'] = 'Alguns cursos que são necessários para destravar este curso não estão disponíveis. Por favor, contate o administrador do site.';
$string['pendingreasonparent'] = 'Será automaticamente marcado como concluído quando: conjunto {$a} estiver disponível.';
$string['pendingreasonpreviouscourse'] = 'Será marcado como concluído automaticamente quando: curso anterior {$a} for marcado como concluído.';
$string['pendingreasonpreviousset'] = 'Será marcado como concluído automaticamente quando: conjunto anterior {$a} for marcado como concluído.';
$string['percentcompleted'] = '{$a}% concluído';
$string['pluginname'] = 'Programa';
$string['previewprogramname'] = 'Pré-visualização do nome do programa';
$string['privacy:metadata:core_tag'] = 'Marcadores adicionados a programas';
$string['privacy:metadata:preference:tool_program_program_status_filter'] = 'Armazena a seleção do usuário para o filtro de estado do programa';
$string['privacy:metadata:program_set_completion'] = 'Informação sobre a conclusão de um conjunto de um programa.';
$string['privacy:metadata:program_set_completion:completeddate'] = 'A data na qual o usuário concluíu o conjunto.';
$string['privacy:metadata:program_set_completion:setid'] = 'O conjunto concluído.';
$string['privacy:metadata:program_set_completion:timemodified'] = 'O momento de modificação da conclusão do conjunto.';
$string['privacy:metadata:program_set_completion:userid'] = 'O usuário que concluíu o conjunto.';
$string['privacy:metadata:program_users'] = 'Informação sobre a alocação do usuário ao programa.';
$string['privacy:metadata:program_users:allocationtype'] = 'A fonte a partir da qual o usuário foi alocado.';
$string['privacy:metadata:program_users:certificationid'] = 'À qual certificação foi alocado (se aplicável).';
$string['privacy:metadata:program_users:duedate'] = 'A data de entrega do programa.';
$string['privacy:metadata:program_users:duedatelocked'] = 'Se a data de entrega padrão do programa foi sobreposta.';
$string['privacy:metadata:program_users:enddate'] = 'Data de término do programa para este usuário.';
$string['privacy:metadata:program_users:enddatelocked'] = 'Se a data de término padrão do programa foi sobreposta.';
$string['privacy:metadata:program_users:programid'] = 'O programa ao qual foi alocado.';
$string['privacy:metadata:program_users:startdate'] = 'Data de início do programa para este usuário.';
$string['privacy:metadata:program_users:startdatelocked'] = 'Se a data de início padrão do programa foi sobreposta.';
$string['privacy:metadata:program_users:status'] = 'Se o usuário foi suspenso do programa.';
$string['privacy:metadata:program_users:timemodified'] = 'O momento de modificação da alocação do usuário.';
$string['privacy:metadata:program_users:userid'] = 'O ID do usuário alocado ao programa.';
$string['program:allocateuser'] = 'Alocar usuários a programas';
$string['program:configurecustomfields'] = 'Configurar campos personalizados de programas';
$string['program:coursereset'] = 'Redefinir os cursos do programa';
$string['program:edit'] = 'Editar programas';
$string['programcreated'] = 'Programa criado com sucesso';
$string['programdescription'] = 'Descrição do programa';
$string['programdescription_help'] = 'A descrição do programa é apresentada no Painel.';
$string['programdisplay'] = 'Apresentação do programa';
$string['programduedate'] = 'Data de entrega do programa';
$string['programfullname'] = 'Nome do programa';
$string['programfullname_help'] = 'O nome do programa é apresentado no Painel e na lista de programas.';
$string['programidnumber'] = 'ID number do programa';
$string['programidnumber_help'] = 'O ID number de um programa é usado apenas quando "casando" o programa com sistemas externos e não é apresentado em nenhum lugar do site. Se o programa tem um código ou nome oficial, você deve preenchê-lo aqui, caso contrário, deixe em branco.';
$string['programimage'] = 'Imagem do programa';
$string['programimage_help'] = 'A imagem do propgrama é apresentada no Painel.';
$string['programname'] = 'Nome do programa';
$string['programnamewithimage'] = 'Nome do programa com imagem';
$string['programparentsetname'] = 'Nome do conjunto pai';
$string['programprogress'] = 'Progresso do programa';
$string['programreset'] = 'Redefinição do programa';
$string['programrules'] = 'Regras do programa';
$string['programs'] = 'Programas';
$string['programscustomfield'] = 'Campos personalizados de programas';
$string['programsetname'] = 'Nome do conjunto';
$string['programsort'] = 'Ordenação do programa';
$string['programsoverview'] = 'Programas';
$string['programsoverview_mobile'] = 'Visão geral dos programas';
$string['programstatus'] = 'Estado do programa';
$string['programtags'] = 'Marcados do programa';
$string['programtags_help'] = 'Marcadores deste programa';
$string['programvisibility'] = 'Visibilidade do programa';
$string['programvisibility_help'] = 'Esta configuração determina se o programa é apresentado no Painel dos usuários e se eles podem acessá-lo.';
$string['progressoverview'] = 'Visão geral do progresso';
$string['progresspercent'] = 'Progresso';
$string['progressreport'] = 'Relatório de progresso';
$string['reg_wpprograms'] = 'Número de programas ({$a})';
$string['reportactiveprograms'] = 'Relatório de sistema dos programas ativos';
$string['reportarchivedprograms'] = 'Relatório de sistema dos programas arquivados';
$string['reportbuilderactiveprograms'] = 'Ver a lista de programas ativos é impossível sem o plugin tool_reporbuilder';
$string['reportbuilderarchivedprograms'] = 'Ver a lista de programas arquivados é impossível sem o plugin tool_reporbuilder';
$string['reportbuilderdynamicrules'] = 'Ver a lista de regras dinâmicas é impossível sem o plugin tool_reporbuilder';
$string['reportbuilderuserallocations'] = 'Ver a lista de alocações de usuários é impossível sem o plugin tool_reporbuilder';
$string['reportbuilderuserlist'] = 'Ver a lista de usuários é impossível sem o plugin tool_reporbuilder';
$string['reportprogramprogress'] = 'Relatório de sistema do progresso do programa';
$string['reportprogramsallocationcompletion'] = 'Alocações e conclusões de usuários ao programa';
$string['reportprogramusers'] = 'Relatório de sistema de usuários do programa';
$string['reportuserprogram'] = 'Relatório de sistema do progresso do usuário no programa';
$string['reportuserprograms'] = 'Relatório de sistema da listagem de programas do usuário';
$string['resetprogress'] = 'Redefinir programa';
$string['restore'] = 'Restaurar';
$string['review'] = 'Revisar';
$string['rolemanager'] = 'Gestor do programa';
$string['rolemanagerdescription'] = 'Permite criar e gerenciar programas em seu tenant atual e alocar usuários aos programas';
$string['scheduleupdatesuccess'] = 'Agendamento atualizado com sucesso';
$string['searchprogram'] = 'Buscar programa';
$string['seecontent_mobile'] = 'Ver conteúdo';
$string['selectcourses'] = 'Selecionar cursos';
$string['selectprogramcondition'] = 'Programa';
$string['selectprogramcondition_help'] = 'Selecione um programa para ser associado a esta condição';
$string['selectprogramoutcome'] = 'Programa';
$string['selectprogramoutcome_help'] = 'Selecione um programa para ser associado a esta ação';
$string['separatetenantsingroupswarning'] = 'Em cursos compartilhados entre tenants, usuários de cada tenant serão adicionados a grupos separados.';
$string['set'] = 'Conjunto';
$string['setid'] = 'ID do conjunto';
$string['setname'] = 'Nome';
$string['setname_help'] = 'Por favor, escolha um nome para este conjunto';
$string['setsandcoursesnotfound_mobile'] = 'Nenhum conjunto ou curso encontrado';
$string['start'] = 'Início';
$string['startdate'] = 'Data de início';
$string['startdate_help'] = 'Data de início para este programa';
$string['status'] = 'Estado';
$string['status_help'] = 'O estado suspenso irá esconder este programa do usuário.';
$string['suspended'] = 'Suspenso';
$string['suspendeddateonorafter'] = 'Data de suspensão a partir de';
$string['tagarea_tool_program'] = 'Programas';
$string['tags'] = 'Marcadores';
$string['timecreated'] = 'Criado em';
$string['timemodified'] = 'Última alteração em';
$string['timesuspended'] = 'Suspenso em';
$string['type'] = 'Tipo';
$string['unknownprogram'] = 'Programa desconhecido';
$string['userallocation'] = 'Alocação ao programa';
$string['userduedate'] = 'Data de entrega';
$string['userduedate_help'] = 'Selecione a data de entrega do programa para este usuário.';
$string['userenddate'] = 'Data de término';
$string['userenddate_help'] = 'Selecione a data na qual este programa não será visível para este usuário.';
$string['userlist'] = 'Selecionar usuários';
$string['userlist_help'] = 'Seleciona usuários para alocar a este programa';
$string['users'] = 'Usuários';
$string['userstartdate'] = 'Data de início';
$string['userstartdate_help'] = 'Selecione a data na qual este usuário poderá iniciar o programa. Esta data será aplicada somente a este usuário.';
$string['visible'] = 'Visível';
$string['warningcourseinvisible'] = 'Aviso: este curso está invisível para os estudantes.';
$string['withduedate'] = 'Com data de entrega';
