<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'congrea', language 'pt', version '3.8'.
 *
 * @package     congrea
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['absent'] = 'Ausente:';
$string['action'] = 'Ação';
$string['addmultiplesessions'] = 'Repetir esta sessão';
$string['addsessions'] = 'Adicionar sessão';
$string['afterkeysavemsg'] = 'Chave API Congrea e chave secreta aprovadas e guardadas com sucesso';
$string['allsessions'] = 'Todas as próximas sessões';
$string['alreadyhave'] = 'Já configurou a chave API e a chave secreta.';
$string['apikey'] = 'A sua chave API é';
$string['askQuestion'] = 'Pergunta & Resposta';
$string['askQuestion_help'] = 'Se ativar esta opção, permite que professores e alunos usem o recurso Fazer pergunta';
$string['askplaymsg'] = '<span id="askplaymsg"> "Descarga em processo, clique em Reproduzir para começar </span>"';
$string['attendance'] = 'Assiduidade';
$string['attendeerecording'] = 'Gravações dos alunos';
$string['attendeerecording_help'] = 'Se ativar esta opção, permite que sejam gravadas as atividades do aluno durante uma sessão.';
$string['attendencereport'] = 'Relatório da assiduidade';
$string['audio'] = 'Áudio';
$string['audio_help'] = 'Se ativado, por predefinição, o áudio de todos os alunos estará ativo.';
$string['audiolatency'] = 'Latência do áudio';
$string['audiotest'] = 'Testar áudio';
$string['blankduration'] = 'Entrada inválida!';
$string['cannotsavekey'] = 'Não foi possível guardar a chave API Congrea ou a chave secreta';
$string['cgallowoverride'] = 'Permitir substituição';
$string['cgallowoverride_help'] = 'Se ativar esta opção, permite que as configurações sejam substituídas nas configurações da atividade dentro da disciplina.';
$string['cgapi'] = 'Chave API Congrea';
$string['cgapid'] = 'Chave API:';
$string['cgrecording'] = 'Ativar gravação de sessões';
$string['cgrecording_help'] = 'Se ativar esta opção, permitirá gravação automática das suas sessões Congrea para esta atividade.';
$string['cgrecordingd'] = 'Se ativar esta opção, pode optar por permitir, ou não, a gravação automática de sessão nas atividades Congrea.';
$string['cgsecret'] = 'Chave secreta Congrea';
$string['cgsecretd'] = 'Insira a chave secreta Congrea';
$string['cgsecretdv'] = 'Chave secreta:';
$string['closebeforeopen'] = 'Não foi possível guardar o Congrea. A data de fecho indicada é anterior à data de abertura.';
$string['closenotset'] = 'Não foi indicada uma hora de fecho.';
$string['closesameopen'] = 'A hora de inicio e de fecho da sessão não podem ser iguais';
$string['closetime'] = 'Sessões fechadas';
$string['colorpicker'] = 'Seletor de cores personalizadas';
$string['colorpickerd'] = 'Escolha a cor personalizada';
$string['configuredheading'] = '<h4>Congrea está configurado. Pode começar a usá-lo agora.</h4>';
$string['conflicts'] = 'Existem algumas sessões em conflito na lista das próximas sessões.';
$string['conflictsdate'] = 'Vaga não disponível';
$string['congrea'] = 'Congrea';
$string['congrea:addinstance'] = 'Adicionar novo Congrea';
$string['congrea:attendance'] = 'Relatório da assiduidade';
$string['congrea:managesession'] = 'Gerir sessões';
$string['congrea:playrecording'] = 'Reproduzir gravação';
$string['congrea:pollreport'] = 'Visualizar relatório da votação';
$string['congrea:quizreport'] = 'Visualizar relatório do teste';
$string['congrea:recordingdelete'] = 'Apagar gravação';
$string['congrea:sessionpresent'] = 'Sessão atual';
$string['congrea:view'] = 'Ver Congrea';
$string['congreadocument'] = 'Este ficheiro já foi carregado anteriormente';
$string['congreafieldset'] = 'Exemplo personalizado de campos';
$string['congreagenerald'] = 'Chave API Congrea';
$string['congreaname'] = 'Nome do Congrea';
$string['congreaname_help'] = 'Sessão online em tempo real que permite a interação dos participantes uns com os outros e que fornece ferramentas de comunicação assíncrona, tais como como quadro em branco, chat e partilha de ecrã.';
$string['congreapoll'] = 'Pergunta da votação Congrea';
$string['congrearecseeting'] = 'Gravação Congrea';
$string['correct'] = 'Correto';
$string['coursesactivity'] = 'Atividade das disciplinas (eventos por disciplina)';
$string['currentsessiontime'] = 'Horário da aula virtual:&nbsp;';
$string['customsetting'] = 'Configurações personalizadas';
$string['datacenter'] = 'Centro de dados';
$string['datacenter_help'] = 'Escolha o nome do centro de dados mais próximo da localização do seu público';
$string['dateandtime'] = 'Data e hora';
$string['datetimelist'] = 'Data e hora da primeira sessão';
$string['deletebtn'] = 'Apagar';
$string['deletepolloption'] = 'A operação de apagar está Sem sucesso';
$string['deleterecordingfile'] = 'Tem a certeza de que pretende apagar o ficheiro de gravação <br> "{$a}"?';
$string['deleteschedule'] = 'Tem a certeza de que pretende apagar esta sessão?';
$string['disable'] = 'Desativar';
$string['disableAudio'] = 'Desativar áudio';
$string['disablespeaker'] = 'Silencioso';
$string['displaymode'] = 'Modo de exibição';
$string['domain'] = 'URL do domínio';
$string['domain_help'] = 'Insira o URL do seu domínio';
$string['downloadsession'] = 'Por favor, aguarde enquanto a gravação é descarregada.';
$string['editbtn'] = 'Editar';
$string['editingschedule'] = 'Editar uma sessão programada';
$string['editingsession'] = 'A editar marcação:&nbsp;';
$string['email'] = 'E-mail';
$string['email_help'] = 'Insira o seu endereço de e-mail';
$string['enable'] = 'Ativar';
$string['enableAudio'] = 'Ativar som';
$string['enablerecording'] = 'Gravação das sessões';
$string['enablerecording_help'] = 'Se ativar esta opção, permite a gravação automática de sessão para todas as sessões no site.';
$string['enablespeaker'] = 'Ativar áudio';
$string['enrolledlater'] = 'Inscrito mais tarde';
$string['enrolteacher'] = 'Inscrever um professor nesta disciplina';
$string['errorcurl'] = 'Ocorreu um erro ao obter detalhes do plano. Atualize a página.';
$string['errordurationlimit'] = 'Introduziu uma duração de sessão inválida. A duração deve ser maior que 10 minutos e menor que 24 horas. Se estiver a adicionar uma sessão aberta use valor \'0\'';
$string['errortimeduration'] = 'Introduziu uma duração de sessão inválida. A duração deve ser maior que 10 minutos e menor que 24 horas. Se estiver a adicionar uma sessão aberta use valor \'0\'';
$string['esessiondate'] = 'Indicou uma data ou hora inválida.';
$string['event'] = 'Evento';
$string['eventsbymonth'] = 'Eventos por mês ({$a})';
$string['eventsmosttriggered'] = 'Eventos mais desencadeados';
$string['exittime'] = 'Hora de saída';
$string['filename'] = 'Nome do ficheiro';
$string['filter'] = 'Selecionar filtro';
$string['filter_help'] = 'Selecionar filtro';
$string['firstname'] = 'Nome';
$string['firstname_help'] = 'Insira o seu nome';
$string['freeplan'] = 'Para obter o plano gratuito Congrea, clique <a href="../mod/congrea/getkeyindex.php"><strong>aqui</strong></a>';
$string['from'] = 'desde:';
$string['fromsessiondate'] = 'Hora de início da sessão';
$string['fromsessiondate_help'] = 'Selecionar a data e hora da sessão.';
$string['generalsection'] = 'Configurações gerais';
$string['generate'] = 'Criar';
$string['getformheading'] = 'Obter plano gratuito Congrea';
$string['getfreeplan'] = 'Obtenha o plano gratuito do Congrea';
$string['getkey'] = 'Chave API Congrea';
$string['grade'] = 'Nota';
$string['gradenotsaved'] = 'Nota não guardada';
$string['graphic:view'] = 'Visualizar relatório gráfico de eventos';
$string['headingschedules'] = 'Agendamentos';
$string['hours'] = 'hr';
$string['hourssetting'] = 'Indicou uma data ou hora inválida. Verifique se a duração total da sessão não deve excede 10 horas.';
$string['httpserror'] = 'Aviso! HTTPS (ssl) é obrigatório para Congrea. Foi detetado que atualmente o Moodle não está configurado como https e, por isso, algumas funcionalidades do Congrea podem não funcionar.';
$string['incorrectcmid'] = 'O ID do módulo da disciplina estava incorreto';
$string['indvprogress'] = 'Tarefa atual';
$string['infinitesession'] = 'Sessão aberta';
$string['informationtocreatesession'] = '<strong>Nota</strong>: Uma atividade do Congrea pode ter uma única sessão aberta ou várias sessões com duração. Para criar uma sessão aberta, insira a duração como \'0\'.';
$string['invalidcmidorinsid'] = 'Tem de especificar um ID do módulo da disciplina ou um ID de instância.';
$string['invalidcoursemodule'] = 'Módulo de disciplina inválido.';
$string['invaliddata'] = 'Dados inválidos.';
$string['invalidkey'] = '<div class="alert alert-warning alert-block fade in">Chave API Congrea/chave secreta inválida ou em falta</div>';
$string['joinasstudent'] = 'Participar da sessão da sala de aula virtual';
$string['joinasteacher'] = 'Entrar na sala como Apresentador';
$string['jointime'] = 'Hora de acesso';
$string['keyis'] = 'Chave API:';
$string['lastname'] = 'Apelido';
$string['lastname_help'] = 'Insira o seu apelido';
$string['legacyplan'] = 'Plano Congrea legado sem gravação';
$string['legacysession'] = 'Sessão legada';
$string['livepresenter'] = 'Apresentador: {$a->firstname} {$a->lastname}';
$string['liverun'] = 'Online - Usar servidor vidya.io';
$string['menu'] = 'Relatório gráfico de eventos';
$string['message'] = '<div class="alert alert-warning alert-block fade in">Obtenha a chave API Congrea/chave secreta do plano gratuito Congrea para o seu domínio. Se já possui chaves da API Congrea, atualize e configure o Congrea <a href="../../admin/settings.php?section=modsettingcongrea"><strong>aqui</strong></a></div>';
$string['mins'] = ' min';
$string['missingdatacenter'] = 'Nome do centro de dados em falta';
$string['missingdomain'] = 'Nome do domínio em falta';
$string['missingprivacy'] = 'Obrigatório para aceitar a política de privacidade.';
$string['missingterms'] = 'Obrigatório para aceitar os Termos de Serviço.';
$string['modulename'] = 'Congrea';
$string['modulename_help'] = 'O módulo Congrea é usado no ensino online em tempo real. Permite-lhe participar na aprendizagem síncrona, o que significa que o professor/apresentador e os alunos estão ligados num ambiente virtual de aprendizagem e interagem uns com os outros ao mesmo tempo.
Este módulo dota os alunos de ferramentas de comunicação assíncrona, tais como, quadro branco e chat';
$string['modulenameplural'] = 'Congreas';
$string['name'] = 'Nome';
$string['newsessionadded'] = 'Criado novo agendamento na tabela.';
$string['next30sessions'] = 'Próximas 30 sessões';
$string['next7sessions'] = 'Próximas 7 sessões';
$string['next90sessions'] = 'Próximas 90 sessões';
$string['noattempt'] = 'Nenhum utilizador fez qualquer tentativa';
$string['nofetchplandetails'] = 'Não foi possível obter os detalhes do seu plano. Por favor, tente novamente!';
$string['nopolldata'] = 'Sem dados para guardar';
$string['nopollresult'] = 'Não é possível guardar o resultado da votação';
$string['nopollsave'] = 'Não é possível guardar a votação';
$string['noquestionsinquiz'] = 'Este teste ainda não tem perguntas.';
$string['noquizattempt'] = 'Nenhum utilizador fez qualquer tentativa';
$string['noquizreport'] = 'Sem dados disponíveis.';
$string['norecordingtoshow'] = 'Não existem gravações para mostrar';
$string['norecordtodelete'] = 'A(s) sessão(ões) não existe(m) na tabela da base de dados.';
$string['noreport'] = 'Sem dados disponíveis.';
$string['nosession'] = 'Nenhuma sessão disponível para mostrar.';
$string['notavaliduser'] = 'Apresentador inválido';
$string['notavaliduserwithname'] = 'é um apresentador inválido.';
$string['notcapabletocreateevent'] = 'Não pode criar, editar ou apagar uma sessão porque não tem a permissão de criar um evento no calendário.';
$string['notcapabletodeletereport'] = 'Não pode apagar um relatório porque não possui a permissão de gerir sessões.';
$string['notcapabletoviewschedules'] = 'Não tem permissão para visualizar agendamentos.';
$string['notenrol'] = 'Nenhum utilizador inscrito nesta disciplina';
$string['notsavekey'] = 'Chave API Congrea em falta. Aceda às <a href="{$a}">configurações do Congrea</a> para inserir a chave.';
$string['notsession'] = '<h2>Não existem sessões disponíveis.</h2>';
$string['noupcomingsession'] = 'Não existem próximas sessões.';
$string['nouser'] = 'Nome de utilizador não encontrado';
$string['onlyintegerallowed'] = 'Entrada inválida. Insira apenas números inteiros (\'0\' para Aberta e \'10\' a \'1439\' para sessão programada.';
$string['onlysingleinfinite'] = 'Uma atividade Congrea pode ter uma única sessão aberta ou várias sessões com duração! Primeiro apague todas as sessões existentes e, em seguida, crie outro tipo de agendamento.';
$string['openended'] = 'Aberta';
$string['opentime'] = 'Sessões abertas';
$string['options'] = 'Opções';
$string['overallprogress'] = 'Progresso geral';
$string['overrideheading'] = 'Configurações da substituição';
$string['percentage'] = 'Percentagem';
$string['plandetails'] = 'Detalhes do seu plano: {$a->rooms} salas, {$a->users} utilizadores, {$a->storage} GB de armazenamento na nuvem {$a->recordingstr}';
$string['play'] = 'Reproduzir';
$string['pluginadministration'] = 'Administração do Congrea';
$string['pluginname'] = 'Congrea';
$string['polldelete'] = 'Apagar votação está definida como Sem sucesso. Tente novamente';
$string['polloptiondeletefailed'] = 'Ocorreu um erro ao apagar. Tente novamente.';
$string['polloverview'] = 'Visão global da votação Congrea';
$string['pollquestionis'] = 'A pergunta da votação é:';
$string['pollquestions'] = 'Perguntas da votação';
$string['pollreport'] = 'Relatório da votação';
$string['pollretrievefail'] = 'Não é possível recuperar a votação. Tente novamente';
$string['pollupdatefail'] = 'Atualizar votação está definida como Sem sucesso. Tente novamente';
$string['presence'] = 'Presença';
$string['present'] = 'Presente:';
$string['preset'] = 'Cor predefinida';
$string['presetd'] = 'Selecione a cor predefinida';
$string['pressAlwaysToSpeak'] = 'Pressionar sempre para falar.';
$string['pressalways'] = 'Pressionar sempre para falar';
$string['pressonce'] = 'Pressionar uma vez para falar';
$string['privacy'] = 'Eu aceito a <a href=\'https://www.congrea.com/documents-for-foreign-customers/#5e886344a0508-0\' target=\'_blank\'>Política de privacidade</a>.';
$string['privacy_help'] = 'Leia a política de privacidade e marque a caixa de verificação.';
$string['proposedspeed'] = 'Velocidade proposta';
$string['psession'] = 'Sessões gravadas';
$string['pushtotalk'] = 'Pressionar para falar';
$string['pushtotalk_help'] = 'Se ativar esta opção, será mostrada uma opção extra para testar o áudio.';
$string['qaAnswer'] = 'Responder';
$string['qaAnswer_help'] = 'Se ativar esta opção, permite que os alunos respondam à pergunta publicada no painel Fazer pergunta';
$string['qaComment'] = 'Comentar';
$string['qaComment_help'] = 'Se ativar esta opção, permite que os alunos comentem sobre respostas e outros comentários';
$string['qaMarkNotes'] = 'Favoritos e Anotações';
$string['qaMarkNotes_help'] = 'Se ativar esta opção, permite que ao apresentador e aos alunos adicionarem Favoritos e Anotações privadas';
$string['qaUpvote'] = 'Votação';
$string['qaUpvote_help'] = 'Se ativar esta opção, permite que os alunos votem nas perguntas e respostas';
$string['qattempted'] = 'P.Tentada';
$string['quantity'] = 'quantidade';
$string['questionsanswersettings'] = 'Configurações de Pergunta & Resposta';
$string['quizheading'] = 'Visão global do teste Congrea';
$string['quizname'] = 'Nome do teste';
$string['quizreport'] = 'Relatório do teste';
$string['recAllowattendeeAVcontrol'] = 'Controlo do aluno sobre a gravação A/V';
$string['recAllowattendeeAVcontrol_help'] = 'Se ativar esta opção, permite que os alunos controlem a sua gravação A/V, ou seja, eles podem a qualquer momento parar e iniciar a sua própria gravação A/V durante uma sessão ao vivo.';
$string['recAllowpresentorAVcontrol'] = 'Controlo do apresentador sobre a gravação A/V';
$string['recAllowpresentorAVcontrol_help'] = 'Se ativar esta opção, permite que o apresentador pare e inicie a gravação A/V de toda a sessão durante uma sessão ao vivo.';
$string['recShowPresentorRecordingStatus'] = 'Visibilidade do estado da gravação para o apresentador';
$string['recShowPresentorRecordingStatus_help'] = 'Se ativar esta opção, permite a visibilidade do estado da gravação para o apresentador, ou seja, saberá a cada instante se a sessão está a ser gravada, ou não, no seu ecrã Congrea';
$string['recattendeeav'] = 'Gravação A/V dos alunos';
$string['recattendeeav_help'] = 'Se ativar esta opção, permite que os alunos gravem A/V durante a sessão, ou seja, todos os dados binários, como áudio, vídeo e partilha de ecrã, serão gravados na gravação da sessão.';
$string['recordedsessions'] = 'Sessões gravadas';
$string['recordingcontrol'] = 'Controlo da gravação';
$string['recordingsection'] = 'Configurações da gravação';
$string['recordingviewed'] = 'Gravação visualizada';
$string['repeatedweeks'] = ' semanas a cada ';
$string['repeaton'] = 'Repetir em';
$string['repeatsession'] = 'Repetir sessões';
$string['repeatsessions'] = 'Agendar várias sessões';
$string['repeatstatus'] = 'Repetir por';
$string['repeattype'] = 'Modo de repetição';
$string['repeattype_help'] = 'Modo de repetição';
$string['repeatweekly'] = 'Repetir semanalmente, criando um total de';
$string['replay'] = 'Repetir';
$string['replay_message'] = 'Obrigado por assistir.';
$string['scheduleid'] = 'ID do agendamento';
$string['secretis'] = 'Chave secreta:';
$string['secs'] = 'seg(s)';
$string['selectcolor'] = 'Selecionar cor';
$string['selectcolor_help'] = 'Escolha a cor para a sala de aula';
$string['selectdays'] = 'Selecione os dias';
$string['selectteacher'] = 'Selecione o apresentador';
$string['selectteacher_help'] = 'Selecione o apresentador para esta sessão';
$string['sessduration'] = 'Duração da sessão';
$string['sessionareport'] = 'Relatório da assiduidade da sessão';
$string['sessionclosed'] = 'Esta sessão não está disponível';
$string['sessiondate'] = 'Data da sessão';
$string['sessionduration'] = 'Duração da sessão:';
$string['sessionedited'] = 'Sessão atualizada.';
$string['sessionenddate'] = 'Hora de fim da sessão';
$string['sessionenddate_help'] = 'Hora de fim da sessão';
$string['sessionendmsg'] = 'A sessão foi encerrada. Pode fechar o navegador.';
$string['sessionnouser'] = 'Nenhum utilizador presente nesta sessão';
$string['sessions'] = 'sessões';
$string['sessionsettings'] = 'Agendar sessões';
$string['sessionsschedule'] = 'Agendamento das sessões';
$string['showAttendeeRecordingStatus'] = 'Visibilidade do estado da gravação para o aluno';
$string['showAttendeeRecordingStatus_help'] = 'Se ativar esta opção, permite a visibilidade do estado da gravação para o aluno, ou seja, saberá a cada instante se a sessão está a ser gravada, ou não, no ecrã Congrea dos alunos';
$string['silencedetect'] = 'Detetar silêncio';
$string['srecordingsection'] = 'Permissões do aluno na gravação';
$string['srecordingsection_help'] = '<b>Configurações do aluno</b> - Estas configurações afetarão os direitos de gravação dos alunos.';
$string['studentaudio'] = 'Áudio do aluno';
$string['studentaudio_help'] = 'Se ativar esta opção, permite que os alunos contribuam com áudio durante a sessão.';
$string['studentgc'] = 'Chat de grupo';
$string['studentgc_help'] = 'Se ativar esta opção, permite que os alunos participem em chat de grupo/conversações durante a sessão.';
$string['studentm'] = 'Gestão da funcionalidade';
$string['studentm_help'] = 'Gestão da funcionalidade';
$string['studentpc'] = 'Chat privado';
$string['studentpc_help'] = 'Se ativar esta opção, permite que os alunos tenham um chat privado, ou seja, uma conversa particular com outro participante durante a sessão.';
$string['studentvideo'] = 'Vídeo do aluno';
$string['studentvideo_help'] = 'Se ativar esta opção, permite que os alunos contribuam com vídeo durante a sessão.';
$string['submiterror'] = 'Erro:';
$string['supportupgrade'] = 'Para suporte e atualização do seu plano Congrea, visite a página <a href="https://www.congrea.com/" target= "_blank">www.congrea.com</a>';
$string['teacher'] = 'Apresentador';
$string['terms'] = 'Eu aceito os <a href=\'https://www.congrea.com/documents-for-foreign-customers/#5e88631ac6b7c-1\' target=\'_blank\'>termos do serviço</a>.';
$string['terms_help'] = 'Leia os termos do serviço e assinale a caixa de verificação.';
$string['testingbrowser'] = 'A testar compatibilidade do explorador';
$string['testinginternetspeed'] = 'A testar velocidade ligação Internet';
$string['testingmichrophone'] = 'A testar microfone';
$string['testingspeaker'] = 'A testar altifalante';
$string['testingwebcam'] = 'A testar a ligação da webcam';
$string['time'] = 'Hora:';
$string['timeclashed'] = 'Algumas sessões existentes estão em conflito com o agendamento atual. Resolva e tente novamente! <br>';
$string['timecreated'] = 'Hora de criação';
$string['timedur'] = 'Duração da sessão';
$string['timeduration'] = 'Duração em minutos';
$string['timeduration_help'] = 'Para criar uma sessão aberta sem duração, insira 0, caso contrário, insira uma duração.';
$string['timetaken'] = 'Hora';
$string['to'] = ' até ';
$string['todaynosession'] = 'Hoje não existe. Consulte abaixo as próximas sessões';
$string['tosessiondate'] = 'Hora de fim da sessão';
$string['tosessiondate_help'] = 'Selecione a hora de término da sessão que não deve exceder uma duração total de 10 horas.';
$string['totalconflicts'] = 'Total de conflitos =';
$string['totalprogress'] = 'Progresso total';
$string['tpAudioTest'] = 'Testar áudio';
$string['trecordingsection'] = 'Permissões do apresentador na gravação';
$string['trecordingsection_help'] = '<b>Configurações do apresentador</b> - Estas configurações afetarão os direitos de gravação do apresentador.';
$string['trimRecordings'] = 'Recortar gravação';
$string['trimRecordings_help'] = 'Se ativar esta opção, permite que a gravação da sessão seja interrompida/ajustada sempre que o A/V for desativado, ou seja, sempre que o apresentador interromper a gravação A/V durante a sessão, essa duração específica não será gravada ou cortada da gravação da sessão.';
$string['unsupportedfiletype'] = 'Tipo de ficheiro inválido. Apenas são suportadas as gravações de sessões Congrea {.vcp}.';
$string['upcomingsession'] = 'Próximas sessões';
$string['updated'] = 'Guardado com sucesso.';
$string['uploadedsession'] = 'A sessão terminou. Pode fechar a janela. <br /> Ou feche esta janela pop-up para iniciar uma nova sessão.';
$string['uploadedsessionOk'] = 'Clique em \'OK\' para iniciar uma nova sessão';
$string['uploadrecordedfile'] = 'Carregar ficheiro de gravação';
$string['uploadsession'] = 'Por favor, aguarde até concluir o processamento.';
$string['userlist'] = 'Visibilidade da lista de utilizadores';
$string['userlist_help'] = 'Se ativar esta opção, permite que os alunos visualizem a lista de participantes durante uma sessão.';
$string['username'] = 'Nome de utilizador';
$string['users'] = 'Utilizadores';
$string['usersactivity'] = 'Atividade do utilizador (eventos por utilizador)';
$string['video'] = 'Vídeo';
$string['video_help'] = 'Se ativar esta opção, por predefinição, o vídeo de todos os alunos estará ativado.';
$string['videoquality'] = 'Qualidade do vídeo';
$string['viewreport'] = 'Relatório das presenças';
$string['waitmsgconnect'] = 'Por favor, espere um pouco. A aplicação está a tentar ligar-se.';
$string['weeksevery'] = '&nbsp;semanas a cada&nbsp;';
$string['wheretoruncongrea'] = 'De onde se pode servir a App Congrea';
$string['withoutrecording'] = 'sem gravação';
$string['withrecording'] = 'com gravação';
$string['wrongkey'] = 'A chave da API Congrea está errada. Aceda às <a href="{$a}">configurações do Congrea</a> para corrigir a chave.';
