<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'pt', version '3.8'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['addtocalendar'] = 'Adicionar ao calendário';
$string['allmeetings'] = 'Todas as reuniões';
$string['alternative_hosts'] = 'Anfitriões alternativos';
$string['apikey'] = 'Chave da API do Zoom';
$string['apisecret'] = 'Chave secreta da API do Zoom';
$string['apiurl'] = 'Url da API do Zoom';
$string['audio_both'] = 'VoIP e Telefone';
$string['audio_telephony'] = 'Apenas telefone';
$string['audio_voip'] = 'Apenas VoIP';
$string['cachedef_sessions'] = 'Informações do Zoom para obter solicitação de relatório do utilizador';
$string['cachedef_zoomid'] = 'O ID do utilizador do Zoom';
$string['calendardescriptionURL'] = 'URL de acesso à reunião: {$a}.';
$string['calendardescriptionintro'] = '\\nDescrição:\\n{\\$a}';
$string['calendariconalt'] = 'Ícone do calendário';
$string['clickjoin'] = 'Clicou no botão de aceder à reunião';
$string['connectionfailed'] = 'Erro na ligação:';
$string['connectionok'] = 'Ligação em funcionamento.';
$string['connectionstatus'] = 'Estado da ligação';
$string['defaultsettings'] = 'Configurações predefinidas do Zoom';
$string['defaultsettings_help'] = 'Estas configurações definem os valores predefinidos para todas as novas reuniões e webinars Zoom.';
$string['downloadical'] = 'Descarregar iCal';
$string['duration'] = 'Duração (minutos)';
$string['endtime'] = 'Hora de fim';
$string['err_duration_nonpositive'] = 'A duração deve ser um valor positivo.';
$string['err_duration_too_long'] = 'A duração não pode exceder as 150 horas.';
$string['err_invalid_password'] = 'A senha contém caracteres inválidos.';
$string['err_long_timeframe'] = 'Período de tempo solicitado muito longo. A mostrar os resultados do último mês no intervalo.';
$string['err_password'] = 'A senha apenas pode conter os seguintes caracteres: [a-z A-Z 0-9 @ - _ *]. Máximo de 10 caracteres.';
$string['err_password_required'] = 'A senha é obrigatória mas o campo da senha está vazio.';
$string['err_start_time_past'] = 'A data de início não pode ser no passado';
$string['errorwebservice'] = 'Erro no web service Zoom: {$a}';
$string['errorwebservice_notfound'] = 'O recurso não existe: {$a}';
$string['export'] = 'Exportar';
$string['firstjoin'] = 'Acesso antecipado';
$string['firstjoin_desc'] = 'O mais cedo que um utilizador pode aceder a uma reunião agendada (minutos antes do início).';
$string['getmeetingreports'] = 'Obter relatório da reunião do Zoom';
$string['invalid_status'] = 'Estado inválido. Verifique a base de dados.';
$string['join'] = 'Aceder';
$string['join_meeting'] = 'Aceder à reunião';
$string['joinbeforehost'] = 'Aceder à reunião antes do anfitrião';
$string['jointime'] = 'Hora de acesso';
$string['leavetime'] = 'Hora de saída';
$string['licensesnumber'] = 'Número de licenças';
$string['lowlicenses'] = 'Se o número das suas licenças exceder as necessárias, quando criar cada nova atividade por um utilizador, será atribuída uma licença PRO à atividade reduzindo o estado do outro utilizador. A opção é efetiva quando o número de licenças PRO ativas é superior a 5.';
$string['maskparticipantdata'] = 'Camuflar dados do participante';
$string['maskparticipantdata_help'] = 'Impede que os dados dos participantes apareçam nos relatórios (útil para sites que mascaram os dados dos participantes, por exemplo, para HIPAA).';
$string['meeting_finished'] = 'Terminada';
$string['meeting_nonexistent_on_zoom'] = 'Não existe no Zoom';
$string['meeting_not_started'] = 'Não iniciada';
$string['meeting_started'] = 'A decorrer';
$string['meeting_time'] = 'Hora de início';
$string['modulename'] = 'Reunião Zoom';
$string['modulename_help'] = 'O Zoom é uma plataforma de videoconferência que oferece aos utilizadores autorizados a capacidade de realizar reuniões online.';
$string['modulenameplural'] = 'Reuniões Zoom';
$string['newmeetings'] = 'Novas reuniões';
$string['nomeetinginstances'] = 'Nenhuma sessão encontrada para esta reunião.';
$string['noparticipants'] = 'De momento, não foi encontrado qualquer participante para esta sessão.';
$string['nosessions'] = 'Nenhuma sessão encontrada para o intervalo especificado.';
$string['nozooms'] = 'Sem reuniões';
$string['off'] = 'Off';
$string['oldmeetings'] = 'Reuniões concluídas';
$string['on'] = 'On';
$string['option_audio'] = 'Opções do áudio';
$string['option_authenticated_users'] = 'Apenas utilizadores autenticados';
$string['option_host_video'] = 'Vídeo do anfitrião';
$string['option_jbh'] = 'Permitir aceder antes do anfitrião';
$string['option_mute_upon_entry'] = 'Silenciar na entrada';
$string['option_mute_upon_entry_help'] = 'Silenciar automaticamente todos os participantes quando eles ingressam na reunião. O servidor controla se os participantes podem ativar o som.';
$string['option_participants_video'] = 'Vídeo dos participantes';
$string['option_proxyhost'] = 'Usar proxy';
$string['option_proxyhost_desc'] = 'O proxy definido aqui como \'<code><hostname>:<port></code>\' é usado apenas para comunicação com o Zoom. Deixe em branco para usar as configurações de proxy predefinidas do Moodle. Só precisa de definir se não pretender definir um proxy global no Moodle.';
$string['option_waiting_room'] = 'Ativar sala de espera';
$string['participantdatanotavailable'] = 'Detalhes não disponíveis';
$string['participantdatanotavailable_help'] = 'Os dados do participante não estão disponíveis para esta sessão de Zoom (por exemplo, devido à conformidade com HIPAA).';
$string['participants'] = 'Participantes';
$string['password'] = 'Senha';
$string['passwordprotected'] = 'Protegido por senha';
$string['pluginadministration'] = 'Gerir reunião Zoom';
$string['pluginname'] = 'Reunião Zoom';
$string['recurringmeeting'] = 'Recorrente';
$string['recurringmeeting_help'] = 'Sem data de fim';
$string['recurringmeetinglong'] = 'Reunião recorrente (reunião sem data ou hora de fim)';
$string['redefinelicenses'] = 'Redefinir licenças';
$string['report'] = 'Relatórios';
$string['reportapicalls'] = 'Reportar chamadas da API esgotadas';
$string['resetapicalls'] = 'Redefinir o número de chamadas disponíveis da API';
$string['search:activity'] = 'Reunião Zoom - informações da atividade';
$string['sessions'] = 'Sessões';
$string['start'] = 'Iniciar';
$string['start_meeting'] = 'Iniciar reunião';
$string['start_time'] = 'Início';
$string['starthostjoins'] = 'Iniciar vídeo quando o anfitrião acede';
$string['startpartjoins'] = 'Iniciar vídeo quando o participante acede';
$string['starttime'] = 'Hora de início';
$string['status'] = 'Estado';
$string['title'] = 'Título';
$string['topic'] = 'Tópico';
$string['unavailable'] = 'De momento não é possível aceder';
$string['updatemeetings'] = 'Atualizar as configurações da reunião a partir do Zoom';
$string['usepersonalmeeting'] = 'Use o ID pessoal da reunião {$a}';
$string['waitingroom'] = 'Sala de espera ativada';
$string['webinar'] = 'Webinar';
$string['webinar_already_false'] = '<p><b>Este módulo já foi definido como uma reunião. Não pode alternar esta configuração para webinar depois de criar a reunião.</b></p>';
$string['webinar_already_true'] = '<p><b>Este módulo já foi definido como um webinar. Não pode alternar esta configuração para reunião depois de criar o webinar.</b></p>';
$string['webinar_help'] = 'Esta opção só está disponível para contas Zoom pré-autorizadas.';
$string['zoom:addinstance'] = 'Adicionar nova reunião Zoom';
$string['zoom:view'] = 'Ver reuniões Zoom';
$string['zoomerr'] = 'Ocorreu um erro com o Zoom.';
$string['zoomerr_apikey_missing'] = 'Chave da API do Zoom não encontrada';
$string['zoomerr_apisecret_missing'] = 'Chave secreta da API do Zoom não encontrada';
$string['zoomerr_id_missing'] = 'Tem de especificar um ID do course_module ou um ID da instância';
$string['zoomerr_maxretries'] = 'Foram repetidas {$a->maxretries} vezes as tentativas para estabelecer a ligação, mas não foi possível: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Não foi possível encontrar esta reunião no Zoom. Pode <a href="{$a->recreate}">recriar a reunião</a> ou <a href="{$a->delete}">apagar a reunião</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Não foi possível encontrar esta reunião no Zoom. Se tiver alguma dúvida, entre em contacto com o organizador da reunião';
$string['zoomerr_usernotfound'] = 'Não foi possível encontrar a sua conta no Zoom. Se estiver a usar o Zoom pela primeira vez, deverá usar a conta do Zoom acedendo à página <a href="{$a}" target="_blank">{$a}</a>. Depois de ativar a sua conta do Zoom, recarregue esta página e continue a configurar a sua reunião. Caso contrário, verifique se o seu e-mail no Zoom corresponde ao seu e-mail neste sistema.';
$string['zoomurl'] = 'URL da página inicial do Zoom';
