<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'cs', version '3.8'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Probíhá odstraňování aktivit ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" není platná hodnota pro věk.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" má více či méně než jeden oddělovač.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$ a}" není pro zemi platná hodnota.';
$string['agedigitalconsentmapinvaliddefault'] = 'Chybí výchozí hodnota (*) .';
$string['agelocationverificationdisabled'] = 'Ověření věku a polohy je zakázáno';
$string['alreadyloggedin'] = 'Již jste přihlášeni jako {$a}. Musíte se nejprve odhlásit a teprve poté se můžete přihlásit jako jiný uživatel.';
$string['authnotexisting'] = 'Autorizační modul neexistuje';
$string['backupcontainexternal'] = 'Tento záložní soubor obsahuje informace o hostitelích MNet, kteři nejsou na našem serveru nastaveni.';
$string['backuptablefail'] = 'NELZE nastavit záložní tabulky!';
$string['blockcannotconfig'] = 'Tento blok nepodporuje globální konfiguraci';
$string['blockcannotinistantiate'] = 'Problém při vytváření objektu bloku';
$string['blockcannotread'] = 'Nemohu číst data pro blockid = {$a}';
$string['blockdoesnotexist'] = 'Takový blok neexistuje';
$string['blockdoesnotexistonpage'] = 'Takový block (id {$a->instanceid}) na této stránce neexistuje ({$a->url}).';
$string['blocknameconflict'] = 'Kolize názvů: blok {$a->name} má stejný název jako již existující blok: {$a->conflict}';
$string['callbackrejectcomment'] = 'Modul odmítl přidat tento komentář';
$string['cannotaddcoursemodule'] = 'Nelze přidat nový modul do kurzu';
$string['cannotaddcoursemoduletosection'] = 'Nelze přidat nový modul do této sekce';
$string['cannotaddmodule'] = 'Modul {$a} nelze přidat do seznamu modulů!';
$string['cannotaddnewmodule'] = 'Nelze přidat nový modul z {$a}';
$string['cannotaddrss'] = 'Nemáte oprávnění přidávat RSS vlákna';
$string['cannotaddthisblocktype'] = 'Nemůžete přidat {$a} blok na tuto stránku.';
$string['cannotassignrole'] = 'Nelze přiřadit role v kurzu';
$string['cannotassignrolehere'] = 'Nemůžete přidělit tuto roli (id = {$a->roleid}) v tomto kontextu ({$a->context})';
$string['cannotassignselfasparent'] = 'Sebe nemůžete přiřadit jako rodiče!';
$string['cannotcallscript'] = 'Tento skript nelze spouštět takovýmto způsobem';
$string['cannotcallusgetselecteduser'] = 'Nelze volat metodu user_selector::get_selected_user() při výběru vícero uživatelů.';
$string['cannotcreatebackupdir'] = 'Není možné vytvořit adresář backupdata. Správce musí opravit přístupová práva.';
$string['cannotcreatecategory'] = 'Kategorie nebyla vložena';
$string['cannotcreatedboninstall'] = '<p>Nelze vytvořit databázi.</p>
<p>Určená databáze neexistuje a uživatel nemá oprávnění k vytvoření databáze.</p>
<p>Správce stránek by měl ověřit konfiguraci databáze.</p>';
$string['cannotcreategroup'] = 'Chyba vytvoření skupiny';
$string['cannotcreatelangbase'] = 'Chyba: Nemohu vytvořit základní adresář s jazykem';
$string['cannotcreatelangdir'] = 'Nelze vytvořit adresář pro jazykové soubory';
$string['cannotcreateorfindstructs'] = 'Chyba při načítání nebo vytváření struktury oddílů v tomto kurzu';
$string['cannotcreatepopupwin'] = 'Nedefinovaný element - nemohu spustit vyskakovací okno';
$string['cannotcreatesitedir'] = 'Nemohu vytvořit adresář stránek. Správce stránek musí změnit oprávnění k souborům.';
$string['cannotcreatetempdir'] = 'Nelze vytvořit dočasný adresář';
$string['cannotcreateuploaddir'] = 'Nemohu vytvořit adresář pro nahrávání. Správce stránek musí změnit oprávnění k souborům.';
$string['cannotcustomisefiltersblockuser'] = 'Nelze upravovat nastavení filtrů v kontextu uživatele nebo bloků.';
$string['cannotdeletebackupids'] = 'Nemohu smazat předchozí id záloh';
$string['cannotdeletecategorycourse'] = 'Chyba při pokusu odstranit kurz "{$a}".';
$string['cannotdeletecategoryquestions'] = 'Není možné odstranit úlohy z kategorie "{$a}".';
$string['cannotdeletecourse'] = 'Nemáte oprávnění potřebná k odstranění tohoto kurzu';
$string['cannotdeletecustomfield'] = 'Chyba při odstraňování dat z uživatelských polí profilu';
$string['cannotdeletedir'] = 'Nelze smazat ({$a})';
$string['cannotdeletefile'] = 'Nelze smazat tento soubor';
$string['cannotdeleterole'] = 'Nemůže být odstraněna, protože {$a}';
$string['cannotdeleterolewithid'] = 'Nelze odstranit roli s identifikátorem {$a}';
$string['cannotdeletethisrole'] = 'Nelze odstranit tuto roli - buď je používána systémem nebo se jedná o poslední roli poskytující oprávnění správce.';
$string['cannotdisableformat'] = 'Nemůžete zakázat výchozí uspořádání';
$string['cannotdownloadcomponents'] = 'Nelze stáhnout komponenty';
$string['cannotdownloadlanguageupdatelist'] = 'Nelze stáhnout seznam aktualizací jazykových balíčků ze serveru download.moodle.org';
$string['cannotdownloadzipfile'] = 'Nelze stáhnout soubor ZIP';
$string['cannoteditcomment'] = 'Tento komentář není váš, nemůžete jej upravovat!';
$string['cannoteditcommentexpired'] = 'Toto nesmíte upravovat. Čas vypršel!';
$string['cannoteditpostorblog'] = 'Nesmíte posílat nebo upravovat blogy';
$string['cannoteditsiteform'] = 'Nelze upravovat záznam kurzu na titulní stránce pomocí tohoto formuláře';
$string['cannotedituserpreferences'] = 'Předvolby tohoto uživatele nelze upravovat';
$string['cannotedityourprofile'] = 'Je nám líto, ale nemůžete upravovat vlastní profil';
$string['cannotexecduringupgrade'] = 'Nelze spustit během aktualizace';
$string['cannotfindcategory'] = 'V databázi nelze najít záznam kategorie podle jeho ID {$a}';
$string['cannotfindcomponent'] = 'Komponenta nenalezena';
$string['cannotfindcontext'] = 'Nemohu najít kontext';
$string['cannotfindcourse'] = 'Kurz nenalezen';
$string['cannotfinddocs'] = 'Nemohu najít soubory dokumentace jazyka "{$a}"';
$string['cannotfindgradeitem'] = 'Nelze najít položku hodnocení';
$string['cannotfindgroup'] = 'Nebylo možné najít skupinu';
$string['cannotfindhelp'] = 'Nelze najít soubory nápovědy v jazyce "{$a}"';
$string['cannotfindinfo'] = 'Nemohu najít info pro: "{$a}"';
$string['cannotfindlang'] = 'Nelze nalézt jazykový balíček "{$a}"!';
$string['cannotfindteacher'] = 'Učitel nenalezen';
$string['cannotfinduser'] = 'Uživatel "{$a}" nenalezen';
$string['cannotgeoplugin'] = 'Nelze se připojit k serveru geoPlugin na https://www.geoplugin.com. Zkontrolujte nastavení proxy, nebo ještě lépe nainstaluje datový soubor MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Nemohu získat bloky z databáze';
$string['cannotgetcats'] = 'Nemohu získat kategorii';
$string['cannotgetdata'] = 'Nemohu získat data';
$string['cannotgradeuser'] = 'Nelze známkovat tohoto uživatele';
$string['cannothaveparentcate'] = 'Kořenová kategorie kurzu nemůže mít nadřazenou kategorii';
$string['cannotimport'] = 'Chyba importu';
$string['cannotimportformat'] = 'Je nám líto, ale import tohoto formátu ještě není implementován!';
$string['cannotimportgrade'] = 'Chyba při importu známek';
$string['cannotinsertgrade'] = 'Nelze vložit položku hodnocení bez identifikátoru kurzu!';
$string['cannotinsertrate'] = 'Nelze vložit nové hodnocení  ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nelze vložit (insert) další záznam s ID {$a}';
$string['cannotmailconfirm'] = 'Chyba při odesílání e-mailu s potvrzením změny hesla';
$string['cannotmanualctrack'] = 'Činnost nepodporuje ruční sledování plnění';
$string['cannotmapfield'] = 'Kolize mapování - dvě pole jsou namapovány na stejnou položku hodnocení {$a}';
$string['cannotmarktopic'] = 'Nemohu označit toto téma v tomto kurzu';
$string['cannotmigratedatacomments'] = 'Nemohu přesunout komentáře datového modulu';
$string['cannotmodulename'] = 'Nemohu získat jméno modulu ve vestavěné navigaci';
$string['cannotmoduletype'] = 'Nemohu získat typ modulu ve vestavěné navigaci';
$string['cannotmovecategory'] = 'Kategorii nelze přesunout';
$string['cannotmovecourses'] = 'Kurzy nelze přesunout z kategorie do jiné.';
$string['cannotmoverolewithid'] = 'Nelze přesunout roli s ID {$a}';
$string['cannotopencsv'] = 'Nelze otevřít soubor CSV ';
$string['cannotopenfile'] = 'Nelze otevřít soubor ({$a})';
$string['cannotopenforwrit'] = 'Nelze otevřít pro zápis: {$a}';
$string['cannotopentemplate'] = 'Nelze otevřít soubor šablony ({$a})';
$string['cannotopenzip'] = 'Nelze otevřít ZIP soubor, pravděpodobně díky chybě formátu ZIP na 64bitových operačních systémech';
$string['cannotoverridebaserole'] = 'Nelze přepsat základní nastavení role';
$string['cannotoverriderolehere'] = 'Nemůžete přepsat roli (id = {$a->roleid}) v kontextu ({$a->context})';
$string['cannotreadfile'] = 'Nelze načíst soubor ({$a})';
$string['cannotreadtmpfile'] = 'Chyba načítání dočasného souboru';
$string['cannotreaduploadfile'] = 'Nebylo možné načíst nahraný soubor';
$string['cannotremovefrommeta'] = 'Nelze odstranit vybraný kurz z tohoto metakurzu!';
$string['cannotreprocessgrades'] = 'Nepodařilo se zpracovat známky pro tuto činnost {$a}';
$string['cannotresetguestpwd'] = 'Nemůžete resetovat heslo uživatele "guest"';
$string['cannotresetmail'] = 'Chyba při resetování hesla a jeho odeslání poštou';
$string['cannotresetthisrole'] = 'Tuto roli nelze obnovit';
$string['cannotrestore'] = 'Došlo k chybě a obnova nemohla být dokončena!';
$string['cannotrestoreadminorcreator'] = 'Pro obnovení kurzu musíte být tvůrce kurzů nebo administrátor!';
$string['cannotrestoreadminoredit'] = 'Pro obnovení vybraného kurzu musíte být učitel nebo administrátor!';
$string['cannotsaveagreement'] = 'Nepodařilo se uložit váš souhlas';
$string['cannotsaveblock'] = 'Chyba ukládání konfigurace bloků';
$string['cannotsavecomment'] = 'Nelze uložit komentář';
$string['cannotsavedata'] = 'Nelze uložit data';
$string['cannotsavefile'] = 'Nelze uložit soubor "{$a}"!';
$string['cannotsavemd5file'] = 'Nelze uložit soubor MD5';
$string['cannotsavezipfile'] = 'Nelze uložit soubor ZIP';
$string['cannotservefile'] = 'Nelze poskytnout soubor - problém v konfiguraci serveru';
$string['cannotsetparentforcatoritem'] = 'Položky hodnocení svázané s kategorií nebo s kurzem nemohou mít nastavenu nadřazenou kategorii.';
$string['cannotsetpassword'] = 'Nelze nastavit uživatelské heslo!';
$string['cannotsetprefgrade'] = 'V této kategorii hodnocení nemohu nastavit volbu aggregationview na {$a}';
$string['cannotsettheme'] = 'Nelze nastavit motiv!';
$string['cannotsetupblock'] = 'NEMOHU nastavit tabulky bloků!';
$string['cannotsetupcapformod'] = 'Nelze nastavit možnosti pro {$}';
$string['cannotsetupcapforplugin'] = 'Nelze nastavit možnosti pro {$}';
$string['cannotshowhidecoursesincategory'] = 'Nelze zobrazit/skrýt kurz v kategorii {$a}.';
$string['cannotsignup'] = 'Nemůžete vytvořit nový účet, protože jste již přihlášený jako {$a}.';
$string['cannotunassigncap'] = 'Nelze odebrat zastaralou pravomoc {$a->cap} roli {$a->role}';
$string['cannotunassignrolefrom'] = 'Nemohu odstranit roli tohoto uživatele, id role: {$a}';
$string['cannotunzipfile'] = 'Nelze dekomprimovat soubor';
$string['cannotupdatemod'] = 'Nelze aktualizovat {$a}';
$string['cannotupdatepasswordonextauth'] = 'Selhala aktualizace hesla v externím autentizačním systému: {$a}. Více informací najdete v protokolu serveru.';
$string['cannotupdateprofile'] = 'Chyba při aktualizaci záznamu uživatele';
$string['cannotupdaterecord'] = 'Nelze upravit (update) záznam s ID {$a}';
$string['cannotupdaterss'] = 'Nelze aktualizovat RSS';
$string['cannotupdatesubcourse'] = 'Nemohu aktualizovat dceřiný kurz!';
$string['cannotupdateusermsgpref'] = 'Nelze aktualizovat uživatelské předvolby zasílání zpráv';
$string['cannotupdateuseronexauth'] = 'Selhala aktualizace uživatelských údajů v externím autentizačním systému: {$a}. Více informací najdete v protokolu serveru.';
$string['cannotuploadfile'] = 'Chyba při zpracování nahraného souboru';
$string['cannotuseadmin'] = 'Pro zpracování této stránky musíte být administrátor';
$string['cannotuseadminadminorteacher'] = 'Pro zpracování této stránky musíte být učitel nebo administrátor';
$string['cannotusepage'] = 'Tuto stránku mohou používat pouze učitelé a administrátoři';
$string['cannotusepage2'] = 'Promiňte, ale nemůžete používat tuto stránku';
$string['cannotviewcategory'] = 'Nemáte oprávnění k zobrazení tohoto seznamu kurzů.';
$string['cannotviewprofile'] = 'Profil tohoto uživatele nemůžete zobrazit';
$string['cannotviewreport'] = 'Nelze zobrazit tento přehled';
$string['cannotwritefile'] = 'Nelze zapsat do souboru ({$a})';
$string['categoryerror'] = 'Chyba kategorie';
$string['categoryidnumbertaken'] = 'Identifikátor (ID) je již používán jinou kategorii';
$string['categorynamerequired'] = 'Je vyžadován název kategorie';
$string['categorytoolong'] = 'Název kategorie je příliš dlouhý';
$string['commentmisconf'] = 'ID komentáře je chybně nastaveno';
$string['componentisuptodate'] = 'Komponenta je aktuální';
$string['confirmationnotenabled'] = 'Na tomto webu není povoleno potvrzení uživatelů';
$string['confirmsesskeybad'] = 'Je mi líto, ale klíči vašeho sezení (session) nebylo povoleno vykonat tuto akci. Toto bezpečnostní opatření zabraňuje nahodilému nebo zákeřnému spouštění důležitých funkcí pod vaším jménem. Prosím, ujistěte se, že opravdu chcete spustit tuto funkci.';
$string['couldnotassignrole'] = 'V průběhu přiřazování vaši role se objevila vážná, ale blíže neurčená chyba.';
$string['couldnotupdatenoexistinguser'] = 'Nemohu aktualizovat uživatele - tento uživatel neexistuje';
$string['couldnotverifyagedigitalconsent'] = 'Při pokusu o ověření věku pro digitální souhlas došlo k chybě. <br /> Kontaktujte administrátora.';
$string['countriesphpempty'] = 'Chyba: v jazykovém balíčku {$a} chybí soubor countries.php (popř. je prázdný)';
$string['coursedoesnotbelongtocategory'] = 'Kurz nenáleží do této kategorie';
$string['courseformatnotfound'] = 'Formát kurzu "{$a}" neexistuje nebo nebyl rozpoznán.';
$string['coursegroupunknown'] = 'Nebyl určen kurz odpovídající skupině "{$a}"';
$string['courseidnotfound'] = 'Kurz ID neexistuje.';
$string['courseidnumbertaken'] = 'Identifikátor kurzu ID je již používán jiným kurzem ({$a})';
$string['coursemisconf'] = 'Kurz je špatně nastaven';
$string['courserequestdisabled'] = 'Bohužel, podávání žádostí o vytvoření kurzů byly administrátorem deaktivovány.';
$string['csvcolumnduplicates'] = 'Byly zjištěny duplicity sloupců';
$string['csvemptyfile'] = 'Prázdný soubor CSV';
$string['csvfewcolumns'] = 'Nedostatečný počet sloupců, zkontrolujte nastavení oddělovače';
$string['csvfileerror'] = 'S formátem souboru CSV není něco v pořádku. Zkontrolujte počet záhlaví a shodu sloupců, správnost oddělovače a kódování souborů: {$a}';
$string['csvinvalidcols'] = '<b>Neplatný formát CSV souboru:</b>První řádek musí obsahovat "Header Fields" a soubor musí být typu<br />"Expanded Fields/Comma Separated"<br />nebo<br />"Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Neplatný soubor CSV - každý řádek musí obsahovat 49 nebo 70 polí';
$string['csvloaderror'] = 'Došlo k chybě při načítání CSV souboru: {$a}';
$string['csvnodata'] = 'Neplatný soubor CSV - soubor CSV má záhlaví, ale neobsahuje žádná data.';
$string['csvweirdcolumns'] = 'Chyba v CSV formátu - počet sloupců není konstantní';
$string['dbconnectionfailed'] = '<p>Chyba: Nelze se připojit k databázi</p>
<p>Je možné, že databázový server je přetížen nebo má jiné problémy.</p>
<p>Správce stránek by měl zkontrolovat správnost údajů pro připojení k databázi v souboru config.php</p>';
$string['dbdriverproblem'] = '<p>Chyba: Databázový ovladač má problém</p>
<p>Správce stránek by měl zkontrolovat nastavení serveru</p>
<p>{$a}</p>';
$string['dbsessionbroken'] = 'Byl detekován vážný problém databáze.<br /><br />Prosím upozorněte správce systému.';
$string['dbsessionhandlerproblem'] = 'Selhalo nastavení databázové session. Prosím, uvědomte správce serveru.';
$string['dbsessionmysqlpacketsize'] = 'Byla zjištěna závažná chyba obsluhy session.<br /><br />Prosím, uvědomte správce serveru. Problém je s největší pravděpodobností způsobeno malou hodnotu v nastavení max_allowed_packet MySQL.';
$string['dbupdatefailed'] = 'Aktualizace databáze selhala';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" - nelze změnit. Existuje závislost: {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Chyba při vykonávání DDL SQL';
$string['ddlfieldalreadyexists'] = 'Pole "{$a}" již existuje';
$string['ddlfieldnotexist'] = 'Pole "{$a->fieldname}" neexistuje v tabulce "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabulka "{$a}" již existuje';
$string['ddltablenotexist'] = 'Tabulka "{$a}" neexistuje';
$string['ddlunknownerror'] = 'Neznámá chyba knihovny DDL';
$string['ddlxmlfileerror'] = 'Chyby v XML souboru s definicí databázové struktury';
$string['ddsequenceerror'] = 'Chyba v definici tabulky "{$a}". Tabulka může obsahovat pouze jeden sloupec s automatickým číslováním a ten musí být zároveň klíčem.';
$string['destinationcmnotexit'] = 'Cílový slot pro modul v kurzu neexistuje';
$string['detectedbrokenplugin'] = 'Modul "{$a}" je chybný nebo zastaralý, není možné pokračovat.';
$string['dmlexceptiononinstall'] = '<p>Došlo k chybě databáze [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Chyba při analýze dotazu SQL';
$string['dmlreadexception'] = 'Chyba čtení z databáze';
$string['dmltransactionexception'] = 'Chyba databázové transakce';
$string['dmlwriteexception'] = 'Chyba zápisu do databáze';
$string['downgradedcore'] = 'Chyba: Zdrojové kódy mají nižší verzi než má databáze.';
$string['downloadedfilecheckfailed'] = 'Selhala kontrola staženého souboru';
$string['duplicatefieldname'] = 'Chyba: Duplicitní název pole "{$a}"';
$string['duplicatenosupport'] = 'Činnost "{$a->modname}" nelze duplikovat, protože modul {$a->modtype} nepodporuje zálohování a obnovení.';
$string['duplicateparaminsql'] = 'Chyba: Duplicitní název parametru v SQL dotazu';
$string['duplicaterolename'] = 'Role s tímto jménem již existuje!';
$string['duplicateroleshortname'] = 'Role s tímto krátkým jménem již existuje!';
$string['duplicateusername'] = 'Duplicitní uživatelské jméno - přeskakuji záznam';
$string['emailfail'] = 'Chyba odesílání pošty';
$string['enddatebeforestartdate'] = 'Datum ukončení kurzu musí být po datu zahájení.';
$string['error'] = 'Vyskytla se chyba';
$string['error_question_answers_missing_in_db'] = 'Nepodařilo se najít shodu odpověď "{$a->answer}" v tabulce question_answers databáze. K tomu došlo při obnovování úlohy s id {$a->filequestionid} ze záložního souboru, které bylo shodné k existující úloze s id {$a->dbquestionid} v databázi.';
$string['errorcleaningdirectory'] = 'Chyba při čištění adresáře "{$a}"';
$string['errorcopyingfiles'] = 'Chyba při kopírování souborů';
$string['errorcreatingdirectory'] = 'Chyba při vytváření adresáře "{$a}"';
$string['errorcreatingfile'] = 'Chyba při vytváření souboru "{$a}"';
$string['errorcreatingrole'] = 'Chyba vytvoření role';
$string['errorfetchingrssfeed'] = 'Chyba při čtení RSS';
$string['erroronline'] = 'Chyba na řádku {$a}';
$string['erroroutput'] = 'Chyba výstupu, deaktivováno automatického přesměrování.';
$string['errorparsingxml'] = 'Chyba parsování XML: {$a->errorstring} na řádku {$a->errorline}, znak {$a->errorchar}';
$string['errorprocessingarchive'] = 'Chyba při zpracovávání archivního souboru';
$string['errorreadingfile'] = 'Chyba při čtení souboru "{$a}"';
$string['errorsavingrequest'] = 'Při pokusu o uložení vašeho požadavku došlo k chybě.';
$string['errorsettinguserpref'] = 'Chyba při nastavování uživatelské předvolby';
$string['errorunzippingfiles'] = 'Chyba při rozbalování souborů ZIP';
$string['expiredkey'] = 'Vypršela platnost klíče';
$string['externalauthpassworderror'] = 'Neprázdné heslo pro externí autentizaci';
$string['externalfilenolocation'] = 'Externí soubor nemá žádné umístění';
$string['failtoloadblocks'] = 'Nepodařilo se načíst jeden nebo více bloků registrovaných v databázi!';
$string['fieldrequired'] = '"{$a}" je povinné pole';
$string['fileexists'] = 'Soubor existuje';
$string['filemismatch'] = 'Jméno souboru neodpovídá. Soubor "{$a->current}" by měl být {$a->file}';
$string['filenotfound'] = 'Je mi líto, požadovaný soubor nebyl nalezen';
$string['filenotreadable'] = 'Soubor není čitelný';
$string['filterdoesnothavelocalconfig'] = 'Filtr {$a} nedovoluje lokální konfiguraci';
$string['filternotactive'] = 'Filtr {$a} není aktivní';
$string['filternotenabled'] = 'Filtr není povolen!';
$string['filternotinstalled'] = 'Filtr {$a} není momentálně nainstalován';
$string['forumblockingtoomanyposts'] = 'Překročili jste limit vložených příspěvků pro toto fórum';
$string['functionalityremoved'] = 'Pokoušíte se o přístup k funkcím, které byly odebrány.';
$string['generalexceptionmessage'] = 'Výjimka - {$a}';
$string['gradecantregrade'] = 'Při výpočtu známky došlo k chybě: {$a}';
$string['gradepubdisable'] = 'Zveřejňování známek není povoleno';
$string['gradesneedregrading'] = 'Známky kurzů musí být přepočítány';
$string['groupalready'] = 'Uživatel už je členem skupiny {$a}';
$string['groupexistforcourse'] = 'Skupina "{$a}" již v tomto kurzu existuje';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Skupina "{$a->name}" s identifikátorem "{$a->idnumber}" již v tomto kurzu existuje';
$string['grouphasidnumber'] = 'Skupina "{$a}" má nastaven identifikátor a mohla být automaticky vytvořena externím systémem. Nemáte oprávnění odstranit tuto skupinu.';
$string['groupinghasidnumber'] = 'Seskupení "{$a}" má nastaven identifikátor a mohlo být automaticky vytvořeno externím systémem. Nemáte oprávnění odstranit toto seskupení.';
$string['groupingnotaddederror'] = 'Seskupení "{$a}" nebylo přidáno';
$string['groupnotaddederror'] = 'Skupina "{$a}" nebyla přidána';
$string['groupnotaddedtogroupingerror'] = 'Skupina  "{$a->groupname}" nebyla přidána do seskupení "{$a->groupingname}"';
$string['groupunknown'] = 'Skupina {$a} nebyla přidružena k určenému kurzu';
$string['groupusernotmember'] = 'Uživatel není členem této skupiny';
$string['guestcantaccessprofiles'] = 'Hosté nemají přístup do profilů uživatele. Přihlaste se uživatelským účtem a pokračujte.';
$string['guestnocomment'] = 'Návštěvníci stránek nemohou odesílat komentáře!';
$string['guestnoeditprofile'] = 'Uživatel "host" nemůže upravovat svůj profil';
$string['guestnoeditprofileother'] = 'Profil uživatele "host" nelze upravovat';
$string['guestnorate'] = 'Návštěvníci stránek nemohou hodnotit položky';
$string['guestsarenotallowed'] = 'Toto není dovoleno hostům';
$string['hackdetected'] = 'Byl detekován pokus o průlom do systému!';
$string['hashpoolproblem'] = 'Neplatný obsah v úložišti souborů {$a}';
$string['headersent'] = 'HTTP hlavičky již byly odeslány';
$string['idnumbertaken'] = 'Tento identifikátor je již používán';
$string['idnumbertoolong'] = 'Číslo ID je příliš dlouhé';
$string['importformatnotimplement'] = 'Promiňte, import tohoto formátu není doposud implementován!';
$string['incorrectext'] = 'Soubor má nesprávnou příponu';
$string['inplaceeditableerror'] = 'Chyba při volání aktualizace procesoru';
$string['installproblem'] = 'Většinou není možné zotavit se z chyb, které se objeví při instalaci. Zřejmě budete muset založit novou databázi nebo použít jinou předponu názvů tabulek a instalaci opakovat.';
$string['internalauthpassworderror'] = 'Chybí heslo nebo jsou nastaveny neplatné zásady bezpečného hesla pro interní autentizaci.';
$string['invalidaccess'] = 'Neplatný přístup k této stránce';
$string['invalidaccessparameter'] = 'Chybný parametr přístupu';
$string['invalidaction'] = 'Chybný parametr akce';
$string['invalidactivityid'] = 'Neplatný identifikátor činnosti';
$string['invalidadminsettingname'] = 'Neplatné nastavení ({$a})';
$string['invalidargorconf'] = 'Chybějící argument nebo nesprávné nastavení serveru';
$string['invalidarguments'] = 'Chybějící argument';
$string['invalidblockinstance'] = 'Neplatná instance bloku: {$a}';
$string['invalidbulkenrolop'] = 'Požadována neplatná hromadná operace se zápisy';
$string['invalidcategory'] = 'Nesprávná kategorie!';
$string['invalidcategoryid'] = 'Neplatné ID kategorie!';
$string['invalidcomment'] = 'Komentář je nesprávný';
$string['invalidcommentarea'] = 'Neplatná oblast komentáře';
$string['invalidcommentid'] = 'Neplatné ID komentáře';
$string['invalidcommentitemid'] = 'Neplatné ID komentované položky';
$string['invalidcommentparam'] = 'Neplatné parametry komentáře';
$string['invalidcomponent'] = 'Neplatný název komponenty';
$string['invalidconfirmdata'] = 'Neplatné údaje v potvrzení';
$string['invalidcontext'] = 'Neplatný kontext';
$string['invalidcountrycode'] = 'Neplatný kód země: {$a}';
$string['invalidcourse'] = 'Neplatný kurz';
$string['invalidcourseformat'] = 'Neplatný formát kurzu';
$string['invalidcourseid'] = 'Pokoušíte se použít neplatný identifikátor kurzu';
$string['invalidcourselevel'] = 'Neplatná úroveň kontextu';
$string['invalidcoursemodule'] = 'Neplatný identifikátor modulu (course module ID)';
$string['invalidcoursenameshort'] = 'Neplatné krátké jméno kurzu';
$string['invaliddata'] = 'Vložené údaje jsou neplatné';
$string['invaliddatarootpermissions'] = 'Při pokusu o vytvoření adresáře bylo zjištěno neplatné oprávnění.Pro další podrobnosti zapněte ladění.';
$string['invaliddevicetype'] = 'Neplatný typ zařízení';
$string['invalidelementid'] = 'Neplatné ID prvku!';
$string['invalidentry'] = 'Toto není platná hodnota!';
$string['invalidevent'] = 'Neplatná událost';
$string['invalidfieldname'] = '"{$a}" není platný název pole';
$string['invalidfiletype'] = '"{$a}" není platný typ souboru';
$string['invalidformatpara'] = 'Nesprávný formát volby parametru';
$string['invalidformdata'] = 'Neplatná formulářová data';
$string['invalidfunction'] = 'Nesprávná funkce';
$string['invalidgradeitemid'] = 'Neplatné ID položky hodnocení';
$string['invalidgroupid'] = 'Zadán neplatné ID skupiny';
$string['invalidipformat'] = 'Neplatný formát IP adresy';
$string['invaliditemid'] = 'Neplatné ID položky';
$string['invalidkey'] = 'Nesprávný klíč';
$string['invalidlanguagecode'] = 'Neplatný kód jazyka: {$a}';
$string['invalidlegacy'] = 'Neplatná definice archetypu role: {$a}';
$string['invalidmd5'] = 'Ověření selhalo - zkuste to znovu';
$string['invalidmode'] = 'Neplatný režim ({$a})';
$string['invalidmodule'] = 'Neplatný modul';
$string['invalidmoduleid'] = 'Neplatné ID modulu: {$a}';
$string['invalidmodulename'] = 'Neplatné jméno modulu: {$a}';
$string['invalidnum'] = 'Neplatná číselná hodnota';
$string['invalidnumkey'] = 'Pole $conditions může obsahovat pouze numerické klíče. Opravte prosím kód!';
$string['invalidoutcome'] = 'Neplatné ID očekávaného výstupu';
$string['invalidpagesize'] = 'Neplatná velikost stránky';
$string['invalidpasswordpolicy'] = 'Neplatná politika hesel';
$string['invalidpaymentmethod'] = 'Neplatná metoda platby: {$a}';
$string['invalidqueryparam'] = 'CHYBA: Nesprávný počet parametrů dotazu. Bylo očekáváno:{$a->expected}, bylo použito: {$a->actual}.';
$string['invalidratingarea'] = 'Neplatná oblast hodnocení';
$string['invalidrecord'] = 'V databázové tabulce {$a} nemohu najít žádný záznam.';
$string['invalidrecordunknown'] = 'V databázi nemohu najít žádný záznam.';
$string['invalidrequest'] = 'Neplatný požadavek';
$string['invalidrole'] = 'Neplatná role';
$string['invalidroleid'] = 'Neplatné ID role';
$string['invalidscaleid'] = 'Neplatné ID škály';
$string['invalidsection'] = 'Záznam o modulu kurzu obsahuje neplatnou část';
$string['invalidsesskey'] = 'Vaše relace se s největší pravděpodobností vypršela. Přihlaste se znovu.';
$string['invalidshortname'] = 'Neplatné krátké jméno kurzu';
$string['invalidsourcefield'] = 'Dočasný soubor obsahuje neplatnou hodnotu pole "source"';
$string['invalidstatedetected'] = 'Něco není v pořádku: {$a}. Toto by se za normálních okolností nikdy nemělo stát.';
$string['invalidurl'] = 'Neplatná URL';
$string['invaliduser'] = 'Neplatný uživatel';
$string['invaliduserdata'] = 'Neplatná uživatelská data: {$a}';
$string['invaliduserfield'] = 'Neplatné uživatelské pole: {$a}';
$string['invaliduserid'] = 'Neplatné ID uživatele';
$string['invalidusername'] = 'Zadané uživatelské jméno obsahuje neplatné znaky';
$string['invalidusernameblank'] = 'Uživatelské jméno nesmí být prázdné';
$string['invalidxmlfile'] = '"{$a}" není platný XML soubor';
$string['iplookupfailed'] = 'Nelze najít geografické informace o této IP adrese: {$a}';
$string['iplookupprivate'] = 'Nelze zobrazit vyhledávání privátní IP adresy';
$string['ipmismatch'] = 'Neshoda IP adresy klienta';
$string['listcantmovedown'] = 'Položku již nelze posunout dolů, neboť je již na posledním místě v dané úrovni';
$string['listcantmoveleft'] = 'Položku nelze posunout doleva, neboť nemá žádný nadřazený prvek';
$string['listcantmoveright'] = 'Položku nelze posunout doprava, neboť neexistuje rovnocenná položka, jíž by se stala podřazenou. Přesuňte ji nejprve pod jinou položku na stejné úrovni a poté ji posuňte doprava.';
$string['listcantmoveup'] = 'Položku již nelze posunout nahoru, neboť je již na prvním místě v dané úrovni';
$string['listnochildren'] = 'Nebyly nalezeny podřazené položky';
$string['listnoitem'] = 'Položka nebyla nalezena';
$string['listnopeers'] = 'Nebyly nalezeny žádné položky na stejné úrovni';
$string['listupdatefail'] = 'Selhala databázová operace při úpravách hierarchie seznamu';
$string['logfilenotavailable'] = 'Protokoly nejsou dostupné';
$string['loginasnoenrol'] = 'Pokud jste v režimu "přihlásit se jako", nemůžete použít funkci zápisu a vyškrtnutí z kurzu';
$string['loginasonecourse'] = 'Do tohoto kurzu nemůžete vstoupit.<br /> Musíte ukončit režim "přihlásit se jako" předtím, než vstoupíte do jiného kurzu';
$string['maxareabytes'] = 'Soubor je větší než zbývající  prostor v této oblasti.';
$string['maxbytesfile'] = 'Soubor {$a->file} je příliš velký. Maximální velikost, kterou můžete nahrát, je  {$a->size}.';
$string['maxdraftitemids'] = 'Z důvodu nahrávání velkého množství souborů je nahrávání souborů dočasně omezeno. Zkuste to prosím znovu za několik sekund.';
$string['messageundeliveredbynotificationsettings'] = 'Zprávu nelze odeslat, protože osobní zprávy mezi uživateli (v nastavení oznámení) byly deaktivovány správcem webu.';
$string['messagingdisable'] = 'Zasílání zpráv není na tomto serveru dovoleno';
$string['mimetexisnotexist'] = 'Ve vašem systému není konfigurován pro spuštění mimeTeXu. Potřebujete získat <a href="https://www.forkosh.com/mimetex.zip"> https://www.forkosh.com/mimetex.zip</a> zdrojový kód v jazyku C, zkompilovat ho a spustitelný program vložit do adresáře moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Binární soubor mimetex není spustitelný!';
$string['missing_moodle_backup_xml_file'] = 'V záloze chybí XML soubor: {$a}';
$string['missingfield'] = 'Chybí pole "{$a}"';
$string['missingkeyinsql'] = 'CHYBA: v dotazu chybí parametr "{$a}"';
$string['missingparam'] = 'Chyběl požadovaný parametr ({$a})';
$string['missingparameter'] = 'Chybí parametr';
$string['missingrequiredfield'] = 'Chybí některé z povinných polí';
$string['missinguseranditemid'] = 'Chybí identifikátor uživatele a položky';
$string['missingvarname'] = 'Chybí požadované jméno proměnné! ';
$string['mixedtypesqlparam'] = 'CHYBA: Typy parametrů SQL dotazu jsou pomíchány!';
$string['mnetdisable'] = 'Podpora MNet není na tomto serveru povolena';
$string['mnetlocal'] = 'Vzdálení uživatelé se nemohou přihlašovat přímo na tomto serveru';
$string['moduledisable'] = 'Modul ({$a}) byl v tomto kurzu zakázán';
$string['moduledoesnotexist'] = 'Tento modul neexistuje';
$string['moduleinstancedoesnotexist'] = 'Instance tohoto modulu neexistuje';
$string['modulemissingcode'] = 'Modul {$a} nemá k dispozici kód potřebný pro vykonání této operace.';
$string['movecatcontentstoroot'] = 'Přesun obsahu kategorie do kořenového umístění není povolen. Obsah může být přesunut pouze do jiné existující kategorie.';
$string['movecategorynotpossible'] = 'Kategorii "{$a}" do vybrané kategorie nelze přesunout.';
$string['movecategoryownparent'] = 'Nemůžete nastavit kategorii "{$a}" jako nadřazenou sobě samé.';
$string['movecategoryparentconflict'] = 'Nemůžete nastavit kategorii "{$a}" jako podkategorii sebe sama.';
$string['mssqlrcsmodemissing'] = 'Databáze nepoužívá očekávaný režim READ_COMMITTED_SNAPSHOT, co může vést k nesprávným výsledkům, hlavně u scénářů s vysokou souběžností procesů. Prosím, aktivujte ji, aby bylo chování korektné. Další informace naleznete v dokumentaci <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Bylo nalezeno více komentářů, ale je očekáván pouze jeden.';
$string['multiplerestorenotallow'] = 'Vícenásobné vykonání obnovy ze zálohy není dovoleno!';
$string['mustbeloggedin'] = 'Abyste toto mohl udělat, musíte být přihlášen';
$string['mustbeteacher'] = 'Přístup na tuto stránku je povolen pouze učitelům';
$string['myisamproblem'] = 'Databázové tabulky používají úložiště MyISAM. Je doporučováno používat ACID kompatibilní úložiště s plnou podporou transakcí, jako je například InnoDB.';
$string['needcopy'] = 'Nejprve musíte něco zkopírovat!';
$string['needcoursecategroyid'] = 'Musí být specifikováno buďto id nebo kategorie kurzu.';
$string['needphpext'] = 'Do vaší instalace PHP musíte přidat podporu {$a}.';
$string['noadmins'] = 'Žádní správci!';
$string['noblocks'] = 'Nebyly nalezeny žádné bloky!';
$string['nocapabilitytousethisservice'] = 'Uživatel nemá potřebnou pravomoc pro použití této služby';
$string['nocategorydelete'] = 'Kategorie "{$a}" nemůže být odstraněna';
$string['nocontext'] = 'Je mi líto, tento kurz není platný kontext.';
$string['nodata'] = 'Žádná data';
$string['noexistingcategory'] = 'Neexistující kategorie';
$string['nofile'] = 'Není určen soubor';
$string['nofiltersenabled'] = 'Nejsou povoleny filtry.';
$string['nofolder'] = 'Požadovaný adresář neexistuje';
$string['noformdesc'] = 'Modul neobsahuje soubor s definicí formuláře';
$string['noguest'] = 'Hosté zde nemají přístup!';
$string['noinstances'] = 'V tomto kurzu se nevyskytuje žádná instance {$a}!';
$string['nologinas'] = 'Nemáte povoleno přihlásit se jako tento uživatel';
$string['nonmeaningfulcontent'] = 'Nesmyslný obsah';
$string['noparticipants'] = 'Pro tento kurz nenalezen žádný účastník';
$string['noparticipatorycms'] = 'Je nám líto, ale nemáte žádné moduly účasti na kurzu k dispozici';
$string['nopermissions'] = 'Je mi líto, ale momentálně nemáte oprávnění vykonat tuto operaci ({$a}).';
$string['nopermissiontocomment'] = 'Nemůžete přidávat komentáře';
$string['nopermissiontodelentry'] = 'Nemůžete odstraňovat tento komentář!';
$string['nopermissiontoeditcomment'] = 'Nemůžete upravovat komentáře jiných lidí!';
$string['nopermissiontohide'] = 'Skrytí není povoleno!';
$string['nopermissiontoimportact'] = 'Nemáte potřebné oprávnění pro import činností do tohoto kurzu';
$string['nopermissiontolock'] = 'Zamčení není povoleno!';
$string['nopermissiontomanagegroup'] = 'Nemáte oprávnění požadovaná ke správě skupin';
$string['nopermissiontorate'] = 'Hodnocení položek není povoleno!';
$string['nopermissiontoshow'] = 'Zobrazení není povoleno!';
$string['nopermissiontounlock'] = 'Odemčení není povoleno!';
$string['nopermissiontoupdatecalendar'] = 'Promiňte, ale nemáte oprávnění aktualizovat událost v kalendáři.';
$string['nopermissiontoviewgrades'] = 'Nelze zobrazit hodnocení.';
$string['nopermissiontoviewletergrade'] = 'Chybí oprávnění pro zobrazení slovních známek';
$string['nopermissiontoviewpage'] = 'Nemáte přístup na tuto stránku';
$string['nosite'] = 'Chybí záznam pro kurz na hlavní stránce';
$string['nositeid'] = 'Chybí ID webu';
$string['nostartdatenoenddate'] = 'Datum ukončení kurzu lze nastavit pouze tehdy, když je nastaveno také datum zahájení.';
$string['nostatstodisplay'] = 'Je nám líto, nejsou dostupná žádná data k zobrazení';
$string['notallowedtoupdateprefremotely'] = 'Nemáte oprávnění pro vzdálenou aktualizaci uživatelských předvoleb';
$string['notavailable'] = 'Prozatím není dostupné';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Nejste členem této skupiny v kurzu';
$string['notownerofkey'] = 'Nejste vlastníkem tohoto klíče';
$string['nousers'] = 'Žádný uživatel nebyl nalezen!';
$string['oauth1accesstoken'] = 'Chyba OAuth 1.0: Neobdrželi jsme přístupový token.';
$string['oauth1requesttoken'] = 'Chyba OAuth 1.0: Neobdrželi jsme  požadavek o token - poskytovatel služeb může být dočasně nefunkční.';
$string['onlyadmins'] = 'Tuto operaci jsou oprávněni provést pouze správci';
$string['onlyeditingteachers'] = 'Toto mohou udělat pouze učitelé s právem editace';
$string['onlyeditown'] = 'Můžete upravovat pouze své vlastní informace';
$string['orderidnotfound'] = 'Objednávka ID {$a} nebyla nalezena';
$string['pagenotexist'] = 'Neočekávaná chyba (požadovaná stránka neexistuje)';
$string['pathdoesnotstartslash'] = 'Chybí argumenty, cesta nezačíná lomítkem!';
$string['pleasereport'] = 'Pokud můžete, pošlete nám prosím zprávu s popisem operace, kterou jste se pokoušeli provést, a která vedla k chybě:';
$string['pluginrequirementsnotmet'] = 'Zásuvný modul "{$a->pluginname}" ({$a->pluginversion}) se nepodařilo nainstalovat - vyžaduje vyšší verzi Moodlu (používáte verzi {$a->currentmoodle}, potřebujete verzi {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Chyba: předpona názvů tabulek nemůže být prázdná ({$a})</p>
<p>Správce serveru musí opravit konfiguraci.</p>';
$string['prefixtoolong'] = '<p>Chyba: předpona názvů tabulek je příliš dlouhá ({$a->dbfamily})</p>
<p>Správce serveru musí opravit konfiguraci. Maximální povolená délka pro {$a->dbfamily} je {$a->maxlength} znaky.</p>';
$string['privatefilesupload'] = 'Nahrávání přímo do uživatelského neveřejné oblasti souborů již není podporován. Nahrává se  do pracovního prostoru a pak přesouvá soubory core_user::add_user_private_files';
$string['processingstops'] = 'Zde se zpracování zastavilo. Zbývající záznamy byly ignorovány.';
$string['protected_cc_not_supported'] = 'Chráněné balíčky nejsou podporovány';
$string['querystringcannotbeempty'] = 'Řetězec dotazu nemůže být prázdný.';
$string['redirecterrordetected'] = 'Zjištěno nepodporované přesměrování. Vykonávání skriptu ukončeno.';
$string['refoundto'] = 'Může být vráceno: {$a}';
$string['refoundtoorigi'] = 'Vráceno v původní výši: {$a}';
$string['registrationdisabled'] = 'Na tomto webu je registrace zakázána';
$string['remotedownloaderror'] = '<p>Stahování komponenty na váš server selhalo. Prověřte nastavení proxy. Vřele doporučujeme PHP rozšíření cURL.</p>
<p>Nyní musíte stáhnout soubor <a href="{$a->url}">{$a->url}</a> ručně, překopírovat jej do "{$a->dest}" na vašem serveru a tam jej rozbalit.</p>';
$string['remotedownloadnotallowed'] = 'Stahování komponent na server není povoleno (direktiva allow_url_fopen je ve stavu \'vypnuto\').<br /><br />Musíte soubor stáhnout <a href="{$a->url}">{$a->url}</a> ručně, zkopírovat jej na serveru do umístění "{$a->dest}" a tam jej dekomprimovat.';
$string['reportnotavailable'] = 'Tento přehled je dostupný pouze pro hlavní kurz na titulní stránce';
$string['requirecorrectaccess'] = 'Neplatná adresa URL nebo port.';
$string['requireloginerror'] = 'Kurz nebo aktivita nejsou přístupné';
$string['restore_path_element_missingmethod'] = 'Proces obnovy vyžaduje metodu {$a}.';
$string['restore_path_element_noobject'] = '{$a} není platným objektem.';
$string['restorechecksumfailed'] = 'Vyskytl se problém s daty potřebnými pro obnovu, která byla uložena ve vaší session. Zkontrolujte vaše nastavení dostupné paměti pro PHP a limit velikosti pro DB package. Obnova byla ukončena.';
$string['restrictedcontextexception'] = 'Bohužel, vykonávání externí funkce porušuje kontextová omezení';
$string['restricteduser'] = 'Je mi líto, ale vašemu současnému účtu "{$a}" bylo zakázáno provést tuto operaci';
$string['reverseproxyabused'] = 'Je povoleno reverzní proxy, na server nelze přistupovat přímo.<br />Prosím, kontaktujte správce serveru.';
$string['rpcerror'] = 'Ale toto je nepříjemné... Komunikace přes MNet selhala. Předejte, prosím, následující chybovou zprávu vašemu správci: {$a}';
$string['scheduledbackupsdisabled'] = 'Naplánované zálohy byly správcem serveru zakázány';
$string['secretalreadyused'] = 'Odkaz na změnu hesla byl již použit. Heslo nebylo změněno.';
$string['sectionnotexist'] = 'Tato sekce neexistuje';
$string['sendmessage'] = 'Odeslat zprávu';
$string['serverconnection'] = 'Chyba spojení se serverem';
$string['servicedonotexist'] = 'Služba neexistuje';
$string['sessioncookiesdisable'] = 'Neplatné použití funkce require_key_login() - session cookie musí být zakázány!';
$string['sessiondiskfull'] = 'Diskový prostor pro ukládání session je zaplněn. Momentálně se nelze přihlásit.<br /><br />Prosím, uvědomte správce.';
$string['sessionerroruser'] = 'Vaše přihlášení vypršelo. Prosím, přihlaste se znovu.';
$string['sessionerroruser2'] = 'Objevila se chyba na serveru, která ovlivňuje vaše přihlášení. Prosím, přihlaste se znovu nebo restartujte váš prohlížeč.';
$string['sessionexpired'] = 'Relace vypršela';
$string['sessionhandlerproblem'] = 'Ovladač relace je špatně nastaven';
$string['sessionipnomatch'] = 'Je mi líto, ale vaše IP se v průběhu vašeho přihlášení změnila. Toto bezpečnostní opatření zabraňuje útočníkům vydávat se za přihlášeného uživatele. Běžným uživatelům by se tato zpráva neměla zobrazit - spojte se s vaším správcem a požádejte jej o pomoc.';
$string['sessionipnomatch2'] = '<p>Vaše IP adresa se od doby vašeho přihlášení změnila. Moodle obsahuje bezpečností pojistky, které zabraňují útočníkům ukrást vaši uživatelskou identitu, zatímco jste přihlášeni na těchto stránkách. Tuto zprávu ale můžete vidět i tehdy, pokud jste připojení k bezdrátové síti nebo pokud cestujete mezi různými sítěmi. O další pomoc požádejte správce webu.</p>
<p>Pokračujte obnovením této stránky tlačítkem F5.</p>';
$string['sessionwaiterr'] = 'Vypršel časový limit čekání na uvolnění zámku session. Vyčkejte na zpracování vašeho stávajícího požadavku a poté to zkuste znovu.';
$string['shortnametaken'] = 'Nějaký jiný kurz již používá tento krátký název ({$a})';
$string['sitepolicynotagreed'] = 'Souhlas s pravidly používání stránek nebyl potvrzen<a href="{$a}">Klikněte na Souhlas s pravidly používání těchto stránek.</a>';
$string['socksnotsupported'] = 'PHP verze 4 nepodporuje SOCKS5 proxy';
$string['spellcheckernotconf'] = 'Kontrola pravopisu není nastavena';
$string['sslonlyaccess'] = 'Promiňte, ale z důvodu bezpečnosti je povolené jen připojení https.';
$string['statscatchupmode'] = 'Probíhá zpracování statistik. Doposud byly zpracovány statistiky za {$a->daysdone} dnů, ke zpracování zůstává {$a->dayspending} dnů. Brzy na viděnou!';
$string['statsdisable'] = 'Statistiky nejsou povoleny.';
$string['statsnodata'] = 'Pro daný kurz a časové období nejsou k dispozici žádné údaje';
$string['storedfilecannotcreatefile'] = 'V úložišti souborů nelze vytvořit lokální soubor. Prověřte nastavení přístupových práv v datovém adresáři Moodle a volné místo na disku..';
$string['storedfilecannotcreatefiledirs'] = 'Nelze vytvořit adresáře v úložišti souborů. Prověřte nastavení přístupových práv v datovém adresáři Moodle.';
$string['storedfilecannotread'] = 'Nelze přečíst soubor. Soubor buď neexistuje nebo nejsou dostatečná přístupová práva.';
$string['storedfilecannotreadfile'] = 'Soubor "{$a}" nelze číst. Buď soubor neexistuje nebo existuje problém s oprávněním.';
$string['storedfilenotcreated'] = 'Nelze vytvořit soubor "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Neznámá výjimka týkající se uložených souborů ({$a})';
$string['tagdisabled'] = 'Štítky nejsou povoleny!';
$string['tagnotfound'] = 'Daný štítek nebyl v databázi nalezen';
$string['targetdatabasenotempty'] = 'Cílová databáze není prázdná. Převod přerušen z bezpečnostních důvodů.';
$string['textconditionsnotallowed'] = 'Přímé porovnání textových sloupců není povoleno. Použijte funkci sql_compare_text()';
$string['themenotinstall'] = 'Toto téma není nainstalováno!';
$string['tokengenerationfailed'] = 'Nelze vytvořit nový token.';
$string['transactionvoid'] = 'Transakce nemůže být zrušena, již byl zrušena';
$string['unenrolerror'] = 'Při odhlášení uživatele z kurzu došlo k nějaké chybě';
$string['unicodeupgradeerror'] = 'Je mi líto. Vaše databáze dosud nepoužívá kódování Unicode a tato verze Moodlu není schopná migraci na Unicode provést. Prosím, proveďte nejprve upgrade na verzi 1.7.x a spusťte proces migrace na Unicode ze stránky Správy. Potom budete moci migrovat na Moodle {$a}';
$string['unknowaction'] = 'Neznámá akce!';
$string['unknowcategory'] = 'Neznámá kategorie!';
$string['unknowcontext'] = 'Neznámý kontext ({$a}) ve funkci get_child_contexts()';
$string['unknowformat'] = 'Neznámý formát ({$a})';
$string['unknownbackupexporterror'] = 'Neznámá chyba při přípravě informací pro import';
$string['unknownblockregion'] = 'Tato stránka nepodporuje oblast bloků "{$a}"';
$string['unknowncontext'] = 'Neznámý kontext.';
$string['unknowncourse'] = 'Neznámý kurz s názvem "{$a}"';
$string['unknowncourseidnumber'] = 'Neznámý kurz s identifikátorem "{$a}"';
$string['unknowncourserequest'] = 'Požadavek na schválení neexistujícího kurzu';
$string['unknowncoursesection'] = 'Neznámé téma kurzu v kurzu "{$a}"';
$string['unknownevent'] = 'Neznámá událost';
$string['unknownfiletype'] = 'Chyba, neznámý typ filtru';
$string['unknowngroup'] = 'Neznámá skupina "{$a}"';
$string['unknownhelp'] = 'Neznámé téma nápovědy {$a}';
$string['unknownjsinrequirejs'] = 'Nemohu najít knihovnu JS: {$a}';
$string['unknownmodulename'] = 'Neznámý název modulu';
$string['unknownrole'] = 'Neznámá role "{$a}"';
$string['unknownsortcolumn'] = 'Neznámý sloupec pro třídění ({$a})';
$string['unknownuseraction'] = 'Této instrukci nerozumím';
$string['unknownuserselector'] = 'Neznámý nástroj pro výběr uživatele';
$string['unknoworder'] = 'Neznámé řazení';
$string['unknowparamtype'] = 'Neznámý typ parametru ({$a})';
$string['unknowquestiontype'] = 'Nepodporovaný typ úlohy {$a}';
$string['unknowuploadaction'] = 'Neznámá akce ({$a})';
$string['unspecifycourseid'] = 'Je potřeba určit identifikátor kurzu v databázi, krátký název nebo pole idnumber';
$string['unsupportedevent'] = 'Nepodporovaný typ události';
$string['unsupportedstate'] = 'Nepodporovaný stav dokončování';
$string['unsupportedwebserver'] = 'Software webového serveru ({$a}) není podporován.';
$string['upgraderequires19'] = 'Nová verze zdrojových kódů byla nahrána na server. Bohužel, přechod z vaši předchozí verze není podporován. Nejprve musíte aktualizovat na poslední dostupnou verzi 1.9.x. Případně se ještě můžete vrátit k předchozí verzi, pokud nahrajete zpět původní verzi zdrojových kódů.';
$string['upgraderunning'] = 'Tyto stránky se právě aktualizují. Prosím, zkuste to později.';
$string['urlnotdefinerss'] = 'URL není definována pro vlákno RSS';
$string['useradmineditadmin'] = 'Pouze správci jsou oprávněni měnit účty jiných správců.';
$string['useradminodelete'] = 'Účty správců nemohou být odstraněny.';
$string['userautherror'] = 'Neznámý autentizační modul';
$string['userauthunsupported'] = 'Autentizační modul zde není podporován';
$string['useremailduplicate'] = 'Duplicitní adresa';
$string['usermustbemnet'] = 'Seznam pro řízení přístupu přes MNet se týká pouze vzdálených uživatelů.';
$string['usernamelowercase'] = 'Uživatelské jméno musí být malá písmena';
$string['usernotaddederror'] = 'Uživatel nebyl přidán - neznámá chyba';
$string['usernotaddedregistered'] = 'Uživatel nebyl přidán - je již registrován';
$string['usernotavailable'] = 'Informace o tomto uživateli vám nejsou dostupné';
$string['usernotdeletedadmin'] = 'Uživatel nebyl odstraněn - nelze odstranit účty správců';
$string['usernotdeleteddeleted'] = 'Tento uživatel již byl odstraněn.';
$string['usernotdeletederror'] = 'Uživatel nebyl odstraněn - chyba';
$string['usernotdeletedmissing'] = 'Uživatel nebyl odstraněn - nelze najít dané uživatelské jméno';
$string['usernotdeletedoff'] = 'Uživatel nebyl odstraněn - odstraňování není povoleno';
$string['usernotfullysetup'] = 'Uživatel není plně nastaven';
$string['usernotincourse'] = 'Uživatel není v tomto kurzu!';
$string['usernotrenamedadmin'] = 'Nelze přejmenovat účty správců';
$string['usernotrenamedexists'] = 'Uživatel nepřejmenován - nové uživatelské jméno již používá někdo jiný.';
$string['usernotrenamedmissing'] = 'Uživatel nepřejmenován - původní uživatelské jméno nenalezeno.';
$string['usernotrenamedoff'] = 'Uživatel nebyl přejmenován - přejmenování není povoleno';
$string['usernotupdatedadmin'] = 'Nelze upravovat účty správců';
$string['usernotupdatederror'] = 'Uživatel nebyl upraven - chyba';
$string['usernotupdatednotexists'] = 'Uživatel nebyl upraven - neexistuje';
$string['userquotalimit'] = 'Dosáhli jste přidělené kvóty pro vaše soubory';
$string['userselectortoomany'] = 'Chybné použití třídy user_selector';
$string['verifyagedigitalconsentnotpossible'] = 'Omlouváme se, ověření digitálního souhlasu dle věku momentálně není možné.';
$string['wrongcall'] = 'Neplatné volání skriptu';
$string['wrongcontextid'] = 'ID kontextu bylo nesprávné (nemohu ho najít)';
$string['wrongdestpath'] = 'Chybné cílové umístění';
$string['wrongroleid'] = 'Neplatný identifikátor role!';
$string['wrongsourcebase'] = 'Chybné URL zdrojového serveru';
$string['wrongusernamepassword'] = 'Chybné uživatelské jméno/heslo';
$string['wrongzipfilename'] = 'Chybné jméno souboru ZIP';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Nemohu vytvořit kurz - Chyba oprávnění';
$string['wwwrootmismatch'] = 'Neplatná přístupová adresa. Tento server je dostupný pouze na adrese "{$a}".<br />Prosím, uvědomte správce serveru.';
$string['wwwrootslash'] = 'Chyba v konfiguraci. Konfigurační parametr $CFG->wwwroot ve vašem souboru config.php nesmí končit lomítkem.<br />. Prosím, uvědomte správce.';
$string['xmldberror'] = 'Chyba XMLDB!';
$string['youcannotdeletecategory'] = 'Nemůžete odstranit kategorii "{$a}", protože nemáte oprávnění ani odstranit ani přesunout její obsah.';
