<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'ru', version '3.8'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Адрес';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Вставить/редактировать якорь';
$string['advanced:backcolor_desc'] = 'Выбрать цвет фона';
$string['advanced:block'] = 'Формат';
$string['advanced:blockquote'] = 'Цитата';
$string['advanced:blockquote_desc'] = 'Цитата';
$string['advanced:bold_desc'] = 'Полужирный (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Вставить/Удалить маркированный список';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Вставить специальный символ';
$string['advanced:cleanup_desc'] = 'Очистить';
$string['advanced:clipboard_msg'] = 'Команды Копировать/Вырезать/Вставить не доступны в Firefox. Хотите узнать об этом подробнее?';
$string['advanced:code'] = 'Код';
$string['advanced:code_desc'] = 'Редактировать HTML-код';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Копировать';
$string['advanced:custom1_desc'] = 'Введите описание';
$string['advanced:cut_desc'] = 'Вырезать';
$string['advanced:dd'] = 'Определение';
$string['advanced:div'] = 'Раздел';
$string['advanced:dt'] = 'Термин';
$string['advanced:font_size'] = 'Размер';
$string['advanced:fontdefault'] = 'Шрифт';
$string['advanced:forecolor_desc'] = 'Выбрать цвет текста';
$string['advanced:h1'] = 'Заголовок 1';
$string['advanced:h2'] = 'Заголовок 2';
$string['advanced:h3'] = 'Заголовок 3';
$string['advanced:h4'] = 'Заголовок 4';
$string['advanced:h5'] = 'Заголовок 5';
$string['advanced:h6'] = 'Заголовок 6';
$string['advanced:help_desc'] = 'Справка';
$string['advanced:help_shortcut'] = 'Нажмите сочетание клавиш ALT-F10 для панели инструментов. Нажмите сочетание клавиш ALT-0 для помощи';
$string['advanced:hr_desc'] = 'Вставить горизонтальную линию';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '65';
$string['advanced:image_desc'] = 'Вставить/редактировать изображение';
$string['advanced:image_props_desc'] = 'Свойства изображения';
$string['advanced:indent_desc'] = 'Увеличить отступ';
$string['advanced:italic_desc'] = 'Курсив (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'По центру';
$string['advanced:justifyfull_desc'] = 'По ширине';
$string['advanced:justifyleft_desc'] = 'По левому краю';
$string['advanced:justifyright_desc'] = 'По правому краю';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Вставить/редактировать ссылку';
$string['advanced:more_colors'] = 'Больше цветов ...';
$string['advanced:newdocument'] = 'Вы уверены, что хотите очистить содержимое?';
$string['advanced:newdocument_desc'] = 'Новый документ';
$string['advanced:numlist_desc'] = 'Вставить/удалить нумерованный список';
$string['advanced:outdent_desc'] = 'Уменьшить отступ';
$string['advanced:paragraph'] = 'Абзац';
$string['advanced:paste_desc'] = 'Вставить';
$string['advanced:path'] = 'Путь';
$string['advanced:pre'] = 'Форматированный';
$string['advanced:redo_desc'] = 'Повторить (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Убрать форматирование';
$string['advanced:rich_text_area'] = 'Область текста';
$string['advanced:samp'] = 'Пример кода';
$string['advanced:shortcuts_desc'] = 'Справка о доступности';
$string['advanced:striketrough_desc'] = 'Зачеркнутый';
$string['advanced:style_select'] = 'Стили';
$string['advanced:sub_desc'] = 'Нижний индекс';
$string['advanced:sup_desc'] = 'Верхний индекс';
$string['advanced:toolbar'] = 'Панель инструментов';
$string['advanced:toolbar_focus'] = 'Перейти к кнопкам инструментов - Alt+Q, перейти к редактору - Alt-Z, перейти к пути элемента - Alt-X';
$string['advanced:underline_desc'] = 'Подчеркнутый (Ctrl+U)';
$string['advanced:undo_desc'] = 'Отменить (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Удалить ссылку';
$string['advanced:visualaid_desc'] = 'Показать/Скрыть указывающие (невидимые) элементы';
$string['advanced_dlg:about_author'] = 'Автор';
$string['advanced_dlg:about_general'] = 'О программе';
$string['advanced_dlg:about_help'] = 'Справка';
$string['advanced_dlg:about_license'] = 'Лицензия';
$string['advanced_dlg:about_loaded'] = 'Загруженные дополнения';
$string['advanced_dlg:about_plugin'] = 'Дополнение';
$string['advanced_dlg:about_plugins'] = 'Дополнения';
$string['advanced_dlg:about_title'] = 'О TinyMCE';
$string['advanced_dlg:about_version'] = 'Версия';
$string['advanced_dlg:accessibility_help'] = 'Справка о доступности';
$string['advanced_dlg:accessibility_usage_title'] = 'Общее использование';
$string['advanced_dlg:anchor_invalid'] = 'Укажите правильное имя якоря.';
$string['advanced_dlg:anchor_name'] = 'Имя якоря';
$string['advanced_dlg:anchor_title'] = 'Вставить/редактировать якорь';
$string['advanced_dlg:charmap_title'] = 'Выберите специальный символ';
$string['advanced_dlg:charmap_usage'] = 'Используйте левую и правую стрелки для перемещения.';
$string['advanced_dlg:code_title'] = 'Редактор HTML-кода';
$string['advanced_dlg:code_wordwrap'] = 'Переносить по словам';
$string['advanced_dlg:colorpicker_color'] = 'Цвет';
$string['advanced_dlg:colorpicker_name'] = 'Название';
$string['advanced_dlg:colorpicker_named_tab'] = 'Стандартные';
$string['advanced_dlg:colorpicker_named_title'] = 'Стандартные цвета';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Палитра';
$string['advanced_dlg:colorpicker_palette_title'] = 'Цвета палитры';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Выбор';
$string['advanced_dlg:colorpicker_picker_title'] = 'Выбор цвета';
$string['advanced_dlg:colorpicker_title'] = 'Выберите цвет';
$string['advanced_dlg:image_align'] = 'Выравнивание';
$string['advanced_dlg:image_align_baseline'] = 'По базовой линии';
$string['advanced_dlg:image_align_bottom'] = 'По низу';
$string['advanced_dlg:image_align_left'] = 'Влево';
$string['advanced_dlg:image_align_middle'] = 'По центру';
$string['advanced_dlg:image_align_right'] = 'Вправо';
$string['advanced_dlg:image_align_textbottom'] = 'По низу текста';
$string['advanced_dlg:image_align_texttop'] = 'По верху текста';
$string['advanced_dlg:image_align_top'] = 'По верху';
$string['advanced_dlg:image_alt'] = 'Описание изображения';
$string['advanced_dlg:image_border'] = 'Граница';
$string['advanced_dlg:image_dimensions'] = 'Размеры';
$string['advanced_dlg:image_hspace'] = 'Отступ по горизонтали';
$string['advanced_dlg:image_list'] = 'Список изображений';
$string['advanced_dlg:image_src'] = 'Адрес изображения';
$string['advanced_dlg:image_title'] = 'Вставить/редактировать изображение';
$string['advanced_dlg:image_vspace'] = 'Отступ по вертикали';
$string['advanced_dlg:invalid_color_value'] = 'Неверное значение цвета';
$string['advanced_dlg:link_is_email'] = 'Введенный URL-адрес похож на адрес эл. почты. Вы хотите добавить префикс mailto:?';
$string['advanced_dlg:link_is_external'] = 'Введенный адрес похож на внешнюю ссылку. Вы хотите добавить префикс http://?';
$string['advanced_dlg:link_list'] = 'Список ссылок';
$string['advanced_dlg:link_target'] = 'Цель';
$string['advanced_dlg:link_target_blank'] = 'Открыть ссылку в новом окне';
$string['advanced_dlg:link_target_same'] = 'Открыть ссылку в том же окне';
$string['advanced_dlg:link_title'] = 'Вставить/редактировать ссылку';
$string['advanced_dlg:link_titlefield'] = 'Название';
$string['advanced_dlg:link_url'] = 'Адрес ссылки';
$string['advhr:advhr_desc'] = 'Вставить горизонтальную линию';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Обычный';
$string['advhr_dlg:noshade'] = 'Без тени';
$string['advhr_dlg:size'] = 'Высота';
$string['advhr_dlg:width'] = 'Ширина';
$string['advhr_dlg:widthunits'] = 'Единицы';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Вставить/редактировать изображение';
$string['advimage_dlg:align'] = 'Выравнивание';
$string['advimage_dlg:align_baseline'] = 'По базовой линии';
$string['advimage_dlg:align_bottom'] = 'По низу';
$string['advimage_dlg:align_left'] = 'Влево';
$string['advimage_dlg:align_middle'] = 'По центру';
$string['advimage_dlg:align_right'] = 'Вправо';
$string['advimage_dlg:align_textbottom'] = 'По низу текста';
$string['advimage_dlg:align_texttop'] = 'По верху текста';
$string['advimage_dlg:align_top'] = 'По верху';
$string['advimage_dlg:alt'] = 'Описание изображения';
$string['advimage_dlg:alt_image'] = 'Альтернативное изображение';
$string['advimage_dlg:border'] = 'Граница';
$string['advimage_dlg:classes'] = 'Классы';
$string['advimage_dlg:constrain_proportions'] = 'Сохранять пропорции';
$string['advimage_dlg:dialog_title'] = 'Вставить/редактировать изображение';
$string['advimage_dlg:dimensions'] = 'Размеры';
$string['advimage_dlg:example_img'] = 'Предварительный просмотр оформления';
$string['advimage_dlg:general'] = 'Общие';
$string['advimage_dlg:height'] = 'Высота';
$string['advimage_dlg:hspace'] = 'Горизонтальный отступ';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Список изображений';
$string['advimage_dlg:langcode'] = 'Код языка';
$string['advimage_dlg:langdir'] = 'Направление языка';
$string['advimage_dlg:list'] = 'Список изображений';
$string['advimage_dlg:long_desc'] = 'Ссылка на подробное описание';
$string['advimage_dlg:ltr'] = 'Слева направо';
$string['advimage_dlg:map'] = 'Карта';
$string['advimage_dlg:misc'] = 'Разное';
$string['advimage_dlg:missing_alt'] = 'Вы уверены, что хотите продолжить без описания изображения? Без него изображение может быть недоступно некоторым пользователям с ограниченными возможностями и тем, кто использует текстовый браузер или отключил изображения при просмотре веб-страниц.';
$string['advimage_dlg:mouseout'] = 'при уведении курсора';
$string['advimage_dlg:mouseover'] = 'при наведении курсора';
$string['advimage_dlg:preview'] = 'Предварительный просмотр';
$string['advimage_dlg:rtl'] = 'Справа налево';
$string['advimage_dlg:src'] = 'Адрес изображения';
$string['advimage_dlg:style'] = 'Стиль';
$string['advimage_dlg:swap_image'] = 'Замена изображения';
$string['advimage_dlg:tab_advanced'] = 'Дополнительные';
$string['advimage_dlg:tab_appearance'] = 'Оформление';
$string['advimage_dlg:tab_general'] = 'Общие';
$string['advimage_dlg:title'] = 'Название';
$string['advimage_dlg:vspace'] = 'Вертикальный отступ';
$string['advimage_dlg:width'] = 'Ширина';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Вставить/редактировать ссылку';
$string['advlink_dlg:accesskey'] = 'Клавиша доступа';
$string['advlink_dlg:advanced_props'] = 'Дополнительные свойства';
$string['advlink_dlg:advanced_tab'] = 'Дополнительные';
$string['advlink_dlg:anchor_names'] = 'Якори';
$string['advlink_dlg:classes'] = 'Классы';
$string['advlink_dlg:encoding'] = 'Целевая кодировка';
$string['advlink_dlg:event_props'] = 'События';
$string['advlink_dlg:events_tab'] = 'События';
$string['advlink_dlg:general_props'] = 'Общие свойства';
$string['advlink_dlg:general_tab'] = 'Общие';
$string['advlink_dlg:height'] = 'Высота';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Введенный адрес похож на эл. почту. Вы хотите добавить префикс mailto:?';
$string['advlink_dlg:is_external'] = 'Введенный адрес похож на внешнюю ссылку. Вы хотите добавить префикс http://?';
$string['advlink_dlg:langcode'] = 'Код языка';
$string['advlink_dlg:langdir'] = 'Направление языка';
$string['advlink_dlg:link_list'] = 'Список ссылок';
$string['advlink_dlg:list'] = 'Список ссылок';
$string['advlink_dlg:ltr'] = 'Слева направо';
$string['advlink_dlg:mime'] = 'Целевой MIME-тип';
$string['advlink_dlg:popup'] = 'Всплывающее окно JavaScript';
$string['advlink_dlg:popup_dependent'] = 'Зависимые (только Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Показать строку адреса';
$string['advlink_dlg:popup_menubar'] = 'Показать строку меню';
$string['advlink_dlg:popup_name'] = 'Название окна';
$string['advlink_dlg:popup_opts'] = 'Параметры';
$string['advlink_dlg:popup_position'] = 'Позиция (X/Y)';
$string['advlink_dlg:popup_props'] = 'Свойства всплывающего окна';
$string['advlink_dlg:popup_resizable'] = 'Сделать размер окна изменяемым';
$string['advlink_dlg:popup_return'] = 'Вставить \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Показать полосы прокрутки';
$string['advlink_dlg:popup_size'] = 'Размер';
$string['advlink_dlg:popup_statusbar'] = 'Показать строку состояния';
$string['advlink_dlg:popup_tab'] = 'Всплывающее окно';
$string['advlink_dlg:popup_toolbar'] = 'Показать панели инструментов';
$string['advlink_dlg:popup_url'] = 'Адрес всплывающего окна';
$string['advlink_dlg:rel'] = 'Отношение страница к цели';
$string['advlink_dlg:rev'] = 'Отношение цель к странице';
$string['advlink_dlg:rtl'] = 'Справа налево';
$string['advlink_dlg:style'] = 'Стиль';
$string['advlink_dlg:tabindex'] = 'Индекс табуляции';
$string['advlink_dlg:target'] = 'Цель';
$string['advlink_dlg:target_blank'] = 'Открыть в новом окне';
$string['advlink_dlg:target_langcode'] = 'Целевой язык';
$string['advlink_dlg:target_name'] = 'Название цели';
$string['advlink_dlg:target_parent'] = 'Открыть в родительском окне/фрейме';
$string['advlink_dlg:target_same'] = 'Открыть в этом окне/фрейме';
$string['advlink_dlg:target_top'] = 'Открыть в верхнем фрейме (замещает все остальные)';
$string['advlink_dlg:title'] = 'Вставить/редактировать ссылку';
$string['advlink_dlg:titlefield'] = 'Название';
$string['advlink_dlg:url'] = 'Адрес ссылки';
$string['advlink_dlg:width'] = 'Ширина';
$string['advlist:circle'] = 'Круг';
$string['advlist:def'] = 'По умолчанию';
$string['advlist:disc'] = 'Диск';
$string['advlist:lower_alpha'] = 'Латинские строчные';
$string['advlist:lower_greek'] = 'Греческие строчные';
$string['advlist:lower_roman'] = 'Римские строчные';
$string['advlist:square'] = 'Квадрат';
$string['advlist:types'] = 'Типы';
$string['advlist:upper_alpha'] = 'Латинские прописные';
$string['advlist:upper_roman'] = 'Римские прописные';
$string['aria:rich_text_area'] = 'Область форматирования текста';
$string['autosave:restore_content'] = 'Восстановление автосохраненного контента';
$string['autosave:unload_msg'] = 'Внесенные изменения будут потеряны, если вы уйдете с этой страницы.';
$string['autosave:warning_message'] = 'При восстановлении сохраненных данных Вы потеряете все содержимое, которое сейчас в редакторе. Вы уверены, что хотите восстановить сохраненный контент?';
$string['availablebuttons'] = 'Доступные кнопки';
$string['colors:000000'] = 'Черный';
$string['colors:000080'] = 'Темно-синий';
$string['colors:0000FF'] = 'Синий';
$string['colors:003300'] = 'Темно-зеленый';
$string['colors:003366'] = 'Темно-лазурный';
$string['colors:008000'] = 'Зеленый';
$string['colors:008080'] = 'Зеленовато-голубой';
$string['colors:00CCFF'] = 'Небесно-голубой';
$string['colors:00FF00'] = 'Зеленый лаймовый';
$string['colors:00FFFF'] = 'Цвет морской волны';
$string['colors:333300'] = 'Темно-оливковый';
$string['colors:333333'] = 'Очень темно-серый';
$string['colors:333399'] = 'Индиго';
$string['colors:3366FF'] = 'Ярко-синий';
$string['colors:339966'] = 'Бирюзовый';
$string['colors:33CCCC'] = 'Бирюзовый';
$string['colors:666699'] = 'Серо-голубой';
$string['colors:800000'] = 'Темно-бордовый';
$string['colors:800080'] = 'Фиолетовый';
$string['colors:808000'] = 'Оливковый';
$string['colors:808080'] = 'Серый';
$string['colors:993300'] = 'Темно-оранжевый';
$string['colors:993366'] = 'Коричневый';
$string['colors:999999'] = 'Средне-серый';
$string['colors:99CC00'] = 'Желто-зеленый';
$string['colors:99CCFF'] = 'Небесно-голубой';
$string['colors:C0C0C0'] = 'Серебристый';
$string['colors:CC99FF'] = 'Сливовый';
$string['colors:CCFFCC'] = 'Бледно-зеленый';
$string['colors:CCFFFF'] = 'Бледно-голубой';
$string['colors:FF0000'] = 'Красный';
$string['colors:FF00FF'] = 'Пурпурный';
$string['colors:FF6600'] = 'Оранжевый';
$string['colors:FF9900'] = 'Янтарный';
$string['colors:FF99CC'] = 'Розовый';
$string['colors:FFCC00'] = 'Золотистый';
$string['colors:FFCC99'] = 'Персиковый';
$string['colors:FFFF00'] = 'Желтый';
$string['colors:FFFF99'] = 'Светло-желтый';
$string['colors:FFFFFF'] = 'Белый';
$string['common:apply'] = 'Сохранить';
$string['common:browse'] = 'Обзор';
$string['common:cancel'] = 'Отменить';
$string['common:class_name'] = 'Класс';
$string['common:clipboard_msg'] = 'Команды Копировать/Вырезать/Вставить не доступны в Firefox. Хотите узнать об этом подробнее?';
$string['common:clipboard_no_support'] = 'Не поддерживается вашим браузером, используйте клавиатурные сокращения.';
$string['common:close'] = 'Закрыть';
$string['common:edit_confirm'] = 'Вы хотите использовать для редактирования визуальный режим?';
$string['common:insert'] = 'Вставить';
$string['common:invalid_data'] = 'Ошибка: красным отмечены значения, введеные неправильно.';
$string['common:invalid_data_min'] = 'значение {#field} должно быть больше, чем {#min}';
$string['common:invalid_data_number'] = '{#field} должно быть числом';
$string['common:invalid_data_size'] = '{#field} должно быть числом или процентом';
$string['common:more_colors'] = 'Больше цветов ...';
$string['common:not_set'] = '-- Нет --';
$string['common:popup_blocked'] = 'Ваш браузер заблокировал всплывающее окно, необходимое для работы приложения. Вам нужно отключить блокирование всплывающих окон на этом сайте, чтобы воспользоваться этим инструментом.';
$string['common:update'] = 'Обновить';
$string['common:value'] = '(значение)';
$string['contextmenu:align'] = 'Выравнивание';
$string['contextmenu:center'] = 'По центру';
$string['contextmenu:full'] = 'По ширине';
$string['contextmenu:left'] = 'По левому краю';
$string['contextmenu:right'] = 'По правому краю';
$string['customconfig'] = 'Пользовательские настройки';
$string['customconfig_desc'] = 'Пользовательские расширенные настройки TinyMCE в формате JSON,например: {"option1" : "value2", "option2" : "value2"}. Любые указанные здесь параметры заменяют стандартные и настройки плагина.';
$string['customtoolbar'] = 'Панель инструментов редактора';
$string['customtoolbar_desc'] = 'Каждая строка содержит список имен кнопок, разделенных запятыми; используйте "перенос строки" в качестве разделителя групп, пустые строки игнорируются. См. <a href="{$a}" target="_blank">{$a}</a> для списка кнопок TinyMCE по умолчанию. <br /> Первый ряд всегда будет показан, видимость второй и третьей панели инструментов можно переключать.';
$string['directionality:ltr_desc'] = 'Направление слева направо';
$string['directionality:rtl_desc'] = 'Направление справа налево';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Эмоции';
$string['emotions_dlg:cool'] = 'Круто';
$string['emotions_dlg:cry'] = 'Плачу';
$string['emotions_dlg:desc'] = 'Смайлики';
$string['emotions_dlg:embarassed'] = 'Стыдно';
$string['emotions_dlg:foot_in_mouth'] = 'Обескуражен';
$string['emotions_dlg:frown'] = 'Недовольный';
$string['emotions_dlg:innocent'] = 'Невинный';
$string['emotions_dlg:kiss'] = 'Поцелуй';
$string['emotions_dlg:laughing'] = 'Смешно';
$string['emotions_dlg:money_mouth'] = 'Хочу денег';
$string['emotions_dlg:sealed'] = 'Рот на замке';
$string['emotions_dlg:smile'] = 'Улыбаюсь';
$string['emotions_dlg:surprised'] = 'Удивлен';
$string['emotions_dlg:title'] = 'Вставить эмоцию';
$string['emotions_dlg:tongue_out'] = 'Показываю язык';
$string['emotions_dlg:undecided'] = 'В нерешительности';
$string['emotions_dlg:usage'] = 'Используйте для навигации стрелки влево и вправо';
$string['emotions_dlg:wink'] = 'Подмигиваю';
$string['emotions_dlg:yell'] = 'В ярости';
$string['fontselectlist'] = 'Список доступных шрифтов';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Свойства документа';
$string['fullpage_dlg:active_color'] = 'Цвет активной';
$string['fullpage_dlg:add'] = 'Добавить элемент';
$string['fullpage_dlg:add_base'] = 'Базовый элемент';
$string['fullpage_dlg:add_comment'] = 'Комментарий';
$string['fullpage_dlg:add_link'] = 'Ссылка';
$string['fullpage_dlg:add_meta'] = 'Мета-элемент';
$string['fullpage_dlg:add_script'] = 'Скрипт';
$string['fullpage_dlg:add_style'] = 'Стиль';
$string['fullpage_dlg:add_title'] = 'Заголовок';
$string['fullpage_dlg:advanced_props'] = 'Расширенные';
$string['fullpage_dlg:advanced_tab'] = 'Расширенные';
$string['fullpage_dlg:appearance_bgprops'] = 'Свойства фона';
$string['fullpage_dlg:appearance_linkprops'] = 'Цвета ссылок';
$string['fullpage_dlg:appearance_marginprops'] = 'Поля страницы';
$string['fullpage_dlg:appearance_style'] = 'Таблица стилей и свойства';
$string['fullpage_dlg:appearance_tab'] = 'Офомление';
$string['fullpage_dlg:appearance_textprops'] = 'Свойства текста';
$string['fullpage_dlg:author'] = 'Автор';
$string['fullpage_dlg:base_element'] = 'Базовый элемент';
$string['fullpage_dlg:bgcolor'] = 'Цвет фона';
$string['fullpage_dlg:bgimage'] = 'Фоновое изображение';
$string['fullpage_dlg:bottom_margin'] = 'Нижнее поле';
$string['fullpage_dlg:charset'] = 'Кодировка';
$string['fullpage_dlg:comment_element'] = 'Комментарий';
$string['fullpage_dlg:content'] = 'Содержание';
$string['fullpage_dlg:copyright'] = 'Авторские права';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Тип документа';
$string['fullpage_dlg:encoding'] = 'Кодировка символов';
$string['fullpage_dlg:font_face'] = 'Гарнитура';
$string['fullpage_dlg:font_size'] = 'Размер шрифта';
$string['fullpage_dlg:fontface'] = 'Гарнитура';
$string['fullpage_dlg:fontsize'] = 'Размер шрифта';
$string['fullpage_dlg:general_props'] = 'Основные';
$string['fullpage_dlg:head_elements'] = 'Заголовочные элементы';
$string['fullpage_dlg:hover_color'] = 'Цвет при наведении';
$string['fullpage_dlg:href'] = 'Адрес ссылки';
$string['fullpage_dlg:hreflang'] = 'Язык ссылки';
$string['fullpage_dlg:info'] = 'Информация';
$string['fullpage_dlg:langcode'] = 'Код языка';
$string['fullpage_dlg:langdir'] = 'Направление языка';
$string['fullpage_dlg:langprops'] = 'Язык и кодировка';
$string['fullpage_dlg:language'] = 'Язык';
$string['fullpage_dlg:left_margin'] = 'Левое поле';
$string['fullpage_dlg:link_color'] = 'Цвет ссылки';
$string['fullpage_dlg:link_element'] = 'Ссылка';
$string['fullpage_dlg:ltr'] = 'Слева направо';
$string['fullpage_dlg:media'] = 'Медиа';
$string['fullpage_dlg:meta_description'] = 'Описание';
$string['fullpage_dlg:meta_element'] = 'Мета-элемент';
$string['fullpage_dlg:meta_index_follow'] = 'Индексировать и следовать';
$string['fullpage_dlg:meta_index_nofollow'] = 'Индексировать и не следовать';
$string['fullpage_dlg:meta_keywords'] = 'Ключевые слова';
$string['fullpage_dlg:meta_noindex_follow'] = 'Не индексировать но следовать';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Не индексировать и не следовать';
$string['fullpage_dlg:meta_props'] = 'Мета информация';
$string['fullpage_dlg:meta_robots'] = 'Роботы';
$string['fullpage_dlg:meta_tab'] = 'Основные';
$string['fullpage_dlg:meta_title'] = 'Заголовок';
$string['fullpage_dlg:movedown'] = 'Опустить выделенный элемент';
$string['fullpage_dlg:moveup'] = 'Поднять выделенный элемент';
$string['fullpage_dlg:name'] = 'Имя';
$string['fullpage_dlg:properties'] = 'Свойства';
$string['fullpage_dlg:rel'] = 'Связь';
$string['fullpage_dlg:remove'] = 'Удалить выделенный элемент';
$string['fullpage_dlg:rev'] = 'Рев.';
$string['fullpage_dlg:right_margin'] = 'Правле поле';
$string['fullpage_dlg:rtl'] = 'Справа налево';
$string['fullpage_dlg:script_element'] = 'Скрипт';
$string['fullpage_dlg:src'] = 'Источник';
$string['fullpage_dlg:style'] = 'Стиль';
$string['fullpage_dlg:style_element'] = 'Стиль';
$string['fullpage_dlg:stylesheet'] = 'Таблица стилей';
$string['fullpage_dlg:target'] = 'Цель';
$string['fullpage_dlg:text_color'] = 'Цвет текста';
$string['fullpage_dlg:textcolor'] = 'Цвет';
$string['fullpage_dlg:title'] = 'Свойства документа';
$string['fullpage_dlg:title_element'] = 'Заголовок';
$string['fullpage_dlg:top_margin'] = 'Верхнее поле';
$string['fullpage_dlg:type'] = 'Тип';
$string['fullpage_dlg:value'] = 'Значение';
$string['fullpage_dlg:visited_color'] = 'Цвет посещенной';
$string['fullpage_dlg:xml_pi'] = 'Определения XML';
$string['fullscreen:desc'] = 'Вкл./выкл. полноэкранный режим';
$string['iespell:download'] = 'Компонент проверки орфографии не обнаружен. Установить?';
$string['iespell:iespell_desc'] = 'Проверить орфографию';
$string['insertdatetime:date_fmt'] = '%A, %d %B %Y';
$string['insertdatetime:day_long'] = 'Воскресенье,Понедельник,Вторник,Среда,Четверг,Пятница,Суббота,Воскресенье';
$string['insertdatetime:day_short'] = 'Вс,Пн,Вт,Ср,Чт,Пт,Сб,Вс';
$string['insertdatetime:insertdate_desc'] = 'Вставить дату';
$string['insertdatetime:inserttime_desc'] = 'Вставить время';
$string['insertdatetime:months_long'] = 'января,февраля,марта,апреля,мая,июня,июля,августа,сентября,октября,ноября,декабря';
$string['insertdatetime:months_short'] = 'янв,фев,мар,апр,май,июн,июл,авг,сен,окт,ноя,дек';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Вкл./выкл. абсолютное позиционирование';
$string['layer:backward_desc'] = 'На задний  план';
$string['layer:content'] = 'Новый слой';
$string['layer:forward_desc'] = 'На передний план';
$string['layer:insertlayer_desc'] = 'Вставить новый слой';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Вставить/редактировать встроенный медиа-объект';
$string['media:edit'] = 'Редактировать медиа-объект';
$string['media_dlg:advanced'] = 'Дополнительные';
$string['media_dlg:align'] = 'Выравнивание';
$string['media_dlg:align_bottom'] = 'По низу';
$string['media_dlg:align_bottom_left'] = 'По низу слева';
$string['media_dlg:align_bottom_right'] = 'По низу справа';
$string['media_dlg:align_center'] = 'По центру';
$string['media_dlg:align_left'] = 'Слева';
$string['media_dlg:align_right'] = 'Справа';
$string['media_dlg:align_top'] = 'По верху';
$string['media_dlg:align_top_left'] = 'По верху слева';
$string['media_dlg:align_top_right'] = 'По верху справа';
$string['media_dlg:altsource1'] = 'Альтернативный источник 1';
$string['media_dlg:altsource2'] = 'Альтернативный источник 2';
$string['media_dlg:audio'] = 'HTML5 аудио';
$string['media_dlg:autogotourl'] = 'Автопереход по URL';
$string['media_dlg:autohref'] = 'Автоматические ссылки';
$string['media_dlg:autostart'] = 'Автостарт';
$string['media_dlg:balance'] = 'Баланс';
$string['media_dlg:base'] = 'Основа';
$string['media_dlg:baseurl'] = 'Основной URL';
$string['media_dlg:bgcolor'] = 'Фон';
$string['media_dlg:cache'] = 'Кеш';
$string['media_dlg:captioningid'] = 'ID субтитров';
$string['media_dlg:center'] = 'По центру';
$string['media_dlg:class_name'] = 'Класс';
$string['media_dlg:console'] = 'Консоль';
$string['media_dlg:constrain_proportions'] = 'Сохранять пропорции';
$string['media_dlg:controller'] = 'Регулятор';
$string['media_dlg:controls'] = 'Управление';
$string['media_dlg:correction'] = 'Без коррекции';
$string['media_dlg:currentmarker'] = 'Текущая отметка';
$string['media_dlg:currentposition'] = 'Текущая позиция';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:embedded_audio_options'] = 'Опции встроенного аудио';
$string['media_dlg:embeddedaudio'] = 'Встроенное аудио';
$string['media_dlg:enabled'] = 'Включить';
$string['media_dlg:enablejavascript'] = 'Включить JavaScript';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = 'Файл/адрес';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash options';
$string['media_dlg:flashvars'] = 'Переменные Flash';
$string['media_dlg:fullscreen'] = 'Полный экран';
$string['media_dlg:general'] = 'Общие';
$string['media_dlg:hidden'] = 'Скрытое';
$string['media_dlg:href'] = 'Адрес ссылки';
$string['media_dlg:hspace'] = 'Горизонтальный отступ';
$string['media_dlg:html5_audio_options'] = 'Опции аудио';
$string['media_dlg:html5_video_options'] = 'Опции видео HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'фрейм';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'Список';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Зациклить';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'Отобразить меню';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'Название';
$string['media_dlg:nojava'] = 'Нет Java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'Проигрывать автоматически';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:poster'] = 'Опубликовавший';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Предварительная загрузка';
$string['media_dlg:preload_auto'] = 'На усмотрение браузера пользователя';
$string['media_dlg:preload_metadata'] = 'Предварительная загрузка метаданных видео';
$string['media_dlg:preload_none'] = 'Без предварительной загрузки';
$string['media_dlg:preview'] = 'Предварительный просмотр';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'Настройки Quicktime';
$string['media_dlg:qt_stream_warn'] = 'Ресурсы потокового RTSP должны быть добавлены в поле источника QT на вкладке Дополнительно. Вы должны также добавить не-потоковые версии поля источника.';
$string['media_dlg:qtsrc'] = 'Источник QT';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:quality'] = 'Качество';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Параметры плеера Real Media';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Масштаб';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave options';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Размеры';
$string['media_dlg:sound'] = 'Звук';
$string['media_dlg:source'] = 'Исходный текст';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Растягивающийся стиль';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Цель';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'Вставить/редактировать медиа-объект';
$string['media_dlg:type'] = 'Тип';
$string['media_dlg:uimode'] = 'Режим UI';
$string['media_dlg:video'] = 'HTML5 видео';
$string['media_dlg:volume'] = 'Громкость';
$string['media_dlg:vspace'] = 'Вертикальный отступ';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Настройки медиаплеера Windows';
$string['nonbreaking:nonbreaking_desc'] = 'Вставить неразрывный пробел';
$string['pagebreak:desc'] = 'Вставить разделитель страниц для печати.';
$string['paste:paste_text_desc'] = 'Вставить как простой текст';
$string['paste:paste_word_desc'] = 'Вставить из Word';
$string['paste:plaintext_mode'] = 'Сейчас используется режим вставки простого текста. Нажмите кнопку для переключения в нормальный режим вставки. После вставки  вернется нормальный режим вставки.';
$string['paste:plaintext_mode_stick'] = 'Сейчас используется режим вставки простого текста. Нажмите кнопку для переключения в нормальный режим вставки.';
$string['paste:selectall_desc'] = 'Выделить все';
$string['paste_dlg:text_linebreaks'] = 'Сохранять разрывы строк';
$string['paste_dlg:text_title'] = 'Используйте комбинацию клавиш Ctrl+V, чтобы вставить текст.';
$string['paste_dlg:word_title'] = 'Используйте комбинацию клавиш Ctrl+V, чтобы вставить текст.';
$string['pluginname'] = 'HTML-редактор TinyMCE';
$string['preview:preview_desc'] = 'Предварительный просмотр';
$string['print:print_desc'] = 'Печать';
$string['privacy:metadata'] = 'Плагин формата данных «HTML-редактор TinyMCE» не хранит никаких персональных данных.';
$string['save:cancel_desc'] = 'Отменить';
$string['save:save_desc'] = 'Сохранить';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Найти и заменить';
$string['searchreplace:search_desc'] = 'Найти';
$string['searchreplace_dlg:allreplaced'] = 'Все встречающиеся строки были заменены.';
$string['searchreplace_dlg:direction'] = 'Направление';
$string['searchreplace_dlg:down'] = 'Вниз';
$string['searchreplace_dlg:findnext'] = 'Найти далее';
$string['searchreplace_dlg:findwhat'] = 'Найти';
$string['searchreplace_dlg:mcase'] = 'Учитывать регистр';
$string['searchreplace_dlg:notfound'] = 'Поиск закончен. Строка не найдена.';
$string['searchreplace_dlg:replace'] = 'Заменить';
$string['searchreplace_dlg:replace_title'] = 'Найти и заменить';
$string['searchreplace_dlg:replaceall'] = 'Заменить все';
$string['searchreplace_dlg:replacewith'] = 'Заменить на';
$string['searchreplace_dlg:search_title'] = 'Найти';
$string['searchreplace_dlg:searchnext_desc'] = 'Найти далее';
$string['searchreplace_dlg:up'] = 'Вверх';
$string['settings'] = 'Основные настройки';
$string['simple:bold_desc'] = 'Полужирный (Ctrl+B)';
$string['simple:bullist_desc'] = 'Вставить/удалить маркированный список';
$string['simple:cleanup_desc'] = 'Очистить';
$string['simple:italic_desc'] = 'Курсив (Ctrl+I)';
$string['simple:numlist_desc'] = 'Вставить/удалить нумерованный список';
$string['simple:redo_desc'] = 'Повторить (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Зачеркнутый';
$string['simple:underline_desc'] = 'Подчеркнутый (Ctrl+U)';
$string['simple:undo_desc'] = 'Отменить (Ctrl+Z)';
$string['spellchecker:desc'] = 'Проверка орфографии';
$string['spellchecker:ignore_word'] = 'Игнорировать слово';
$string['spellchecker:ignore_words'] = 'Игнорировать все';
$string['spellchecker:langs'] = 'Языки';
$string['spellchecker:learn_word'] = 'Добавить слово';
$string['spellchecker:menu'] = 'Параметры проверки орфографии';
$string['spellchecker:no_mpell'] = 'Ошибок не обнаружено.';
$string['spellchecker:no_sug'] = 'Нет вариантов';
$string['spellchecker:sug'] = 'Варианты';
$string['spellchecker:wait'] = 'Пожалуйста, подождите...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '35';
$string['style:desc'] = 'Редактировать стиль CSS';
$string['style_dlg:apply'] = 'Применить';
$string['style_dlg:background'] = 'Фон';
$string['style_dlg:background_attachment'] = 'Прикрепление';
$string['style_dlg:background_color'] = 'Цвет фона';
$string['style_dlg:background_hpos'] = 'Горизонтальная позиция';
$string['style_dlg:background_image'] = 'Фоновое изображение';
$string['style_dlg:background_repeat'] = 'Повторение';
$string['style_dlg:background_tab'] = 'Фон';
$string['style_dlg:background_vpos'] = 'Вертикальная позиция';
$string['style_dlg:block'] = 'Блок';
$string['style_dlg:block_display'] = 'Отображение';
$string['style_dlg:block_letterspacing'] = 'Промежутки между символами';
$string['style_dlg:block_tab'] = 'Блок';
$string['style_dlg:block_text_align'] = 'Выравнивание текста';
$string['style_dlg:block_text_indent'] = 'Отступ текста';
$string['style_dlg:block_vertical_alignment'] = 'Вертикальное выравнивание';
$string['style_dlg:block_whitespace'] = 'Пробел';
$string['style_dlg:block_wordspacing'] = 'Промежутки между словами';
$string['style_dlg:border'] = 'Граница';
$string['style_dlg:border_tab'] = 'Граница';
$string['style_dlg:bottom'] = 'Снизу';
$string['style_dlg:box'] = 'Поле';
$string['style_dlg:box_clear'] = 'Очистить';
$string['style_dlg:box_float'] = 'Плавающий';
$string['style_dlg:box_height'] = 'Высота';
$string['style_dlg:box_tab'] = 'Контейнер';
$string['style_dlg:box_width'] = 'Ширина';
$string['style_dlg:bullet_image'] = 'Изображение маркера';
$string['style_dlg:clip'] = 'Кадрирование';
$string['style_dlg:color'] = 'Цвет';
$string['style_dlg:height'] = 'Высота';
$string['style_dlg:left'] = 'Слева';
$string['style_dlg:list'] = 'Список';
$string['style_dlg:list_tab'] = 'Список';
$string['style_dlg:list_type'] = 'Тип';
$string['style_dlg:margin'] = 'Поля';
$string['style_dlg:overflow'] = 'Обтекание';
$string['style_dlg:padding'] = 'Отступ';
$string['style_dlg:placement'] = 'Позиция';
$string['style_dlg:position'] = 'Позиция';
$string['style_dlg:positioning_tab'] = 'Позиция';
$string['style_dlg:positioning_type'] = 'Тип';
$string['style_dlg:right'] = 'Справа';
$string['style_dlg:same'] = 'Одно значение';
$string['style_dlg:style'] = 'Стиль';
$string['style_dlg:text'] = 'Текст';
$string['style_dlg:text_blink'] = 'Мигающий';
$string['style_dlg:text_case'] = 'Регистр';
$string['style_dlg:text_color'] = 'Цвет';
$string['style_dlg:text_decoration'] = 'Оформление';
$string['style_dlg:text_font'] = 'Шрифт';
$string['style_dlg:text_lineheight'] = 'Высота строки';
$string['style_dlg:text_none'] = 'Отсутствует';
$string['style_dlg:text_overline'] = 'Надчеркнутый';
$string['style_dlg:text_props'] = 'Текст';
$string['style_dlg:text_size'] = 'Размер';
$string['style_dlg:text_striketrough'] = 'Зачеркнутый';
$string['style_dlg:text_style'] = 'Стиль';
$string['style_dlg:text_tab'] = 'Текст';
$string['style_dlg:text_underline'] = 'Подчеркнутый';
$string['style_dlg:text_variant'] = 'Начертание';
$string['style_dlg:text_weight'] = 'Вес';
$string['style_dlg:title'] = 'Редактировать стиль CSS';
$string['style_dlg:toggle_insert_span'] = 'Вставить span для выделенного';
$string['style_dlg:top'] = 'Сверху';
$string['style_dlg:visibility'] = 'Видимость';
$string['style_dlg:width'] = 'Ширина';
$string['style_dlg:zindex'] = 'Z-индекс';
$string['subplugintype_tinymce'] = 'Плагин';
$string['subplugintype_tinymce_plural'] = 'Плагины';
$string['table:cell'] = 'Ячейка';
$string['table:cell_desc'] = 'Свойства ячейки';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Столбец';
$string['table:col_after_desc'] = 'Вставить столбец после';
$string['table:col_before_desc'] = 'Вставить столбец до';
$string['table:copy_row_desc'] = 'Копировать строку';
$string['table:cut_row_desc'] = 'Вырезать строку';
$string['table:del'] = 'Удалить таблицу';
$string['table:delete_col_desc'] = 'Удалить столбец';
$string['table:delete_row_desc'] = 'Удалить строку';
$string['table:desc'] = 'Вставить/редактировать таблицу';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Объединить ячейки';
$string['table:paste_row_after_desc'] = 'Вставить строку таблицы после';
$string['table:paste_row_before_desc'] = 'Вставить строку таблицы до';
$string['table:props_desc'] = 'Свойства таблицы';
$string['table:row'] = 'Строка';
$string['table:row_after_desc'] = 'Вставить строку после';
$string['table:row_before_desc'] = 'Вставить строку до';
$string['table:row_desc'] = 'Свойства строки';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Разделить ячейку';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Дополнительные свойства';
$string['table_dlg:advanced_tab'] = 'Дополнительные';
$string['table_dlg:align'] = 'Выравнивание';
$string['table_dlg:align_bottom'] = 'По низу';
$string['table_dlg:align_default'] = 'По умолчанию';
$string['table_dlg:align_left'] = 'Влево';
$string['table_dlg:align_middle'] = 'По центру';
$string['table_dlg:align_right'] = 'Вправо';
$string['table_dlg:align_top'] = 'По верху';
$string['table_dlg:bgcolor'] = 'Цвет фона';
$string['table_dlg:bgimage'] = 'Фоновое изображение';
$string['table_dlg:border'] = 'Граница';
$string['table_dlg:bordercolor'] = 'Цвет границы';
$string['table_dlg:caption'] = 'Заголовок таблицы';
$string['table_dlg:cell_all'] = 'Обновить все ячейки в таблице';
$string['table_dlg:cell_cell'] = 'Обновить текущую ячейку';
$string['table_dlg:cell_col'] = 'Обновить все ячейки в столбце';
$string['table_dlg:cell_limit'] = 'Вы превысили максимальное количество в {$cells} ячеек.';
$string['table_dlg:cell_row'] = 'Обновить все ячейки в строке';
$string['table_dlg:cell_title'] = 'Свойства ячейки';
$string['table_dlg:cell_type'] = 'Тип ячейки';
$string['table_dlg:cellpadding'] = 'Отступы в ячейках';
$string['table_dlg:cellspacing'] = 'Расстояние между ячейками';
$string['table_dlg:col_limit'] = 'Вы превысили максимальное количество в {$cols} столбцов.';
$string['table_dlg:colgroup'] = 'Группа столбцов';
$string['table_dlg:cols'] = 'Столбцы';
$string['table_dlg:frame'] = 'Границы';
$string['table_dlg:frame_all'] = 'все';
$string['table_dlg:frame_cols'] = 'столбцы';
$string['table_dlg:frame_groups'] = 'группы';
$string['table_dlg:frame_none'] = 'отсутствует';
$string['table_dlg:frame_rows'] = 'строки';
$string['table_dlg:general_props'] = 'Общие свойства';
$string['table_dlg:general_tab'] = 'Общие';
$string['table_dlg:height'] = 'Высота';
$string['table_dlg:id'] = 'Идентификатор';
$string['table_dlg:langcode'] = 'Код языка';
$string['table_dlg:langdir'] = 'Направление языка';
$string['table_dlg:ltr'] = 'Слева направо';
$string['table_dlg:merge_cells_title'] = 'Объединить ячейки';
$string['table_dlg:mime'] = 'Целевой MIME-тип';
$string['table_dlg:missing_scope'] = 'Вы действительно хотите продолжить, не указав область действия ячейки заголовка этой таблицы? Без этого некоторым пользователям с ограниченными возможностями может быть трудно понять содержание или данные таблицы.';
$string['table_dlg:row_all'] = 'Обновить все строки в таблице';
$string['table_dlg:row_even'] = 'Обновить четные строки в таблице';
$string['table_dlg:row_limit'] = 'Вы превысили максимальное количество в {$rows} строк.';
$string['table_dlg:row_odd'] = 'Обновить нечетные строки в таблице';
$string['table_dlg:row_row'] = 'Обновить текущую строку';
$string['table_dlg:row_title'] = 'Свойства строки';
$string['table_dlg:rowgroup'] = 'Группа строк';
$string['table_dlg:rows'] = 'Строки';
$string['table_dlg:rowtype'] = 'Строка в части таблицы';
$string['table_dlg:rtl'] = 'Справа налево';
$string['table_dlg:rules'] = 'Линейки';
$string['table_dlg:rules_above'] = 'сверху';
$string['table_dlg:rules_below'] = 'снизу';
$string['table_dlg:rules_border'] = 'граница';
$string['table_dlg:rules_box'] = 'контейнер';
$string['table_dlg:rules_hsides'] = 'горизонтальные';
$string['table_dlg:rules_lhs'] = 'слева';
$string['table_dlg:rules_rhs'] = 'справа';
$string['table_dlg:rules_void'] = 'отсутствуют';
$string['table_dlg:rules_vsides'] = 'вертикальные';
$string['table_dlg:scope'] = 'Пределы';
$string['table_dlg:style'] = 'Стиль';
$string['table_dlg:summary'] = 'Сводка';
$string['table_dlg:tbody'] = 'Основная часть таблицы';
$string['table_dlg:td'] = 'Данные';
$string['table_dlg:tfoot'] = 'Нижняя часть таблицы';
$string['table_dlg:th'] = 'Заголовок';
$string['table_dlg:thead'] = 'Верхняя часть таблицы';
$string['table_dlg:title'] = 'Вставить/изменить таблицу';
$string['table_dlg:valign'] = 'Вертикальное выравнивание';
$string['table_dlg:width'] = 'Ширина';
$string['template:desc'] = 'Вставить готовый шаблон';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Воскресенье,Понедельник,Вторник,Среда,Четверг,Пятница,Суббота,Воскресенье';
$string['template_dlg:day_short'] = 'Вс,Пн,Вт,Ср,Чт,Пт,Сб,Вс';
$string['template_dlg:desc'] = 'Вставить готовый шаблон';
$string['template_dlg:desc_label'] = 'Описание';
$string['template_dlg:label'] = 'Шаблон';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Январь,Февраль,Март,Апрель,Май,Июнь,Июль,Август,Сентябрь,Октябрь,Ноябрь,Декабрь';
$string['template_dlg:months_short'] = 'Янв,Фев,Мар,Апр,Май,Июн,Июл,Авг,Сен,Окт,Ноя,Дек';
$string['template_dlg:preview'] = 'Просмотр';
$string['template_dlg:select'] = 'Выберите шаблон';
$string['template_dlg:title'] = 'Шаблоны';
$string['template_dlg:warning'] = 'Внимание: замена одного шаблона другим может вызвать потерю данных.';
$string['visualblocks:desc'] = 'Показать/скрыть элементы блока';
$string['visualchars:desc'] = 'Показать/Скрыть символы визуального контроля';
$string['wordcount:words'] = 'Слов:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Аббревиатура';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Акроним';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Вставить/редактировать атрибуты';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Цитата';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Удаленный текст';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Добавленный текст';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Атрибуты';
$string['xhtmlxtras_dlg:attribs_title'] = 'Вставить/редактировать атрибуты';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Атрибуты';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'События';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Клавиша доступа';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Цитата';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Класс';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Дата/время';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'Идентификатор';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Язык';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Направление текста';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Стиль';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Индекс табуляции';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Название';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Слева направо';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Справа налево';
$string['xhtmlxtras_dlg:events_tab'] = 'События';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Атрибуты элемента';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'События элемента';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Общие настройки';
$string['xhtmlxtras_dlg:general_tab'] = 'Общие';
$string['xhtmlxtras_dlg:insert_date'] = 'Вставить текущую дату/время';
$string['xhtmlxtras_dlg:option_ltr'] = 'Слева направо';
$string['xhtmlxtras_dlg:option_rtl'] = 'Справа налево';
$string['xhtmlxtras_dlg:remove'] = 'Убрать';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Элемент аббревиатуры';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Элемент акронима';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Элемент цитаты';
$string['xhtmlxtras_dlg:title_del_element'] = 'Элемент удаленного текста';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Элемент добавленного текста';
