<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_intelliboard', language 'nl', version '3.9'.
 *
 * @package     local_intelliboard
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a0'] = 'Competenties Startpagina';
$string['a1'] = 'Competenties';
$string['a10'] = 'Aangemelde leerlingen';
$string['a11'] = 'Lijst van competenties toegewezen aan een cursus';
$string['a12'] = 'Status leerling';
$string['a13'] = 'Naam competentie';
$string['a14'] = 'Aangemaakt op';
$string['a15'] = 'Toegewezen op';
$string['a16'] = 'Voldoende bekwaamdheid';
$string['a17'] = 'Beoordeling';
$string['a18'] = 'Bekwaamheid van competenties';
$string['a19'] = 'Datum dat de competentie beoordeeld is';
$string['a2'] = 'Bekwaamdheid';
$string['a20'] = 'Competentie beoordelaar';
$string['a21'] = 'Activiteiten toegewezen';
$string['a22'] = 'Behaalde bekwaamdheid';
$string['a23'] = 'Competentie beoordeeld';
$string['a24'] = '# Bewijs';
$string['a25'] = 'Voltooide leerlingen';
$string['a26'] = 'Deze tabel toont het aantal competenties dat aan een cursus is toegewezen, leerlingen die zijn beoordeeld (al dan niet bekwaam) en leerlingen die zijn aangewezen als bekwaam in de competentie.';
$string['a27'] = 'uit';
$string['a28'] = 'Details';
$string['a29'] = 'Inschakelen competenties startpagina';
$string['a3'] = 'Toegewezen activiteiten';
$string['a30'] = 'Inschakelen competentierapporten';
$string['a31'] = 'Framewerken';
$string['a32'] = 'Studieplannen';
$string['a33'] = 'Beoordeeld, Bekwaamd';
$string['a34'] = 'Beoordeeld, Niet bekwaamd';
$string['a35'] = 'Niet beoordeeld';
$string['a36'] = 'Competentie Overzicht';
$string['a37'] = 'Er is geen competentie aangemaakt. Neem contact op met uw sitebeheerder.';
$string['a38'] = 'Cursussen die gekoppeld zijn aan competenties';
$string['a39'] = 'Competentie Totalen';
$string['a4'] = 'Bekwaamdheidvoortgang';
$string['a40'] = 'Gekoppelde cursussen';
$string['a5'] = 'Beoordeelde cursussen';
$string['a6'] = '# Bewijzen';
$string['a7'] = 'Beoordeelde leerlingen';
$string['a8'] = 'Voortgang';
$string['a9'] = 'Bekwaamde leerlingen';
$string['account'] = 'Abonnement Informatie';
$string['actions'] = 'Acties';
$string['active'] = 'Actief';
$string['activities'] = 'Activiteiten';
$string['activities_resources'] = 'Activiteiten/bronnen';
$string['activity'] = 'Activiteit';
$string['activity_grades'] = 'Activiteitscijfer';
$string['activity_name'] = 'Naam activiteit';
$string['activity_participation'] = 'Activiteitsdeelname';
$string['activity_progress'] = 'Activiteitsvoortgang';
$string['address'] = 'Adres';
$string['adm_dshb_adm_dashb_totals'] = 'Totalen';
$string['adm_dshb_course_enrollments_types'] = 'Cursus aanmeldingsmethodes';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Gebruiker aanmelding, Sessie, Voltooiing van activiteitlevels';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Cursus aanmeldingen met Voltooiingsoverzicht';
$string['adm_dshb_user_map'] = 'Gebruikersmap';
$string['adm_dshb_user_site_summary_details'] = 'Gebruikers site samenvatting details';
$string['admin_dashboard'] = 'Admin startpagina';
$string['adv_settings'] = 'Geavanceerde instellingen';
$string['ajax'] = 'Frequentie';
$string['ajax_desc'] = 'Sessie-opslagfrequentie via AJAX. 0 - AJAX uitgeschakeld (in seconden)';
$string['all_cohorts'] = 'Alle sitegroepen';
$string['all_courses'] = 'Alle cursussen';
$string['all_data'] = 'Alle data';
$string['all_fields_required'] = 'Alle verplichten velden';
$string['all_modules'] = 'Alle modules';
$string['all_time'] = 'Altijd';
$string['allmod'] = 'Alle activiteiten';
$string['analityc_3_name'] = 'Test overzicht & vragen detail';
$string['analytics'] = 'Analytics';
$string['answers'] = 'Antwoorden';
$string['api'] = 'Alternatieve API';
$string['api_desc'] = 'Gebruik een alternatieve API-server (om firewall blokkering te voorkomen)';
$string['assignment_name'] = 'Naam opdracht';
$string['assignments'] = 'Opdrachten';
$string['attendance'] = 'Aanwezigheid';
$string['attendanceapibase'] = 'Aanwezigheid API-basispad';
$string['attendanceapikey'] = 'Aanwezigheid API Key';
$string['attendanceapisecret'] = 'Aanwezigheid API Secret';
$string['attendanceconsumerkey'] = 'Consumentensleutel';
$string['attendancesharedsecret'] = 'Gedeeld geheim';
$string['attendancetoolurl'] = 'Tool-URL';
$string['authentication'] = 'Account aanmaken';
$string['authorized_user_descr'] = 'Voor IntelliBoard is een geautoriseerde gebruiker vereist. De geautoriseerde gebruiker is waarschijnlijk een sitebeheerder en moet rechten hebben om webservices, protocollen en tokens te beheren. Ga voor aanvullende controle naar Sitebeheer> Plugins> Webservices> Externe services> IntelliBoard-service> Geautoriseerde gebruiker';
$string['average_grade'] = 'gemiddelde cijfer';
$string['avg_score'] = 'Gemiddelde score';
$string['avg_time_spent_per_stud'] = 'Gemiddeld bestede tijd per leerling';
$string['avg_visits_per_stud'] = 'Gemiddeld aantal bezoeken per leerling';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API endpoint';
$string['bb_col_consumer_key'] = 'BlackBoard Collaborate consumentensleutel';
$string['bb_col_meetings'] = 'BlackBoard Collaborate bijeenkomsten';
$string['bb_col_secret'] = 'BlackBoard Collaborate geheim';
$string['bbbapiendpoint'] = 'BBB API endpoint';
$string['bbbmeetings'] = 'BigBlueButton bijeenkomsten';
$string['bbbserversecret'] = 'BBB servergeheim';
$string['billingcycles'] = 'Facturatie-cyclus';
$string['cache_compresstracking'] = 'Bewaar in Moodle cache';
$string['cachedef_bb_collaborate_access_token'] = 'BB collaborate toegang token';
$string['cachedef_instructor_course_data'] = 'Cache voor cursusdata';
$string['cachedef_reports_list'] = 'Cache voor rapportlijsten';
$string['cachedef_tracking'] = 'Intelliboard tracking gegevens';
$string['cancel_subscription'] = 'Annuleer abonnement';
$string['canceled'] = 'Geannuleerd';
$string['categories'] = 'Categorieën';
$string['category'] = 'Categorie';
$string['check_active_bb_col_meetings'] = 'Controleer actieve BlackBoard Collaborate bijeenkomsten';
$string['check_active_meetings'] = 'Controleer actieve bijeenkomsten';
$string['cipherlist'] = 'CURLOPT SSL CIPHER LIST';
$string['cipherlist_desc'] = 'Specifieke ciphers om te gebruiken voor TLS';
$string['city'] = 'Stad/Plaats';
$string['class_average'] = 'Klasgemiddelde';
$string['click_link_below_support_pages'] = 'Klik op de link hieronder voor toegang tot IntelliBoard support-pagina\'s:';
$string['close'] = 'Sluit';
$string['closed'] = 'Gesloten';
$string['cohorts'] = 'Sitegroepen';
$string['completed'] = 'Voltooid';
$string['completed_activities'] = 'Voltooide activiteiten';
$string['completed_activities_resources'] = 'Voltooide activiteiten/bronnen';
$string['completed_activities_resourses'] = 'Voltooide activiteiten/bronnen';
$string['completed_courses'] = 'Voltooide cursussen';
$string['completed_on'] = 'Voltooid op {$a}';
$string['completion'] = 'Voltooiing';
$string['completion_is_not_enabled'] = 'Voltooiing is niet ingeschakeld voor deze cursus';
$string['completion_not_enabled'] = 'Voltooiing niet Ingeschakeld';
$string['completion_status'] = 'Voltooiingsstatus';
$string['completions'] = 'Status activiteitsvoltooiing';
$string['completions_completed'] = 'Voltooiingsstatus (voltooid)';
$string['completions_desc'] = '1) De gebruiker heeft de activiteit voltooid. Er is niet aangegeven of iemand geslaagd of gezakt is.  <br>
2) De gebruiker heeft de activiteit voltooid met een cijfer hoger de geslaagd cijfer. <br>
3) De gebruiker heeft de activiteit voltooid maar met een cijfer dat lager is dan het ingestelde cijfer om te slagen.';
$string['completions_fail'] = 'Voltooiingsstatus (onvoldoende)';
$string['completions_pass'] = 'Voltooiingsstatus (geslaagd)';
$string['compresstracking'] = 'Comprimeer tracking';
$string['compresstracking_desc'] = 'Schrijf de tijd tracking data naar bestand of redis en stuur data naar de database met behulp van cron taak (standaard: elke 15 minuten)';
$string['confirm_and_sign_up'] = 'Bevestig en schrijf in';
$string['congratulations_intb_register'] = 'Gefeliciteerd';
$string['congratulations_intb_register_msg'] = 'Bedankt voor het starten van je gratis proefperiode van 15 dagen met IntelliBoard! Controleer je e-mail om je IntelliBoard-account te bevestigen. Gebruik om te beginnen de Single Sign On (SSO) -link, indien ingeschakeld via Sitebeheer> IntelliBoard, of log <a href="https://app.intelliboard.net/signin"> hier </a> in. De SSO-link leest als "INTELLIBOARD.NET" en bevindt zich in de rechterbovenhoek van het Dashboard. Neem voor vragen contact op met Support@IntelliBoard.net.';
$string['cor_incor_answers'] = 'juiste / foute antwoorden';
$string['correct'] = 'Juist';
$string['correct_number'] = 'Juist {$a}';
$string['correlations'] = 'Correlaties';
$string['country'] = 'Land';
$string['course'] = 'Cursus';
$string['course_activities'] = 'Inschakelen cursusactiviteiten';
$string['course_category'] = 'Cursuscategorie';
$string['course_chart'] = 'Inschakelen cursuskaart';
$string['course_completion_status'] = 'Cursus Voltooiingsstatus';
$string['course_completions'] = 'Cursusvoltooiingen';
$string['course_enrollment_types'] = 'Cursus aanmeldingsmethode';
$string['course_enrollments_with_completion_overview'] = 'Cursusaanmeldingen met voltooiingsoverzicht';
$string['course_grade'] = 'Cursuscijfer';
$string['course_idnumber'] = 'ID-Nummer';
$string['course_max_grade'] = 'Cursus max. cijfer';
$string['course_name'] = 'Cursusnaam';
$string['course_name_a'] = 'Cursus: {$a}';
$string['course_overview'] = 'Cursusoverzicht';
$string['course_progress'] = 'Cursusvoortgang';
$string['course_short_name'] = 'Cursus korte naam';
$string['course_start_date'] = 'Cursus startdatum';
$string['course_started'] = 'Begindatum van de cursus';
$string['course_status'] = 'Status';
$string['course_success'] = 'Cursus succes';
$string['courseaverage'] = 'Cursus gemiddelde';
$string['courses'] = 'Cursussen';
$string['courses_avg_grade'] = 'Cursus gemiddelde cijfer';
$string['courses_in_progress'] = 'Cursussen die uitgevoerd worden';
$string['courses_sum_grade'] = 'Cursus som cijfer per cijferschaalwaarde';
$string['coursessessions'] = 'Cursus sessies';
$string['coursessessionspage'] = 'Cursus sessies pagina';
$string['created'] = 'Gemaakt';
$string['criteria_all_courses'] = 'Alle volgende cursussen moeten worden afgerond';
$string['criteria_any_course'] = 'Elk van de volgende cursussen moet worden afgerond';
$string['criteria_method'] = 'Criteria methode';
$string['csv'] = 'CSV';
$string['current_grade'] = 'Huidige cijfer';
$string['customod'] = 'Aangepaste activiteiten';
$string['daily'] = 'Laatste 10 dagen';
$string['dashboard'] = 'Startpagina';
$string['dashboard_settings'] = 'Startpagina instellingen';
$string['date_created'] = 'Datum aangemaakt';
$string['date_format'] = 'Datum opmaak';
$string['debug'] = 'Foutopsporing CURL-verzoeken';
$string['delete_message'] = 'Verwijder SQL-rapport?';
$string['department'] = 'Afdeling';
$string['details'] = 'Details';
$string['disable_time_and_visits_users_overview'] = 'Schakel tijd en bezoeken uit in het gebruikersoverzicht.';
$string['disabled'] = 'Uitsgeschakeld';
$string['do_not_use_compresstracking'] = 'Comprimeer tracking niet';
$string['done'] = 'Klaar!';
$string['downloadinvoice'] = 'Download factuur';
$string['due_date'] = 'Vervaldatum';
$string['email'] = 'E-mail';
$string['email_is_required'] = 'E-mail is verplicht';
$string['email_subscr'] = 'Abonnement e-mail';
$string['enable_badges_report'] = 'Schakel "Badges" rapport in';
$string['enable_bb_col_debug'] = 'Schakel BlackBoard Collaborate debuggin in';
$string['enable_bb_col_meetings'] = 'Schakel BlackBoard Collaborate bijeenkomsten in';
$string['enable_sso'] = 'Schakel Single SIgn On (SSO) Link in';
$string['enable_sso_descr'] = 'Schakel Single Sign On-link in voor toegang met één klik voor sitebeheerders tot de IntelliBoard SuperAdmin-toegang op app.intelliboard.net';
$string['enable_time_and_visits_users_overview'] = 'Schakel tijd en bezoeken in, in het gebruikersoverzicht.';
$string['enable_time_tracking'] = 'Inschakelen tijdsregistratie';
$string['enable_time_tracking_descr'] = 'Schakel tijdsregistratie in voor aanvullende inzichten over gebruikerstoegang, bezoeken en bestede tijd. IntelliBoard biedt aanvullende inzichten over tijdregistratie afzonderlijk van de Moodle-tijdbestedingstabellen';
$string['enable_transcripts'] = 'Inschakelen transcripts';
$string['enable_webservice'] = 'Inschakelen webservices';
$string['enableattendance'] = 'Schakel aanwezigheid in';
$string['enablebbbdebug'] = 'BigBlueButton debug modus';
$string['enablebbbmeetings'] = 'Schakel monitoring van BigBlueButton bijeenkomsten in';
$string['enabled'] = 'Volgen ingeschakeld';
$string['enabled_desc'] = 'Schakel Volgen in';
$string['enablesyncattendance'] = 'Synchronisatie van BB Collaborate-sessies met InAttendance inschakelen';
$string['enroled_on'] = 'Aanmeldingsdatum';
$string['enrolled'] = 'Aangemeld';
$string['enrolled_completed'] = 'Aangemeld: {$a->courses}, Voltooid: {$a->completed_courses}';
$string['enrolled_completed_learners'] = 'Aangemelde/Voltooide leerlingen';
$string['enrolled_date'] = 'Aanmelddatum';
$string['enrolled_users_completed'] = 'Aangemeld gebruikers: {$a->courses}, Voltooid: {$a->completed_courses}';
$string['enrollments'] = 'Aangemeldingen';
$string['enrolment_expiration'] = 'Aanmelding vervaldatum';
$string['enrolment_method'] = 'Aanmeldingsmethode';
$string['enter_course_and_quiz'] = 'Selecteer jouw cursus en test.';
$string['enter_quiz'] = 'Selecteer jouw test.';
$string['excel'] = 'Excel';
$string['expired'] = 'Vervallen';
$string['failed'] = 'Gefaald';
$string['failed_on'] = 'Voltooid (gefaald) op {$a}';
$string['file_compresstracking'] = 'Bewaar naar MoodleData';
$string['filter1'] = 'Verwijderde gebruikers';
$string['filter1_desc'] = 'Toon verwijderde gebruikers';
$string['filter2'] = 'Geschorste gebruikers';
$string['filter2_desc'] = 'Toon geschorste gebruikers';
$string['filter3'] = 'Gastgebruiker';
$string['filter3_desc'] = 'Toon [gast] gebruikers in de rapportage';
$string['filter4'] = 'Cursusfilter';
$string['filter4_desc'] = 'Toon verborgen cursussen';
$string['filter5'] = 'Aanmeldingsmethode-filter';
$string['filter5_desc'] = 'Toon niet actieve aanmeldingsmethodes';
$string['filter6'] = 'Gebruikersaanmelding-filter';
$string['filter6_desc'] = 'Toon gebruikers die geen actieve aanmeldingsstatus hebben';
$string['filter7'] = 'Activiteiten/bronnen-filter';
$string['filter7_desc'] = 'Toon verborgen Activiteiten/bronnen';
$string['filter8'] = 'Filter aangemelde gebruikers';
$string['filter8_desc'] = 'Toon alleen aangemelde gebruikers (raden we niet aan)';
$string['filter_all_time'] = 'Tijdfilter: altijd';
$string['filter_dates'] = 'Filter datums:';
$string['filter_last_year'] = 'Tijdfilter: Vorig Jaar';
$string['filter_this_year'] = 'Tijd filter: Dit jaar';
$string['filters'] = 'Startpagina filters';
$string['first_access'] = 'Eerste toegang';
$string['first_name'] = 'Voornaam';
$string['firstname_lastname'] = '{First Name} {Last Name}';
$string['goal_grade'] = 'Doelcijfer';
$string['grade'] = 'Cijfer';
$string['grade_activities_overview'] = 'Beoordeelde Activiteiten Overzicht';
$string['graded'] = 'Beoordeeld';
$string['grades'] = 'Cijfers';
$string['grades_alt_text'] = 'Alternatieve tekst voor navigatie menu';
$string['grid_view'] = 'Rasterweergave';
$string['group_aggregation'] = 'Groepaggregatie';
$string['help'] = 'Hulp nodig?';
$string['highest_grade'] = 'Hoogste cijfer';
$string['hosting_provider'] = 'Hosting-provider';
$string['ianalytics'] = 'IntelliBoard Analytics';
$string['id_number'] = 'ID-Nummer';
$string['import'] = 'Importeer';
$string['importing_logs'] = 'Importeren logs';
$string['importing_totals'] = 'Importeren totalen';
$string['importtrackingtask'] = 'Importeer tracking-taak';
$string['in1'] = 'Overzicht';
$string['in10'] = 'Event gebruik';
$string['in11'] = 'Voortgang leerling';
$string['in12'] = 'Cijfervoortgang';
$string['in13'] = 'Bestede tijd (%)';
$string['in14'] = '% voortgang';
$string['in15'] = 'Aantal leerling voltooiingen';
$string['in16'] = 'Laatste toegang';
$string['in17'] = 'Totaal bestede tijd';
$string['in18'] = 'Totaal aantal bezoeken.';
$string['in19'] = 'Gem. cIjfer';
$string['in2'] = 'Huidige voortgang';
$string['in20'] = 'Ga terug naar leerlingen';
$string['in201'] = 'Ga terug naar activiteiten';
$string['in21'] = 'Cursus gem. cijfer';
$string['in22'] = 'Ingeschakeld';
$string['in23'] = 'Je hebt geen leerlingen om te tonen';
$string['in24'] = 'Module';
$string['in25'] = 'Geslaagd cijfer';
$string['in26'] = 'Betrokkenheid leerling';
$string['in27'] = 'Totaal aantal leerlingen';
$string['in28'] = 'Gemiddeld bestede tijd';
$string['in29'] = 'Actieve leerlingen';
$string['in3'] = 'Totaal aantal cursussen';
$string['in30'] = 'Niet actieve leerlingen';
$string['in31'] = 'Activiteitsgebruik';
$string['in32'] = 'Gemiddelde tijd in een geselecteerde periode';
$string['in33'] = 'Onderwerp gebruik';
$string['in34'] = 'Voortgang leerlingcijfer';
$string['in4'] = 'Totaal aantal lerenden';
$string['in5'] = 'Totaal aantal cursuscijfers';
$string['in6'] = 'Leerlingen voltooid';
$string['in7'] = 'Leerlingen onvoltooid';
$string['in8'] = 'Gemiddelde cijfer van leerling';
$string['in9'] = 'Correlaties';
$string['inactivity'] = 'Inactiviteit';
$string['inactivity_desc'] = 'Gebruiker inactieve tijd  (in seconden)';
$string['incomplete'] = 'Onvolledig';
$string['incorrect'] = 'Fout';
$string['incorrect_number'] = 'Fout {$a}';
$string['initial_reports'] = 'Eerste rapporten';
$string['initial_reports_warning'] = 'Klik op "<a href="{$a}"> Verbind & upgrade </a>" om deze rapporten te e-mailen, te plannen en verder te personaliseren.';
$string['inprogress'] = 'Voortgang bezig';
$string['institution'] = 'Insituut';
$string['instructor_course_shortname'] = 'Toon cursus korte naam in plaats van cursus volledige naam';
$string['instructor_course_visibility'] = 'Toon verborgen/geschorste cursussen voor [leraar]';
$string['instructor_courses_table_name'] = 'Cursuscijfers';
$string['instructor_courses_table_name_activities'] = 'Cursus {$a->fullname}, activiteiten';
$string['instructor_courses_table_name_activity'] = 'Cursus {$a->course}, activiteit {$a->name}, cijfers';
$string['instructor_courses_table_name_learner'] = 'Cursus {$a->course}, Leerling {$a->learner}, Cijfers';
$string['instructor_courses_table_name_learners'] = 'Cursus {$a->fullname}, Leerlingen';
$string['instructor_custom_groups'] = 'Leraar aangepaste groepen';
$string['instructor_hide_need_help'] = 'Verberg "hulp nodig" knop';
$string['instructor_mode'] = 'Toon alle cursussen beschikbaar voor [leraar]';
$string['instructor_mode_access'] = 'Toon alle cursussen beschikbaar voor [leraar] met [bijgewerkte] rechten';
$string['instructor_redirect'] = 'Leraar doorverwijzing';
$string['instructor_show_suspended_enrollments'] = 'Toon geschorste aanmeldingen';
$string['intb_settings_descr'] = 'Voor IntelliBoard is één belangrijk, uniek abonnement e-mailadres vereist. Voer hieronder het e-mailadres in dat je wilt gebruiken als e-mailadres voor je abonnement. De e-mail moet vóór gebruik dubbel worden geverifieerd via een e-mailbevestiging. Neem voor vragen contact op met <a href=\'mailto:Support@IntelliBoard.net\'> Support@IntelliBoard.net </a>. Ga voor een volledige lijst van IntelliBoard-instellingen naar Sitebeheer> Plugins> Lokale plugins> IntelliBoard';
$string['intelliBoard_migration_tool'] = 'IntelliBoard migratie-tool';
$string['intelliBoard_migration_tool_info'] = 'De IntelliBoard-migratietool wordt gebruikt om historische gegevens uit de Moodle-logs-tabel naar een nieuw formaat te migreren. Hou er rekening mee dat de Moodle-logboeken-opslagprocedure niet verandert. Zodra historische gegevens zijn gemigreerd naar een nieuw formaat, zijn de historische waarden zoals \'Bestede tijd\' en \'Bezoeken\' beschikbaar als voorbeeld op IntelliBoard.net.';
$string['intelliboard:attendanceadmin'] = 'Aanwezigheid beheer';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [blader door alle site-groepen]';
$string['intelliboard:competency'] = 'IntelliBoard [competenties]';
$string['intelliboard:instructors'] = 'IntelliBoard [leraar]';
$string['intelliboard:manage'] = 'IntelliBoard [beheer]';
$string['intelliboard:students'] = 'Intelliboard [leerling]';
$string['intelliboard:view'] = 'IntelliBoard [bekijk]';
$string['intelliboard_logs'] = 'Intelliboard logs';
$string['intelliboard_reports'] = 'Intelliboard-rapporten';
$string['intelliboard_settings'] = 'IntelliBoard Instellingen';
$string['intelliboard_start_tracking'] = 'IntelliBoard start volgen';
$string['intelliboard_terms'] = 'IntelliBoard overeenkomsten';
$string['intelliboard_totals'] = 'IntelliBoard totalen';
$string['intelliboard_tracking'] = 'IntelliBoard volgen';
$string['intelliboardaccess'] = 'Je hebt niet de rechten om deze pagina te bekijken. Neem contact op met je site-beheerder voor assistentie.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intellicart'] = 'IntelliCart integratie';
$string['intellicart_app_reports_integration'] = 'Integratie met IntelliBoard rapportage';
$string['intellicart_desc'] = 'Sta leerlingen toe om IntelliCart rapporten te zien.';
$string['intellicart_instructor_integration'] = 'Integratie met leraren startpagina';
$string['intellicart_student_integration'] = 'Integratie met leerling startpagina';
$string['invalid_email'] = 'Ongeldige e-mail';
$string['invalid_user'] = 'Ongeldige gebruiker';
$string['issuer'] = 'Gebruiker';
$string['items_per_query'] = 'Items per zoekopdracht';
$string['join_a_webinar'] = 'Deelnemen aan een Webinar';
$string['key'] = 'Sleutel';
$string['last_access'] = 'Laatste toegang';
$string['last_access_on_course'] = 'Laatste toegang tot cursus';
$string['last_day'] = 'dag';
$string['last_hour'] = 'uur';
$string['last_month'] = 'Laatste 30 Dagen';
$string['last_name'] = 'Achternaam';
$string['last_quarter'] = 'Laatste 3 maanden';
$string['last_semester'] = 'Laatste 6 maanden';
$string['last_week'] = 'Laatste 7 dagen';
$string['last_year'] = 'Afgelopen jaar';
$string['lastname_firstname'] = '{Voornaam} {Achternaam}';
$string['learner_menu'] = 'Toon "Leerlingen startpagina" in navigatie blok menu voor aangemelde leerlingen.';
$string['learner_name'] = 'Naam van leerling';
$string['learner_tf_last_week'] = 'Tijd filter: 7 Dagen';
$string['learners'] = 'Leerlingen';
$string['learners_enrolled'] = 'Leerlingen aangemeld';
$string['learners_enrolled_period'] = 'Aangemelde leerlingen binnen geselecteerde periode';
$string['learning'] = 'Studeren';
$string['learning_plan_filter'] = 'Studieplan filter';
$string['learning_plan_viewer_role'] = '"Studieplan Bekijker" rol';
$string['learning_progress'] = 'Leervoortgang';
$string['letter'] = 'Letter';
$string['list_view'] = 'Lijstweergave';
$string['load'] = 'Prestatie';
$string['loading'] = 'Laden...';
$string['loading2'] = 'Even geduld, laden...';
$string['log_values_include'] = 'Log-waarden inclusief logs van elke gebruiker per dag.';
$string['logs'] = 'Migratie-tool';
$string['logs_to_process'] = 'Te verwerken logs {$a}';
$string['lowest_grade'] = 'Laagste cijfer';
$string['messageprovider:intelliboard_notification'] = 'Intelilboard melding';
$string['messages'] = 'Berichten';
$string['modulename'] = 'Naam module';
$string['modules'] = 'Modules';
$string['monitors'] = 'Monitoren';
$string['monitorselect'] = 'Selecteer ten minste één monitor van App.IntelliBoard.net. Klik op "Monitors" en vervolgens op "Monitors instellingen" en selecteer deze in "Zichtbaar in Moodle".';
$string['monthly'] = 'Laatste 365 dagen';
$string['moodle'] = 'Moodle';
$string['moodle_logs'] = 'Moodle logs';
$string['moodle_settings'] = 'Moodle Instellingen';
$string['more_courses'] = 'Meer cursussen';
$string['more_users'] = 'Meer gebruikers';
$string['my_course_average_all'] = 'Mijn cursusgemiddelde (alle cursussen)';
$string['mygrade'] = 'Mijn cijfer';
$string['myorders'] = 'Bestellingen';
$string['myprogress'] = 'Mijn cijfer voortgang';
$string['myseats'] = 'Plaatsen';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlmonth'] = '%c';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlquarter'] = 'kwartaal';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlyear'] = '%Y';
$string['mysubscriptions'] = 'Abonnementen';
$string['mywaitlist'] = 'Wachtlijst';
$string['n1'] = 'Overzicht [leerling voortgang]';
$string['n10'] = 'Leraren startpagina';
$string['n101'] = 'Schakel leraren startpagina in';
$string['n11'] = 'Alternatieve test voor navigatieblock-menu';
$string['n12'] = 'Overzicht [Cursus Overzicht]';
$string['n13'] = 'Totaal aantal leerlingen';
$string['n14'] = 'Widget: leerlingbetrokkenheid';
$string['n15'] = 'Widget: gebruik van activiteiten';
$string['n16'] = 'Widget: Onderwerp gebruik';
$string['n17'] = 'Analytics-pagina';
$string['n18'] = 'Widget: Leerling cijfervoortgang';
$string['n19'] = 'Navigatie link in cursussen naar rapporten';
$string['n2'] = 'Overzicht [Cijfervoortgang]';
$string['n3'] = 'Overzicht [Activiteitsvoortgang]';
$string['n4'] = 'Overzicht [Totalen]';
$string['n5'] = 'Huidige voortgang';
$string['n6'] = 'Widget: correlaties';
$string['n7'] = 'Widget: gebruik van gebeurtenissen';
$string['n8'] = 'Cursuspagina';
$string['n9'] = 'Rapporten pagina';
$string['name'] = 'Naam';
$string['names_order'] = 'Namen volgorde';
$string['next'] = 'Volgende';
$string['no_competency'] = 'Het lijkt erop dat je competenties niet hebt ingeschakeld op jouw Moodle site.';
$string['no_data'] = 'Geen gegevens';
$string['no_data_notification'] = 'Er zijn geen nieuwe gegevens voor [date]';
$string['not_connected'] = 'Niet verbonden';
$string['not_quiz'] = 'Oeps, het lijkt erop dat je geen testen aangemaakt hebt voor de geselecteerde cursus.';
$string['notstarted'] = 'Niet gestart';
$string['num_attempts'] = '# van pogingen';
$string['num_completed_activity'] = '# van gebruikers die deze activiteit voltooid hebben.';
$string['number_of_completed_learners'] = '# van Voltooide gebruiker(s)';
$string['number_of_learners'] = '# van aangemelde gebruiker(s)';
$string['number_of_modules'] = '# van activiteit(en)';
$string['number_of_sessions'] = 'Aantal sessies';
$string['number_of_visits'] = 'Bezoek(en)';
$string['number_this_week'] = '{$a} deze week';
$string['number_today'] = '{$a} vandaag';
$string['numberofseats'] = 'Aantal plaatsen';
$string['ok'] = 'Ok';
$string['overall_course_average'] = 'algemeen cursusgemiddelde (alle leerlingen;alle cursussen)';
$string['participation'] = 'Deelname';
$string['passed'] = 'Geslaagd';
$string['passed_on'] = 'Voltooid (geslaagd) op {$a}';
$string['passing_score_for'] = 'Geslaagde cijfer voor {$a}';
$string['password'] = 'Wachtwoord';
$string['pdf'] = 'PDF';
$string['percentage_completed_learners'] = 'Percentage voltooide leerlingen';
$string['please_accept_terms_and_conditions'] = 'Accepteer de algemene voorwaarden';
$string['please_wait_or_cancel'] = 'Wacht om door te gaan of <a href="{$a}"> annuleer </a>';
$string['pluginname'] = 'IntelliBoard.net plugin';
$string['postgredaymonth'] = 'DD Ma JJJJ';
$string['postgredayshortmonthyear'] = 'DD Ma, JJJJ';
$string['postgrehour'] = 'UU 12:MI AM';
$string['postgremonth'] = 'MM';
$string['postgremonthdayyear'] = 'MM/DD/JJJJ';
$string['postgremonthyear'] = 'Maand JJJJ';
$string['postgremonthyearday'] = 'Maand JJJJ,DD';
$string['postgrequarter'] = 'kwartaal';
$string['postgrequarteryear'] = 'Q JJJJ';
$string['postgretimedate'] = 'UU12:MIAM, DD Ma JJJJ';
$string['postgretimemonthdayyear'] = 'UU24 MM/DD/JJJJ';
$string['postgreweek'] = 'JJJJ, "week" WW';
$string['postgreyear'] = 'JJJJ';
$string['powered_by'] = 'Aangeboden door <a href="https://intelliboard.net/">IntelliBoard.net</a>';
$string['price'] = 'Prijs';
$string['privacy:metadata:local_intelliboard_assign'] = 'IntelliBoard assigns-subaccount tabel';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'Verbonden Moodle Instantie-ID';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Rel type van record';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Legt Tijdstip vast';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodle Instantie-type';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'USER ID van record';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Lijst of gesynchroniseerde sessies';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Aanvullende sync data';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID vab sync log';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle sessie ID';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Sessie soort';
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Lijst van deelnemers aan samenwerkingssessie.';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Gebruikersnaam';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Bestede tijd aan sessie';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'Gebruiker ID (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Eerste deelname aan een sessie';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID van sessie-deelname';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Laatste keer sessie verlaten';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Aantal keren terugkeren in sessie';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Sessie-rol';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Sessie-UUID';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'Gebruiker-UUID (BlackBoard Collaborate Services)';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Lijst met bijgehouden sessies';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID van tracklog';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Sessie-UUID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Gevolgde tijd';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Log aanwezigen tijdens een BigBlueButton bijeenkomsten';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Tijd waarop een gebruiker verbinding maakte met de sessie';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Tijd waarop de verbinding van een gebruiker verbroken werd met een sessie';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Volledige naam van aanwezige deelnemer';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Vlag. Aanwezige heeft de microfoon aangesloten';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Vlag. Aanwezige heeft webcamera aangesloten';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'Aanwezige ID';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Vlag. Aanwezige heeft geeft microfoon of webcamera aangesloten.';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Vlag. Aanwezige is presentator';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'Meeting-ID (ID in tabel local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'Meeting-ID (ID in BigBlueButton-server)';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Rol van deelnemer bijeenkomst';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'User-ID (in tabel rij "user")';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Log BigBlueButton bijeenkomsten';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Het wachtwoord dat deelnemers nodig hebben om deel te nemen aan de bijeenkomst';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'Row-ID in tabel bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'Cursus module-ID';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'Cursus-ID';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Maak datum (string)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Maak tijd (tijdstip)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Het telefoonnummer dat deelnemers kunnen inbellen met een normaal telefoontoestel.';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Bijeenkomstduur';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Tijdstip einde van bijeenkomst';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Vlag. Bijeenkomst is gedwongen beeïndigd';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Vlag. Gebruikers namen deel aan de bijeenkomst';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID van bijeenkomst log';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'Interne (in BBB-server) Bijeenkomst-ID';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Aantal luisteraars';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Maximaal aantal deelnemers';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'Bijeenkomst-ID';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Bijeenkomst naam';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Aantal moderators';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Het wachtwoord dat nodig is voor moderators om deel te nemen aan de vergadering of voor bepaalde administratieve handelingen';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'Eigenaar-ID (gebruiker die de bijeenkomst heeft aangemaakt)';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Aantal deelnemers';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Vlag. Bijeenkomst zal opgenomen worden';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Status bijeenkomst (actief | gestopt)';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Start-tijd van bijeenkomst';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Aantal deelnemers met verbonden video-camera';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Het toestelnummer voor de spraakbrug (gebruik indien verbonden met het telefoonsysteem)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Aantal deelnemers met verbonden microfoons';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/logs/per-uur-tabel';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'Tabel ID [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'Het uur';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'De hoeveelheid tijd besteed per uur';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Totaal aantal bezoeken, muisklikken, per dag.';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/logs/per-uur-tabel';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Tijdstip van dag in jaar';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Gespendeerde tijd, per dag';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'Het ID van de tabel [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Bezoeken, muisklikken, per dag.';
$string['privacy:metadata:local_intelliboard_ntf'] = 'IntelliBoard notificaties hoofdtabel';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Notificatiebijlage';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Notificatie CC';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Notificatie e-mail';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Notificatie externalNID';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'Notificatie-ID';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Notificatiebericht';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Notificatiestatus';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Notificatieonderwerp';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Notificatie-tags';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Notificatietype';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Notificatie ExternalAppID';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'IntelliBoard notificatie geschiedenistabel';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Notificatiegeschiedenis e-mail';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'Notificatiegeschiedenis-ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Notificatie-ID';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Notificatienaam';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Notificatiegeschiedenis tijdsstip';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Notificatie externalAppID';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'IntelliBoard notificaties dynamische parameterstabel';
$string['privacy:metadata:local_intelliboard_reports'] = 'IntelliBoard aangepaste SQL rapportentabel';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Naam gepersonaliseerd rapport';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64 geëncodeerde SQL-code';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Status rapport - geactiveerd / niet geactiveerd';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Aangemaakt op';
$string['privacy:metadata:local_intelliboard_totals'] = 'IntelliBoard alt/logs/totale tabel';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Totaal aantal cursussen in Moodle';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Totaal aantal gebruikerssessies in Moodle';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Tijdstempel van dag in jaar';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Totaal tijd gebruikers in Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Totaal aantal bezoeken van alle Ssers in Moodle';
$string['privacy:metadata:local_intelliboard_tracking'] = 'IntelliBoard alt/logs/altijd tabel';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Het cursus id dat bezocht is door de gebruiker.';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Gebruikers eerste inlog';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Gebruikers laatste inlog';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Paginatype [cursus,module,profiel,set]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Pagina-ID type';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Gebruikers tijdsbesteding op een pagina';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Browsertype van gebruikers';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'Het gebruikers ID dat de Moodle pagina bezocht heeft.';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Gebruikers laatste IP-adres';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Gebruikers browser-taal';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Gebruikers besturingssysteem';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Gebruikersbezoeken op een pagina.';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transcripts cursus-records';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Voltooiingsdatum';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Cursus-ID';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Cursus volledige naam';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Aanmeldingsdatum';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Aanmelding record-ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Aanmeldingsmethode';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Eindcijfer';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Voornaam gebruikers';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Opgemaakt cijfer';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'Cijfer Cijfer ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Cijfer Item ID';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Max cijfer';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Min cijfer';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Gebruikersgroepen';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Achternaam gebruiker';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Rollen gebruiker';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transcript status';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Tijdstip waaarop record is aangemaakt';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Tijdstip wanneer record de vorige keer is bijgewerkt';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Uitschrijfdatum';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Gebruiker e-mail';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transcript gebruiker aanmeldings-ID';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'Gebruikers-ID';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transcript cursussen records';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Cursus module-ID';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Voltooiingdatum';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Cursus-ID';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Eindcijfer';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Opgemaakt cijfer';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Cijfer cijfer-ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Cijfer Item-ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Max-cijfer';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Min-cijfer';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Module-ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Activiteitsnaam';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Moduletype';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Startdatum';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Status';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Tijdstip waarop record is aangemaakt';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Tijdstip waarop record de laatste keer was bijgewerkt';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Vertaalt aangemeld-ID gebruiker';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'Gebruiker-ID';
$string['privacy_msg'] = 'Door dit vakje aan te vinken, bevestig je dat je ons privacybeleid hebt gelezen en ermee akkoord gaat.';
$string['privacy_policy'] = 'Privacybeleid';
$string['privacy_shield_policy'] = 'Addendum voor gegevensverwerking';
$string['process'] = 'Proces';
$string['product'] = 'Product';
$string['progress'] = 'Voortgang';
$string['protocol'] = 'Protocol';
$string['protocol_descr'] = 'Voor IntelliBoard moet REST of SOAP-protocol zijn ingeschakeld. Om veiligheidsredenen mogen alleen protocollen die in gebruik zijn worden ingeschakeld. Ga voor aanvullende controle naar Sitebeheer> Plugins> Webservices> Beheer Protocols';
$string['protocols_descr'] = 'Voor IntelliBoard moet REST of SOAP-protocol zijn ingeschakeld. Om veiligheidsredenen mogen alleen protocollen die in gebruik zijn worden ingeschakeld. Ga voor aanvullende controle naar Sitebeheer> Plugins> Webservices> Beheer Protocols';
$string['ques_breakdown'] = 'Vraagverdeling';
$string['quiz_finished'] = 'Test afgerond';
$string['quiz_grades'] = 'Testcijfers';
$string['quiz_name'] = 'Naam toets';
$string['quiz_name_a'] = 'Test: {$a}';
$string['quizzes'] = 'Testen';
$string['recurringperiod'] = 'Terugkerende periode';
$string['registered'] = 'Geregistreerd';
$string['registrations'] = 'Registraties';
$string['remove_message'] = 'SQL-rapport is verwijderd';
$string['report'] = 'Rapport';
$string['report1_name'] = 'Gebruikersstatus';
$string['report2_name'] = 'Cursusstatus';
$string['report3_name'] = 'Samenvatting activiteitsstatistieken';
$string['report45_name'] = 'Test activiteitsdetails';
$string['report_activity_stats_summary'] = 'Samenvatting activiteitsstatistieken';
$string['report_user_profile_information'] = 'Informatie gebruikersprofiel';
$string['reports'] = 'Rapporten';
$string['reportselect'] = 'Selecteer ten minste één rapport van App.IntelliBoard.net. Klik op een rapport en vervolgens op "Rapportinstellingen" en selecteer het in "Zichtbaar in Moodle".';
$string['rest'] = 'REST';
$string['return_to_courses'] = 'Terug naar cursussen';
$string['return_to_grades'] = 'Ga terug naar cijfers';
$string['return_to_home'] = 'Ga terug naar startpagina';
$string['return_to_sessions'] = 'Ga terug naar sessies';
$string['review_support_doc'] = 'Bekijk ondersteunende documentatie';
$string['role1'] = 'Eerste rol';
$string['role2'] = 'Tweede rol';
$string['s25'] = 'Bestede tijd op een activiteit';
$string['s45'] = 'Activiteit';
$string['s46'] = 'Percentage pogingen van leerlingen';
$string['s47'] = 'Onderwerp';
$string['s48'] = 'Bestede tijd op een onderwerp';
$string['save'] = 'Bewaren';
$string['scale_percentage'] = 'Percentage';
$string['scale_percentage_round'] = 'Percentage afgerond';
$string['scale_raw'] = 'Schalen uitschakelen';
$string['scale_real'] = 'Toon echt cijfer i.p.v. percentage';
$string['scale_total'] = 'Totaalcijfer';
$string['scale_value'] = 'Waarde';
$string['scales'] = 'Aangepaste schaal inschakelen';
$string['scalesettings'] = 'Instellingen schalen';
$string['score'] = 'Cijfer';
$string['seatnumber'] = 'Aantal plaatsen';
$string['seatscode'] = 'Plaats code';
$string['seatsused'] = 'Bezette plaatsen';
$string['section'] = 'Sectie';
$string['sections'] = 'Secties';
$string['select'] = 'Selecteer';
$string['select_course'] = 'Selecteer cursus';
$string['select_date'] = 'Selecteer datum';
$string['select_manager_role'] = 'Selecteer manager rol';
$string['select_quiz'] = 'Selecteer test';
$string['select_user'] = 'Selecteer gebruiker';
$string['selectall'] = 'Selecteer alle';
$string['self_hosted'] = 'Zelf-gehost';
$string['server'] = 'IntelliBoard Server';
$string['server_au'] = 'IntelliBoard Australië';
$string['server_error'] = 'Oeps! Er is iets onverwachts gebeurd. Neem contact met ons op via support@intelliboard.net';
$string['server_eu'] = 'IntelliBoard Europa';
$string['server_usa'] = 'IntelliBoard VS';
$string['session_name'] = 'Naam sessie';
$string['session_time'] = 'Sessie-tijd';
$string['settings'] = 'Instellingen';
$string['setup'] = 'Verbind nu';
$string['setup_subheading'] = 'Maak verbinding om de kracht van jouw gegevens te ervaren. Geen creditcard. Geen verplichting. Slechts 15 dagen gratis data-zaligheid.';
$string['shield_msg'] = 'Door dit vakje aan te vinken, bevestig je dat je ons addendum voor gegevensverwerking hebt gelezen en ermee akkoord gaat.';
$string['show_dashboard_tab'] = 'Startpagina pagina';
$string['showing_1_to_10'] = '1 van 10 tonen';
$string['sign_in'] = 'Inloggen';
$string['sign_up'] = 'Inschrijven';
$string['sizemode'] = 'Site-modus: groot ( > 5000 gebruikers)';
$string['soap'] = 'SOAP';
$string['sqlreport'] = 'SQL-rapport';
$string['sqlreportactive'] = 'Geactiveerd';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportcreate'] = 'Maak rapport';
$string['sqlreportdate'] = 'Gemaakt op';
$string['sqlreportinactive'] = 'Uitgeschakeld';
$string['sqlreportname'] = 'Naam rapport';
$string['sqlreports'] = 'SQL-rapporten';
$string['sslversion'] = 'CURLOPT SSLVERSION';
$string['sslversion_desc'] = 'Geef een parameter long door om te bepalen welk versiebereik van SSL / TLS-versies moet worden gebruikt';
$string['sso'] = 'SSO-link';
$string['sso_desc'] = 'SSO-link naar Intelliboard.net';
$string['ssodomain'] = 'Subdomein SSO';
$string['ssodomain_desc'] = 'Single Sign On met aparte Server/Account';
$string['ssomenu'] = 'SSO Menu-item';
$string['ssomenu_desc'] = 'SSO-link in navigatieblok menu (voor niet-lerende/niet-docerende)';
$string['status'] = 'Status';
$string['student_course_visibility'] = 'Toon verborgen cursussen voor [leerling]';
$string['student_grades'] = 'Cijfers leerling';
$string['student_redirect'] = 'Leerling redirect';
$string['subscriptiondate'] = 'Inschrijvingsdatum';
$string['success_message'] = 'SQL-rapport is bewaard';
$string['successfull_connected'] = 'Succesvol verbonden';
$string['support'] = 'Ondersteuning';
$string['support_close'] = 'Sluit';
$string['support_connect'] = 'Klik op de rapportknoppen in de onderstaande rechthoek. Krijg een glimp van de kracht van IntelliBoard: toegang met 1 knop tot jouw LMS-inzichten. Wil je meer? Klik op "Klik om Analytics te bekijken". Wil je nog meer? <a href="{$a-> connect_link} ">" Connect & Upgrade "</a> in de rechterbovenhoek, of waar je de link ook ziet.';
$string['support_demo'] = 'Plan een Demo';
$string['support_info1'] = 'Je kan deelnemen aan onze <a target=\'_blank\' href=\'https://intelliboard.net/events\'> Webinars </a> terwijl we je meenemen op een rondleiding door IntelliBoard 5.0-rapportage en -analyse!';
$string['support_info2'] = 'Neem deel aan onze <a target=\'_blank\' href=\'https://intelliboard.net/events\'> Webinars </a> of plan een persoonlijke rondleiding door jouw eigen gegevens. Met onze ondersteuning en service van wereldklasse ziet je jouw LMS in een geheel nieuw licht.';
$string['support_page'] = 'Bekijk documentatie';
$string['support_terms'] = 'Alle rechten voorbehouden.';
$string['support_text1'] = 'Al jouw Moodle-gegevens: eenvoudig, deelbaar, begrijpelijk en aantrekkelijk. IntelliBoard is een Moodle-plug-in die je <strong> 120+ </strong> rapporten en monitoren in handen geeft.';
$string['support_text2'] = 'Al jouw Moodle-gegevens: eenvoudig, deelbaar, begrijpelijk en aantrekkelijk. IntelliBoard is jouw Moodle-oplossing voor rapportage en analyse en biedt je meer dan 120 rapporten en analyses om jouw educatieve zakelijke beslissingen te helpen onderbouwen.';
$string['support_text3'] = 'Welkom bij IntelliBoard! Instellingen wereldwijd gebruiken IntelliBoard om bewaring, voortgang, voltooiing en betrokkenheid te bewaken. Al jouw LMS-gegevens in gemakkelijk vindbare, intuïtieve, deelbare, begrijpelijke en aantrekkelijke rapporten en grafieken.';
$string['support_text4'] = 'De IntelliBoard-plug-in onderbouwt jouw educatieve zakelijke beslissingen met gegevens rechtstreeks vanuit uw LBS, in realtime.';
$string['support_text6'] = 'Meer informatie nodig? Klik op een van de blauwe knoppen om met ons in contact te komen.';
$string['support_trial'] = 'Verbind & upgrade';
$string['suspended'] = 'Geschorst';
$string['sync_data_with_attendance'] = 'Synchroniseer gegevens met aanwezigheid';
$string['synctranscriptstask'] = 'Synchroniseren transcript-taak';
$string['t01'] = 'Tijdfilter: laatste 30 dagen';
$string['t02'] = 'Tijdfilter: laatste 3 maanden';
$string['t03'] = 'Tijdfilter: laatste 6 maanden';
$string['t04'] = 'Inschakelen [header] voltooide cursussen';
$string['t05'] = 'Inschakelen [header] cursussen in voortgang';
$string['t06'] = 'Inschakelen [header] cursussen gemid. cijfer';
$string['t07'] = 'Inschakelen [header] berichten';
$string['t08'] = 'Inschakelen [headers] cursussen som cijfer';
$string['t09'] = 'Docent kan eigen leerlingen zien';
$string['t1'] = 'Schakel leerlingen startpagina in.';
$string['t10'] = 'Inschakelen [testen] widget';
$string['t11'] = 'Inschakelen [cursusvoltooiing] widget';
$string['t12'] = 'Inschakelen [activiteitsdeelname] widget';
$string['t13'] = 'Inschakelen [leerling] widget';
$string['t14'] = 'Inschakelen [cursus succes] widget';
$string['t15'] = 'Inschakelen [correlaties] widget';
$string['t16'] = 'Schakel Leraar voor cursus in';
$string['t17'] = 'Schakel cursuscategorie in';
$string['t18'] = 'Schakel cursusvoltooiing in';
$string['t19'] = 'Schakel cursuscijfer in';
$string['t2'] = 'Schakel startpagina in';
$string['t20'] = 'Schakel klasgemiddelde van cursus in';
$string['t21'] = 'Schakel gespendeerde cursustijd in';
$string['t22'] = 'Schakel cursus startdatum in';
$string['t23'] = 'Schakel [Cursus startdatum] kolom in';
$string['t24'] = 'Schakel [aanmelddatum] kolom in';
$string['t25'] = 'Inschakelen [voortgang] kolom';
$string['t26'] = 'Inschakelen [letter] kolom';
$string['t27'] = 'Inschakelen [voltooide activiteiten] kolom';
$string['t28'] = 'Inschakelen [cijfer] kolom';
$string['t29'] = 'Inschakelen [cursus voltooiingsstatus] kolom';
$string['t3'] = 'Inschakelen cursussen';
$string['t30'] = 'Inschakelen [activiteitscijfers] kolom';
$string['t31'] = 'Inschakelen [opdrachten] [cijfer] widget-kolom';
$string['t32'] = 'Inschakelen [opdrachten] [vervaldatum] widget-kolom';
$string['t33'] = 'Inschakelen [testen] [cijfer] widget-kolom';
$string['t34'] = 'Inschakelen [testen] [vervaldatum] widget-kolom';
$string['t35'] = 'Inschakelen [cursusvoortgang] [voortgang] widget-kolom';
$string['t36'] = 'Inschakelen [cursusvoortgang] [cijfer] widget-kolom';
$string['t37'] = 'Schakel [Cursusvoortgang][Aangemeld] widget kolom in';
$string['t38'] = 'Inschakelen [cursusvoortgang] [voltooid] widget-kolom';
$string['t39'] = 'Inschakelen [voortgang] [doelcijfer] widget-kolom';
$string['t4'] = 'Inschakelen cijfers';
$string['t40'] = 'Inschakelen [voortgang] [klasgemid.] optie';
$string['t41'] = 'Inschakelen [activiteitscijferhoofding] voltooid op';
$string['t42'] = 'Activeer [Activiteit cijfer kop] laatste toegang tot cursus';
$string['t43'] = 'Inschakelen [activiteitscijfers] type kolom';
$string['t44'] = 'Inschakelen [Activiteit Cijfers] Cijfer-kolom';
$string['t45'] = 'Inschakelen [Activiteit Cijfers] Beoordeeld-kolom';
$string['t46'] = 'Inschakelen [Activiteit Cijfers] Voltooid-kolom';
$string['t47'] = 'Cursussen [raster] achtergrondkleur';
$string['t48'] = 'Inschakelen rapporten';
$string['t49'] = 'Rapportfilterkolommen';
$string['t5'] = 'Inschakelen [Activiteit voortgang] grafiek';
$string['t50'] = 'Leraar-rollen';
$string['t51'] = 'Leerlingrollen';
$string['t52'] = 'Inschakelen [Cursus Voortgang] [Categorie] widget-rijen';
$string['t53'] = 'Inschakelen [Activiteit voortgang] grafiek gemiddeldelijn';
$string['t54'] = 'Inschakelen [Activiteit Cijfers] Gespendeerde tijd-kolom';
$string['t6'] = 'Inschakelen [Cursus voortgang] grafiek';
$string['t7'] = 'Inschakelen [Mijn cursusgemiddelde]';
$string['t8'] = 'Inschakelen [Algemene cursusgemiddelde]';
$string['t9'] = 'Inschakelen [Opdracht] Widget';
$string['table_set_iag'] = 'Leraar Cursus > Activiteiten';
$string['table_set_iag1'] = 'Leraar Cursus > Activiteiten > Cijfers';
$string['table_set_iag1_c1'] = 'Naam leerling';
$string['table_set_iag1_c2'] = 'E-mailadres';
$string['table_set_iag1_c3'] = 'Status';
$string['table_set_iag1_c4'] = 'Cijfer';
$string['table_set_iag1_c5'] = 'Cijfers';
$string['table_set_iag1_c6'] = 'Bezoeken';
$string['table_set_iag1_c7'] = 'Bestede tijd';
$string['table_set_iag_c1'] = 'Naam leerling';
$string['table_set_iag_c2'] = 'Type';
$string['table_set_iag_c3'] = 'Leerlingen voltooid';
$string['table_set_iag_c4'] = 'Gemiddelde cijfer';
$string['table_set_iag_c5'] = 'Bezoeken';
$string['table_set_iag_c6'] = 'Bestede tijd';
$string['table_set_iag_c7'] = 'Acties';
$string['table_set_icg'] = 'Leraar cursussen';
$string['table_set_icg_c1'] = 'Cursusnaam';
$string['table_set_icg_c11'] = 'Actie - activiteiten';
$string['table_set_icg_c12'] = 'Actie - leerlingen';
$string['table_set_icg_c2'] = 'Cursus korte naam';
$string['table_set_icg_c3'] = 'Categorie';
$string['table_set_icg_c4'] = 'Aangemeld/voltooide leerlingen';
$string['table_set_icg_c5'] = 'Gemiddelde cijfer cursus';
$string['table_set_icg_c6'] = 'Secties';
$string['table_set_icg_c7'] = 'Activiteiten/Bronnen';
$string['table_set_icg_c8'] = 'Bezoeken';
$string['table_set_icg_c9'] = 'Bestede tijd';
$string['table_set_ilg'] = 'leraar Cursussen > Leerlingen';
$string['table_set_ilg1'] = 'Leraar Cursussen > Leerlingen > Cijfers';
$string['table_set_ilg1_c1'] = 'Naam activiteit';
$string['table_set_ilg1_c2'] = 'Type';
$string['table_set_ilg1_c3'] = 'Cijfer';
$string['table_set_ilg1_c4'] = 'Beoordeeld';
$string['table_set_ilg1_c5'] = 'Status';
$string['table_set_ilg1_c6'] = 'Bezoeken';
$string['table_set_ilg1_c7'] = 'Bestede tijd';
$string['table_set_ilg_c1'] = 'Naam leerling';
$string['table_set_ilg_c10'] = 'Acties';
$string['table_set_ilg_c2'] = 'E-mailadressen';
$string['table_set_ilg_c3'] = 'Aangemeld';
$string['table_set_ilg_c4'] = 'Laatste toegang';
$string['table_set_ilg_c5'] = 'Status';
$string['table_set_ilg_c6'] = 'Cijfer';
$string['table_set_ilg_c7'] = 'Voltooide activiteiten/bronnen';
$string['table_set_ilg_c8'] = 'Bezoeken';
$string['table_set_ilg_c9'] = 'Bestede tijd';
$string['te1'] = 'E-mail';
$string['te12'] = 'Voornaam';
$string['te13'] = 'Achternaam';
$string['te1_desc'] = 'Voer een e-mailadres in dat wordt gebruikt met een IntelliBoard.net-abonnement. Als je geen actief abonnement hebt, registreer je dan op <a target="_blank" href="https://intelliboard.net"> IntelliBoard.net </a>. Het leerling- en instructeursdashboard zijn beschikbaar met een abonnement van niveau 4 en hoger.';
$string['teacher'] = 'Leraar';
$string['telephone1'] = 'Telefoon 1';
$string['telephone2'] = 'Telefoon 2';
$string['term_of_use'] = 'Gebruiksvoorwaarden';
$string['terms_msg'] = 'Door dit vakje aan te vinken, bevestigt je dat je onze gebruiksvoorwaarden hebt gelezen en ermee akkoord gaat.';
$string['tex1'] = 'Intelliboard leerling startpagina is niet ingeschakeld';
$string['this_year'] = 'Dit Jaar';
$string['time'] = 'Tijd';
$string['time_1'] = 'Voormiddag';
$string['time_2'] = 'Namiddag';
$string['time_3'] = 'Avond';
$string['time_4'] = 'Vrije Uren';
$string['time_period_due'] = 'Tijdsperiode (Vervaldatum)';
$string['time_spent'] = 'Bestede tijd';
$string['timespent'] = '------ Bestede tijd ----';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Geavanceerde instellingen:TLS v1.2';
$string['topics'] = 'Onderwerpen';
$string['total'] = 'Totaal';
$string['total_activities_resources'] = 'Totaal aantal activiteiten / bronnen';
$string['total_numbers'] = 'Datum: {$a->timepoint}, Sessies: {$a->sessions}, Bezoeken: {$a->visits},  Bestede tijd: {$a->timespend}';
$string['total_numbers2'] = 'Gebruiker: {$a->userid}, Pagina: {$a->page}, Parameter:{$a->param}, Bezoeken: {$a->visits},  Bestede tijd: {$a->timespend}';
$string['total_numbers3'] = '----Datum: {$a->timecreated}, Track ID: {$a->trackid}, Bezoeken: {$a->visits},  Bestede tijd: {$a->timespend}';
$string['total_time_spent'] = 'Totaal gespendeerde tijd';
$string['total_time_spent_enrolled_learners'] = 'Totale tijd die aangemelde leerlingen in de cursus doorbrengen';
$string['total_values_include'] = 'Totaal waarde inclusief unieke sessies, cursussen, bezoeken en bestede tijd.';
$string['total_visits_enrolled_learners'] = 'Totaal aantal bezoeken van aangemelde leerlingen aan de cursus';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'Volgen site-beheerders';
$string['trackadmin_desc'] = 'Inschakelen tijd volgen voor site-beheerders (niet aanbevolen)';
$string['trackdetails'] = 'Volg tijd per gebruiker - per uur';
$string['tracking'] = 'Sessie volgen';
$string['tracking_title'] = 'Tijd bijhouden';
$string['tracklogs'] = 'Tijd bijhouden per gebruiker - dagelijks';
$string['trackmedia'] = 'Bijhouden HTML5 media';
$string['trackmedia_desc'] = 'Bijhouden HTML5 video en audio';
$string['tracktotals'] = 'Tijd bijhouden geaggregeerd - dagelijks';
$string['transcripts'] = 'Transcripties';
$string['transcriptssyncrecordsnum'] = 'Transcripties verwerkingsgrootte';
$string['transcriptssyncrecordsnum_desc'] = 'Het aantal records met gebruikersaanmeldingen dat in een keer verwerkt wordt';
$string['ts1'] = 'Leerling startpagina';
$string['ts2'] = 'Leerling startpagina pagina';
$string['ts3'] = 'Leerling startpagina cursussen';
$string['ts4'] = 'Leerling startpagina cijfers';
$string['ts5'] = 'Leerling startpagina rapportages';
$string['type'] = 'Type';
$string['type_here'] = 'Type hier';
$string['used'] = 'Gebruikt';
$string['user_enrollments_sessions_completion'] = 'Gebruikersaanmelding, sessie, voltooid, activiteitsniveaus';
$string['user_enrolments'] = 'Gebruikersaanmeldingen';
$string['user_grade_avg'] = '{$a->user} cijfer: {$a->grade}, gemiddelde cijfer: {$a->avg_grade_site})';
$string['user_map'] = 'Gebruikerskaart';
$string['user_site_summary_detail'] = 'Site samenvattingsdetail gebruiker';
$string['user_time_avg'] = '{$a->user} tijd: {$a->timespend}, Gemiddelde tijd: {$a->avg_timespend_site}';
$string['user_visit_avg'] = '{$a->user} bezoeken: {$a->visits}, Gemiddeld bezoeken: {$a->avg_visits_site}';
$string['username'] = 'Gebruikersnaam';
$string['users'] = 'Gebruikers';
$string['users_activity'] = 'Gebruikersactiviteit';
$string['users_overview'] = 'Gebruikersoverzicht';
$string['verifyhost'] = 'CURLOPT SSL VERIFYHOST';
$string['verifyhost_desc'] = 'Deze optie bepaalt of libcurl verifieert dat het servercertificaat bij voor de juiste server hoort.';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'Deze optie bepaalt of curl de authenticiteit van het peer-certificaat verifieert.';
$string['view_course_details'] = 'Bekijk cursusdetails';
$string['viewed'] = 'Bekeken';
$string['visits'] = 'Bezocht';
$string['web_services_descr'] = 'Om Intelliboard te kunnen gebruiken dient de Webservice ingeschakeld staan. De Webservice zorgt ervoor dat andere systemen (zoals Intelliboard) toegang heeft tot het LMS systeem en bewerkingen kan doen. In verband met veiligheid, zet Webservices niet aan als je het niet gebruikt. Voor meer informatie, ga naar Sitebeheer > Geavanceerd > Webservices';
$string['weekday_0'] = 'Maandag';
$string['weekday_1'] = 'Dinsdag';
$string['weekday_2'] = 'Woensdag';
$string['weekday_3'] = 'Donderdag';
$string['weekday_4'] = 'Vrijdag';
$string['weekday_5'] = 'Zaterdag';
$string['weekday_6'] = 'Zondag';
$string['weekly'] = 'Laatste 90 dagen';
$string['widget_name27'] = 'Cumulatieve aanmeldingen';
$string['widget_name28'] = 'Engagement';
$string['widget_name29'] = 'Unieke aanmeldingen';
$string['widget_name30'] = 'Aanmeldingen per cursus';
$string['widget_name31'] = 'Registrars & Supervisor nemen het op';
$string['x_completions'] = '{$a} Voltooiingen';
$string['you_have_certificates'] = 'Je hebt {$a} certificaten';
$string['you_need_to_enable_at_least_one_protocol'] = 'Je moet ten minste één protocol inschakelen';
