<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_grid', language 'de', version '3.9'.
 *
 * @package     format_grid
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsection'] = 'Abschnitt hinzufügen';
$string['alttext'] = 'alt-Text für Bild';
$string['alttext_help'] = 'Der Alternativtext wird als alt-Attribut für das Bild gesetzt.';
$string['bottom'] = 'Unten';
$string['cannotconvertuploadedimagetodisplayedimage'] = 'Das hochgeladene Bild kann nicht in ein anzuzeigendes Bild umgewandelt werden - {$a}. Melden Sie bitte die Fehlerdetails und die Infos aus der Datei php.log an die Entwickler/innen.';
$string['cannotfinduploadedimage'] = 'Das hochgeladene Originalbild kann nicht gefunden werden. Bitte geben Sie einen Fehlerbericht an die Entwickler weiter.

Das hochgeladene Originalbild kann nicht gefunden werden. Melden Sie bitte die Fehlerdetails und die Infos aus der Datei php.log an die Entwickler/innen. Aktualisieren Sie die Seite und laden Sie eine neue Kopie des Bildes hoch.';
$string['cannotgetimagelock'] = 'Bild kann nicht gesperrt werden. Melden Sie bitte diesen Fehler dem Entwickler.';
$string['cannotgetsummarylock'] = 'Übersicht kann nicht gesperrt werden. Melden Sie bitte diesen Fehler dem Entwickler.';
$string['centre'] = 'Zentriert';
$string['closeshadebox'] = 'Hervorgehobene Box schließen';
$string['colourrule'] = 'Geben Sie einen gültigen RGB-Farbcode ein. Er enthält sechs hexadezimale Zeichen oder \'-\' für Standard.';
$string['crop'] = 'Zuschneiden';
$string['currentsection'] = 'Dieser Abschnitt';
$string['custommousepointers'] = 'Angepasste Mauszeiger verwenden';
$string['custommousepointers_desc'] = 'Im Design Grid lassen sich angepasste Mauszeiger verwenden.';
$string['default'] = 'Standard - {$a}.';
$string['defaultbordercolour'] = 'Rahmenfarbe für Bildcontainer';
$string['defaultbordercolour_desc'] = 'Wählen Sie die standardmäßige Rahmenfarbe für die Bildcontainer.';
$string['defaultborderradius'] = 'Abgerundete Ecken (Standard)';
$string['defaultborderradius_desc'] = 'Wählen Sie, ob die Rahmen standardmäßig abgerundete Ecken haben sollen.';
$string['defaultborderwidth'] = 'Rahmendicke (Standard)';
$string['defaultborderwidth_desc'] = 'Wählen Sie die Dicke der Rahmenlinie.';
$string['defaultcurrentselectedimagecontainercolour'] = 'Farbe des ausgewählten Bildcontainers (Standard)';
$string['defaultcurrentselectedimagecontainercolour_desc'] = 'Wählen Sie die standardmäßige Farbe für den ausgewählten Bildcontainer.';
$string['defaultcurrentselectedimagecontainertextcolour'] = 'Textfarbe des ausgewählten Bildcontainers (Standard)';
$string['defaultcurrentselectedimagecontainertextcolour_desc'] = 'Wählen Sie die standardmäßige Textfarbe für den ausgewählten Bildcontainer.';
$string['defaultcurrentselectedsectioncolour'] = 'Farbe des ausgewählten Abschnitts (Standard)';
$string['defaultcurrentselectedsectioncolour_desc'] = 'Wählen Sie die standardmäßige Farbe des ausgewählten Abschnitts.';
$string['defaultdisplayedimagefiletype'] = 'Angezeigter Bildtyp';
$string['defaultdisplayedimagefiletype_desc'] = 'Diese Option setzt den angezeigten Bildtyp.';
$string['defaultfitsectioncontainertowindow'] = 'Container an Fenster anpassen (Standard)';
$string['defaultfitsectioncontainertowindow_desc'] = 'Standardeinstellung für \'Container an Fenster anpassen\'';
$string['defaultgreyouthidden'] = 'Nicht Verfügbares ausgrauen';
$string['defaultgreyouthidden_desc'] = 'Nicht verfügbare Abschnitte werden in der Grid-Ansicht grau und unverlinkt angezeigt.';
$string['defaulthidesectiontitle'] = 'Abschnittstitel verbergen';
$string['defaulthidesectiontitle_desc'] = 'Wählen Sie, ob die Abschnittstitel verborgen werden sollen.';
$string['defaultimagecontaineralignment'] = 'Ausrichtung der Bildcontainer (Standard)';
$string['defaultimagecontaineralignment_desc'] = 'Wählen Sie die standardmäßige Ausrichtung der Bildcontainer.';
$string['defaultimagecontainerbackgroundcolour'] = 'Hintergrundfarbe des ausgewählten Bildcontainers  (standard)';
$string['defaultimagecontainerbackgroundcolour_desc'] = 'Wählen Sie die standardmäßige Hintergrundfarbe des ausgewählten Bildcontainers.';
$string['defaultimagecontainerratio'] = 'Seitenverhältnis des Bildcontainers relativ zur Breite (Standard)';
$string['defaultimagecontainerratio_desc'] = 'Wählen Sie das standardmäßige Seitenverhältnis des Bildcontainers relativ zur Breite.';
$string['defaultimagecontainerwidth'] = 'Breite des Bildcontainers (Standard)';
$string['defaultimagecontainerwidth_desc'] = 'Wählen Sie die standardmäßige Breite des Bildcontainers.';
$string['defaultimageresizemethod'] = 'Bildgrößenanpassung (Standard)';
$string['defaultimageresizemethod_desc'] = 'Wählen Sie die standardmäßige Methode zur Anpassung der Bildgrösse an den Container.';
$string['defaultnewactivity'] = 'Bildmitteilung für neue Aktivität (Standard)';
$string['defaultnewactivity_desc'] = 'Bildmitteilung für neue Aktivität anzeigen, wenn eine neue Aktivität oder ein neues Material in einem Abschnitt hinzugefügt wurde (Standard).';
$string['defaultsectiontitlealignment'] = 'Ausrichtung für Abschnittstitel';
$string['defaultsectiontitlealignment_desc'] = 'Wählen Sie die Ausrichtung für den Abschnittstitel aus \'Links\', \'Rechts\' und \'Zentriert\'.';
$string['defaultsectiontitleboxheight'] = 'Rahmenhöhe für Abschnittstitel';
$string['defaultsectiontitleboxheight_desc'] = 'Legen Sie die Rahmenhöhe für den Abschnittstitel fest (in Pixel). Wenn der Wert 0 ist, wird die Rahmenhöhe automatisch berechnet. Die Option wird verwendet, wenn die Rahmenposition \'innen\' ist.';
$string['defaultsectiontitleboxinsideposition'] = 'Rahmenposition für Abschnittstitel, wenn \'innen\'';
$string['defaultsectiontitleboxinsideposition_desc'] = 'Wählen Sie die Rahmenposition für den Abschnittstitel aus \'Oben\', \'Mitte\' oder \'Unten\'. Die Option wird verwendet, wenn die Rahmenposition \'innen\' ist.';
$string['defaultsectiontitleboxopacity'] = 'Deckkraft für Abschnittstitel';
$string['defaultsectiontitleboxopacity_desc'] = 'Legen Sie die Deckkraft für den Abschnittstitel und dessen Rahmen (als Wert zwischen 0 und 1 in Schritten von 0.1) fest. Die Option wird verwendet, wenn die Rahmenposition \'innen\' ist.';
$string['defaultsectiontitleboxposition'] = 'Rahmenposition für Abschnittstitel';
$string['defaultsectiontitleboxposition_desc'] = 'Wählen Sie die Rahmenposition für den Abschnittstitel für die Gridbox aus \'innen\' oder \'außen\'.';
$string['defaultsectiontitlefontsize'] = 'Schriftgröße für Abschnittstitel';
$string['defaultsectiontitlefontsize_desc'] = 'Legen Sie die Schriftgröße zwischen 12 und 24 Pixel fest. Mit dem Wert 0 ist \'Nicht setzen, aber vom Design oder anderem CSS übernehmen\' gemeint.';
$string['defaultsectiontitlegridlengthmaxoption'] = 'Länge für Abschnittstitel';
$string['defaultsectiontitlegridlengthmaxoption_desc'] = 'Legen Sie die standardmäßige maximale Länge für den Abschnittstitel in der Gridbox fest. Der Wert 0 steht für \'Keine Begrenzung\'.';
$string['defaultsectiontitleinsidetitlebackgroundcolour'] = 'Hintergrundfarbe für Abschnittstitel';
$string['defaultsectiontitleinsidetitlebackgroundcolour_desc'] = 'Legen Sie die Hintergrundfarbe für den Abschnittstitel fest. Die Option wird verwendet, wenn die Rahmenposition \'innen\' ist.';
$string['defaultsectiontitleinsidetitletextcolour'] = 'Schriftfarbe für Abschnittstitel';
$string['defaultsectiontitleinsidetitletextcolour_desc'] = 'Legen Sie die Schriftfarbe für den Abschnittstitel fest. Die Option wird verwendet, wenn die Rahmenposition \'innen\' ist.';
$string['defaultsectiontitlesummarybackgroundcolour'] = 'Hintergrundfarbe für die Zusammenfassung bei Hover';
$string['defaultsectiontitlesummarybackgroundcolour_desc'] = 'Legen Sie die Hintergrundfarbe für die Zusammenfassung fest. Die Option wird verwendet, wenn der Mauszeiger über die Gridbox bewegt wird.';
$string['defaultsectiontitlesummarybackgroundopacity'] = 'Hintergrunddeckkraft für die Zusammenfassung bei Hover';
$string['defaultsectiontitlesummarybackgroundopacity_desc'] = 'Legen Sie die Hintergrunddeckkraft für die Zusammenfassung (als Wert zwischen 0 und 1 in Schritten von 0.1) fest. Die Option wird verwendet, wenn der Mauszeiger über die Gridbox bewegt wird.';
$string['defaultsectiontitlesummarymaxlength'] = 'Maimale Länge für Zusammenfassung bei Hover';
$string['defaultsectiontitlesummarymaxlength_desc'] = 'Legen Sie die maximale Textlänge für die Zusammenfassung fest. Der Wert 0 steht für \'Keine Begrenzung\'. Die Option wird verwendet, wenn der Mauszeiger über die Gridbox bewegt wird.';
$string['defaultsectiontitlesummarytextcolour'] = 'Textfarbe für die Zusammenfassung bei Hover';
$string['defaultsectiontitlesummarytextcolour_desc'] = 'Legen Sie die Textfarbe für die Zusammenfassung fest.  Die Option wird verwendet, wenn der Mauszeiger über die Gridbox bewegt wird.';
$string['defaultsetsection0ownpagenogridonesection'] = 'Abschnitt 0 auf einer eigenen Seite außerhalb des Rasters und auf einer einzelnen Abschnittsseite';
$string['defaultsetsection0ownpagenogridonesection_desc'] = 'Der Abschnitt 0 wird auf einer eigenen Seite angezeigt, wenn er sich außerhalb des Rasters befindet und für das Kurslayout "Ein Abschnitt pro Seite" eingestellt ist.';
$string['defaultsetshowsectiontitlesummaryposition'] = 'Position für Zusammenfassung bei Hover';
$string['defaultsetshowsectiontitlesummaryposition_desc'] = 'Wählen Sie die Position aus \'oben\', \'unten\', \'links\' oder \'rechts\', an der die Zusammenfassung angezeigt wird. Die Option wird verwendet, wenn der Mauszeiger über die Gridbox bewegt wird.';
$string['defaultshowsectiontitlesummary'] = 'Zusammenfassung bei Hover anzeigen';
$string['defaultshowsectiontitlesummary_desc'] = 'Die Zusammenfassung soll angezeigt werden, wenn der Mauszeiger über die Gridbox bewegt wird.';
$string['defaultsinglepagesummaryimage'] = 'Rasterbild in der Abschnittszusammenfassung auf einzelner Seite anzeigen';
$string['defaultsinglepagesummaryimage_desc'] = 'Wenn das Kurslayout auf "Ein Abschnitt pro Seite anzeigen" eingestellt ist, wird das Rasterbild für diesen Abschnitt in der Abschnittszusammenfassung angezeigt (falls eine Zusammenfassung existiert).';
$string['deleteimage'] = 'Bild löschen';
$string['deleteimage_help'] = 'Das Bild für den bearbeiteten Abschnitt löschen. Wenn Sie ein Bild hochgeladen haben, wird es das gelöschte Bild nicht ersetzen.';
$string['deletesection'] = 'Abschnitt löschen';
$string['display_summary'] = 'Aus Grid verschieben';
$string['display_summary_alt'] = 'Diesen Abschnitt aus dem Grid verschieben';
$string['editimage'] = 'Bild ändern';
$string['editimage_alt'] = 'Bild einfügen oder ersetzen';
$string['editsection'] = 'Abschnitt bearbeiten';
$string['editsectionname'] = 'Abschnittsname bearbeiten';
$string['formatnotsupported'] = 'Format wird auf diesem Server nicht unterstützt. Korrigieren Sie bitte die Systemkonfiguration, so dass die PHP-Extension GD installiert ist - {$a}.';
$string['functionfailed'] = 'Die Funktion konnte nicht auf Bild angewendet werden - {$a}.';
$string['gfreset'] = 'Optionen zum Zurücksetzen des Grids';
$string['gfreset_help'] = 'Auf Standardwerte des Grids zurücksetzen';
$string['greyouthidden'] = 'Nicht Verfügbares ausgrauen';
$string['greyouthidden_help'] = 'In der Griddarstellung sollen nicht verfügbare Abschnittsbilder ausgegraut und unverlinkt dargestellt werden.';
$string['grid:changeimagecontaineralignment'] = 'Ausrichtung für Bildcontainer ändern oder zurücksetzen';
$string['grid:changeimagecontainernavigation'] = 'Bildcontainernavigation ändern oder zurücksetzen';
$string['grid:changeimagecontainersize'] = 'Breite für Bildcontainer ändern oder zurücksetzen';
$string['grid:changeimagecontainerstyle'] = 'Stil für Bildcontainer ändern oder zurücksetzen';
$string['grid:changeimageresizemethod'] = 'Größenanpassung für Bilder ändern oder zurücksetzen';
$string['grid:changesectiontitleoptions'] = 'Optionen für Abschnittstitel ändern oder zurücksetzen';
$string['gridimagecontainer'] = 'Gridbilder';
$string['hidden_topic'] = 'Der Abschnitt wurde verborgen.';
$string['hide_summary'] = 'Ins Grid verschieben';
$string['hide_summary_alt'] = 'Dieser Abschnitt soll ins Grid verschoben werden.';
$string['hidefromothers'] = 'Abschnitt verbergen';
$string['hidesectiontitle'] = 'Abschnittstitel verbergen';
$string['hidesectiontitle_help'] = 'Dieser Abschnittstitel soll verborgen sein.';
$string['imagecannotbeused'] = 'Das Bildformat kann nicht verwendet werden. Geeignete Formate sind: png, jpg oder gif. Außerdem muss die PHP-Extension gd auf dem Server installiert sein.';
$string['imagefile'] = 'Bild hochladen';
$string['imagefile_help'] = 'Laden Sie ein Bild im Format png, jpg oder gif hoch. webp erfordert Moodle Core Support.';
$string['information'] = 'Information';
$string['informationsettings'] = 'Informationseinstellungen';
$string['informationsettingsdesc'] = 'Informationen zum Grid-Format';
$string['invalidiconrecordid'] = 'Bildcontainer konnte nicht erstellt werden. Datenbank von Grid Format ist nicht bereit. Ein Administrator muss den Benachrichtigungsbereich besuchen.';
$string['invalidsummaryrecordid'] = 'Übersichtsstatus konnte nicht gesetzt werden. Datenbank von Grid Format ist nicht bereit. Ein Administrator muss den Benachrichtigungsbereich besuchen.';
$string['left'] = 'Links';
$string['markedthissection'] = 'Der Abschnitt ist als aktueller Abschnitt hervorgehoben.';
$string['markthissection'] = 'Abschnitt als aktuell hervorheben';
$string['mimetypenotsupported'] = 'Dieser Mime-Typ wird für das Grid-Format nicht unterstützt - {$a}.';
$string['newsectionname'] = 'Neuer Name für Abschnitt {$a}';
$string['nextsection'] = 'Nächster Abschnitt';
$string['noimageinformation'] = 'Fehlende Bildinformation - {$a}';
$string['numbersections'] = 'Anzahl der Abschnitte';
$string['off'] = 'Aus';
$string['on'] = 'An';
$string['opacityrule'] = 'Geben Sie eine gültige Deckkraft an, und zwar zwischen 0 und 1 in Schritten von 0.1.';
$string['original'] = 'Original';
$string['originalheightempty'] = 'Originalhöhe ist leer - {$a}';
$string['originalwidthempty'] = 'Originalbreite ist leer - {$a}';
$string['page-course-view-grid'] = 'Jede Kursstartseite im Grid-Format';
$string['page-course-view-grid-x'] = 'Jede Kursseite im Grid-Format.';
$string['pluginname'] = 'Grid Format';
$string['previoussection'] = 'Vorheriger Abschnitt';
$string['privacy:nop'] = 'Das Grid-Format speichert zahlreiche Einstellungen in der Konfiguration. Keine der Einstellungen ist personenbezogen. Trainer/innen müssen sicherstellen, dass in keinem der Freitextfelder personenbezogene Daten eingegeben werden. Das Setzen einer Einstellung führt dazu, dass diese Aktion innerhalb des zentralen Logdaten protokolliert wird, und zwar mit der ID der Person, die die Einstellung vorgenommen hat. Dies liegt außerhalb der Kontrolle des Grid-Formats. Beim Hochladen von Bildern sollten Sie die möglicherweise eingebetteten Standortdaten (EXIF GPS) oder personenbezogene Daten vermeiden. Andernfalls wäre es möglich, orts- und personenbezogene Daten aus den Bildern zu extrahieren. Wenn Sie datenschutzrechtliche Bedenken haben, sollten Sie das Grid-Format entfernen.';
$string['reporterror'] = 'Melden Sie bitte alle Fehler und Information aus der Datei php.log an die Entwickler/innen.';
$string['resetallfitpopup'] = 'Abschnitt-Popup an Fenster anpassen';
$string['resetallfitpopup_help'] = 'Diese Option setzt \'Abschnitt-Popup an Fenster anpassen\' im Kurs auf den Standardwert zurück.';
$string['resetallgreyouthidden'] = 'Nicht Verfügbares ausgrauen';
$string['resetallgreyouthidden_help'] = 'Diese Option setzt \'Nicht verfügbare Abschnitte werden in der Grid-Ansicht grau und unverlinkt angezeigt.\' im Kurs auf den Standardwert zurück.';
$string['resetallgrp'] = 'Alle zurücksetzen:';
$string['resetallimagecontaineralignment'] = 'Ausrichtung für Bildcontainer';
$string['resetallimagecontaineralignment_help'] = 'Diese Option setzt die Ausrichtung der Bildcontainer im Kurs auf den Standardwert zurück.';
$string['resetallimagecontainernavigation'] = 'Bildcontainernavigation';
$string['resetallimagecontainernavigation_help'] = 'Diese Option setzt die Bildcontainernavigation im Kurs auf den Standardwert zurück.';
$string['resetallimagecontainersize'] = 'Größe für Bildcontainer';
$string['resetallimagecontainersize_help'] = 'Diese Option setzt die Größe der Bildcontainer im Kurs auf den Standardwert zurück.';
$string['resetallimagecontainerstyle'] = 'Stil für Bildcontainer';
$string['resetallimagecontainerstyle_help'] = 'Diese Option setzt die Stile der Bildcontainer im Kurs auf den Standardwert zurück.';
$string['resetallimageresizemethod'] = 'Größenanpassung für Bilder';
$string['resetallimageresizemethod_help'] = 'Diese Einstellung setzt die Größenanpassung für Bilder im Kurs auf den Standardwert zurück.';
$string['resetallnewactivity'] = 'Neue Aktivitäten';
$string['resetallnewactivity_help'] = 'Diese Einstellung setzt die Bildmitteilungen im Kurs auf den Standardwert zurück.';
$string['resetallsectiontitleoptions'] = 'Optionen für Abschnittstitel';
$string['resetallsectiontitleoptions_help'] = 'Diese Einstellung setzt die Optionen für Abschnittstitel im Kurs auf die Standardwerte zurück.';
$string['resetallsinglepagesummaryimage'] = 'Zusammenfassungsbilder für Einzelseiten';
$string['resetallsinglepagesummaryimage_help'] = 'Diese Einstellung setzt die Zusammenfassungsbilder für Einzelseiten auf die Standardwerte zurück.';
$string['resetfitpopup'] = 'Abschnitt-Popup an Fenster anpassen';
$string['resetfitpopup_help'] = 'Diese Einstellung setzt \'Abschnitt-Popup an Fenster anpassen\' im Kurs auf den Standardwert zurück.';
$string['resetgreyouthidden'] = 'Nicht Verfügbares ausgrauen';
$string['resetgreyouthidden_help'] = 'Diese Einstellung setzt \'Grid zeigt die Bilder unsichtbarer Abschnitte in grau und unverlinkt\' im Kurs auf den Standardwert zurück.';
$string['resetgrp'] = 'Zurücksetzen:';
$string['resetimagecontaineralignment'] = 'Ausrichtung für Bildcontainer';
$string['resetimagecontaineralignment_help'] = 'Diese Einstellung setzt die Ausrichtung der Bildcontainer im Kurs auf den Standardwert zurück.';
$string['resetimagecontainernavigation'] = 'Bildcontainernavigation';
$string['resetimagecontainernavigation_help'] = 'Diese Option setzt die Bildcontainernavigation im Kurs auf den Standardwert zurück.';
$string['resetimagecontainersize'] = 'Größe für Bildcontainer';
$string['resetimagecontainersize_help'] = 'Diese Option setzt die Größe der Bildcontainer im Kurs auf den Standardwert zurück.';
$string['resetimagecontainerstyle'] = 'Stil für Bildcontainer';
$string['resetimagecontainerstyle_help'] = 'Diese Option setzt die Stile der Bildcontainer im Kurs auf den Standardwert zurück.';
$string['resetimageresizemethod'] = 'Größenanpassung für Bilder';
$string['resetimageresizemethod_help'] = 'Diese Einstellung setzt die Größenanpassung für Bilder im Kurs auf den Standardwert zurück.';
$string['resetnewactivity'] = 'Neue Aktivität';
$string['resetnewactivity_help'] = 'Diese Einstellung setzt die Bildmitteilung \'Neue Aktivität\' im Kurs auf den Standardwert zurück.';
$string['resetsectiontitleoptions'] = 'Optionen für Abschittstitel';
$string['resetsectiontitleoptions_help'] = 'Diese Einstellung setzt die Optionen für den Abschnittstitel im Kurs auf den Standardwert zurück.';
$string['resetsinglepagesummaryimage'] = 'Zusammenfassungsbild für Einzelseite';
$string['resetsinglepagesummaryimage_help'] = 'Diese Einstellung setzt das Zusammenfassungsbild für Einzelseite auf den Standardwert zurück.';
$string['right'] = 'Rechts';
$string['scale'] = 'Skalieren';
$string['section0name'] = 'Allgemein';
$string['sectionname'] = 'Abschnitt';
$string['sectiontitlealignment'] = 'Ausrichtung für Abschnittstitel';
$string['sectiontitlealignment_help'] = 'Wählen Sie die Ausrichtung für den Abschnittstitel aus \'links\', \'zentriert\' oder \'rechts\'.';
$string['sectiontitleboxheight'] = 'Rahmenhöhe für Abschnittstitel';
$string['sectiontitleboxheight_help'] = 'Rahmenhöhe für Abschnittstitel in Pixel oder \'0\' für berechnet oder \'-\' für Standard. Wenn als Rahmenposition \'innen\' gewählt wurde.';
$string['sectiontitleboxinsideposition'] = 'Position des Abschnittstitelrahmens bei Option \'innen\'';
$string['sectiontitleboxinsideposition_help'] = 'Platziert den Abschnittstiel, wenn er innerhalb des Grids steht (Position \'Innen\'), auf: \'Oben\', \'Mitte\' oder \'Unten\'.';
$string['sectiontitleboxinsidepositionbottom'] = 'Unten';
$string['sectiontitleboxinsidepositionmiddle'] = 'Mitte';
$string['sectiontitleboxinsidepositiontop'] = 'Oben';
$string['sectiontitleboxopacity'] = 'Deckkraft für Abschnittstitel';
$string['sectiontitleboxopacity_help'] = 'Deckkraft des Abschnittstitels zwischen 0 und 1 in 0.1 Schritten. Wenn als Position des Titels \'Innen\' gewählt wurde.';
$string['sectiontitleboxposition'] = 'Rahmenposition für Abschnittstitel';
$string['sectiontitleboxposition_help'] = 'Setzt die Position des Abschnittstitels innerhalb des Grids auf: \'innen\' oder \'außen\'';
$string['sectiontitleboxpositioninside'] = 'Innen';
$string['sectiontitleboxpositionoutside'] = 'Außen';
$string['sectiontitlefontsize'] = 'Schriftgröße für Abschnittstitel';
$string['sectiontitlefontsize_help'] = 'Schriftgröße für den Abschnittstitel zwischen 12 und 24 Pixel. Bei 0 wird der Wert aus dem Theme oder einer sonstigen CSS übernommen.';
$string['sectiontitlefontsizerule'] = 'Bitte geben Sie einen gültigen Wert für die Schriftgröße des Abschnittstitels ein. Wert muss zwischen 12 und 24 (Pixel) liegen oder 0 für \'kein Wert eingestellt\'.';
$string['sectiontitlegridlengthmaxoption'] = 'Länge des Abschnittstitels';
$string['sectiontitlegridlengthmaxoption_help'] = 'Legt die maximale Textlänge des Abschnittstitels im Grid fest. Geben Sie \'0\' für keine Beschränkung oder \'-\' für Standard ein.';
$string['sectiontitlegridlengthmaxoptionrule'] = 'Das Feld "Länge des Abschnittstitels" darf nicht leer sein. Geben Sie \'0\' für keine Beschränkung oder \'-\' für Standard ein.';
$string['sectiontitleinsidetitlebackgroundcolour'] = 'Hintergrundfarbe Abschnittstitel';
$string['sectiontitleinsidetitlebackgroundcolour_help'] = 'Hintergrundfarbe des Abschnittstitels, wenn die Option \'innen\' gewählt wurde';
$string['sectiontitleinsidetitletextcolour'] = 'Textfarbe Abschnittstitel';
$string['sectiontitleinsidetitletextcolour_help'] = 'Diese Einstellung setzt die Textfarbe des Abschnittstitels, wenn die Option \'innen\' gewählt wurde';
$string['sectiontitlesummarybackgroundcolour'] = 'Hintergrundfarbe der Zusammenfassung bei Hover';
$string['sectiontitlesummarybackgroundcolour_help'] = 'Diese Einstellung setzt die Hintergrundfarbe der Zusammenfassung, wenn die Maus über die Gridbox bewegt wird.';
$string['sectiontitlesummarybackgroundopacity'] = 'Deckkraft der Zusammenfassung bei Hover';
$string['sectiontitlesummarybackgroundopacity_help'] = 'Diese Einstellung legt die Deckkraft der Zusammenfassung fest, wenn die Maus über die Gridbox bewegt wird. Wert kann zwischen 0 und 1 liegen, in 0.1 Schritten.';
$string['sectiontitlesummarymaxlength'] = 'Länge der Zusammenfassung bei Hover';
$string['sectiontitlesummarymaxlength_help'] = 'Diese Einstellung legt die maximale Textlänge der Zusammenfassung fest, wenn die Maus über die Gridbox bewegt wird. Geben Sie \'0\' für keine Beschränkung oder \'.\' für Standard ein.';
$string['sectiontitlesummarytextcolour'] = 'Textfarbe Zusammenfassung bei Hover';
$string['sectiontitlesummarytextcolour_help'] = 'Diese Einstellung legt die Textfarbe der Zusammenfassung fest, wenn die Maus über die Gridbox bewegt wird.';
$string['setbordercolour'] = 'Rahmenfarbe';
$string['setbordercolour_help'] = 'Diese Einstellung legt die Rahmenfarbe als hexadezimalen RGB-Wert fest.';
$string['setborderradius'] = 'Abgerundete Ecken';
$string['setborderradius_help'] = 'Diese Einstellung schaltet abgerundete Ecken für Rahmen an oder aus.';
$string['setborderwidth'] = 'Rahmendicke';
$string['setborderwidth_help'] = 'Diese Einstellung legt die Rahmendicke zwischen 1 und 10 fest.';
$string['setcurrentselectedimagecontainercolour'] = 'Farbe für gewählten Bildcontainer';
$string['setcurrentselectedimagecontainercolour_help'] = 'Diese Einstellung legt die Farbe für den ausgewählten Bildcontainer als hexadezimalen RGB-Wert fest.';
$string['setcurrentselectedimagecontainertextcolour'] = 'Textfarbe für gewählten Bildcontainer';
$string['setcurrentselectedimagecontainertextcolour_help'] = 'Diese Einstellung legt die Textfarbe für den ausgewählten Bildcontainer als hexadezimalen RGB-Wert fest.';
$string['setcurrentselectedsectioncolour'] = 'Farbe für gewählten Abschnitt';
$string['setcurrentselectedsectioncolour_help'] = 'Diese Einstellung legt die Farbe für den ausgewählten Abschnitt als hexadezimalen RGB-Wert fest.';
$string['setfitsectioncontainertowindow'] = 'Abschnitt-Popups an Fenster anpassen';
$string['setfitsectioncontainertowindow_help'] = 'Diese Einstellung legt fest, dass ein Popup-Feld mit dem Inhalt des Abschnitts in das Fenster passt und bei Bedarf gescrollt werden kann. Wenn die Einstellung deaktiviert ist, wird stattdessen die ganze Seite gescrollt.';
$string['setimagecontaineralignment'] = 'Ausrichtung für Bildcontainer';
$string['setimagecontaineralignment_help'] = 'Diese Einstellung legt die Ausrichtung für den Bildcontainer auf \'links\', \'zentriert\' oder \'rechts\' fest.';
$string['setimagecontainerbackgroundcolour'] = 'Hintergrundfarbe für Bildcontainer';
$string['setimagecontainerbackgroundcolour_help'] = 'Diese Einstellung legt die Hintergrundfarbe des ausgewählten Bildcontainers als hexadezimalen RGB-Wert fest.';
$string['setimagecontainerratio'] = 'Seitenverhältnis des Bildcontainers relativ zur Breite';
$string['setimagecontainerratio_help'] = 'Diese Einstellung setzt das Seitenverhältnis des Bildcontainers auf: 3-2, 3-1, 3-3, 2-3, 1-3, 4-3 oder 3-4';
$string['setimagecontainerwidth'] = 'Breite des Bildcontainers';
$string['setimagecontainerwidth_help'] = 'Diese Einstellung setzt die Breite des Bildcontainers auf: 128, 192, 210, 256, 320, 384, 448, 512, 576, 640, 704 oder 768 Pixel.';
$string['setimageresizemethod'] = 'Größenanpassung für Bilder';
$string['setimageresizemethod_help'] = 'Diese Einstellung legt als Methode zur Anpassung der Bildgröße \'Skalieren\' oder \'Beschneiden\' fest, um das Bild in den Container einzupassen.';
$string['setnewactivity'] = 'Bildmitteilung für neue Aktivität';
$string['setnewactivity_help'] = 'Bildmitteilung für neue Aktivität anzeigen, wenn eine neue Aktivität oder ein neues Material in einem Abschnitt hinzugefügt wurde.';
$string['setsection0ownpagenogridonesection'] = 'Abschnitt 0 auf einer eigenen Seite, wenn er nicht im Raster ist und sich auf einer einzelnen Abschnittsseite befindet';
$string['setsection0ownpagenogridonesection_help'] = 'Der Abschnitt 0 wird auf einer eigenen Seite angezeigt, wenn er sich außerhalb des Rasters befindet und für das Kurslayout "Ein Abschnitt pro Seite" eingestellt ist.';
$string['setshowsectiontitlesummaryposition'] = 'Position der Zusammenfassung bei Hover-Anzeige';
$string['setshowsectiontitlesummaryposition_help'] = 'Diese Einstellung legt die Position der Zusammenfassung fest, wenn Sie mit der Maus über die Gridbox fahren: \'Oben\', \'Unten\', \'Links\' oder \'Rechts\'';
$string['settings'] = 'Einstellungen';
$string['settingssettings'] = 'Einstellungen';
$string['settingssettingsdesc'] = 'Einstellungen für das Gridformat';
$string['shadeboxcontent'] = 'Inhalt der hervorgehobenen Box';
$string['showfromothers'] = 'Abschnitt anzeigen';
$string['showsectiontitlesummary'] = 'Zusammenfassung bei Hover anzeigen';
$string['showsectiontitlesummary_help'] = 'Zusammenfassung anzeigen, wenn Sie mit der Maus über die Gridbox fahren.';
$string['singlepagesummaryimage'] = 'Rasterbild in der Abschnittszusammenfassung auf einzelner Seite  anzeigen';
$string['singlepagesummaryimage_help'] = 'Wenn das Kurslayout auf "Ein Abschnitt pro Seite anzeigen" eingestellt ist, wird das Rasterbild für diesen Abschnitt in der Abschnittszusammenfassung angezeigt (falls eine Zusammenfassung existiert).';
$string['top'] = 'Oben';
$string['topic'] = 'Abschnitt';
$string['topic0'] = 'Allgemein';
$string['versionalpha'] = 'Alphaversion - hat ziemlich sicher Fehler. Dies ist eine Entwicklungsversion! Denken Sie nicht einmal daran, diese Version auf einem Produktionsserver zu installieren!';
$string['versionbeta'] = 'Betaversion - hat wahrscheinlich Fehler. Diese Version steht nur zum Testen durch Administrator/innen auf einem Testserver bereit.';
$string['versioninfo'] = 'Release {$a->release}, Version {$a->version} für Moodle {$a->moodle}';
$string['versionrc'] = 'Release Candidate Version - kann Fehler haben. Testen Sie das Plugin intensiv auf einem Testserver, bevor Sie es auf einem Produktivserver einsetzen.';
$string['versionstable'] = 'Stabile Version - kann Fehler haben. Testen Sie das Plugin auf einem Testserver, bevor Sie es auf einem Produktivserver einsetzen.';
$string['webp'] = 'WebP';
